/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.utils;

import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureFileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecureFileUtils.class);

    private SecureFileUtils() {
    }

    public static void validatePath(File file) {
        if (file == null) {
            LOGGER.error("File cannot be null");
            throw new IllegalArgumentException("File cannot be null");
        }
        try {
            String absolutePath = file.getAbsolutePath();
            String canonicalPath = file.getCanonicalPath();
            if (absolutePath.contains("..") || absolutePath.contains("\u0000")) {
                LOGGER.error("Path contains suspicious characters: {}", (Object)absolutePath);
                throw new SecurityException("Path contains suspicious characters: " + absolutePath);
            }
            if (canonicalPath.contains("..") || canonicalPath.contains("\u0000")) {
                LOGGER.error("Path contains suspicious characters: {}", (Object)canonicalPath);
                throw new SecurityException("Path contains suspicious characters: " + canonicalPath);
            }
        }
        catch (IOException e) {
            LOGGER.error("Unable to resolve canonical path for: {}, error: {}", (Object)file.getAbsolutePath(), (Object)e.getMessage());
            throw new SecurityException("Unable to resolve canonical path for: " + file.getAbsolutePath(), e);
        }
    }

    public static void validatePath(String path) {
        if (path == null || path.trim().isEmpty()) {
            LOGGER.error("Path cannot be null or empty");
            throw new IllegalArgumentException("Path cannot be null or empty");
        }
        if (path.contains("..") || path.contains("\u0000")) {
            LOGGER.error("Path contains suspicious characters: {}", (Object)path);
            throw new SecurityException("Path contains suspicious characters: " + path);
        }
        SecureFileUtils.validatePath(new File(path));
    }
}

