/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.Info;
import io.swagger.models.Model;
import io.swagger.models.Swagger;
import io.swagger.models.properties.AbstractNumericProperty;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BaseIntegerProperty;
import io.swagger.models.properties.BinaryProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.ByteArrayProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.EmailProperty;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.PasswordProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.models.properties.UUIDProperty;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ElixirClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    protected String apiVersion = "1.0.0";
    protected String moduleName;
    protected static final String defaultModuleName = "Swagger.Client";
    protected static final String defaultPackageName = "swagger_client";
    String supportedElixirVersion = "1.4";
    List<String> extraApplications = Arrays.asList(":logger");
    List<String> deps = Arrays.asList("{:tesla, \"~> 0.8\"}", "{:poison, \">= 1.0.0\"}");

    public ElixirClientCodegen() {
        this.outputFolder = "generated-code/elixir";
        this.modelTemplateFiles.put("model.mustache", ".ex");
        this.apiTemplateFiles.put("api.mustache", ".ex");
        this.templateDir = "elixir";
        this.reservedWords = new HashSet<String>(Arrays.asList("nil", "true", "false", "__MODULE__", "__FILE__", "__DIR__", "__ENV__", "__CALLER__"));
        this.additionalProperties.put("apiVersion", this.apiVersion);
        this.supportingFiles.add(new SupportingFile("README.md.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("config.exs.mustache", "config", "config.exs"));
        this.supportingFiles.add(new SupportingFile("mix.exs.mustache", "", "mix.exs"));
        this.supportingFiles.add(new SupportingFile("test_helper.exs.mustache", "test", "test_helper.exs"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("Integer", "Float", "Boolean", "String", "List", "Atom", "Map", "Tuple", "PID", "DateTime"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("integer", "Integer");
        this.typeMapping.put("long", "Integer");
        this.typeMapping.put("number", "Float");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("double", "Float");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("byte", "Integer");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("Date", "DateTime");
        this.typeMapping.put("DateTime", "DateTime");
        this.typeMapping.put("file", "String");
        this.typeMapping.put("map", "Map");
        this.typeMapping.put("array", "List");
        this.typeMapping.put("list", "List");
        this.typeMapping.put("binary", "String");
        this.typeMapping.put("ByteArray", "String");
        this.typeMapping.put("UUID", "String");
        this.cliOptions.add(new CliOption("invokerPackage", "The main namespace to use for all classes. e.g. Yay.Pets"));
        this.cliOptions.add(new CliOption("licenseHeader", "The license header to prepend to the top of all source files."));
        this.cliOptions.add(new CliOption("packageName", "Elixir package name (convention: lowercase)."));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "elixir";
    }

    @Override
    public String getHelp() {
        return "Generates an elixir client library (alpha).";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.additionalProperties.put("supportedElixirVersion", this.supportedElixirVersion);
        this.additionalProperties.put("extraApplications", this.join(",", this.extraApplications));
        this.additionalProperties.put("deps", this.deps);
        this.additionalProperties.put("underscored", new Mustache.Lambda(){

            public void execute(Template.Fragment fragment, Writer writer) throws IOException {
                writer.write(ElixirClientCodegen.this.underscored(fragment.execute()));
            }
        });
        this.additionalProperties.put("modulized", new Mustache.Lambda(){

            public void execute(Template.Fragment fragment, Writer writer) throws IOException {
                writer.write(ElixirClientCodegen.this.modulized(fragment.execute()));
            }
        });
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.setModuleName((String)this.additionalProperties.get("invokerPackage"));
        }
    }

    @Override
    public void preprocessSwagger(Swagger swagger) {
        Info info = swagger.getInfo();
        if (this.moduleName == null) {
            if (info.getTitle() != null) {
                this.setModuleName(this.modulized(this.escapeText(info.getTitle())));
            } else {
                this.setModuleName(defaultModuleName);
            }
        }
        this.additionalProperties.put("moduleName", this.moduleName);
        if (!this.additionalProperties.containsKey("packageName")) {
            this.additionalProperties.put("packageName", this.underscored(this.moduleName));
        }
        this.supportingFiles.add(new SupportingFile("connection.ex.mustache", this.sourceFolder(), "connection.ex"));
        this.supportingFiles.add(new SupportingFile("request_builder.ex.mustache", this.sourceFolder(), "request_builder.ex"));
        this.supportingFiles.add(new SupportingFile("deserializer.ex.mustache", this.sourceFolder(), "deserializer.ex"));
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations = (Map)super.postProcessOperations(objs).get("operations");
        List os = (List)operations.get("operation");
        ArrayList<ExtendedCodegenOperation> newOs = new ArrayList<ExtendedCodegenOperation>();
        Pattern pattern = Pattern.compile("\\{([^\\}]+)\\}([^\\{]*)");
        for (CodegenOperation o : os) {
            Map firstType;
            ArrayList<String> pathTemplateNames = new ArrayList<String>();
            Matcher matcher = pattern.matcher(o.path);
            StringBuffer buffer = new StringBuffer();
            while (matcher.find()) {
                String pathTemplateName = matcher.group(1);
                matcher.appendReplacement(buffer, "#{" + ElixirClientCodegen.underscore(pathTemplateName) + "}" + "$2");
                pathTemplateNames.add(pathTemplateName);
            }
            ExtendedCodegenOperation eco = new ExtendedCodegenOperation(o);
            if (buffer.toString().isEmpty()) {
                eco.setReplacedPathName(o.path);
            } else {
                eco.setReplacedPathName(buffer.toString());
            }
            eco.setPathTemplateNames(pathTemplateNames);
            if (eco.hasConsumes == Boolean.TRUE && (firstType = (Map)eco.consumes.get(0)) != null && "multipart/form-data".equals(firstType.get("mediaType"))) {
                eco.isMultipart = Boolean.TRUE;
            }
            newOs.add(eco);
        }
        operations.put("operation", newOs);
        return objs;
    }

    @Override
    public CodegenModel fromModel(String name, Model model, Map<String, Model> allDefinitions) {
        CodegenModel cm = super.fromModel(name, model, allDefinitions);
        return new ExtendedCodegenModel(cm);
    }

    String join(CharSequence charSequence, Iterable<String> iterable) {
        StringBuilder buf = new StringBuilder();
        for (String str : iterable) {
            if (0 < buf.length()) {
                buf.append(charSequence);
            }
            buf.append(str);
        }
        return buf.toString();
    }

    String underscored(String words) {
        ArrayList<String> underscoredWords = new ArrayList<String>();
        for (String word : words.split(" ")) {
            underscoredWords.add(ElixirClientCodegen.underscore(word));
        }
        return this.join("_", underscoredWords);
    }

    String modulized(String words) {
        ArrayList<String> modulizedWords = new ArrayList<String>();
        for (String word : words.split(" ")) {
            modulizedWords.add(ElixirClientCodegen.camelize(word));
        }
        return this.join("", modulizedWords);
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    private String sourceFolder() {
        ArrayList<String> underscoredWords = new ArrayList<String>();
        for (String word : this.moduleName.split("\\.")) {
            underscoredWords.add(ElixirClientCodegen.underscore(word));
        }
        return "lib/" + this.join("/", underscoredWords);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder() + "/" + "model";
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder() + "/" + "api";
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "Default";
        }
        return ElixirClientCodegen.camelize(name);
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return ElixirClientCodegen.underscore(name);
    }

    @Override
    public String toModelName(String name) {
        return ElixirClientCodegen.camelize(this.toModelFilename(name));
    }

    @Override
    public String toModelFilename(String name) {
        if (!StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(name = this.sanitizeName(name))) {
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + "model_" + name);
            name = "model_" + name;
        }
        if (name.matches("^\\d.*")) {
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + "model_" + name);
            name = "model_" + name;
        }
        return ElixirClientCodegen.underscore(name);
    }

    @Override
    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        return ElixirClientCodegen.camelize(this.sanitizeName(operationId));
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return "%{optional(String.t) => " + this.getTypeDeclaration(inner) + "}";
        }
        if (p instanceof PasswordProperty) {
            return "String.t";
        }
        if (p instanceof EmailProperty) {
            return "String.t";
        }
        if (p instanceof ByteArrayProperty) {
            return "binary()";
        }
        if (p instanceof StringProperty) {
            return "String.t";
        }
        if (p instanceof DateProperty) {
            return "Date.t";
        }
        if (p instanceof UUIDProperty) {
            return "String.t";
        }
        if (p instanceof DateTimeProperty) {
            return "DateTime.t";
        }
        if (p instanceof ObjectProperty) {
            return super.getTypeDeclaration(p);
        }
        if (p instanceof IntegerProperty) {
            return "integer()";
        }
        if (p instanceof LongProperty) {
            return "integer()";
        }
        if (p instanceof BaseIntegerProperty) {
            return "integer()";
        }
        if (p instanceof DoubleProperty) {
            return "float()";
        }
        if (p instanceof FloatProperty) {
            return "float()";
        }
        if (p instanceof DecimalProperty) {
            return "float()";
        }
        if (p instanceof AbstractNumericProperty) {
            return "number()";
        }
        if (p instanceof BinaryProperty) {
            return "binary()";
        }
        if (p instanceof BooleanProperty) {
            return "boolean()";
        }
        if (p instanceof RefProperty) {
            return super.getTypeDeclaration(p);
        }
        if (p instanceof FileProperty) {
            return "String.t";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    class ExtendedCodegenModel
    extends CodegenModel {
        public boolean hasImports;

        public ExtendedCodegenModel(CodegenModel cm) {
            this.parent = cm.parent;
            this.parentSchema = cm.parentSchema;
            this.parentModel = cm.parentModel;
            this.interfaceModels = cm.interfaceModels;
            this.children = cm.children;
            this.name = cm.name;
            this.classname = cm.classname;
            this.title = cm.title;
            this.description = cm.description;
            this.classVarName = cm.classVarName;
            this.modelJson = cm.modelJson;
            this.dataType = cm.dataType;
            this.xmlPrefix = cm.xmlPrefix;
            this.xmlNamespace = cm.xmlNamespace;
            this.xmlName = cm.xmlName;
            this.classFilename = cm.classFilename;
            this.unescapedDescription = cm.unescapedDescription;
            this.discriminator = cm.discriminator;
            this.defaultValue = cm.defaultValue;
            this.arrayModelType = cm.arrayModelType;
            this.isAlias = cm.isAlias;
            this.vars = cm.vars;
            this.requiredVars = cm.requiredVars;
            this.optionalVars = cm.optionalVars;
            this.readOnlyVars = cm.readOnlyVars;
            this.readWriteVars = cm.readWriteVars;
            this.allVars = cm.allVars;
            this.parentVars = cm.parentVars;
            this.allowableValues = cm.allowableValues;
            this.mandatory = cm.mandatory;
            this.allMandatory = cm.allMandatory;
            this.imports = cm.imports;
            this.hasVars = cm.hasVars;
            this.emptyVars = cm.emptyVars;
            this.hasMoreModels = cm.hasMoreModels;
            this.hasEnums = cm.hasEnums;
            this.isEnum = cm.isEnum;
            this.hasRequired = cm.hasRequired;
            this.hasOptional = cm.hasOptional;
            this.isArrayModel = cm.isArrayModel;
            this.hasChildren = cm.hasChildren;
            this.hasOnlyReadOnly = cm.hasOnlyReadOnly;
            this.externalDocs = cm.externalDocs;
            this.vendorExtensions = cm.vendorExtensions;
            this.additionalPropertiesType = cm.additionalPropertiesType;
            this.hasImports = !this.imports.isEmpty();
        }

        public boolean hasComplexVars() {
            for (CodegenProperty p : this.vars) {
                if (p.isPrimitiveType) continue;
                return true;
            }
            return false;
        }
    }

    class ExtendedCodegenOperation
    extends CodegenOperation {
        private List<String> pathTemplateNames = new ArrayList<String>();
        private String replacedPathName;

        public ExtendedCodegenOperation(CodegenOperation o) {
            this.responseHeaders.addAll(o.responseHeaders);
            this.hasAuthMethods = o.hasAuthMethods;
            this.hasConsumes = o.hasConsumes;
            this.hasProduces = o.hasProduces;
            this.hasParams = o.hasParams;
            this.hasOptionalParams = o.hasOptionalParams;
            this.returnTypeIsPrimitive = o.returnTypeIsPrimitive;
            this.returnSimpleType = o.returnSimpleType;
            this.subresourceOperation = o.subresourceOperation;
            this.isMapContainer = o.isMapContainer;
            this.isListContainer = o.isListContainer;
            this.isMultipart = o.isMultipart;
            this.hasMore = o.hasMore;
            this.isResponseBinary = o.isResponseBinary;
            this.hasReference = o.hasReference;
            this.isRestfulIndex = o.isRestfulIndex;
            this.isRestfulShow = o.isRestfulShow;
            this.isRestfulCreate = o.isRestfulCreate;
            this.isRestfulUpdate = o.isRestfulUpdate;
            this.isRestfulDestroy = o.isRestfulDestroy;
            this.isRestful = o.isRestful;
            this.path = o.path;
            this.operationId = o.operationId;
            this.returnType = o.returnType;
            this.httpMethod = o.httpMethod;
            this.returnBaseType = o.returnBaseType;
            this.returnContainer = o.returnContainer;
            this.summary = o.summary;
            this.unescapedNotes = o.unescapedNotes;
            this.notes = o.notes;
            this.baseName = o.baseName;
            this.defaultResponse = o.defaultResponse;
            this.discriminator = o.discriminator;
            this.consumes = o.consumes;
            this.produces = o.produces;
            this.bodyParam = o.bodyParam;
            this.allParams = o.allParams;
            this.bodyParams = o.bodyParams;
            this.pathParams = o.pathParams;
            this.queryParams = o.queryParams;
            this.headerParams = o.headerParams;
            this.formParams = o.formParams;
            this.authMethods = o.authMethods;
            this.tags = o.tags;
            this.responses = o.responses;
            this.imports = o.imports;
            this.examples = o.examples;
            this.externalDocs = o.externalDocs;
            this.vendorExtensions = o.vendorExtensions;
            this.nickname = o.nickname;
            this.operationIdLowerCase = o.operationIdLowerCase;
            this.operationIdCamelCase = o.operationIdCamelCase;
        }

        public List<String> getPathTemplateNames() {
            return this.pathTemplateNames;
        }

        public void setPathTemplateNames(List<String> pathTemplateNames) {
            this.pathTemplateNames = pathTemplateNames;
        }

        public String getReplacedPathName() {
            return this.replacedPathName;
        }

        public void setReplacedPathName(String replacedPathName) {
            this.replacedPathName = replacedPathName;
        }

        public String typespec() {
            StringBuilder sb = new StringBuilder("@spec ");
            sb.append(DefaultCodegen.underscore(this.operationId));
            sb.append("(Tesla.Env.client, ");
            for (CodegenParameter param : this.allParams) {
                if (!param.required) continue;
                this.buildTypespec(param, sb);
                sb.append(", ");
            }
            sb.append("keyword()) :: {:ok, ");
            if (this.returnBaseType == null) {
                sb.append("nil");
            } else if (this.returnSimpleType) {
                if (!this.returnTypeIsPrimitive) {
                    sb.append(ElixirClientCodegen.this.moduleName);
                    sb.append(".Model.");
                }
                sb.append(this.returnBaseType);
                sb.append(".t");
            } else if (this.returnContainer == null) {
                sb.append(this.returnBaseType);
                sb.append(".t");
            } else if (this.returnContainer.equals("array")) {
                sb.append("list(");
                if (!this.returnTypeIsPrimitive) {
                    sb.append(ElixirClientCodegen.this.moduleName);
                    sb.append(".Model.");
                }
                sb.append(this.returnBaseType);
                sb.append(".t)");
            } else if (this.returnContainer.equals("map")) {
                sb.append("map()");
            }
            sb.append("} | {:error, Tesla.Env.t}");
            return sb.toString();
        }

        private void buildTypespec(CodegenParameter param, StringBuilder sb) {
            if (param.dataType == null) {
                sb.append("nil");
            } else if (param.isListContainer) {
                sb.append("list(");
                if (param.isBodyParam) {
                    this.buildTypespec(param.items.items, sb);
                } else {
                    this.buildTypespec(param.items, sb);
                }
                sb.append(")");
            } else if (param.isMapContainer) {
                sb.append("%{optional(String.t) => ");
                this.buildTypespec(param.items, sb);
                sb.append("}");
            } else if (param.isPrimitiveType) {
                sb.append(param.dataType);
            } else if (param.isFile) {
                sb.append("String.t");
            } else {
                sb.append(ElixirClientCodegen.this.moduleName);
                sb.append(".Model.");
                sb.append(param.dataType);
                sb.append(".t");
            }
        }

        private void buildTypespec(CodegenProperty property, StringBuilder sb) {
            if (property.isListContainer) {
                sb.append("list(");
                this.buildTypespec(property.items, sb);
                sb.append(")");
            } else if (property.isMapContainer) {
                sb.append("%{optional(String.t) => ");
                this.buildTypespec(property.items, sb);
                sb.append("}");
            } else if (property.isPrimitiveType) {
                sb.append(property.baseType);
                sb.append(".t");
            } else {
                sb.append(ElixirClientCodegen.this.moduleName);
                sb.append(".Model.");
                sb.append(property.baseType);
                sb.append(".t");
            }
        }

        public String decodedStruct() {
            if (this.isMapContainer) {
                return "";
            }
            if (this.returnBaseType == null || this.returnSimpleType && this.returnTypeIsPrimitive) {
                return "false";
            }
            StringBuilder sb = new StringBuilder();
            if (this.isListContainer) {
                sb.append("[");
            }
            sb.append("%");
            sb.append(ElixirClientCodegen.this.moduleName);
            sb.append(".Model.");
            sb.append(this.returnBaseType);
            sb.append("{}");
            if (this.isListContainer) {
                sb.append("]");
            }
            return sb.toString();
        }
    }
}

