/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenResponse;
import io.swagger.codegen.CodegenSecurity;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.AbstractPhpCodegen;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymfonyServerCodegen
extends AbstractPhpCodegen
implements CodegenConfig {
    static Logger LOGGER = LoggerFactory.getLogger(SymfonyServerCodegen.class);
    public static final String BUNDLE_NAME = "bundleName";
    public static final String COMPOSER_VENDOR_NAME = "composerVendorName";
    public static final String COMPOSER_PROJECT_NAME = "composerProjectName";
    public static final Map<String, String> SYMFONY_EXCEPTIONS = new HashMap<String, String>();
    protected String testsPackage;
    protected String apiTestsPackage;
    protected String modelTestsPackage;
    protected String composerVendorName = "swagger";
    protected String composerProjectName = "server-bundle";
    protected String testsDirName = "Tests";
    protected String bundleName;
    protected String bundleClassName;
    protected String bundleExtensionName;
    protected String bundleAlias;
    protected String controllerDirName = "Controller";
    protected String controllerPackage;

    public SymfonyServerCodegen() {
        this.importMapping.clear();
        this.supportsInheritance = true;
        this.srcBasePath = ".";
        this.setInvokerPackage("Swagger\\Server");
        this.setBundleName("SwaggerServer");
        this.packagePath = "SymfonyBundle-php";
        this.modelDirName = "Model";
        this.docsBasePath = "Resources" + File.separator + "docs";
        this.apiDocPath = this.docsBasePath + File.separator + this.apiDirName;
        this.modelDocPath = this.docsBasePath + File.separator + this.modelDirName;
        this.outputFolder = "generated-code" + File.separator + "php";
        this.apiTemplateFiles.put("api_controller.mustache", ".php");
        this.modelTestTemplateFiles.put("model_test.mustache", ".php");
        this.templateDir = "php-symfony";
        this.embeddedTemplateDir = "php-symfony";
        this.setReservedWordsLowerCase(Arrays.asList("resourcePath", "httpBody", "queryParams", "headerParams", "formParams", "_header_accept", "_tempBody", "__halt_compiler", "abstract", "and", "array", "as", "break", "callable", "case", "catch", "class", "clone", "const", "continue", "declare", "default", "die", "do", "echo", "else", "elseif", "empty", "enddeclare", "endfor", "endforeach", "endif", "endswitch", "endwhile", "eval", "exit", "extends", "final", "for", "foreach", "function", "global", "goto", "if", "implements", "include", "include_once", "instanceof", "insteadof", "interface", "isset", "list", "namespace", "new", "or", "print", "private", "protected", "public", "require", "require_once", "return", "static", "switch", "throw", "trait", "try", "unset", "use", "var", "while", "xor"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("bool", "boolean", "int", "integer", "double", "float", "string", "object", "DateTime", "mixed", "number", "void", "byte"));
        this.instantiationTypes.put("array", "array");
        this.instantiationTypes.put("map", "map");
        ArrayList sortedLanguageSpecificPrimitives = new ArrayList(this.languageSpecificPrimitives);
        Collections.sort(sortedLanguageSpecificPrimitives);
        String primitives = "'" + StringUtils.join(sortedLanguageSpecificPrimitives, (String)"', '") + "'";
        this.additionalProperties.put("primitives", primitives);
        this.typeMapping = new HashMap();
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("long", "int");
        this.typeMapping.put("number", "float");
        this.typeMapping.put("float", "float");
        this.typeMapping.put("double", "double");
        this.typeMapping.put("string", "string");
        this.typeMapping.put("byte", "int");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("Date", "\\DateTime");
        this.typeMapping.put("DateTime", "\\DateTime");
        this.typeMapping.put("file", "\\SplFileObject");
        this.typeMapping.put("map", "map");
        this.typeMapping.put("array", "array");
        this.typeMapping.put("list", "array");
        this.typeMapping.put("object", "object");
        this.typeMapping.put("binary", "string");
        this.typeMapping.put("ByteArray", "string");
        this.typeMapping.put("UUID", "string");
        this.cliOptions.add(new CliOption(COMPOSER_VENDOR_NAME, "The vendor name used in the composer package name. The template uses {{composerVendorName}}/{{composerProjectName}} for the composer package name. e.g. yaypets. IMPORTANT NOTE (2016/03): composerVendorName will be deprecated and replaced by gitUserId in the next swagger-codegen release"));
        this.cliOptions.add(new CliOption(BUNDLE_NAME, "The name of the Symfony bundle. The template uses {{bundleName}}"));
        this.cliOptions.add(new CliOption(COMPOSER_PROJECT_NAME, "The project name used in the composer package name. The template uses {{composerVendorName}}/{{composerProjectName}} for the composer package name. e.g. petstore-client. IMPORTANT NOTE (2016/03): composerProjectName will be deprecated and replaced by gitRepoId in the next swagger-codegen release"));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "hides the timestamp when files were generated").defaultValue(Boolean.TRUE.toString()));
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
        this.bundleClassName = bundleName + "Bundle";
        this.bundleExtensionName = bundleName + "Extension";
        this.bundleAlias = this.snakeCase(bundleName).replaceAll("([A-Z]+)", "\\_$1").toLowerCase();
    }

    public String controllerFileFolder() {
        return this.outputFolder + File.separator + this.toPackagePath(this.controllerPackage, this.srcBasePath);
    }

    @Override
    public String escapeText(String input) {
        if (input != null) {
            return super.escapeText(input).trim();
        }
        return input;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "php-symfony";
    }

    @Override
    public String getHelp() {
        return "Generates a Symfony server bundle.";
    }

    @Override
    public String apiFilename(String templateName, String tag) {
        String suffix = this.apiTemplateFiles().get(templateName);
        if (templateName.equals("api_controller.mustache")) {
            return this.controllerFileFolder() + '/' + this.toControllerName(tag) + suffix;
        }
        return this.apiFileFolder() + '/' + this.toApiFilename(tag) + suffix;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (!this.additionalProperties.containsKey("hideGenerationTimestamp")) {
            this.additionalProperties.put("hideGenerationTimestamp", Boolean.TRUE.toString());
        } else {
            this.additionalProperties.put("hideGenerationTimestamp", Boolean.valueOf(this.additionalProperties().get("hideGenerationTimestamp").toString()));
        }
        if (this.additionalProperties.containsKey(BUNDLE_NAME)) {
            this.setBundleName((String)this.additionalProperties.get(BUNDLE_NAME));
        } else {
            this.additionalProperties.put(BUNDLE_NAME, this.bundleName);
        }
        if (this.additionalProperties.containsKey(COMPOSER_PROJECT_NAME)) {
            this.setComposerProjectName((String)this.additionalProperties.get(COMPOSER_PROJECT_NAME));
        } else {
            this.additionalProperties.put(COMPOSER_PROJECT_NAME, this.composerProjectName);
        }
        if (this.additionalProperties.containsKey(COMPOSER_VENDOR_NAME)) {
            this.setComposerVendorName((String)this.additionalProperties.get(COMPOSER_VENDOR_NAME));
        } else {
            this.additionalProperties.put(COMPOSER_VENDOR_NAME, this.composerVendorName);
        }
        this.additionalProperties.put("escapedInvokerPackage", this.invokerPackage.replace("\\", "\\\\"));
        this.additionalProperties.put("controllerPackage", this.controllerPackage);
        this.additionalProperties.put("apiTestsPackage", this.apiTestsPackage);
        this.additionalProperties.put("modelTestsPackage", this.modelTestsPackage);
        this.additionalProperties.put(BUNDLE_NAME, this.bundleName);
        this.additionalProperties.put("bundleClassName", this.bundleClassName);
        this.additionalProperties.put("bundleExtensionName", this.bundleExtensionName);
        this.additionalProperties.put("bundleAlias", this.bundleAlias);
        this.additionalProperties.put("apiSrcPath", "." + File.separator + this.toSrcPath(this.apiPackage, this.srcBasePath));
        this.additionalProperties.put("modelSrcPath", "." + File.separator + this.toSrcPath(this.modelPackage, this.srcBasePath));
        this.additionalProperties.put("testsSrcPath", "." + File.separator + this.toSrcPath(this.testsPackage, this.srcBasePath));
        this.additionalProperties.put("apiTestsSrcPath", "." + File.separator + this.toSrcPath(this.apiTestsPackage, this.srcBasePath));
        this.additionalProperties.put("modelTestsSrcPath", "." + File.separator + this.toSrcPath(this.modelTestsPackage, this.srcBasePath));
        this.additionalProperties.put("apiTestPath", "." + File.separator + this.testsDirName + File.separator + this.apiDirName);
        this.additionalProperties.put("modelTestPath", "." + File.separator + this.testsDirName + File.separator + this.modelDirName);
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.additionalProperties.put("testsDirName", this.testsDirName);
        String configDir = this.getPackagePath() + File.separator + "Resources" + File.separator + "config";
        String dependencyInjectionDir = this.getPackagePath() + File.separator + "DependencyInjection";
        this.supportingFiles.add(new SupportingFile("Controller.mustache", this.toPackagePath(this.controllerPackage, this.srcBasePath), "Controller.php"));
        this.supportingFiles.add(new SupportingFile("Bundle.mustache", this.getPackagePath(), this.bundleClassName + ".php"));
        this.supportingFiles.add(new SupportingFile("Extension.mustache", dependencyInjectionDir, this.bundleExtensionName + ".php"));
        this.supportingFiles.add(new SupportingFile("ApiPass.mustache", dependencyInjectionDir + File.separator + "Compiler", this.bundleName + "ApiPass.php"));
        this.supportingFiles.add(new SupportingFile("ApiServer.mustache", this.toPackagePath(this.apiPackage, this.srcBasePath), "ApiServer.php"));
        this.supportingFiles.add(new SupportingFile("ModelSerializer.mustache", this.toPackagePath(this.modelPackage, this.srcBasePath), "ModelSerializer.php"));
        this.supportingFiles.add(new SupportingFile("ModelInterface.mustache", this.toPackagePath(this.modelPackage, this.srcBasePath), "ModelInterface.php"));
        this.supportingFiles.add(new SupportingFile("routing.mustache", configDir, "routing.yml"));
        this.supportingFiles.add(new SupportingFile("services.mustache", configDir, "services.yml"));
        this.supportingFiles.add(new SupportingFile("composer.mustache", this.getPackagePath(), "composer.json"));
        this.supportingFiles.add(new SupportingFile("autoload.mustache", this.getPackagePath(), "autoload.php"));
        this.supportingFiles.add(new SupportingFile("README.mustache", this.getPackagePath(), "README.md"));
        this.supportingFiles.add(new SupportingFile("phpunit.xml.mustache", this.getPackagePath(), "phpunit.xml.dist"));
        this.supportingFiles.add(new SupportingFile(".travis.yml", this.getPackagePath(), ".travis.yml"));
        this.supportingFiles.add(new SupportingFile(".php_cs", this.getPackagePath(), ".php_cs"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", this.getPackagePath(), "git_push.sh"));
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        objs = super.postProcessOperations(objs);
        Map operations = (Map)objs.get("operations");
        operations.put("controllerName", this.toControllerName((String)operations.get("pathPrefix")));
        operations.put("symfonyService", this.toSymfonyService((String)operations.get("pathPrefix")));
        HashSet<CodegenSecurity> authMethods = new HashSet<CodegenSecurity>();
        HashSet<String> imports = new HashSet<String>();
        List operationList = (List)operations.get("operation");
        for (CodegenOperation op : operationList) {
            for (CodegenParameter param : op.allParams) {
                String simpleName = this.extractSimpleName(param.dataType);
                param.vendorExtensions.put("x-simpleName", simpleName);
                boolean isScalarType = this.typeMapping.containsValue(param.dataType);
                param.vendorExtensions.put("x-parameterType", isScalarType ? null : simpleName);
                if (isScalarType) continue;
                imports.add(param.dataType);
            }
            for (CodegenResponse response : op.responses) {
                String exception = SYMFONY_EXCEPTIONS.get(response.code);
                response.vendorExtensions.put("x-symfonyException", exception);
                response.vendorExtensions.put("x-symfonyExceptionSimple", this.extractSimpleName(exception));
                if (response.dataType != null) {
                    String dataType = this.extractSimpleName(response.dataType);
                    response.vendorExtensions.put("x-simpleName", dataType);
                    imports.add(response.dataType.replaceFirst("\\[\\]$", ""));
                }
                if (exception == null) continue;
                imports.add(exception);
            }
            if (op.authMethods == null) continue;
            authMethods.addAll(op.authMethods);
        }
        operations.put("imports", new ArrayList(imports));
        operations.put("authMethods", authMethods);
        return objs;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        objs = super.postProcessModels(objs);
        ArrayList modelsArray = (ArrayList)objs.get("models");
        Map models = (Map)modelsArray.get(0);
        CodegenModel model = (CodegenModel)models.get("model");
        HashSet<String> imports = new HashSet<String>();
        for (CodegenProperty var : model.vars) {
            if (var.datatype == null) continue;
            String importType = var.datatype.replaceFirst("\\[\\]$", "");
            String dataType = this.extractSimpleName(var.datatype);
            boolean isScalarType = this.typeMapping.containsValue(importType);
            var.vendorExtensions.put("x-fullType", var.datatype);
            if (!isScalarType) {
                var.vendorExtensions.put("x-typeAnnotation", dataType.endsWith("[]") ? "array" : dataType);
                imports.add(importType);
                var.datatype = dataType;
            }
            if (!var.isBoolean) continue;
            var.getter = var.getter.replaceAll("^get", "is");
        }
        objs.put("useStatements", new ArrayList(imports));
        return objs;
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + File.separator + this.toPackagePath(this.apiTestsPackage, this.srcBasePath);
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + File.separator + this.toPackagePath(this.modelTestsPackage, this.srcBasePath);
    }

    public void setComposerVendorName(String composerVendorName) {
        this.composerVendorName = composerVendorName;
    }

    public void setComposerProjectName(String composerProjectName) {
        this.composerProjectName = composerProjectName;
    }

    @Override
    public void setInvokerPackage(String invokerPackage) {
        super.setInvokerPackage(invokerPackage);
        this.apiPackage = invokerPackage + "\\" + this.apiDirName;
        this.modelPackage = invokerPackage + "\\" + this.modelDirName;
        this.testsPackage = invokerPackage + "\\" + this.testsDirName;
        this.apiTestsPackage = this.testsPackage + "\\" + this.apiDirName;
        this.modelTestsPackage = this.testsPackage + "\\" + this.modelDirName;
        this.controllerPackage = invokerPackage + "\\" + this.controllerDirName;
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getTypeDeclaration(inner) + "[]";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "array<string," + this.getTypeDeclaration(inner) + ">";
        }
        if (p instanceof RefProperty) {
            return this.getTypeDeclaration(this.getPropertyTypeDeclaration(p));
        }
        return this.getPropertyTypeDeclaration(p);
    }

    public String getPropertyTypeDeclaration(Property p) {
        String swaggerType = this.getSwaggerType(p);
        if (this.typeMapping.containsKey(swaggerType)) {
            return (String)this.typeMapping.get(swaggerType);
        }
        return swaggerType;
    }

    @Override
    public String getTypeDeclaration(String name) {
        if (!this.languageSpecificPrimitives.contains(name)) {
            return this.modelPackage + "\\" + name;
        }
        return super.getTypeDeclaration(name);
    }

    @Override
    public String toApiName(String name) {
        if (name.isEmpty()) {
            return "DefaultApiInterface";
        }
        return SymfonyServerCodegen.camelize(name, false) + "ApiInterface";
    }

    protected String toControllerName(String name) {
        if (name.isEmpty()) {
            return "DefaultController";
        }
        return SymfonyServerCodegen.camelize(name, false) + "Controller";
    }

    protected String toSymfonyService(String name) {
        String prefix = this.composerVendorName + ".api.";
        if (name.isEmpty()) {
            return prefix + "default";
        }
        return prefix + name;
    }

    static {
        SYMFONY_EXCEPTIONS.put("400", "Symfony\\Component\\HttpKernel\\Exception\\BadRequestHttpException");
        SYMFONY_EXCEPTIONS.put("401", "Symfony\\Component\\HttpKernel\\Exception\\UnauthorizedHttpException");
        SYMFONY_EXCEPTIONS.put("403", "Symfony\\Component\\HttpKernel\\Exception\\AccessDeniedHttpException");
        SYMFONY_EXCEPTIONS.put("404", "Symfony\\Component\\HttpKernel\\Exception\\NotFoundHttpException");
        SYMFONY_EXCEPTIONS.put("405", "Symfony\\Component\\HttpKernel\\Exception\\MethodNotAllowedHttpException");
        SYMFONY_EXCEPTIONS.put("406", "Symfony\\Component\\HttpKernel\\Exception\\NotAcceptableHttpException");
        SYMFONY_EXCEPTIONS.put("409", "Symfony\\Component\\HttpKernel\\Exception\\ConflictHttpException");
        SYMFONY_EXCEPTIONS.put("410", "Symfony\\Component\\HttpKernel\\Exception\\GoneHttpException");
        SYMFONY_EXCEPTIONS.put("411", "Symfony\\Component\\HttpKernel\\Exception\\LengthRequiredHttpException");
        SYMFONY_EXCEPTIONS.put("412", "Symfony\\Component\\HttpKernel\\Exception\\PreconditionFailedHttpException");
        SYMFONY_EXCEPTIONS.put("415", "Symfony\\Component\\HttpKernel\\Exception\\UnsupportedMediaTypeHttpException");
        SYMFONY_EXCEPTIONS.put("422", "Symfony\\Component\\HttpKernel\\Exception\\UnprocessableEntityHttpException");
        SYMFONY_EXCEPTIONS.put("428", "Symfony\\Component\\HttpKernel\\Exception\\PreconditionRequiredHttpException");
        SYMFONY_EXCEPTIONS.put("429", "Symfony\\Component\\HttpKernel\\Exception\\TooManyRequestsHttpException");
        SYMFONY_EXCEPTIONS.put("503", "Symfony\\Component\\HttpKernel\\Exception\\ServiceUnavailableHttpException");
    }
}

