/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerShellClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    static Logger LOGGER = LoggerFactory.getLogger(PowerShellClientCodegen.class);
    private String packageGuid = "{" + UUID.randomUUID().toString().toUpperCase() + "}";
    protected String sourceFolder = "src";
    protected String packageName = "IO.Swagger";
    protected String csharpClientPath = "$ScriptDir\\csharp\\SwaggerClient";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";

    public PowerShellClientCodegen() {
        this.outputFolder = "generated-code" + File.separator + "powershell";
        this.modelTemplateFiles.put("model.mustache", ".ps1");
        this.apiTemplateFiles.put("api.mustache", ".ps1");
        this.modelTestTemplateFiles.put("model_test.mustache", ".ps1");
        this.apiTestTemplateFiles.put("api_test.mustache", ".ps1");
        this.modelDocTemplateFiles.clear();
        this.apiDocTemplateFiles.clear();
        this.templateDir = "powershell";
        this.embeddedTemplateDir = "powershell";
        this.apiPackage = this.packageName + File.separator + "API";
        this.modelPackage = this.packageName + File.separator + "Model";
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("Byte", "SByte", "Byte[]", "Int16", "Int32", "Int64", "UInt16", "UInt32", "UInt64", "Decimal", "Single", "Double", "TimeSpan", "System.DateTime", "ProgressRecord", "Char", "String", "XmlDocument", "SecureString", "Boolean", "Guid", "Uri", "Version"));
        this.reservedWords = new HashSet<String>(Arrays.asList("Begin", "Break", "Catch", "Continue", "Data", "Do", "Dynamicparam", "Else", "Elseif", "End", "Exit", "Filter", "Finally", "For", "Foreach", "From", "Function", "If", "In", "Param", "Process", "Return", "Switch", "Throw", "Trap", "Try", "Until", "While", "Local", "Private", "Where"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("Byte", "SByte", "Byte[]", "Int16", "Int32", "Int64", "UInt16", "UInt32", "UInt64", "Decimal", "Single", "Double", "TimeSpan", "System.DateTime", "ProgressRecord", "Char", "String", "XmlDocument", "SecureString", "Boolean", "Guid", "Uri", "Version"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("string", "String");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("integer", "Int32");
        this.typeMapping.put("float", "Double");
        this.typeMapping.put("long", "Int64");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("number", "Decimal");
        this.typeMapping.put("date-time", "System.DateTime");
        this.typeMapping.put("date", "System.DateTime");
        this.typeMapping.put("file", "String");
        this.typeMapping.put("object", "String");
        this.typeMapping.put("binary", "String");
        this.typeMapping.put("Date", "System.DateTime");
        this.typeMapping.put("DateTime", "System.DateTime");
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("packageName", "Client package name (e.g. io.swagger.client).").defaultValue(this.packageName));
        this.cliOptions.add(new CliOption("packageGuid", "GUID for PowerShell module (e.g. a27b908d-2a20-467f-bc32-af6f3a654ac5). A random GUID will be generated by default."));
        this.cliOptions.add(new CliOption("csharpClientPath", "Path to the C# API client generated by Swagger Codegen, e.g. $ScriptDir\\..\\csharp\\SwaggerClient where $ScriptDir is the current directory.").defaultValue(this.csharpClientPath));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "powershell";
    }

    @Override
    public String getHelp() {
        return "Generates a PowerShell API client (beta).";
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setCsharpClientPath(String csharpClientPath) {
        this.csharpClientPath = csharpClientPath;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    public void setPackageGuid(String packageGuid) {
        this.packageGuid = packageGuid;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageGuid")) {
            this.setPackageGuid((String)this.additionalProperties.get("packageGuid"));
        }
        this.additionalProperties.put("packageGuid", this.packageGuid);
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        } else {
            this.additionalProperties.put("packageName", this.packageName);
        }
        if (this.additionalProperties.containsKey("csharpClientPath")) {
            this.setCsharpClientPath((String)this.additionalProperties.get("csharpClientPath"));
        } else {
            this.additionalProperties.put("csharpClientPath", this.csharpClientPath);
        }
        if (this.additionalProperties.containsKey("modelPackage")) {
            LOGGER.warn("modelPackage with " + this.getName() + " generator is ignored. Setting this value independently of " + "packageName" + " is not currently supported.");
        }
        if (this.additionalProperties.containsKey("apiPackage")) {
            LOGGER.warn("apiPackage with " + this.getName() + " generator is ignored. Setting this value independently of " + "packageName" + " is not currently supported.");
        }
        this.additionalProperties.put("apiPackage", this.apiPackage());
        this.additionalProperties.put("modelPackage", this.modelPackage());
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("Build.ps1.mustache", "", "Build.ps1"));
        String infrastructureFolder = this.sourceFolder + File.separator + this.packageName + File.separator;
        this.supportingFiles.add(new SupportingFile("IO.Swagger.psm1.mustache", infrastructureFolder, this.packageName + ".psm1"));
        this.supportingFiles.add(new SupportingFile("Get-CommonParameters.ps1", infrastructureFolder + File.separator + "Private" + File.separator, "Get-CommonParameters.ps1"));
        this.supportingFiles.add(new SupportingFile("Out-DebugParameter.ps1", infrastructureFolder + File.separator + "Private" + File.separator, "Out-DebugParameter.ps1"));
        this.supportingFiles.add(new SupportingFile("about_IO.Swagger.help.txt.mustache", infrastructureFolder + File.separator + "en-US" + File.separator + "about_" + this.packageName + ".help.txt"));
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("#>", "#_>").replace("<#", "<_#");
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String apiTestFileFolder() {
        return (this.outputFolder + "/test").replace('/', File.separatorChar);
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.apiPackage();
    }

    @Override
    public String modelTestFileFolder() {
        return (this.outputFolder + "/test").replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.modelPackage();
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String toModelName(String name) {
        if (!StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(name = this.sanitizeName(name))) {
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + PowerShellClientCodegen.camelize("model_" + name));
            name = "model_" + name;
        }
        if (name.matches("^\\d.*")) {
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + PowerShellClientCodegen.camelize("model_" + name));
            name = "model_" + name;
        }
        return PowerShellClientCodegen.camelize(name);
    }

    @Override
    public String toModelFilename(String name) {
        return "New-" + this.toModelName(name);
    }

    @Override
    public String getSwaggerType(Property p) {
        String type;
        String swaggerType = super.getSwaggerType(p);
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getTypeDeclaration(inner) + "[]";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return "{String, " + this.getTypeDeclaration(inner) + "}";
        }
        if (!this.languageSpecificPrimitives.contains(this.getSwaggerType(p))) {
            return this.packageName + ".Model." + super.getTypeDeclaration(p);
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId)) {
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + PowerShellClientCodegen.camelize(this.sanitizeName("call_" + operationId)));
            operationId = "call_" + operationId;
        }
        return PowerShellClientCodegen.camelize(this.sanitizeName(operationId));
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        for (CodegenOperation op : operationList) {
            int index = 0;
            for (CodegenParameter p : op.allParams) {
                p.vendorExtensions.put("x-index", index);
                ++index;
            }
        }
        return objs;
    }
}

