/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;

public class CsharpDotNet2ClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    public static final String CLIENT_PACKAGE = "clientPackage";
    protected String packageName = "IO.Swagger";
    protected String packageVersion = "1.0.0";
    protected String clientPackage = "IO.Swagger.Client";
    protected String sourceFolder = "src" + File.separator + "main" + File.separator + "CsharpDotNet2";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";

    public CsharpDotNet2ClientCodegen() {
        this.importMapping.clear();
        this.outputFolder = "generated-code" + File.separator + "CsharpDotNet2";
        this.modelTemplateFiles.put("model.mustache", ".cs");
        this.apiTemplateFiles.put("api.mustache", ".cs");
        this.templateDir = "CsharpDotNet2";
        this.embeddedTemplateDir = "CsharpDotNet2";
        this.apiPackage = "IO.Swagger.Api";
        this.modelPackage = "IO.Swagger.Model";
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.setReservedWordsLowerCase(Arrays.asList("path", "queryParams", "headerParams", "formParams", "fileParams", "postBody", "authSettings", "response", "StatusCode", "abstract", "as", "base", "bool", "break", "byte", "case", "catch", "char", "checked", "class", "const", "continue", "decimal", "default", "delegate", "do", "double", "else", "enum", "event", "explicit", "extern", "false", "finally", "fixed", "float", "for", "foreach", "goto", "if", "implicit", "in", "int", "interface", "internal", "is", "lock", "long", "namespace", "new", "null", "object", "operator", "out", "override", "params", "private", "protected", "public", "readonly", "ref", "return", "sbyte", "sealed", "short", "sizeof", "stackalloc", "static", "string", "struct", "switch", "this", "throw", "true", "try", "typeof", "uint", "ulong", "unchecked", "unsafe", "ushort", "using", "virtual", "void", "volatile", "while"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("String", "string", "bool?", "double?", "int?", "long?", "float?", "byte[]", "List", "Dictionary", "DateTime?", "String", "Boolean", "Double", "Integer", "Long", "Float", "Guid?", "System.IO.Stream", "Object"));
        this.instantiationTypes.put("array", "List");
        this.instantiationTypes.put("map", "Dictionary");
        this.typeMapping = new HashMap();
        this.typeMapping.put("string", "string");
        this.typeMapping.put("boolean", "bool?");
        this.typeMapping.put("integer", "int?");
        this.typeMapping.put("float", "float?");
        this.typeMapping.put("long", "long?");
        this.typeMapping.put("double", "double?");
        this.typeMapping.put("number", "double?");
        this.typeMapping.put("datetime", "DateTime?");
        this.typeMapping.put("date", "DateTime?");
        this.typeMapping.put("file", "System.IO.Stream");
        this.typeMapping.put("array", "List");
        this.typeMapping.put("list", "List");
        this.typeMapping.put("map", "Dictionary");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("uuid", "Guid?");
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("packageName", "C# package name (convention: Camel.Case).").defaultValue("IO.Swagger"));
        this.cliOptions.add(new CliOption("packageVersion", "C# package version.").defaultValue("1.0.0"));
        this.cliOptions.add(new CliOption(CLIENT_PACKAGE, "C# client package name (convention: Camel.Case).").defaultValue("IO.Swagger.Client"));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        } else {
            this.additionalProperties.put("packageVersion", this.packageVersion);
        }
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
            this.apiPackage = this.packageName + ".Api";
            this.modelPackage = this.packageName + ".Model";
            this.clientPackage = this.packageName + ".Client";
        } else {
            this.additionalProperties.put("packageName", this.packageName);
        }
        if (this.additionalProperties.containsKey(CLIENT_PACKAGE)) {
            this.setClientPackage((String)this.additionalProperties.get(CLIENT_PACKAGE));
        } else {
            this.additionalProperties.put(CLIENT_PACKAGE, this.clientPackage);
        }
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.supportingFiles.add(new SupportingFile("Configuration.mustache", this.sourceFolder + File.separator + this.clientPackage.replace(".", File.separator), "Configuration.cs"));
        this.supportingFiles.add(new SupportingFile("ApiClient.mustache", this.sourceFolder + File.separator + this.clientPackage.replace(".", File.separator), "ApiClient.cs"));
        this.supportingFiles.add(new SupportingFile("ApiException.mustache", this.sourceFolder + File.separator + this.clientPackage.replace(".", File.separator), "ApiException.cs"));
        this.supportingFiles.add(new SupportingFile("packages.config.mustache", "vendor", "packages.config"));
        this.supportingFiles.add(new SupportingFile("compile-mono.sh.mustache", "", "compile-mono.sh"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
    }

    public void setClientPackage(String clientPackage) {
        this.clientPackage = clientPackage;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "CsharpDotNet2";
    }

    @Override
    public String getHelp() {
        return "Generates a C# .Net 2.0 client library.";
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String toVarName(String name) {
        if ((name = name.replaceAll("-", "_")).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = CsharpDotNet2ClientCodegen.camelize(name)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        if ((name = name.replaceAll("-", "_")).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = CsharpDotNet2ClientCodegen.camelize(name, true)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toModelName(String name) {
        if (!StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(name = this.sanitizeName(name))) {
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + CsharpDotNet2ClientCodegen.camelize("model_" + name));
            name = "model_" + name;
        }
        if (name.matches("^\\d.*")) {
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + CsharpDotNet2ClientCodegen.camelize("model_" + name));
            name = "model_" + name;
        }
        return CsharpDotNet2ClientCodegen.camelize(name);
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getSwaggerType(p) + "<" + this.getTypeDeclaration(inner) + ">";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "<String, " + this.getTypeDeclaration(inner) + ">";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType.toLowerCase())) {
            type = (String)this.typeMapping.get(swaggerType.toLowerCase());
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }

    @Override
    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId)) {
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + CsharpDotNet2ClientCodegen.camelize(this.sanitizeName("call_" + operationId)));
            operationId = "call_" + operationId;
        }
        return CsharpDotNet2ClientCodegen.camelize(this.sanitizeName(operationId));
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }
}

