/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenResponse;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.languages.AbstractJavaCodegen;
import io.swagger.codegen.languages.features.BeanValidationFeatures;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJavaJAXRSServerCodegen
extends AbstractJavaCodegen
implements BeanValidationFeatures {
    protected static final String JAXRS_TEMPLATE_DIRECTORY_NAME = "JavaJaxRS";
    protected String implFolder = "src/main/java";
    protected String testResourcesFolder = "src/test/resources";
    protected String title = "Swagger Server";
    protected boolean useBeanValidation = true;
    static Logger LOGGER = LoggerFactory.getLogger(AbstractJavaJAXRSServerCodegen.class);

    public AbstractJavaJAXRSServerCodegen() {
        this.sourceFolder = "src/gen/java";
        this.invokerPackage = "io.swagger.api";
        this.artifactId = "swagger-jaxrs-server";
        this.dateLibrary = "legacy";
        this.apiPackage = "io.swagger.api";
        this.modelPackage = "io.swagger.model";
        this.additionalProperties.put("title", this.title);
        this.additionalProperties.put("jackson", "true");
        this.cliOptions.add(new CliOption("implFolder", "folder for generated implementation code"));
        this.cliOptions.add(new CliOption("title", "a title describing the application"));
        this.cliOptions.add(CliOption.newBoolean("useBeanValidation", "Use BeanValidation API annotations"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("implFolder")) {
            this.implFolder = (String)this.additionalProperties.get("implFolder");
        }
        if (this.additionalProperties.containsKey("useBeanValidation")) {
            this.setUseBeanValidation(this.convertPropertyToBoolean("useBeanValidation"));
        }
        if (this.useBeanValidation) {
            this.writePropertyBack("useBeanValidation", this.useBeanValidation);
        }
    }

    @Override
    public void preprocessSwagger(Swagger swagger) {
        String[] parts;
        if ("/".equals(swagger.getBasePath())) {
            swagger.setBasePath("");
        }
        String host = swagger.getHost();
        String port = "8080";
        if (host != null && (parts = host.split(":")).length > 1) {
            port = parts[1];
        }
        this.additionalProperties.put("serverPort", port);
        if (swagger.getPaths() != null) {
            for (String pathname : swagger.getPaths().keySet()) {
                Path path = swagger.getPath(pathname);
                if (path.getOperations() == null) continue;
                for (Operation operation : path.getOperations()) {
                    if (operation.getTags() == null) continue;
                    ArrayList tags = new ArrayList();
                    for (String tag : operation.getTags()) {
                        HashMap<String, String> value = new HashMap<String, String>();
                        value.put("tag", tag);
                        value.put("hasMore", "true");
                        tags.add(value);
                    }
                    if (tags.size() > 0) {
                        ((Map)tags.get(tags.size() - 1)).remove("hasMore");
                    }
                    if (operation.getTags().size() > 0) {
                        String tag = (String)operation.getTags().get(0);
                        operation.setTags(Arrays.asList(tag));
                    }
                    operation.setVendorExtension("x-tags", tags);
                }
            }
        }
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        if (operations != null) {
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                String string;
                int end;
                boolean isMultipartPost = false;
                List<Map<String, String>> consumes = operation.consumes;
                if (consumes != null) {
                    for (Map map : consumes) {
                        String mt = (String)map.get("mediaType");
                        if (mt == null || !mt.startsWith("multipart/form-data")) continue;
                        isMultipartPost = true;
                    }
                }
                for (CodegenParameter codegenParameter : operation.allParams) {
                    if (!isMultipartPost) continue;
                    codegenParameter.vendorExtensions.put("x-multipart", "true");
                }
                List<CodegenResponse> responses = operation.responses;
                if (responses != null) {
                    for (CodegenResponse resp : responses) {
                        if (!"0".equals(resp.code)) continue;
                        resp.code = "200";
                    }
                }
                if (operation.returnType == null) {
                    operation.returnType = "void";
                    operation.vendorExtensions.put("x-java-is-response-void", true);
                    continue;
                }
                if (operation.returnType.startsWith("List")) {
                    String string2 = operation.returnType;
                    int end2 = string2.lastIndexOf(">");
                    if (end2 <= 0) continue;
                    operation.returnType = string2.substring("List<".length(), end2).trim();
                    operation.returnContainer = "List";
                    continue;
                }
                if (operation.returnType.startsWith("Map")) {
                    String string3 = operation.returnType;
                    int end3 = string3.lastIndexOf(">");
                    if (end3 <= 0) continue;
                    operation.returnType = string3.substring("Map<".length(), end3).split(",")[1].trim();
                    operation.returnContainer = "Map";
                    continue;
                }
                if (!operation.returnType.startsWith("Set") || (end = (string = operation.returnType).lastIndexOf(">")) <= 0) continue;
                operation.returnType = string.substring("Set<".length(), end).trim();
                operation.returnContainer = "Set";
            }
        }
        return objs;
    }

    @Override
    public String toApiName(String name) {
        String computed = name;
        if (computed.length() == 0) {
            return "DefaultApi";
        }
        computed = this.sanitizeName(computed);
        return AbstractJavaJAXRSServerCodegen.camelize(computed) + "Api";
    }

    @Override
    public String apiFilename(String templateName, String tag) {
        String result = super.apiFilename(templateName, tag);
        if (templateName.endsWith("Impl.mustache")) {
            int ix = result.lastIndexOf(47);
            result = result.substring(0, ix) + "/impl" + result.substring(ix, result.length() - 5) + "ServiceImpl.java";
            result = result.replace(this.apiFileFolder(), this.implFileFolder(this.implFolder));
        } else if (templateName.endsWith("Factory.mustache")) {
            int ix = result.lastIndexOf(47);
            result = result.substring(0, ix) + "/factories" + result.substring(ix, result.length() - 5) + "ServiceFactory.java";
            result = result.replace(this.apiFileFolder(), this.implFileFolder(this.implFolder));
        } else if (templateName.endsWith("Service.mustache")) {
            int ix = result.lastIndexOf(46);
            result = result.substring(0, ix) + "Service.java";
        }
        return result;
    }

    private String implFileFolder(String output) {
        return this.outputFolder + "/" + output + "/" + this.apiPackage().replace('.', '/');
    }

    @Override
    public void setUseBeanValidation(boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
    }
}

