/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.AbstractJavaCodegen;
import java.io.File;

public class GroovyClientCodegen
extends AbstractJavaCodegen {
    public static final String CONFIG_PACKAGE = "configPackage";
    protected String title = "Petstore Server";
    protected String configPackage = "";

    public GroovyClientCodegen() {
        this.sourceFolder = this.projectFolder + File.separator + "groovy";
        this.outputFolder = "generated-code/groovy";
        this.modelTemplateFiles.put("model.mustache", ".groovy");
        this.apiTemplateFiles.put("api.mustache", ".groovy");
        this.apiTestTemplateFiles.clear();
        this.templateDir = "Groovy";
        this.embeddedTemplateDir = "Groovy";
        this.modelDocTemplateFiles.remove("model_doc.mustache");
        this.apiDocTemplateFiles.remove("api_doc.mustache");
        this.apiPackage = "io.swagger.api";
        this.modelPackage = "io.swagger.model";
        this.configPackage = "io.swagger.configuration";
        this.invokerPackage = "io.swagger.api";
        this.artifactId = "swagger-groovy";
        this.dateLibrary = "legacy";
        this.additionalProperties.put("title", this.title);
        this.additionalProperties.put(CONFIG_PACKAGE, this.configPackage);
        this.cliOptions.add(new CliOption(CONFIG_PACKAGE, "configuration package for generated code"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "groovy";
    }

    @Override
    public String getHelp() {
        return "Generates a Groovy API client (beta).";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(CONFIG_PACKAGE)) {
            this.setConfigPackage((String)this.additionalProperties.get(CONFIG_PACKAGE));
        }
        this.supportingFiles.add(new SupportingFile("build.gradle.mustache", "", "build.gradle"));
        this.supportingFiles.add(new SupportingFile("ApiUtils.mustache", (this.sourceFolder + File.separator + this.apiPackage).replace(".", File.separator), "ApiUtils.groovy"));
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        name = this.sanitizeName(name);
        return GroovyClientCodegen.camelize(name) + "Api";
    }

    public void setConfigPackage(String configPackage) {
        this.configPackage = configPackage;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("'", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }
}

