/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class DartClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    public static final String BROWSER_CLIENT = "browserClient";
    public static final String PUB_NAME = "pubName";
    public static final String PUB_VERSION = "pubVersion";
    public static final String PUB_DESCRIPTION = "pubDescription";
    protected boolean browserClient = true;
    protected String pubName = "swagger";
    protected String pubVersion = "1.0.0";
    protected String pubDescription = "Swagger API client";
    protected String sourceFolder = "";

    public DartClientCodegen() {
        this.outputFolder = "generated-code/dart";
        this.modelTemplateFiles.put("model.mustache", ".dart");
        this.apiTemplateFiles.put("api.mustache", ".dart");
        this.templateDir = "dart";
        this.embeddedTemplateDir = "dart";
        this.apiPackage = "lib.api";
        this.modelPackage = "lib.model";
        this.setReservedWordsLowerCase(Arrays.asList("abstract", "as", "assert", "async", "async*", "await", "break", "case", "catch", "class", "const", "continue", "default", "deferred", "do", "dynamic", "else", "enum", "export", "external", "extends", "factory", "false", "final", "finally", "for", "get", "if", "implements", "import", "in", "is", "library", "new", "null", "operator", "part", "rethrow", "return", "set", "static", "super", "switch", "sync*", "this", "throw", "true", "try", "typedef", "var", "void", "while", "with", "yield", "yield*"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("String", "bool", "int", "double"));
        this.instantiationTypes.put("array", "List");
        this.instantiationTypes.put("map", "Map");
        this.typeMapping = new HashMap();
        this.typeMapping.put("Array", "List");
        this.typeMapping.put("array", "List");
        this.typeMapping.put("List", "List");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("int", "int");
        this.typeMapping.put("float", "double");
        this.typeMapping.put("long", "int");
        this.typeMapping.put("short", "int");
        this.typeMapping.put("char", "String");
        this.typeMapping.put("double", "double");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("Date", "DateTime");
        this.typeMapping.put("date", "DateTime");
        this.typeMapping.put("File", "MultipartFile");
        this.typeMapping.put("binary", "String");
        this.cliOptions.add(new CliOption(BROWSER_CLIENT, "Is the client browser based"));
        this.cliOptions.add(new CliOption(PUB_NAME, "Name in generated pubspec"));
        this.cliOptions.add(new CliOption(PUB_VERSION, "Version in generated pubspec"));
        this.cliOptions.add(new CliOption(PUB_DESCRIPTION, "Description in generated pubspec"));
        this.cliOptions.add(new CliOption("sourceFolder", "source folder for generated code"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "dart";
    }

    @Override
    public String getHelp() {
        return "Generates a Dart client library.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(BROWSER_CLIENT)) {
            this.setBrowserClient(Boolean.parseBoolean((String)this.additionalProperties.get(BROWSER_CLIENT)));
            this.additionalProperties.put(BROWSER_CLIENT, this.browserClient);
        } else {
            this.additionalProperties.put(BROWSER_CLIENT, this.browserClient);
        }
        if (this.additionalProperties.containsKey(PUB_NAME)) {
            this.setPubName((String)this.additionalProperties.get(PUB_NAME));
        } else {
            this.additionalProperties.put(PUB_NAME, this.pubName);
        }
        if (this.additionalProperties.containsKey(PUB_VERSION)) {
            this.setPubVersion((String)this.additionalProperties.get(PUB_VERSION));
        } else {
            this.additionalProperties.put(PUB_VERSION, this.pubVersion);
        }
        if (this.additionalProperties.containsKey(PUB_DESCRIPTION)) {
            this.setPubDescription((String)this.additionalProperties.get(PUB_DESCRIPTION));
        } else {
            this.additionalProperties.put(PUB_DESCRIPTION, this.pubDescription);
        }
        if (this.additionalProperties.containsKey("sourceFolder")) {
            this.setSourceFolder((String)this.additionalProperties.get("sourceFolder"));
        }
        String libFolder = this.sourceFolder + File.separator + "lib";
        this.supportingFiles.add(new SupportingFile("pubspec.mustache", "", "pubspec.yaml"));
        this.supportingFiles.add(new SupportingFile("api_client.mustache", libFolder, "api_client.dart"));
        this.supportingFiles.add(new SupportingFile("api_exception.mustache", libFolder, "api_exception.dart"));
        this.supportingFiles.add(new SupportingFile("api_helper.mustache", libFolder, "api_helper.dart"));
        this.supportingFiles.add(new SupportingFile("apilib.mustache", libFolder, "api.dart"));
        String authFolder = this.sourceFolder + File.separator + "lib" + File.separator + "auth";
        this.supportingFiles.add(new SupportingFile("auth/authentication.mustache", authFolder, "authentication.dart"));
        this.supportingFiles.add(new SupportingFile("auth/http_basic_auth.mustache", authFolder, "http_basic_auth.dart"));
        this.supportingFiles.add(new SupportingFile("auth/api_key_auth.mustache", authFolder, "api_key_auth.dart"));
        this.supportingFiles.add(new SupportingFile("auth/oauth.mustache", authFolder, "oauth.dart"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String toVarName(String name) {
        if ((name = name.replaceAll("-", "_")).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = DartClientCodegen.camelize(name, true)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        if (this.isReservedWord(name)) {
            throw new RuntimeException(name + " (reserved word) cannot be used as a model name");
        }
        return DartClientCodegen.camelize(name);
    }

    @Override
    public String toModelFilename(String name) {
        return DartClientCodegen.underscore(this.toModelName(name));
    }

    @Override
    public String toApiFilename(String name) {
        return DartClientCodegen.underscore(this.toApiName(name));
    }

    @Override
    public String toDefaultValue(Property p) {
        if (p instanceof MapProperty) {
            return "{}";
        }
        if (p instanceof ArrayProperty) {
            return "[]";
        }
        return super.toDefaultValue(p);
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getSwaggerType(p) + "<" + this.getTypeDeclaration(inner) + ">";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "<String, " + this.getTypeDeclaration(inner) + ">";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }

    @Override
    public String toOperationId(String operationId) {
        if (this.isReservedWord(operationId)) {
            throw new RuntimeException(operationId + " (reserved word) cannot be used as method name");
        }
        return DartClientCodegen.camelize(operationId, true);
    }

    public void setBrowserClient(boolean browserClient) {
        this.browserClient = browserClient;
    }

    public void setPubName(String pubName) {
        this.pubName = pubName;
    }

    public void setPubVersion(String pubVersion) {
        this.pubVersion = pubVersion;
    }

    public void setPubDescription(String pubDescription) {
        this.pubDescription = pubDescription;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }
}

