/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.swagger.codegen.AbstractGenerator;
import io.swagger.codegen.ClientOptInput;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenSecurity;
import io.swagger.codegen.Generator;
import io.swagger.codegen.GlobalSupportingFile;
import io.swagger.codegen.InlineModelResolver;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.ignore.CodegenIgnoreProcessor;
import io.swagger.models.ComposedModel;
import io.swagger.models.Contact;
import io.swagger.models.Info;
import io.swagger.models.License;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Scheme;
import io.swagger.models.SecurityRequirement;
import io.swagger.models.Swagger;
import io.swagger.models.auth.OAuth2Definition;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.swagger.models.parameters.Parameter;
import io.swagger.util.Json;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGenerator
extends AbstractGenerator
implements Generator {
    protected Logger LOGGER = LoggerFactory.getLogger(DefaultGenerator.class);
    protected CodegenConfig config;
    protected ClientOptInput opts;
    protected Swagger swagger;
    protected CodegenIgnoreProcessor ignoreProcessor;

    @Override
    public Generator opts(ClientOptInput opts) {
        this.opts = opts;
        this.swagger = opts.getSwagger();
        this.config = opts.getConfig();
        this.config.additionalProperties().putAll(opts.getOpts().getProperties());
        this.ignoreProcessor = new CodegenIgnoreProcessor(this.config.getOutputDir());
        return this;
    }

    @Override
    public List<File> generate() {
        File written;
        String filename;
        Boolean generateApis = null;
        Boolean generateModels = null;
        Boolean generateSupportingFiles = null;
        Boolean generateApiTests = null;
        Boolean generateApiDocumentation = null;
        Boolean generateModelTests = null;
        Boolean generateModelDocumentation = null;
        HashSet<String> modelsToGenerate = null;
        HashSet<String> apisToGenerate = null;
        HashSet<String> supportingFilesToGenerate = null;
        if (System.getProperty("models") != null) {
            String modelNames = System.getProperty("models");
            generateModels = true;
            if (!modelNames.isEmpty()) {
                modelsToGenerate = new HashSet<String>(Arrays.asList(modelNames.split(",")));
            }
        }
        if (System.getProperty("apis") != null) {
            String apiNames = System.getProperty("apis");
            generateApis = true;
            if (!apiNames.isEmpty()) {
                apisToGenerate = new HashSet<String>(Arrays.asList(apiNames.split(",")));
            }
        }
        if (System.getProperty("supportingFiles") != null) {
            String supportingFiles = System.getProperty("supportingFiles");
            generateSupportingFiles = true;
            if (!supportingFiles.isEmpty()) {
                supportingFilesToGenerate = new HashSet<String>(Arrays.asList(supportingFiles.split(",")));
            }
        }
        if (System.getProperty("modelTests") != null) {
            generateModelTests = Boolean.valueOf(System.getProperty("modelTests"));
        }
        if (System.getProperty("modelDocs") != null) {
            generateModelDocumentation = Boolean.valueOf(System.getProperty("modelDocs"));
        }
        if (System.getProperty("apiTests") != null) {
            generateApiTests = Boolean.valueOf(System.getProperty("apiTests"));
        }
        if (System.getProperty("apiDocs") != null) {
            generateApiDocumentation = Boolean.valueOf(System.getProperty("apiDocs"));
        }
        if (generateApis == null && generateModels == null && generateSupportingFiles == null) {
            generateApis = true;
            generateModels = true;
            generateSupportingFiles = true;
        } else {
            if (generateApis == null) {
                generateApis = false;
            }
            if (generateModels == null) {
                generateModels = false;
            }
            if (generateSupportingFiles == null) {
                generateSupportingFiles = false;
            }
        }
        if (generateModelTests == null) {
            generateModelTests = true;
        }
        if (generateModelDocumentation == null) {
            generateModelDocumentation = true;
        }
        if (generateApiTests == null) {
            generateApiTests = true;
        }
        if (generateApiDocumentation == null) {
            generateApiDocumentation = true;
        }
        this.config.additionalProperties().put("generateApiTests", generateApiTests);
        this.config.additionalProperties().put("generateModelTests", generateModelTests);
        if (Boolean.FALSE.equals(generateApiTests) && Boolean.FALSE.equals(generateModelTests)) {
            this.config.additionalProperties().put("excludeTests", Boolean.TRUE);
        }
        if (this.swagger == null || this.config == null) {
            throw new RuntimeException("missing swagger input or config!");
        }
        if (System.getProperty("debugSwagger") != null) {
            Json.prettyPrint((Object)this.swagger);
        }
        ArrayList<File> files = new ArrayList<File>();
        this.config.processOpts();
        this.config.preprocessSwagger(this.swagger);
        this.config.additionalProperties().put("generatedDate", DateTime.now().toString());
        this.config.additionalProperties().put("generatorClass", this.config.getClass().toString());
        if (this.swagger.getInfo() != null) {
            Info info = this.swagger.getInfo();
            if (info.getTitle() != null) {
                this.config.additionalProperties().put("appName", this.config.escapeText(info.getTitle()));
            }
            if (info.getVersion() != null) {
                this.config.additionalProperties().put("appVersion", this.config.escapeText(info.getVersion()));
            }
            if (info.getDescription() != null) {
                this.config.additionalProperties().put("appDescription", this.config.escapeText(info.getDescription()));
            }
            if (info.getContact() != null) {
                Contact contact = info.getContact();
                this.config.additionalProperties().put("infoUrl", this.config.escapeText(contact.getUrl()));
                if (contact.getEmail() != null) {
                    this.config.additionalProperties().put("infoEmail", this.config.escapeText(contact.getEmail()));
                }
            }
            if (info.getLicense() != null) {
                License license = info.getLicense();
                if (license.getName() != null) {
                    this.config.additionalProperties().put("licenseInfo", this.config.escapeText(license.getName()));
                }
                if (license.getUrl() != null) {
                    this.config.additionalProperties().put("licenseUrl", this.config.escapeText(license.getUrl()));
                }
            }
            if (info.getVersion() != null) {
                this.config.additionalProperties().put("version", this.config.escapeText(info.getVersion()));
            }
            if (info.getTermsOfService() != null) {
                this.config.additionalProperties().put("termsOfService", this.config.escapeText(info.getTermsOfService()));
            }
        }
        if (this.swagger.getVendorExtensions() != null) {
            this.config.vendorExtensions().putAll(this.swagger.getVendorExtensions());
        }
        StringBuilder hostBuilder = new StringBuilder();
        String scheme = this.swagger.getSchemes() != null && this.swagger.getSchemes().size() > 0 ? this.config.escapeText(((Scheme)this.swagger.getSchemes().get(0)).toValue()) : "https";
        scheme = this.config.escapeText(scheme);
        hostBuilder.append(scheme);
        hostBuilder.append("://");
        if (this.swagger.getHost() != null) {
            hostBuilder.append(this.swagger.getHost());
        } else {
            hostBuilder.append("localhost");
        }
        if (this.swagger.getBasePath() != null) {
            hostBuilder.append(this.swagger.getBasePath());
        }
        String contextPath = this.config.escapeText(this.swagger.getBasePath() == null ? "" : this.swagger.getBasePath());
        String basePath = this.config.escapeText(hostBuilder.toString());
        String basePathWithoutHost = this.config.escapeText(this.swagger.getBasePath());
        InlineModelResolver inlineModelResolver = new InlineModelResolver();
        inlineModelResolver.flatten(this.swagger);
        ArrayList<HashMap<String, Object>> allOperations = new ArrayList<HashMap<String, Object>>();
        ArrayList allModels = new ArrayList();
        final Map definitions = this.swagger.getDefinitions();
        if (definitions != null) {
            Set modelKeys = definitions.keySet();
            if (generateModels.booleanValue()) {
                if (modelsToGenerate != null && modelsToGenerate.size() > 0) {
                    HashSet updatedKeys = new HashSet();
                    for (String m : modelKeys) {
                        if (!modelsToGenerate.contains(m)) continue;
                        updatedKeys.add(m);
                    }
                    modelKeys = updatedKeys;
                }
                Map<String, Object> allProcessedModels = new TreeMap<String, Object>(new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        int model2InheritanceDepth;
                        Model model1 = (Model)definitions.get(o1);
                        Model model2 = (Model)definitions.get(o2);
                        int model1InheritanceDepth = this.getInheritanceDepth(model1);
                        if (model1InheritanceDepth == (model2InheritanceDepth = this.getInheritanceDepth(model2))) {
                            return ObjectUtils.compare((Comparable)((Object)DefaultGenerator.this.config.toModelName(o1)), (Comparable)((Object)DefaultGenerator.this.config.toModelName(o2)));
                        }
                        if (model1InheritanceDepth > model2InheritanceDepth) {
                            return 1;
                        }
                        return -1;
                    }

                    private int getInheritanceDepth(Model model) {
                        int inheritanceDepth = 0;
                        Model parent = this.getParent(model);
                        while (parent != null) {
                            ++inheritanceDepth;
                            parent = this.getParent(parent);
                        }
                        return inheritanceDepth;
                    }

                    private Model getParent(Model model) {
                        Model parent;
                        if (model instanceof ComposedModel && (parent = ((ComposedModel)model).getParent()) != null) {
                            return (Model)definitions.get(parent.getReference());
                        }
                        return null;
                    }
                });
                for (String name : modelKeys) {
                    try {
                        if (this.config.importMapping().containsKey(name)) continue;
                        Model model = (Model)definitions.get(name);
                        HashMap<String, Model> modelMap = new HashMap<String, Model>();
                        modelMap.put(name, model);
                        Map<String, Object> models = this.processModels(this.config, modelMap, definitions);
                        models.put("classname", this.config.toModelName(name));
                        models.putAll(this.config.additionalProperties());
                        allProcessedModels.put(name, models);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not process model '" + name + "'" + ".Please make sure that your schema is correct!", e);
                    }
                }
                allProcessedModels = this.config.postProcessAllModels(allProcessedModels);
                for (String name : allProcessedModels.keySet()) {
                    Map models = (Map)allProcessedModels.get(name);
                    try {
                        String suffix;
                        if (this.config.importMapping().containsKey(name)) continue;
                        allModels.add(((List)models.get("models")).get(0));
                        for (String templateName : this.config.modelTemplateFiles().keySet()) {
                            suffix = this.config.modelTemplateFiles().get(templateName);
                            filename = this.config.modelFileFolder() + File.separator + this.config.toModelFilename(name) + suffix;
                            if (!this.config.shouldOverwrite(filename)) {
                                this.LOGGER.info("Skipped overwriting " + filename);
                                continue;
                            }
                            written = this.processTemplateToFile(models, templateName, filename);
                            if (written == null) continue;
                            files.add(written);
                        }
                        if (generateModelTests.booleanValue()) {
                            for (String templateName : this.config.modelTestTemplateFiles().keySet()) {
                                suffix = this.config.modelTestTemplateFiles().get(templateName);
                                filename = this.config.modelTestFileFolder() + File.separator + this.config.toModelTestFilename(name) + suffix;
                                if (new File(filename).exists()) {
                                    this.LOGGER.info("File exists. Skipped overwriting " + filename);
                                    continue;
                                }
                                written = this.processTemplateToFile(models, templateName, filename);
                                if (written == null) continue;
                                files.add(written);
                            }
                        }
                        if (!generateModelDocumentation.booleanValue()) continue;
                        for (String templateName : this.config.modelDocTemplateFiles().keySet()) {
                            suffix = this.config.modelDocTemplateFiles().get(templateName);
                            filename = this.config.modelDocFileFolder() + File.separator + this.config.toModelDocFilename(name) + suffix;
                            if (!this.config.shouldOverwrite(filename)) {
                                this.LOGGER.info("Skipped overwriting " + filename);
                                continue;
                            }
                            written = this.processTemplateToFile(models, templateName, filename);
                            if (written == null) continue;
                            files.add(written);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not generate model '" + name + "'", e);
                    }
                }
            }
        }
        if (System.getProperty("debugModels") != null) {
            this.LOGGER.info("############ Model info ############");
            Json.prettyPrint(allModels);
        }
        Map<String, List<CodegenOperation>> paths = this.processPaths(this.swagger.getPaths());
        if (generateApis.booleanValue()) {
            if (apisToGenerate != null && apisToGenerate.size() > 0) {
                TreeMap<String, List<CodegenOperation>> updatedPaths = new TreeMap<String, List<CodegenOperation>>();
                for (String m : paths.keySet()) {
                    if (!apisToGenerate.contains(m)) continue;
                    updatedPaths.put(m, paths.get(m));
                }
                paths = updatedPaths;
            }
            for (String tag : paths.keySet()) {
                try {
                    List<CodegenOperation> ops = paths.get(tag);
                    Collections.sort(ops, new Comparator<CodegenOperation>(){

                        @Override
                        public int compare(CodegenOperation one, CodegenOperation another) {
                            return ObjectUtils.compare((Comparable)((Object)one.operationId), (Comparable)((Object)another.operationId));
                        }
                    });
                    Map<String, Object> operation = this.processOperations(this.config, tag, ops);
                    operation.put("basePath", basePath);
                    operation.put("basePathWithoutHost", basePathWithoutHost);
                    operation.put("contextPath", contextPath);
                    operation.put("baseName", tag);
                    operation.put("modelPackage", this.config.modelPackage());
                    operation.putAll(this.config.additionalProperties());
                    operation.put("classname", this.config.toApiName(tag));
                    operation.put("classVarName", this.config.toApiVarName(tag));
                    operation.put("importPath", this.config.toApiImport(tag));
                    if (!this.config.vendorExtensions().isEmpty()) {
                        operation.put("vendorExtensions", this.config.vendorExtensions());
                    }
                    boolean sortParamsByRequiredFlag = true;
                    if (this.config.additionalProperties().containsKey("sortParamsByRequiredFlag")) {
                        sortParamsByRequiredFlag = Boolean.valueOf(this.config.additionalProperties().get("sortParamsByRequiredFlag").toString());
                    }
                    operation.put("sortParamsByRequiredFlag", sortParamsByRequiredFlag);
                    DefaultGenerator.processMimeTypes(this.swagger.getConsumes(), operation, "consumes");
                    DefaultGenerator.processMimeTypes(this.swagger.getProduces(), operation, "produces");
                    allOperations.add(new HashMap<String, Object>(operation));
                    for (int i = 0; i < allOperations.size(); ++i) {
                        Map oo = (Map)allOperations.get(i);
                        if (i >= allOperations.size() - 1) continue;
                        oo.put("hasMore", "true");
                    }
                    for (String templateName : this.config.apiTemplateFiles().keySet()) {
                        filename = this.config.apiFilename(templateName, tag);
                        if (!this.config.shouldOverwrite(filename) && new File(filename).exists()) {
                            this.LOGGER.info("Skipped overwriting " + filename);
                            continue;
                        }
                        written = this.processTemplateToFile(operation, templateName, filename);
                        if (written == null) continue;
                        files.add(written);
                    }
                    if (generateApiTests.booleanValue()) {
                        for (String templateName : this.config.apiTestTemplateFiles().keySet()) {
                            filename = this.config.apiTestFilename(templateName, tag);
                            if (new File(filename).exists()) {
                                this.LOGGER.info("File exists. Skipped overwriting " + filename);
                                continue;
                            }
                            written = this.processTemplateToFile(operation, templateName, filename);
                            if (written == null) continue;
                            files.add(written);
                        }
                    }
                    if (!generateApiDocumentation.booleanValue()) continue;
                    for (String templateName : this.config.apiDocTemplateFiles().keySet()) {
                        filename = this.config.apiDocFilename(templateName, tag);
                        if (!this.config.shouldOverwrite(filename) && new File(filename).exists()) {
                            this.LOGGER.info("Skipped overwriting " + filename);
                            continue;
                        }
                        written = this.processTemplateToFile(operation, templateName, filename);
                        if (written == null) continue;
                        files.add(written);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not generate api file for '" + tag + "'", e);
                }
            }
        }
        if (System.getProperty("debugOperations") != null) {
            this.LOGGER.info("############ Operation info ############");
            Json.prettyPrint(allOperations);
        }
        HashMap<String, Object> bundle = new HashMap<String, Object>();
        bundle.putAll(this.config.additionalProperties());
        bundle.put("apiPackage", this.config.apiPackage());
        HashMap<String, ArrayList<HashMap<String, Object>>> apis = new HashMap<String, ArrayList<HashMap<String, Object>>>();
        apis.put("apis", allOperations);
        if (this.swagger.getHost() != null) {
            bundle.put("host", this.swagger.getHost());
        }
        bundle.put("swagger", this.swagger);
        bundle.put("basePath", basePath);
        bundle.put("basePathWithoutHost", basePathWithoutHost);
        bundle.put("scheme", scheme);
        bundle.put("contextPath", contextPath);
        bundle.put("apiInfo", apis);
        bundle.put("models", allModels);
        bundle.put("apiFolder", this.config.apiPackage().replace('.', File.separatorChar));
        bundle.put("modelPackage", this.config.modelPackage());
        List<CodegenSecurity> authMethods = this.config.fromSecurity(this.swagger.getSecurityDefinitions());
        if (authMethods != null && !authMethods.isEmpty()) {
            bundle.put("authMethods", authMethods);
            bundle.put("hasAuthMethods", true);
        }
        if (this.swagger.getExternalDocs() != null) {
            bundle.put("externalDocs", this.swagger.getExternalDocs());
        }
        for (int i = 0; i < allModels.size() - 1; ++i) {
            HashMap cm = (HashMap)allModels.get(i);
            CodegenModel m = (CodegenModel)cm.get("model");
            m.hasMoreModels = true;
        }
        this.config.postProcessSupportingFileData(bundle);
        if (System.getProperty("debugSupportingFiles") != null) {
            this.LOGGER.info("############ Supporting file info ############");
            Json.prettyPrint(bundle);
        }
        if (generateSupportingFiles.booleanValue()) {
            for (SupportingFile support : this.config.supportingFiles()) {
                try {
                    String outputFilename;
                    File of;
                    String outputFolder = this.config.outputFolder();
                    if (StringUtils.isNotEmpty((CharSequence)support.folder)) {
                        outputFolder = outputFolder + File.separator + support.folder;
                    }
                    if (!(of = new File(outputFolder)).isDirectory()) {
                        of.mkdirs();
                    }
                    if (!this.config.shouldOverwrite(outputFilename = outputFolder + File.separator + support.destinationFilename)) {
                        this.LOGGER.info("Skipped overwriting " + outputFilename);
                        continue;
                    }
                    String templateFile = support instanceof GlobalSupportingFile ? this.config.getCommonTemplateDir() + File.separator + support.templateFile : this.getFullTemplateFile(this.config, support.templateFile);
                    boolean shouldGenerate = true;
                    if (supportingFilesToGenerate != null && supportingFilesToGenerate.size() > 0) {
                        shouldGenerate = supportingFilesToGenerate.contains(support.destinationFilename);
                    }
                    if (!shouldGenerate) continue;
                    if (this.ignoreProcessor.allowsFile(new File(outputFilename))) {
                        if (templateFile.endsWith("mustache")) {
                            String template = this.readTemplate(templateFile);
                            Template tmpl = Mustache.compiler().withLoader(new Mustache.TemplateLoader(){

                                public Reader getTemplate(String name) {
                                    return DefaultGenerator.this.getTemplateReader(DefaultGenerator.this.getFullTemplateFile(DefaultGenerator.this.config, name + ".mustache"));
                                }
                            }).defaultValue("").compile(template);
                            this.writeToFile(outputFilename, tmpl.execute(bundle));
                            files.add(new File(outputFilename));
                            continue;
                        }
                        InputStream in = null;
                        try {
                            in = new FileInputStream(templateFile);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (in == null) {
                            in = this.getClass().getClassLoader().getResourceAsStream(this.getCPResourcePath(templateFile));
                        }
                        File outputFile = new File(outputFilename);
                        FileOutputStream out = new FileOutputStream(outputFile, false);
                        if (in != null) {
                            this.LOGGER.info("writing file " + outputFile);
                            IOUtils.copy((InputStream)in, (OutputStream)out);
                        } else if (in == null) {
                            this.LOGGER.error("can't open " + templateFile + " for input");
                        }
                        files.add(outputFile);
                        continue;
                    }
                    this.LOGGER.info("Skipped generation of " + outputFilename + " due to rule in .swagger-codegen-ignore");
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not generate supporting file '" + support + "'", e);
                }
            }
            String swaggerCodegenIgnore = ".swagger-codegen-ignore";
            String ignoreFileNameTarget = this.config.outputFolder() + File.separator + ".swagger-codegen-ignore";
            File ignoreFile = new File(ignoreFileNameTarget);
            if (!ignoreFile.exists()) {
                String ignoreFileNameSource = File.separator + this.config.getCommonTemplateDir() + File.separator + ".swagger-codegen-ignore";
                String ignoreFileContents = this.readResourceContents(ignoreFileNameSource);
                try {
                    this.writeToFile(ignoreFileNameTarget, ignoreFileContents);
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not generate supporting file '.swagger-codegen-ignore'", e);
                }
                files.add(ignoreFile);
            }
            String apache2License = "LICENSE";
            String licenseFileNameTarget = this.config.outputFolder() + File.separator + "LICENSE";
            File licenseFile = new File(licenseFileNameTarget);
            String licenseFileNameSource = File.separator + this.config.getCommonTemplateDir() + File.separator + "LICENSE";
            String licenseFileContents = this.readResourceContents(licenseFileNameSource);
            try {
                this.writeToFile(licenseFileNameTarget, licenseFileContents);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not generate LICENSE file 'LICENSE'", e);
            }
            files.add(licenseFile);
        }
        this.config.processSwagger(this.swagger);
        return files;
    }

    private File processTemplateToFile(Map<String, Object> templateData, String templateName, String outputFilename) throws IOException {
        if (this.ignoreProcessor.allowsFile(new File(outputFilename.replaceAll("//", "/")))) {
            String templateFile = this.getFullTemplateFile(this.config, templateName);
            String template = this.readTemplate(templateFile);
            Template tmpl = Mustache.compiler().withLoader(new Mustache.TemplateLoader(){

                public Reader getTemplate(String name) {
                    return DefaultGenerator.this.getTemplateReader(DefaultGenerator.this.getFullTemplateFile(DefaultGenerator.this.config, name + ".mustache"));
                }
            }).defaultValue("").compile(template);
            this.writeToFile(outputFilename, tmpl.execute(templateData));
            return new File(outputFilename);
        }
        this.LOGGER.info("Skipped generation of " + outputFilename + " due to rule in .swagger-codegen-ignore");
        return null;
    }

    private static void processMimeTypes(List<String> mimeTypeList, Map<String, Object> operation, String source) {
        if (mimeTypeList != null && mimeTypeList.size() > 0) {
            ArrayList c = new ArrayList();
            int count = 0;
            for (String key : mimeTypeList) {
                HashMap<String, String> mediaType = new HashMap<String, String>();
                mediaType.put("mediaType", key);
                if (++count < mimeTypeList.size()) {
                    mediaType.put("hasMore", "true");
                } else {
                    mediaType.put("hasMore", null);
                }
                c.add(mediaType);
            }
            operation.put(source, c);
            String flagFieldName = "has" + source.substring(0, 1).toUpperCase() + source.substring(1);
            operation.put(flagFieldName, true);
        }
    }

    public Map<String, List<CodegenOperation>> processPaths(Map<String, Path> paths) {
        TreeMap<String, List<CodegenOperation>> ops = new TreeMap<String, List<CodegenOperation>>();
        for (String resourcePath : paths.keySet()) {
            Path path = paths.get(resourcePath);
            this.processOperation(resourcePath, "get", path.getGet(), ops, path);
            this.processOperation(resourcePath, "head", path.getHead(), ops, path);
            this.processOperation(resourcePath, "put", path.getPut(), ops, path);
            this.processOperation(resourcePath, "post", path.getPost(), ops, path);
            this.processOperation(resourcePath, "delete", path.getDelete(), ops, path);
            this.processOperation(resourcePath, "patch", path.getPatch(), ops, path);
            this.processOperation(resourcePath, "options", path.getOptions(), ops, path);
        }
        return ops;
    }

    public SecuritySchemeDefinition fromSecurity(String name) {
        Map map = this.swagger.getSecurityDefinitions();
        if (map == null) {
            return null;
        }
        return (SecuritySchemeDefinition)map.get(name);
    }

    public void processOperation(String resourcePath, String httpMethod, Operation operation, Map<String, List<CodegenOperation>> operations, Path path) {
        if (operation != null) {
            ArrayList<String> tags;
            if (System.getProperty("debugOperations") != null) {
                this.LOGGER.info("processOperation: resourcePath= " + resourcePath + "\t;" + httpMethod + " " + operation + "\n");
            }
            if ((tags = operation.getTags()) == null) {
                tags = new ArrayList<String>();
                tags.add("default");
            }
            HashSet<String> operationParameters = new HashSet<String>();
            if (operation.getParameters() != null) {
                for (Parameter parameter : operation.getParameters()) {
                    operationParameters.add(DefaultGenerator.generateParameterId(parameter));
                }
            }
            if (path.getParameters() != null) {
                for (Parameter parameter : path.getParameters()) {
                    if (operationParameters.contains(DefaultGenerator.generateParameterId(parameter))) continue;
                    operation.addParameter(parameter);
                }
            }
            for (String tag : tags) {
                CodegenOperation co = null;
                try {
                    co = this.config.fromOperation(resourcePath, httpMethod, operation, this.swagger.getDefinitions(), this.swagger);
                    co.tags = new ArrayList<String>();
                    co.tags.add(this.config.sanitizeTag(tag));
                    this.config.addOperationToGroup(this.config.sanitizeTag(tag), resourcePath, operation, co, operations);
                    ArrayList<Map> securities = operation.getSecurity();
                    if (securities == null && this.swagger.getSecurity() != null) {
                        securities = new ArrayList<Map>();
                        for (SecurityRequirement sr : this.swagger.getSecurity()) {
                            securities.add(sr.getRequirements());
                        }
                    }
                    if (securities == null || securities.isEmpty()) continue;
                    HashMap<String, SecuritySchemeDefinition> authMethods = new HashMap<String, SecuritySchemeDefinition>();
                    for (Map security : securities) {
                        for (String securityName : security.keySet()) {
                            SecuritySchemeDefinition securityDefinition = this.fromSecurity(securityName);
                            if (securityDefinition == null) continue;
                            if (securityDefinition instanceof OAuth2Definition) {
                                OAuth2Definition oauth2Definition = (OAuth2Definition)securityDefinition;
                                OAuth2Definition oauth2Operation = new OAuth2Definition();
                                oauth2Operation.setType(oauth2Definition.getType());
                                oauth2Operation.setAuthorizationUrl(oauth2Definition.getAuthorizationUrl());
                                oauth2Operation.setFlow(oauth2Definition.getFlow());
                                oauth2Operation.setTokenUrl(oauth2Definition.getTokenUrl());
                                oauth2Operation.setScopes(new HashMap());
                                for (String scope : (List)security.get(securityName)) {
                                    if (!oauth2Definition.getScopes().containsKey(scope)) continue;
                                    oauth2Operation.addScope(scope, (String)oauth2Definition.getScopes().get(scope));
                                }
                                authMethods.put(securityName, (SecuritySchemeDefinition)oauth2Operation);
                                continue;
                            }
                            authMethods.put(securityName, securityDefinition);
                        }
                    }
                    if (authMethods.isEmpty()) continue;
                    co.authMethods = this.config.fromSecurity(authMethods);
                    co.hasAuthMethods = true;
                }
                catch (Exception ex) {
                    String msg = "Could not process operation:\n  Tag: " + tag + "\n" + "  Operation: " + operation.getOperationId() + "\n" + "  Resource: " + httpMethod + " " + resourcePath + "\n" + "  Definitions: " + this.swagger.getDefinitions() + "\n" + "  Exception: " + ex.getMessage();
                    throw new RuntimeException(msg, ex);
                }
            }
        }
    }

    private static String generateParameterId(Parameter parameter) {
        return parameter.getName() + ":" + parameter.getIn();
    }

    public Map<String, Object> processOperations(CodegenConfig config, String tag, List<CodegenOperation> ops) {
        List os;
        HashMap<String, Object> operations = new HashMap<String, Object>();
        HashMap<String, Object> objs = new HashMap<String, Object>();
        objs.put("classname", config.toApiName(tag));
        objs.put("pathPrefix", config.toApiVarName(tag));
        HashSet<String> opIds = new HashSet<String>();
        int counter = 0;
        for (CodegenOperation op : ops) {
            String opId = op.nickname;
            if (opIds.contains(opId)) {
                op.nickname = op.nickname + "_" + ++counter;
            }
            opIds.add(opId);
        }
        objs.put("operation", ops);
        operations.put("operations", objs);
        operations.put("package", config.apiPackage());
        LinkedHashSet<String> allImports = new LinkedHashSet<String>();
        for (CodegenOperation op : ops) {
            allImports.addAll(op.imports);
        }
        ArrayList imports = new ArrayList();
        for (String nextImport : allImports) {
            LinkedHashMap<String, String> im = new LinkedHashMap<String, String>();
            String mapping = config.importMapping().get(nextImport);
            if (mapping == null) {
                mapping = config.toModelImport(nextImport);
            }
            if (mapping == null) continue;
            im.put("import", mapping);
            imports.add(im);
        }
        operations.put("imports", imports);
        if (imports.size() > 0) {
            operations.put("hasImport", true);
        }
        config.postProcessOperations(operations);
        if (objs.size() > 0 && (os = (List)objs.get("operation")) != null && os.size() > 0) {
            CodegenOperation op = (CodegenOperation)os.get(os.size() - 1);
            op.hasMore = null;
        }
        return operations;
    }

    public Map<String, Object> processModels(CodegenConfig config, Map<String, Model> definitions, Map<String, Model> allDefinitions) {
        HashMap<String, Object> objs = new HashMap<String, Object>();
        objs.put("package", config.modelPackage());
        ArrayList models = new ArrayList();
        LinkedHashSet<String> allImports = new LinkedHashSet<String>();
        for (String key : definitions.keySet()) {
            Model mm = definitions.get(key);
            CodegenModel cm = config.fromModel(key, mm, allDefinitions);
            HashMap<String, Object> mo = new HashMap<String, Object>();
            mo.put("model", cm);
            mo.put("importPath", config.toModelImport(cm.classname));
            models.add(mo);
            allImports.addAll(cm.imports);
        }
        objs.put("models", models);
        TreeSet<String> importSet = new TreeSet<String>();
        for (String nextImport : allImports) {
            String mapping = config.importMapping().get(nextImport);
            if (mapping == null) {
                mapping = config.toModelImport(nextImport);
            }
            if (mapping != null && !config.defaultIncludes().contains(mapping)) {
                importSet.add(mapping);
            }
            if ((mapping = config.instantiationTypes().get(nextImport)) == null || config.defaultIncludes().contains(mapping)) continue;
            importSet.add(mapping);
        }
        ArrayList imports = new ArrayList();
        for (String s : importSet) {
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("import", s);
            imports.add(item);
        }
        objs.put("imports", imports);
        config.postProcessModels(objs);
        return objs;
    }
}

