/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Swagger;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class HaskellServantCodegen
extends DefaultCodegen
implements CodegenConfig {
    protected String sourceFolder = "src";
    protected String apiVersion = "0.0.1";

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "haskell-servant";
    }

    @Override
    public String getHelp() {
        return "Generates a HaskellServantCodegen library.";
    }

    public HaskellServantCodegen() {
        this.outputFolder = "generated-code/HaskellServantCodegen";
        this.modelTemplateFiles.put("model.mustache", ".hs");
        this.apiTemplateFiles.put("api.mustache", ".hs");
        this.templateDir = "haskell-servant";
        this.embeddedTemplateDir = "haskell-servant";
        this.apiPackage = "Api";
        this.modelPackage = "Model";
        this.setReservedWordsLowerCase(Arrays.asList("as", "case", "of", "class", "data", "default", "deriving", "do", "forall", "foreign", "hiding", "id", "if", "then", "else", "import", "infix", "infixl", "infixr", "instance", "let", "in", "mdo", "module", "newtype", "proc", "qualified", "rec", "type", "where"));
        this.additionalProperties.put("apiVersion", this.apiVersion);
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("stack.mustache", "", "stack.yaml"));
        this.supportingFiles.add(new SupportingFile("haskell-servant-codegen.mustache", "", "haskell-servant-codegen.cabal"));
        this.supportingFiles.add(new SupportingFile("Setup.mustache", "", "Setup.hs"));
        this.supportingFiles.add(new SupportingFile("LICENSE", "", "LICENSE"));
        this.supportingFiles.add(new SupportingFile("Apis.mustache", "lib", "Apis.hs"));
        this.supportingFiles.add(new SupportingFile("Utils.mustache", "lib", "Utils.hs"));
        this.supportingFiles.add(new SupportingFile("Client.mustache", "client", "Main.hs"));
        this.supportingFiles.add(new SupportingFile("Server.mustache", "server", "Main.hs"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("Bool", "String", "Int", "Integer", "Float", "Char", "Double", "List", "FilePath"));
        this.typeMapping.clear();
        this.typeMapping.put("array", "List");
        this.typeMapping.put("set", "Set");
        this.typeMapping.put("boolean", "Bool");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("int", "Int");
        this.typeMapping.put("long", "Integer");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("short", "Int");
        this.typeMapping.put("char", "Char");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("DateTime", "Integer");
        this.typeMapping.put("file", "FilePath");
        this.importMapping.clear();
        this.importMapping.put("Map", "qualified Data.Map as Map");
        this.cliOptions.add(new CliOption("modelPackage", "package for generated models"));
        this.cliOptions.add(new CliOption("apiPackage", "package for generated api classes"));
    }

    @Override
    public String escapeReservedWord(String name) {
        return name + "_";
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separatorChar + "lib" + File.separatorChar + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separatorChar + "lib" + File.separatorChar + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return "Map.Map String " + this.getTypeDeclaration(inner);
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }

    private String capturePath(String path, List<CodegenParameter> pathParams) {
        for (CodegenParameter p : pathParams) {
            String pName = "{" + p.baseName + "}";
            if (path.indexOf(pName) < 0) continue;
            path = path.replace(pName, "Capture \"" + p.baseName + "\" " + p.dataType);
        }
        return path;
    }

    private String queryPath(String path, List<CodegenParameter> queryParams) {
        for (CodegenParameter p : queryParams) {
            path = path + " :> QueryParam \"" + p.baseName + "\" " + p.dataType;
        }
        return path;
    }

    private String bodyPath(String path, List<CodegenParameter> bodyParams) {
        for (CodegenParameter p : bodyParams) {
            path = path + " :> ReqBody '[JSON] " + p.dataType;
        }
        return path;
    }

    private String formPath(String path, List<CodegenParameter> formParams) {
        String names = "Form";
        for (CodegenParameter p : formParams) {
            if (p.dataType.equals("FilePath")) {
                // empty if block
            }
            names = names + p.baseName;
        }
        if (formParams.size() > 0) {
            path = path + " :> ReqBody '[FormUrlEncoded] " + names;
        }
        return path;
    }

    private String headerPath(String path, List<CodegenParameter> headerParams) {
        for (CodegenParameter p : headerParams) {
            path = path + " :> Header \"" + p.baseName + "\" " + p.dataType;
        }
        return path;
    }

    private String filterReturnType(String rt) {
        if (rt == null || rt.equals("null")) {
            return "()";
        }
        if (rt.indexOf(" ") >= 0) {
            return "(" + rt + ")";
        }
        return rt;
    }

    private String addReturnPath(String path, String httpMethod, String returnType) {
        return path + " :> " + this.upperCaseFirst(httpMethod) + " '[JSON] " + this.filterReturnType(returnType);
    }

    private String joinStrings(String sep, List<String> ss) {
        StringBuilder sb = new StringBuilder();
        for (String s : ss) {
            if (sb.length() > 0) {
                sb.append(sep);
            }
            sb.append(s);
        }
        return sb.toString();
    }

    private String replacePathSplitter(String path) {
        String[] ps = path.replaceFirst("/", "").split("/", 0);
        ArrayList<String> rs = new ArrayList<String>();
        for (String p : ps) {
            if (p.indexOf("{") < 0) {
                rs.add("\"" + p + "\"");
                continue;
            }
            rs.add(p);
        }
        return this.joinStrings(" :> ", rs);
    }

    private String upperCaseFirst(String str) {
        char[] array = str.toLowerCase().toCharArray();
        array[0] = Character.toUpperCase(array[0]);
        return new String(array);
    }

    private String parseScheme(String basePath) {
        return "Http";
    }

    @Override
    public CodegenOperation fromOperation(String resourcePath, String httpMethod, Operation operation, Map<String, Model> definitions, Swagger swagger) {
        CodegenOperation op = super.fromOperation(resourcePath, httpMethod, operation, definitions, swagger);
        String path = op.path;
        op.nickname = this.addReturnPath(this.headerPath(this.formPath(this.bodyPath(this.queryPath(this.capturePath(this.replacePathSplitter(path), op.pathParams), op.queryParams), op.bodyParams), op.formParams), op.headerParams), op.httpMethod, op.returnType);
        return op;
    }
}

