/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class ObjcClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    public static final String CLASS_PREFIX = "classPrefix";
    public static final String POD_NAME = "podName";
    public static final String AUTHOR_NAME = "authorName";
    public static final String AUTHOR_EMAIL = "authorEmail";
    public static final String GIT_REPO_URL = "gitRepoURL";
    public static final String LICENSE = "license";
    protected Set<String> foundationClasses = new HashSet<String>();
    protected String podName = "SwaggerClient";
    protected String podVersion = "1.0.0";
    protected String classPrefix = "SWG";
    protected String authorName = "Swagger";
    protected String authorEmail = "apiteam@swagger.io";
    protected String license = "MIT";
    protected String gitRepoURL = "https://github.com/swagger-api/swagger-codegen";
    protected String[] specialWords = new String[]{"new", "copy"};

    public ObjcClientCodegen() {
        this.outputFolder = "generated-code" + File.separator + "objc";
        this.modelTemplateFiles.put("model-header.mustache", ".h");
        this.modelTemplateFiles.put("model-body.mustache", ".m");
        this.apiTemplateFiles.put("api-header.mustache", ".h");
        this.apiTemplateFiles.put("api-body.mustache", ".m");
        this.templateDir = "objc";
        this.embeddedTemplateDir = "objc";
        this.defaultIncludes.clear();
        this.defaultIncludes.add("bool");
        this.defaultIncludes.add("BOOL");
        this.defaultIncludes.add("int");
        this.defaultIncludes.add("NSURL");
        this.defaultIncludes.add("NSString");
        this.defaultIncludes.add("NSObject");
        this.defaultIncludes.add("NSArray");
        this.defaultIncludes.add("NSNumber");
        this.defaultIncludes.add("NSDate");
        this.defaultIncludes.add("NSDictionary");
        this.defaultIncludes.add("NSMutableArray");
        this.defaultIncludes.add("NSMutableDictionary");
        this.languageSpecificPrimitives.clear();
        this.languageSpecificPrimitives.add("NSNumber");
        this.languageSpecificPrimitives.add("NSString");
        this.languageSpecificPrimitives.add("NSObject");
        this.languageSpecificPrimitives.add("NSDate");
        this.languageSpecificPrimitives.add("NSURL");
        this.languageSpecificPrimitives.add("bool");
        this.languageSpecificPrimitives.add("BOOL");
        this.typeMapping.clear();
        this.typeMapping.put("enum", "NSString");
        this.typeMapping.put("date", "NSDate");
        this.typeMapping.put("DateTime", "NSDate");
        this.typeMapping.put("boolean", "NSNumber");
        this.typeMapping.put("string", "NSString");
        this.typeMapping.put("integer", "NSNumber");
        this.typeMapping.put("int", "NSNumber");
        this.typeMapping.put("float", "NSNumber");
        this.typeMapping.put("long", "NSNumber");
        this.typeMapping.put("double", "NSNumber");
        this.typeMapping.put("array", "NSArray");
        this.typeMapping.put("map", "NSDictionary");
        this.typeMapping.put("number", "NSNumber");
        this.typeMapping.put("List", "NSArray");
        this.typeMapping.put("object", "NSObject");
        this.typeMapping.put("file", "NSURL");
        this.reservedWords = new HashSet<String>(Arrays.asList("resourcePath", "pathParams", "queryParams", "headerParams", "responseContentType", "requestContentType", "authSettings", "formParams", "files", "bodyParam", "auto", "else", "long", "switch", "break", "enum", "register", "typedef", "case", "extern", "return", "union", "char", "float", "short", "unsigned", "const", "for", "signed", "void", "continue", "goto", "sizeof", "volatile", "default", "if", "id", "static", "while", "do", "int", "struct", "_Packed", "double", "protocol", "interface", "implementation", "NSObject", "NSInteger", "NSNumber", "CGFloat", "property", "nonatomic", "retain", "strong", "weak", "unsafe_unretained", "readwrite", "readonly", "description"));
        this.importMapping = new HashMap();
        this.foundationClasses = new HashSet<String>(Arrays.asList("NSNumber", "NSObject", "NSString", "NSDate", "NSURL", "NSDictionary"));
        this.instantiationTypes.put("array", "NSMutableArray");
        this.instantiationTypes.put("map", "NSMutableDictionary");
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption(CLASS_PREFIX, "prefix for generated classes (convention: Abbreviation of pod name e.g. `HN` for `HackerNews`).`").defaultValue("SWG"));
        this.cliOptions.add(new CliOption(POD_NAME, "cocoapods package name (convention: CameCase).").defaultValue("SwaggerClient"));
        this.cliOptions.add(new CliOption("podVersion", "cocoapods package version.").defaultValue("1.0.0"));
        this.cliOptions.add(new CliOption(AUTHOR_NAME, "Name to use in the podspec file.").defaultValue("Swagger"));
        this.cliOptions.add(new CliOption(AUTHOR_EMAIL, "Email to use in the podspec file.").defaultValue("apiteam@swagger.io"));
        this.cliOptions.add(new CliOption(GIT_REPO_URL, "URL for the git repo where this podspec should point to.").defaultValue("https://github.com/swagger-api/swagger-codegen"));
        this.cliOptions.add(new CliOption(LICENSE, "License to use in the podspec file.").defaultValue("MIT"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "objc";
    }

    @Override
    public String getHelp() {
        return "Generates an Objective-C client library.";
    }

    @Override
    public void processOpts() {
        String swaggerFolder;
        super.processOpts();
        if (this.additionalProperties.containsKey(POD_NAME)) {
            this.setPodName((String)this.additionalProperties.get(POD_NAME));
        }
        if (this.additionalProperties.containsKey("podVersion")) {
            this.setPodVersion((String)this.additionalProperties.get("podVersion"));
        }
        if (this.additionalProperties.containsKey(CLASS_PREFIX)) {
            this.setClassPrefix((String)this.additionalProperties.get(CLASS_PREFIX));
        }
        if (this.additionalProperties.containsKey(AUTHOR_NAME)) {
            this.setAuthorName((String)this.additionalProperties.get(AUTHOR_NAME));
        }
        if (this.additionalProperties.containsKey(AUTHOR_EMAIL)) {
            this.setAuthorEmail((String)this.additionalProperties.get(AUTHOR_EMAIL));
        }
        if (this.additionalProperties.containsKey(GIT_REPO_URL)) {
            this.setGitRepoURL((String)this.additionalProperties.get(GIT_REPO_URL));
        }
        if (this.additionalProperties.containsKey(LICENSE)) {
            this.setLicense((String)this.additionalProperties.get(LICENSE));
        }
        this.additionalProperties.put(POD_NAME, this.podName);
        this.additionalProperties.put("podVersion", this.podVersion);
        this.additionalProperties.put(CLASS_PREFIX, this.classPrefix);
        this.additionalProperties.put(AUTHOR_NAME, this.authorName);
        this.additionalProperties.put(AUTHOR_EMAIL, this.authorEmail);
        this.additionalProperties.put(GIT_REPO_URL, this.gitRepoURL);
        this.additionalProperties.put(LICENSE, this.license);
        this.modelPackage = swaggerFolder = this.podName;
        this.apiPackage = swaggerFolder;
        this.supportingFiles.add(new SupportingFile("Object-header.mustache", swaggerFolder, this.classPrefix + "Object.h"));
        this.supportingFiles.add(new SupportingFile("Object-body.mustache", swaggerFolder, this.classPrefix + "Object.m"));
        this.supportingFiles.add(new SupportingFile("QueryParamCollection-header.mustache", swaggerFolder, this.classPrefix + "QueryParamCollection.h"));
        this.supportingFiles.add(new SupportingFile("QueryParamCollection-body.mustache", swaggerFolder, this.classPrefix + "QueryParamCollection.m"));
        this.supportingFiles.add(new SupportingFile("ApiClient-header.mustache", swaggerFolder, this.classPrefix + "ApiClient.h"));
        this.supportingFiles.add(new SupportingFile("ApiClient-body.mustache", swaggerFolder, this.classPrefix + "ApiClient.m"));
        this.supportingFiles.add(new SupportingFile("JSONResponseSerializer-header.mustache", swaggerFolder, this.classPrefix + "JSONResponseSerializer.h"));
        this.supportingFiles.add(new SupportingFile("JSONResponseSerializer-body.mustache", swaggerFolder, this.classPrefix + "JSONResponseSerializer.m"));
        this.supportingFiles.add(new SupportingFile("JSONRequestSerializer-body.mustache", swaggerFolder, this.classPrefix + "JSONRequestSerializer.m"));
        this.supportingFiles.add(new SupportingFile("JSONRequestSerializer-header.mustache", swaggerFolder, this.classPrefix + "JSONRequestSerializer.h"));
        this.supportingFiles.add(new SupportingFile("JSONValueTransformer+ISO8601.m", swaggerFolder, "JSONValueTransformer+ISO8601.m"));
        this.supportingFiles.add(new SupportingFile("JSONValueTransformer+ISO8601.h", swaggerFolder, "JSONValueTransformer+ISO8601.h"));
        this.supportingFiles.add(new SupportingFile("Configuration-body.mustache", swaggerFolder, this.classPrefix + "Configuration.m"));
        this.supportingFiles.add(new SupportingFile("Configuration-header.mustache", swaggerFolder, this.classPrefix + "Configuration.h"));
        this.supportingFiles.add(new SupportingFile("podspec.mustache", "", this.podName + ".podspec"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
    }

    @Override
    public String toInstantiationType(Property p) {
        if (p instanceof MapProperty) {
            MapProperty ap = (MapProperty)p;
            String inner = this.getSwaggerType(ap.getAdditionalProperties());
            return (String)this.instantiationTypes.get("map");
        }
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            String inner = this.getSwaggerType(ap.getItems());
            return (String)this.instantiationTypes.get("array");
        }
        return null;
    }

    @Override
    public String getTypeDeclaration(String name) {
        if (this.languageSpecificPrimitives.contains(name) && !this.foundationClasses.contains(name)) {
            return name;
        }
        return name + "*";
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type) && !this.foundationClasses.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            String innerType = this.getSwaggerType(inner);
            String innerTypeDeclaration = this.getTypeDeclaration(inner);
            if (innerTypeDeclaration.endsWith("*")) {
                innerTypeDeclaration = innerTypeDeclaration.substring(0, innerTypeDeclaration.length() - 1);
            }
            if (this.languageSpecificPrimitives.contains(innerType)) {
                return this.getSwaggerType(p) + "*" + " /* " + innerTypeDeclaration + " */";
            }
            return this.getSwaggerType(p) + "<" + innerTypeDeclaration + ">*";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            String innerTypeDeclaration = this.getTypeDeclaration(inner);
            if (innerTypeDeclaration.endsWith("*")) {
                innerTypeDeclaration = innerTypeDeclaration.substring(0, innerTypeDeclaration.length() - 1);
            }
            return this.getSwaggerType(p) + "* /* NSString, " + innerTypeDeclaration + " */";
        }
        String swaggerType = this.getSwaggerType(p);
        if (this.languageSpecificPrimitives.contains(swaggerType) && this.foundationClasses.contains(swaggerType)) {
            return swaggerType + "*";
        }
        if (this.languageSpecificPrimitives.contains(swaggerType)) {
            return swaggerType;
        }
        return swaggerType + "*";
    }

    @Override
    public String toModelName(String type) {
        type = type.replaceAll("[^0-9a-zA-Z_]", "_");
        if (this.typeMapping.keySet().contains(type) || this.foundationClasses.contains(type) || this.importMapping.values().contains(type) || this.defaultIncludes.contains(type) || this.languageSpecificPrimitives.contains(type)) {
            return ObjcClientCodegen.camelize(type);
        }
        return this.classPrefix + ObjcClientCodegen.camelize(type);
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    protected void setNonArrayMapProperty(CodegenProperty property, String type) {
        super.setNonArrayMapProperty(property, type);
        property.setter = "NSDictionary".equals(type) ? "initWithDictionary" : "initWithValues";
    }

    @Override
    public String toModelImport(String name) {
        return name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separatorChar + this.apiPackage();
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separatorChar + this.modelPackage();
    }

    @Override
    public String toApiName(String name) {
        return this.classPrefix + ObjcClientCodegen.camelize(name) + "Api";
    }

    @Override
    public String toApiFilename(String name) {
        return this.classPrefix + ObjcClientCodegen.camelize(name) + "Api";
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeName(name)).matches("^[A-Z_]$")) {
            return name;
        }
        for (int i = 0; i < this.specialWords.length; ++i) {
            if (!name.matches("(?i:^" + this.specialWords[i] + ".*)")) continue;
            name = this.escapeSpecialWord(name);
        }
        if (this.reservedWords.contains(name = ObjcClientCodegen.camelize(name, true)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    public String escapeSpecialWord(String name) {
        return "var_" + name;
    }

    @Override
    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((String)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.reservedWords.contains(operationId)) {
            throw new RuntimeException(operationId + " (reserved word) cannot be used as method name");
        }
        return ObjcClientCodegen.camelize(this.sanitizeName(operationId), true);
    }

    public void setClassPrefix(String classPrefix) {
        this.classPrefix = classPrefix;
    }

    public void setPodName(String podName) {
        this.podName = podName;
    }

    public void setPodVersion(String podVersion) {
        this.podVersion = podVersion;
    }

    public void setAuthorEmail(String authorEmail) {
        this.authorEmail = authorEmail;
    }

    public void setAuthorName(String authorName) {
        this.authorName = authorName;
    }

    public void setGitRepoURL(String gitRepoURL) {
        this.gitRepoURL = gitRepoURL;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    @Override
    public String toDefaultValue(Property p) {
        if (p instanceof StringProperty) {
            StringProperty dp = (StringProperty)p;
            if (dp.getDefault() != null) {
                return "@\"" + dp.getDefault().toString() + "\"";
            }
        } else if (p instanceof BooleanProperty) {
            BooleanProperty dp = (BooleanProperty)p;
            if (dp.getDefault() != null) {
                if (dp.getDefault().toString().equalsIgnoreCase("false")) {
                    return "@0";
                }
                return "@1";
            }
        } else if (!(p instanceof DateProperty) && !(p instanceof DateTimeProperty)) {
            LongProperty dp;
            if (p instanceof DoubleProperty) {
                DoubleProperty dp2 = (DoubleProperty)p;
                if (dp2.getDefault() != null) {
                    return "@" + dp2.getDefault().toString();
                }
            } else if (p instanceof FloatProperty) {
                FloatProperty dp3 = (FloatProperty)p;
                if (dp3.getDefault() != null) {
                    return "@" + dp3.getDefault().toString();
                }
            } else if (p instanceof IntegerProperty) {
                IntegerProperty dp4 = (IntegerProperty)p;
                if (dp4.getDefault() != null) {
                    return "@" + dp4.getDefault().toString();
                }
            } else if (p instanceof LongProperty && (dp = (LongProperty)p).getDefault() != null) {
                return "@" + dp.getDefault().toString();
            }
        }
        return null;
    }
}

