/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class TizenClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    protected static String PREFIX = "Sami";
    protected Set<String> foundationClasses = new HashSet<String>();
    protected String sourceFolder = "client";
    protected Map<String, String> namespaces = new HashMap<String, String>();

    public TizenClientCodegen() {
        this.outputFolder = "generated-code/tizen";
        this.modelTemplateFiles.put("model-header.mustache", ".h");
        this.modelTemplateFiles.put("model-body.mustache", ".cpp");
        this.apiTemplateFiles.put("api-header.mustache", ".h");
        this.apiTemplateFiles.put("api-body.mustache", ".cpp");
        this.templateDir = "tizen";
        this.modelPackage = "";
        this.defaultIncludes = new HashSet<String>(Arrays.asList("bool", "int", "long"));
        this.languageSpecificPrimitives = new HashSet();
        this.additionalProperties().put("prefix", PREFIX);
        this.reservedWords = new HashSet<String>(Arrays.asList("void", "char", "short", "int", "void", "char", "short", "int", "long", "float", "double", "signed", "unsigned", "id", "const", "volatile", "in", "out", "inout", "bycopy", "byref", "oneway", "self", "super"));
        this.typeMapping = new HashMap<String, String>();
        this.typeMapping.put("Date", "DateTime");
        this.typeMapping.put("DateTime", "DateTime");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("integer", "Integer");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("long", "Long");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("array", "IList");
        this.typeMapping.put("map", "HashMap");
        this.typeMapping.put("number", "Long");
        this.typeMapping.put("object", PREFIX + "Object");
        this.importMapping = new HashMap();
        this.namespaces = new HashMap<String, String>();
        this.namespaces.put("DateTime", "Tizen::Base::DateTime");
        this.namespaces.put("Integer", "Tizen::Base::Integer");
        this.namespaces.put("Long", "Tizen::Base::Long");
        this.namespaces.put("Boolean", "Tizen::Base::Boolean");
        this.namespaces.put("Float", "Tizen::Base::Float");
        this.namespaces.put("String", "Tizen::Base::String");
        this.namespaces.put("Double", "Tizen::Base::Double");
        this.namespaces.put("IList", "Tizen::Base::Collection::IList");
        this.namespaces.put("HashMap", "Tizen::Base::Collection::HashMap");
        this.namespaces.put("ArrayList", "Tizen::Base::Collection::ArrayList");
        this.namespaces.put("JsonNumber", "Tizen::Web::Json");
        this.namespaces.put("JsonString", "Tizen::Web::Json");
        this.foundationClasses = new HashSet<String>(Arrays.asList("String", "Integer", "Float"));
        this.supportingFiles.clear();
        this.supportingFiles.add(new SupportingFile("modelFactory.mustache", this.sourceFolder, PREFIX + "ModelFactory.h"));
        this.supportingFiles.add(new SupportingFile("helpers-header.mustache", this.sourceFolder, PREFIX + "Helpers.h"));
        this.supportingFiles.add(new SupportingFile("helpers-body.mustache", this.sourceFolder, PREFIX + "Helpers.cpp"));
        this.supportingFiles.add(new SupportingFile("apiclient-header.mustache", this.sourceFolder, PREFIX + "ApiClient.h"));
        this.supportingFiles.add(new SupportingFile("apiclient-body.mustache", this.sourceFolder, PREFIX + "ApiClient.cpp"));
        this.supportingFiles.add(new SupportingFile("object.mustache", this.sourceFolder, PREFIX + "Object.h"));
        this.supportingFiles.add(new SupportingFile("error-header.mustache", this.sourceFolder, PREFIX + "Error.h"));
        this.supportingFiles.add(new SupportingFile("error-body.mustache", this.sourceFolder, PREFIX + "Error.cpp"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "tizen";
    }

    @Override
    public String getHelp() {
        return "Generates a Samsung Tizen C++ client library.";
    }

    @Override
    public String toInstantiationType(Property p) {
        if (p instanceof MapProperty) {
            MapProperty ap = (MapProperty)p;
            String inner = this.getSwaggerType(ap.getAdditionalProperties());
            return (String)this.instantiationTypes.get("map");
        }
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            String inner = this.getSwaggerType(ap.getItems());
            return (String)this.instantiationTypes.get("array");
        }
        return null;
    }

    @Override
    public String getTypeDeclaration(String name) {
        if (this.languageSpecificPrimitives.contains(name) && !this.foundationClasses.contains(name)) {
            return name;
        }
        return name + "*";
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type) && !this.foundationClasses.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }

    @Override
    public String getTypeDeclaration(Property p) {
        String swaggerType = this.getSwaggerType(p);
        if (this.languageSpecificPrimitives.contains(swaggerType) && !this.foundationClasses.contains(swaggerType)) {
            return this.toModelName(swaggerType);
        }
        return swaggerType + "*";
    }

    @Override
    public String toModelName(String type) {
        if (this.typeMapping.keySet().contains(type) || this.typeMapping.values().contains(type) || this.foundationClasses.contains(type) || this.importMapping.values().contains(type) || this.defaultIncludes.contains(type) || this.languageSpecificPrimitives.contains(type)) {
            return type;
        }
        return PREFIX + Character.toUpperCase(type.charAt(0)) + type.substring(1);
    }

    @Override
    public String toModelImport(String name) {
        if (this.namespaces.containsKey(name)) {
            return "using " + this.namespaces.get(name) + ";";
        }
        return "#include \"" + name + ".h\"";
    }

    @Override
    public String toDefaultValue(Property p) {
        if (p instanceof StringProperty) {
            return "new String()";
        }
        if (p instanceof BooleanProperty) {
            return "new Boolean(false)";
        }
        if (p instanceof DateProperty) {
            return "new DateTime()";
        }
        if (p instanceof DateTimeProperty) {
            return "new DateTime()";
        }
        if (p instanceof DoubleProperty) {
            return "new Double()";
        }
        if (p instanceof FloatProperty) {
            return "new Float()";
        }
        if (p instanceof IntegerProperty) {
            return "new Integer()";
        }
        if (p instanceof LongProperty) {
            return "new Long()";
        }
        if (p instanceof DecimalProperty) {
            return "new Long()";
        }
        if (p instanceof MapProperty) {
            MapProperty ap = (MapProperty)p;
            String inner = this.getSwaggerType(ap.getAdditionalProperties());
            return "new HashMap()";
        }
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            String inner = this.getSwaggerType(ap.getItems());
            return "new ArrayList()";
        }
        if (p instanceof RefProperty) {
            RefProperty rp = (RefProperty)p;
            return "new " + this.toModelName(rp.getSimpleRef()) + "()";
        }
        return "null";
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder;
    }

    @Override
    public String toModelFilename(String name) {
        return PREFIX + this.initialCaps(name);
    }

    @Override
    public String toApiName(String name) {
        return PREFIX + this.initialCaps(name) + "Api";
    }

    @Override
    public String toApiFilename(String name) {
        return PREFIX + this.initialCaps(name) + "Api";
    }

    @Override
    public String toVarName(String name) {
        String paramName = name.replaceAll("[^a-zA-Z0-9_]", "");
        paramName = Character.toUpperCase(paramName.charAt(0)) + paramName.substring(1);
        return "p" + paramName;
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((String)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.reservedWords.contains(operationId)) {
            throw new RuntimeException(operationId + " (reserved word) cannot be used as method name");
        }
        return TizenClientCodegen.camelize(operationId, true);
    }
}

