/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;

public class SwiftCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Pattern PATH_PARAM_PATTERN = Pattern.compile("\\{[a-zA-Z_]+\\}");
    protected static final String LIBRARY_PROMISE_KIT = "PromiseKit";
    protected static final String[] RESPONSE_LIBRARIES = new String[]{"PromiseKit"};
    protected String projectName = "SwaggerClient";
    protected boolean unwrapRequired = false;
    protected String[] responseAs = new String[0];
    protected String sourceFolder = "Classes" + File.separator + "Swaggers";

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "swift";
    }

    @Override
    public String getHelp() {
        return "Generates a swift client library.";
    }

    public SwiftCodegen() {
        this.outputFolder = "generated-code" + File.separator + "swift";
        this.modelTemplateFiles.put("model.mustache", ".swift");
        this.apiTemplateFiles.put("api.mustache", ".swift");
        this.templateDir = "swift";
        this.apiPackage = File.separator + "APIs";
        this.modelPackage = File.separator + "Models";
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("Int", "Float", "Double", "Bool", "Void", "String", "Character"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("NSDate", "Array", "Dictionary", "Set", "Any", "Empty", "AnyObject"));
        this.reservedWords = new HashSet<String>(Arrays.asList("class", "break", "as", "associativity", "deinit", "case", "dynamicType", "convenience", "enum", "continue", "false", "dynamic", "extension", "default", "is", "didSet", "func", "do", "nil", "final", "import", "else", "self", "get", "init", "fallthrough", "Self", "infix", "internal", "for", "super", "inout", "let", "if", "true", "lazy", "operator", "in", "COLUMN", "left", "private", "return", "FILE", "mutating", "protocol", "switch", "FUNCTION", "none", "public", "where", "LINE", "nonmutating", "static", "while", "optional", "struct", "override", "subscript", "postfix", "typealias", "precedence", "var", "prefix", "Protocol", "required", "right", "set", "Type", "unowned", "weak"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("array", "Array");
        this.typeMapping.put("List", "Array");
        this.typeMapping.put("map", "Dictionary");
        this.typeMapping.put("date", "NSDate");
        this.typeMapping.put("Date", "NSDate");
        this.typeMapping.put("DateTime", "NSDate");
        this.typeMapping.put("boolean", "Bool");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("char", "Character");
        this.typeMapping.put("short", "Int");
        this.typeMapping.put("int", "Int");
        this.typeMapping.put("long", "Int");
        this.typeMapping.put("integer", "Int");
        this.typeMapping.put("Integer", "Int");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("number", "Double");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("object", "String");
        this.typeMapping.put("file", "NSURL");
        this.importMapping = new HashMap();
        this.cliOptions.add(new CliOption("projectName", "Project name in Xcode"));
        this.cliOptions.add(new CliOption("responseAs", "Optionally use libraries to manage response.  Currently " + StringUtils.join((Object[])RESPONSE_LIBRARIES, (String)", ") + " are available."));
        this.cliOptions.add(new CliOption("unwrapRequired", "Treat 'required' properties in response as non-optional (which would crash the app if api returns null as opposed to required option specified in json schema"));
        this.cliOptions.add(new CliOption("podSource", "Source information used for Podspec"));
        this.cliOptions.add(new CliOption("podVersion", "Version used for Podspec"));
        this.cliOptions.add(new CliOption("podAuthors", "Authors used for Podspec"));
        this.cliOptions.add(new CliOption("podSocialMediaURL", "Social Media URL used for Podspec"));
        this.cliOptions.add(new CliOption("podDocsetURL", "Docset URL used for Podspec"));
        this.cliOptions.add(new CliOption("podLicense", "License used for Podspec"));
        this.cliOptions.add(new CliOption("podHomepage", "Homepage used for Podspec"));
        this.cliOptions.add(new CliOption("podSummary", "Summary used for Podspec"));
        this.cliOptions.add(new CliOption("podDescription", "Description used for Podspec"));
        this.cliOptions.add(new CliOption("podScreenshots", "Screenshots used for Podspec"));
        this.cliOptions.add(new CliOption("podDocumentationURL", "Documentation URL used for Podspec"));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("projectName")) {
            this.projectName = (String)this.additionalProperties.get("projectName");
        } else {
            this.additionalProperties.put("projectName", this.projectName);
        }
        this.sourceFolder = this.projectName + File.separator + this.sourceFolder;
        if (this.additionalProperties.containsKey("unwrapRequired")) {
            this.unwrapRequired = Boolean.parseBoolean(String.valueOf(this.additionalProperties.get("unwrapRequired")));
        }
        this.additionalProperties.put("unwrapRequired", this.unwrapRequired);
        if (this.additionalProperties.containsKey("responseAs")) {
            Object responseAsObject = this.additionalProperties.get("responseAs");
            this.responseAs = responseAsObject instanceof String ? ((String)responseAsObject).split(",") : (String[])responseAsObject;
        }
        this.additionalProperties.put("responseAs", this.responseAs);
        if (ArrayUtils.contains((Object[])this.responseAs, (Object)LIBRARY_PROMISE_KIT)) {
            this.additionalProperties.put("usePromiseKit", true);
        }
        this.supportingFiles.add(new SupportingFile("Podspec.mustache", "", this.projectName + ".podspec"));
        this.supportingFiles.add(new SupportingFile("Cartfile.mustache", "", "Cartfile"));
        this.supportingFiles.add(new SupportingFile("APIHelper.mustache", this.sourceFolder, "APIHelper.swift"));
        this.supportingFiles.add(new SupportingFile("AlamofireImplementations.mustache", this.sourceFolder, "AlamofireImplementations.swift"));
        this.supportingFiles.add(new SupportingFile("Extensions.mustache", this.sourceFolder, "Extensions.swift"));
        this.supportingFiles.add(new SupportingFile("Models.mustache", this.sourceFolder, "Models.swift"));
        this.supportingFiles.add(new SupportingFile("APIs.mustache", this.sourceFolder, "APIs.swift"));
    }

    @Override
    public String escapeReservedWord(String name) {
        return "Swagger" + name;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return "[String:" + this.getTypeDeclaration(inner) + "]";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }

    @Override
    public String toDefaultValue(Property p) {
        return null;
    }

    @Override
    public String toInstantiationType(Property p) {
        if (p instanceof MapProperty) {
            MapProperty ap = (MapProperty)p;
            String inner = this.getSwaggerType(ap.getAdditionalProperties());
            return "[String:" + inner + "]";
        }
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            String inner = this.getSwaggerType(ap.getItems());
            return "[" + inner + "]";
        }
        return null;
    }

    @Override
    public CodegenProperty fromProperty(String name, Property p) {
        CodegenProperty codegenProperty = super.fromProperty(name, p);
        if (codegenProperty.isEnum) {
            ArrayList swiftEnums = new ArrayList();
            List values = (List)codegenProperty.allowableValues.get("values");
            for (String value : values) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("enum", this.toSwiftyEnumName(value));
                map.put("raw", value);
                swiftEnums.add(map);
            }
            codegenProperty.allowableValues.put("values", swiftEnums);
            codegenProperty.datatypeWithEnum = StringUtils.left((String)codegenProperty.datatypeWithEnum, (int)(codegenProperty.datatypeWithEnum.length() - "Enum".length()));
            if (this.reservedWords.contains(codegenProperty.datatypeWithEnum)) {
                codegenProperty.datatypeWithEnum = this.escapeReservedWord(codegenProperty.datatypeWithEnum);
            }
        }
        return codegenProperty;
    }

    public String toSwiftyEnumName(String value) {
        if (value.matches("[A-Z][a-z0-9]+[a-zA-Z0-9]*")) {
            return value;
        }
        char[] separators = new char[]{'-', '_', ' '};
        return WordUtils.capitalizeFully((String)StringUtils.lowerCase((String)value), (char[])separators).replaceAll("[-_ ]", "");
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultAPI";
        }
        return this.initialCaps(name) + "API";
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, Map<String, Model> definitions, Swagger swagger) {
        path = SwiftCodegen.normalizePath(path);
        List parameters = operation.getParameters();
        parameters = Lists.newArrayList((Iterator)Iterators.filter(parameters.iterator(), (Predicate)new Predicate<Parameter>(){

            public boolean apply(@Nullable Parameter parameter) {
                return !(parameter instanceof HeaderParameter);
            }
        }));
        operation.setParameters(parameters);
        return super.fromOperation(path, httpMethod, operation, definitions, swagger);
    }

    private static String normalizePath(String path) {
        StringBuilder builder = new StringBuilder();
        int cursor = 0;
        Matcher matcher = PATH_PARAM_PATTERN.matcher(path);
        boolean found = matcher.find();
        while (found) {
            String stringBeforeMatch = path.substring(cursor, matcher.start());
            builder.append(stringBeforeMatch);
            String group = matcher.group().substring(1, matcher.group().length() - 1);
            group = SwiftCodegen.camelize(group, true);
            builder.append("{").append(group).append("}");
            cursor = matcher.end();
            found = matcher.find();
        }
        String stringAfterMatch = path.substring(cursor);
        builder.append(stringAfterMatch);
        return builder.toString();
    }
}

