/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class AsyncScalaClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    protected String invokerPackage = "io.swagger.client";
    protected String groupId = "io.swagger";
    protected String artifactId = "swagger-async-scala-client";
    protected String artifactVersion = "1.0.0";
    protected String sourceFolder = "src/main/scala";
    protected String clientName = "SwaggerClient";
    protected String authScheme = "";
    protected boolean authPreemptive = false;
    protected boolean asyncHttpClient = !this.authScheme.isEmpty();

    public AsyncScalaClientCodegen() {
        this.outputFolder = "generated-code/async-scala";
        this.modelTemplateFiles.put("model.mustache", ".scala");
        this.apiTemplateFiles.put("api.mustache", ".scala");
        this.templateDir = "asyncscala";
        this.apiPackage = "io.swagger.client.api";
        this.modelPackage = "io.swagger.client.model";
        this.reservedWords = new HashSet<String>(Arrays.asList("abstract", "case", "catch", "class", "def", "do", "else", "extends", "false", "final", "finally", "for", "forSome", "if", "implicit", "import", "lazy", "match", "new", "null", "object", "override", "package", "private", "protected", "return", "sealed", "super", "this", "throw", "trait", "try", "true", "type", "val", "var", "while", "with", "yield"));
        this.additionalProperties.put("invokerPackage", this.invokerPackage);
        this.additionalProperties.put("groupId", this.groupId);
        this.additionalProperties.put("artifactId", this.artifactId);
        this.additionalProperties.put("artifactVersion", this.artifactVersion);
        this.additionalProperties.put("asyncHttpClient", this.asyncHttpClient);
        this.additionalProperties.put("authScheme", this.authScheme);
        this.additionalProperties.put("authPreemptive", this.authPreemptive);
        this.additionalProperties.put("clientName", this.clientName);
        this.supportingFiles.add(new SupportingFile("sbt.mustache", "", "build.sbt"));
        this.supportingFiles.add(new SupportingFile("client.mustache", (this.sourceFolder + File.separator + this.invokerPackage).replace(".", File.separator), this.clientName + ".scala"));
        this.importMapping.remove("List");
        this.importMapping.remove("Set");
        this.importMapping.remove("Map");
        this.importMapping.put("DateTime", "org.joda.time.DateTime");
        this.importMapping.put("ListBuffer", "scala.collections.mutable.ListBuffer");
        this.typeMapping = new HashMap();
        this.typeMapping.put("enum", "NSString");
        this.typeMapping.put("array", "List");
        this.typeMapping.put("set", "Set");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("int", "Int");
        this.typeMapping.put("long", "Long");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("byte", "Byte");
        this.typeMapping.put("short", "Short");
        this.typeMapping.put("char", "Char");
        this.typeMapping.put("long", "Long");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("object", "Any");
        this.typeMapping.put("file", "File");
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("String", "boolean", "Boolean", "Double", "Int", "Long", "Float", "Object", "List", "Map"));
        this.instantiationTypes.put("array", "ListBuffer");
        this.instantiationTypes.put("map", "HashMap");
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "async-scala";
    }

    @Override
    public String getHelp() {
        return "Generates an Asynchronous Scala client library.";
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getSwaggerType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "[String, " + this.getTypeDeclaration(inner) + "]";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }

    @Override
    public String toInstantiationType(Property p) {
        if (p instanceof MapProperty) {
            MapProperty ap = (MapProperty)p;
            String inner = this.getSwaggerType(ap.getAdditionalProperties());
            return (String)this.instantiationTypes.get("map") + "[String, " + inner + "]";
        }
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            String inner = this.getSwaggerType(ap.getItems());
            return (String)this.instantiationTypes.get("array") + "[" + inner + "]";
        }
        return null;
    }

    @Override
    public String toDefaultValue(Property p) {
        if (p instanceof StringProperty) {
            return "null";
        }
        if (p instanceof BooleanProperty) {
            return "null";
        }
        if (p instanceof DateProperty) {
            return "null";
        }
        if (p instanceof DateTimeProperty) {
            return "null";
        }
        if (p instanceof DoubleProperty) {
            return "null";
        }
        if (p instanceof FloatProperty) {
            return "null";
        }
        if (p instanceof IntegerProperty) {
            return "null";
        }
        if (p instanceof LongProperty) {
            return "null";
        }
        if (p instanceof MapProperty) {
            MapProperty ap = (MapProperty)p;
            String inner = this.getSwaggerType(ap.getAdditionalProperties());
            return "new HashMap[String, " + inner + "]() ";
        }
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            String inner = this.getSwaggerType(ap.getItems());
            return "new ListBuffer[" + inner + "]() ";
        }
        return "null";
    }
}

