/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.RefUtils;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.links.Link;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ByteArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.Discriminator;
import io.swagger.v3.oas.models.media.Encoding;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.XML;
import io.swagger.v3.oas.models.parameters.CookieParameter;
import io.swagger.v3.oas.models.parameters.HeaderParameter;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.PathParameter;
import io.swagger.v3.oas.models.parameters.QueryParameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.OAuthFlows;
import io.swagger.v3.oas.models.security.Scopes;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.servers.ServerVariable;
import io.swagger.v3.oas.models.servers.ServerVariables;
import io.swagger.v3.oas.models.tags.Tag;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import io.swagger.v3.parser.util.ReferenceValidator;
import io.swagger.v3.parser.util.SchemaTypeUtil;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class OpenAPIDeserializer {
    protected static Set<String> ROOT_KEYS = new LinkedHashSet<String>(Arrays.asList("openapi", "info", "servers", "paths", "components", "security", "tags", "externalDocs"));
    protected static Set<String> INFO_KEYS = new LinkedHashSet<String>(Arrays.asList("title", "description", "termsOfService", "contact", "license", "version"));
    protected static Set<String> CONTACT_KEYS = new LinkedHashSet<String>(Arrays.asList("name", "url", "email"));
    protected static Set<String> LICENSE_KEYS = new LinkedHashSet<String>(Arrays.asList("name", "url"));
    protected static Set<String> TAG_KEYS = new LinkedHashSet<String>(Arrays.asList("description", "name", "externalDocs"));
    protected static Set<String> RESPONSE_KEYS = new LinkedHashSet<String>(Arrays.asList("$ref", "description", "headers", "content", "links"));
    protected static Set<String> SERVER_KEYS = new LinkedHashSet<String>(Arrays.asList("url", "description", "variables"));
    protected static Set<String> SERVER_VARIABLE_KEYS = new LinkedHashSet<String>(Arrays.asList("enum", "default", "description"));
    protected static Set<String> PATHITEM_KEYS = new LinkedHashSet<String>(Arrays.asList("$ref", "summary", "description", "get", "put", "post", "delete", "head", "patch", "options", "trace", "servers", "parameters"));
    protected static Set<String> OPERATION_KEYS = new LinkedHashSet<String>(Arrays.asList("tags", "summary", "description", "externalDocs", "operationId", "parameters", "requestBody", "responses", "callbacks", "deprecated", "security", "servers"));
    protected static Set<String> PARAMETER_KEYS = new LinkedHashSet<String>(Arrays.asList("$ref", "name", "in", "description", "required", "deprecated", "allowEmptyValue", "style", "explode", "allowReserved", "schema", "example", "examples", "content"));
    protected static Set<String> REQUEST_BODY_KEYS = new LinkedHashSet<String>(Arrays.asList("$ref", "description", "content", "required"));
    protected static Set<String> SECURITY_SCHEME_KEYS = new LinkedHashSet<String>(Arrays.asList("$ref", "type", "name", "in", "description", "flows", "scheme", "bearerFormat", "openIdConnectUrl"));
    protected static Set<String> EXTERNAL_DOCS_KEYS = new LinkedHashSet<String>(Arrays.asList("description", "url"));
    protected static Set<String> COMPONENTS_KEYS = new LinkedHashSet<String>(Arrays.asList("schemas", "responses", "parameters", "examples", "requestBodies", "headers", "securitySchemes", "links", "callbacks"));
    protected static Set<String> SCHEMA_KEYS = new LinkedHashSet<String>(Arrays.asList("$ref", "title", "multipleOf", "maximum", "format", "exclusiveMaximum", "minimum", "exclusiveMinimum", "maxLength", "minLength", "pattern", "maxItems", "minItems", "uniqueItems", "maxProperties", "minProperties", "required", "enum", "type", "allOf", "oneOf", "anyOf", "not", "items", "properties", "additionalProperties", "description", "format", "default", "nullable", "discriminator", "readOnly", "writeOnly", "xml", "externalDocs", "example", "deprecated"));
    protected static Set<String> EXAMPLE_KEYS = new LinkedHashSet<String>(Arrays.asList("$ref", "summary", "description", "value", "externalValue"));
    protected static Set<String> HEADER_KEYS = new LinkedHashSet<String>(Arrays.asList("$ref", "name", "in", "description", "required", "deprecated", "allowEmptyValue", "style", "explode", "allowReserved", "schema", "example", "examples", "content"));
    protected static Set<String> LINK_KEYS = new LinkedHashSet<String>(Arrays.asList("$ref", "operationRef", "operationId", "parameters", "requestBody", "description", "server"));
    protected static Set<String> MEDIATYPE_KEYS = new LinkedHashSet<String>(Arrays.asList("schema", "example", "examples", "encoding"));
    protected static Set<String> XML_KEYS = new LinkedHashSet<String>(Arrays.asList("name", "namespace", "prefix", "attribute", "wrapped"));
    protected static Set<String> OAUTHFLOW_KEYS = new LinkedHashSet<String>(Arrays.asList("authorizationUrl", "tokenUrl", "refreshUrl", "scopes"));
    protected static Set<String> OAUTHFLOWS_KEYS = new LinkedHashSet<String>(Arrays.asList("implicit", "password", "clientCredentials", "authorizationCode"));
    protected static Set<String> ENCODING_KEYS = new LinkedHashSet<String>(Arrays.asList("contentType", "headers", "style", "explode", "allowReserved"));
    private static final String QUERY_PARAMETER = "query";
    private static final String COOKIE_PARAMETER = "cookie";
    private static final String PATH_PARAMETER = "path";
    private static final String HEADER_PARAMETER = "header";
    private static final Pattern RFC3339_DATE_TIME_PATTERN = Pattern.compile("^(\\d{4})-(\\d{2})-(\\d{2})T(\\d{2}):(\\d{2}):(\\d{2})(\\.\\d+)?((Z)|([+-]\\d{2}:\\d{2}))$");
    private static final Pattern RFC3339_DATE_PATTERN = Pattern.compile("^(\\d{4})-(\\d{2})-(\\d{2})$");
    private static final String REFERENCE_SEPARATOR = "#/";
    private Components components;
    private final Set<String> operationIDs = new HashSet<String>();
    private Map<String, String> localSchemaRefs = new HashMap<String, String>();

    public SwaggerParseResult deserialize(JsonNode rootNode) {
        return this.deserialize(rootNode, null);
    }

    public SwaggerParseResult deserialize(JsonNode rootNode, String path) {
        return this.deserialize(rootNode, path, new ParseOptions());
    }

    public SwaggerParseResult deserialize(JsonNode rootNode, String path, ParseOptions options) {
        SwaggerParseResult result = new SwaggerParseResult();
        ParseResult rootParse = new ParseResult();
        rootParse.setAllowEmptyStrings(options.isAllowEmptyString());
        rootParse.setValidateInternalRefs(options.isValidateInternalRefs());
        OpenAPI api = this.parseRoot(rootNode, rootParse, path);
        result.setOpenAPI(api);
        result.setMessages(rootParse.getMessages());
        return result;
    }

    public OpenAPI parseRoot(JsonNode node, ParseResult result, String path) {
        String location = "";
        OpenAPI openAPI = new OpenAPI();
        if (node.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
            Map<String, Object> extensions;
            List<SecurityRequirement> securityRequirements;
            ArrayNode array;
            ObjectNode rootNode = (ObjectNode)node;
            String value = this.getString("openapi", rootNode, true, location, result);
            if (value == null || !value.startsWith("3.0")) {
                return null;
            }
            openAPI.setOpenapi(value);
            ObjectNode obj = this.getObject("info", rootNode, true, location, result);
            if (obj != null) {
                Info info = this.getInfo(obj, "info", result);
                openAPI.setInfo(info);
            }
            if ((obj = this.getObject("components", rootNode, false, location, result)) != null) {
                Components components = this.getComponents(obj, "components", result);
                openAPI.setComponents(components);
                this.components = components;
                if (result.validateInternalRefs) {
                    for (String schema : this.localSchemaRefs.keySet()) {
                        if (components.getSchemas().get(schema) != null) continue;
                        result.invalidType(this.localSchemaRefs.get(schema), schema, "schema", (JsonNode)rootNode);
                    }
                }
            }
            if ((obj = this.getObject("paths", rootNode, true, location, result)) != null) {
                Paths paths = this.getPaths(obj, "paths", result);
                openAPI.setPaths(paths);
            }
            if ((array = this.getArray("servers", rootNode, false, location, result)) != null && array.size() > 0) {
                openAPI.setServers(this.getServersList(array, String.format("%s.%s", location, "servers"), result, path));
            } else {
                Server defaultServer = new Server();
                defaultServer.setUrl("/");
                ArrayList<Server> servers = new ArrayList<Server>();
                servers.add(defaultServer);
                openAPI.setServers(servers);
            }
            obj = this.getObject("externalDocs", rootNode, false, location, result);
            if (obj != null) {
                ExternalDocumentation externalDocs = this.getExternalDocs(obj, "externalDocs", result);
                openAPI.setExternalDocs(externalDocs);
            }
            if ((array = this.getArray("tags", rootNode, false, location, result)) != null && array.size() > 0) {
                openAPI.setTags(this.getTagList(array, "tags", result));
            }
            if ((array = this.getArray("security", rootNode, false, location, result)) != null && array.size() > 0 && (securityRequirements = this.getSecurityRequirementsList(array, "security", result)) != null && securityRequirements.size() > 0) {
                openAPI.setSecurity(securityRequirements);
            }
            if ((extensions = this.getExtensions(rootNode)) != null && extensions.size() > 0) {
                openAPI.setExtensions(extensions);
            }
            Set<String> keys = this.getKeys(rootNode);
            for (String key : keys) {
                if (ROOT_KEYS.contains(key) || key.startsWith("x-")) continue;
                result.extra(location, key, node.get(key));
            }
        } else {
            result.invalidType(location, "openapi", "object", node);
            result.invalid();
            return null;
        }
        return openAPI;
    }

    public String mungedRef(String refString) {
        if (!(refString.contains(":") || refString.startsWith("#") || refString.startsWith("/") || refString.indexOf(".") <= 0)) {
            return "./" + refString;
        }
        return null;
    }

    public Map<String, Object> getExtensions(ObjectNode node) {
        Map<String, Object> extensions = this.tryDirectExtensions(node);
        if (extensions.isEmpty()) {
            extensions = this.tryUnwrapLookupExtensions(node);
        }
        return extensions;
    }

    private Map<String, Object> tryUnwrapLookupExtensions(ObjectNode node) {
        LinkedHashMap<String, Object> extensions = new LinkedHashMap<String, Object>();
        JsonNode extensionsNode = node.get("extensions");
        if (Objects.nonNull(extensionsNode) && JsonNodeType.OBJECT.equals((Object)node.getNodeType())) {
            ObjectNode extensionsObjectNode = (ObjectNode)extensionsNode;
            extensions.putAll(this.tryDirectExtensions(extensionsObjectNode));
        }
        return extensions;
    }

    private Map<String, Object> tryDirectExtensions(ObjectNode node) {
        LinkedHashMap<String, Object> extensions = new LinkedHashMap<String, Object>();
        Set<String> keys = this.getKeys(node);
        for (String key : keys) {
            if (!key.startsWith("x-")) continue;
            extensions.put(key, Json.mapper().convertValue((Object)node.get(key), Object.class));
        }
        return extensions;
    }

    public Components getComponents(ObjectNode obj, String location, ParseResult result) {
        if (obj == null) {
            return null;
        }
        Components components = new Components();
        ObjectNode node = this.getObject("schemas", obj, false, location, result);
        if (node != null) {
            components.setSchemas(this.getSchemas(node, String.format("%s.%s", location, "schemas"), result, true));
        }
        if ((node = this.getObject("responses", obj, false, location, result)) != null) {
            components.setResponses((Map)this.getResponses(node, String.format("%s.%s", location, "responses"), result, true));
        }
        if ((node = this.getObject("parameters", obj, false, location, result)) != null) {
            components.setParameters(this.getParameters(node, String.format("%s.%s", location, "parameters"), result, true));
        }
        if ((node = this.getObject("examples", obj, false, location, result)) != null) {
            components.setExamples(this.getExamples(node, String.format("%s.%s", location, "examples"), result, true));
        }
        if ((node = this.getObject("requestBodies", obj, false, location, result)) != null) {
            components.setRequestBodies(this.getRequestBodies(node, String.format("%s.%s", location, "requestBodies"), result, true));
        }
        if ((node = this.getObject("headers", obj, false, location, result)) != null) {
            components.setHeaders(this.getHeaders(node, String.format("%s.%s", location, "headers"), result, true));
        }
        if ((node = this.getObject("securitySchemes", obj, false, location, result)) != null) {
            components.setSecuritySchemes(this.getSecuritySchemes(node, String.format("%s.%s", location, "securitySchemes"), result, true));
        }
        if ((node = this.getObject("links", obj, false, location, result)) != null) {
            components.setLinks(this.getLinks(node, String.format("%s.%s", location, "links"), result, true));
        }
        if ((node = this.getObject("callbacks", obj, false, location, result)) != null) {
            components.setCallbacks(this.getCallbacks(node, String.format("%s.%s", location, "callbacks"), result, true));
        }
        components.setExtensions(new LinkedHashMap());
        Map<String, Object> extensions = this.getExtensions(obj);
        if (extensions != null && extensions.size() > 0) {
            components.setExtensions(extensions);
        }
        Set<String> keys = this.getKeys(obj);
        for (String key : keys) {
            if (COMPONENTS_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, obj.get(key));
        }
        return components;
    }

    public List<Tag> getTagList(ArrayNode obj, String location, ParseResult result) {
        if (obj == null) {
            return null;
        }
        ArrayList<Tag> tags = new ArrayList<Tag>();
        HashSet<String> tagsTracker = new HashSet<String>();
        for (JsonNode item : obj) {
            Tag tag;
            if (!item.getNodeType().equals((Object)JsonNodeType.OBJECT) || (tag = this.getTag((ObjectNode)item, location, result)) == null) continue;
            tags.add(tag);
            if (tagsTracker.contains(tag.getName())) {
                result.uniqueTags(location, tag.getName());
            }
            tagsTracker.add(tag.getName());
        }
        return tags;
    }

    public Tag getTag(ObjectNode obj, String location, ParseResult result) {
        Map<String, Object> extensions;
        ObjectNode docs;
        ExternalDocumentation externalDocs;
        if (obj == null) {
            return null;
        }
        Tag tag = new Tag();
        String value = this.getString("name", obj, true, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            tag.setName(value);
        }
        value = this.getString("description", obj, false, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            tag.setDescription(value);
        }
        if ((externalDocs = this.getExternalDocs(docs = this.getObject("externalDocs", obj, false, location, result), String.format("%s.%s", location, "externalDocs"), result)) != null) {
            tag.setExternalDocs(externalDocs);
        }
        if ((extensions = this.getExtensions(obj)) != null && extensions.size() > 0) {
            tag.setExtensions(extensions);
        }
        Set<String> keys = this.getKeys(obj);
        for (String key : keys) {
            if (TAG_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, obj.get(key));
        }
        return tag;
    }

    public List<Server> getServersList(ArrayNode obj, String location, ParseResult result, String path) {
        ArrayList<Server> servers = new ArrayList<Server>();
        if (obj == null) {
            return null;
        }
        for (JsonNode item : obj) {
            if (!item.getNodeType().equals((Object)JsonNodeType.OBJECT)) continue;
            Server server = this.getServer((ObjectNode)item, location, result, path);
            if (server != null) {
                servers.add(server);
                continue;
            }
            Server defaultServer = new Server();
            defaultServer.setUrl("/");
            servers.add(defaultServer);
        }
        return servers;
    }

    public List<Server> getServersList(ArrayNode obj, String location, ParseResult result) {
        return this.getServersList(obj, location, result, null);
    }

    public Server getServer(ObjectNode obj, String location, ParseResult result) {
        return this.getServer(obj, location, result, null);
    }

    public Server getServer(ObjectNode obj, String location, ParseResult result, String path) {
        Map<String, Object> extensions;
        ObjectNode variables;
        ServerVariables serverVariables;
        if (obj == null) {
            return null;
        }
        Server server = new Server();
        if (obj.get("variables") != null && (serverVariables = this.getServerVariables(variables = this.getObject("variables", obj, false, location, result), String.format("%s.%s", location, "variables"), result)) != null && serverVariables.size() > 0) {
            server.setVariables(serverVariables);
        }
        String value = this.getString("url", obj, true, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            block10: {
                if (!this.isValidURL(value) && path != null) {
                    try {
                        URI absURI = new URI(path.replaceAll("\\\\", "/"));
                        if ("http".equals(absURI.getScheme()) || "https".equals(absURI.getScheme())) {
                            value = absURI.resolve(new URI(value)).toString();
                        }
                    }
                    catch (URISyntaxException e) {
                        String variable = value.substring(value.indexOf("{") + 1, value.indexOf("}"));
                        if (server.getVariables() == null || server.getVariables().containsKey((Object)variable)) break block10;
                        result.warning(location, "invalid url : " + value);
                    }
                }
            }
            server.setUrl(value);
        }
        value = this.getString("description", obj, false, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            server.setDescription(value);
        }
        if ((extensions = this.getExtensions(obj)) != null && extensions.size() > 0) {
            server.setExtensions(extensions);
        }
        Set<String> keys = this.getKeys(obj);
        for (String key : keys) {
            if (SERVER_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, obj.get(key));
        }
        return server;
    }

    boolean isValidURL(String urlString) {
        try {
            URL url = new URL(urlString);
            url.toURI();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public ServerVariables getServerVariables(ObjectNode obj, String location, ParseResult result) {
        ServerVariables serverVariables = new ServerVariables();
        if (obj == null) {
            return null;
        }
        Set<String> serverKeys = this.getKeys(obj);
        for (String serverName : serverKeys) {
            JsonNode serverValue = obj.get(serverName);
            ObjectNode server = (ObjectNode)serverValue;
            ServerVariable serverVariable = this.getServerVariable(server, String.format("%s.%s", location, serverName), result);
            serverVariables.addServerVariable(serverName, serverVariable);
        }
        return serverVariables;
    }

    public ServerVariable getServerVariable(ObjectNode obj, String location, ParseResult result) {
        Map<String, Object> extensions;
        if (obj == null) {
            return null;
        }
        ServerVariable serverVariable = new ServerVariable();
        ArrayNode arrayNode = this.getArray("enum", obj, false, location, result);
        if (arrayNode != null) {
            ArrayList<String> _enum = new ArrayList<String>();
            for (JsonNode n : arrayNode) {
                if (n.isValueNode()) {
                    _enum.add(n.asText());
                    serverVariable.setEnum(_enum);
                    continue;
                }
                result.invalidType(location, "enum", "value", n);
            }
        }
        String value = this.getString("default", obj, true, String.format("%s.%s", location, "default"), result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            serverVariable.setDefault(value);
        }
        value = this.getString("description", obj, false, String.format("%s.%s", location, "description"), result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            serverVariable.setDescription(value);
        }
        if ((extensions = this.getExtensions(obj)) != null && extensions.size() > 0) {
            serverVariable.setExtensions(extensions);
        }
        Set<String> keys = this.getKeys(obj);
        for (String key : keys) {
            if (SERVER_VARIABLE_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, obj.get(key));
        }
        return serverVariable;
    }

    public Paths getPaths(ObjectNode obj, String location, ParseResult result) {
        Paths paths = new Paths();
        if (obj == null) {
            return null;
        }
        Set<String> pathKeys = this.getKeys(obj);
        for (String pathName : pathKeys) {
            JsonNode pathValue = obj.get(pathName);
            if (pathName.startsWith("x-")) {
                Map<String, Object> extensions = this.getExtensions(obj);
                if (extensions == null || extensions.size() <= 0) continue;
                paths.setExtensions(extensions);
                continue;
            }
            if (!pathValue.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                result.invalidType(location, pathName, "object", pathValue);
                continue;
            }
            if (!pathName.startsWith("/")) {
                result.warning(location, " Resource " + pathName + " should start with /");
            }
            ObjectNode path = (ObjectNode)pathValue;
            PathItem pathObj = this.getPathItem(path, String.format("%s.'%s'", location, pathName), result);
            ArrayList<String> eachPart = new ArrayList<String>();
            Matcher m = Pattern.compile("\\{(.+?)\\}").matcher(pathName);
            while (m.find()) {
                eachPart.add(m.group());
            }
            eachPart.stream().forEach(part -> {
                String pathParam = part.substring(1, part.length() - 1);
                boolean definedInPathLevel = this.isPathParamDefined(pathParam, pathObj.getParameters());
                if (!definedInPathLevel) {
                    List<Operation> operationsInAPath = this.getAllOperationsInAPath(pathObj);
                    operationsInAPath.forEach(operation -> {
                        List<Parameter> operationParameters = operation.getParameters();
                        if (operationParameters == null) {
                            operationParameters = Collections.emptyList();
                        }
                        operationParameters.forEach(parameter -> {
                            if (PATH_PARAMETER.equalsIgnoreCase(parameter.getIn()) && Boolean.FALSE.equals(parameter.getRequired())) {
                                result.warning(location, "For path parameter " + parameter.getName() + " the required value should be true");
                            }
                        });
                        if (!this.isPathParamDefined(pathParam, operationParameters)) {
                            result.warning(location + ".'" + pathName + "'", " Declared path parameter " + pathParam + " needs to be defined as a path parameter in path or operation level");
                            return;
                        }
                    });
                }
            });
            paths.put((Object)pathName, (Object)pathObj);
        }
        return paths;
    }

    private boolean isPathParamDefined(String pathParam, List<Parameter> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return false;
        }
        Parameter pathParamDefined = parameters.stream().filter(parameter -> parameter.get$ref() != null || pathParam.equals(parameter.getName()) && PATH_PARAMETER.equals(parameter.getIn())).findFirst().orElse(null);
        return pathParamDefined != null;
    }

    private void addToOperationsList(List<Operation> operationsList, Operation operation) {
        if (operation == null) {
            return;
        }
        operationsList.add(operation);
    }

    public List<Operation> getAllOperationsInAPath(PathItem pathObj) {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        this.addToOperationsList(operations, pathObj.getGet());
        this.addToOperationsList(operations, pathObj.getPut());
        this.addToOperationsList(operations, pathObj.getPost());
        this.addToOperationsList(operations, pathObj.getPatch());
        this.addToOperationsList(operations, pathObj.getDelete());
        this.addToOperationsList(operations, pathObj.getTrace());
        this.addToOperationsList(operations, pathObj.getOptions());
        this.addToOperationsList(operations, pathObj.getHead());
        return operations;
    }

    public PathItem getPathItem(ObjectNode obj, String location, ParseResult result) {
        Map<String, Object> extensions;
        Operation operation;
        ObjectNode node;
        ArrayNode servers;
        ArrayNode parameters;
        PathItem pathItem = new PathItem();
        if (obj.get("$ref") != null) {
            JsonNode ref = obj.get("$ref");
            if (ref.getNodeType().equals((Object)JsonNodeType.STRING)) {
                String mungedRef = this.mungedRef(ref.textValue());
                if (mungedRef != null) {
                    pathItem.set$ref(mungedRef);
                } else {
                    pathItem.set$ref(ref.textValue());
                }
                return pathItem;
            }
            if (ref.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                ObjectNode node2 = (ObjectNode)ref;
                Set<String> keys = this.getKeys(node2);
                for (String key : keys) {
                    result.extra(location, key, node2.get(key));
                }
            }
            return null;
        }
        String value = this.getString("summary", obj, false, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            pathItem.setSummary(value);
        }
        value = this.getString("description", obj, false, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            pathItem.setDescription(value);
        }
        if ((parameters = this.getArray("parameters", obj, false, location, result)) != null && parameters.size() > 0) {
            pathItem.setParameters(this.getParameterList(parameters, location, result));
        }
        if ((servers = this.getArray("servers", obj, false, location, result)) != null && servers.size() > 0) {
            pathItem.setServers(this.getServersList(servers, location, result));
        }
        if ((node = this.getObject("get", obj, false, location, result)) != null && (operation = this.getOperation(node, location + "(get)", result)) != null) {
            pathItem.setGet(operation);
        }
        if ((node = this.getObject("put", obj, false, location, result)) != null && (operation = this.getOperation(node, location + "(put)", result)) != null) {
            pathItem.setPut(operation);
        }
        if ((node = this.getObject("post", obj, false, location, result)) != null && (operation = this.getOperation(node, location + "(post)", result)) != null) {
            pathItem.setPost(operation);
        }
        if ((node = this.getObject("head", obj, false, location, result)) != null && (operation = this.getOperation(node, location + "(head)", result)) != null) {
            pathItem.setHead(operation);
        }
        if ((node = this.getObject("delete", obj, false, location, result)) != null && (operation = this.getOperation(node, location + "(delete)", result)) != null) {
            pathItem.setDelete(operation);
        }
        if ((node = this.getObject("patch", obj, false, location, result)) != null && (operation = this.getOperation(node, location + "(patch)", result)) != null) {
            pathItem.setPatch(operation);
        }
        if ((node = this.getObject("options", obj, false, location, result)) != null && (operation = this.getOperation(node, location + "(options)", result)) != null) {
            pathItem.setOptions(operation);
        }
        if ((node = this.getObject("trace", obj, false, location, result)) != null && (operation = this.getOperation(node, location + "(trace)", result)) != null) {
            pathItem.setTrace(operation);
        }
        if ((extensions = this.getExtensions(obj)) != null && extensions.size() > 0) {
            pathItem.setExtensions(extensions);
        }
        Set<String> keys = this.getKeys(obj);
        for (String key : keys) {
            if (PATHITEM_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, obj.get(key));
        }
        return pathItem;
    }

    public ExternalDocumentation getExternalDocs(ObjectNode node, String location, ParseResult result) {
        ExternalDocumentation externalDocs = null;
        if (node != null) {
            Map<String, Object> extensions;
            externalDocs = new ExternalDocumentation();
            String value = this.getString("description", node, false, location, result);
            if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
                externalDocs.description(value);
            }
            value = this.getString("url", node, true, location, result);
            if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
                externalDocs.url(value);
            }
            if ((extensions = this.getExtensions(node)) != null && extensions.size() > 0) {
                externalDocs.setExtensions(extensions);
            }
            Set<String> keys = this.getKeys(node);
            for (String key : keys) {
                if (EXTERNAL_DOCS_KEYS.contains(key) || key.startsWith("x-")) continue;
                result.extra(location, key, node.get(key));
            }
        }
        return externalDocs;
    }

    public String getString(String key, ObjectNode node, boolean required, String location, ParseResult result, Set<String> uniqueValues) {
        String value = null;
        JsonNode v = node.get(key);
        if (node == null || v == null) {
            if (required) {
                result.missing(location, key);
                result.invalid();
            }
        } else if (!v.isValueNode()) {
            result.invalidType(location, key, "string", (JsonNode)node);
        } else if (!v.isNull()) {
            value = v.asText();
            if (uniqueValues != null && !uniqueValues.add(value)) {
                result.unique(location, "operationId");
                result.invalid();
            }
        }
        return value;
    }

    public String getString(String key, ObjectNode node, boolean required, String location, ParseResult result) {
        return this.getString(key, node, required, location, result, null);
    }

    public Set<String> getKeys(ObjectNode node) {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        if (node == null) {
            return keys;
        }
        Iterator it = node.fieldNames();
        while (it.hasNext()) {
            keys.add((String)it.next());
        }
        return keys;
    }

    public ObjectNode getObject(String key, ObjectNode node, boolean required, String location, ParseResult result) {
        JsonNode value = node.get(key);
        ObjectNode object = null;
        if (value == null) {
            if (required) {
                result.missing(location, key);
                result.invalid();
            }
        } else if (!value.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
            result.invalidType(location, key, "object", value);
            if (required) {
                result.invalid();
            }
        } else {
            object = (ObjectNode)value;
        }
        return object;
    }

    public Info getInfo(ObjectNode node, String location, ParseResult result) {
        Map<String, Object> extensions;
        if (node == null) {
            return null;
        }
        Info info = new Info();
        String value = this.getString("title", node, true, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            info.setTitle(value);
        }
        value = this.getString("description", node, false, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            info.setDescription(value);
        }
        value = this.getString("termsOfService", node, false, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            info.setTermsOfService(value);
        }
        ObjectNode obj = this.getObject("contact", node, false, "contact", result);
        Contact contact = this.getContact(obj, String.format("%s.%s", location, "contact"), result);
        if (obj != null) {
            info.setContact(contact);
        }
        obj = this.getObject("license", node, false, location, result);
        License license = this.getLicense(obj, String.format("%s.%s", location, "license"), result);
        if (obj != null) {
            info.setLicense(license);
        }
        value = this.getString("version", node, true, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            info.setVersion(value);
        }
        if ((extensions = this.getExtensions(node)) != null && extensions.size() > 0) {
            info.setExtensions(extensions);
        }
        Set<String> keys = this.getKeys(node);
        for (String key : keys) {
            if (INFO_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, node.get(key));
        }
        return info;
    }

    public License getLicense(ObjectNode node, String location, ParseResult result) {
        Map<String, Object> extensions;
        if (node == null) {
            return null;
        }
        License license = new License();
        String value = this.getString("name", node, true, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            license.setName(value);
        }
        value = this.getString("url", node, false, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            try {
                new URL(value);
            }
            catch (Exception e) {
                result.warning(location, value);
            }
            license.setUrl(value);
        }
        if ((extensions = this.getExtensions(node)) != null && extensions.size() > 0) {
            license.setExtensions(extensions);
        }
        Set<String> keys = this.getKeys(node);
        for (String key : keys) {
            if (LICENSE_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, node.get(key));
        }
        return license;
    }

    public Contact getContact(ObjectNode node, String location, ParseResult result) {
        Map<String, Object> extensions;
        if (node == null) {
            return null;
        }
        Contact contact = new Contact();
        String value = this.getString("name", node, false, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            contact.setName(value);
        }
        value = this.getString("url", node, false, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            try {
                new URL(value);
            }
            catch (Exception e) {
                result.warning(location, value);
            }
            contact.setUrl(value);
        }
        value = this.getString("email", node, false, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            contact.setEmail(value);
        }
        if ((extensions = this.getExtensions(node)) != null && extensions.size() > 0) {
            contact.setExtensions(extensions);
        }
        Set<String> keys = this.getKeys(node);
        for (String key : keys) {
            if (CONTACT_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, node.get(key));
        }
        return contact;
    }

    public Content getContent(ObjectNode node, String location, ParseResult result) {
        if (node == null) {
            return null;
        }
        Content content = new Content();
        Set<String> keys = this.getKeys(node);
        for (String key : keys) {
            MediaType mediaType = this.getMediaType((ObjectNode)node.get(key), String.format("%s.'%s'", location, key), result);
            if (mediaType == null) continue;
            content.addMediaType(key, mediaType);
        }
        return content;
    }

    public MediaType getMediaType(ObjectNode contentNode, String location, ParseResult result) {
        Object example;
        ObjectNode examplesObject;
        Map<String, Object> extensions;
        ObjectNode encodingObject;
        if (contentNode == null) {
            return null;
        }
        MediaType mediaType = new MediaType();
        ObjectNode schemaObject = this.getObject("schema", contentNode, false, location, result);
        if (schemaObject != null) {
            mediaType.setSchema(this.getSchema(schemaObject, String.format("%s.%s", location, "schema"), result));
        }
        if ((encodingObject = this.getObject("encoding", contentNode, false, location, result)) != null) {
            mediaType.setEncoding(this.getEncodingMap(encodingObject, String.format("%s.%s", location, "encoding"), result));
        }
        if ((extensions = this.getExtensions(contentNode)) != null && extensions.size() > 0) {
            mediaType.setExtensions(extensions);
        }
        if ((examplesObject = this.getObject("examples", contentNode, false, location, result)) != null) {
            mediaType.setExamples(this.getExamples(examplesObject, String.format("%s.%s", location, "examples"), result, false));
        }
        if ((example = this.getAnyExample("example", contentNode, location, result)) != null) {
            if (examplesObject != null) {
                result.warning(location, "examples already defined -- ignoring \"example\" field");
            } else {
                mediaType.setExample(example instanceof NullNode ? null : example);
            }
        }
        Set<String> keys = this.getKeys(contentNode);
        for (String key : keys) {
            if (MEDIATYPE_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, contentNode.get(key));
        }
        return mediaType;
    }

    public Map<String, Encoding> getEncodingMap(ObjectNode node, String location, ParseResult result) {
        if (node == null) {
            return null;
        }
        LinkedHashMap<String, Encoding> encodings = new LinkedHashMap<String, Encoding>();
        Set<String> keys = this.getKeys(node);
        for (String key : keys) {
            Encoding encoding = this.getEncoding((ObjectNode)node.get(key), location, result);
            if (encoding == null) continue;
            encodings.put(key, encoding);
        }
        return encodings;
    }

    public Encoding getEncoding(ObjectNode node, String location, ParseResult result) {
        Map<String, Object> extensions;
        ObjectNode headersObject;
        Boolean allowReserved;
        if (node == null) {
            return null;
        }
        Encoding encoding = new Encoding();
        String value = this.getString("contentType", node, false, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            encoding.setContentType(value);
        }
        if (StringUtils.isBlank((CharSequence)(value = this.getString("style", node, false, location, result)))) {
            encoding.setStyle(Encoding.StyleEnum.FORM);
        } else if (value.equals(Encoding.StyleEnum.FORM.toString())) {
            encoding.setStyle(Encoding.StyleEnum.FORM);
        } else if (value.equals(Encoding.StyleEnum.DEEP_OBJECT.toString())) {
            encoding.setStyle(Encoding.StyleEnum.DEEP_OBJECT);
        } else if (value.equals(Encoding.StyleEnum.PIPE_DELIMITED.toString())) {
            encoding.setStyle(Encoding.StyleEnum.PIPE_DELIMITED);
        } else if (value.equals(Encoding.StyleEnum.SPACE_DELIMITED.toString())) {
            encoding.setStyle(Encoding.StyleEnum.SPACE_DELIMITED);
        } else {
            result.invalidType(location, "style", "string", (JsonNode)node);
        }
        Boolean explode = this.getBoolean("explode", node, false, location, result);
        if (explode != null) {
            encoding.setExplode(explode);
        }
        if ((allowReserved = this.getBoolean("allowReserved", node, false, location, result)) != null) {
            encoding.setAllowReserved(allowReserved);
        }
        if ((headersObject = this.getObject("headers", node, false, location, result)) != null) {
            encoding.setHeaders(this.getHeaders(headersObject, location, result, false));
        }
        if ((extensions = this.getExtensions(node)) != null && extensions.size() > 0) {
            encoding.setExtensions(extensions);
        }
        Set<String> keys = this.getKeys(node);
        for (String key : keys) {
            if (ENCODING_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, node.get(key));
        }
        return encoding;
    }

    public Map<String, Link> getLinks(ObjectNode obj, String location, ParseResult result, boolean underComponents) {
        if (obj == null) {
            return null;
        }
        LinkedHashMap<String, Link> links = new LinkedHashMap<String, Link>();
        Set<String> linkKeys = this.getKeys(obj);
        for (String linkName : linkKeys) {
            JsonNode linkValue;
            if (underComponents && !Pattern.matches("^[a-zA-Z0-9\\.\\-_]+$", linkName)) {
                result.warning(location, "Link name " + linkName + " doesn't adhere to regular expression ^[a-zA-Z0-9\\.\\-_]+$");
            }
            if (!(linkValue = obj.get(linkName)).getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                result.invalidType(location, linkName, "object", linkValue);
                continue;
            }
            ObjectNode link = (ObjectNode)linkValue;
            Link linkObj = this.getLink(link, String.format("%s.%s", location, linkName), result);
            if (linkObj == null) continue;
            links.put(linkName, linkObj);
        }
        return links;
    }

    public Link getLink(ObjectNode linkNode, String location, ParseResult result) {
        Map<String, Object> extensions;
        ObjectNode serverObject;
        ObjectNode headerObject;
        ObjectNode parametersObject;
        if (linkNode == null) {
            return null;
        }
        Link link = new Link();
        JsonNode ref = linkNode.get("$ref");
        if (ref != null) {
            if (ref.getNodeType().equals((Object)JsonNodeType.STRING)) {
                String mungedRef = this.mungedRef(ref.textValue());
                if (mungedRef != null) {
                    link.set$ref(mungedRef);
                } else {
                    link.set$ref(ref.textValue());
                }
                return link;
            }
            result.invalidType(location, "$ref", "string", (JsonNode)linkNode);
            return null;
        }
        String value = this.getString("operationRef", linkNode, false, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            link.setOperationRef(value);
        }
        value = this.getString("operationId", linkNode, false, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            link.setOperationId(value);
        }
        if ((parametersObject = this.getObject("parameters", linkNode, false, location, result)) != null) {
            link.setParameters(this.getLinkParameters(parametersObject, location, result));
        }
        String requestBody = this.getString("requestBody", linkNode, false, location, result);
        if (result.isAllowEmptyStrings() && requestBody != null) {
            link.setRequestBody((Object)requestBody);
        }
        if ((headerObject = this.getObject("headers", linkNode, false, location, result)) != null) {
            link.setHeaders(this.getHeaders(headerObject, location, result, false));
        }
        if ((serverObject = this.getObject("server", linkNode, false, location, result)) != null) {
            link.setServer(this.getServer(serverObject, location, result));
        }
        value = this.getString("description", linkNode, false, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            link.setDescription(value);
        }
        if ((extensions = this.getExtensions(linkNode)) != null && extensions.size() > 0) {
            link.setExtensions(extensions);
        }
        Set<String> keys = this.getKeys(linkNode);
        for (String key : keys) {
            if (LINK_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, linkNode.get(key));
        }
        return link;
    }

    private Map<String, String> getLinkParameters(ObjectNode parametersObject, String location, ParseResult result) {
        LinkedHashMap<String, String> linkParameters = new LinkedHashMap<String, String>();
        Set<String> keys = this.getKeys(parametersObject);
        for (String name : keys) {
            JsonNode value = parametersObject.get(name);
            linkParameters.put(name, value.asText());
        }
        return linkParameters;
    }

    public Map<String, Callback> getCallbacks(ObjectNode node, String location, ParseResult result, boolean underComponents) {
        if (node == null) {
            return null;
        }
        LinkedHashMap<String, Callback> callbacks = new LinkedHashMap<String, Callback>();
        Set<String> keys = this.getKeys(node);
        for (String key : keys) {
            Callback callback;
            if (underComponents && !Pattern.matches("^[a-zA-Z0-9\\.\\-_]+$", key)) {
                result.warning(location, "Callback key " + key + " doesn't adhere to regular expression ^[a-zA-Z0-9\\.\\-_]+$");
            }
            if ((callback = this.getCallback((ObjectNode)node.get(key), location, result)) == null) continue;
            callbacks.put(key, callback);
        }
        return callbacks;
    }

    public Callback getCallback(ObjectNode node, String location, ParseResult result) {
        if (node == null) {
            return null;
        }
        Callback callback = new Callback();
        Set<String> keys = this.getKeys(node);
        for (String name : keys) {
            Map<String, Object> extensions;
            JsonNode value = node.get(name);
            if (node == null) continue;
            JsonNode ref = node.get("$ref");
            if (ref != null) {
                if (ref.getNodeType().equals((Object)JsonNodeType.STRING)) {
                    String mungedRef = this.mungedRef(ref.textValue());
                    if (mungedRef != null) {
                        callback.set$ref(mungedRef);
                    } else {
                        callback.set$ref(ref.textValue());
                    }
                    return callback;
                }
                result.invalidType(location, "$ref", "string", (JsonNode)node);
                return null;
            }
            if (value.isObject()) {
                callback.addPathItem(name, this.getPathItem((ObjectNode)value, location, result));
            } else {
                result.invalidType(location, name, "object", value);
            }
            if ((extensions = this.getExtensions(node)) == null || extensions.size() <= 0) continue;
            callback.setExtensions(extensions);
        }
        return callback;
    }

    public XML getXml(ObjectNode node, String location, ParseResult result) {
        Map<String, Object> extensions;
        Boolean wrapped;
        Boolean attribute;
        if (node == null) {
            return null;
        }
        XML xml = new XML();
        String value = this.getString("name", node, false, String.format("%s.%s", location, "name"), result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            xml.setName(value);
        }
        value = this.getString("namespace", node, false, String.format("%s.%s", location, "namespace"), result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            xml.setNamespace(value);
        }
        value = this.getString("prefix", node, false, String.format("%s.%s", location, "prefix"), result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            xml.setPrefix(value);
        }
        if ((attribute = this.getBoolean("attribute", node, false, location, result)) != null) {
            xml.setAttribute(attribute);
        }
        if ((wrapped = this.getBoolean("wrapped", node, false, location, result)) != null) {
            xml.setWrapped(wrapped);
        }
        if ((extensions = this.getExtensions(node)) != null && extensions.size() > 0) {
            xml.setExtensions(extensions);
        }
        Set<String> keys = this.getKeys(node);
        for (String key : keys) {
            if (XML_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, node.get(key));
        }
        return xml;
    }

    public ArrayNode getArray(String key, ObjectNode node, boolean required, String location, ParseResult result) {
        JsonNode value = node.get(key);
        ArrayNode arrayNode = null;
        if (value == null) {
            if (required) {
                result.missing(location, key);
                result.invalid();
            }
        } else if (!value.getNodeType().equals((Object)JsonNodeType.ARRAY)) {
            result.invalidType(location, key, "array", value);
        } else {
            arrayNode = (ArrayNode)value;
        }
        return arrayNode;
    }

    public Boolean getBoolean(String key, ObjectNode node, boolean required, String location, ParseResult result) {
        Boolean value = null;
        JsonNode v = node.get(key);
        if (node == null || v == null) {
            if (required) {
                result.missing(location, key);
                result.invalid();
            }
        } else if (v.getNodeType().equals((Object)JsonNodeType.BOOLEAN)) {
            value = v.asBoolean();
        } else if (v.getNodeType().equals((Object)JsonNodeType.STRING)) {
            String stringValue = v.textValue();
            return Boolean.parseBoolean(stringValue);
        }
        return value;
    }

    public BigDecimal getBigDecimal(String key, ObjectNode node, boolean required, String location, ParseResult result) {
        BigDecimal value = null;
        JsonNode v = node.get(key);
        if (node == null || v == null) {
            if (required) {
                result.missing(location, key);
                result.invalid();
            }
        } else if (v.getNodeType().equals((Object)JsonNodeType.NUMBER)) {
            value = new BigDecimal(v.asText());
        } else if (!v.isValueNode()) {
            result.invalidType(location, key, "double", (JsonNode)node);
        }
        return value;
    }

    public Integer getInteger(String key, ObjectNode node, boolean required, String location, ParseResult result) {
        Integer value = null;
        JsonNode v = node.get(key);
        if (node == null || v == null) {
            if (required) {
                result.missing(location, key);
                result.invalid();
            }
        } else if (v.getNodeType().equals((Object)JsonNodeType.NUMBER)) {
            if (v.isInt()) {
                value = v.intValue();
            }
        } else if (!v.isValueNode()) {
            result.invalidType(location, key, "integer", (JsonNode)node);
        }
        return value;
    }

    public Map<String, Parameter> getParameters(ObjectNode obj, String location, ParseResult result, boolean underComponents) {
        if (obj == null) {
            return null;
        }
        LinkedHashMap<String, Parameter> parameters = new LinkedHashMap<String, Parameter>();
        HashSet filter = new HashSet();
        Parameter parameter = null;
        Set<String> parameterKeys = this.getKeys(obj);
        for (String parameterName : parameterKeys) {
            ObjectNode parameterObj;
            JsonNode parameterValue;
            if (underComponents && !Pattern.matches("^[a-zA-Z0-9\\.\\-_]+$", parameterName)) {
                result.warning(location, "Parameter name " + parameterName + " doesn't adhere to regular expression ^[a-zA-Z0-9\\.\\-_]+$");
            }
            if (!(parameterValue = obj.get(parameterName)).getNodeType().equals((Object)JsonNodeType.OBJECT) || (parameterObj = (ObjectNode)parameterValue) == null || (parameter = this.getParameter(parameterObj, String.format("%s.%s", location, parameterName), result)) == null) continue;
            if (PATH_PARAMETER.equalsIgnoreCase(parameter.getIn()) && Boolean.FALSE.equals(parameter.getRequired())) {
                result.warning(location, "For path parameter " + parameterName + " the required value should be true");
            }
            parameters.put(parameterName, parameter);
        }
        return parameters;
    }

    public List<Parameter> getParameterList(ArrayNode obj, String location, ParseResult result) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        if (obj == null) {
            return parameters;
        }
        for (JsonNode item : obj) {
            Parameter parameter;
            if (!item.getNodeType().equals((Object)JsonNodeType.OBJECT) || (parameter = this.getParameter((ObjectNode)item, location, result)) == null) continue;
            parameters.add(parameter);
        }
        HashSet filter = new HashSet();
        parameters.stream().map(this::getParameterDefinition).forEach(param -> {
            String ref = param.get$ref();
            if (!filter.add(param.getName() + "#" + param.getIn())) {
                if (ref != null) {
                    if (ref.startsWith(REFERENCE_SEPARATOR)) {
                        result.warning(location, "There are duplicate parameter values");
                    }
                } else {
                    result.warning(location, "There are duplicate parameter values");
                }
            }
        });
        return parameters;
    }

    private Parameter getParameterDefinition(Parameter parameter) {
        if (parameter.get$ref() == null) {
            return parameter;
        }
        Object parameterSchemaName = RefUtils.extractSimpleName((String)parameter.get$ref()).getLeft();
        return Optional.ofNullable(this.components).map(Components::getParameters).map(parameters -> (Parameter)parameters.get(parameterSchemaName)).orElse(parameter);
    }

    public Parameter getParameter(ObjectNode obj, String location, ParseResult result) {
        Map<String, Object> extensions;
        ObjectNode contentNode;
        Boolean allowReserved;
        Object example;
        ObjectNode examplesObject;
        ObjectNode parameterObject;
        Boolean allowEmptyValue;
        Boolean required;
        if (obj == null) {
            return null;
        }
        Parameter parameter = null;
        JsonNode ref = obj.get("$ref");
        if (ref != null) {
            if (ref.getNodeType().equals((Object)JsonNodeType.STRING)) {
                parameter = new Parameter();
                String mungedRef = this.mungedRef(ref.textValue());
                if (mungedRef != null) {
                    parameter.set$ref(mungedRef);
                } else {
                    parameter.set$ref(ref.textValue());
                }
                return parameter;
            }
            result.invalidType(location, "$ref", "string", (JsonNode)obj);
            return null;
        }
        String l = null;
        JsonNode ln = obj.get("name");
        l = ln != null ? ln.asText() : "['unknown']";
        location = location + ".[" + l + "]";
        String value = this.getString("in", obj, true, location, result);
        if (!result.isAllowEmptyStrings() && StringUtils.isBlank((CharSequence)value) || result.isAllowEmptyStrings() && value == null) {
            return null;
        }
        if (QUERY_PARAMETER.equals(value)) {
            parameter = new QueryParameter();
        } else if (HEADER_PARAMETER.equals(value)) {
            parameter = new HeaderParameter();
        } else if (PATH_PARAMETER.equals(value)) {
            parameter = new PathParameter();
        } else if (COOKIE_PARAMETER.equals(value)) {
            parameter = new CookieParameter();
        }
        if (parameter == null) {
            result.invalidType(location, "in", "[query|header|path|cookie]", (JsonNode)obj);
            return null;
        }
        parameter.setIn(value);
        value = this.getString("name", obj, true, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            parameter.setName(value);
        }
        value = this.getString("description", obj, false, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            parameter.setDescription(value);
        }
        if ((required = this.getBoolean("required", obj, false, location, result)) != null) {
            parameter.setRequired(required);
        } else {
            parameter.setRequired(Boolean.valueOf(false));
        }
        Boolean deprecated = this.getBoolean("deprecated", obj, false, location, result);
        if (deprecated != null) {
            parameter.setDeprecated(deprecated);
        }
        if (parameter instanceof QueryParameter && (allowEmptyValue = this.getBoolean("allowEmptyValue", obj, false, location, result)) != null) {
            parameter.setAllowEmptyValue(allowEmptyValue);
        }
        if ((parameterObject = this.getObject("schema", obj, false, location, result)) != null) {
            parameter.setSchema(this.getSchema(parameterObject, String.format("%s.%s", location, "schemas"), result));
        }
        if ((examplesObject = this.getObject("examples", obj, false, location, result)) != null) {
            parameter.setExamples(this.getExamples(examplesObject, String.format("%s.%s", location, "examples"), result, false));
        }
        if ((example = this.getAnyExample("example", obj, location, result)) != null) {
            if (examplesObject != null) {
                result.warning(location, "examples already defined -- ignoring \"example\" field");
            } else {
                parameter.setExample(example instanceof NullNode ? null : example);
            }
        }
        if ((allowReserved = this.getBoolean("allowReserved", obj, false, location, result)) != null) {
            parameter.setAllowReserved(allowReserved);
        }
        if ((contentNode = this.getObject("content", obj, false, location, result)) != null) {
            Content content = this.getContent(contentNode, String.format("%s.%s", location, "content"), result);
            if (content.size() == 0) {
                result.unsupported(location, "content with no media type", (JsonNode)contentNode);
                result.invalid();
            } else if (content.size() > 1) {
                result.unsupported(location, "content with multiple media types", (JsonNode)contentNode);
                result.invalid();
            } else if (parameter.getSchema() != null) {
                result.unsupported(location, "content when schema defined", (JsonNode)contentNode);
                result.invalid();
            } else {
                parameter.setContent(content);
            }
        } else if (parameter.getSchema() == null) {
            result.missing(location, "content");
        }
        value = this.getString("style", obj, false, location, result);
        if (parameter.getContent() == null) {
            this.setStyle(value, parameter, location, obj, result);
            Boolean explode = this.getBoolean("explode", obj, false, location, result);
            if (explode != null) {
                parameter.setExplode(explode);
            } else if (Parameter.StyleEnum.FORM.equals((Object)parameter.getStyle())) {
                parameter.setExplode(Boolean.TRUE);
            } else {
                parameter.setExplode(Boolean.FALSE);
            }
        }
        if ((extensions = this.getExtensions(obj)) != null && extensions.size() > 0) {
            parameter.setExtensions(extensions);
        }
        Set<String> keys = this.getKeys(obj);
        for (String key : keys) {
            if (PARAMETER_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, obj.get(key));
        }
        return parameter;
    }

    public Map<String, Header> getHeaders(ObjectNode obj, String location, ParseResult result, boolean underComponents) {
        if (obj == null) {
            return null;
        }
        LinkedHashMap<String, Header> headers = new LinkedHashMap<String, Header>();
        Set<String> headerKeys = this.getKeys(obj);
        for (String headerName : headerKeys) {
            JsonNode headerValue;
            if (underComponents && !Pattern.matches("^[a-zA-Z0-9\\.\\-_]+$", headerName)) {
                result.warning(location, "Header name " + headerName + " doesn't adhere to regular expression ^[a-zA-Z0-9\\.\\-_]+$");
            }
            if (!(headerValue = obj.get(headerName)).getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                result.invalidType(location, headerName, "object", headerValue);
                continue;
            }
            ObjectNode header = (ObjectNode)headerValue;
            Header headerObj = this.getHeader(header, String.format("%s.%s", location, headerName), result);
            if (headerObj == null) continue;
            headers.put(headerName, headerObj);
        }
        return headers;
    }

    public Header getHeader(ObjectNode headerNode, String location, ParseResult result) {
        Map<String, Object> extensions;
        ObjectNode contentNode;
        Object example;
        ObjectNode examplesObject;
        Boolean explode;
        Boolean deprecated;
        Boolean required;
        if (headerNode == null) {
            return null;
        }
        Header header = new Header();
        JsonNode ref = headerNode.get("$ref");
        if (ref != null) {
            if (ref.getNodeType().equals((Object)JsonNodeType.STRING)) {
                String mungedRef = this.mungedRef(ref.textValue());
                if (mungedRef != null) {
                    header.set$ref(mungedRef);
                } else {
                    header.set$ref(ref.textValue());
                }
                return header;
            }
            result.invalidType(location, "$ref", "string", (JsonNode)headerNode);
            return null;
        }
        String value = this.getString("description", headerNode, false, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            header.setDescription(value);
        }
        if ((required = this.getBoolean("required", headerNode, false, location, result)) != null) {
            header.setRequired(required);
        }
        if ((deprecated = this.getBoolean("deprecated", headerNode, false, location, result)) != null) {
            header.setDeprecated(deprecated);
        }
        if ((explode = this.getBoolean("explode", headerNode, false, location, result)) != null) {
            header.setExplode(explode);
        } else {
            header.setExplode(Boolean.FALSE);
        }
        header.setStyle(Header.StyleEnum.SIMPLE);
        ObjectNode headerObject = this.getObject("schema", headerNode, false, location, result);
        if (headerObject != null) {
            header.setSchema(this.getSchema(headerObject, location, result));
        }
        if ((examplesObject = this.getObject("examples", headerNode, false, location, result)) != null) {
            header.setExamples(this.getExamples(examplesObject, location, result, false));
        }
        if ((example = this.getAnyExample("example", headerNode, location, result)) != null) {
            if (examplesObject != null) {
                result.warning(location, "examples already defined -- ignoring \"example\" field");
            } else {
                header.setExample(example instanceof NullNode ? null : example);
            }
        }
        if ((contentNode = this.getObject("content", headerNode, false, location, result)) != null) {
            header.setContent(this.getContent(contentNode, String.format("%s.%s", location, "content"), result));
        }
        if ((extensions = this.getExtensions(headerNode)) != null && extensions.size() > 0) {
            header.setExtensions(extensions);
        }
        Set<String> oAuthFlowKeys = this.getKeys(headerNode);
        for (String key : oAuthFlowKeys) {
            if (HEADER_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, headerNode.get(key));
        }
        return header;
    }

    public Object getAnyExample(String nodeKey, ObjectNode node, String location, ParseResult result) {
        JsonNode example = node.get(nodeKey);
        if (example != null) {
            if (example.getNodeType().equals((Object)JsonNodeType.STRING)) {
                return this.getString(nodeKey, node, false, location, result);
            }
            if (example.getNodeType().equals((Object)JsonNodeType.NUMBER)) {
                Integer integerExample = this.getInteger(nodeKey, node, false, location, result);
                if (integerExample != null) {
                    return integerExample;
                }
                BigDecimal bigDecimalExample = this.getBigDecimal(nodeKey, node, false, location, result);
                if (bigDecimalExample != null) {
                    return bigDecimalExample;
                }
            } else if (example.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                ObjectNode objectValue = this.getObject(nodeKey, node, false, location, result);
                if (objectValue != null) {
                    return objectValue;
                }
            } else if (example.getNodeType().equals((Object)JsonNodeType.ARRAY)) {
                ArrayNode arrayValue = this.getArray(nodeKey, node, false, location, result);
                if (arrayValue != null) {
                    return arrayValue;
                }
            } else if (example.getNodeType().equals((Object)JsonNodeType.BOOLEAN)) {
                Boolean bool = this.getBoolean(nodeKey, node, false, location, result);
                if (bool != null) {
                    return bool;
                }
            } else if (example.getNodeType().equals((Object)JsonNodeType.NULL)) {
                return example;
            }
        }
        return null;
    }

    public Map<String, SecurityScheme> getSecuritySchemes(ObjectNode obj, String location, ParseResult result, boolean underComponents) {
        if (obj == null) {
            return null;
        }
        LinkedHashMap<String, SecurityScheme> securitySchemes = new LinkedHashMap<String, SecurityScheme>();
        Set<String> securitySchemeKeys = this.getKeys(obj);
        for (String securitySchemeName : securitySchemeKeys) {
            JsonNode securitySchemeValue;
            if (underComponents && !Pattern.matches("^[a-zA-Z0-9\\.\\-_]+$", securitySchemeName)) {
                result.warning(location, "SecurityScheme name " + securitySchemeName + " doesn't adhere to regular expression ^[a-zA-Z0-9\\.\\-_]+$");
            }
            if (!(securitySchemeValue = obj.get(securitySchemeName)).getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                result.invalidType(location, securitySchemeName, "object", securitySchemeValue);
                continue;
            }
            ObjectNode securityScheme = (ObjectNode)securitySchemeValue;
            SecurityScheme securitySchemeObj = this.getSecurityScheme(securityScheme, String.format("%s.%s", location, securitySchemeName), result);
            if (securityScheme == null) continue;
            securitySchemes.put(securitySchemeName, securitySchemeObj);
        }
        return securitySchemes;
    }

    public SecurityScheme getSecurityScheme(ObjectNode node, String location, ParseResult result) {
        Map<String, Object> extensions;
        ObjectNode flowsObject;
        if (node == null) {
            return null;
        }
        SecurityScheme securityScheme = new SecurityScheme();
        JsonNode ref = node.get("$ref");
        if (ref != null) {
            if (ref.getNodeType().equals((Object)JsonNodeType.STRING)) {
                String mungedRef = this.mungedRef(ref.textValue());
                if (mungedRef != null) {
                    securityScheme.set$ref(mungedRef);
                } else {
                    securityScheme.set$ref(ref.textValue());
                }
                return securityScheme;
            }
            result.invalidType(location, "$ref", "string", (JsonNode)node);
            return null;
        }
        boolean openIdConnectRequired = false;
        boolean flowsRequired = false;
        boolean schemeRequired = false;
        boolean inRequired = false;
        boolean nameRequired = false;
        boolean bearerFormatRequired = false;
        boolean descriptionRequired = false;
        String value = this.getString("type", node, true, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            if (SecurityScheme.Type.APIKEY.toString().equals(value)) {
                securityScheme.setType(SecurityScheme.Type.APIKEY);
                inRequired = true;
                nameRequired = true;
            } else if (SecurityScheme.Type.HTTP.toString().equals(value)) {
                securityScheme.setType(SecurityScheme.Type.HTTP);
                schemeRequired = true;
            } else if (SecurityScheme.Type.OAUTH2.toString().equals(value)) {
                securityScheme.setType(SecurityScheme.Type.OAUTH2);
                flowsRequired = true;
            } else if (SecurityScheme.Type.OPENIDCONNECT.toString().equals(value)) {
                securityScheme.setType(SecurityScheme.Type.OPENIDCONNECT);
                openIdConnectRequired = true;
            } else {
                result.invalidType(location + ".type", "type", "http|apiKey|oauth2|openIdConnect ", (JsonNode)node);
            }
        }
        value = this.getString("description", node, descriptionRequired, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            securityScheme.setDescription(value);
        }
        value = this.getString("name", node, nameRequired, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            securityScheme.setName(value);
        }
        String securitySchemeIn = this.getString("in", node, inRequired, location, result);
        Optional<SecurityScheme.In> matchingIn = Arrays.stream(SecurityScheme.In.values()).filter(in -> in.toString().equals(securitySchemeIn)).findFirst();
        securityScheme.setIn((SecurityScheme.In)matchingIn.orElse(null));
        value = this.getString("scheme", node, schemeRequired, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            securityScheme.setScheme(value);
        }
        value = this.getString("bearerFormat", node, bearerFormatRequired, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            securityScheme.setBearerFormat(value);
        }
        if ((flowsObject = this.getObject("flows", node, flowsRequired, location, result)) != null) {
            securityScheme.setFlows(this.getOAuthFlows(flowsObject, location, result));
        }
        value = this.getString("openIdConnectUrl", node, openIdConnectRequired, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            securityScheme.setOpenIdConnectUrl(value);
        }
        if ((extensions = this.getExtensions(node)) != null && extensions.size() > 0) {
            securityScheme.setExtensions(extensions);
        }
        Set<String> securitySchemeKeys = this.getKeys(node);
        for (String key : securitySchemeKeys) {
            if (SECURITY_SCHEME_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, node.get(key));
        }
        return securityScheme;
    }

    public OAuthFlows getOAuthFlows(ObjectNode node, String location, ParseResult result) {
        Map<String, Object> extensions;
        if (node == null) {
            return null;
        }
        OAuthFlows oAuthFlows = new OAuthFlows();
        ObjectNode objectNode = this.getObject("implicit", node, false, location, result);
        if (objectNode != null) {
            oAuthFlows.setImplicit(this.getOAuthFlow("implicit", objectNode, location, result));
        }
        if ((objectNode = this.getObject("password", node, false, location, result)) != null) {
            oAuthFlows.setPassword(this.getOAuthFlow("password", objectNode, location, result));
        }
        if ((objectNode = this.getObject("clientCredentials", node, false, location, result)) != null) {
            oAuthFlows.setClientCredentials(this.getOAuthFlow("clientCredentials", objectNode, location, result));
        }
        if ((objectNode = this.getObject("authorizationCode", node, false, location, result)) != null) {
            oAuthFlows.setAuthorizationCode(this.getOAuthFlow("authorizationCode", objectNode, location, result));
        }
        if ((extensions = this.getExtensions(node)) != null && extensions.size() > 0) {
            oAuthFlows.setExtensions(extensions);
        }
        Set<String> oAuthFlowKeys = this.getKeys(node);
        for (String key : oAuthFlowKeys) {
            if (OAUTHFLOWS_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, node.get(key));
        }
        return oAuthFlows;
    }

    public OAuthFlow getOAuthFlow(String oAuthFlowType, ObjectNode node, String location, ParseResult result) {
        if (node == null) {
            return null;
        }
        OAuthFlow oAuthFlow = new OAuthFlow();
        boolean refreshUrlRequired = false;
        boolean tokenUrlRequired = false;
        boolean authorizationUrlRequired = false;
        boolean scopesRequired = true;
        switch (oAuthFlowType) {
            case "implicit": {
                authorizationUrlRequired = true;
                break;
            }
            case "password": {
                tokenUrlRequired = true;
                break;
            }
            case "clientCredentials": {
                tokenUrlRequired = true;
                break;
            }
            case "authorizationCode": {
                tokenUrlRequired = true;
                authorizationUrlRequired = true;
            }
        }
        String value = this.getString("authorizationUrl", node, authorizationUrlRequired, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            oAuthFlow.setAuthorizationUrl(value);
        }
        value = this.getString("tokenUrl", node, tokenUrlRequired, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            oAuthFlow.setTokenUrl(value);
        }
        value = this.getString("refreshUrl", node, refreshUrlRequired, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            oAuthFlow.setRefreshUrl(value);
        }
        ObjectNode scopesObject = this.getObject("scopes", node, scopesRequired, location, result);
        Scopes scope = new Scopes();
        Set<String> keys = this.getKeys(scopesObject);
        for (String name : keys) {
            JsonNode scopeValue = scopesObject.get(name);
            if (scopesObject == null) continue;
            scope.addString(name, scopeValue.asText());
        }
        oAuthFlow.setScopes(scope);
        Map<String, Object> extensions = this.getExtensions(node);
        if (extensions != null && extensions.size() > 0) {
            oAuthFlow.setExtensions(extensions);
        }
        Set<String> oAuthFlowKeys = this.getKeys(node);
        for (String key : oAuthFlowKeys) {
            if (OAUTHFLOW_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, node.get(key));
        }
        return oAuthFlow;
    }

    public Map<String, Schema> getSchemas(ObjectNode obj, String location, ParseResult result, boolean underComponents) {
        if (obj == null) {
            return null;
        }
        LinkedHashMap<String, Schema> schemas = new LinkedHashMap<String, Schema>();
        Set<String> schemaKeys = this.getKeys(obj);
        for (String schemaName : schemaKeys) {
            JsonNode schemaValue;
            if (underComponents && !Pattern.matches("^[a-zA-Z0-9\\.\\-_]+$", schemaName)) {
                result.warning(location, "Schema name " + schemaName + " doesn't adhere to regular expression ^[a-zA-Z0-9\\.\\-_]+$");
            }
            if (!(schemaValue = obj.get(schemaName)).getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                result.invalidType(location, schemaName, "object", schemaValue);
                continue;
            }
            ObjectNode schema = (ObjectNode)schemaValue;
            Schema schemaObj = this.getSchema(schema, String.format("%s.%s", location, schemaName), result);
            if (schemaObj == null) continue;
            schemas.put(schemaName, schemaObj);
        }
        return schemas;
    }

    public Discriminator getDiscriminator(ObjectNode node, String location, ParseResult result) {
        ObjectNode mappingNode;
        Discriminator discriminator = new Discriminator();
        String value = this.getString("propertyName", node, true, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            discriminator.setPropertyName(value);
        }
        if ((mappingNode = this.getObject("mapping", node, false, location, result)) != null) {
            LinkedHashMap<String, String> mapping = new LinkedHashMap<String, String>();
            Set<String> keys = this.getKeys(mappingNode);
            for (String key : keys) {
                mapping.put(key, mappingNode.get(key).asText());
            }
            discriminator.setMapping(mapping);
        }
        return discriminator;
    }

    public Schema getSchema(ObjectNode node, String location, ParseResult result) {
        Map<String, Object> extensions;
        Object example;
        ExternalDocumentation docs;
        ObjectNode externalDocs;
        XML xml;
        ObjectNode xmlNode;
        Schema not;
        ObjectNode notObj;
        ArrayNode enumArray;
        ArrayNode required;
        Integer integer;
        Boolean bool;
        BigDecimal bigDecimal;
        ObjectNode discriminatorNode;
        JsonNode ref;
        Boolean additionalProperties;
        Boolean additionalPropertiesBoolean;
        if (node == null) {
            return null;
        }
        if (result == null) {
            result = new ParseResult();
            result.setAllowEmptyStrings(true);
        }
        ComposedSchema schema = null;
        ArrayNode oneOfArray = this.getArray("oneOf", node, false, location, result);
        ArrayNode allOfArray = this.getArray("allOf", node, false, location, result);
        ArrayNode anyOfArray = this.getArray("anyOf", node, false, location, result);
        ObjectNode itemsNode = this.getObject("items", node, false, location, result);
        if (allOfArray != null || anyOfArray != null || oneOfArray != null) {
            ComposedSchema composedSchema = new ComposedSchema();
            if (allOfArray != null) {
                for (JsonNode n : allOfArray) {
                    if (!n.isObject()) continue;
                    schema = this.getSchema((ObjectNode)n, location, result);
                    composedSchema.addAllOfItem((Schema)schema);
                }
                schema = composedSchema;
            }
            if (anyOfArray != null) {
                for (JsonNode n : anyOfArray) {
                    if (!n.isObject()) continue;
                    schema = this.getSchema((ObjectNode)n, location, result);
                    composedSchema.addAnyOfItem((Schema)schema);
                }
                schema = composedSchema;
            }
            if (oneOfArray != null) {
                for (JsonNode n : oneOfArray) {
                    if (!n.isObject()) continue;
                    schema = this.getSchema((ObjectNode)n, location, result);
                    composedSchema.addOneOfItem((Schema)schema);
                }
                schema = composedSchema;
            }
        }
        if (itemsNode != null) {
            ArraySchema items = new ArraySchema();
            if (itemsNode.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                items.setItems(this.getSchema(itemsNode, location, result));
            } else if (itemsNode.getNodeType().equals((Object)JsonNodeType.ARRAY)) {
                for (JsonNode n : itemsNode) {
                    if (!n.isValueNode()) continue;
                    items.setItems(this.getSchema(itemsNode, location, result));
                }
            }
            schema = items;
        }
        ObjectNode additionalPropertiesObject = (additionalPropertiesBoolean = this.getBoolean("additionalProperties", node, false, location, result)) == null ? this.getObject("additionalProperties", node, false, location, result) : null;
        Boolean bl = additionalProperties = additionalPropertiesObject != null ? this.getSchema(additionalPropertiesObject, location, result) : additionalPropertiesBoolean;
        if (additionalProperties != null) {
            if (schema == null) {
                schema = ((Object)additionalProperties).equals(Boolean.FALSE) ? new ObjectSchema() : new MapSchema();
            }
            schema.setAdditionalProperties((Object)additionalProperties);
        }
        if (schema == null) {
            schema = SchemaTypeUtil.createSchemaByType(node);
        }
        if ((ref = node.get("$ref")) != null) {
            if (ref.getNodeType().equals((Object)JsonNodeType.STRING)) {
                String mungedRef;
                if (location.startsWith("paths")) {
                    try {
                        String[] childComponents;
                        String[] newChildComponents;
                        boolean isValidComponent;
                        String[] components = ref.asText().split("#/components");
                        if (ref.asText().startsWith("#/components") && components.length > 1 && !(isValidComponent = ReferenceValidator.valueOf((newChildComponents = Arrays.copyOfRange(childComponents = components[1].split("/"), 1, childComponents.length))[0]).validateComponent(this.components, newChildComponents[1]))) {
                            result.missing(location, ref.asText());
                        }
                    }
                    catch (Exception e) {
                        result.missing(location, ref.asText());
                    }
                }
                if ((mungedRef = this.mungedRef(ref.textValue())) != null) {
                    schema.set$ref(mungedRef);
                } else {
                    schema.set$ref(ref.asText());
                }
                if (schema.get$ref().startsWith("#/components/schemas")) {
                    String refName = schema.get$ref().substring(schema.get$ref().lastIndexOf("/") + 1);
                    this.localSchemaRefs.put(refName, location);
                }
                return schema;
            }
            result.invalidType(location, "$ref", "string", (JsonNode)node);
            return null;
        }
        String value = this.getString("title", node, false, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            schema.setTitle(value);
        }
        if ((discriminatorNode = this.getObject("discriminator", node, false, location, result)) != null) {
            schema.setDiscriminator(this.getDiscriminator(discriminatorNode, location, result));
        }
        if ((bigDecimal = this.getBigDecimal("multipleOf", node, false, location, result)) != null) {
            if (bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
                schema.setMultipleOf(bigDecimal);
            } else {
                result.warning(location, "multipleOf value must be > 0");
            }
        }
        if ((bigDecimal = this.getBigDecimal("maximum", node, false, location, result)) != null) {
            schema.setMaximum(bigDecimal);
        }
        if ((bool = this.getBoolean("exclusiveMaximum", node, false, location, result)) != null) {
            schema.setExclusiveMaximum(bool);
        }
        if ((bigDecimal = this.getBigDecimal("minimum", node, false, location, result)) != null) {
            schema.setMinimum(bigDecimal);
        }
        if ((bool = this.getBoolean("exclusiveMinimum", node, false, location, result)) != null) {
            schema.setExclusiveMinimum(bool);
        }
        if ((integer = this.getInteger("minLength", node, false, location, result)) != null) {
            schema.setMinLength(integer);
        }
        if ((integer = this.getInteger("maxLength", node, false, location, result)) != null) {
            schema.setMaxLength(integer);
        }
        String pattern = this.getString("pattern", node, false, location, result);
        if (result.isAllowEmptyStrings() && pattern != null) {
            schema.setPattern(pattern);
        }
        if ((integer = this.getInteger("maxItems", node, false, location, result)) != null) {
            schema.setMaxItems(integer);
        }
        if ((integer = this.getInteger("minItems", node, false, location, result)) != null) {
            schema.setMinItems(integer);
        }
        if ((bool = this.getBoolean("uniqueItems", node, false, location, result)) != null) {
            schema.setUniqueItems(bool);
        }
        if ((integer = this.getInteger("maxProperties", node, false, location, result)) != null) {
            schema.setMaxProperties(integer);
        }
        if ((integer = this.getInteger("minProperties", node, false, location, result)) != null) {
            schema.setMinProperties(integer);
        }
        if ((required = this.getArray("required", node, false, location, result)) != null) {
            ArrayList<String> requiredList = new ArrayList<String>();
            for (JsonNode n : required) {
                if (n.getNodeType().equals((Object)JsonNodeType.STRING)) {
                    requiredList.add(((TextNode)n).textValue());
                    continue;
                }
                result.invalidType(location, "required", "string", n);
            }
            if (requiredList.size() > 0) {
                schema.setRequired(requiredList);
            }
        }
        if ((enumArray = this.getArray("enum", node, false, location, result)) != null) {
            for (JsonNode n : enumArray) {
                if (n.isNumber()) {
                    schema.addEnumItemObject((Object)n.numberValue());
                    continue;
                }
                if (n.isBoolean()) {
                    schema.addEnumItemObject((Object)n.booleanValue());
                    continue;
                }
                if (n.isValueNode()) {
                    try {
                        schema.addEnumItemObject(this.getDecodedObject((Schema)schema, n.asText(null)));
                    }
                    catch (ParseException e) {
                        result.invalidType(location, String.format("enum=`%s`", e.getMessage()), schema.getFormat(), n);
                    }
                    continue;
                }
                if (n.isContainerNode()) {
                    schema.addEnumItemObject((Object)(n.isNull() ? null : n));
                    continue;
                }
                result.invalidType(location, "enum", "value", n);
            }
        }
        value = this.getString("type", node, false, location, result);
        if (StringUtils.isBlank((CharSequence)schema.getType())) {
            if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
                schema.setType(value);
            } else {
                JsonNode enumNode = node.get("enum");
                if (enumNode != null && enumNode.isArray()) {
                    String type = this.inferTypeFromArray((ArrayNode)enumNode);
                    schema.setType(type);
                }
            }
            if ("array".equals(schema.getType()) && (!(schema instanceof ArraySchema) || ((ArraySchema)schema).getItems() == null)) {
                result.missing(location, "items");
            }
        }
        if ((notObj = this.getObject("not", node, false, location, result)) != null && (not = this.getSchema(notObj, location, result)) != null) {
            schema.setNot(not);
        }
        LinkedHashMap<String, Schema> properties = new LinkedHashMap<String, Schema>();
        ObjectNode propertiesObj = this.getObject("properties", node, false, location, result);
        Schema property = null;
        Set<String> keys = this.getKeys(propertiesObj);
        for (String name : keys) {
            JsonNode propertyValue = propertiesObj.get(name);
            if (!propertyValue.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                result.invalidType(location, "properties", "object", propertyValue);
                continue;
            }
            if (propertiesObj == null || (property = this.getSchema((ObjectNode)propertyValue, location, result)) == null) continue;
            properties.put(name, property);
        }
        if (propertiesObj != null) {
            schema.setProperties(properties);
        }
        value = this.getString("description", node, false, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            schema.setDescription(value);
        }
        value = this.getString("format", node, false, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            schema.setFormat(value);
        }
        if (node.get("default") != null && !StringUtils.isBlank((CharSequence)schema.getType())) {
            Number number;
            if (schema.getType().equals("array")) {
                ArrayNode array = this.getArray("default", node, false, location, result);
                if (array != null) {
                    schema.setDefault((Object)array);
                }
            } else if (schema.getType().equals("string")) {
                value = this.getString("default", node, false, location, result);
                if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
                    try {
                        schema.setDefault(this.getDecodedObject((Schema)schema, value));
                    }
                    catch (ParseException e) {
                        result.invalidType(location, String.format("default=`%s`", e.getMessage()), schema.getFormat(), (JsonNode)node);
                    }
                }
            } else if (schema.getType().equals("boolean")) {
                bool = this.getBoolean("default", node, false, location, result);
                if (bool != null) {
                    schema.setDefault((Object)bool);
                }
            } else if (schema.getType().equals("object")) {
                ObjectNode object = this.getObject("default", node, false, location, result);
                if (object != null) {
                    schema.setDefault((Object)object);
                }
            } else if (schema.getType().equals("integer")) {
                number = this.getInteger("default", node, false, location, result);
                if (number != null) {
                    schema.setDefault((Object)number);
                }
            } else if (schema.getType().equals("number") && (number = this.getBigDecimal("default", node, false, location, result)) != null) {
                schema.setDefault((Object)number);
            }
        }
        if ((bool = this.getBoolean("nullable", node, false, location, result)) != null) {
            schema.setNullable(bool);
        }
        if ((bool = this.getBoolean("readOnly", node, false, location, result)) != null) {
            schema.setReadOnly(bool);
        }
        if ((bool = this.getBoolean("writeOnly", node, false, location, result)) != null) {
            schema.setWriteOnly(bool);
        }
        if ((bool = Boolean.valueOf(Optional.ofNullable(this.getBoolean("writeOnly", node, false, location, result)).orElse(false) != false && Optional.ofNullable(this.getBoolean("readOnly", node, false, location, result)).orElse(false) != false)).booleanValue()) {
            result.warning(location, " writeOnly and readOnly are both present");
        }
        if ((xmlNode = this.getObject("xml", node, false, location, result)) != null && (xml = this.getXml(xmlNode, location, result)) != null) {
            schema.setXml(xml);
        }
        if ((externalDocs = this.getObject("externalDocs", node, false, location, result)) != null && (docs = this.getExternalDocs(externalDocs, location, result)) != null) {
            schema.setExternalDocs(docs);
        }
        if ((example = this.getAnyExample("example", node, location, result)) != null) {
            schema.setExample(example instanceof NullNode ? null : example);
        }
        if ((bool = this.getBoolean("deprecated", node, false, location, result)) != null) {
            schema.setDeprecated(bool);
        }
        if ((extensions = this.getExtensions(node)) != null && extensions.size() > 0) {
            schema.setExtensions(extensions);
        }
        Set<String> schemaKeys = this.getKeys(node);
        for (String key : schemaKeys) {
            if (SCHEMA_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, node.get(key));
        }
        return schema;
    }

    private Object getDecodedObject(Schema schema, String objectString) throws ParseException {
        Date object;
        Comparable<Comparable<OffsetDateTime>> comparable = objectString == null ? null : (schema.getClass().equals(DateSchema.class) ? this.toDate(objectString) : (schema.getClass().equals(DateTimeSchema.class) ? this.toDateTime(objectString) : (object = schema.getClass().equals(ByteArraySchema.class) ? (Comparable<Comparable<OffsetDateTime>>)this.toBytes(objectString) : objectString)));
        if (object == null && objectString != null) {
            throw new ParseException(objectString, 0);
        }
        return object;
    }

    private OffsetDateTime toDateTime(String dateString) {
        OffsetDateTime dateTime = null;
        try {
            dateTime = OffsetDateTime.parse(dateString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dateTime;
    }

    private Date toDate(String dateString) {
        Matcher matcher = RFC3339_DATE_PATTERN.matcher(dateString);
        Date date = null;
        if (matcher.matches()) {
            String year = matcher.group(1);
            String month = matcher.group(2);
            String day = matcher.group(3);
            try {
                date = new Calendar.Builder().setDate(Integer.parseInt(year), Integer.parseInt(month) - 1, Integer.parseInt(day)).build().getTime();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return date;
    }

    private byte[] toBytes(String byteString) {
        byte[] bytes;
        try {
            bytes = Base64.getDecoder().decode(byteString);
        }
        catch (Exception e) {
            bytes = null;
        }
        return bytes;
    }

    public Map<String, Example> getExamples(ObjectNode obj, String location, ParseResult result, boolean underComponents) {
        if (obj == null) {
            return null;
        }
        LinkedHashMap<String, Example> examples = new LinkedHashMap<String, Example>();
        Set<String> exampleKeys = this.getKeys(obj);
        for (String exampleName : exampleKeys) {
            Example exampleObj;
            JsonNode exampleValue;
            if (underComponents && !Pattern.matches("^[a-zA-Z0-9\\.\\-_]+$", exampleName)) {
                result.warning(location, "Example name " + exampleName + " doesn't adhere to regular expression ^[a-zA-Z0-9\\.\\-_]+$");
            }
            if (!(exampleValue = obj.get(exampleName)).getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                result.invalidType(location, exampleName, "object", exampleValue);
                continue;
            }
            ObjectNode example = (ObjectNode)exampleValue;
            if (example == null || (exampleObj = this.getExample(example, String.format("%s.%s", location, exampleName), result)) == null) continue;
            examples.put(exampleName, exampleObj);
        }
        return examples;
    }

    public List<Example> getExampleList(ArrayNode obj, String location, ParseResult result) {
        ArrayList<Example> examples = new ArrayList<Example>();
        if (obj == null) {
            return examples;
        }
        for (JsonNode item : obj) {
            Example example;
            if (!item.getNodeType().equals((Object)JsonNodeType.OBJECT) || (example = this.getExample((ObjectNode)item, location, result)) == null) continue;
            examples.add(example);
        }
        return examples;
    }

    public Example getExample(ObjectNode node, String location, ParseResult result) {
        Map<String, Object> extensions;
        Object sample;
        if (node == null) {
            return null;
        }
        Example example = new Example();
        JsonNode ref = node.get("$ref");
        if (ref != null) {
            if (ref.getNodeType().equals((Object)JsonNodeType.STRING)) {
                String mungedRef = this.mungedRef(ref.textValue());
                if (mungedRef != null) {
                    example.set$ref(mungedRef);
                } else {
                    example.set$ref(ref.textValue());
                }
                return example;
            }
            result.invalidType(location, "$ref", "string", (JsonNode)node);
            return null;
        }
        String value = this.getString("summary", node, false, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            example.setSummary(value);
        }
        value = this.getString("description", node, false, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            example.setDescription(value);
        }
        if ((sample = this.getAnyExample("value", node, location, result)) != null) {
            example.setValue(sample instanceof NullNode ? null : sample);
        }
        value = this.getString("externalValue", node, false, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            example.setExternalValue(value);
        }
        if (sample != null && value != null) {
            result.warning(location, " value and externalValue are both present");
        }
        if ((extensions = this.getExtensions(node)) != null && extensions.size() > 0) {
            example.setExtensions(extensions);
        }
        Set<String> keys = this.getKeys(node);
        for (String key : keys) {
            if (EXAMPLE_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, node.get(key));
        }
        return example;
    }

    public void setStyle(String value, Parameter parameter, String location, ObjectNode obj, ParseResult result) {
        if (StringUtils.isBlank((CharSequence)value)) {
            if (QUERY_PARAMETER.equals(parameter.getIn()) || COOKIE_PARAMETER.equals(parameter.getIn())) {
                parameter.setStyle(Parameter.StyleEnum.FORM);
            } else if (PATH_PARAMETER.equals(parameter.getIn()) || HEADER_PARAMETER.equals(parameter.getIn())) {
                parameter.setStyle(Parameter.StyleEnum.SIMPLE);
            }
        } else if (value.equals(Parameter.StyleEnum.FORM.toString())) {
            parameter.setStyle(Parameter.StyleEnum.FORM);
        } else if (value.equals(Parameter.StyleEnum.DEEPOBJECT.toString())) {
            parameter.setStyle(Parameter.StyleEnum.DEEPOBJECT);
        } else if (value.equals(Parameter.StyleEnum.LABEL.toString())) {
            parameter.setStyle(Parameter.StyleEnum.LABEL);
        } else if (value.equals(Parameter.StyleEnum.MATRIX.toString())) {
            parameter.setStyle(Parameter.StyleEnum.MATRIX);
        } else if (value.equals(Parameter.StyleEnum.PIPEDELIMITED.toString())) {
            parameter.setStyle(Parameter.StyleEnum.PIPEDELIMITED);
        } else if (value.equals(Parameter.StyleEnum.SIMPLE.toString())) {
            parameter.setStyle(Parameter.StyleEnum.SIMPLE);
        } else if (value.equals(Parameter.StyleEnum.SPACEDELIMITED.toString())) {
            parameter.setStyle(Parameter.StyleEnum.SPACEDELIMITED);
        } else {
            result.invalidType(location, "style", "StyleEnum", (JsonNode)obj);
        }
    }

    public ApiResponses getResponses(ObjectNode node, String location, ParseResult result, boolean underComponents) {
        if (node == null) {
            return null;
        }
        ApiResponses apiResponses = new ApiResponses();
        Set<String> keys = this.getKeys(node);
        for (String key : keys) {
            ApiResponse response;
            if (underComponents && !Pattern.matches("^[a-zA-Z0-9\\.\\-_]+$", key)) {
                result.warning(location, "Response key " + key + " doesn't adhere to regular expression ^[a-zA-Z0-9\\.\\-_]+$");
            }
            if (key.startsWith("x-")) {
                Map<String, Object> extensions = this.getExtensions(node);
                if (extensions == null || extensions.size() <= 0) continue;
                apiResponses.setExtensions(extensions);
                continue;
            }
            ObjectNode obj = this.getObject(key, node, false, location, result);
            if (obj == null || (response = this.getResponse(obj, String.format("%s.%s", location, key), result)) == null) continue;
            apiResponses.put((Object)key, (Object)response);
        }
        return apiResponses;
    }

    public ApiResponse getResponse(ObjectNode node, String location, ParseResult result) {
        Map<String, Object> extensions;
        ObjectNode contentObject;
        Map<String, Link> links;
        ObjectNode linksObj;
        Map<String, Header> headers;
        ObjectNode headerObject;
        if (node == null) {
            return null;
        }
        ApiResponse apiResponse = new ApiResponse();
        JsonNode ref = node.get("$ref");
        if (ref != null) {
            if (ref.getNodeType().equals((Object)JsonNodeType.STRING)) {
                String mungedRef = this.mungedRef(ref.textValue());
                if (mungedRef != null) {
                    apiResponse.set$ref(mungedRef);
                } else {
                    apiResponse.set$ref(ref.textValue());
                }
                return apiResponse;
            }
            result.invalidType(location, "$ref", "string", (JsonNode)node);
            return null;
        }
        String value = this.getString("description", node, true, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            apiResponse.description(value);
        }
        if ((headerObject = this.getObject("headers", node, false, location, result)) != null && (headers = this.getHeaders(headerObject, location, result, false)) != null && headers.size() > 0) {
            apiResponse.setHeaders(headers);
        }
        if ((linksObj = this.getObject("links", node, false, location, result)) != null && (links = this.getLinks(linksObj, location, result, false)) != null && links.size() > 0) {
            apiResponse.setLinks(links);
        }
        if ((contentObject = this.getObject("content", node, false, location, result)) != null) {
            apiResponse.setContent(this.getContent(contentObject, String.format("%s.%s", location, "content"), result));
        }
        if ((extensions = this.getExtensions(node)) != null && extensions.size() > 0) {
            apiResponse.setExtensions(extensions);
        }
        Set<String> keys = this.getKeys(node);
        for (String key : keys) {
            if (RESPONSE_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, node.get(key));
        }
        return apiResponse;
    }

    public List<String> getTagsStrings(ArrayNode nodes, String location, ParseResult result) {
        if (nodes == null) {
            return null;
        }
        ArrayList<String> tags = new ArrayList<String>();
        for (JsonNode node : nodes) {
            if (!node.getNodeType().equals((Object)JsonNodeType.STRING)) continue;
            tags.add(node.textValue());
        }
        return tags;
    }

    public Operation getOperation(ObjectNode obj, String location, ParseResult result) {
        Map<String, Object> extensions;
        Boolean deprecated;
        ObjectNode callbacksNode;
        Map<String, Callback> callbacks;
        ObjectNode responsesNode;
        ApiResponses responses;
        ObjectNode requestObjectNode;
        ArrayNode parameters;
        ObjectNode externalDocs;
        ExternalDocumentation docs;
        if (obj == null) {
            return null;
        }
        Operation operation = new Operation();
        ArrayNode array = this.getArray("tags", obj, false, location, result);
        List<String> tags = this.getTagsStrings(array, String.format("%s.%s", location, "tags"), result);
        if (tags != null) {
            operation.setTags(tags);
        }
        String value = this.getString("summary", obj, false, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            operation.setSummary(value);
        }
        value = this.getString("description", obj, false, location, result);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            operation.setDescription(value);
        }
        if ((docs = this.getExternalDocs(externalDocs = this.getObject("externalDocs", obj, false, location, result), String.format("%s.%s", location, "externalDocs"), result)) != null) {
            operation.setExternalDocs(docs);
        }
        value = this.getString("operationId", obj, false, location, result, this.operationIDs);
        if (result.isAllowEmptyStrings() && value != null || !result.isAllowEmptyStrings() && !StringUtils.isBlank((CharSequence)value)) {
            operation.operationId(value);
        }
        if ((parameters = this.getArray("parameters", obj, false, location, result)) != null) {
            operation.setParameters(this.getParameterList(parameters, String.format("%s.%s", location, "parameters"), result));
        }
        if ((requestObjectNode = this.getObject("requestBody", obj, false, location, result)) != null) {
            operation.setRequestBody(this.getRequestBody(requestObjectNode, String.format("%s.%s", location, "requestBody"), result));
        }
        if ((responses = this.getResponses(responsesNode = this.getObject("responses", obj, true, location, result), String.format("%s.%s", location, "responses"), result, false)) != null) {
            operation.setResponses(responses);
        }
        if ((callbacks = this.getCallbacks(callbacksNode = this.getObject("callbacks", obj, false, location, result), String.format("%s.%s", location, "callbacks"), result, false)) != null) {
            operation.setCallbacks(callbacks);
        }
        if ((deprecated = this.getBoolean("deprecated", obj, false, location, result)) != null) {
            operation.setDeprecated(deprecated);
        }
        if ((array = this.getArray("servers", obj, false, location, result)) != null && array.size() > 0) {
            operation.setServers(this.getServersList(array, String.format("%s.%s", location, "servers"), result));
        }
        if ((array = this.getArray("security", obj, false, location, result)) != null) {
            operation.setSecurity(this.getSecurityRequirementsList(array, String.format("%s.%s", location, "security"), result));
        }
        if ((extensions = this.getExtensions(obj)) != null && extensions.size() > 0) {
            operation.setExtensions(extensions);
        }
        Set<String> keys = this.getKeys(obj);
        for (String key : keys) {
            if (OPERATION_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, obj.get(key));
        }
        return operation;
    }

    public List<SecurityRequirement> getSecurityRequirementsList(ArrayNode nodes, String location, ParseResult result) {
        if (nodes == null) {
            return null;
        }
        ArrayList<SecurityRequirement> securityRequirements = new ArrayList<SecurityRequirement>();
        for (JsonNode node : nodes) {
            if (!node.getNodeType().equals((Object)JsonNodeType.OBJECT)) continue;
            SecurityRequirement securityRequirement = new SecurityRequirement();
            Set<String> keys = this.getKeys((ObjectNode)node);
            if (keys.size() == 0) {
                securityRequirements.add(securityRequirement);
                continue;
            }
            for (String key : keys) {
                if (key == null) continue;
                JsonNode value = node.get(key);
                if (key == null || !JsonNodeType.ARRAY.equals((Object)value.getNodeType())) continue;
                ArrayNode arrayNode = (ArrayNode)value;
                List scopes = Stream.generate(arrayNode.elements()::next).map(n -> n.asText()).limit(arrayNode.size()).collect(Collectors.toList());
                securityRequirement.addList(key, scopes);
            }
            if (securityRequirement.size() <= 0) continue;
            securityRequirements.add(securityRequirement);
        }
        return securityRequirements;
    }

    public Map<String, RequestBody> getRequestBodies(ObjectNode obj, String location, ParseResult result, boolean underComponents) {
        if (obj == null) {
            return null;
        }
        LinkedHashMap<String, RequestBody> bodies = new LinkedHashMap<String, RequestBody>();
        Set<String> bodyKeys = this.getKeys(obj);
        for (String bodyName : bodyKeys) {
            JsonNode bodyValue;
            if (underComponents && !Pattern.matches("^[a-zA-Z0-9\\.\\-_]+$", bodyName)) {
                result.warning(location, "RequestBody name " + bodyName + " doesn't adhere to regular expression ^[a-zA-Z0-9\\.\\-_]+$");
            }
            if (!(bodyValue = obj.get(bodyName)).getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                result.invalidType(location, bodyName, "object", bodyValue);
                continue;
            }
            ObjectNode bodyObj = (ObjectNode)bodyValue;
            RequestBody body = this.getRequestBody(bodyObj, String.format("%s.%s", location, bodyName), result);
            if (body == null) continue;
            bodies.put(bodyName, body);
        }
        return bodies;
    }

    public RequestBody getRequestBody(ObjectNode node, String location, ParseResult result) {
        ObjectNode contentNode;
        Content content;
        Boolean required;
        if (node == null) {
            return null;
        }
        RequestBody body = new RequestBody();
        JsonNode ref = node.get("$ref");
        if (ref != null) {
            if (ref.getNodeType().equals((Object)JsonNodeType.STRING)) {
                String mungedRef = this.mungedRef(ref.textValue());
                if (mungedRef != null) {
                    body.set$ref(mungedRef);
                } else {
                    body.set$ref(ref.textValue());
                }
                return body;
            }
            result.invalidType(location, "$ref", "string", (JsonNode)node);
            return null;
        }
        String description = this.getString("description", node, false, location, result);
        if (result.isAllowEmptyStrings() && description != null) {
            body.setDescription(description);
        }
        if ((required = this.getBoolean("required", node, false, location, result)) != null) {
            body.setRequired(required);
        }
        if ((content = this.getContent(contentNode = this.getObject("content", node, true, location, result), location + ".content", result)) != null && content.isEmpty()) {
            result.unsupported(location, "content with no media type", (JsonNode)contentNode);
            result.invalid();
        } else {
            body.setContent(content);
        }
        Map<String, Object> extensions = this.getExtensions(node);
        if (extensions != null && extensions.size() > 0) {
            body.setExtensions(extensions);
        }
        Set<String> keys = this.getKeys(node);
        for (String key : keys) {
            if (REQUEST_BODY_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, node.get(key));
        }
        return body;
    }

    public String inferTypeFromArray(ArrayNode an) {
        if (an.size() == 0) {
            return "string";
        }
        String type = null;
        for (int i = 0; i < an.size(); ++i) {
            JsonNode element = an.get(0);
            if (element.isBoolean()) {
                if (type == null) {
                    type = "boolean";
                    continue;
                }
                if ("boolean".equals(type)) continue;
                type = "string";
                continue;
            }
            if (element.isNumber()) {
                if (type == null) {
                    type = "number";
                    continue;
                }
                if ("number".equals(type)) continue;
                type = "string";
                continue;
            }
            type = "string";
        }
        return type;
    }

    protected static class Location {
        private String location;
        private String key;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Location)) {
                return false;
            }
            Location location1 = (Location)o;
            if (this.location != null ? !this.location.equals(location1.location) : location1.location != null) {
                return false;
            }
            return !(this.key == null ? location1.key != null : !this.key.equals(location1.key));
        }

        public int hashCode() {
            int result = this.location != null ? this.location.hashCode() : 0;
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            return result;
        }

        public Location(String location, String key) {
            this.location = location;
            this.key = key;
        }
    }

    public static class ParseResult {
        private boolean valid = true;
        private Map<Location, JsonNode> extra = new LinkedHashMap<Location, JsonNode>();
        private Map<Location, JsonNode> unsupported = new LinkedHashMap<Location, JsonNode>();
        private Map<Location, String> invalidType = new LinkedHashMap<Location, String>();
        private List<Location> missing = new ArrayList<Location>();
        private List<Location> warnings = new ArrayList<Location>();
        private List<Location> unique = new ArrayList<Location>();
        private List<Location> uniqueTags = new ArrayList<Location>();
        private boolean allowEmptyStrings = true;
        private boolean validateInternalRefs;

        public boolean isAllowEmptyStrings() {
            return this.allowEmptyStrings;
        }

        public void setAllowEmptyStrings(boolean allowEmptyStrings) {
            this.allowEmptyStrings = allowEmptyStrings;
        }

        public ParseResult allowEmptyStrings(boolean allowEmptyStrings) {
            this.allowEmptyStrings = allowEmptyStrings;
            return this;
        }

        public void unsupported(String location, String key, JsonNode value) {
            this.unsupported.put(new Location(location, key), value);
        }

        public void extra(String location, String key, JsonNode value) {
            this.extra.put(new Location(location, key), value);
        }

        public void missing(String location, String key) {
            this.missing.add(new Location(location, key));
        }

        public void warning(String location, String key) {
            this.warnings.add(new Location(location, key));
        }

        public void unique(String location, String key) {
            this.unique.add(new Location(location, key));
        }

        public void uniqueTags(String location, String key) {
            this.uniqueTags.add(new Location(location, key));
        }

        public void invalidType(String location, String key, String expectedType, JsonNode value) {
            this.invalidType.put(new Location(location, key), expectedType);
        }

        public void invalid() {
            this.valid = false;
        }

        public boolean isValid() {
            return this.valid;
        }

        public List<String> getMessages() {
            String message;
            String location;
            ArrayList<String> messages = new ArrayList<String>();
            for (Location l : this.extra.keySet()) {
                location = l.location.equals("") ? "" : l.location + ".";
                message = "attribute " + location + l.key + " is unexpected";
                messages.add(message);
            }
            for (Location l : this.invalidType.keySet()) {
                location = l.location.equals("") ? "" : l.location + ".";
                message = "attribute " + location + l.key + " is not of type `" + this.invalidType.get(l) + "`";
                messages.add(message);
            }
            for (Location l : this.missing) {
                location = l.location.equals("") ? "" : l.location + ".";
                message = "attribute " + location + l.key + " is missing";
                messages.add(message);
            }
            for (Location l : this.warnings) {
                location = l.location.equals("") ? "" : l.location + ".";
                message = "attribute " + location + l.key;
                messages.add(message);
            }
            for (Location l : this.unsupported.keySet()) {
                location = l.location.equals("") ? "" : l.location + ".";
                message = "attribute " + location + l.key + " is unsupported";
                messages.add(message);
            }
            for (Location l : this.unique) {
                location = l.location.equals("") ? "" : l.location + ".";
                message = "attribute " + location + l.key + " is repeated";
                messages.add(message);
            }
            for (Location l : this.uniqueTags) {
                location = l.location.equals("") ? "" : l.location + ".";
                message = "attribute " + location + l.key + " is repeated";
                messages.add(message);
            }
            return messages;
        }

        public void setValidateInternalRefs(boolean validateInternalRefs) {
            this.validateInternalRefs = validateInternalRefs;
        }

        public boolean isValidateInternalRefs() {
            return this.validateInternalRefs;
        }
    }
}

