/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.processors;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.parser.ResolverCache;
import io.swagger.v3.parser.models.RefFormat;
import io.swagger.v3.parser.processors.ExternalRefProcessor;
import io.swagger.v3.parser.processors.ParameterProcessor;
import io.swagger.v3.parser.processors.RequestBodyProcessor;
import io.swagger.v3.parser.processors.ResponseProcessor;
import io.swagger.v3.parser.util.RefUtils;
import java.util.List;
import java.util.Map;

public class OperationProcessor {
    private final ParameterProcessor parameterProcessor;
    private final RequestBodyProcessor requestBodyProcessor;
    private final ResponseProcessor responseProcessor;
    private final ExternalRefProcessor externalRefProcessor;
    private final ResolverCache cache;

    public OperationProcessor(ResolverCache cache, OpenAPI openAPI) {
        this.parameterProcessor = new ParameterProcessor(cache, openAPI);
        this.responseProcessor = new ResponseProcessor(cache, openAPI);
        this.requestBodyProcessor = new RequestBodyProcessor(cache, openAPI);
        this.externalRefProcessor = new ExternalRefProcessor(cache, openAPI);
        this.cache = cache;
    }

    public void processOperation(Operation operation) {
        Map callbacks;
        ApiResponses responses;
        RequestBody requestBody;
        List<Parameter> processedOperationParameters = this.parameterProcessor.processParameters(operation.getParameters());
        if (processedOperationParameters != null) {
            operation.setParameters(processedOperationParameters);
        }
        if ((requestBody = operation.getRequestBody()) != null) {
            this.requestBodyProcessor.processRequestBody(requestBody);
        }
        if ((responses = operation.getResponses()) != null) {
            for (String responseCode : responses.keySet()) {
                ApiResponse response = (ApiResponse)responses.get(responseCode);
                if (response == null) continue;
                if (response.get$ref() != null) {
                    this.responseProcessor.processResponse(response);
                    RefFormat refFormat = RefUtils.computeRefFormat(response.get$ref());
                    ApiResponse resolvedResponse = this.cache.loadRef(response.get$ref(), refFormat, ApiResponse.class);
                    if (resolvedResponse != null) {
                        response = resolvedResponse;
                        responses.put(responseCode, resolvedResponse);
                    }
                }
                this.responseProcessor.processResponse(response);
            }
        }
        if ((callbacks = operation.getCallbacks()) != null) {
            for (String name : callbacks.keySet()) {
                String newRef;
                String $ref;
                RefFormat refFormat;
                Callback callback = (Callback)callbacks.get(name);
                if (callback == null) continue;
                if (callback.get$ref() != null && RefUtils.isAnExternalRefFormat(refFormat = RefUtils.computeRefFormat($ref = callback.get$ref())) && (newRef = this.externalRefProcessor.processRefToExternalCallback($ref, refFormat)) != null) {
                    callback.set$ref(newRef);
                }
                for (String callbackName : callback.keySet()) {
                    PathItem pathItem = (PathItem)callback.get((Object)callbackName);
                    Map operationMap = pathItem.readOperationsMap();
                    for (PathItem.HttpMethod httpMethod : operationMap.keySet()) {
                        Operation op = (Operation)operationMap.get(httpMethod);
                        this.processOperation(op);
                    }
                    List parameters = pathItem.getParameters();
                    if (parameters == null) continue;
                    for (Parameter parameter : parameters) {
                        this.parameterProcessor.processParameter(parameter);
                    }
                }
            }
        }
    }
}

