/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.maven.plugin;

import io.swagger.codegen.v3.CliOption;
import io.swagger.codegen.v3.ClientOptInput;
import io.swagger.codegen.v3.CodegenArgument;
import io.swagger.codegen.v3.CodegenConfig;
import io.swagger.codegen.v3.DefaultGenerator;
import io.swagger.codegen.v3.config.CodegenConfigurator;
import io.swagger.codegen.v3.config.CodegenConfiguratorUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class CodeGenMojo
extends AbstractMojo {
    @Parameter(name="verbose", required=false, defaultValue="false")
    private boolean verbose;
    @Parameter(name="language", required=true)
    private String language;
    @Parameter(name="output", property="swagger.codegen.maven.plugin.output", defaultValue="${project.build.directory}/generated-sources/swagger")
    private File output;
    @Parameter(name="inputSpec", required=true)
    private String inputSpec;
    @Parameter(name="gitUserId", required=false)
    private String gitUserId;
    @Parameter(name="gitRepoId", required=false)
    private String gitRepoId;
    @Parameter(name="templateDirectory")
    private File templateDirectory;
    @Parameter(name="auth")
    private String auth;
    @Parameter(name="configurationFile", required=false)
    private String configurationFile;
    @Parameter(name="skipOverwrite", required=false)
    private Boolean skipOverwrite;
    @Parameter(name="removeOperationIdPrefix", required=false)
    private Boolean removeOperationIdPrefix;
    @Parameter(name="apiPackage")
    private String apiPackage;
    @Parameter(name="modelPackage")
    private String modelPackage;
    @Parameter(name="invokerPackage")
    private String invokerPackage;
    @Parameter(name="groupId")
    private String groupId;
    @Parameter(name="artifactId")
    private String artifactId;
    @Parameter(name="artifactVersion")
    private String artifactVersion;
    @Parameter(name="library", required=false)
    private String library;
    @Parameter(name="modelNamePrefix", required=false)
    private String modelNamePrefix;
    @Parameter(name="modelNameSuffix", required=false)
    private String modelNameSuffix;
    @Parameter(name="ignoreFileOverride", required=false)
    private String ignoreFileOverride;
    @Parameter(name="configOptions")
    private Map<?, ?> configOptions;
    @Parameter(name="instantiationTypes")
    private List<String> instantiationTypes;
    @Parameter(name="importMappings")
    private List<String> importMappings;
    @Parameter(name="typeMappings")
    private List<String> typeMappings;
    @Parameter(name="languageSpecificPrimitives")
    private List<String> languageSpecificPrimitives;
    @Parameter(name="additionalProperties")
    private List<String> additionalProperties;
    @Parameter(name="reservedWordsMappings")
    private List<String> reservedWordsMappings;
    @Parameter(name="generateApis", required=false)
    private Boolean generateApis = true;
    @Parameter(name="generateModels", required=false)
    private Boolean generateModels = true;
    @Parameter(name="modelsToGenerate", required=false)
    private String modelsToGenerate = "";
    @Parameter(name="generateSupportingFiles", required=false)
    private Boolean generateSupportingFiles = true;
    @Parameter(name="supportingFilesToGenerate", required=false)
    private String supportingFilesToGenerate = "";
    @Parameter(name="generateModelTests", required=false)
    private Boolean generateModelTests = true;
    @Parameter(name="generateModelDocumentation", required=false)
    private Boolean generateModelDocumentation = true;
    @Parameter(name="generateApiTests", required=false)
    private Boolean generateApiTests = true;
    @Parameter(name="generateApiDocumentation", required=false)
    private Boolean generateApiDocumentation = true;
    @Parameter(name="withXml", required=false)
    private Boolean withXml = false;
    @Parameter(name="skip", property="codegen.skip", required=false, defaultValue="false")
    private Boolean skip;
    @Parameter(defaultValue="true")
    private boolean addCompileSourceRoot = true;
    @Parameter
    protected Map<String, String> environmentVariables = new HashMap<String, String>();
    @Parameter
    protected Map<String, String> originalEnvironmentVariables = new HashMap<String, String>();
    @Parameter
    private boolean configHelp = false;
    @Parameter(readonly=true, required=true, defaultValue="${project}")
    private MavenProject project;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        Class<CodeGenMojo> clazz = CodeGenMojo.class;
        synchronized (CodeGenMojo.class) {
            this.execute_();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void execute_() throws MojoExecutionException {
        if (this.skip.booleanValue()) {
            this.getLog().info((CharSequence)"Code generation is skipped.");
            this.addCompileSourceRootIfConfigured();
            return;
        }
        CodegenConfigurator configurator = CodegenConfigurator.fromFile((String)this.configurationFile);
        if (configurator == null) {
            configurator = new CodegenConfigurator();
        }
        configurator.setVerbose(this.verbose);
        if (this.skipOverwrite != null) {
            configurator.setSkipOverwrite(this.skipOverwrite.booleanValue());
        }
        if (this.removeOperationIdPrefix != null) {
            configurator.setRemoveOperationIdPrefix(this.removeOperationIdPrefix.booleanValue());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.inputSpec)) {
            configurator.setInputSpecURL(this.inputSpec);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.gitUserId)) {
            configurator.setGitUserId(this.gitUserId);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.gitRepoId)) {
            configurator.setGitRepoId(this.gitRepoId);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.ignoreFileOverride)) {
            configurator.setIgnoreFileOverride(this.ignoreFileOverride);
        }
        configurator.setLang(this.language);
        configurator.setOutputDir(this.output.getAbsolutePath());
        if (StringUtils.isNotEmpty((CharSequence)this.auth)) {
            configurator.setAuth(this.auth);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.apiPackage)) {
            configurator.setApiPackage(this.apiPackage);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.modelPackage)) {
            configurator.setModelPackage(this.modelPackage);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.invokerPackage)) {
            configurator.setInvokerPackage(this.invokerPackage);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.groupId)) {
            configurator.setGroupId(this.groupId);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.artifactId)) {
            configurator.setArtifactId(this.artifactId);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.artifactVersion)) {
            configurator.setArtifactVersion(this.artifactVersion);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.library)) {
            configurator.setLibrary(this.library);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.modelNamePrefix)) {
            configurator.setModelNamePrefix(this.modelNamePrefix);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.modelNameSuffix)) {
            configurator.setModelNameSuffix(this.modelNameSuffix);
        }
        if (null != this.templateDirectory) {
            configurator.setTemplateDir(this.templateDirectory.getAbsolutePath());
        }
        if (null != this.generateApis && this.generateApis.booleanValue()) {
            System.setProperty("apis", "");
        } else {
            System.clearProperty("apis");
        }
        if (null != this.generateModels && this.generateModels.booleanValue()) {
            System.setProperty("models", this.modelsToGenerate);
        } else {
            System.clearProperty("models");
        }
        if (null != this.generateSupportingFiles && this.generateSupportingFiles.booleanValue()) {
            System.setProperty("supportingFiles", this.supportingFilesToGenerate);
        } else {
            System.clearProperty("supportingFiles");
        }
        this.addCodegenArgumentIfAbsent("--model-tests", "boolean", this.generateModelTests.toString(), configurator);
        this.addCodegenArgumentIfAbsent("--api-tests", "boolean", this.generateApiTests.toString(), configurator);
        this.addCodegenArgumentIfAbsent("--model-docs", "boolean", this.generateModelDocumentation.toString(), configurator);
        this.addCodegenArgumentIfAbsent("--api-docs", "boolean", this.generateApiDocumentation.toString(), configurator);
        System.setProperty("withXml", this.withXml.toString());
        if (this.configOptions != null) {
            if (this.instantiationTypes == null && this.configOptions.containsKey("instantiation-types")) {
                CodegenConfiguratorUtils.applyInstantiationTypesKvp((String)this.configOptions.get("instantiation-types").toString(), (CodegenConfigurator)configurator);
            }
            if (this.importMappings == null && this.configOptions.containsKey("import-mappings")) {
                CodegenConfiguratorUtils.applyImportMappingsKvp((String)this.configOptions.get("import-mappings").toString(), (CodegenConfigurator)configurator);
            }
            if (this.typeMappings == null && this.configOptions.containsKey("type-mappings")) {
                CodegenConfiguratorUtils.applyTypeMappingsKvp((String)this.configOptions.get("type-mappings").toString(), (CodegenConfigurator)configurator);
            }
            if (this.languageSpecificPrimitives == null && this.configOptions.containsKey("language-specific-primitives")) {
                CodegenConfiguratorUtils.applyLanguageSpecificPrimitivesCsv((String)this.configOptions.get("language-specific-primitives").toString(), (CodegenConfigurator)configurator);
            }
            if (this.additionalProperties == null && this.configOptions.containsKey("additional-properties")) {
                CodegenConfiguratorUtils.applyAdditionalPropertiesKvp((String)this.configOptions.get("additional-properties").toString(), (CodegenConfigurator)configurator);
            }
            if (this.reservedWordsMappings == null && this.configOptions.containsKey("reserved-words-mappings")) {
                CodegenConfiguratorUtils.applyReservedWordsMappingsKvp((String)this.configOptions.get("reserved-words-mappings").toString(), (CodegenConfigurator)configurator);
            }
        }
        if (this.instantiationTypes != null && !this.configOptions.containsKey("instantiation-types")) {
            CodegenConfiguratorUtils.applyInstantiationTypesKvpList(this.instantiationTypes, (CodegenConfigurator)configurator);
        }
        if (this.importMappings != null && !this.configOptions.containsKey("import-mappings")) {
            CodegenConfiguratorUtils.applyImportMappingsKvpList(this.importMappings, (CodegenConfigurator)configurator);
        }
        if (this.typeMappings != null && !this.configOptions.containsKey("type-mappings")) {
            CodegenConfiguratorUtils.applyTypeMappingsKvpList(this.typeMappings, (CodegenConfigurator)configurator);
        }
        if (this.languageSpecificPrimitives != null && !this.configOptions.containsKey("language-specific-primitives")) {
            CodegenConfiguratorUtils.applyLanguageSpecificPrimitivesCsvList(this.languageSpecificPrimitives, (CodegenConfigurator)configurator);
        }
        if (this.withXml != null && this.withXml.booleanValue()) {
            if (this.additionalProperties == null) {
                this.additionalProperties = new ArrayList<String>();
            }
            this.additionalProperties.add("withXml=" + this.withXml.toString());
            if (this.configOptions == null) {
                this.configOptions = new HashMap();
            }
        }
        if (this.additionalProperties != null && !this.configOptions.containsKey("additional-properties")) {
            CodegenConfiguratorUtils.applyAdditionalPropertiesKvpList(this.additionalProperties, (CodegenConfigurator)configurator);
        }
        if (this.reservedWordsMappings != null && !this.configOptions.containsKey("reserved-words-mappings")) {
            CodegenConfiguratorUtils.applyReservedWordsMappingsKvpList(this.reservedWordsMappings, (CodegenConfigurator)configurator);
        }
        if (this.environmentVariables != null) {
            for (String key : this.environmentVariables.keySet()) {
                this.originalEnvironmentVariables.put(key, System.getProperty(key));
                Object value = this.environmentVariables.get(key);
                if (value == null) {
                    value = "";
                }
                System.setProperty(key, (String)value);
                configurator.addSystemProperty(key, (String)value);
            }
        }
        ClientOptInput input = configurator.toClientOptInput();
        CodegenConfig config = input.getConfig();
        if (this.configOptions != null) {
            for (CliOption langCliOption : config.cliOptions()) {
                if (!this.configOptions.containsKey(langCliOption.getOpt())) continue;
                input.getConfig().additionalProperties().put(langCliOption.getOpt(), this.configOptions.get(langCliOption.getOpt()));
            }
        }
        if (this.configHelp) {
            for (CliOption langCliOption : config.cliOptions()) {
                System.out.println("\t" + langCliOption.getOpt());
                System.out.println("\t    " + langCliOption.getOptionHelp().replaceAll("\n", "\n\t    "));
                System.out.println();
            }
            return;
        }
        try {
            new DefaultGenerator().opts(input).generate();
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Code generation failed. See above for the full exception.");
        }
        this.addCompileSourceRootIfConfigured();
    }

    private void addCompileSourceRootIfConfigured() {
        if (this.addCompileSourceRoot) {
            Object sourceFolderObject = this.configOptions == null ? null : (Object)this.configOptions.get("sourceFolder");
            String sourceFolder = sourceFolderObject == null ? "src/main/java" : sourceFolderObject.toString();
            String sourceJavaFolder = this.output.toString() + "/" + sourceFolder;
            this.project.addCompileSourceRoot(sourceJavaFolder);
        }
        for (Map.Entry<String, String> entry : this.originalEnvironmentVariables.entrySet()) {
            if (entry.getValue() == null) {
                System.clearProperty(entry.getKey());
                continue;
            }
            System.setProperty(entry.getKey(), entry.getValue());
        }
    }

    private void addCodegenArgumentIfAbsent(String option, String type, String value, CodegenConfigurator configurator) {
        if (configurator.getCodegenArguments().stream().noneMatch(codegenArgument -> option.equals(codegenArgument.getOption()))) {
            configurator.getCodegenArguments().add(new CodegenArgument().option(option).type(type).value(value));
        }
    }
}

