/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.java;

import com.google.common.collect.ImmutableMap;
import io.swagger.codegen.v3.CliOption;
import io.swagger.codegen.v3.CodegenContent;
import io.swagger.codegen.v3.CodegenModel;
import io.swagger.codegen.v3.CodegenOperation;
import io.swagger.codegen.v3.CodegenParameter;
import io.swagger.codegen.v3.CodegenProperty;
import io.swagger.codegen.v3.CodegenResponse;
import io.swagger.codegen.v3.CodegenSecurity;
import io.swagger.codegen.v3.CodegenType;
import io.swagger.codegen.v3.SupportingFile;
import io.swagger.codegen.v3.VendorExtendable;
import io.swagger.codegen.v3.generators.features.BeanValidationFeatures;
import io.swagger.codegen.v3.generators.features.OptionalFeatures;
import io.swagger.codegen.v3.generators.handlebars.ExtensionHelper;
import io.swagger.codegen.v3.generators.handlebars.lambda.CamelCaseLambda;
import io.swagger.codegen.v3.generators.handlebars.lambda.CapitaliseLambda;
import io.swagger.codegen.v3.generators.handlebars.lambda.EscapeDoubleQuotesLambda;
import io.swagger.codegen.v3.generators.handlebars.lambda.IndentedLambda;
import io.swagger.codegen.v3.generators.handlebars.lambda.LowercaseLambda;
import io.swagger.codegen.v3.generators.handlebars.lambda.RemoveLineBreakLambda;
import io.swagger.codegen.v3.generators.handlebars.lambda.TitlecaseLambda;
import io.swagger.codegen.v3.generators.handlebars.lambda.UppercaseLambda;
import io.swagger.codegen.v3.generators.java.AbstractJavaCodegen;
import io.swagger.codegen.v3.utils.URLPathUtil;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicronautCodegen
extends AbstractJavaCodegen
implements BeanValidationFeatures,
OptionalFeatures {
    private static Logger LOGGER = LoggerFactory.getLogger(MicronautCodegen.class);
    private static final String TITLE = "title";
    private static final String CONFIG_PACKAGE = "configPackage";
    private static final String BASE_PACKAGE = "basePackage";
    private static final String USE_TAGS = "useTags";
    private static final String IMPLICIT_HEADERS = "implicitHeaders";
    private static final String SKIP_SUPPORT_FILES = "skipSupportFiles";
    private String title = "swagger-petstore";
    private String configPackage = "io.swagger.configuration";
    private String basePackage = "io.swagger";
    private boolean useTags = false;
    private boolean useBeanValidation = true;
    private boolean implicitHeaders = false;
    private boolean useOptional = false;

    public MicronautCodegen() {
        this.init();
    }

    private void init() {
        this.outputFolder = "generated-code/javaMicronaut";
        this.apiPackage = "io.swagger.api";
        this.modelPackage = "io.swagger.model";
        this.invokerPackage = "io.swagger.api";
        this.artifactId = "swagger-micronaut";
        this.additionalProperties.put(CONFIG_PACKAGE, this.configPackage);
        this.additionalProperties.put(BASE_PACKAGE, this.basePackage);
        this.additionalProperties.put("jackson", "true");
        this.cliOptions.add(new CliOption(TITLE, "server title name or client service name"));
        this.cliOptions.add(new CliOption(CONFIG_PACKAGE, "configuration package for generated code"));
        this.cliOptions.add(new CliOption(BASE_PACKAGE, "base package (invokerPackage) for generated code"));
        this.cliOptions.add(new CliOption(SKIP_SUPPORT_FILES, "skip support files such as pom.xml, mvnw, etc from code generation."));
        this.cliOptions.add(CliOption.newBoolean((String)USE_TAGS, (String)"use tags for creating interface and controller classnames"));
        this.cliOptions.add(CliOption.newBoolean((String)"useBeanValidation", (String)"Use BeanValidation API annotations"));
        this.cliOptions.add(CliOption.newBoolean((String)IMPLICIT_HEADERS, (String)"Use of @ApiImplicitParams for headers."));
        this.cliOptions.add(CliOption.newBoolean((String)"useOptional", (String)"Use Optional container for optional parameters"));
        this.supportedLibraries.put("<default>", "Java Micronaut Server application.");
        this.setLibrary("<default>");
        CliOption library = new CliOption("library", "library template (sub-template) to use");
        library.setDefault("<default>");
        library.setEnum(this.supportedLibraries);
        library.setDefault("<default>");
        this.cliOptions.add(library);
    }

    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    public String getName() {
        return "micronaut";
    }

    public String getHelp() {
        return "Generates a Java Micronaut Server application.";
    }

    @Override
    public void processOpts() {
        this.setUseOas2(false);
        this.additionalProperties.put("useOas2", false);
        if (this.additionalProperties.containsKey("httpMethod")) {
            String httpMethod = (String)this.additionalProperties.get("httpMethod");
            String httpMethodNormalCase = Character.toUpperCase(httpMethod.charAt(0)) + httpMethod.substring(1);
            this.additionalProperties.put("httpMethodNormalCase", httpMethodNormalCase);
        }
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.setBasePackage((String)this.additionalProperties.get("invokerPackage"));
            this.additionalProperties.put(BASE_PACKAGE, this.basePackage);
            LOGGER.info("Set base package to invoker package (" + this.basePackage + ")");
        }
        super.processOpts();
        this.modelDocTemplateFiles.remove("model_doc.mustache");
        this.apiDocTemplateFiles.remove("api_doc.mustache");
        if (this.additionalProperties.containsKey(TITLE)) {
            this.setTitle((String)this.additionalProperties.get(TITLE));
        }
        if (this.additionalProperties.containsKey(CONFIG_PACKAGE)) {
            this.setConfigPackage((String)this.additionalProperties.get(CONFIG_PACKAGE));
        }
        if (this.additionalProperties.containsKey(BASE_PACKAGE)) {
            this.setBasePackage((String)this.additionalProperties.get(BASE_PACKAGE));
        }
        if (this.additionalProperties.containsKey(USE_TAGS)) {
            this.setUseTags(Boolean.valueOf(this.additionalProperties.get(USE_TAGS).toString()));
        }
        if (this.additionalProperties.containsKey("useBeanValidation")) {
            this.setUseBeanValidation(this.convertPropertyToBoolean("useBeanValidation"));
        }
        if (this.additionalProperties.containsKey("useOptional")) {
            this.setUseOptional(this.convertPropertyToBoolean("useOptional"));
        }
        boolean skipSupportFiles = false;
        if (this.additionalProperties.containsKey(SKIP_SUPPORT_FILES)) {
            skipSupportFiles = Boolean.valueOf(this.additionalProperties.get(SKIP_SUPPORT_FILES).toString());
        }
        if (this.useBeanValidation) {
            this.writePropertyBack("useBeanValidation", this.useBeanValidation);
        }
        if (this.additionalProperties.containsKey(IMPLICIT_HEADERS)) {
            this.setImplicitHeaders(Boolean.valueOf(this.additionalProperties.get(IMPLICIT_HEADERS).toString()));
        }
        if (this.useOptional) {
            this.writePropertyBack("useOptional", this.useOptional);
        }
        if (!skipSupportFiles) {
            this.supportingFiles.add(new SupportingFile("pom.mustache", "", "pom.xml"));
            this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
            this.supportingFiles.add(new SupportingFile("mvnw", "", "mvnw"));
            this.supportingFiles.add(new SupportingFile("mvnw.cmd", "", "mvnw.cmd"));
            this.supportingFiles.add(new SupportingFile("unsupportedOperationExceptionHandler.mustache", (this.sourceFolder + File.separator + this.configPackage).replace(".", File.separator), "UnsupportedOperationExceptionHandler.java"));
            this.supportingFiles.add(new SupportingFile("mainApplication.mustache", (this.sourceFolder + File.separator).replace(".", File.separator), "MainApplication.java"));
        }
        this.addHandlebarsLambdas(this.additionalProperties);
    }

    private void addHandlebarsLambdas(Map<String, Object> objs) {
        ImmutableMap lambdas = new ImmutableMap.Builder().put((Object)"lowercase", (Object)new LowercaseLambda().generator(this)).put((Object)"uppercase", (Object)new UppercaseLambda()).put((Object)"titlecase", (Object)new TitlecaseLambda()).put((Object)"camelcase", (Object)new CamelCaseLambda().generator(this)).put((Object)"camelcase_param", (Object)new CamelCaseLambda().generator(this).escapeAsParamName(true)).put((Object)"indented", (Object)new IndentedLambda()).put((Object)"indented_8", (Object)new IndentedLambda(8, " ")).put((Object)"indented_12", (Object)new IndentedLambda(12, " ")).put((Object)"indented_16", (Object)new IndentedLambda(16, " ")).put((Object)"capitalise", (Object)new CapitaliseLambda()).put((Object)"escapeDoubleQuote", (Object)new EscapeDoubleQuotesLambda()).put((Object)"removeLineBreak", (Object)new RemoveLineBreakLambda()).build();
        if (objs.containsKey("lambda")) {
            LOGGER.warn("An property named 'lambda' already exists. Mustache lambdas renamed from 'lambda' to '_lambda'. You'll likely need to use a custom template, see https://github.com/swagger-api/swagger-codegen#modifying-the-client-library-format. ");
            objs.put("_lambda", lambdas);
        } else {
            objs.put("lambda", lambdas);
        }
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        if (!this.useTags) {
            int pos;
            String basePath = resourcePath;
            if (basePath.startsWith("/")) {
                basePath = basePath.substring(1);
            }
            if ((pos = basePath.indexOf("/")) > 0) {
                basePath = basePath.substring(0, pos);
            }
            if (basePath.equals("")) {
                basePath = "default";
            } else {
                co.subresourceOperation = !co.path.isEmpty();
            }
            List opList = operations.computeIfAbsent(basePath, k -> new ArrayList());
            opList.add(co);
            co.baseName = basePath;
        } else {
            super.addOperationToGroup(tag, resourcePath, operation, co, operations);
        }
    }

    @Override
    public String getArgumentsLocation() {
        return null;
    }

    @Override
    public String getDefaultTemplateDir() {
        return "JavaMicronaut";
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        if (!this.additionalProperties.containsKey(TITLE)) {
            String title = openAPI.getInfo().getTitle();
            if (title != null) {
                if ((title = title.trim().replace(" ", "-")).toUpperCase().endsWith("API")) {
                    title = title.substring(0, title.length() - 3);
                }
                this.title = MicronautCodegen.camelize(this.sanitizeName(title), true);
            }
            this.additionalProperties.put(TITLE, this.title);
        }
        URL urlInfo = URLPathUtil.getServerURL((OpenAPI)openAPI);
        String port = "8080";
        if (urlInfo != null && urlInfo.getPort() != 0) {
            port = String.valueOf(urlInfo.getPort());
        }
        this.additionalProperties.put("serverPort", port);
        if (openAPI.getPaths() != null) {
            for (String pathname : openAPI.getPaths().keySet()) {
                PathItem pathItem = (PathItem)openAPI.getPaths().get((Object)pathname);
                List operations = pathItem.readOperations();
                for (Operation operation : operations) {
                    if (operation.getTags() == null) continue;
                    ArrayList tags = new ArrayList();
                    for (String tag : operation.getTags()) {
                        HashMap<String, String> value = new HashMap<String, String>();
                        value.put("tag", tag);
                        value.put("hasMore", "true");
                        tags.add(value);
                    }
                    if (tags.size() > 0) {
                        ((Map)tags.get(tags.size() - 1)).remove("hasMore");
                    }
                    if (operation.getTags().size() > 0) {
                        String tag = (String)operation.getTags().get(0);
                        operation.setTags(Collections.singletonList(tag));
                    }
                    operation.addExtension("x-tags", tags);
                }
            }
        }
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        if (operations != null) {
            List ops = (List)operations.get("operation");
            for (final CodegenOperation operation : ops) {
                List responses = operation.responses;
                if (responses != null) {
                    for (final CodegenResponse resp : responses) {
                        if ("0".equals(resp.code)) {
                            resp.code = "200";
                        }
                        this.doDataTypeAssignment(resp.dataType, new DataTypeAssigner(){

                            @Override
                            public void setReturnType(String returnType) {
                                resp.dataType = returnType;
                            }

                            @Override
                            public void setReturnContainer(String returnContainer) {
                                resp.containerType = returnContainer;
                            }
                        });
                    }
                }
                this.doDataTypeAssignment(operation.returnType, new DataTypeAssigner(){

                    @Override
                    public void setReturnType(String returnType) {
                        operation.returnType = returnType;
                    }

                    @Override
                    public void setReturnContainer(String returnContainer) {
                        operation.returnContainer = returnContainer;
                    }
                });
                if (!this.implicitHeaders) continue;
                this.removeHeadersFromAllParams(operation.allParams);
                this.removeHeadersFromContents(operation.contents);
            }
        }
        return objs;
    }

    private void doDataTypeAssignment(String returnType, DataTypeAssigner dataTypeAssigner) {
        int end;
        if (returnType == null) {
            dataTypeAssigner.setReturnType("Void");
        } else if (returnType.startsWith("List")) {
            int end2 = returnType.lastIndexOf(">");
            if (end2 > 0) {
                dataTypeAssigner.setReturnType(returnType.substring("List<".length(), end2).trim());
                dataTypeAssigner.setReturnContainer("List");
            }
        } else if (returnType.startsWith("Map")) {
            int end3 = returnType.lastIndexOf(">");
            if (end3 > 0) {
                dataTypeAssigner.setReturnType(returnType.substring("Map<".length(), end3).split(",")[1].trim());
                dataTypeAssigner.setReturnContainer("Map");
            }
        } else if (returnType.startsWith("Set") && (end = returnType.lastIndexOf(">")) > 0) {
            dataTypeAssigner.setReturnType(returnType.substring("Set<".length(), end).trim());
            dataTypeAssigner.setReturnContainer("Set");
        }
    }

    private void removeHeadersFromAllParams(List<CodegenParameter> allParams) {
        if (allParams.isEmpty()) {
            return;
        }
        ArrayList<CodegenParameter> copy = new ArrayList<CodegenParameter>(allParams);
        allParams.clear();
        for (CodegenParameter p : copy) {
            if (ExtensionHelper.getBooleanValue((VendorExtendable)p, "x-is-header-param")) continue;
            allParams.add(p);
        }
        allParams.get(allParams.size() - 1).getVendorExtensions().put("x-has-more", Boolean.FALSE);
    }

    private void removeHeadersFromContents(List<CodegenContent> contents) {
        if (contents == null || contents.isEmpty()) {
            return;
        }
        for (CodegenContent codegenContent : contents) {
            List parameters = codegenContent.getParameters();
            if (parameters == null || parameters.isEmpty()) continue;
            List filteredParameters = parameters.stream().filter(codegenParameter -> !ExtensionHelper.getBooleanValue((VendorExtendable)codegenParameter, "x-is-header-param")).collect(Collectors.toList());
            parameters.clear();
            parameters.addAll(filteredParameters);
            ((CodegenParameter)parameters.get(parameters.size() - 1)).getVendorExtensions().put("x-has-more", Boolean.FALSE);
        }
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        List authMethods = (List)objs.get("authMethods");
        if (authMethods != null) {
            for (CodegenSecurity authMethod : authMethods) {
                authMethod.name = MicronautCodegen.camelize(this.sanitizeName(authMethod.name), true);
            }
        }
        return objs;
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        name = this.sanitizeName(name);
        return MicronautCodegen.camelize(name) + "Api";
    }

    @Override
    public String toApiTestFilename(String name) {
        return this.toApiName(name) + "ControllerTest";
    }

    @Override
    public String toBooleanGetter(String name) {
        return this.getterAndSetterCapitalize(name);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setConfigPackage(String configPackage) {
        this.configPackage = configPackage;
    }

    public void setBasePackage(String configPackage) {
        this.basePackage = configPackage;
    }

    public void setUseTags(boolean useTags) {
        this.useTags = useTags;
    }

    public void setImplicitHeaders(boolean implicitHeaders) {
        this.implicitHeaders = implicitHeaders;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        boolean isEnum;
        super.postProcessModelProperty(model, property);
        if ("null".equals(property.example)) {
            property.example = null;
        }
        if (!Boolean.TRUE.equals(isEnum = ExtensionHelper.getBooleanValue((VendorExtendable)model, "x-is-enum"))) {
            model.imports.add("JsonProperty");
            boolean hasEnums = ExtensionHelper.getBooleanValue((VendorExtendable)model, "x-has-enums");
            if (Boolean.TRUE.equals(hasEnums)) {
                model.imports.add("JsonValue");
            }
        } else if (this.additionalProperties.containsKey("jackson")) {
            model.imports.add("JsonCreator");
        }
        if (model.discriminator != null && model.discriminator.getPropertyName().equals(property.baseName)) {
            property.vendorExtensions.put("x-is-discriminator-property", true);
        }
    }

    @Override
    public Map<String, Object> postProcessModelsEnum(Map<String, Object> objs) {
        objs = super.postProcessModelsEnum(objs);
        List imports = (List)objs.get("imports");
        List models = (List)objs.get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            boolean isEnum = ExtensionHelper.getBooleanValue((VendorExtendable)cm, "x-is-enum");
            if (!Boolean.TRUE.equals(isEnum) || cm.allowableValues == null) continue;
            cm.imports.add(this.importMapping.get("JsonValue"));
            HashMap item = new HashMap();
            item.put("import", this.importMapping.get("JsonValue"));
            imports.add(item);
        }
        return objs;
    }

    @Override
    public void setUseBeanValidation(boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
    }

    @Override
    public void setUseOptional(boolean useOptional) {
        this.useOptional = useOptional;
    }

    private static interface DataTypeAssigner {
        public void setReturnType(String var1);

        public void setReturnContainer(String var1);
    }
}

