/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.java;

import com.github.jknack.handlebars.Handlebars;
import io.swagger.codegen.v3.CliOption;
import io.swagger.codegen.v3.CodegenArgument;
import io.swagger.codegen.v3.CodegenModel;
import io.swagger.codegen.v3.CodegenOperation;
import io.swagger.codegen.v3.CodegenParameter;
import io.swagger.codegen.v3.CodegenProperty;
import io.swagger.codegen.v3.VendorExtendable;
import io.swagger.codegen.v3.generators.DefaultCodegenConfig;
import io.swagger.codegen.v3.generators.features.NotNullAnnotationFeatures;
import io.swagger.codegen.v3.generators.handlebars.ExtensionHelper;
import io.swagger.codegen.v3.generators.handlebars.java.JavaHelper;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJavaCodegen
extends DefaultCodegenConfig {
    private static Logger LOGGER = LoggerFactory.getLogger(AbstractJavaCodegen.class);
    public static final String FULL_JAVA_UTIL = "fullJavaUtil";
    public static final String DEFAULT_LIBRARY = "<default>";
    public static final String DATE_LIBRARY = "dateLibrary";
    public static final String JAVA8_MODE = "java8";
    public static final String WITH_XML = "withXml";
    public static final String SUPPORT_JAVA6 = "supportJava6";
    public static final String ERROR_ON_UNKNOWN_ENUM = "errorOnUnknownEnum";
    public static final String CHECK_DUPLICATED_MODEL_NAME = "checkDuplicatedModelName";
    protected String dateLibrary = "threetenbp";
    protected boolean java8Mode = false;
    protected boolean withXml = false;
    protected String invokerPackage = "io.swagger";
    protected String groupId = "io.swagger";
    protected String artifactId = "swagger-java";
    protected String artifactVersion = "1.0.0";
    protected String artifactUrl = "https://github.com/swagger-api/swagger-codegen";
    protected String artifactDescription = "Swagger Java";
    protected String developerName = "Swagger";
    protected String developerEmail = "apiteam@swagger.io";
    protected String developerOrganization = "Swagger";
    protected String developerOrganizationUrl = "http://swagger.io";
    protected String scmConnection = "scm:git:git@github.com:swagger-api/swagger-codegen.git";
    protected String scmDeveloperConnection = "scm:git:git@github.com:swagger-api/swagger-codegen.git";
    protected String scmUrl = "https://github.com/swagger-api/swagger-codegen";
    protected String licenseName = "Unlicense";
    protected String licenseUrl = "http://unlicense.org";
    protected String projectFolder = "src" + File.separator + "main";
    protected String projectTestFolder = "src" + File.separator + "test";
    protected String sourceFolder = this.projectFolder + File.separator + "java";
    protected String testFolder = this.projectTestFolder + File.separator + "java";
    protected String localVariablePrefix = "";
    protected boolean fullJavaUtil;
    protected String javaUtilPrefix = "";
    protected Boolean serializableModel = false;
    protected boolean serializeBigDecimalAsString = false;
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected boolean supportJava6 = false;
    private NotNullAnnotationFeatures notNullOption;

    public AbstractJavaCodegen() {
        this.hideGenerationTimestamp = false;
        this.supportsInheritance = true;
        this.setReservedWordsLowerCase(Arrays.asList("localVarPath", "localVarQueryParams", "localVarCollectionQueryParams", "localVarHeaderParams", "localVarFormParams", "localVarPostBody", "localVarAccepts", "localVarAccept", "localVarContentTypes", "localVarContentType", "localVarAuthNames", "localReturnType", "ApiClient", "ApiException", "ApiResponse", "Configuration", "StringUtil", "abstract", "continue", "for", "new", "switch", "assert", "default", "if", "package", "synchronized", "boolean", "do", "goto", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while", "null"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("String", "boolean", "Boolean", "Double", "Integer", "Long", "Float", "Object", "byte[]"));
        this.instantiationTypes.put("array", "ArrayList");
        this.instantiationTypes.put("map", "HashMap");
        this.typeMapping.put("date", "Date");
        this.typeMapping.put("file", "File");
        this.typeMapping.put("binary", "File");
        this.cliOptions.add(new CliOption("modelPackage", "package for generated models"));
        this.cliOptions.add(new CliOption("apiPackage", "package for generated api classes"));
        this.cliOptions.add(new CliOption("invokerPackage", "root package for generated code"));
        this.cliOptions.add(new CliOption("groupId", "groupId in generated pom.xml"));
        this.cliOptions.add(new CliOption("artifactId", "artifactId in generated pom.xml"));
        this.cliOptions.add(new CliOption("artifactVersion", "artifact version in generated pom.xml"));
        this.cliOptions.add(new CliOption("artifactUrl", "artifact URL in generated pom.xml"));
        this.cliOptions.add(new CliOption("artifactDescription", "artifact description in generated pom.xml"));
        this.cliOptions.add(new CliOption("scmConnection", "SCM connection in generated pom.xml"));
        this.cliOptions.add(new CliOption("scmDeveloperConnection", "SCM developer connection in generated pom.xml"));
        this.cliOptions.add(new CliOption("scmUrl", "SCM URL in generated pom.xml"));
        this.cliOptions.add(new CliOption("developerName", "developer name in generated pom.xml"));
        this.cliOptions.add(new CliOption("developerEmail", "developer email in generated pom.xml"));
        this.cliOptions.add(new CliOption("developerOrganization", "developer organization in generated pom.xml"));
        this.cliOptions.add(new CliOption("developerOrganizationUrl", "developer organization URL in generated pom.xml"));
        this.cliOptions.add(new CliOption("licenseName", "The name of the license"));
        this.cliOptions.add(new CliOption("licenseUrl", "The URL of the license"));
        this.cliOptions.add(new CliOption("sourceFolder", "source folder for generated code"));
        this.cliOptions.add(new CliOption("localVariablePrefix", "prefix for generated code members and local variables"));
        this.cliOptions.add(CliOption.newBoolean((String)"serializableModel", (String)"boolean - toggle \"implements Serializable\" for generated models"));
        this.cliOptions.add(CliOption.newBoolean((String)"bigDecimalAsString", (String)"Treat BigDecimal values as Strings to avoid precision loss."));
        this.cliOptions.add(CliOption.newBoolean((String)FULL_JAVA_UTIL, (String)"whether to use fully qualified name for classes under java.util. This option only works for Java API client"));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "Hides the generation timestamp when files are generated."));
        this.cliOptions.add(CliOption.newBoolean((String)WITH_XML, (String)"whether to include support for application/xml content type and include XML annotations in the model (works with libraries that provide support for JSON and XML)"));
        this.cliOptions.add(CliOption.newBoolean((String)"useOas2", (String)"use OpenAPI v2.0 (Swagger 1.5.x)"));
        if (this instanceof NotNullAnnotationFeatures) {
            this.cliOptions.add(CliOption.newBoolean((String)"notNullJacksonAnnotation", (String)"adds @JsonInclude(JsonInclude.Include.NON_NULL) annotation to model classes"));
        }
        CliOption dateLibrary = new CliOption(DATE_LIBRARY, "Option. Date library to use");
        HashMap<String, String> dateOptions = new HashMap<String, String>();
        dateOptions.put(JAVA8_MODE, "Java 8 native JSR310 (preferred for jdk 1.8+) - note: this also sets \"java8\" to true");
        dateOptions.put("threetenbp", "Backport of JSR310 (preferred for jdk < 1.8)");
        dateOptions.put("java8-localdatetime", "Java 8 using LocalDateTime (for legacy app only)");
        dateOptions.put("joda", "Joda (for legacy app only)");
        dateOptions.put("legacy", "Legacy java.util.Date (if you really have a good reason not to use threetenbp");
        dateLibrary.setEnum(dateOptions);
        this.cliOptions.add(dateLibrary);
        CliOption java8Mode = new CliOption(JAVA8_MODE, "Option. Use Java8 classes instead of third party equivalents");
        HashMap<String, String> java8ModeOptions = new HashMap<String, String>();
        java8ModeOptions.put("true", "Use Java 8 classes such as Base64");
        java8ModeOptions.put("false", "Various third party libraries as needed");
        java8Mode.setEnum(java8ModeOptions);
        this.cliOptions.add(java8Mode);
        this.cliOptions.add(CliOption.newBoolean((String)CHECK_DUPLICATED_MODEL_NAME, (String)"Check if there are duplicated model names (ignoring case)"));
    }

    @Override
    public void processOpts() {
        String derivedInvokerPackage;
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.setInvokerPackage((String)this.additionalProperties.get("invokerPackage"));
        } else if (this.additionalProperties.containsKey("apiPackage")) {
            derivedInvokerPackage = this.deriveInvokerPackageName((String)this.additionalProperties.get("apiPackage"));
            this.additionalProperties.put("invokerPackage", derivedInvokerPackage);
            this.setInvokerPackage((String)this.additionalProperties.get("invokerPackage"));
            LOGGER.info("Invoker Package Name, originally not set, is now derived from api package name: " + derivedInvokerPackage);
        } else if (this.additionalProperties.containsKey("modelPackage")) {
            derivedInvokerPackage = this.deriveInvokerPackageName((String)this.additionalProperties.get("modelPackage"));
            this.additionalProperties.put("invokerPackage", derivedInvokerPackage);
            this.setInvokerPackage((String)this.additionalProperties.get("invokerPackage"));
            LOGGER.info("Invoker Package Name, originally not set, is now derived from model package name: " + derivedInvokerPackage);
        } else if (StringUtils.isNotEmpty((CharSequence)this.invokerPackage)) {
            this.additionalProperties.put("invokerPackage", this.invokerPackage);
        }
        super.processOpts();
        this.modelTemplateFiles.put("model.mustache", ".java");
        this.apiTemplateFiles.put("api.mustache", ".java");
        this.apiTestTemplateFiles.put("api_test.mustache", ".java");
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        if (this.additionalProperties.containsKey(SUPPORT_JAVA6)) {
            this.setSupportJava6(false);
        }
        this.additionalProperties.put(SUPPORT_JAVA6, this.supportJava6);
        if (this.additionalProperties.containsKey("groupId")) {
            this.setGroupId((String)this.additionalProperties.get("groupId"));
        } else if (StringUtils.isNotEmpty((CharSequence)this.groupId)) {
            this.additionalProperties.put("groupId", this.groupId);
        }
        if (this.additionalProperties.containsKey("artifactId")) {
            this.setArtifactId((String)this.additionalProperties.get("artifactId"));
        } else if (StringUtils.isNotEmpty((CharSequence)this.artifactId)) {
            this.additionalProperties.put("artifactId", this.artifactId);
        }
        if (this.additionalProperties.containsKey("artifactVersion")) {
            this.setArtifactVersion((String)this.additionalProperties.get("artifactVersion"));
        } else if (StringUtils.isNotEmpty((CharSequence)this.artifactVersion)) {
            this.additionalProperties.put("artifactVersion", this.artifactVersion);
        }
        if (this.additionalProperties.containsKey("artifactUrl")) {
            this.setArtifactUrl((String)this.additionalProperties.get("artifactUrl"));
        } else if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.artifactUrl})) {
            this.additionalProperties.put("artifactUrl", this.artifactUrl);
        }
        if (this.additionalProperties.containsKey("artifactDescription")) {
            this.setArtifactDescription((String)this.additionalProperties.get("artifactDescription"));
        } else if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.artifactDescription})) {
            this.additionalProperties.put("artifactDescription", this.artifactDescription);
        }
        if (this.additionalProperties.containsKey("scmConnection")) {
            this.setScmConnection((String)this.additionalProperties.get("scmConnection"));
        } else if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.scmConnection})) {
            this.additionalProperties.put("scmConnection", this.scmConnection);
        }
        if (this.additionalProperties.containsKey("scmDeveloperConnection")) {
            this.setScmDeveloperConnection((String)this.additionalProperties.get("scmDeveloperConnection"));
        } else if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.scmDeveloperConnection})) {
            this.additionalProperties.put("scmDeveloperConnection", this.scmDeveloperConnection);
        }
        if (this.additionalProperties.containsKey("scmUrl")) {
            this.setScmUrl((String)this.additionalProperties.get("scmUrl"));
        } else if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.scmUrl})) {
            this.additionalProperties.put("scmUrl", this.scmUrl);
        }
        if (this.additionalProperties.containsKey("developerName")) {
            this.setDeveloperName((String)this.additionalProperties.get("developerName"));
        } else if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.developerName})) {
            this.additionalProperties.put("developerName", this.developerName);
        }
        if (this.additionalProperties.containsKey("developerEmail")) {
            this.setDeveloperEmail((String)this.additionalProperties.get("developerEmail"));
        } else if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.developerEmail})) {
            this.additionalProperties.put("developerEmail", this.developerEmail);
        }
        if (this.additionalProperties.containsKey("developerOrganization")) {
            this.setDeveloperOrganization((String)this.additionalProperties.get("developerOrganization"));
        } else if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.developerOrganization})) {
            this.additionalProperties.put("developerOrganization", this.developerOrganization);
        }
        if (this.additionalProperties.containsKey("developerOrganizationUrl")) {
            this.setDeveloperOrganizationUrl((String)this.additionalProperties.get("developerOrganizationUrl"));
        } else if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.developerOrganizationUrl})) {
            this.additionalProperties.put("developerOrganizationUrl", this.developerOrganizationUrl);
        }
        if (this.additionalProperties.containsKey("licenseName")) {
            this.setLicenseName((String)this.additionalProperties.get("licenseName"));
        } else if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.licenseName})) {
            this.additionalProperties.put("licenseName", this.licenseName);
        }
        if (this.additionalProperties.containsKey("licenseUrl")) {
            this.setLicenseUrl((String)this.additionalProperties.get("licenseUrl"));
        } else if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.licenseUrl})) {
            this.additionalProperties.put("licenseUrl", this.licenseUrl);
        }
        if (this.additionalProperties.containsKey("sourceFolder")) {
            this.setSourceFolder((String)this.additionalProperties.get("sourceFolder"));
        }
        if (this.additionalProperties.containsKey("localVariablePrefix")) {
            this.setLocalVariablePrefix((String)this.additionalProperties.get("localVariablePrefix"));
        }
        if (this.additionalProperties.containsKey("serializableModel")) {
            this.setSerializableModel(Boolean.valueOf(this.additionalProperties.get("serializableModel").toString()));
        }
        if (this.additionalProperties.containsKey("library")) {
            this.setLibrary((String)this.additionalProperties.get("library"));
        }
        if (this.additionalProperties.containsKey("bigDecimalAsString")) {
            this.setSerializeBigDecimalAsString(Boolean.valueOf(this.additionalProperties.get("bigDecimalAsString").toString()));
        }
        this.additionalProperties.put("serializableModel", this.serializableModel);
        if (this.additionalProperties.containsKey(FULL_JAVA_UTIL)) {
            this.setFullJavaUtil(Boolean.valueOf(this.additionalProperties.get(FULL_JAVA_UTIL).toString()));
        }
        if (this.additionalProperties.containsKey(ERROR_ON_UNKNOWN_ENUM)) {
            boolean errorOnUnknownEnum = Boolean.parseBoolean(this.additionalProperties.get(ERROR_ON_UNKNOWN_ENUM).toString());
            this.additionalProperties.put(ERROR_ON_UNKNOWN_ENUM, errorOnUnknownEnum);
        }
        if (this instanceof NotNullAnnotationFeatures) {
            this.notNullOption = (NotNullAnnotationFeatures)((Object)this);
            if (this.additionalProperties.containsKey("notNullJacksonAnnotation")) {
                this.notNullOption.setNotNullJacksonAnnotation(this.convertPropertyToBoolean("notNullJacksonAnnotation"));
                this.writePropertyBack("notNullJacksonAnnotation", this.notNullOption.isNotNullJacksonAnnotation());
                if (this.notNullOption.isNotNullJacksonAnnotation()) {
                    this.importMapping.put("JsonInclude", "com.fasterxml.jackson.annotation.JsonInclude");
                }
            }
        }
        if (this.fullJavaUtil) {
            this.javaUtilPrefix = "java.util.";
        }
        this.additionalProperties.put(FULL_JAVA_UTIL, this.fullJavaUtil);
        this.additionalProperties.put("javaUtilPrefix", this.javaUtilPrefix);
        if (this.additionalProperties.containsKey(WITH_XML)) {
            this.setWithXml(Boolean.valueOf(this.additionalProperties.get(WITH_XML).toString()));
        }
        this.additionalProperties.put(WITH_XML, this.withXml);
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.importMapping.put("List", "java.util.List");
        if (this.fullJavaUtil) {
            this.typeMapping.put("array", "java.util.List");
            this.typeMapping.put("map", "java.util.Map");
            this.typeMapping.put("DateTime", "java.util.Date");
            this.typeMapping.put("UUID", "java.util.UUID");
            this.typeMapping.remove("List");
            this.importMapping.remove("Date");
            this.importMapping.remove("Map");
            this.importMapping.remove("HashMap");
            this.importMapping.remove("Array");
            this.importMapping.remove("ArrayList");
            this.importMapping.remove("List");
            this.importMapping.remove("Set");
            this.importMapping.remove("DateTime");
            this.importMapping.remove("UUID");
            this.instantiationTypes.put("array", "java.util.ArrayList");
            this.instantiationTypes.put("map", "java.util.HashMap");
        }
        this.sanitizeConfig();
        this.importMapping.put("ToStringSerializer", "com.fasterxml.jackson.databind.ser.std.ToStringSerializer");
        this.importMapping.put("JsonSerialize", "com.fasterxml.jackson.databind.annotation.JsonSerialize");
        if (this.useOas2) {
            this.importMapping.put("ApiModelProperty", "io.swagger.annotations.ApiModelProperty");
            this.importMapping.put("ApiModel", "io.swagger.annotations.ApiModel");
        } else {
            this.importMapping.put("Schema", "io.swagger.v3.oas.annotations.media.Schema");
        }
        this.importMapping.put("JsonProperty", "com.fasterxml.jackson.annotation.JsonProperty");
        this.importMapping.put("JsonSubTypes", "com.fasterxml.jackson.annotation.JsonSubTypes");
        this.importMapping.put("JsonTypeInfo", "com.fasterxml.jackson.annotation.JsonTypeInfo");
        this.importMapping.put("JsonCreator", "com.fasterxml.jackson.annotation.JsonCreator");
        this.importMapping.put("JsonValue", "com.fasterxml.jackson.annotation.JsonValue");
        this.importMapping.put("JsonTypeId", "com.fasterxml.jackson.annotation.JsonTypeId");
        this.importMapping.put("SerializedName", "com.google.gson.annotations.SerializedName");
        this.importMapping.put("TypeAdapter", "com.google.gson.TypeAdapter");
        this.importMapping.put("JsonAdapter", "com.google.gson.annotations.JsonAdapter");
        this.importMapping.put("JsonReader", "com.google.gson.stream.JsonReader");
        this.importMapping.put("JsonWriter", "com.google.gson.stream.JsonWriter");
        this.importMapping.put("IOException", "java.io.IOException");
        this.importMapping.put("Objects", "java.util.Objects");
        this.importMapping.put("StringUtil", this.invokerPackage + ".StringUtil");
        this.importMapping.put("com.fasterxml.jackson.annotation.JsonProperty", "com.fasterxml.jackson.annotation.JsonCreator");
        if (this.additionalProperties.containsKey(JAVA8_MODE)) {
            this.setJava8Mode(Boolean.parseBoolean(this.additionalProperties.get(JAVA8_MODE).toString()));
            if (this.java8Mode) {
                this.additionalProperties.put(JAVA8_MODE, true);
            }
        }
        if (this.additionalProperties.containsKey(WITH_XML)) {
            this.setWithXml(Boolean.parseBoolean(this.additionalProperties.get(WITH_XML).toString()));
            if (this.withXml) {
                this.additionalProperties.put(WITH_XML, "true");
            }
        }
        if (this.additionalProperties.containsKey(DATE_LIBRARY)) {
            this.setDateLibrary(this.additionalProperties.get(DATE_LIBRARY).toString());
        }
        if ("threetenbp".equals(this.dateLibrary)) {
            this.additionalProperties.put("threetenbp", "true");
            this.additionalProperties.put("jsr310", "true");
            this.typeMapping.put("date", "LocalDate");
            this.typeMapping.put("DateTime", "OffsetDateTime");
            this.importMapping.put("LocalDate", "org.threeten.bp.LocalDate");
            this.importMapping.put("OffsetDateTime", "org.threeten.bp.OffsetDateTime");
        } else if ("joda".equals(this.dateLibrary)) {
            this.additionalProperties.put("joda", "true");
            this.typeMapping.put("date", "LocalDate");
            this.typeMapping.put("DateTime", "DateTime");
            this.importMapping.put("LocalDate", "org.joda.time.LocalDate");
            this.importMapping.put("DateTime", "org.joda.time.DateTime");
        } else if (this.dateLibrary.startsWith(JAVA8_MODE)) {
            this.additionalProperties.put(JAVA8_MODE, true);
            this.additionalProperties.put("jsr310", "true");
            this.typeMapping.put("date", "LocalDate");
            this.importMapping.put("LocalDate", "java.time.LocalDate");
            if ("java8-localdatetime".equals(this.dateLibrary)) {
                this.typeMapping.put("DateTime", "LocalDateTime");
                this.importMapping.put("LocalDateTime", "java.time.LocalDateTime");
            } else {
                this.typeMapping.put("DateTime", "OffsetDateTime");
                this.importMapping.put("OffsetDateTime", "java.time.OffsetDateTime");
            }
        } else if (this.dateLibrary.equals("legacy")) {
            this.additionalProperties.put("legacyDates", true);
        }
    }

    private void sanitizeConfig() {
        this.setApiPackage(AbstractJavaCodegen.sanitizePackageName(this.apiPackage));
        if (this.additionalProperties.containsKey("apiPackage")) {
            this.additionalProperties.put("apiPackage", this.apiPackage);
        }
        this.setModelPackage(AbstractJavaCodegen.sanitizePackageName(this.modelPackage));
        if (this.additionalProperties.containsKey("modelPackage")) {
            this.additionalProperties.put("modelPackage", this.modelPackage);
        }
        this.setInvokerPackage(AbstractJavaCodegen.sanitizePackageName(this.invokerPackage));
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.additionalProperties.put("invokerPackage", this.invokerPackage);
        }
    }

    protected String escapeUnderscore(String name) {
        if ("_".equals(name)) {
            return "_u";
        }
        return name;
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.apiPackage().replace('.', '/');
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + "/" + this.testFolder + "/" + this.apiPackage().replace('.', '/');
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.modelPackage().replace('.', '/');
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiTestFilename(String name) {
        return this.toApiName(name) + "Test";
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        return AbstractJavaCodegen.camelize(name) + "Api";
    }

    @Override
    public String toApiFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeVarName(name)).toLowerCase().matches("^_*class$")) {
            return "propertyClass";
        }
        if ((name = this.escapeUnderscore(name)).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.startsWithTwoUppercaseLetters(name)) {
            name = name.substring(0, 2).toLowerCase() + name.substring(2);
        }
        if (this.isReservedWord(name = this.camelizeVarName(name, true)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    public String camelizeVarName(String word, boolean lowercaseFirstLetter) {
        if (!(word = word.startsWith("_") && word.length() > 1 && !word.equals("_u") ? "_" + DefaultCodegenConfig.camelize(word, lowercaseFirstLetter) : DefaultCodegenConfig.camelize(word, lowercaseFirstLetter)).startsWith("$") || word.length() <= 1) {
            return word;
        }
        String letter = String.valueOf(word.charAt(1));
        if (!StringUtils.isAllUpperCase((CharSequence)letter)) {
            return word;
        }
        word = word.replaceFirst(letter, letter.toLowerCase());
        return word;
    }

    private boolean startsWithTwoUppercaseLetters(String name) {
        boolean startsWithTwoUppercaseLetters = false;
        if (name.length() > 1) {
            startsWithTwoUppercaseLetters = name.substring(0, 2).equals(name.substring(0, 2).toUpperCase());
        }
        return startsWithTwoUppercaseLetters;
    }

    @Override
    public String toParamName(String name) {
        if ("callback".equals(name)) {
            return "paramCallback";
        }
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        String camelizedName;
        String sanitizedName;
        if (!this.getIgnoreImportMapping() && this.importMapping.containsKey(name)) {
            return (String)this.importMapping.get(name);
        }
        String nameWithPrefixSuffix = sanitizedName = this.sanitizeName(name);
        if (!StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            nameWithPrefixSuffix = this.modelNamePrefix + "_" + nameWithPrefixSuffix;
        }
        if (!StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            nameWithPrefixSuffix = nameWithPrefixSuffix + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(camelizedName = AbstractJavaCodegen.camelize(nameWithPrefixSuffix))) {
            String modelName = "Model" + camelizedName;
            LOGGER.warn(camelizedName + " (reserved word) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        if (camelizedName.matches("^\\d.*")) {
            String modelName = "Model" + camelizedName;
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        return camelizedName;
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String getTypeDeclaration(Schema propertySchema) {
        if (propertySchema instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)propertySchema;
            Schema inner = arraySchema.getItems();
            if (inner == null) {
                LOGGER.warn(arraySchema.getName() + "(array property) does not have a proper inner type defined");
                return null;
            }
            return String.format("%s<%s>", this.getSchemaType(propertySchema), this.getTypeDeclaration(inner));
        }
        if (propertySchema instanceof MapSchema && AbstractJavaCodegen.hasSchemaProperties(propertySchema)) {
            Schema inner = (Schema)propertySchema.getAdditionalProperties();
            if (inner == null) {
                LOGGER.warn(propertySchema.getName() + "(map property) does not have a proper inner type defined");
                return null;
            }
            return this.getSchemaType(propertySchema) + "<String, " + this.getTypeDeclaration(inner) + ">";
        }
        if (propertySchema instanceof MapSchema && AbstractJavaCodegen.hasTrueAdditionalProperties(propertySchema)) {
            ObjectSchema inner = new ObjectSchema();
            return this.getSchemaType(propertySchema) + "<String, " + this.getTypeDeclaration((Schema)inner) + ">";
        }
        return super.getTypeDeclaration(propertySchema);
    }

    @Override
    public String getAlias(String name) {
        if (this.typeAliases != null && this.typeAliases.containsKey(name)) {
            return (String)this.typeAliases.get(name);
        }
        return name;
    }

    @Override
    public String toDefaultValue(Schema schema) {
        if (schema instanceof ArraySchema) {
            Boolean java8;
            ArraySchema arraySchema = (ArraySchema)schema;
            String pattern = this.fullJavaUtil ? "new java.util.ArrayList<%s>()" : "new ArrayList<%s>()";
            if (arraySchema.getItems() == null) {
                return null;
            }
            String typeDeclaration = this.getTypeDeclaration(arraySchema.getItems());
            Object java8obj = this.additionalProperties.get(JAVA8_MODE);
            if (java8obj != null && (java8 = Boolean.valueOf(java8obj.toString())) != null && java8.booleanValue()) {
                typeDeclaration = "";
            }
            return String.format(pattern, typeDeclaration);
        }
        if (schema instanceof MapSchema && AbstractJavaCodegen.hasSchemaProperties(schema)) {
            Boolean java8;
            String pattern = this.fullJavaUtil ? "new java.util.HashMap<%s>()" : "new HashMap<%s>()";
            if (schema.getAdditionalProperties() == null) {
                return null;
            }
            String typeDeclaration = String.format("String, %s", this.getTypeDeclaration((Schema)schema.getAdditionalProperties()));
            Object java8obj = this.additionalProperties.get(JAVA8_MODE);
            if (java8obj != null && (java8 = Boolean.valueOf(java8obj.toString())) != null && java8.booleanValue()) {
                typeDeclaration = "";
            }
            return String.format(pattern, typeDeclaration);
        }
        if (schema instanceof MapSchema && AbstractJavaCodegen.hasTrueAdditionalProperties(schema)) {
            Boolean java8;
            String pattern = this.fullJavaUtil ? "new java.util.HashMap<%s>()" : "new HashMap<%s>()";
            if (schema.getAdditionalProperties() == null) {
                return null;
            }
            ObjectSchema inner = new ObjectSchema();
            String typeDeclaration = String.format("String, %s", this.getTypeDeclaration((Schema)inner));
            Object java8obj = this.additionalProperties.get(JAVA8_MODE);
            if (java8obj != null && (java8 = Boolean.valueOf(java8obj.toString())) != null && java8.booleanValue()) {
                typeDeclaration = "";
            }
            return String.format(pattern, typeDeclaration);
        }
        if (schema instanceof IntegerSchema) {
            if (schema.getDefault() != null && "int64".equals(schema.getFormat())) {
                return String.format("%sl", schema.getDefault().toString());
            }
        } else if (schema instanceof NumberSchema) {
            if (schema.getDefault() != null) {
                if (schema.getDefault() != null && "float".equals(schema.getFormat())) {
                    return String.format("%sf", schema.getDefault().toString());
                }
                if (schema.getDefault() != null && "double".equals(schema.getFormat())) {
                    return String.format("%sd", schema.getDefault().toString());
                }
                return String.format("new BigDecimal(%s)", schema.getDefault().toString());
            }
        } else if (schema instanceof StringSchema && schema.getDefault() != null) {
            String _default = schema.getDefault().toString();
            if (schema.getEnum() == null) {
                return String.format("\"%s\"", this.escapeText(_default));
            }
            return _default;
        }
        return super.toDefaultValue(schema);
    }

    @Override
    public void setParameterExampleValue(CodegenParameter p) {
        String example = p.defaultValue == null ? p.example : p.defaultValue;
        String type = p.baseType;
        if (type == null) {
            type = p.dataType;
        }
        if ("String".equals(type)) {
            if (example == null) {
                example = p.paramName + "_example";
            }
            p.testExample = example;
            example = "\"" + this.escapeText(example) + "\"";
        } else if ("Integer".equals(type) || "Short".equals(type)) {
            if (example == null) {
                example = "56";
            }
        } else if ("Long".equals(type)) {
            if (example == null) {
                example = "56";
            }
            p.testExample = example;
            example = example + "L";
        } else if ("Float".equals(type)) {
            if (example == null) {
                example = "3.4";
            }
            p.testExample = example;
            example = example + "F";
        } else if ("Double".equals(type)) {
            p.testExample = example = "3.4";
            example = example + "D";
        } else if ("Boolean".equals(type)) {
            if (example == null) {
                example = "true";
            }
        } else if ("File".equals(type)) {
            if (example == null) {
                example = "/path/to/file";
            }
            example = "new File(\"" + this.escapeText(example) + "\")";
        } else if ("Date".equals(type)) {
            example = "new Date()";
        } else if (!this.languageSpecificPrimitives.contains(type)) {
            example = "new " + type + "()";
        }
        if (p.testExample == null) {
            p.testExample = example;
        }
        if (example == null) {
            example = "null";
        } else if (ExtensionHelper.getBooleanValue((VendorExtendable)p, "x-is-list-container")) {
            example = "Arrays.asList(" + example + ")";
        } else if (ExtensionHelper.getBooleanValue((VendorExtendable)p, "x-is-map-container")) {
            example = "new HashMap()";
        }
        p.example = example;
    }

    @Override
    public String toExampleValue(Schema schemaProperty) {
        if (schemaProperty.getExample() != null) {
            return this.escapeText(schemaProperty.getExample().toString());
        }
        return super.toExampleValue(schemaProperty);
    }

    @Override
    public String getSchemaType(Schema schema) {
        String schemaType = super.getSchemaType(schema);
        if (this.typeMapping.containsKey(schemaType = this.getAlias(schemaType))) {
            return (String)this.typeMapping.get(schemaType);
        }
        if (null == schemaType && schema.getName() != null) {
            LOGGER.warn("No Type defined for Property " + schema.getName());
        }
        return this.toModelName(schemaType);
    }

    @Override
    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method/operation name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId = AbstractJavaCodegen.camelize(this.sanitizeName(operationId), true))) {
            String newOperationId = AbstractJavaCodegen.camelize("call_" + operationId, true);
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + newOperationId);
            return newOperationId;
        }
        return operationId;
    }

    @Override
    public CodegenModel fromModel(String name, Schema schema, Map<String, Schema> allSchemas) {
        CodegenModel codegenModel = super.fromModel(name, schema, allSchemas);
        if (codegenModel.description != null) {
            if (this.useOas2) {
                codegenModel.imports.add("ApiModel");
            } else {
                codegenModel.imports.add("Schema");
            }
        }
        if (codegenModel.discriminator != null && this.additionalProperties.containsKey("jackson")) {
            codegenModel.imports.add("JsonSubTypes");
            codegenModel.imports.add("JsonTypeInfo");
        }
        boolean hasEnums = ExtensionHelper.getBooleanValue((VendorExtendable)codegenModel, "x-has-enums");
        if (allSchemas != null && codegenModel.parentSchema != null && hasEnums) {
            Schema parentModel = allSchemas.get(codegenModel.parentSchema);
            CodegenModel parentCodegenModel = super.fromModel(codegenModel.parent, parentModel, allSchemas);
            codegenModel = AbstractJavaCodegen.reconcileInlineEnums(codegenModel, parentCodegenModel);
        }
        if (this instanceof NotNullAnnotationFeatures && this instanceof NotNullAnnotationFeatures) {
            this.notNullOption = (NotNullAnnotationFeatures)((Object)this);
            if (this.additionalProperties.containsKey("notNullJacksonAnnotation") && this.notNullOption.isNotNullJacksonAnnotation()) {
                codegenModel.imports.add("JsonInclude");
            }
        }
        return codegenModel;
    }

    @Override
    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, Schema schema) {
        super.addAdditionPropertiesToCodeGenModel(codegenModel, schema);
        this.addVars(codegenModel, schema.getProperties(), schema.getRequired());
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        boolean isEnum;
        if (this.serializeBigDecimalAsString && property.baseType.equals("BigDecimal")) {
            property.vendorExtensions.put("extraAnnotation", "@JsonSerialize(using = ToStringSerializer.class)");
            model.imports.add("ToStringSerializer");
            model.imports.add("JsonSerialize");
        }
        if (!this.fullJavaUtil) {
            if ("array".equals(property.containerType)) {
                model.imports.add("ArrayList");
            } else if ("map".equals(property.containerType)) {
                model.imports.add("HashMap");
            }
        }
        if (!BooleanUtils.toBoolean((Boolean)(isEnum = ExtensionHelper.getBooleanValue((VendorExtendable)model, "x-is-enum")))) {
            if (this.useOas2) {
                model.imports.add("ApiModelProperty");
                model.imports.add("ApiModel");
            } else {
                model.imports.add("Schema");
            }
        }
        if (model.discriminator != null && model.discriminator.getPropertyName().equals(property.baseName)) {
            property.vendorExtensions.put("x-is-discriminator-property", true);
            if (this.additionalProperties.containsKey("jackson")) {
                model.imports.add("JsonTypeId");
            }
        }
    }

    @Override
    protected void fixUpParentAndInterfaces(CodegenModel codegenModel, Map<String, CodegenModel> allModels) {
        super.fixUpParentAndInterfaces(codegenModel, allModels);
        if (codegenModel.vars == null || codegenModel.vars.isEmpty() || codegenModel.parentModel == null) {
            return;
        }
        CodegenModel parentModel = codegenModel.parentModel;
        block0: for (CodegenProperty codegenProperty : codegenModel.vars) {
            while (parentModel != null) {
                if (parentModel.vars == null || parentModel.vars.isEmpty()) {
                    parentModel = parentModel.parentModel;
                    continue;
                }
                boolean hasConflict = parentModel.vars.stream().anyMatch(parentProperty -> parentProperty.name.equals(codegenProperty.name) && !parentProperty.datatype.equals(codegenProperty.datatype));
                if (hasConflict) {
                    codegenProperty.name = this.toVarName(codegenModel.name + "_" + codegenProperty.name);
                    codegenProperty.getter = this.toGetter(codegenProperty.name);
                    codegenProperty.setter = this.toGetter(codegenProperty.name);
                    continue block0;
                }
                parentModel = parentModel.parentModel;
            }
        }
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        List recursiveImports = (List)objs.get("imports");
        if (recursiveImports == null) {
            return objs;
        }
        ListIterator listIterator = recursiveImports.listIterator();
        while (listIterator.hasNext()) {
            String _import = (String)((Map)listIterator.next()).get("import");
            if (!this.importMapping.containsKey(_import)) continue;
            HashMap newImportMap = new HashMap();
            newImportMap.put("import", this.importMapping.get(_import));
            listIterator.add(newImportMap);
        }
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        List imports = (List)objs.get("imports");
        Pattern pattern = Pattern.compile("java\\.util\\.(List|ArrayList|Map|HashMap)");
        Iterator itr = imports.iterator();
        while (itr.hasNext()) {
            String _import = (String)((Map)itr.next()).get("import");
            if (!pattern.matcher(_import).matches()) continue;
            itr.remove();
        }
        return objs;
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        if (openAPI == null || openAPI.getPaths() == null) {
            return;
        }
        boolean checkDuplicatedModelName = Boolean.parseBoolean(this.additionalProperties.get(CHECK_DUPLICATED_MODEL_NAME) != null ? this.additionalProperties.get(CHECK_DUPLICATED_MODEL_NAME).toString() : "");
        if (checkDuplicatedModelName) {
            this.checkDuplicatedModelNameIgnoringCase(openAPI);
        }
        for (String pathname : openAPI.getPaths().keySet()) {
            PathItem pathItem = (PathItem)openAPI.getPaths().get((Object)pathname);
            for (Operation operation : pathItem.readOperations()) {
                if (operation == null) continue;
                if (!operation.equals((Object)pathItem.getGet())) {
                    String contentType = this.getContentType(operation.getRequestBody());
                    if (StringUtils.isBlank((CharSequence)contentType)) {
                        contentType = "application/json";
                    }
                    operation.addExtension("x-contentType", (Object)contentType);
                }
                String accepts = AbstractJavaCodegen.getAccept(operation);
                operation.addExtension("x-accepts", (Object)accepts);
            }
        }
    }

    private static String getAccept(Operation operation) {
        String accepts = null;
        if (operation != null && operation.getResponses() != null && !operation.getResponses().isEmpty()) {
            StringBuilder mediaTypeBuilder = new StringBuilder();
            block0: for (ApiResponse response : operation.getResponses().values()) {
                if (response.getContent() == null || response.getContent().isEmpty()) continue;
                for (String mediaTypeKey : response.getContent().keySet()) {
                    if ("application/json".equalsIgnoreCase(mediaTypeKey)) {
                        accepts = "application/json";
                        break block0;
                    }
                    if (mediaTypeBuilder.length() > 0) {
                        mediaTypeBuilder.append(",");
                    }
                    mediaTypeBuilder.append(mediaTypeKey);
                }
            }
            if (accepts == null) {
                accepts = mediaTypeBuilder.toString();
            }
        } else {
            accepts = "application/json";
        }
        return accepts;
    }

    @Override
    protected boolean needToImport(String type) {
        return super.needToImport(type) && type.indexOf(".") < 0;
    }

    protected void checkDuplicatedModelNameIgnoringCase(OpenAPI openAPI) {
        Map schemas = openAPI.getComponents().getSchemas();
        HashMap<String, HashMap<String, Schema>> schemasRepeated = new HashMap<String, HashMap<String, Schema>>();
        for (String schemaKey : schemas.keySet()) {
            Schema schema = (Schema)schemas.get(schemaKey);
            String lowerKeyDefinition = schemaKey.toLowerCase();
            if (schemasRepeated.containsKey(lowerKeyDefinition)) {
                HashMap<String, Schema> modelMap = (HashMap<String, Schema>)schemasRepeated.get(lowerKeyDefinition);
                if (modelMap == null) {
                    modelMap = new HashMap<String, Schema>();
                    schemasRepeated.put(lowerKeyDefinition, modelMap);
                }
                modelMap.put(schemaKey, schema);
                continue;
            }
            schemasRepeated.put(lowerKeyDefinition, null);
        }
        for (String lowerKeyDefinition : schemasRepeated.keySet()) {
            Map modelMap = (Map)schemasRepeated.get(lowerKeyDefinition);
            if (modelMap == null) continue;
            int index = 1;
            for (String name : modelMap.keySet()) {
                Schema schema = (Schema)modelMap.get(name);
                String newModelName = name + index;
                schemas.put(newModelName, schema);
                this.replaceDuplicatedInPaths(openAPI.getPaths(), name, newModelName);
                this.replaceDuplicatedInModelProperties(schemas, name, newModelName);
                schemas.remove(name);
                ++index;
            }
        }
    }

    protected void replaceDuplicatedInPaths(Paths paths, String modelName, String newModelName) {
        if (paths == null || paths.isEmpty()) {
            return;
        }
        paths.values().stream().flatMap(pathItem -> pathItem.readOperations().stream()).filter(operation -> {
            RequestBody requestBody = operation.getRequestBody();
            if (requestBody == null || requestBody.getContent() == null || requestBody.getContent().isEmpty()) {
                return false;
            }
            Optional mediaTypeOptional = requestBody.getContent().values().stream().findAny();
            if (!mediaTypeOptional.isPresent()) {
                return false;
            }
            MediaType mediaType = (MediaType)mediaTypeOptional.get();
            Schema schema = mediaType.getSchema();
            return schema.get$ref() != null;
        }).forEach(operation -> {
            Schema schema = this.getSchemaFromBody(operation.getRequestBody());
            schema.set$ref(schema.get$ref().replace(modelName, newModelName));
        });
        paths.values().stream().flatMap(path -> path.readOperations().stream()).flatMap(operation -> operation.getResponses().values().stream()).filter(response -> {
            if (response.getContent() == null || response.getContent().isEmpty()) {
                return false;
            }
            Optional mediaTypeOptional = response.getContent().values().stream().findFirst();
            if (!mediaTypeOptional.isPresent()) {
                return false;
            }
            MediaType mediaType = (MediaType)mediaTypeOptional.get();
            Schema schema = mediaType.getSchema();
            return schema.get$ref() != null;
        }).forEach(response -> {
            Optional mediaTypeOptional = response.getContent().values().stream().findFirst();
            Schema schema = ((MediaType)mediaTypeOptional.get()).getSchema();
            schema.set$ref(schema.get$ref().replace(modelName, newModelName));
        });
    }

    protected void replaceDuplicatedInModelProperties(Map<String, Schema> definitions, String modelName, String newModelName) {
        definitions.values().stream().flatMap(model -> model.getProperties().values().stream()).filter(property -> ((Schema)property).get$ref() != null).forEach(property -> {
            Schema schema = (Schema)property;
            schema.set$ref(schema.get$ref().replace(modelName, newModelName));
        });
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        return this.sanitizeName(AbstractJavaCodegen.camelize(property.name)) + "Enum";
    }

    @Override
    public String toEnumVarName(String value, String datatype) {
        if (value.length() == 0) {
            return "EMPTY";
        }
        if (this.getSymbolName(value) != null) {
            return this.getSymbolName(value).toUpperCase();
        }
        if ("Integer".equals(datatype) || "Long".equals(datatype) || "Float".equals(datatype) || "Double".equals(datatype) || "BigDecimal".equals(datatype)) {
            String varName = "NUMBER_" + value;
            varName = varName.replaceAll("-", "MINUS_");
            varName = varName.replaceAll("\\+", "PLUS_");
            varName = varName.replaceAll("\\.", "_DOT_");
            return varName;
        }
        String var = value.replaceAll("\\W+", "_").toUpperCase();
        if (var.matches("\\d.*")) {
            return "_" + var;
        }
        return this.escapeUnderscore(var).toUpperCase();
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if (value == null) {
            return null;
        }
        if ("Integer".equals(datatype) || "Double".equals(datatype) || "Boolean".equals(datatype)) {
            return value;
        }
        if ("Long".equals(datatype)) {
            return value + "l";
        }
        if ("Float".equals(datatype)) {
            return value + "f";
        }
        if ("BigDecimal".equals(datatype)) {
            return "new BigDecimal(" + this.escapeText(value) + ")";
        }
        return "\"" + this.escapeText(value) + "\"";
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, Map<String, Schema> schemas, OpenAPI openAPI) {
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, schemas, openAPI);
        op.path = this.sanitizePath(op.path);
        return op;
    }

    public String sanitizeVarName(String name) {
        if (name == null) {
            LOGGER.warn("String to be sanitized is null. Default to " + Object.class.getSimpleName());
            return Object.class.getSimpleName();
        }
        if ("$".equals(name)) {
            return "value";
        }
        name = name.replaceAll("\\[\\]", "");
        name = name.replaceAll("\\[", "_").replaceAll("\\]", "").replaceAll("\\(", "_").replaceAll("\\)", "").replaceAll("\\.", "_").replaceAll("@", "_at_").replaceAll("-", "_").replaceAll(" ", "_");
        name = this.allowUnicodeIdentifiers != false ? Pattern.compile("[\\W&&[^$]]", 256).matcher(name).replaceAll("") : name.replaceAll("[\\W&&[^$]]", "");
        return name;
    }

    private static CodegenModel reconcileInlineEnums(CodegenModel codegenModel, CodegenModel parentCodegenModel) {
        boolean hasEnums = ExtensionHelper.getBooleanValue((VendorExtendable)parentCodegenModel, "x-has-enums");
        if (!hasEnums) {
            return codegenModel;
        }
        List parentModelCodegenProperties = parentCodegenModel.vars;
        List codegenProperties = codegenModel.vars;
        boolean removedChildEnum = false;
        for (CodegenProperty parentModelCodegenPropery : parentModelCodegenProperties) {
            boolean isEnum = ExtensionHelper.getBooleanValue((VendorExtendable)parentModelCodegenPropery, "x-is-enum");
            if (!isEnum) continue;
            Iterator iterator = codegenProperties.iterator();
            while (iterator.hasNext()) {
                CodegenProperty codegenProperty = (CodegenProperty)iterator.next();
                isEnum = ExtensionHelper.getBooleanValue((VendorExtendable)codegenProperty, "x-is-enum");
                if (!isEnum || !AbstractJavaCodegen.isSameEnum(codegenProperty, parentModelCodegenPropery)) continue;
                iterator.remove();
                removedChildEnum = true;
            }
        }
        if (removedChildEnum) {
            int count = 0;
            int numVars = codegenProperties.size();
            for (CodegenProperty codegenProperty : codegenProperties) {
                codegenProperty.getVendorExtensions().put("x-has-more", ++count < numVars);
            }
            if (!codegenProperties.isEmpty()) {
                codegenModel.getVendorExtensions().put("x-has-vars", true);
                codegenModel.getVendorExtensions().put("x-has-enums", false);
            } else {
                codegenModel.emptyVars = true;
                codegenModel.getVendorExtensions().put("x-has-vars", false);
                codegenModel.getVendorExtensions().put("x-has-enums", false);
            }
            codegenModel.vars = codegenProperties;
        }
        return codegenModel;
    }

    protected static boolean isSameEnum(CodegenProperty actual, CodegenProperty other) {
        if (actual == null && other == null) {
            return true;
        }
        if (actual.name == null ? other.name != null : !actual.name.equals(other.name)) {
            return false;
        }
        if (actual.baseName == null ? other.baseName != null : !actual.baseName.equals(other.baseName)) {
            return false;
        }
        if (actual.datatype == null ? other.datatype != null : !actual.datatype.equals(other.datatype)) {
            return false;
        }
        if (actual.datatypeWithEnum == null ? other.datatypeWithEnum != null : !actual.datatypeWithEnum.equals(other.datatypeWithEnum)) {
            return false;
        }
        if (actual.baseType == null ? other.baseType != null : !actual.baseType.equals(other.baseType)) {
            return false;
        }
        return Objects.equals(actual.enumName, other.enumName);
    }

    private static String sanitizePackageName(String packageName) {
        packageName = packageName.trim();
        if ((packageName = packageName.replaceAll("[^a-zA-Z0-9_\\.]", "_")) == null || packageName.isEmpty()) {
            return "invalidPackageName";
        }
        return packageName;
    }

    public void setInvokerPackage(String invokerPackage) {
        this.invokerPackage = invokerPackage;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setArtifactVersion(String artifactVersion) {
        this.artifactVersion = artifactVersion;
    }

    public void setArtifactUrl(String artifactUrl) {
        this.artifactUrl = artifactUrl;
    }

    public void setArtifactDescription(String artifactDescription) {
        this.artifactDescription = artifactDescription;
    }

    public void setScmConnection(String scmConnection) {
        this.scmConnection = scmConnection;
    }

    public void setScmDeveloperConnection(String scmDeveloperConnection) {
        this.scmDeveloperConnection = scmDeveloperConnection;
    }

    public void setScmUrl(String scmUrl) {
        this.scmUrl = scmUrl;
    }

    public void setDeveloperName(String developerName) {
        this.developerName = developerName;
    }

    public void setDeveloperEmail(String developerEmail) {
        this.developerEmail = developerEmail;
    }

    public void setDeveloperOrganization(String developerOrganization) {
        this.developerOrganization = developerOrganization;
    }

    public void setDeveloperOrganizationUrl(String developerOrganizationUrl) {
        this.developerOrganizationUrl = developerOrganizationUrl;
    }

    public void setLicenseName(String licenseName) {
        this.licenseName = licenseName;
    }

    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    public void setTestFolder(String testFolder) {
        this.testFolder = testFolder;
    }

    public void setLocalVariablePrefix(String localVariablePrefix) {
        this.localVariablePrefix = localVariablePrefix;
    }

    public void setSerializeBigDecimalAsString(boolean s) {
        this.serializeBigDecimalAsString = s;
    }

    public void setSerializableModel(Boolean serializableModel) {
        this.serializableModel = serializableModel;
    }

    private String sanitizePath(String p) {
        return p.replaceAll("\"", "%22");
    }

    public void setFullJavaUtil(boolean fullJavaUtil) {
        this.fullJavaUtil = fullJavaUtil;
    }

    public void setWithXml(boolean withXml) {
        this.withXml = withXml;
    }

    public void setDateLibrary(String library) {
        this.dateLibrary = library;
    }

    public void setJava8Mode(boolean enabled) {
        this.java8Mode = enabled;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    private String deriveInvokerPackageName(String input) {
        String[] parts = input.split(Pattern.quote("."));
        StringBuilder sb = new StringBuilder();
        String delim = "";
        for (String p : Arrays.copyOf(parts, parts.length - 1)) {
            sb.append(delim).append(p);
            delim = ".";
        }
        return sb.toString();
    }

    public void setSupportJava6(boolean value) {
        this.supportJava6 = value;
    }

    @Override
    public String toRegularExpression(String pattern) {
        return this.escapeText(pattern);
    }

    @Override
    public boolean convertPropertyToBoolean(String propertyKey) {
        boolean booleanValue = false;
        if (this.additionalProperties.containsKey(propertyKey)) {
            booleanValue = Boolean.valueOf(this.additionalProperties.get(propertyKey).toString());
        }
        return booleanValue;
    }

    @Override
    public void writePropertyBack(String propertyKey, boolean value) {
        this.additionalProperties.put(propertyKey, value);
    }

    @Override
    public String toBooleanGetter(String name) {
        return "is" + this.getterAndSetterCapitalize(name);
    }

    @Override
    public String sanitizeTag(String tag) {
        if ((tag = AbstractJavaCodegen.camelize(AbstractJavaCodegen.underscore(this.sanitizeName(tag)))).matches("^\\d.*")) {
            tag = "Class" + tag;
        }
        return tag;
    }

    @Override
    public void addHandlebarHelpers(Handlebars handlebars) {
        super.addHandlebarHelpers(handlebars);
        handlebars.registerHelpers((Object)new JavaHelper());
    }

    @Override
    public void setLanguageArguments(List<CodegenArgument> languageArguments) {
        if (languageArguments != null && !languageArguments.stream().anyMatch(codegenArgument -> "--use-oas2".equalsIgnoreCase(codegenArgument.getOption()) && StringUtils.isNotBlank((CharSequence)codegenArgument.getValue()))) {
            languageArguments.add(new CodegenArgument().option("--use-oas2").type("boolean").value(Boolean.FALSE.toString()));
        }
        super.setLanguageArguments(languageArguments);
    }

    @Override
    public boolean defaultIgnoreImportMappingOption() {
        return true;
    }

    public boolean checkAliasModel() {
        return true;
    }
}

