/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.samskivert.mustache.Mustache;
import io.swagger.codegen.v3.CliOption;
import io.swagger.codegen.v3.CodegenArgument;
import io.swagger.codegen.v3.CodegenConfig;
import io.swagger.codegen.v3.CodegenContent;
import io.swagger.codegen.v3.CodegenModel;
import io.swagger.codegen.v3.CodegenModelFactory;
import io.swagger.codegen.v3.CodegenModelType;
import io.swagger.codegen.v3.CodegenOperation;
import io.swagger.codegen.v3.CodegenParameter;
import io.swagger.codegen.v3.CodegenProperty;
import io.swagger.codegen.v3.CodegenResponse;
import io.swagger.codegen.v3.CodegenSecurity;
import io.swagger.codegen.v3.ISchemaHandler;
import io.swagger.codegen.v3.SupportingFile;
import io.swagger.codegen.v3.VendorExtendable;
import io.swagger.codegen.v3.generators.CodegenHelper;
import io.swagger.codegen.v3.generators.SchemaHandler;
import io.swagger.codegen.v3.generators.examples.ExampleGenerator;
import io.swagger.codegen.v3.generators.handlebars.BaseItemsHelper;
import io.swagger.codegen.v3.generators.handlebars.BracesHelper;
import io.swagger.codegen.v3.generators.handlebars.ExtensionHelper;
import io.swagger.codegen.v3.generators.handlebars.HasHelper;
import io.swagger.codegen.v3.generators.handlebars.HasNotHelper;
import io.swagger.codegen.v3.generators.handlebars.IsHelper;
import io.swagger.codegen.v3.generators.handlebars.IsNotHelper;
import io.swagger.codegen.v3.generators.handlebars.NotEmptyHelper;
import io.swagger.codegen.v3.generators.handlebars.StringUtilHelper;
import io.swagger.codegen.v3.generators.util.OpenAPIUtil;
import io.swagger.codegen.v3.templates.HandlebarTemplateEngine;
import io.swagger.codegen.v3.templates.MustacheTemplateEngine;
import io.swagger.codegen.v3.templates.TemplateEngine;
import io.swagger.codegen.v3.utils.ModelUtils;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BinarySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.ByteArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.EmailSchema;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.media.UUIDSchema;
import io.swagger.v3.oas.models.parameters.CookieParameter;
import io.swagger.v3.oas.models.parameters.HeaderParameter;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.PathParameter;
import io.swagger.v3.oas.models.parameters.QueryParameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.OAuthFlows;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultCodegenConfig
implements CodegenConfig {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DefaultCodegenConfig.class);
    public static final String DEFAULT_CONTENT_TYPE = "application/json";
    public static final String REQUEST_BODY_NAME = "body";
    public static final String DEFAULT_TEMPLATE_DIR = "handlebars";
    protected OpenAPI openAPI;
    protected OpenAPI unflattenedOpenAPI;
    protected String inputSpec;
    protected String inputURL;
    protected String outputFolder = "";
    protected Set<String> defaultIncludes = new HashSet<String>();
    protected Map<String, String> typeMapping = new HashMap<String, String>();
    protected Map<String, String> instantiationTypes = new HashMap<String, String>();
    protected Set<String> reservedWords = new HashSet<String>();
    protected Set<String> languageSpecificPrimitives = new HashSet<String>();
    protected Map<String, String> importMapping = new HashMap<String, String>();
    protected String modelPackage = "";
    protected String apiPackage = "";
    protected String fileSuffix;
    protected String modelNamePrefix = "";
    protected String modelNameSuffix = "";
    protected String testPackage = "";
    protected Map<String, String> apiTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> modelTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> apiTestTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> modelTestTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> apiDocTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> modelDocTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> reservedWordsMappings = new HashMap<String, String>();
    protected String templateDir;
    protected String customTemplateDir;
    protected String templateVersion;
    protected String embeddedTemplateDir;
    protected String commonTemplateDir = "_common";
    protected Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected Map<String, Object> vendorExtensions = new HashMap<String, Object>();
    protected List<SupportingFile> supportingFiles = new ArrayList<SupportingFile>();
    protected List<CliOption> cliOptions = new ArrayList<CliOption>();
    protected List<CodegenArgument> languageArguments;
    protected boolean skipOverwrite;
    protected boolean removeOperationIdPrefix;
    protected boolean supportsInheritance;
    protected boolean supportsMixins;
    protected Map<String, String> supportedLibraries = new LinkedHashMap<String, String>();
    protected String library;
    protected Boolean sortParamsByRequiredFlag = true;
    protected Boolean ensureUniqueParams = true;
    protected Boolean allowUnicodeIdentifiers = false;
    protected String gitUserId;
    protected String gitRepoId;
    protected String releaseNote;
    protected String httpUserAgent;
    protected Boolean hideGenerationTimestamp = true;
    protected TemplateEngine templateEngine = new HandlebarTemplateEngine((CodegenConfig)this);
    protected Map<String, String> specialCharReplacements = new HashMap<String, String>();
    protected Map<String, String> typeAliases = null;
    protected String ignoreFilePathOverride;
    protected boolean useOas2 = false;
    protected boolean copyFistAllOfProperties = false;
    protected boolean ignoreImportMapping;

    public List<CliOption> cliOptions() {
        return this.cliOptions;
    }

    public void processOpts() {
        if (this.additionalProperties.containsKey("templateDir")) {
            this.customTemplateDir = this.additionalProperties.get("templateDir").toString();
        }
        this.embeddedTemplateDir = this.templateDir = this.getTemplateDir();
        if (this.additionalProperties.get("ignoreImportMappings") != null) {
            this.setIgnoreImportMapping(Boolean.parseBoolean(this.additionalProperties.get("ignoreImportMappings").toString()));
        } else {
            this.setIgnoreImportMapping(this.defaultIgnoreImportMappingOption());
        }
        if (this.additionalProperties.containsKey("templateVersion")) {
            this.setTemplateVersion((String)this.additionalProperties.get("templateVersion"));
        }
        if (this.additionalProperties.containsKey("modelPackage")) {
            this.setModelPackage((String)this.additionalProperties.get("modelPackage"));
        } else if (StringUtils.isNotEmpty((CharSequence)this.modelPackage)) {
            this.additionalProperties.put("modelPackage", this.modelPackage);
        }
        if (this.additionalProperties.containsKey("apiPackage")) {
            this.setApiPackage((String)this.additionalProperties.get("apiPackage"));
        } else if (StringUtils.isNotEmpty((CharSequence)this.apiPackage)) {
            this.additionalProperties.put("apiPackage", this.apiPackage);
        }
        if (this.additionalProperties.containsKey("sortParamsByRequiredFlag")) {
            this.setSortParamsByRequiredFlag(Boolean.valueOf(this.additionalProperties.get("sortParamsByRequiredFlag").toString()));
        } else if (this.sortParamsByRequiredFlag != null) {
            this.additionalProperties.put("sortParamsByRequiredFlag", this.sortParamsByRequiredFlag);
        }
        if (this.additionalProperties.containsKey("ensureUniqueParams")) {
            this.setEnsureUniqueParams(Boolean.valueOf(this.additionalProperties.get("ensureUniqueParams").toString()));
        }
        if (this.additionalProperties.containsKey("allowUnicodeIdentifiers")) {
            this.setAllowUnicodeIdentifiers(Boolean.valueOf(this.additionalProperties.get("allowUnicodeIdentifiers").toString()));
        }
        if (this.additionalProperties.containsKey("modelNamePrefix")) {
            this.setModelNamePrefix((String)this.additionalProperties.get("modelNamePrefix"));
        }
        if (this.additionalProperties.containsKey("modelNameSuffix")) {
            this.setModelNameSuffix((String)this.additionalProperties.get("modelNameSuffix"));
        }
        if (this.additionalProperties.containsKey("removeOperationIdPrefix")) {
            this.setRemoveOperationIdPrefix(Boolean.valueOf(this.additionalProperties.get("removeOperationIdPrefix").toString()));
        }
        if (this.additionalProperties.containsKey("hideGenerationTimestamp")) {
            this.setHideGenerationTimestamp(Boolean.valueOf(this.additionalProperties.get("hideGenerationTimestamp").toString()));
        } else if (this.hideGenerationTimestamp != null) {
            this.additionalProperties.put("hideGenerationTimestamp", this.hideGenerationTimestamp);
        }
        if (this.additionalProperties.containsKey("useOas2")) {
            this.setUseOas2(Boolean.valueOf(this.additionalProperties.get("useOas2").toString()));
        }
        this.setTemplateEngine();
    }

    public Map<String, Object> postProcessAllModels(Map<String, Object> processedModels) {
        HashMap<String, CodegenModel> allModels = new HashMap<String, CodegenModel>();
        for (Map.Entry<String, Object> entry : processedModels.entrySet()) {
            String modelName = this.toModelName(entry.getKey());
            Map inner = (Map)entry.getValue();
            List models = (List)inner.get("models");
            for (Map mo : models) {
                CodegenModel codegenModel = (CodegenModel)mo.get("model");
                allModels.put(modelName, codegenModel);
            }
        }
        this.postProcessAllCodegenModels(allModels);
        return processedModels;
    }

    protected void postProcessAllCodegenModels(Map<String, CodegenModel> allModels) {
        if (this.supportsInheritance) {
            for (String name : allModels.keySet()) {
                CodegenModel codegenModel = allModels.get(name);
                this.fixUpParentAndInterfaces(codegenModel, allModels);
            }
        }
    }

    protected void fixUpParentAndInterfaces(CodegenModel codegenModel, Map<String, CodegenModel> allModels) {
        if (codegenModel.parent != null) {
            codegenModel.parentModel = allModels.get(codegenModel.parent);
        }
        if (codegenModel.interfaces != null && !codegenModel.interfaces.isEmpty()) {
            codegenModel.interfaceModels = new ArrayList(codegenModel.interfaces.size());
            for (String intf : codegenModel.interfaces) {
                CodegenModel intfModel = allModels.get(intf);
                if (intfModel == null) continue;
                codegenModel.interfaceModels.add(intfModel);
            }
        }
        CodegenModel parent = codegenModel.parentModel;
        while (parent != null) {
            if (parent.children == null) {
                parent.children = new ArrayList();
            }
            parent.children.add(codegenModel);
            if (parent.discriminator == null) {
                parent = allModels.get(parent.parent);
                continue;
            }
            parent = null;
        }
    }

    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        return objs;
    }

    public Map<String, Object> postProcessModelsEnum(Map<String, Object> objs) {
        this.processModelEnums(objs);
        return objs;
    }

    public void processModelEnums(Map<String, Object> objs) {
        List models = (List)objs.get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            boolean isEnum = ExtensionHelper.getBooleanValue((VendorExtendable)cm, "x-is-enum");
            if (Boolean.TRUE.equals(isEnum) && cm.allowableValues != null) {
                Map allowableValues = cm.allowableValues;
                List values = (List)allowableValues.get("values");
                ArrayList enumVars = new ArrayList();
                String commonPrefix = this.findCommonPrefixOfVars(values);
                int truncateIdx = commonPrefix.length();
                for (Object value : values) {
                    HashMap<String, String> enumVar = new HashMap<String, String>();
                    String enumName = this.findEnumName(truncateIdx, value);
                    enumVar.put("name", this.toEnumVarName(enumName, cm.dataType));
                    if (value == null) {
                        enumVar.put("value", this.toEnumValue(null, cm.dataType));
                    } else {
                        enumVar.put("value", this.toEnumValue(value.toString(), cm.dataType));
                    }
                    enumVars.add(enumVar);
                }
                cm.allowableValues.put("enumVars", enumVars);
            }
            this.updateCodegenModelEnumVars(cm);
        }
    }

    public boolean isPrimivite(String datatype) {
        return "number".equalsIgnoreCase(datatype) || "integer".equalsIgnoreCase(datatype) || "boolean".equalsIgnoreCase(datatype);
    }

    protected void updateCodegenModelEnumVars(CodegenModel codegenModel) {
        for (CodegenProperty var : codegenModel.vars) {
            this.updateCodegenPropertyEnum(var);
        }
    }

    private String findEnumName(int truncateIdx, Object value) {
        String enumName;
        if (value == null) {
            return "null";
        }
        if (truncateIdx == 0) {
            enumName = value.toString();
        } else {
            enumName = value.toString().substring(truncateIdx);
            if ("".equals(enumName)) {
                enumName = value.toString();
            }
        }
        return enumName;
    }

    public String findCommonPrefixOfVars(List<Object> vars) {
        if (vars.size() > 1) {
            try {
                String[] listStr = vars.toArray(new String[vars.size()]);
                String prefix = StringUtils.getCommonPrefix((String[])listStr);
                return prefix.replaceAll("[a-zA-Z0-9]+\\z", "");
            }
            catch (ArrayStoreException arrayStoreException) {
                // empty catch block
            }
        }
        return "";
    }

    public String toEnumDefaultValue(String value, String datatype) {
        return datatype + "." + value;
    }

    public String toEnumValue(String value, String datatype) {
        if (value == null) {
            return null;
        }
        if ("number".equalsIgnoreCase(datatype)) {
            return value;
        }
        return "\"" + this.escapeText(value) + "\"";
    }

    public String toEnumVarName(String value, String datatype) {
        return ModelUtils.toEnumVarName((String)value);
    }

    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        return objs;
    }

    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        return objs;
    }

    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        return objs;
    }

    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
    }

    public void postProcessParameter(CodegenParameter parameter) {
    }

    public void preprocessOpenAPI(OpenAPI openAPI) {
        this.openAPI = openAPI;
    }

    public void processOpenAPI(OpenAPI openAPI) {
    }

    public Mustache.Compiler processCompiler(Mustache.Compiler compiler) {
        return compiler;
    }

    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public String escapeText(String input) {
        if (input == null) {
            return input;
        }
        return this.escapeUnsafeCharacters(StringEscapeUtils.unescapeJava((String)StringEscapeUtils.escapeJava((String)input).replace("\\/", "/")).replaceAll("[\\t\\n\\r]", " ").replace("\\", "\\\\").replace("\"", "\\\""));
    }

    public String escapeUnsafeCharacters(String input) {
        LOGGER.warn("escapeUnsafeCharacters should be overridden in the code generator with proper logic to escape unsafe characters");
        return input;
    }

    public String escapeQuotationMark(String input) {
        LOGGER.warn("escapeQuotationMark should be overridden in the code generator with proper logic to escape single/double quote");
        return input.replace("\"", "\\\"");
    }

    public Set<String> defaultIncludes() {
        return this.defaultIncludes;
    }

    public Map<String, String> typeMapping() {
        return this.typeMapping;
    }

    public Map<String, String> instantiationTypes() {
        return this.instantiationTypes;
    }

    public Set<String> reservedWords() {
        return this.reservedWords;
    }

    public Set<String> languageSpecificPrimitives() {
        return this.languageSpecificPrimitives;
    }

    public Map<String, String> importMapping() {
        return this.importMapping;
    }

    public String testPackage() {
        return this.testPackage;
    }

    public String modelPackage() {
        return this.modelPackage;
    }

    public String apiPackage() {
        return this.apiPackage;
    }

    public String fileSuffix() {
        return this.fileSuffix;
    }

    public String templateDir() {
        return this.templateDir;
    }

    public String embeddedTemplateDir() {
        if (this.embeddedTemplateDir != null) {
            return this.embeddedTemplateDir;
        }
        return this.templateDir;
    }

    public String customTemplateDir() {
        return this.customTemplateDir;
    }

    public String getCommonTemplateDir() {
        return this.commonTemplateDir;
    }

    public void setCommonTemplateDir(String commonTemplateDir) {
        this.commonTemplateDir = commonTemplateDir;
    }

    public Map<String, String> apiDocTemplateFiles() {
        return this.apiDocTemplateFiles;
    }

    public Map<String, String> modelDocTemplateFiles() {
        return this.modelDocTemplateFiles;
    }

    public Map<String, String> reservedWordsMappings() {
        return this.reservedWordsMappings;
    }

    public Map<String, String> apiTestTemplateFiles() {
        return this.apiTestTemplateFiles;
    }

    public Map<String, String> modelTestTemplateFiles() {
        return this.modelTestTemplateFiles;
    }

    public Map<String, String> apiTemplateFiles() {
        return this.apiTemplateFiles;
    }

    public Map<String, String> modelTemplateFiles() {
        return this.modelTemplateFiles;
    }

    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.modelPackage().replace('.', File.separatorChar);
    }

    public String apiTestFileFolder() {
        return this.outputFolder + File.separator + this.testPackage().replace('.', File.separatorChar);
    }

    public String modelTestFileFolder() {
        return this.outputFolder + File.separator + this.testPackage().replace('.', File.separatorChar);
    }

    public String apiDocFileFolder() {
        return this.outputFolder;
    }

    public String modelDocFileFolder() {
        return this.outputFolder;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public Map<String, Object> vendorExtensions() {
        return this.vendorExtensions;
    }

    public List<SupportingFile> supportingFiles() {
        return this.supportingFiles;
    }

    public String outputFolder() {
        return this.outputFolder;
    }

    public void setOutputDir(String dir) {
        this.outputFolder = dir;
    }

    public String getOutputDir() {
        return this.outputFolder();
    }

    public String getInputSpec() {
        return this.inputSpec;
    }

    public void setInputSpec(String inputSpec) {
        this.inputSpec = inputSpec;
    }

    public String getInputURL() {
        return this.inputURL;
    }

    public void setInputURL(String inputURL) {
        this.inputURL = inputURL;
    }

    public void setTemplateDir(String templateDir) {
        this.templateDir = templateDir;
    }

    public String getTemplateVersion() {
        return this.templateVersion;
    }

    public void setTemplateVersion(String templateVersion) {
        this.templateVersion = templateVersion;
    }

    public void setModelPackage(String modelPackage) {
        this.modelPackage = modelPackage;
    }

    public void setModelNamePrefix(String modelNamePrefix) {
        this.modelNamePrefix = modelNamePrefix;
    }

    public void setModelNameSuffix(String modelNameSuffix) {
        this.modelNameSuffix = modelNameSuffix;
    }

    public void setApiPackage(String apiPackage) {
        this.apiPackage = apiPackage;
    }

    public Boolean getSortParamsByRequiredFlag() {
        return this.sortParamsByRequiredFlag;
    }

    public void setSortParamsByRequiredFlag(Boolean sortParamsByRequiredFlag) {
        this.sortParamsByRequiredFlag = sortParamsByRequiredFlag;
    }

    public void setEnsureUniqueParams(Boolean ensureUniqueParams) {
        this.ensureUniqueParams = ensureUniqueParams;
    }

    public void setAllowUnicodeIdentifiers(Boolean allowUnicodeIdentifiers) {
        this.allowUnicodeIdentifiers = allowUnicodeIdentifiers;
    }

    public String toRegularExpression(String pattern) {
        return this.addRegularExpressionDelimiter(this.escapeText(pattern));
    }

    public String toApiFilename(String name) {
        return this.toApiName(name);
    }

    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    public String toApiTestFilename(String name) {
        return this.toApiName(name) + "Test";
    }

    public String toApiVarName(String name) {
        return this.snakeCase(name);
    }

    public String toModelFilename(String name) {
        return this.initialCaps(name);
    }

    public String toModelTestFilename(String name) {
        return this.initialCaps(name) + "Test";
    }

    public String toModelDocFilename(String name) {
        return this.initialCaps(name);
    }

    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        return operationId;
    }

    public String toVarName(String name) {
        if (this.reservedWords.contains(name)) {
            return this.escapeReservedWord(name);
        }
        return name;
    }

    public String toParamName(String name) {
        if (this.reservedWords.contains(name = this.removeNonNameElementToCamelCase(name))) {
            return this.escapeReservedWord(name);
        }
        return name;
    }

    public String toEnumName(CodegenProperty property) {
        return StringUtils.capitalize((String)property.name) + "Enum";
    }

    public String escapeReservedWord(String name) {
        throw new RuntimeException("reserved word " + name + " not allowed");
    }

    public String toModelImport(String name) {
        if ("".equals(this.modelPackage())) {
            return name;
        }
        return this.modelPackage() + "." + name;
    }

    public String toApiImport(String name) {
        return this.apiPackage() + "." + name;
    }

    public DefaultCodegenConfig() {
        this.defaultIncludes = CodegenHelper.getDefaultIncludes();
        this.typeMapping = CodegenHelper.getTypeMappings();
        this.instantiationTypes = new HashMap<String, String>();
        this.reservedWords = new HashSet<String>();
        this.importMapping = CodegenHelper.getImportMappings();
        this.cliOptions.add(CliOption.newBoolean((String)"sortParamsByRequiredFlag", (String)"Sort method arguments to place required parameters before optional parameters.").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(CliOption.newBoolean((String)"ensureUniqueParams", (String)"Whether to ensure parameter names are unique in an operation (rename parameters that are not).").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(CliOption.newBoolean((String)"allowUnicodeIdentifiers", (String)"boolean, toggles whether unicode identifiers are allowed in names or not, default is false").defaultValue(Boolean.FALSE.toString()));
        CodegenHelper.initalizeSpecialCharacterMapping(this.specialCharReplacements);
    }

    protected String getSymbolName(String input) {
        return this.specialCharReplacements.get(input);
    }

    public String generateExamplePath(String path, Operation operation) {
        StringBuilder sb = new StringBuilder();
        sb.append(path);
        if (operation.getParameters() != null) {
            int count = 0;
            for (Parameter param : operation.getParameters()) {
                if (!(param instanceof QueryParameter)) continue;
                StringBuilder paramPart = new StringBuilder();
                QueryParameter queryParameter = (QueryParameter)param;
                if (count == 0) {
                    paramPart.append("?");
                } else {
                    paramPart.append(",");
                }
                ++count;
                if (!param.getRequired().booleanValue()) {
                    paramPart.append("[");
                }
                paramPart.append(param.getName()).append("=");
                paramPart.append("{");
                if (queryParameter.getStyle() != null) {
                    paramPart.append(param.getName()).append("1");
                    if (Parameter.StyleEnum.FORM.equals((Object)queryParameter.getStyle())) {
                        if (queryParameter.getExplode() != null && queryParameter.getExplode().booleanValue()) {
                            paramPart.append(",");
                        } else {
                            paramPart.append("&").append(param.getName()).append("=");
                            paramPart.append(param.getName()).append("2");
                        }
                    } else if (Parameter.StyleEnum.PIPEDELIMITED.equals((Object)queryParameter.getStyle())) {
                        paramPart.append("|");
                    } else if (Parameter.StyleEnum.SPACEDELIMITED.equals((Object)queryParameter.getStyle())) {
                        paramPart.append("%20");
                    }
                } else {
                    paramPart.append(param.getName());
                }
                paramPart.append("}");
                if (!param.getRequired().booleanValue()) {
                    paramPart.append("]");
                }
                sb.append(paramPart.toString());
            }
        }
        return sb.toString();
    }

    public String toInstantiationType(Schema property) {
        if (property instanceof MapSchema && DefaultCodegenConfig.hasSchemaProperties(property)) {
            Schema additionalProperties = (Schema)property.getAdditionalProperties();
            String type = additionalProperties.getType();
            if (null == type) {
                LOGGER.error("No Type defined for Additional Property " + additionalProperties + "\n\tIn Property: " + property);
            }
            String inner = this.getSchemaType(additionalProperties);
            return this.instantiationTypes.get("map") + "<String, " + inner + ">";
        }
        if (property instanceof MapSchema && DefaultCodegenConfig.hasTrueAdditionalProperties(property)) {
            String inner = this.getSchemaType((Schema)new ObjectSchema());
            return this.instantiationTypes.get("map") + "<String, " + inner + ">";
        }
        if (property instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)property;
            String inner = this.getSchemaType(arraySchema.getItems());
            return this.instantiationTypes.get("array") + "<" + inner + ">";
        }
        return null;
    }

    public void setParameterExampleValue(CodegenParameter p) {
    }

    public String toExampleValue(Schema property) {
        return String.valueOf(property.getExample());
    }

    public String toDefaultValue(Schema property) {
        return String.valueOf(property.getDefault());
    }

    public String toDefaultValueWithParam(String name, Schema property) {
        return " = data." + name + ";";
    }

    public String getSchemaType(Schema property) {
        String datatype = null;
        if (StringUtils.isNotBlank((CharSequence)property.get$ref())) {
            try {
                datatype = property.get$ref();
                if (datatype.indexOf("#/components/schemas/") == 0) {
                    datatype = datatype.substring("#/components/schemas/".length());
                    return datatype;
                }
            }
            catch (Exception e) {
                LOGGER.warn("Error obtaining the datatype from ref:" + property + ". Datatype default to Object");
                datatype = "Object";
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            return datatype;
        }
        datatype = DefaultCodegenConfig.getTypeOfSchema(property);
        return datatype;
    }

    private static String getTypeOfSchema(Schema schema) {
        if (schema instanceof StringSchema && "number".equals(schema.getFormat())) {
            return "BigDecimal";
        }
        if (schema instanceof ByteArraySchema) {
            return "ByteArray";
        }
        if (schema instanceof BinarySchema) {
            return "binary";
        }
        if (schema instanceof FileSchema) {
            return "binary";
        }
        if (schema instanceof BooleanSchema) {
            return "boolean";
        }
        if (schema instanceof DateSchema) {
            return "date";
        }
        if (schema instanceof DateTimeSchema) {
            return "DateTime";
        }
        if (schema instanceof NumberSchema) {
            if ("float".equals(schema.getFormat())) {
                return "float";
            }
            if ("double".equals(schema.getFormat())) {
                return "double";
            }
            return "BigDecimal";
        }
        if (schema instanceof IntegerSchema) {
            if ("int64".equals(schema.getFormat())) {
                return "long";
            }
            return "integer";
        }
        if (schema instanceof MapSchema) {
            return "map";
        }
        if (schema instanceof ObjectSchema) {
            return "object";
        }
        if (schema instanceof UUIDSchema) {
            return "UUID";
        }
        if (schema instanceof StringSchema) {
            return "string";
        }
        if (schema instanceof ComposedSchema && schema.getExtensions() != null && schema.getExtensions().containsKey("x-model-name")) {
            return schema.getExtensions().get("x-model-name").toString();
        }
        if (schema != null) {
            if ("object".equals(schema.getType()) && (DefaultCodegenConfig.hasSchemaProperties(schema) || DefaultCodegenConfig.hasTrueAdditionalProperties(schema))) {
                return "map";
            }
            if (schema.getType() == null && schema.getProperties() != null && !schema.getProperties().isEmpty()) {
                return "object";
            }
            return schema.getType();
        }
        return null;
    }

    public String snakeCase(String name) {
        return name.length() > 0 ? Character.toLowerCase(name.charAt(0)) + name.substring(1) : "";
    }

    public String initialCaps(String name) {
        return StringUtils.capitalize((String)name);
    }

    public String getTypeDeclaration(String name) {
        return name;
    }

    public String getTypeDeclaration(Schema schema) {
        String schemaType = this.getSchemaType(schema);
        if (this.typeMapping.containsKey(schemaType)) {
            return this.typeMapping.get(schemaType);
        }
        return schemaType;
    }

    public String getAlias(String name) {
        return name;
    }

    public String toBooleanGetter(String name) {
        return "get" + this.getterAndSetterCapitalize(name);
    }

    public String toGetter(String name) {
        return "get" + this.getterAndSetterCapitalize(name);
    }

    public String toSetter(String name) {
        return "set" + this.getterAndSetterCapitalize(name);
    }

    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        return this.initialCaps(name) + "Api";
    }

    public String toModelName(String name) {
        return this.initialCaps(this.modelNamePrefix + name + this.modelNameSuffix);
    }

    public CodegenModel fromModel(String name, Schema schema) {
        if (this.openAPI != null && this.openAPI.getComponents() != null && this.openAPI.getComponents().getSchemas() != null) {
            return this.fromModel(name, schema, this.openAPI.getComponents().getSchemas());
        }
        return this.fromModel(name, schema, null);
    }

    public CodegenModel fromModel(String name, Schema schema, Map<String, Schema> allDefinitions) {
        if (this.typeAliases == null) {
            this.typeAliases = DefaultCodegenConfig.getAllAliases(allDefinitions);
        }
        CodegenModel codegenModel = (CodegenModel)CodegenModelFactory.newInstance((CodegenModelType)CodegenModelType.MODEL);
        codegenModel.name = this.reservedWords.contains(name) ? this.escapeReservedWord(name) : name;
        codegenModel.title = this.escapeText(schema.getTitle());
        codegenModel.description = this.escapeText(schema.getDescription());
        codegenModel.unescapedDescription = schema.getDescription();
        codegenModel.classname = this.toModelName(name);
        codegenModel.classVarName = this.toVarName(name);
        codegenModel.classFilename = this.toModelFilename(name);
        codegenModel.modelJson = Json.pretty((Object)schema);
        codegenModel.externalDocumentation = schema.getExternalDocs();
        if (schema.getExtensions() != null && !schema.getExtensions().isEmpty()) {
            codegenModel.getVendorExtensions().putAll(schema.getExtensions());
        }
        codegenModel.getVendorExtensions().put("x-is-alias", this.typeAliases.containsKey(name));
        codegenModel.discriminator = schema.getDiscriminator();
        if (schema.getXml() != null) {
            codegenModel.xmlPrefix = schema.getXml().getPrefix();
            codegenModel.xmlNamespace = schema.getXml().getNamespace();
            codegenModel.xmlName = schema.getXml().getName();
        }
        if (schema instanceof ArraySchema) {
            codegenModel.getVendorExtensions().put("x-is-array-model", Boolean.TRUE);
            codegenModel.getVendorExtensions().put("x-is-container", Boolean.TRUE);
            codegenModel.arrayModelType = this.fromProperty((String)name, (Schema)schema).complexType;
            this.addParentContainer(codegenModel, name, schema);
        } else if (schema instanceof MapSchema) {
            codegenModel.getVendorExtensions().put("x-is-map-container", Boolean.TRUE);
            codegenModel.getVendorExtensions().put("x-is-container", Boolean.TRUE);
            this.addParentContainer(codegenModel, name, schema);
            if (DefaultCodegenConfig.hasSchemaProperties(schema) || DefaultCodegenConfig.hasTrueAdditionalProperties(schema)) {
                this.addAdditionPropertiesToCodeGenModel(codegenModel, schema);
            }
        } else if (schema instanceof ComposedSchema) {
            List oneOf;
            String parentName;
            ArrayList<String> allRequired;
            LinkedHashMap<String, Schema> allProperties;
            ComposedSchema composed = (ComposedSchema)schema;
            LinkedHashMap<String, Schema> properties = new LinkedHashMap<String, Schema>();
            ArrayList<String> required = new ArrayList<String>();
            if (this.supportsInheritance || this.supportsMixins) {
                allProperties = new LinkedHashMap<String, Schema>();
                allRequired = new ArrayList<String>();
                codegenModel.allVars = new ArrayList();
                int modelImplCnt = 0;
                if (composed.getAllOf() != null) {
                    for (Schema innerModel : composed.getAllOf()) {
                        if (codegenModel.discriminator == null) {
                            codegenModel.discriminator = innerModel.getDiscriminator();
                        }
                        if (innerModel.getXml() != null) {
                            codegenModel.xmlPrefix = innerModel.getXml().getPrefix();
                            codegenModel.xmlNamespace = innerModel.getXml().getNamespace();
                            codegenModel.xmlName = innerModel.getXml().getName();
                        }
                        if (modelImplCnt++ <= 1) continue;
                        LOGGER.warn("More than one inline schema specified in allOf:. Only the first one is recognized. All others are ignored.");
                        break;
                    }
                }
            } else {
                allProperties = null;
                allRequired = null;
            }
            Schema parent = StringUtils.isBlank((CharSequence)(parentName = this.getParentName(composed))) ? null : allDefinitions.get(parentName);
            List allOf = composed.getAllOf();
            if (allOf != null && !allOf.isEmpty()) {
                if (codegenModel.discriminator != null && codegenModel.discriminator.getPropertyName() != null) {
                    codegenModel.discriminator.setPropertyName(this.toVarName(codegenModel.discriminator.getPropertyName()));
                }
                for (int i = 0; i < allOf.size(); ++i) {
                    Schema interfaceSchema;
                    if (i == 0 && !this.copyFistAllOfProperties || StringUtils.isBlank((CharSequence)(interfaceSchema = (Schema)allOf.get(i)).get$ref())) continue;
                    Schema refSchema = null;
                    String ref = OpenAPIUtil.getSimpleRef(interfaceSchema.get$ref());
                    if (allDefinitions != null) {
                        refSchema = allDefinitions.get(ref);
                    }
                    String modelName = this.toModelName(ref);
                    this.addImport(codegenModel, modelName);
                    if (allDefinitions == null || refSchema == null) continue;
                    if (!this.supportsMixins) {
                        this.addProperties(properties, required, refSchema, allDefinitions);
                    }
                    if (!this.supportsInheritance) continue;
                    this.addProperties(allProperties, allRequired, refSchema, allDefinitions);
                }
            }
            if ((oneOf = composed.getOneOf()) != null && !oneOf.isEmpty() && schema.getDiscriminator() != null) {
                codegenModel.discriminator = schema.getDiscriminator();
                if (codegenModel.discriminator != null && codegenModel.discriminator.getPropertyName() != null) {
                    codegenModel.discriminator.setPropertyName(this.toVarName(codegenModel.discriminator.getPropertyName()));
                }
            }
            if (parent != null) {
                codegenModel.parentSchema = parentName;
                codegenModel.parent = this.typeMapping.containsKey(parentName) ? this.typeMapping.get(parentName) : this.toModelName(parentName);
                this.addImport(codegenModel, codegenModel.parent);
                if (allDefinitions != null) {
                    if (this.supportsInheritance) {
                        this.addProperties(allProperties, allRequired, parent, allDefinitions);
                    } else {
                        this.addProperties(properties, required, parent, allDefinitions);
                    }
                }
            }
            this.addProperties(properties, required, (Schema)composed, allDefinitions);
            if (this.supportsInheritance) {
                this.addProperties(allProperties, allRequired, (Schema)composed, allDefinitions);
            }
            this.addVars(codegenModel, properties, required, allProperties, allRequired);
        } else {
            codegenModel.dataType = this.getSchemaType(schema);
            if (schema.getEnum() != null && !schema.getEnum().isEmpty()) {
                codegenModel.getVendorExtensions().put("x-is-enum", Boolean.TRUE);
                codegenModel.allowableValues = new HashMap();
                codegenModel.allowableValues.put("values", schema.getEnum());
                if (codegenModel.dataType.equals("BigDecimal")) {
                    this.addImport(codegenModel, "BigDecimal");
                }
            }
            codegenModel.getVendorExtensions().put("x-is-nullable", Boolean.TRUE.equals(schema.getNullable()));
            this.addVars(codegenModel, schema.getProperties(), schema.getRequired());
        }
        if (codegenModel.vars != null) {
            for (CodegenProperty prop : codegenModel.vars) {
                this.postProcessModelProperty(codegenModel, prop);
            }
        }
        return codegenModel;
    }

    private boolean isDiscriminatorInInterfaceTree(ComposedSchema composedSchema, Map<String, Schema> allSchema) {
        if (composedSchema == null || allSchema == null || allSchema.isEmpty()) {
            return false;
        }
        if (composedSchema.getDiscriminator() != null) {
            return true;
        }
        List<Schema> interfaces = this.getInterfaces(composedSchema);
        if (interfaces == null) {
            return false;
        }
        for (Schema interfaceSchema : interfaces) {
            if (interfaceSchema.getDiscriminator() == null) continue;
            return true;
        }
        return false;
    }

    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, Schema schema) {
        this.addParentContainer(codegenModel, codegenModel.name, schema);
    }

    protected void addProperties(Map<String, Schema> properties, List<String> required, Schema schema, Map<String, Schema> allSchemas) {
        ComposedSchema composedSchema;
        if (StringUtils.isNotBlank((CharSequence)schema.get$ref())) {
            Schema interfaceSchema = allSchemas.get(OpenAPIUtil.getSimpleRef(schema.get$ref()));
            this.addProperties(properties, required, interfaceSchema, allSchemas);
            return;
        }
        if (schema instanceof ComposedSchema && (composedSchema = (ComposedSchema)schema).getAllOf() != null && !composedSchema.getAllOf().isEmpty() && composedSchema.getAllOf().size() != 1) {
            for (int i = 1; i < composedSchema.getAllOf().size(); ++i) {
                this.addProperties(properties, required, (Schema)composedSchema.getAllOf().get(i), allSchemas);
            }
        }
        if (schema.getProperties() != null) {
            properties.putAll(schema.getProperties());
        }
        if (schema.getRequired() != null) {
            required.addAll(schema.getRequired());
        }
    }

    public String getterAndSetterCapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        return DefaultCodegenConfig.camelize(this.toVarName(name));
    }

    public CodegenProperty fromProperty(String name, Schema propertySchema) {
        CodegenProperty cp;
        HashMap<String, List> allowableValues;
        List _enum;
        if (propertySchema == null) {
            LOGGER.error("unexpected missing property for name " + name);
            return null;
        }
        CodegenProperty codegenProperty = (CodegenProperty)CodegenModelFactory.newInstance((CodegenModelType)CodegenModelType.PROPERTY);
        codegenProperty.name = this.toVarName(name);
        codegenProperty.baseName = name;
        codegenProperty.nameInCamelCase = DefaultCodegenConfig.camelize(codegenProperty.name, false);
        codegenProperty.description = this.escapeText(propertySchema.getDescription());
        codegenProperty.unescapedDescription = propertySchema.getDescription();
        codegenProperty.title = propertySchema.getTitle();
        codegenProperty.getter = this.toGetter(name);
        codegenProperty.setter = this.toSetter(name);
        String example = this.toExampleValue(propertySchema);
        if (!"null".equals(example)) {
            codegenProperty.example = example;
        }
        codegenProperty.defaultValue = this.toDefaultValue(propertySchema);
        codegenProperty.defaultValueWithParam = this.toDefaultValueWithParam(name, propertySchema);
        codegenProperty.jsonSchema = Json.pretty((Object)propertySchema);
        codegenProperty.nullable = Boolean.TRUE.equals(propertySchema.getNullable());
        codegenProperty.getVendorExtensions().put("x-is-nullable", Boolean.TRUE.equals(propertySchema.getNullable()));
        if (propertySchema.getReadOnly() != null) {
            codegenProperty.getVendorExtensions().put("x-is-read-only", propertySchema.getReadOnly());
        }
        if (propertySchema.getXml() != null) {
            if (propertySchema.getXml().getAttribute() != null) {
                codegenProperty.getVendorExtensions().put("x-is-xml-attribute", propertySchema.getXml().getAttribute());
            }
            codegenProperty.xmlPrefix = propertySchema.getXml().getPrefix();
            codegenProperty.xmlName = propertySchema.getXml().getName();
            codegenProperty.xmlNamespace = propertySchema.getXml().getNamespace();
        }
        if (propertySchema.getExtensions() != null && !propertySchema.getExtensions().isEmpty()) {
            codegenProperty.getVendorExtensions().putAll(propertySchema.getExtensions());
        }
        String type = this.getSchemaType(propertySchema);
        if (propertySchema instanceof IntegerSchema) {
            codegenProperty.getVendorExtensions().put("x-is-numeric", Boolean.TRUE);
            if ("int64".equals(propertySchema.getFormat())) {
                codegenProperty.getVendorExtensions().put("x-is-long", Boolean.TRUE);
            } else {
                codegenProperty.getVendorExtensions().put("x-is-integer", Boolean.TRUE);
            }
            this.handleMinMaxValues(propertySchema, codegenProperty);
            if (codegenProperty.minimum != null || codegenProperty.maximum != null) {
                codegenProperty.getVendorExtensions().put("x-has-validation", Boolean.TRUE);
            }
            HashMap<String, Object> allowableValues2 = new HashMap<String, Object>();
            if (propertySchema.getMinimum() != null) {
                allowableValues2.put("min", propertySchema.getMinimum());
            }
            if (propertySchema.getMaximum() != null) {
                allowableValues2.put("max", propertySchema.getMaximum());
            }
            if (propertySchema.getEnum() != null) {
                List _enum2 = propertySchema.getEnum();
                codegenProperty._enum = new ArrayList();
                for (Integer i : _enum2) {
                    codegenProperty._enum.add(i.toString());
                }
                codegenProperty.getVendorExtensions().put("x-is-enum", Boolean.TRUE);
                allowableValues2.put("values", _enum2);
            }
            if (allowableValues2.size() > 0) {
                codegenProperty.allowableValues = allowableValues2;
            }
        }
        if (propertySchema instanceof StringSchema) {
            codegenProperty.maxLength = propertySchema.getMaxLength();
            codegenProperty.minLength = propertySchema.getMinLength();
            codegenProperty.pattern = this.toRegularExpression(propertySchema.getPattern());
            if (codegenProperty.pattern != null || codegenProperty.minLength != null || codegenProperty.maxLength != null) {
                codegenProperty.getVendorExtensions().put("x-has-validation", Boolean.TRUE);
            }
            codegenProperty.getVendorExtensions().put("x-is-string", Boolean.TRUE);
            if (propertySchema.getEnum() != null) {
                codegenProperty._enum = _enum = propertySchema.getEnum();
                codegenProperty.getVendorExtensions().put("x-is-enum", Boolean.TRUE);
                allowableValues = new HashMap<String, List>();
                allowableValues.put("values", _enum);
                codegenProperty.allowableValues = allowableValues;
            }
        }
        if (propertySchema instanceof BooleanSchema) {
            codegenProperty.getVendorExtensions().put("x-is-boolean", Boolean.TRUE);
            codegenProperty.getter = this.toBooleanGetter(name);
        }
        if (propertySchema instanceof FileSchema || propertySchema instanceof BinarySchema) {
            codegenProperty.getVendorExtensions().put("x-is-file", Boolean.TRUE);
            codegenProperty.getVendorExtensions().put("x-is-binary", Boolean.TRUE);
            codegenProperty.getVendorExtensions().put("x-is-string", Boolean.TRUE);
        }
        if (propertySchema instanceof EmailSchema) {
            codegenProperty.getVendorExtensions().put("x-is-string", Boolean.TRUE);
        }
        if (propertySchema instanceof UUIDSchema) {
            codegenProperty.getVendorExtensions().put("x-is-uuid", Boolean.TRUE);
            codegenProperty.getVendorExtensions().put("x-is-string", Boolean.TRUE);
        }
        if (propertySchema instanceof ByteArraySchema) {
            codegenProperty.getVendorExtensions().put("x-is-byte-array", Boolean.TRUE);
        }
        if (propertySchema instanceof NumberSchema) {
            codegenProperty.getVendorExtensions().put("x-is-numeric", Boolean.TRUE);
            if ("float".equals(propertySchema.getFormat())) {
                codegenProperty.getVendorExtensions().put("x-is-float", Boolean.TRUE);
            } else {
                codegenProperty.getVendorExtensions().put("x-is-double", Boolean.TRUE);
            }
            this.handleMinMaxValues(propertySchema, codegenProperty);
            if (propertySchema.getEnum() != null && !propertySchema.getEnum().isEmpty()) {
                _enum = propertySchema.getEnum();
                codegenProperty._enum = _enum.stream().map(number -> number.toString()).collect(Collectors.toList());
                codegenProperty.getVendorExtensions().put("x-is-enum", Boolean.TRUE);
                allowableValues = new HashMap();
                allowableValues.put("values", _enum);
                codegenProperty.allowableValues = allowableValues;
            }
        }
        if (propertySchema instanceof DateSchema) {
            codegenProperty.getVendorExtensions().put("x-is-date", Boolean.TRUE);
            this.handlePropertySchema(propertySchema, codegenProperty);
        }
        if (propertySchema instanceof DateTimeSchema) {
            codegenProperty.getVendorExtensions().put("x-is-date-time", Boolean.TRUE);
            this.handlePropertySchema(propertySchema, codegenProperty);
        }
        codegenProperty.datatype = this.getTypeDeclaration(propertySchema);
        codegenProperty.dataFormat = propertySchema.getFormat();
        boolean isEnum = ExtensionHelper.getBooleanValue((VendorExtendable)codegenProperty, "x-is-enum");
        if (isEnum) {
            codegenProperty.datatypeWithEnum = this.toEnumName(codegenProperty);
            codegenProperty.enumName = this.toEnumName(codegenProperty);
        } else {
            codegenProperty.datatypeWithEnum = codegenProperty.datatype;
        }
        codegenProperty.baseType = this.getSchemaType(propertySchema);
        if (propertySchema instanceof ArraySchema) {
            codegenProperty.getVendorExtensions().put("x-is-container", Boolean.TRUE);
            codegenProperty.getVendorExtensions().put("x-is-list-container", Boolean.TRUE);
            codegenProperty.containerType = "array";
            codegenProperty.baseType = this.getSchemaType(propertySchema);
            if (propertySchema.getXml() != null) {
                codegenProperty.getVendorExtensions().put("x-is-xml-wrapped", propertySchema.getXml().getWrapped() == null ? false : propertySchema.getXml().getWrapped());
                codegenProperty.xmlPrefix = propertySchema.getXml().getPrefix();
                codegenProperty.xmlNamespace = propertySchema.getXml().getNamespace();
                codegenProperty.xmlName = propertySchema.getXml().getName();
            }
            codegenProperty.maxItems = propertySchema.getMaxItems();
            codegenProperty.minItems = propertySchema.getMinItems();
            String itemName = null;
            if (propertySchema.getExtensions() != null && propertySchema.getExtensions().get("x-item-name") != null) {
                itemName = propertySchema.getExtensions().get("x-item-name").toString();
            }
            if (itemName == null) {
                itemName = codegenProperty.name;
            }
            Schema items = ((ArraySchema)propertySchema).getItems();
            CodegenProperty innerCodegenProperty = this.fromProperty(itemName, items);
            this.updatePropertyForArray(codegenProperty, innerCodegenProperty);
        } else if (propertySchema instanceof MapSchema && DefaultCodegenConfig.hasSchemaProperties(propertySchema)) {
            codegenProperty.getVendorExtensions().put("x-is-container", Boolean.TRUE);
            codegenProperty.getVendorExtensions().put("x-is-map-container", Boolean.TRUE);
            codegenProperty.containerType = "map";
            codegenProperty.baseType = this.getSchemaType(propertySchema);
            codegenProperty.minItems = propertySchema.getMinProperties();
            codegenProperty.maxItems = propertySchema.getMaxProperties();
            cp = this.fromProperty("inner", (Schema)propertySchema.getAdditionalProperties());
            this.updatePropertyForMap(codegenProperty, cp);
        } else if (propertySchema instanceof MapSchema && DefaultCodegenConfig.hasTrueAdditionalProperties(propertySchema)) {
            codegenProperty.getVendorExtensions().put("x-is-container", Boolean.TRUE);
            codegenProperty.getVendorExtensions().put("x-is-map-container", Boolean.TRUE);
            codegenProperty.containerType = "map";
            codegenProperty.baseType = this.getSchemaType(propertySchema);
            codegenProperty.minItems = propertySchema.getMinProperties();
            codegenProperty.maxItems = propertySchema.getMaxProperties();
            cp = this.fromProperty("inner", (Schema)new ObjectSchema());
            this.updatePropertyForMap(codegenProperty, cp);
        } else {
            if (this.isObjectSchema(propertySchema)) {
                codegenProperty.getVendorExtensions().put("x-is-object", Boolean.TRUE);
            }
            this.setNonArrayMapProperty(codegenProperty, type);
        }
        return codegenProperty;
    }

    private void handleMinMaxValues(Schema propertySchema, CodegenProperty codegenProperty) {
        if (propertySchema.getMinimum() != null) {
            codegenProperty.minimum = String.valueOf(propertySchema.getMinimum().longValue());
        }
        if (propertySchema.getMaximum() != null) {
            codegenProperty.maximum = String.valueOf(propertySchema.getMaximum().longValue());
        }
        if (propertySchema.getExclusiveMinimum() != null) {
            codegenProperty.exclusiveMinimum = propertySchema.getExclusiveMinimum();
        }
        if (propertySchema.getExclusiveMaximum() != null) {
            codegenProperty.exclusiveMaximum = propertySchema.getExclusiveMaximum();
        }
    }

    private void handlePropertySchema(Schema propertySchema, CodegenProperty codegenProperty) {
        if (propertySchema.getEnum() != null) {
            List _enum = propertySchema.getEnum();
            codegenProperty._enum = new ArrayList();
            for (String i : _enum) {
                codegenProperty._enum.add(i);
            }
            codegenProperty.getVendorExtensions().put("x-is-enum", Boolean.TRUE);
            HashMap<String, List> allowableValues = new HashMap<String, List>();
            allowableValues.put("values", _enum);
            codegenProperty.allowableValues = allowableValues;
        }
    }

    protected void updatePropertyForArray(CodegenProperty property, CodegenProperty innerProperty) {
        if (innerProperty == null) {
            LOGGER.warn("skipping invalid array property " + Json.pretty((Object)property));
            return;
        }
        property.dataFormat = innerProperty.dataFormat;
        this.decideIfComplex(property, innerProperty);
        property.items = innerProperty;
        if (this.isPropertyInnerMostEnum(property).booleanValue()) {
            property.getVendorExtensions().put("x-is-enum", Boolean.TRUE);
            this.updateDataTypeWithEnumForArray(property);
            property.allowableValues = this.getInnerEnumAllowableValues(property);
        }
    }

    private void decideIfComplex(CodegenProperty property, CodegenProperty innerProperty) {
        if (!this.languageSpecificPrimitives.contains(innerProperty.baseType)) {
            property.complexType = innerProperty.baseType;
        } else {
            property.getVendorExtensions().put("x-is-primitive-type", Boolean.TRUE);
        }
    }

    protected void updatePropertyForMap(CodegenProperty property, CodegenProperty innerProperty) {
        if (innerProperty == null) {
            LOGGER.warn("skipping invalid map property " + Json.pretty((Object)property));
            return;
        }
        this.decideIfComplex(property, innerProperty);
        property.items = innerProperty;
        property.dataFormat = innerProperty.dataFormat;
        if (this.isPropertyInnerMostEnum(property).booleanValue()) {
            property.getVendorExtensions().put("x-is-enum", Boolean.TRUE);
            this.updateDataTypeWithEnumForMap(property);
            property.allowableValues = this.getInnerEnumAllowableValues(property);
        }
    }

    protected Boolean isPropertyInnerMostEnum(CodegenProperty property) {
        CodegenProperty baseItem = BaseItemsHelper.getBaseItemsProperty(property);
        return baseItem == null ? false : ExtensionHelper.getBooleanValue((VendorExtendable)baseItem, "x-is-enum");
    }

    protected Map<String, Object> getInnerEnumAllowableValues(CodegenProperty property) {
        CodegenProperty baseItem = BaseItemsHelper.getBaseItemsProperty(property);
        return baseItem == null ? new HashMap() : baseItem.allowableValues;
    }

    protected void updateDataTypeWithEnumForArray(CodegenProperty property) {
        CodegenProperty baseItem = BaseItemsHelper.getBaseItemsProperty(property);
        if (baseItem != null) {
            property.datatypeWithEnum = property.datatypeWithEnum.replace(baseItem.baseType, this.toEnumName(baseItem));
            property.enumName = this.toEnumName(property);
            if (property.defaultValue != null) {
                property.defaultValue = property.defaultValue.replace(baseItem.baseType, this.toEnumName(baseItem));
            }
        }
    }

    protected void updateDataTypeWithEnumForMap(CodegenProperty property) {
        CodegenProperty baseItem = BaseItemsHelper.getBaseItemsProperty(property);
        if (baseItem != null) {
            property.datatypeWithEnum = property.datatypeWithEnum.replace(", " + baseItem.baseType, ", " + this.toEnumName(baseItem));
            property.enumName = this.toEnumName(property);
            if (property.defaultValue != null) {
                property.defaultValue = property.defaultValue.replace(", " + property.items.baseType, ", " + this.toEnumName(property.items));
            }
        }
    }

    protected void setNonArrayMapProperty(CodegenProperty property, String type) {
        property.getVendorExtensions().put("x-is-not-container", Boolean.TRUE);
        if (this.languageSpecificPrimitives().contains(type)) {
            property.getVendorExtensions().put("x-is-primitive-type", Boolean.TRUE);
        } else {
            property.complexType = property.baseType;
        }
    }

    protected ApiResponse findMethodResponse(ApiResponses responses) {
        String code = null;
        for (String responseCode : responses.keySet()) {
            if (!responseCode.startsWith("2") && !responseCode.equals("default") || code != null && code.compareTo(responseCode) <= 0) continue;
            code = responseCode;
        }
        if (code == null) {
            return null;
        }
        return (ApiResponse)responses.get(code);
    }

    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, Map<String, Schema> schemas) {
        return this.fromOperation(path, httpMethod, operation, schemas, null);
    }

    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, Map<String, Schema> schemas, OpenAPI openAPI) {
        int offset;
        CodegenOperation codegenOperation = (CodegenOperation)CodegenModelFactory.newInstance((CodegenModelType)CodegenModelType.OPERATION);
        HashSet<String> imports = new HashSet<String>();
        if (operation.getExtensions() != null && !operation.getExtensions().isEmpty()) {
            codegenOperation.vendorExtensions.putAll(operation.getExtensions());
        }
        String operationId = this.getOrGenerateOperationId(operation, path, httpMethod);
        if (this.removeOperationIdPrefix && (offset = operationId.indexOf(95)) > -1) {
            operationId = operationId.substring(offset + 1);
        }
        operationId = this.removeNonNameElementToCamelCase(operationId);
        codegenOperation.path = path;
        codegenOperation.operationId = this.toOperationId(operationId);
        codegenOperation.summary = this.escapeText(operation.getSummary());
        codegenOperation.unescapedNotes = operation.getDescription();
        codegenOperation.notes = this.escapeText(operation.getDescription());
        codegenOperation.getVendorExtensions().put("x-has-consumes", Boolean.FALSE);
        codegenOperation.getVendorExtensions().put("x-has-produces", Boolean.FALSE);
        if (operation.getDeprecated() != null) {
            codegenOperation.getVendorExtensions().put("x-is-deprecated", operation.getDeprecated());
        }
        this.addConsumesInfo(operation, codegenOperation, openAPI);
        if (operation.getResponses() != null && !operation.getResponses().isEmpty()) {
            ApiResponse methodResponse = this.findMethodResponse(operation.getResponses());
            for (String key : operation.getResponses().keySet()) {
                ApiResponse response = (ApiResponse)operation.getResponses().get((Object)key);
                this.addProducesInfo(response, codegenOperation);
                CodegenResponse codegenResponse = this.fromResponse(key, response);
                codegenResponse.getVendorExtensions().put("x-has-more", Boolean.TRUE);
                if (codegenResponse.baseType != null && !this.defaultIncludes.contains(codegenResponse.baseType) && !this.languageSpecificPrimitives.contains(codegenResponse.baseType)) {
                    imports.add(codegenResponse.baseType);
                }
                codegenResponse.getVendorExtensions().put("x-is-default", response == methodResponse);
                codegenOperation.responses.add(codegenResponse);
                if (ExtensionHelper.getBooleanValue((VendorExtendable)codegenResponse, "x-is-binary") && ExtensionHelper.getBooleanValue((VendorExtendable)codegenResponse, "x-is-default")) {
                    codegenOperation.getVendorExtensions().put("x-is-response-binary", Boolean.TRUE);
                }
                if (!ExtensionHelper.getBooleanValue((VendorExtendable)codegenResponse, "x-is-file") || !ExtensionHelper.getBooleanValue((VendorExtendable)codegenResponse, "x-is-default")) continue;
                codegenOperation.getVendorExtensions().put("x-is-response-file", Boolean.TRUE);
            }
            if (codegenOperation.produces != null) {
                HashSet mediaTypes = new HashSet();
                codegenOperation.produces.removeIf(map -> !mediaTypes.add(map.get("mediaType")));
                ((Map)codegenOperation.produces.get(codegenOperation.produces.size() - 1)).remove("hasMore");
            }
            ((CodegenResponse)codegenOperation.responses.get(codegenOperation.responses.size() - 1)).getVendorExtensions().put("x-has-more", Boolean.FALSE);
            if (methodResponse != null) {
                Schema responseSchema = this.getSchemaFromResponse(methodResponse);
                if (responseSchema != null) {
                    boolean isContainer;
                    Schema schemaDefinition;
                    CodegenProperty innerProperty;
                    CodegenProperty codegenProperty = this.fromProperty("response", responseSchema);
                    if (responseSchema instanceof ArraySchema) {
                        ArraySchema arraySchema = (ArraySchema)responseSchema;
                        innerProperty = this.fromProperty("response", arraySchema.getItems());
                        codegenOperation.returnBaseType = innerProperty.baseType;
                    } else if (responseSchema instanceof MapSchema && DefaultCodegenConfig.hasSchemaProperties(responseSchema)) {
                        MapSchema mapSchema = (MapSchema)responseSchema;
                        innerProperty = this.fromProperty("response", (Schema)mapSchema.getAdditionalProperties());
                        codegenOperation.returnBaseType = innerProperty.baseType;
                    } else if (responseSchema instanceof MapSchema && DefaultCodegenConfig.hasTrueAdditionalProperties(responseSchema)) {
                        CodegenProperty innerProperty2 = this.fromProperty("response", (Schema)new ObjectSchema());
                        codegenOperation.returnBaseType = innerProperty2.baseType;
                    } else {
                        codegenOperation.returnBaseType = codegenProperty.complexType != null ? codegenProperty.complexType : codegenProperty.baseType;
                    }
                    if (!this.additionalProperties.containsKey("disableExample")) {
                        codegenOperation.examples = new ExampleGenerator(openAPI).generate(null, null, responseSchema);
                    }
                    codegenOperation.defaultResponse = this.toDefaultValue(responseSchema);
                    codegenOperation.returnType = codegenProperty.datatype;
                    boolean hasReference = schemas != null && schemas.containsKey(codegenOperation.returnBaseType);
                    codegenOperation.getVendorExtensions().put("x-has-reference", hasReference);
                    if (schemas != null && (schemaDefinition = schemas.get(codegenOperation.returnBaseType)) != null) {
                        CodegenModel cmod = this.fromModel(codegenOperation.returnBaseType, schemaDefinition, schemas);
                        codegenOperation.discriminator = cmod.discriminator;
                    }
                    if (isContainer = ExtensionHelper.getBooleanValue((VendorExtendable)codegenProperty, "x-is-container")) {
                        codegenOperation.returnContainer = codegenProperty.containerType;
                        if ("map".equals(codegenProperty.containerType)) {
                            codegenOperation.getVendorExtensions().put("x-is-map-container", Boolean.TRUE);
                        } else if ("list".equalsIgnoreCase(codegenProperty.containerType)) {
                            codegenOperation.getVendorExtensions().put("x-is-list-container", Boolean.TRUE);
                        } else if ("array".equalsIgnoreCase(codegenProperty.containerType)) {
                            codegenOperation.getVendorExtensions().put("x-is-list-container", Boolean.TRUE);
                        }
                    } else {
                        codegenOperation.returnSimpleType = true;
                    }
                    if (this.languageSpecificPrimitives().contains(codegenOperation.returnBaseType) || codegenOperation.returnBaseType == null) {
                        codegenOperation.returnTypeIsPrimitive = true;
                    }
                }
                Map componentHeaders = null;
                if (openAPI != null && openAPI.getComponents() != null) {
                    componentHeaders = openAPI.getComponents().getHeaders();
                }
                this.addHeaders(methodResponse, codegenOperation.responseHeaders, componentHeaders);
            }
        }
        List parameters = operation.getParameters();
        CodegenParameter bodyParam = null;
        ArrayList<CodegenParameter> allParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> bodyParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> pathParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> queryParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> headerParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> cookieParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> formParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> requiredParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenContent> codegenContents = new ArrayList<CodegenContent>();
        RequestBody body = operation.getRequestBody();
        if (body != null) {
            if (StringUtils.isNotBlank((CharSequence)body.get$ref())) {
                String bodyName = OpenAPIUtil.getSimpleRef(body.get$ref());
                body = (RequestBody)openAPI.getComponents().getRequestBodies().get(bodyName);
            }
            ArrayList foundSchemas = new ArrayList();
            for (String contentType : body.getContent().keySet()) {
                boolean isForm = "application/x-www-form-urlencoded".equalsIgnoreCase(contentType) || "multipart/form-data".equalsIgnoreCase(contentType);
                String schemaName = null;
                Schema schema = ((MediaType)body.getContent().get((Object)contentType)).getSchema();
                if (schema != null && StringUtils.isNotBlank((CharSequence)schema.get$ref())) {
                    schemaName = OpenAPIUtil.getSimpleRef(schema.get$ref());
                    try {
                        schemaName = URLDecoder.decode(schemaName, StandardCharsets.UTF_8.name());
                    }
                    catch (UnsupportedEncodingException e) {
                        LOGGER.error("Could not decoded string: " + schemaName, (Throwable)e);
                    }
                    schema = schemas.get(schemaName);
                }
                CodegenContent codegenContent = new CodegenContent(contentType);
                codegenContent.getContentExtensions().put("x-is-form", isForm);
                if (schema == null) {
                    CodegenParameter codegenParameter2 = (CodegenParameter)CodegenModelFactory.newInstance((CodegenModelType)CodegenModelType.PARAMETER);
                    codegenParameter2.description = body.getDescription();
                    codegenParameter2.unescapedDescription = body.getDescription();
                    String bodyName = REQUEST_BODY_NAME;
                    if (body.getExtensions() != null && body.getExtensions().get("x-codegen-request-body-name") != null) {
                        bodyName = body.getExtensions().get("x-codegen-request-body-name").toString();
                    }
                    codegenParameter2.baseName = bodyName;
                    codegenParameter2.paramName = bodyName;
                    codegenParameter2.dataType = "Object";
                    codegenParameter2.baseType = "Object";
                    codegenParameter2.required = body.getRequired() != null ? body.getRequired() : Boolean.FALSE;
                    if (isForm) continue;
                    codegenParameter2.getVendorExtensions().put("x-is-body-param", Boolean.TRUE);
                    continue;
                }
                if (isForm) {
                    Map propertyMap = schema.getProperties();
                    boolean isMultipart = contentType.equalsIgnoreCase("multipart/form-data");
                    if (propertyMap == null || propertyMap.isEmpty()) continue;
                    for (String propertyName : propertyMap.keySet()) {
                        CodegenParameter formParameter = this.fromParameter(new Parameter().name(propertyName).required(body.getRequired()).schema((Schema)propertyMap.get(propertyName)), imports);
                        if (isMultipart) {
                            formParameter.getVendorExtensions().put("x-is-multipart", Boolean.TRUE);
                        }
                        formParameter.getVendorExtensions().put("x-is-form-param", Boolean.TRUE);
                        formParams.add(formParameter.copy());
                        if (body.getRequired() != null && body.getRequired().booleanValue()) {
                            requiredParams.add(formParameter.copy());
                        }
                        allParams.add(formParameter);
                    }
                    codegenContents.add(codegenContent);
                    continue;
                }
                bodyParam = this.fromRequestBody(body, schemaName, schema, schemas, imports);
                if (foundSchemas.isEmpty()) {
                    bodyParams.add(bodyParam.copy());
                    allParams.add(bodyParam);
                } else {
                    Schema usedSchema;
                    boolean alreadyAdded = false;
                    Iterator iterator = foundSchemas.iterator();
                    while (iterator.hasNext() && !(alreadyAdded = (usedSchema = (Schema)iterator.next()).equals((Object)schema))) {
                    }
                    if (alreadyAdded) continue;
                }
                foundSchemas.add(schema);
                codegenContents.add(codegenContent);
            }
        }
        if (parameters != null) {
            for (Parameter param : parameters) {
                if (StringUtils.isNotBlank((CharSequence)param.get$ref())) {
                    param = this.getParameterFromRef(param.get$ref(), openAPI);
                }
                CodegenParameter codegenParameter3 = this.fromParameter(param, imports);
                allParams.add(codegenParameter3);
                if (param instanceof QueryParameter || "query".equalsIgnoreCase(param.getIn())) {
                    queryParams.add(codegenParameter3.copy());
                } else if (param instanceof PathParameter || "path".equalsIgnoreCase(param.getIn())) {
                    pathParams.add(codegenParameter3.copy());
                } else if (param instanceof HeaderParameter || "header".equalsIgnoreCase(param.getIn())) {
                    headerParams.add(codegenParameter3.copy());
                } else if (param instanceof CookieParameter || "cookie".equalsIgnoreCase(param.getIn())) {
                    cookieParams.add(codegenParameter3.copy());
                }
                if (!codegenParameter3.required) continue;
                requiredParams.add(codegenParameter3.copy());
            }
        }
        this.addOperationImports(codegenOperation, imports);
        codegenOperation.bodyParam = bodyParam;
        codegenOperation.httpMethod = httpMethod.toUpperCase();
        if (this.sortParamsByRequiredFlag.booleanValue()) {
            Collections.sort(allParams, new Comparator<CodegenParameter>(){

                @Override
                public int compare(CodegenParameter one, CodegenParameter another) {
                    if (one.required == another.required) {
                        return 0;
                    }
                    if (one.required) {
                        return -1;
                    }
                    return 1;
                }
            });
        }
        codegenOperation.allParams = DefaultCodegenConfig.addHasMore(allParams);
        codegenOperation.bodyParams = DefaultCodegenConfig.addHasMore(bodyParams);
        codegenOperation.pathParams = DefaultCodegenConfig.addHasMore(pathParams);
        codegenOperation.queryParams = DefaultCodegenConfig.addHasMore(queryParams);
        codegenOperation.headerParams = DefaultCodegenConfig.addHasMore(headerParams);
        codegenOperation.cookieParams = DefaultCodegenConfig.addHasMore(cookieParams);
        codegenOperation.formParams = DefaultCodegenConfig.addHasMore(formParams);
        codegenOperation.requiredParams = DefaultCodegenConfig.addHasMore(requiredParams);
        codegenOperation.externalDocs = operation.getExternalDocs();
        this.configuresParameterForMediaType(codegenOperation, codegenContents);
        codegenOperation.nickname = codegenOperation.operationId;
        if (codegenOperation.allParams.size() > 0) {
            codegenOperation.getVendorExtensions().put("x-has-params", Boolean.TRUE);
        }
        boolean hasRequiredParams = codegenOperation.requiredParams.size() > 0;
        codegenOperation.getVendorExtensions().put("x-has-required-params", hasRequiredParams);
        boolean hasOptionalParams = codegenOperation.allParams.stream().anyMatch(codegenParameter -> !codegenParameter.required);
        codegenOperation.getVendorExtensions().put("x-has-optional-params", hasOptionalParams);
        codegenOperation.getVendorExtensions().put("x-is-restful-show", codegenOperation.getIsRestfulShow());
        codegenOperation.getVendorExtensions().put("x-is-restful-index", codegenOperation.getIsRestfulIndex());
        codegenOperation.getVendorExtensions().put("x-is-restful-create", codegenOperation.getIsRestfulCreate());
        codegenOperation.getVendorExtensions().put("x-is-restful-update", codegenOperation.getIsRestfulUpdate());
        codegenOperation.getVendorExtensions().put("x-is-restful-destroy", codegenOperation.getIsRestfulDestroy());
        codegenOperation.getVendorExtensions().put("x-is-restful", codegenOperation.getIsRestful());
        this.configureDataForTestTemplate(codegenOperation);
        return codegenOperation;
    }

    protected void addOperationImports(CodegenOperation codegenOperation, Set<String> operationImports) {
        for (String operationImport : operationImports) {
            if (!this.needToImport(operationImport)) continue;
            codegenOperation.imports.add(operationImport);
        }
    }

    public CodegenResponse fromResponse(String responseCode, ApiResponse response) {
        CodegenResponse codegenResponse = (CodegenResponse)CodegenModelFactory.newInstance((CodegenModelType)CodegenModelType.RESPONSE);
        codegenResponse.code = "default".equals(responseCode) ? "0" : responseCode;
        Schema responseSchema = this.getSchemaFromResponse(response);
        codegenResponse.schema = responseSchema;
        codegenResponse.message = this.escapeText(response.getDescription());
        if (response.getContent() != null) {
            HashMap<String, Object> examples = new HashMap<String, Object>();
            for (String name : response.getContent().keySet()) {
                if (response.getContent().get((Object)name) == null) continue;
                if (((MediaType)response.getContent().get((Object)name)).getExample() != null) {
                    examples.put(name, ((MediaType)response.getContent().get((Object)name)).getExample());
                }
                if (((MediaType)response.getContent().get((Object)name)).getExamples() == null) continue;
                for (String exampleName : ((MediaType)response.getContent().get((Object)name)).getExamples().keySet()) {
                    examples.put(exampleName, ((Example)((MediaType)response.getContent().get((Object)name)).getExamples().get(exampleName)).getValue());
                }
            }
            codegenResponse.examples = this.toExamples(examples);
        }
        codegenResponse.jsonSchema = Json.pretty((Object)response);
        if (response.getExtensions() != null && !response.getExtensions().isEmpty()) {
            codegenResponse.vendorExtensions.putAll(response.getExtensions());
        }
        Map componentHeaders = null;
        if (this.openAPI != null && this.openAPI.getComponents() != null) {
            componentHeaders = this.openAPI.getComponents().getHeaders();
        }
        this.addHeaders(response, codegenResponse.headers, componentHeaders);
        codegenResponse.getVendorExtensions().put("x-has-headers", !codegenResponse.headers.isEmpty());
        if (responseSchema != null) {
            CodegenProperty codegenProperty = this.fromProperty("response", responseSchema);
            if (responseSchema instanceof ArraySchema) {
                CodegenProperty innerProperty;
                ArraySchema arraySchema = (ArraySchema)responseSchema;
                CodegenProperty innerCp = innerProperty = this.fromProperty("response", arraySchema.getItems());
                while (innerCp != null) {
                    codegenResponse.baseType = innerCp.baseType;
                    innerCp = innerCp.items;
                }
            } else {
                codegenResponse.baseType = codegenProperty.complexType != null ? codegenProperty.complexType : codegenProperty.baseType;
            }
            codegenResponse.dataType = codegenProperty.datatype;
            if (ExtensionHelper.getBooleanValue((VendorExtendable)codegenProperty, "x-is-string")) {
                codegenResponse.getVendorExtensions().put("x-is-string", Boolean.TRUE);
            } else if (ExtensionHelper.getBooleanValue((VendorExtendable)codegenProperty, "x-is-boolean")) {
                codegenResponse.getVendorExtensions().put("x-is-boolean", Boolean.TRUE);
            } else if (ExtensionHelper.getBooleanValue((VendorExtendable)codegenProperty, "x-is-long")) {
                codegenResponse.getVendorExtensions().put("x-is-long", Boolean.TRUE);
                codegenResponse.getVendorExtensions().put("x-is-numeric", Boolean.TRUE);
            } else if (ExtensionHelper.getBooleanValue((VendorExtendable)codegenProperty, "x-is-integer")) {
                codegenResponse.getVendorExtensions().put("x-is-integer", Boolean.TRUE);
                codegenResponse.getVendorExtensions().put("x-is-numeric", Boolean.TRUE);
            } else if (ExtensionHelper.getBooleanValue((VendorExtendable)codegenProperty, "x-is-double")) {
                codegenResponse.getVendorExtensions().put("x-is-double", Boolean.TRUE);
                codegenResponse.getVendorExtensions().put("x-is-numeric", Boolean.TRUE);
            } else if (ExtensionHelper.getBooleanValue((VendorExtendable)codegenProperty, "x-is-float")) {
                codegenResponse.getVendorExtensions().put("x-is-float", Boolean.TRUE);
                codegenResponse.getVendorExtensions().put("x-is-numeric", Boolean.TRUE);
            } else if (ExtensionHelper.getBooleanValue((VendorExtendable)codegenProperty, "x-is-byte-array")) {
                codegenResponse.getVendorExtensions().put("x-is-byte-array", Boolean.TRUE);
            } else if (ExtensionHelper.getBooleanValue((VendorExtendable)codegenProperty, "x-is-binary")) {
                codegenResponse.getVendorExtensions().put("x-is-binary", Boolean.TRUE);
            } else if (ExtensionHelper.getBooleanValue((VendorExtendable)codegenProperty, "x-is-file")) {
                codegenResponse.getVendorExtensions().put("x-is-file", Boolean.TRUE);
            } else if (ExtensionHelper.getBooleanValue((VendorExtendable)codegenProperty, "x-is-date")) {
                codegenResponse.getVendorExtensions().put("x-is-date", Boolean.TRUE);
            } else if (ExtensionHelper.getBooleanValue((VendorExtendable)codegenProperty, "x-is-date-time")) {
                codegenResponse.getVendorExtensions().put("x-is-date-time", Boolean.TRUE);
            } else if (ExtensionHelper.getBooleanValue((VendorExtendable)codegenProperty, "x-is-uuid")) {
                codegenResponse.getVendorExtensions().put("x-is-uuid", Boolean.TRUE);
            } else {
                LOGGER.debug("Property type is not primitive: " + codegenProperty.datatype);
            }
            if (ExtensionHelper.getBooleanValue((VendorExtendable)codegenProperty, "x-is-container")) {
                codegenResponse.getVendorExtensions().put("x-is-simple-type", Boolean.FALSE);
                codegenResponse.containerType = codegenProperty.containerType;
                codegenResponse.getVendorExtensions().put("x-is-map-container", "map".equals(codegenProperty.containerType));
                codegenResponse.getVendorExtensions().put("x-is-list-container", "list".equalsIgnoreCase(codegenProperty.containerType) || "array".equalsIgnoreCase(codegenProperty.containerType));
            } else {
                codegenResponse.getVendorExtensions().put("x-is-simple-type", Boolean.TRUE);
            }
            codegenResponse.getVendorExtensions().put("x-is-primitive-type", codegenResponse.baseType == null || this.languageSpecificPrimitives().contains(codegenResponse.baseType));
        }
        if (codegenResponse.baseType == null) {
            codegenResponse.getVendorExtensions().put("x-is-map-container", Boolean.FALSE);
            codegenResponse.getVendorExtensions().put("x-is-list-container", Boolean.FALSE);
            codegenResponse.getVendorExtensions().put("x-is-primitive-type", Boolean.TRUE);
            codegenResponse.getVendorExtensions().put("x-is-simple-type", Boolean.TRUE);
        }
        return codegenResponse;
    }

    public CodegenParameter fromParameter(Parameter parameter, Set<String> imports) {
        Schema parameterSchema;
        HeaderParameter hp;
        CodegenParameter codegenParameter = (CodegenParameter)CodegenModelFactory.newInstance((CodegenModelType)CodegenModelType.PARAMETER);
        codegenParameter.baseName = parameter.getName();
        codegenParameter.description = this.escapeText(parameter.getDescription());
        codegenParameter.unescapedDescription = parameter.getDescription();
        if (parameter.getRequired() != null) {
            codegenParameter.required = parameter.getRequired();
        }
        codegenParameter.jsonSchema = Json.pretty((Object)parameter);
        if (System.getProperty("debugParser") != null) {
            LOGGER.info("working on Parameter " + parameter.getName());
        }
        if (parameter instanceof QueryParameter) {
            QueryParameter qp = (QueryParameter)parameter;
            if (qp.getSchema() != null && qp.getSchema().getDefault() != null) {
                codegenParameter.defaultValue = qp.getSchema().getDefault().toString();
            }
        } else if (parameter instanceof HeaderParameter && (hp = (HeaderParameter)parameter).getSchema() != null && hp.getSchema().getDefault() != null) {
            codegenParameter.defaultValue = hp.getSchema().getDefault().toString();
        }
        if (parameter.getExtensions() != null && !parameter.getExtensions().isEmpty()) {
            codegenParameter.vendorExtensions.putAll(parameter.getExtensions());
        }
        if ((parameterSchema = parameter.getSchema()) == null) {
            parameterSchema = this.getSchemaFromParameter(parameter);
        }
        if (parameterSchema != null) {
            CodegenProperty codegenProperty;
            String collectionFormat = null;
            if (parameterSchema instanceof ArraySchema) {
                CodegenProperty codegenProperty2;
                ArraySchema arraySchema = (ArraySchema)parameterSchema;
                Schema inner = arraySchema.getItems();
                if (inner == null) {
                    LOGGER.warn("warning!  No inner type supplied for array parameter \"" + parameter.getName() + "\", using String");
                    inner = new StringSchema().description("//TODO automatically added by swagger-codegen");
                    arraySchema.setItems(inner);
                } else if (this.isObjectSchema(inner)) {
                    codegenParameter.getVendorExtensions().put("x-has-inner-object", Boolean.TRUE);
                }
                collectionFormat = this.getCollectionFormat(parameter);
                codegenParameter.items = codegenProperty2 = this.fromProperty("inner", inner);
                codegenParameter.baseType = codegenProperty2.datatype;
                codegenParameter.getVendorExtensions().put("x-is-container", Boolean.TRUE);
                codegenParameter.getVendorExtensions().put("x-is-list-container", Boolean.TRUE);
                while (codegenProperty2 != null) {
                    imports.add(codegenProperty2.baseType);
                    codegenProperty2 = codegenProperty2.items;
                }
            } else if (parameterSchema instanceof MapSchema && DefaultCodegenConfig.hasSchemaProperties(parameterSchema)) {
                codegenParameter.items = codegenProperty = this.fromProperty("inner", (Schema)parameterSchema.getAdditionalProperties());
                codegenParameter.baseType = codegenProperty.datatype;
                codegenParameter.getVendorExtensions().put("x-is-container", Boolean.TRUE);
                codegenParameter.getVendorExtensions().put("x-is-map-container", Boolean.TRUE);
                while (codegenProperty != null) {
                    imports.add(codegenProperty.baseType);
                    codegenProperty = codegenProperty.items;
                }
                collectionFormat = this.getCollectionFormat(parameter);
            } else if (parameterSchema instanceof MapSchema && DefaultCodegenConfig.hasTrueAdditionalProperties(parameterSchema)) {
                codegenParameter.items = codegenProperty = this.fromProperty("inner", (Schema)new ObjectSchema());
                codegenParameter.baseType = codegenProperty.datatype;
                codegenParameter.getVendorExtensions().put("x-is-container", Boolean.TRUE);
                codegenParameter.getVendorExtensions().put("x-is-map-container", Boolean.TRUE);
                while (codegenProperty != null) {
                    imports.add(codegenProperty.baseType);
                    codegenProperty = codegenProperty.items;
                }
                collectionFormat = this.getCollectionFormat(parameter);
            } else if (parameterSchema instanceof FileSchema || parameterSchema instanceof BinarySchema) {
                codegenParameter.getVendorExtensions().put("x-is-binary", Boolean.TRUE);
                codegenParameter.getVendorExtensions().put("x-is-file", Boolean.TRUE);
            }
            if (parameterSchema == null) {
                LOGGER.warn("warning!  Schema not found for parameter \"" + parameter.getName() + "\", using String");
                parameterSchema = new StringSchema().description("//TODO automatically added by swagger-codegen.");
            }
            codegenProperty = this.fromProperty(parameter.getName(), parameterSchema);
            this.setParameterBooleanFlagWithCodegenProperty(codegenParameter, codegenProperty);
            this.setParameterNullable(codegenParameter, codegenProperty);
            codegenParameter.nullable = Boolean.TRUE.equals(parameterSchema.getNullable());
            codegenParameter.getVendorExtensions().put("x-is-nullable", Boolean.TRUE.equals(parameterSchema.getNullable()));
            codegenParameter.dataType = codegenProperty.datatype;
            codegenParameter.dataFormat = codegenProperty.dataFormat;
            if (ExtensionHelper.getBooleanValue((VendorExtendable)codegenProperty, "x-is-enum")) {
                codegenParameter.datatypeWithEnum = codegenProperty.datatypeWithEnum;
                codegenParameter.enumName = codegenProperty.enumName;
                this.updateCodegenPropertyEnum(codegenProperty);
                codegenParameter.getVendorExtensions().put("x-is-enum", Boolean.TRUE);
                codegenParameter._enum = codegenProperty._enum;
            }
            codegenParameter.allowableValues = codegenProperty.allowableValues;
            if (codegenProperty.items != null && ExtensionHelper.getBooleanValue((VendorExtendable)codegenProperty.items, "x-is-enum")) {
                codegenParameter.datatypeWithEnum = codegenProperty.datatypeWithEnum;
                codegenParameter.enumName = codegenProperty.enumName;
                codegenParameter.items = codegenProperty.items;
            }
            codegenParameter.collectionFormat = collectionFormat;
            if (collectionFormat != null && collectionFormat.equals("multi")) {
                codegenParameter.getVendorExtensions().put("x-is-collection-format-multi", Boolean.TRUE);
            }
            codegenParameter.paramName = this.toParamName(parameter.getName());
            if (codegenProperty.complexType != null) {
                imports.add(codegenProperty.complexType);
            }
            if (parameterSchema instanceof IntegerSchema) {
                codegenParameter.maximum = parameterSchema.getMaximum() == null ? null : String.valueOf(parameterSchema.getMaximum().longValue());
                codegenParameter.minimum = parameterSchema.getMinimum() == null ? null : String.valueOf(parameterSchema.getMinimum().longValue());
            } else {
                codegenParameter.maximum = parameterSchema.getMaximum() == null ? null : String.valueOf(parameterSchema.getMaximum());
                codegenParameter.minimum = parameterSchema.getMinimum() == null ? null : String.valueOf(parameterSchema.getMinimum());
            }
            codegenParameter.exclusiveMaximum = parameterSchema.getExclusiveMaximum() == null ? false : parameterSchema.getExclusiveMaximum();
            codegenParameter.exclusiveMinimum = parameterSchema.getExclusiveMinimum() == null ? false : parameterSchema.getExclusiveMinimum();
            codegenParameter.maxLength = parameterSchema.getMaxLength();
            codegenParameter.minLength = parameterSchema.getMinLength();
            codegenParameter.pattern = this.toRegularExpression(parameterSchema.getPattern());
            codegenParameter.maxItems = parameterSchema.getMaxItems();
            codegenParameter.minItems = parameterSchema.getMinItems();
            codegenParameter.uniqueItems = parameterSchema.getUniqueItems() == null ? false : parameterSchema.getUniqueItems();
            codegenParameter.multipleOf = parameterSchema.getMultipleOf();
            if (codegenParameter.maximum != null || codegenParameter.minimum != null || codegenParameter.maxLength != null || codegenParameter.minLength != null || codegenParameter.maxItems != null || codegenParameter.minItems != null || codegenParameter.pattern != null) {
                codegenParameter.getVendorExtensions().put("x-has-validation", Boolean.TRUE);
            }
        }
        if (parameter instanceof QueryParameter || "query".equalsIgnoreCase(parameter.getIn())) {
            codegenParameter.getVendorExtensions().put("x-is-query-param", Boolean.TRUE);
        } else if (parameter instanceof PathParameter || "path".equalsIgnoreCase(parameter.getIn())) {
            codegenParameter.required = true;
            codegenParameter.getVendorExtensions().put("x-is-path-param", Boolean.TRUE);
        } else if (parameter instanceof HeaderParameter || "header".equalsIgnoreCase(parameter.getIn())) {
            codegenParameter.getVendorExtensions().put("x-is-header-param", Boolean.TRUE);
        } else if (parameter instanceof CookieParameter || "cookie".equalsIgnoreCase(parameter.getIn())) {
            codegenParameter.getVendorExtensions().put("x-is-cookie-param", Boolean.TRUE);
        }
        if (codegenParameter.vendorExtensions != null && codegenParameter.vendorExtensions.containsKey("x-example")) {
            codegenParameter.example = Json.pretty(codegenParameter.vendorExtensions.get("x-example"));
        } else if (ExtensionHelper.getBooleanValue((VendorExtendable)codegenParameter, "x-is-string")) {
            codegenParameter.example = codegenParameter.paramName + "_example";
        } else if (ExtensionHelper.getBooleanValue((VendorExtendable)codegenParameter, "x-is-boolean")) {
            codegenParameter.example = "true";
        } else if (ExtensionHelper.getBooleanValue((VendorExtendable)codegenParameter, "x-is-long")) {
            codegenParameter.example = "789";
        } else if (ExtensionHelper.getBooleanValue((VendorExtendable)codegenParameter, "x-is-integer")) {
            codegenParameter.example = "56";
        } else if (ExtensionHelper.getBooleanValue((VendorExtendable)codegenParameter, "x-is-float")) {
            codegenParameter.example = "3.4";
        } else if (ExtensionHelper.getBooleanValue((VendorExtendable)codegenParameter, "x-is-double")) {
            codegenParameter.example = "1.2";
        } else if (ExtensionHelper.getBooleanValue((VendorExtendable)codegenParameter, "x-is-binary")) {
            codegenParameter.example = "BINARY_DATA_HERE";
        } else if (ExtensionHelper.getBooleanValue((VendorExtendable)codegenParameter, "x-is-byte-array")) {
            codegenParameter.example = "B";
        } else if (ExtensionHelper.getBooleanValue((VendorExtendable)codegenParameter, "x-is-file")) {
            codegenParameter.example = "/path/to/file.txt";
        } else if (ExtensionHelper.getBooleanValue((VendorExtendable)codegenParameter, "x-is-date")) {
            codegenParameter.example = "2013-10-20";
        } else if (ExtensionHelper.getBooleanValue((VendorExtendable)codegenParameter, "x-is-date-time")) {
            codegenParameter.example = "2013-10-20T19:20:30+01:00";
        } else if (ExtensionHelper.getBooleanValue((VendorExtendable)codegenParameter, "x-is-uuid")) {
            codegenParameter.example = "38400000-8cf0-11bd-b23e-10b96e4ef00d";
        }
        this.setParameterExampleValue(codegenParameter);
        this.postProcessParameter(codegenParameter);
        return codegenParameter;
    }

    public CodegenParameter fromRequestBody(RequestBody body, String name, Schema schema, Map<String, Schema> schemas, Set<String> imports) {
        CodegenParameter codegenParameter = (CodegenParameter)CodegenModelFactory.newInstance((CodegenModelType)CodegenModelType.PARAMETER);
        String bodyName = REQUEST_BODY_NAME;
        if (body.getExtensions() != null && body.getExtensions().get("x-codegen-request-body-name") != null) {
            bodyName = body.getExtensions().get("x-codegen-request-body-name").toString();
        }
        codegenParameter.baseName = bodyName;
        codegenParameter.paramName = bodyName;
        codegenParameter.description = body.getDescription();
        codegenParameter.unescapedDescription = body.getDescription();
        codegenParameter.required = body.getRequired() != null ? body.getRequired() : Boolean.FALSE;
        codegenParameter.getVendorExtensions().put("x-is-body-param", Boolean.TRUE);
        codegenParameter.jsonSchema = Json.pretty((Object)body);
        if (body.getContent() != null && !body.getContent().isEmpty()) {
            Object example = ((MediaType)new ArrayList(body.getContent().values()).get(0)).getExample();
            if (example != null) {
                codegenParameter.example = Json.pretty((Object)example);
            } else {
                Map examples = ((MediaType)new ArrayList(body.getContent().values()).get(0)).getExamples();
                if (examples != null && !examples.isEmpty()) {
                    codegenParameter.example = Json.pretty(new ArrayList(examples.values()).get(0));
                }
            }
        }
        if (schema == null) {
            schema = this.getSchemaFromBody(body);
        }
        if (StringUtils.isNotBlank((CharSequence)schema.get$ref())) {
            name = OpenAPIUtil.getSimpleRef(schema.get$ref());
            schema = schemas.get(name);
        }
        if (this.isObjectSchema(schema)) {
            CodegenModel codegenModel = null;
            if (StringUtils.isNotBlank((CharSequence)name)) {
                schema.setName(name);
                codegenModel = this.fromModel(name, schema, schemas);
            }
            if (codegenModel != null) {
                codegenParameter.baseType = codegenModel.classname;
                codegenParameter.dataType = this.getTypeDeclaration(codegenModel.classname);
                imports.add(codegenParameter.dataType);
            } else {
                CodegenProperty codegenProperty = this.fromProperty("property", schema);
                if (codegenProperty != null) {
                    codegenParameter.baseType = codegenProperty.baseType;
                    codegenParameter.dataType = codegenProperty.datatype;
                    boolean isPrimitiveType = ExtensionHelper.getBooleanValue((VendorExtendable)codegenProperty, "x-is-primitive-type");
                    boolean isBinary = ExtensionHelper.getBooleanValue((VendorExtendable)codegenProperty, "x-is-binary");
                    boolean isFile = ExtensionHelper.getBooleanValue((VendorExtendable)codegenProperty, "x-is-file");
                    codegenParameter.getVendorExtensions().put("x-is-primitive-type", isPrimitiveType);
                    codegenParameter.getVendorExtensions().put("x-is-binary", isBinary);
                    codegenParameter.getVendorExtensions().put("x-is-file", isFile);
                    if (codegenProperty.complexType != null) {
                        imports.add(codegenProperty.complexType);
                    }
                }
                this.setParameterBooleanFlagWithCodegenProperty(codegenParameter, codegenProperty);
                this.setParameterNullable(codegenParameter, codegenProperty);
            }
        } else if (schema instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)schema;
            Schema inner = arraySchema.getItems();
            if (inner == null) {
                inner = new StringSchema().description("//TODO automatically added by swagger-codegen");
                arraySchema.setItems(inner);
            } else if (this.isObjectSchema(inner)) {
                codegenParameter.getVendorExtensions().put("x-has-inner-object", Boolean.TRUE);
            }
            CodegenProperty codegenProperty = this.fromProperty("property", schema);
            CodegenProperty innerProperty = this.fromProperty("inner", arraySchema.getItems());
            codegenProperty.baseType = innerProperty.baseType;
            if (codegenProperty.complexType != null) {
                imports.add(codegenProperty.complexType);
            }
            if (codegenParameter.baseType != null) {
                imports.add(codegenProperty.baseType);
            }
            CodegenProperty innerCp = codegenProperty;
            while (innerCp != null) {
                if (innerCp.complexType != null) {
                    imports.add(innerCp.complexType);
                }
                innerCp = innerCp.items;
            }
            codegenParameter.items = codegenProperty;
            codegenParameter.dataType = codegenProperty.datatype;
            codegenParameter.baseType = codegenProperty.baseType;
            boolean isPrimitiveType = ExtensionHelper.getBooleanValue((VendorExtendable)codegenProperty, "x-is-primitive-type");
            codegenParameter.getVendorExtensions().put("x-is-primitive-type", isPrimitiveType);
            codegenParameter.getVendorExtensions().put("x-is-container", Boolean.TRUE);
            codegenParameter.getVendorExtensions().put("x-is-list-container", Boolean.TRUE);
            this.setParameterBooleanFlagWithCodegenProperty(codegenParameter, codegenProperty);
            this.setParameterNullable(codegenParameter, codegenProperty);
            while (codegenProperty != null) {
                if (codegenProperty.baseType != null) {
                    imports.add(codegenProperty.baseType);
                }
                codegenProperty = codegenProperty.items;
            }
        } else if (schema instanceof BinarySchema) {
            codegenParameter.dataType = "Object";
            codegenParameter.baseType = "Object";
            codegenParameter.getVendorExtensions().put("x-is-binary", Boolean.TRUE);
        } else {
            CodegenProperty codegenProperty = this.fromProperty(bodyName, schema);
            codegenParameter.dataType = codegenProperty.datatype;
            codegenParameter.baseType = codegenProperty.baseType;
            if (codegenProperty.complexType != null) {
                imports.add(codegenProperty.complexType);
            }
        }
        this.setParameterExampleValue(codegenParameter);
        this.postProcessParameter(codegenParameter);
        return codegenParameter;
    }

    public boolean isDataTypeBinary(String dataType) {
        if (dataType != null) {
            return dataType.toLowerCase().startsWith("byte");
        }
        return false;
    }

    public boolean isDataTypeFile(String dataType) {
        if (dataType != null) {
            return dataType.toLowerCase().equals("file");
        }
        return false;
    }

    public List<CodegenSecurity> fromSecurity(Map<String, SecurityScheme> securitySchemeMap) {
        if (securitySchemeMap == null) {
            return Collections.emptyList();
        }
        ArrayList<CodegenSecurity> securities = new ArrayList<CodegenSecurity>(securitySchemeMap.size());
        for (String key : securitySchemeMap.keySet()) {
            SecurityScheme schemeDefinition = securitySchemeMap.get(key);
            CodegenSecurity codegenSecurity = (CodegenSecurity)CodegenModelFactory.newInstance((CodegenModelType)CodegenModelType.SECURITY);
            codegenSecurity.name = key;
            codegenSecurity.type = schemeDefinition.getType().toString();
            if (SecurityScheme.Type.APIKEY.equals((Object)schemeDefinition.getType())) {
                codegenSecurity.keyParamName = schemeDefinition.getName();
                codegenSecurity.getVendorExtensions().put("x-is-api-key", Boolean.TRUE);
                boolean isKeyInHeader = schemeDefinition.getIn() == SecurityScheme.In.HEADER;
                codegenSecurity.getVendorExtensions().put("x-is-key-in-header", isKeyInHeader);
                codegenSecurity.getVendorExtensions().put("x-is-key-in-query", !isKeyInHeader);
            } else if (SecurityScheme.Type.HTTP.equals((Object)schemeDefinition.getType())) {
                if ("bearer".equalsIgnoreCase(schemeDefinition.getScheme())) {
                    String tokenExample;
                    codegenSecurity.getVendorExtensions().put("x-is-bearer", Boolean.TRUE);
                    Map extensions = schemeDefinition.getExtensions();
                    if (extensions != null && extensions.get("x-token-example") != null && StringUtils.isNotBlank((CharSequence)(tokenExample = extensions.get("x-token-example").toString()))) {
                        codegenSecurity.getVendorExtensions().put("x-token-example", tokenExample);
                    }
                } else {
                    codegenSecurity.getVendorExtensions().put("x-is-basic", Boolean.TRUE);
                }
            } else if (SecurityScheme.Type.OAUTH2.equals((Object)schemeDefinition.getType())) {
                codegenSecurity.getVendorExtensions().put("x-is-oauth", Boolean.TRUE);
                OAuthFlows flows = schemeDefinition.getFlows();
                if (schemeDefinition.getFlows() == null) {
                    throw new RuntimeException("missing oauth flow in " + codegenSecurity.name);
                }
                if (flows.getPassword() != null) {
                    this.setOauth2Info(codegenSecurity, flows.getPassword());
                    codegenSecurity.getVendorExtensions().put("x-is-password", Boolean.TRUE);
                    codegenSecurity.flow = "password";
                } else if (flows.getImplicit() != null) {
                    this.setOauth2Info(codegenSecurity, flows.getImplicit());
                    codegenSecurity.getVendorExtensions().put("x-is-implicit", Boolean.TRUE);
                    codegenSecurity.flow = "implicit";
                } else if (flows.getClientCredentials() != null) {
                    this.setOauth2Info(codegenSecurity, flows.getClientCredentials());
                    codegenSecurity.getVendorExtensions().put("x-is-application", Boolean.TRUE);
                    codegenSecurity.flow = "application";
                } else if (flows.getAuthorizationCode() != null) {
                    this.setOauth2Info(codegenSecurity, flows.getAuthorizationCode());
                    codegenSecurity.getVendorExtensions().put("x-is-code", Boolean.TRUE);
                    codegenSecurity.flow = "accessCode";
                } else {
                    throw new RuntimeException("Could not identify any oauth2 flow in " + codegenSecurity.name);
                }
            }
            securities.add(codegenSecurity);
        }
        Collections.sort(securities, new Comparator<CodegenSecurity>(){

            @Override
            public int compare(CodegenSecurity one, CodegenSecurity another) {
                return ObjectUtils.compare((Comparable)((Object)one.name), (Comparable)((Object)another.name));
            }
        });
        Iterator it = securities.iterator();
        while (it.hasNext()) {
            CodegenSecurity security = (CodegenSecurity)it.next();
            security.getVendorExtensions().put("x-has-more", it.hasNext());
        }
        return securities;
    }

    protected void setReservedWordsLowerCase(List<String> words) {
        this.reservedWords = new HashSet<String>();
        for (String word : words) {
            this.reservedWords.add(word.toLowerCase());
        }
    }

    protected void setReservedWords(List<String> words) {
        this.reservedWords = new HashSet<String>();
        this.reservedWords.addAll(words);
    }

    protected boolean isReservedWord(String word) {
        return word != null && this.reservedWords.contains(word.toLowerCase());
    }

    protected String getOrGenerateOperationId(Operation operation, String path, String httpMethod) {
        String operationId = operation.getOperationId();
        if (StringUtils.isBlank((CharSequence)operationId)) {
            String tmpPath = path;
            tmpPath = tmpPath.replaceAll("\\{", "");
            tmpPath = tmpPath.replaceAll("\\}", "");
            String[] parts = (tmpPath + "/" + httpMethod).split("/");
            StringBuilder builder = new StringBuilder();
            if ("/".equals(tmpPath)) {
                builder.append("root");
            }
            for (String part : parts) {
                if (part.length() <= 0) continue;
                part = builder.toString().length() == 0 ? Character.toLowerCase(part.charAt(0)) + part.substring(1) : this.initialCaps(part);
                builder.append(part);
            }
            operationId = this.sanitizeName(builder.toString());
            LOGGER.warn("Empty operationId found for path: " + httpMethod + " " + path + ". Renamed to auto-generated operationId: " + operationId);
        }
        return operationId;
    }

    protected boolean needToImport(String type) {
        return StringUtils.isNotBlank((CharSequence)type) && !this.defaultIncludes.contains(type) && !this.languageSpecificPrimitives.contains(type);
    }

    protected List<Map<String, Object>> toExamples(Map<String, Object> examples) {
        if (examples == null) {
            return null;
        }
        ArrayList<Map<String, Object>> output = new ArrayList<Map<String, Object>>(examples.size());
        for (Map.Entry<String, Object> entry : examples.entrySet()) {
            HashMap<String, Object> kv = new HashMap<String, Object>();
            kv.put("contentType", entry.getKey());
            kv.put("example", entry.getValue());
            output.add(kv);
        }
        return output;
    }

    private void addHeaders(ApiResponse response, List<CodegenProperty> target, Map<String, Header> componentHeaders) {
        if (response.getHeaders() != null) {
            for (Map.Entry headers : response.getHeaders().entrySet()) {
                Schema schema;
                Header header = (Header)headers.getValue();
                if (header.get$ref() != null && componentHeaders != null) {
                    String ref = OpenAPIUtil.getSimpleRef(header.get$ref());
                    schema = componentHeaders.get(ref).getSchema();
                } else {
                    schema = header.getSchema();
                }
                target.add(this.fromProperty((String)headers.getKey(), schema));
            }
        }
    }

    protected static List<CodegenParameter> addHasMore(List<CodegenParameter> objs) {
        if (objs != null) {
            for (int i = 0; i < objs.size(); ++i) {
                objs.get((int)i).secondaryParam = i > 0;
                objs.get(i).getVendorExtensions().put("x-has-more", i < objs.size() - 1);
            }
        }
        return objs;
    }

    private static Map<String, Object> addHasMore(Map<String, Object> objs) {
        if (objs != null) {
            for (int i = 0; i < objs.size() - 1; ++i) {
                if (i > 0) {
                    objs.put("secondaryParam", true);
                }
                if (i >= objs.size() - 1) continue;
                objs.put("hasMore", true);
            }
        }
        return objs;
    }

    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        List<CodegenOperation> opList = operations.get(tag);
        if (opList == null) {
            opList = new ArrayList<CodegenOperation>();
            operations.put(tag, opList);
        }
        String uniqueName = co.operationId;
        int counter = 0;
        for (CodegenOperation op : opList) {
            if (!uniqueName.equals(op.operationId)) continue;
            uniqueName = co.operationId + "_" + counter;
            ++counter;
        }
        if (!co.operationId.equals(uniqueName)) {
            LOGGER.warn("generated unique operationId `" + uniqueName + "`");
        }
        co.operationId = uniqueName;
        co.operationIdLowerCase = uniqueName.toLowerCase();
        co.operationIdCamelCase = DefaultCodegenConfig.camelize(uniqueName);
        co.operationIdSnakeCase = DefaultCodegenConfig.underscore(uniqueName);
        opList.add(co);
        co.baseName = tag;
    }

    public void addParentContainer(CodegenModel codegenModel, String name, Schema schema) {
        String mappedType;
        CodegenProperty codegenProperty = this.fromProperty(name, schema);
        this.addImport(codegenModel, codegenProperty.complexType);
        codegenModel.parent = this.toInstantiationType(schema);
        String containerType = codegenProperty.containerType;
        String instantiationType = this.instantiationTypes.get(containerType);
        if (instantiationType != null) {
            this.addImport(codegenModel, instantiationType);
        }
        if ((mappedType = this.typeMapping.get(containerType)) != null) {
            this.addImport(codegenModel, mappedType);
        }
    }

    public static String underscore(String word) {
        String firstPattern = "([A-Z]+)([A-Z][a-z])";
        String secondPattern = "([a-z\\d])([A-Z])";
        String replacementPattern = "$1_$2";
        word = word.replaceAll("\\.", "/");
        word = word.replaceAll("\\$", "__");
        word = word.replaceAll(firstPattern, replacementPattern);
        word = word.replaceAll(secondPattern, replacementPattern);
        word = word.replace('-', '_');
        word = word.replace(' ', '_');
        word = word.toLowerCase();
        return word;
    }

    protected String dashize(String word) {
        return DefaultCodegenConfig.underscore(word).replaceAll("[_ ]", "-");
    }

    private static String generateNextName(String name) {
        Pattern pattern = Pattern.compile("\\d+\\z");
        Matcher matcher = pattern.matcher(name);
        if (matcher.find()) {
            String numStr = matcher.group();
            int num = Integer.parseInt(numStr) + 1;
            return name.substring(0, name.length() - numStr.length()) + num;
        }
        return name + "2";
    }

    protected void addImport(CodegenModel m, String type) {
        if (type != null && this.needToImport(type)) {
            m.imports.add(type);
        }
    }

    protected void addVars(CodegenModel codegenModel, Map<String, Schema> properties, List<String> required) {
        this.addVars(codegenModel, properties, required, null, null);
    }

    private void addVars(CodegenModel codegenModel, Map<String, Schema> properties, List<String> required, Map<String, Schema> allProperties, List<String> allRequired) {
        codegenModel.getVendorExtensions().put("x-has-required", Boolean.FALSE);
        if (properties != null && !properties.isEmpty()) {
            codegenModel.getVendorExtensions().put("x-has-vars", true);
            codegenModel.getVendorExtensions().put("x-has-enums", false);
            TreeSet<String> mandatory = required == null ? Collections.emptySet() : new TreeSet<String>(required);
            this.addVars(codegenModel, codegenModel.vars, properties, mandatory);
            codegenModel.allMandatory = codegenModel.mandatory = mandatory;
        } else {
            codegenModel.emptyVars = true;
            codegenModel.getVendorExtensions().put("x-has-vars", false);
            codegenModel.getVendorExtensions().put("x-has-enums", false);
        }
        if (allProperties != null) {
            TreeSet<String> allMandatory = allRequired == null ? Collections.emptySet() : new TreeSet<String>(allRequired);
            this.addVars(codegenModel, codegenModel.allVars, allProperties, allMandatory);
            codegenModel.allMandatory = allMandatory;
        }
    }

    private void addVars(CodegenModel codegenModel, List<CodegenProperty> vars, Map<String, Schema> properties, Set<String> mandatory) {
        ArrayList<Map.Entry<String, Schema>> propertyList = new ArrayList<Map.Entry<String, Schema>>(properties.entrySet());
        int totalCount = propertyList.size();
        for (int i = 0; i < totalCount; ++i) {
            Map.Entry entry = (Map.Entry)propertyList.get(i);
            String key = (String)entry.getKey();
            Schema propertySchema = (Schema)entry.getValue();
            if (propertySchema == null) {
                LOGGER.warn("null property for " + key);
                continue;
            }
            CodegenProperty codegenProperty2 = this.fromProperty(key, propertySchema);
            codegenProperty2.required = mandatory.contains(key);
            if (propertySchema.get$ref() != null) {
                if (this.openAPI == null) {
                    LOGGER.warn("open api utility object was not properly set.");
                } else {
                    OpenAPIUtil.addPropertiesFromRef(this.openAPI, propertySchema, codegenProperty2);
                }
            }
            boolean hasRequired = ExtensionHelper.getBooleanValue((VendorExtendable)codegenModel, "x-has-required") || codegenProperty2.required;
            boolean hasOptional = ExtensionHelper.getBooleanValue((VendorExtendable)codegenModel, "x-has-optional") || !codegenProperty2.required;
            codegenModel.getVendorExtensions().put("x-has-required", hasRequired);
            codegenModel.getVendorExtensions().put("x-has-optional", hasOptional);
            boolean isEnum = ExtensionHelper.getBooleanValue((VendorExtendable)codegenProperty2, "x-is-enum");
            if (isEnum) {
                codegenModel.getVendorExtensions().put("x-has-enums", true);
            }
            if (!ExtensionHelper.getBooleanValue((VendorExtendable)codegenProperty2, "x-is-read-only")) {
                codegenModel.getVendorExtensions().put("x-has-only-read-only", Boolean.FALSE);
            }
            if (i + 1 != totalCount) {
                codegenProperty2.getVendorExtensions().put("x-has-more", Boolean.TRUE);
                if (!Boolean.TRUE.equals(((Schema)((Map.Entry)propertyList.get(i + 1)).getValue()).getReadOnly())) {
                    codegenProperty2.getVendorExtensions().put("x-has-more-non-read-only", Boolean.TRUE);
                }
            }
            if (ExtensionHelper.getBooleanValue((VendorExtendable)codegenProperty2, "x-is-container")) {
                this.addImport(codegenModel, this.typeMapping.get("array"));
            }
            this.addImport(codegenModel, codegenProperty2.baseType);
            CodegenProperty innerCp = codegenProperty2;
            while (innerCp != null) {
                this.addImport(codegenModel, innerCp.complexType);
                innerCp = innerCp.items;
            }
            vars.add(codegenProperty2);
            if (Boolean.TRUE.equals(codegenProperty2.required)) {
                codegenModel.requiredVars.add(codegenProperty2);
            } else {
                codegenModel.optionalVars.add(codegenProperty2);
            }
            if (ExtensionHelper.getBooleanValue((VendorExtendable)codegenProperty2, "x-is-read-only")) {
                codegenModel.readOnlyVars.add(codegenProperty2);
                continue;
            }
            codegenModel.readWriteVars.add(codegenProperty2);
        }
        List modelProperties = vars.stream().filter(codegenProperty -> ExtensionHelper.getBooleanValue((VendorExtendable)codegenProperty, "x-is-object") && this.importMapping.containsKey(codegenProperty.baseType)).collect(Collectors.toList());
        if (modelProperties == null || modelProperties.isEmpty()) {
            return;
        }
        for (CodegenProperty modelProperty : modelProperties) {
            List codegenProperties = vars.stream().filter(codegenProperty -> !ExtensionHelper.getBooleanValue((VendorExtendable)codegenProperty, "x-is-object") && this.importMapping.containsKey(codegenProperty.baseType) && codegenProperty.baseType.equals(modelProperty.baseType)).collect(Collectors.toList());
            if (codegenProperties == null || codegenProperties.isEmpty()) continue;
            for (CodegenProperty codegenProperty3 : codegenProperties) {
                codegenModel.imports.remove(codegenProperty3.baseType);
                codegenProperty3.datatypeWithEnum = codegenProperty3.datatype = this.importMapping.get(codegenProperty3.baseType);
            }
        }
    }

    private static Map<String, String> getAllAliases(Map<String, Schema> allSchemas) {
        HashMap<String, String> aliases = new HashMap<String, String>();
        if (allSchemas == null || allSchemas.isEmpty()) {
            return aliases;
        }
        for (Map.Entry<String, Schema> entry : allSchemas.entrySet()) {
            String schemaType;
            String swaggerName = entry.getKey();
            Schema schema = entry.getValue();
            if (schema instanceof ArraySchema || schema instanceof MapSchema || (schemaType = DefaultCodegenConfig.getTypeOfSchema(schema)) == null || schemaType.equals("object") || schema.getEnum() != null) continue;
            aliases.put(swaggerName, schemaType);
        }
        return aliases;
    }

    public String removeNonNameElementToCamelCase(String name) {
        return this.removeNonNameElementToCamelCase(name, "[-_:;#]");
    }

    protected String removeNonNameElementToCamelCase(String name, String nonNameElementPattern) {
        String result = Arrays.stream(name.split(nonNameElementPattern)).map(StringUtils::capitalize).collect(Collectors.joining(""));
        if (result.length() > 0) {
            result = result.substring(0, 1).toLowerCase() + result.substring(1);
        }
        return result;
    }

    public static String camelize(String word) {
        return DefaultCodegenConfig.camelize(word, false);
    }

    public static String camelize(String word, boolean lowercaseFirstLetter) {
        String originalWord = word;
        LOGGER.trace("camelize start - " + originalWord);
        Pattern p = Pattern.compile("\\/(.?)");
        Matcher m = p.matcher(word);
        int i = 0;
        int MAX = 100;
        while (m.find()) {
            if (i > MAX) {
                LOGGER.error("camelize reached find limit - {} / {}", (Object)originalWord, (Object)word);
                break;
            }
            ++i;
            word = m.replaceFirst("." + m.group(1));
            m = p.matcher(word);
        }
        i = 0;
        String[] parts = word.split("\\.");
        StringBuilder f = new StringBuilder();
        for (String z : parts) {
            if (z.length() <= 0) continue;
            f.append(Character.toUpperCase(z.charAt(0))).append(z.substring(1));
        }
        word = f.toString();
        m = p.matcher(word);
        while (m.find()) {
            if (i > MAX) {
                LOGGER.error("camelize reached find limit - {} / {}", (Object)originalWord, (Object)word);
                break;
            }
            ++i;
            word = m.replaceFirst("" + Character.toUpperCase(m.group(1).charAt(0)) + m.group(1).substring(1));
            m = p.matcher(word);
        }
        i = 0;
        p = Pattern.compile("(\\.?)(\\w)([^\\.]*)$");
        m = p.matcher(word);
        if (m.find()) {
            String rep = m.group(1) + m.group(2).toUpperCase() + m.group(3);
            rep = rep.replaceAll("\\$", "\\\\\\$");
            word = m.replaceAll(rep);
        }
        p = Pattern.compile("(_)(.)");
        m = p.matcher(word);
        while (m.find()) {
            String upperCase;
            if (i > MAX) {
                LOGGER.error("camelize reached find limit - {} / {}", (Object)originalWord, (Object)word);
                break;
            }
            ++i;
            String original = m.group(2);
            word = original.equals(upperCase = original.toUpperCase()) ? word.replaceFirst("_", "") : m.replaceFirst(upperCase);
            m = p.matcher(word);
        }
        p = Pattern.compile("(-)(.)");
        m = p.matcher(word);
        i = 0;
        while (m.find()) {
            if (i > MAX) {
                LOGGER.error("camelize reached find limit - {} / {}", (Object)originalWord, (Object)word);
                break;
            }
            ++i;
            word = m.replaceFirst(m.group(2).toUpperCase());
            m = p.matcher(word);
        }
        if (lowercaseFirstLetter && word.length() > 0) {
            word = word.substring(0, 1).toLowerCase() + word.substring(1);
        }
        LOGGER.trace("camelize end - {} (new: {})", (Object)originalWord, (Object)word);
        return word;
    }

    public String apiFilename(String templateName, String tag) {
        String suffix = this.apiTemplateFiles().get(templateName);
        return this.apiFileFolder() + File.separator + this.toApiFilename(tag) + suffix;
    }

    public String apiDocFilename(String templateName, String tag) {
        String suffix = this.apiDocTemplateFiles().get(templateName);
        return this.apiDocFileFolder() + '/' + this.toApiDocFilename(tag) + suffix;
    }

    public String apiTestFilename(String templateName, String tag) {
        String suffix = this.apiTestTemplateFiles().get(templateName);
        return this.apiTestFileFolder() + '/' + this.toApiTestFilename(tag) + suffix;
    }

    public boolean shouldOverwrite(String filename) {
        return !this.skipOverwrite || !new File(filename).exists();
    }

    public boolean isSkipOverwrite() {
        return this.skipOverwrite;
    }

    public void setSkipOverwrite(boolean skipOverwrite) {
        this.skipOverwrite = skipOverwrite;
    }

    public boolean isRemoveOperationIdPrefix() {
        return this.removeOperationIdPrefix;
    }

    public void setRemoveOperationIdPrefix(boolean removeOperationIdPrefix) {
        this.removeOperationIdPrefix = removeOperationIdPrefix;
    }

    public Map<String, String> supportedLibraries() {
        return this.supportedLibraries;
    }

    public void setLibrary(String library) {
        if (library != null && !this.supportedLibraries.containsKey(library)) {
            StringBuilder sb = new StringBuilder("Unknown library: " + library + "\nAvailable libraries:");
            if (this.supportedLibraries.size() == 0) {
                sb.append("\n  ").append("NONE");
            } else {
                for (String lib : this.supportedLibraries.keySet()) {
                    sb.append("\n  ").append(lib);
                }
            }
            throw new RuntimeException(sb.toString());
        }
        this.library = library;
    }

    public String getLibrary() {
        return this.library;
    }

    public void setGitUserId(String gitUserId) {
        this.gitUserId = gitUserId;
    }

    public String getGitUserId() {
        return this.gitUserId;
    }

    public void setGitRepoId(String gitRepoId) {
        this.gitRepoId = gitRepoId;
    }

    public String getGitRepoId() {
        return this.gitRepoId;
    }

    public void setReleaseNote(String releaseNote) {
        this.releaseNote = releaseNote;
    }

    public String getReleaseNote() {
        return this.releaseNote;
    }

    public void setHttpUserAgent(String httpUserAgent) {
        this.httpUserAgent = httpUserAgent;
    }

    public String getHttpUserAgent() {
        return this.httpUserAgent;
    }

    public void setHideGenerationTimestamp(Boolean hideGenerationTimestamp) {
        this.hideGenerationTimestamp = hideGenerationTimestamp;
    }

    public Boolean getHideGenerationTimestamp() {
        return this.hideGenerationTimestamp;
    }

    protected CliOption buildLibraryCliOption(Map<String, String> supportedLibraries) {
        StringBuilder sb = new StringBuilder("library template (sub-template) to use:");
        for (String lib : supportedLibraries.keySet()) {
            sb.append("\n").append(lib).append(" - ").append(supportedLibraries.get(lib));
        }
        return new CliOption("library", sb.toString());
    }

    public String sanitizeName(String name) {
        if (this.maybeHandleEmptyName(name)) {
            return Object.class.getSimpleName();
        }
        if (this.maybeHandleDollarName(name)) {
            return "value";
        }
        name = name.replaceAll("\\[\\]", "");
        name = name.replaceAll("\\[", "_");
        name = name.replaceAll("\\]", "");
        name = name.replaceAll("\\(", "_");
        name = name.replaceAll("\\)", "");
        name = name.replaceAll("\\.", "_");
        name = name.replaceAll("-", "_");
        name = name.replaceAll(" ", "_");
        name = this.allowUnicodeIdentifiers != false ? Pattern.compile("\\W", 256).matcher(name).replaceAll("") : name.replaceAll("\\W", "");
        return name;
    }

    private boolean maybeHandleDollarName(String name) {
        return "$".equals(name);
    }

    private boolean maybeHandleEmptyName(String name) {
        if (name == null) {
            LOGGER.warn("String to be sanitized is null. Default to " + Object.class.getSimpleName());
            return true;
        }
        return false;
    }

    public String sanitizeTag(String tag) {
        if ((tag = DefaultCodegenConfig.camelize(this.sanitizeName(tag))).matches("^\\d.*")) {
            tag = "Class" + tag;
        }
        return tag;
    }

    public void addHandlebarHelpers(Handlebars handlebars) {
        handlebars.registerHelper("is", (Helper)new IsHelper());
        handlebars.registerHelper("has", (Helper)new HasHelper());
        handlebars.registerHelper("isNot", (Helper)new IsNotHelper());
        handlebars.registerHelper("hasNot", (Helper)new HasNotHelper());
        handlebars.registerHelper("braces", (Helper)new BracesHelper());
        handlebars.registerHelper("baseItems", (Helper)new BaseItemsHelper());
        handlebars.registerHelper("notEmpty", (Helper)new NotEmptyHelper());
        handlebars.registerHelpers((Object)new StringUtilHelper());
    }

    public List<CodegenArgument> readLanguageArguments() {
        JsonNode rootNode;
        String content;
        String argumentsLocation = this.getArgumentsLocation();
        if (StringUtils.isBlank((CharSequence)argumentsLocation)) {
            return null;
        }
        InputStream inputStream = this.getClass().getResourceAsStream(argumentsLocation);
        if (inputStream == null) {
            return null;
        }
        try {
            content = IOUtils.toString((InputStream)inputStream);
            if (StringUtils.isBlank((CharSequence)content)) {
                return null;
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not read arguments for java language.", (Throwable)e);
            return null;
        }
        try {
            rootNode = Yaml.mapper().readTree(content.getBytes());
            if (rootNode == null) {
                return null;
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not parse java arguments content.", (Throwable)e);
            return null;
        }
        JsonNode arguments = rootNode.findValue("arguments");
        if (arguments == null || !arguments.isArray()) {
            return null;
        }
        ArrayList<CodegenArgument> languageArguments = new ArrayList<CodegenArgument>();
        for (JsonNode argument : arguments) {
            String option = argument.findValue("option") != null ? argument.findValue("option").textValue() : null;
            String description = argument.findValue("description") != null ? argument.findValue("description").textValue() : null;
            String shortOption = argument.findValue("shortOption") != null ? argument.findValue("shortOption").textValue() : null;
            String type = argument.findValue("type") != null ? argument.findValue("type").textValue() : "string";
            boolean isArray = argument.findValue("isArray") != null ? argument.findValue("isArray").booleanValue() : false;
            languageArguments.add(new CodegenArgument().option(option).shortOption(shortOption).description(description).type(type).isArray(Boolean.valueOf(isArray)));
        }
        return languageArguments;
    }

    public void setLanguageArguments(List<CodegenArgument> languageArguments) {
        this.languageArguments = languageArguments;
    }

    public List<CodegenArgument> getLanguageArguments() {
        return this.languageArguments;
    }

    public String getArgumentsLocation() {
        return null;
    }

    protected String getOptionValue(String optionName) {
        List<CodegenArgument> codegenArguments = this.getLanguageArguments();
        if (codegenArguments == null || codegenArguments.isEmpty()) {
            return null;
        }
        Optional<CodegenArgument> codegenArgumentOptional = codegenArguments.stream().filter(argument -> argument.getOption().equalsIgnoreCase(optionName)).findAny();
        if (!codegenArgumentOptional.isPresent()) {
            return null;
        }
        return codegenArgumentOptional.get().getValue();
    }

    public void writeOptional(String outputFolder, SupportingFile supportingFile) {
        String folder = "";
        if (outputFolder != null && !"".equals(outputFolder)) {
            folder = folder + outputFolder + File.separator;
        }
        if (!new File(folder = !"".equals(folder = folder + supportingFile.folder) ? folder + File.separator + supportingFile.destinationFilename : supportingFile.destinationFilename).exists()) {
            this.supportingFiles.add(supportingFile);
        } else {
            LOGGER.info("Skipped overwriting " + supportingFile.destinationFilename + " as the file already exists in " + folder);
        }
    }

    public void setParameterBooleanFlagWithCodegenProperty(CodegenParameter parameter, CodegenProperty property) {
        if (parameter == null) {
            LOGGER.error("Codegen Parameter cannot be null.");
            return;
        }
        if (property == null) {
            LOGGER.error("Codegen Property cannot be null.");
            return;
        }
        parameter.getVendorExtensions().put("x-is-primitive-type", Boolean.TRUE);
        if (ExtensionHelper.getBooleanValue((VendorExtendable)property, "x-is-uuid") && ExtensionHelper.getBooleanValue((VendorExtendable)property, "x-is-string")) {
            parameter.getVendorExtensions().put("x-is-uuid", Boolean.TRUE);
            parameter.getVendorExtensions().put("x-is-primitive-type", Boolean.FALSE);
        } else if (ExtensionHelper.getBooleanValue((VendorExtendable)property, "x-is-byte-array")) {
            parameter.getVendorExtensions().put("x-is-byte-array", Boolean.TRUE);
        } else if (ExtensionHelper.getBooleanValue((VendorExtendable)property, "x-is-string")) {
            parameter.getVendorExtensions().put("x-is-string", Boolean.TRUE);
        } else if (ExtensionHelper.getBooleanValue((VendorExtendable)property, "x-is-boolean")) {
            parameter.getVendorExtensions().put("x-is-boolean", Boolean.TRUE);
        } else if (ExtensionHelper.getBooleanValue((VendorExtendable)property, "x-is-long")) {
            parameter.getVendorExtensions().put("x-is-long", Boolean.TRUE);
        } else if (ExtensionHelper.getBooleanValue((VendorExtendable)property, "x-is-integer")) {
            parameter.getVendorExtensions().put("x-is-integer", Boolean.TRUE);
        } else if (ExtensionHelper.getBooleanValue((VendorExtendable)property, "x-is-double")) {
            parameter.getVendorExtensions().put("x-is-double", Boolean.TRUE);
        } else if (ExtensionHelper.getBooleanValue((VendorExtendable)property, "x-is-float")) {
            parameter.getVendorExtensions().put("x-is-float", Boolean.TRUE);
        } else if (ExtensionHelper.getBooleanValue((VendorExtendable)property, "x-is-number")) {
            parameter.getVendorExtensions().put("x-is-number", Boolean.TRUE);
        } else if (ExtensionHelper.getBooleanValue((VendorExtendable)property, "x-is-binary")) {
            parameter.getVendorExtensions().put("x-is-byte-array", Boolean.TRUE);
        } else if (ExtensionHelper.getBooleanValue((VendorExtendable)property, "x-is-file")) {
            parameter.getVendorExtensions().put("x-is-file", Boolean.TRUE);
        } else if (ExtensionHelper.getBooleanValue((VendorExtendable)property, "x-is-date")) {
            parameter.getVendorExtensions().put("x-is-date", Boolean.TRUE);
        } else if (ExtensionHelper.getBooleanValue((VendorExtendable)property, "x-is-date-time")) {
            parameter.getVendorExtensions().put("x-is-date-time", Boolean.TRUE);
        } else {
            LOGGER.debug("Property type is not primitive: " + property.datatype);
            parameter.getVendorExtensions().put("x-is-primitive-type", Boolean.FALSE);
        }
    }

    public void updateCodegenPropertyEnum(CodegenProperty var) {
        Map allowableValues = var.allowableValues;
        if (var.items != null) {
            allowableValues = var.items.allowableValues;
        }
        if (allowableValues == null) {
            return;
        }
        List values = (List)allowableValues.get("values");
        if (values == null) {
            return;
        }
        ArrayList enumVars = new ArrayList();
        String commonPrefix = this.findCommonPrefixOfVars(values);
        int truncateIdx = commonPrefix.length();
        for (Object value : values) {
            Map enumVar = new HashMap<String, String>();
            String enumName = this.findEnumName(truncateIdx, value);
            enumVar.put("name", this.toEnumVarName(enumName, var.datatype));
            if (value == null) {
                enumVar.put("value", this.toEnumValue(null, var.datatype));
            } else {
                enumVar.put("value", this.toEnumValue(value.toString(), var.datatype));
            }
            enumVars.add(enumVar);
        }
        allowableValues.put("enumVars", enumVars);
        if (enumVars != null & !enumVars.isEmpty()) {
            for (int i = 0; i < enumVars.size(); ++i) {
                Map enumVarList = (Map)enumVars.get(i);
                String enumVarName = (String)enumVarList.get("name");
                for (int j = 0; j < enumVars.size(); ++j) {
                    Map enumVarToCheckList;
                    String enumVarNameToCheck;
                    if (i == j || !enumVarName.equals(enumVarNameToCheck = (String)(enumVarToCheckList = (Map)enumVars.get(j)).get("name"))) continue;
                    enumVarToCheckList.put("name", enumVarName + "_" + j);
                }
            }
        }
        if (var.defaultValue != null) {
            String enumName = null;
            for (Map enumVar : enumVars) {
                if (!this.toEnumValue(var.defaultValue, var.datatype).equals(enumVar.get("value"))) continue;
                enumName = (String)enumVar.get("name");
                break;
            }
            if (enumName != null) {
                var.defaultValue = String.format("%s.%s", var.datatypeWithEnum, enumName);
            }
        }
    }

    public String addRegularExpressionDelimiter(String pattern) {
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            return pattern;
        }
        if (!pattern.matches("^/.*")) {
            return "/" + pattern.replaceAll("/", "\\\\/") + "/";
        }
        return pattern;
    }

    public boolean convertPropertyToBooleanAndWriteBack(String propertyKey) {
        boolean booleanValue = false;
        if (this.additionalProperties.containsKey(propertyKey)) {
            booleanValue = this.convertPropertyToBoolean(propertyKey);
            this.writePropertyBack(propertyKey, booleanValue);
        }
        return booleanValue;
    }

    public String getIgnoreFilePathOverride() {
        return this.ignoreFilePathOverride;
    }

    public void setIgnoreFilePathOverride(String ignoreFileOverride) {
        this.ignoreFilePathOverride = ignoreFileOverride;
    }

    public void setUseOas2(boolean useOas2) {
        this.useOas2 = useOas2;
    }

    public abstract String getDefaultTemplateDir();

    public boolean convertPropertyToBoolean(String propertyKey) {
        boolean booleanValue = false;
        if (this.additionalProperties.containsKey(propertyKey)) {
            booleanValue = Boolean.valueOf(this.additionalProperties.get(propertyKey).toString());
        }
        return booleanValue;
    }

    public void writePropertyBack(String propertyKey, boolean value) {
        this.additionalProperties.put(propertyKey, value);
    }

    protected void addOption(String key, String description) {
        this.addOption(key, description, null);
    }

    protected void addOption(String key, String description, String defaultValue) {
        CliOption option = new CliOption(key, description);
        if (defaultValue != null) {
            option.defaultValue(defaultValue);
        }
        this.cliOptions.add(option);
    }

    protected void addSwitch(String key, String description, Boolean defaultValue) {
        CliOption option = CliOption.newBoolean((String)key, (String)description);
        if (defaultValue != null) {
            option.defaultValue(defaultValue.toString());
        }
        this.cliOptions.add(option);
    }

    protected String getContentType(RequestBody requestBody) {
        if (requestBody == null || requestBody.getContent() == null || requestBody.getContent().isEmpty()) {
            return null;
        }
        return (String)new ArrayList(requestBody.getContent().keySet()).get(0);
    }

    protected Schema getSchemaFromBody(RequestBody requestBody) {
        String contentType = (String)new ArrayList(requestBody.getContent().keySet()).get(0);
        MediaType mediaType = (MediaType)requestBody.getContent().get((Object)contentType);
        return mediaType.getSchema();
    }

    protected Schema getSchemaFromResponse(ApiResponse response) {
        Schema schema;
        block2: {
            if (response.getContent() == null || response.getContent().isEmpty()) {
                return null;
            }
            schema = null;
            Iterator iterator = response.getContent().keySet().iterator();
            if (!iterator.hasNext()) break block2;
            String contentType = (String)iterator.next();
            schema = ((MediaType)response.getContent().get((Object)contentType)).getSchema();
            if (schema != null) {
                schema.addExtension("x-content-type", (Object)contentType);
            }
        }
        return schema;
    }

    protected Schema getSchemaFromParameter(Parameter parameter) {
        Schema schema;
        block2: {
            if (parameter.getContent() == null || parameter.getContent().isEmpty()) {
                return null;
            }
            schema = null;
            Iterator iterator = parameter.getContent().keySet().iterator();
            if (!iterator.hasNext()) break block2;
            String contentType = (String)iterator.next();
            schema = ((MediaType)parameter.getContent().get((Object)contentType)).getSchema();
            if (schema != null) {
                schema.addExtension("x-content-type", (Object)contentType);
            }
        }
        return schema;
    }

    protected Parameter getParameterFromRef(String ref, OpenAPI openAPI) {
        String parameterName = ref.substring(ref.lastIndexOf(47) + 1);
        Map parameterMap = openAPI.getComponents().getParameters();
        return (Parameter)parameterMap.get(parameterName);
    }

    protected void setTemplateEngine() {
        String templateEngineKey;
        String string = templateEngineKey = this.additionalProperties.get("templateEngine") != null ? this.additionalProperties.get("templateEngine").toString() : null;
        this.templateEngine = templateEngineKey == null ? new HandlebarTemplateEngine((CodegenConfig)this) : (DEFAULT_TEMPLATE_DIR.equalsIgnoreCase(templateEngineKey) ? new HandlebarTemplateEngine((CodegenConfig)this) : new MustacheTemplateEngine((CodegenConfig)this));
    }

    protected String getTemplateDir() {
        return this.templateEngine.getName() + File.separatorChar + this.getDefaultTemplateDir();
    }

    private void setOauth2Info(CodegenSecurity codegenSecurity, OAuthFlow flow) {
        codegenSecurity.authorizationUrl = flow.getAuthorizationUrl();
        codegenSecurity.tokenUrl = flow.getTokenUrl();
        codegenSecurity.scopes = flow.getScopes();
    }

    private List<Schema> getInterfaces(ComposedSchema composed) {
        if (composed.getAllOf() != null && composed.getAllOf().size() > 1) {
            return composed.getAllOf().subList(1, composed.getAllOf().size());
        }
        if (composed.getAnyOf() != null && !composed.getAnyOf().isEmpty()) {
            return composed.getAnyOf();
        }
        if (composed.getOneOf() != null && !composed.getOneOf().isEmpty()) {
            return composed.getOneOf();
        }
        return null;
    }

    protected void addConsumesInfo(Operation operation, CodegenOperation codegenOperation, OpenAPI openAPI) {
        RequestBody body = operation.getRequestBody();
        if (body == null) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)body.get$ref())) {
            String bodyName = OpenAPIUtil.getSimpleRef(body.get$ref());
            body = (RequestBody)openAPI.getComponents().getRequestBodies().get(bodyName);
        }
        if (body.getContent() == null || body.getContent().isEmpty()) {
            return;
        }
        Set consumes = body.getContent().keySet();
        ArrayList<HashMap<String, String>> mediaTypeList = new ArrayList<HashMap<String, String>>();
        int count = 0;
        for (String key : consumes) {
            HashMap<String, String> mediaType = new HashMap<String, String>();
            this.decideMediaType(key, mediaType);
            if (++count < consumes.size()) {
                mediaType.put("hasMore", "true");
            } else {
                mediaType.put("hasMore", null);
            }
            mediaTypeList.add(mediaType);
        }
        codegenOperation.consumes = mediaTypeList;
        codegenOperation.getVendorExtensions().put("x-has-consumes", Boolean.TRUE);
    }

    private void decideMediaType(String key, Map<String, String> mediaType) {
        if ("*/*".equals(key)) {
            mediaType.put("mediaType", key);
        } else {
            mediaType.put("mediaType", this.escapeText(this.escapeQuotationMark(key)));
        }
    }

    protected void configureDataForTestTemplate(CodegenOperation codegenOperation) {
        String httpMethod = codegenOperation.httpMethod;
        String path = codegenOperation.path;
        if ("GET".equalsIgnoreCase(httpMethod)) {
            codegenOperation.getVendorExtensions().put("x-is-get-method", Boolean.TRUE);
        }
        if ("POST".equalsIgnoreCase(httpMethod)) {
            codegenOperation.getVendorExtensions().put("x-is-post-method", Boolean.TRUE);
        }
        if ("PUT".equalsIgnoreCase(httpMethod)) {
            codegenOperation.getVendorExtensions().put("x-is-put-method", Boolean.TRUE);
        }
        if ("DELETE".equalsIgnoreCase(httpMethod)) {
            codegenOperation.getVendorExtensions().put("x-is-delete-method", Boolean.TRUE);
        }
        if ("HEAD".equalsIgnoreCase(httpMethod)) {
            codegenOperation.getVendorExtensions().put("x-is-head-method", Boolean.TRUE);
        }
        if ("TRACE".equalsIgnoreCase(httpMethod)) {
            codegenOperation.getVendorExtensions().put("x-is-trace-method", Boolean.TRUE);
        }
        if ("PATCH".equalsIgnoreCase(httpMethod)) {
            codegenOperation.getVendorExtensions().put("x-is-patch-method", Boolean.TRUE);
        }
        if ("OPTIONS".equalsIgnoreCase(httpMethod)) {
            codegenOperation.getVendorExtensions().put("x-is-options-method", Boolean.TRUE);
        }
        if (path.contains("{")) {
            while (path.contains("{")) {
                String pathParam = path.substring(path.indexOf("{"), path.indexOf("}") + 1);
                String paramName = pathParam.replace("{", "").replace("}", "");
                Optional<CodegenParameter> optionalCodegenParameter = codegenOperation.pathParams.stream().filter(codegenParam -> codegenParam.baseName.equals(paramName)).findFirst();
                if (!optionalCodegenParameter.isPresent()) {
                    return;
                }
                CodegenParameter codegenParameter = optionalCodegenParameter.get();
                if (codegenParameter.testExample == null) {
                    return;
                }
                path = path.replace(pathParam, codegenParameter.testExample);
            }
        }
        codegenOperation.testPath = path;
    }

    protected Set<String> getConsumesInfo(Operation operation) {
        if (operation.getRequestBody() == null || operation.getRequestBody().getContent() == null || operation.getRequestBody().getContent().isEmpty()) {
            return null;
        }
        return operation.getRequestBody().getContent().keySet();
    }

    protected void addProducesInfo(ApiResponse response, CodegenOperation codegenOperation) {
        if (response == null || response.getContent() == null || response.getContent().isEmpty()) {
            return;
        }
        Set produces = response.getContent().keySet();
        if (codegenOperation.produces == null) {
            codegenOperation.produces = new ArrayList();
        }
        for (String key : produces) {
            HashMap<String, String> mediaType = new HashMap<String, String>();
            this.decideMediaType(key, mediaType);
            mediaType.put("hasMore", "true");
            codegenOperation.produces.add(mediaType);
            codegenOperation.getVendorExtensions().put("x-has-produces", Boolean.TRUE);
        }
    }

    protected Set<String> getProducesInfo(Operation operation) {
        if (operation.getResponses() == null || operation.getResponses().isEmpty()) {
            return null;
        }
        return operation.getResponses().keySet();
    }

    protected Schema detectParent(ComposedSchema composedSchema, Map<String, Schema> allSchemas) {
        if (composedSchema.getAllOf() != null && !composedSchema.getAllOf().isEmpty()) {
            Schema schema = (Schema)composedSchema.getAllOf().get(0);
            String ref = schema.get$ref();
            if (StringUtils.isBlank((CharSequence)ref)) {
                return null;
            }
            ref = OpenAPIUtil.getSimpleRef(ref);
            return allSchemas.get(ref);
        }
        return null;
    }

    protected String getParentName(ComposedSchema composedSchema) {
        if (composedSchema.getAllOf() != null && !composedSchema.getAllOf().isEmpty()) {
            Schema schema = (Schema)composedSchema.getAllOf().get(0);
            String ref = schema.get$ref();
            if (StringUtils.isBlank((CharSequence)ref)) {
                return null;
            }
            return OpenAPIUtil.getSimpleRef(ref);
        }
        return null;
    }

    protected String getCollectionFormat(Parameter parameter) {
        if (parameter.getExplode() == null || parameter.getExplode().booleanValue()) {
            return "multi";
        }
        if (parameter.getStyle() == null || Parameter.StyleEnum.FORM.equals((Object)parameter.getStyle())) {
            return "csv";
        }
        if (Parameter.StyleEnum.PIPEDELIMITED.equals((Object)parameter.getStyle())) {
            return "pipe";
        }
        if (Parameter.StyleEnum.SPACEDELIMITED.equals((Object)parameter.getStyle())) {
            return "space";
        }
        return null;
    }

    public boolean isObjectSchema(Schema schema) {
        Schema refSchema;
        if (schema == null) {
            return false;
        }
        if (schema instanceof ObjectSchema || schema instanceof ComposedSchema) {
            return true;
        }
        if ("object".equalsIgnoreCase(schema.getType()) && !(schema instanceof MapSchema)) {
            return true;
        }
        if (schema.getType() == null && schema.getProperties() != null && !schema.getProperties().isEmpty()) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)schema.get$ref()) && (refSchema = OpenAPIUtil.getSchemaFromRefSchema(schema, this.openAPI)) != null) {
            return this.isObjectSchema(refSchema);
        }
        return false;
    }

    private boolean containsFormContentType(RequestBody body) {
        if (body == null) {
            return false;
        }
        Content content = body.getContent();
        if (content == null || content.isEmpty()) {
            return false;
        }
        return content.get((Object)"application/x-www-form-urlencoded") != null || content.get((Object)"multipart/form-data") != null;
    }

    protected static boolean hasSchemaProperties(Schema schema) {
        Object additionalProperties = schema.getAdditionalProperties();
        return additionalProperties != null && additionalProperties instanceof Schema;
    }

    protected static boolean hasTrueAdditionalProperties(Schema schema) {
        Object additionalProperties = schema.getAdditionalProperties();
        return additionalProperties != null && Boolean.TRUE.equals(additionalProperties);
    }

    protected void configuresParameterForMediaType(CodegenOperation codegenOperation, List<CodegenContent> codegenContents) {
        if (codegenContents.isEmpty()) {
            CodegenContent content = new CodegenContent();
            content.getParameters().addAll(codegenOperation.allParams);
            codegenContents.add(content);
            codegenOperation.getContents().add(content);
            return;
        }
        this.addCodegenContentParameters(codegenOperation, codegenContents);
        for (CodegenContent content : codegenContents) {
            if (this.ensureUniqueParams.booleanValue()) {
                this.ensureUniqueParameters(content.getParameters());
            }
            Collections.sort(content.getParameters(), (one, another) -> {
                if (one.required == another.required) {
                    return 0;
                }
                if (one.required) {
                    return -1;
                }
                return 1;
            });
            DefaultCodegenConfig.addHasMore(content.getParameters());
        }
        codegenOperation.getContents().addAll(codegenContents);
    }

    protected void addParameters(CodegenContent codegenContent, List<CodegenParameter> codegenParameters) {
        if (codegenParameters == null || codegenParameters.isEmpty()) {
            return;
        }
        for (CodegenParameter codegenParameter : codegenParameters) {
            codegenContent.getParameters().add(codegenParameter.copy());
        }
    }

    protected void addCodegenContentParameters(CodegenOperation codegenOperation, List<CodegenContent> codegenContents) {
        for (CodegenContent content : codegenContents) {
            if (content.getIsForm()) {
                this.addParameters(content, codegenOperation.formParams);
            } else {
                this.addParameters(content, codegenOperation.bodyParams);
            }
            this.addParameters(content, codegenOperation.headerParams);
            this.addParameters(content, codegenOperation.queryParams);
            this.addParameters(content, codegenOperation.pathParams);
            this.addParameters(content, codegenOperation.cookieParams);
        }
    }

    protected void ensureUniqueParameters(List<CodegenParameter> codegenParameters) {
        if (codegenParameters == null || codegenParameters.isEmpty()) {
            return;
        }
        for (CodegenParameter codegenParameter : codegenParameters) {
            long count = codegenParameters.stream().filter(codegenParam -> codegenParam.paramName.equals(codegenParameter.paramName)).count();
            if (count <= 1L) continue;
            codegenParameter.paramName = DefaultCodegenConfig.generateNextName(codegenParameter.paramName);
        }
    }

    protected void setParameterNullable(CodegenParameter parameter, CodegenProperty property) {
        parameter.nullable = property.nullable;
    }

    public boolean needsUnflattenedSpec() {
        return false;
    }

    public void setUnflattenedOpenAPI(OpenAPI unflattenedOpenAPI) {
        this.unflattenedOpenAPI = unflattenedOpenAPI;
    }

    public boolean getIgnoreImportMapping() {
        return this.ignoreImportMapping;
    }

    public void setIgnoreImportMapping(boolean ignoreImportMapping) {
        this.ignoreImportMapping = ignoreImportMapping;
    }

    public boolean defaultIgnoreImportMappingOption() {
        return false;
    }

    public ISchemaHandler getSchemaHandler() {
        return new SchemaHandler(this);
    }

    public OpenAPI getOpenAPI() {
        return this.openAPI;
    }
}

