/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.r;

import io.swagger.codegen.v3.CliOption;
import io.swagger.codegen.v3.CodegenProperty;
import io.swagger.codegen.v3.CodegenType;
import io.swagger.codegen.v3.SupportingFile;
import io.swagger.codegen.v3.generators.DefaultCodegenConfig;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RClientCodegen
extends DefaultCodegenConfig {
    static Logger LOGGER = LoggerFactory.getLogger(RClientCodegen.class);
    protected String packageName = "swagger";
    protected String packageVersion = "1.0.0";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";

    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    public String getName() {
        return "r";
    }

    public String getHelp() {
        return "Generates a R client library (beta).";
    }

    public RClientCodegen() {
        this.outputFolder = "generated-code/r";
        this.modelTemplateFiles.put("model.mustache", ".r");
        this.apiTemplateFiles.put("api.mustache", ".r");
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.hideGenerationTimestamp = Boolean.TRUE;
        this.setReservedWordsLowerCase(Arrays.asList("if", "else", "repeat", "while", "function", "for", "in", "next", "break", "TRUE", "FALSE", "NULL", "Inf", "NaN", "NA", "NA_integer_", "NA_real_", "NA_complex_", "NA_character_"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("map", "array"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("Integer", "Numeric", "Character"));
        this.instantiationTypes.clear();
        this.typeMapping.clear();
        this.typeMapping.put("integer", "Integer");
        this.typeMapping.put("long", "Integer");
        this.typeMapping.put("number", "Numeric");
        this.typeMapping.put("float", "Numeric");
        this.typeMapping.put("double", "Numeric");
        this.typeMapping.put("boolean", "Character");
        this.typeMapping.put("string", "Character");
        this.typeMapping.put("UUID", "Character");
        this.typeMapping.put("date", "Character");
        this.typeMapping.put("DateTime", "Character");
        this.typeMapping.put("password", "Character");
        this.typeMapping.put("file", "TODO_FILE_MAPPING");
        this.typeMapping.put("binary", "Character");
        this.typeMapping.put("ByteArray", "Character");
        this.typeMapping.put("object", "TODO_OBJECT_MAPPING");
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("packageName", "R package name (convention: lowercase).").defaultValue("swagger"));
        this.cliOptions.add(new CliOption("packageVersion", "R package version.").defaultValue("1.0.0"));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.").defaultValue(Boolean.TRUE.toString()));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        } else {
            this.setPackageName("swagger");
        }
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        } else {
            this.setPackageVersion("1.0.0");
        }
        this.additionalProperties.put("packageName", this.packageName);
        this.additionalProperties.put("packageVersion", this.packageVersion);
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.apiTestTemplateFiles.clear();
        this.modelTestTemplateFiles.clear();
        this.apiDocTemplateFiles.clear();
        this.modelDocTemplateFiles.clear();
        this.modelPackage = this.packageName;
        this.apiPackage = this.packageName;
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("description.mustache", "", "DESCRIPTION"));
        this.supportingFiles.add(new SupportingFile("Rbuildignore.mustache", "", ".Rbuildignore"));
        this.supportingFiles.add(new SupportingFile(".travis.yml", "", ".travis.yml"));
        this.supportingFiles.add(new SupportingFile("response.mustache", "/R", "Response.r"));
        this.supportingFiles.add(new SupportingFile("element.mustache", "/R", "Element.r"));
        this.supportingFiles.add(new SupportingFile("api_client.mustache", "/R", "ApiClient.r"));
        this.supportingFiles.add(new SupportingFile("NAMESPACE.mustache", "", "NAMESPACE"));
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return RClientCodegen.camelize(name) + '_';
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + "R" + File.separator;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + "R" + File.separator;
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeName(name.replaceAll("-", "_"))).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = RClientCodegen.underscore(name))) {
            name = this.escapeReservedWord(name);
        }
        if (name.matches("^\\d.*")) {
            name = "Var" + name;
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        return this.toModelFilename(name);
    }

    @Override
    public String toModelFilename(String name) {
        if (!StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(name = this.sanitizeName(name))) {
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + RClientCodegen.camelize("model_" + name));
            name = "model_" + name;
        }
        if (name.matches("^\\d.*")) {
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + RClientCodegen.camelize("model_" + name));
            name = "model_" + name;
        }
        return RClientCodegen.camelize(name);
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return RClientCodegen.camelize(name + "_api");
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String toApiName(String name) {
        return RClientCodegen.camelize(super.toApiName(name));
    }

    @Override
    public String getTypeDeclaration(Schema schema) {
        MapSchema mp;
        Object innerObject;
        if (schema instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)schema;
            Schema inner = arraySchema.getItems();
            return this.getTypeDeclaration(inner);
        }
        if (schema instanceof MapSchema && (innerObject = (mp = (MapSchema)schema).getAdditionalProperties()) instanceof Schema) {
            return this.getTypeDeclaration((Schema)innerObject);
        }
        String schemaType = this.getSchemaType(schema);
        if (this.typeMapping.containsKey(schemaType)) {
            return (String)this.typeMapping.get(schemaType);
        }
        if (this.typeMapping.containsValue(schemaType)) {
            return schemaType;
        }
        if (this.languageSpecificPrimitives.contains(schemaType)) {
            return schemaType;
        }
        return this.toModelName(schemaType);
    }

    @Override
    public String getSchemaType(Schema schema) {
        String swaggerType = super.getSchemaType(schema);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = swaggerType;
        }
        return type;
    }

    @Override
    public String toOperationId(String operationId) {
        String sanitizedOperationId = this.sanitizeName(operationId);
        if (this.isReservedWord(sanitizedOperationId)) {
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + RClientCodegen.underscore("call_" + operationId));
            sanitizedOperationId = "call_" + sanitizedOperationId;
        }
        return RClientCodegen.underscore(sanitizedOperationId);
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        List imports = (List)objs.get("imports");
        String prefix = this.modelPackage();
        Iterator iterator = imports.iterator();
        while (iterator.hasNext()) {
            String _import = (String)((Map)iterator.next()).get("import");
            if (!_import.startsWith(prefix)) continue;
            iterator.remove();
        }
        List recursiveImports = (List)objs.get("imports");
        if (recursiveImports == null) {
            return objs;
        }
        ListIterator<Map<String, String>> listIterator = imports.listIterator();
        while (listIterator.hasNext()) {
            String _import = (String)((Map)listIterator.next()).get("import");
            if (!this.importMapping.containsKey(_import)) continue;
            listIterator.add(this.createMapping("import", (String)this.importMapping.get(_import)));
        }
        return this.postProcessModelsEnum(objs);
    }

    @Override
    protected boolean needToImport(String type) {
        return !this.defaultIncludes.contains(type) && !this.languageSpecificPrimitives.contains(type);
    }

    @Override
    public String getDefaultTemplateDir() {
        return "R";
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("]]", "] ]");
    }

    public Map<String, String> createMapping(String key, String value) {
        HashMap<String, String> customImport = new HashMap<String, String>();
        customImport.put(key, value);
        return customImport;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("int".equals(datatype) || "double".equals(datatype) || "float".equals(datatype)) {
            return value;
        }
        return this.escapeText(value);
    }

    @Override
    public String toEnumDefaultValue(String value, String datatype) {
        return datatype + "_" + value;
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if (name.length() == 0) {
            return "EMPTY";
        }
        if ("int".equals(datatype) || "double".equals(datatype) || "float".equals(datatype)) {
            String varName = name;
            varName = varName.replaceAll("-", "MINUS_");
            varName = varName.replaceAll("\\+", "PLUS_");
            varName = varName.replaceAll("\\.", "_DOT_");
            return varName;
        }
        if (this.getSymbolName(name) != null) {
            return this.getSymbolName(name).toUpperCase();
        }
        String enumName = this.sanitizeName(RClientCodegen.underscore(name).toUpperCase());
        enumName = enumName.replaceFirst("^_", "");
        if (this.isReservedWord(enumName = enumName.replaceFirst("_$", "")) || enumName.matches("\\d.*")) {
            return this.escapeReservedWord(enumName);
        }
        return enumName;
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        String enumName = RClientCodegen.underscore(this.toModelName(property.name)).toUpperCase();
        if ((enumName = enumName.replace("[]", "")).matches("\\d.*")) {
            return "_" + enumName;
        }
        return enumName;
    }
}

