/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.go;

import io.swagger.codegen.v3.CodegenType;
import io.swagger.codegen.v3.SupportingFile;
import io.swagger.codegen.v3.generators.go.AbstractGoCodegen;
import java.io.File;
import java.util.Arrays;

public class GoServerCodegen
extends AbstractGoCodegen {
    protected String apiVersion = "1.0.0";
    protected int serverPort = 8080;
    protected String projectName = "swagger-server";
    protected String apiPath = "go";

    public GoServerCodegen() {
        this.outputFolder = "generated-code/go";
        this.modelTemplateFiles.put("model.mustache", ".go");
        this.apiTemplateFiles.put("controller-api.mustache", ".go");
        this.setReservedWordsLowerCase(Arrays.asList("string", "bool", "uint", "uint8", "uint16", "uint32", "uint64", "int", "int8", "int16", "int32", "int64", "float32", "float64", "complex64", "complex128", "rune", "byte", "uintptr", "break", "default", "func", "interface", "select", "case", "defer", "go", "map", "struct", "chan", "else", "goto", "package", "switch", "const", "fallthrough", "if", "range", "type", "continue", "for", "import", "return", "var", "error", "nil"));
    }

    @Override
    public String getDefaultTemplateDir() {
        return "go-server";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        } else {
            this.setPackageName("swagger");
        }
        this.additionalProperties.put("apiVersion", this.apiVersion);
        this.additionalProperties.put("serverPort", this.serverPort);
        this.additionalProperties.put("apiPath", this.apiPath);
        this.additionalProperties.put("packageName", this.packageName);
        this.modelPackage = this.packageName;
        this.apiPackage = this.packageName;
        this.supportingFiles.add(new SupportingFile("swagger.mustache", "api", "swagger.yaml"));
        this.supportingFiles.add(new SupportingFile("main.mustache", "", "main.go"));
        this.supportingFiles.add(new SupportingFile("routers.mustache", this.apiPath, "routers.go"));
        this.supportingFiles.add(new SupportingFile("logger.mustache", this.apiPath, "logger.go"));
        this.writeOptional(this.outputFolder, new SupportingFile("README.mustache", this.apiPath, "README.md"));
    }

    @Override
    public String apiPackage() {
        return this.apiPath;
    }

    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    public String getName() {
        return "go-server";
    }

    public String getHelp() {
        return "Generates a Go server library using the swagger-tools project.  By default, it will also generate service classes--which you can disable with the `-Dnoservice` environment variable.";
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }
}

