/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.scala;

import com.samskivert.mustache.Escapers;
import com.samskivert.mustache.Mustache;
import io.swagger.codegen.v3.CliOption;
import io.swagger.codegen.v3.CodegenConfig;
import io.swagger.codegen.v3.generators.DefaultCodegenConfig;
import io.swagger.codegen.v3.templates.MustacheTemplateEngine;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractScalaCodegen
extends DefaultCodegenConfig {
    protected String modelPropertyNaming = "camelCase";
    protected String sourceFolder = "src/main/scala";

    public AbstractScalaCodegen() {
        this.languageSpecificPrimitives.addAll(Arrays.asList("String", "boolean", "Boolean", "Double", "Int", "Long", "Float", "Object", "Any", "List", "Seq", "Map", "Array"));
        this.reservedWords.addAll(Arrays.asList("abstract", "case", "catch", "class", "def", "do", "else", "extends", "false", "final", "finally", "for", "forSome", "if", "implicit", "import", "lazy", "match", "new", "null", "object", "override", "package", "private", "protected", "return", "sealed", "super", "this", "throw", "trait", "try", "true", "type", "val", "var", "while", "with", "yield"));
        this.typeMapping.put("int", "Int");
        this.typeMapping.put("integer", "Int");
        this.cliOptions.add(new CliOption("modelPackage", "package for generated models"));
        this.cliOptions.add(new CliOption("apiPackage", "package for generated api classes"));
        this.cliOptions.add(new CliOption("sourceFolder", "source folder for generated code"));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("sourceFolder")) {
            this.setSourceFolder((String)this.additionalProperties.get("sourceFolder"));
        }
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    public String getSourceFolder() {
        return this.sourceFolder;
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "`" + name + "`";
    }

    @Override
    public Mustache.Compiler processCompiler(Mustache.Compiler compiler) {
        Mustache.Escaper SCALA = new Mustache.Escaper(){

            public String escape(String text) {
                if (text.startsWith("`") && text.endsWith("`")) {
                    String unescaped = text.substring(1, text.length() - 1);
                    return "`" + Escapers.HTML.escape(unescaped) + "`";
                }
                return Escapers.HTML.escape(text);
            }
        };
        return compiler.withEscaper(SCALA);
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String getTypeDeclaration(Schema propertySchema) {
        if (propertySchema instanceof ArraySchema) {
            Schema inner = ((ArraySchema)propertySchema).getItems();
            return String.format("%s[%s]", this.getSchemaType(propertySchema), this.getTypeDeclaration(inner));
        }
        if (propertySchema instanceof MapSchema && AbstractScalaCodegen.hasSchemaProperties(propertySchema)) {
            Schema inner = (Schema)propertySchema.getAdditionalProperties();
            return String.format("%s[String, %s]", this.getSchemaType(propertySchema), this.getTypeDeclaration(inner));
        }
        return super.getTypeDeclaration(propertySchema);
    }

    @Override
    public String getSchemaType(Schema propertySchema) {
        String swaggerType = super.getSchemaType(propertySchema);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = swaggerType;
        }
        return type;
    }

    @Override
    public String toInstantiationType(Schema schemaProperty) {
        if (schemaProperty instanceof MapSchema && AbstractScalaCodegen.hasSchemaProperties(schemaProperty)) {
            String inner = this.getSchemaType((Schema)schemaProperty.getAdditionalProperties());
            return String.format("%s[%s]", this.instantiationTypes.get("map"), inner);
        }
        if (schemaProperty instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)schemaProperty;
            String inner = this.getSchemaType(arraySchema.getItems());
            return String.format("%s[%s]", this.instantiationTypes.get("array"), inner);
        }
        return null;
    }

    @Override
    public String toDefaultValue(Schema propertySchema) {
        if (propertySchema instanceof MapSchema && AbstractScalaCodegen.hasSchemaProperties(propertySchema)) {
            String inner = this.getSchemaType((Schema)propertySchema.getAdditionalProperties());
            return String.format("new HashMap[String, %s]()", inner);
        }
        if (propertySchema instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)propertySchema;
            String inner = this.getSchemaType(arraySchema.getItems());
            return String.format("new ListBuffer[%s]()", inner);
        }
        return "null";
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        List imports = (List)objs.get("imports");
        String prefix = this.modelPackage() + ".";
        Iterator iterator = imports.iterator();
        while (iterator.hasNext()) {
            String _import = (String)((Map)iterator.next()).get("import");
            if (!_import.startsWith(prefix)) continue;
            iterator.remove();
        }
        return objs;
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    protected String formatIdentifier(String name, boolean capitalized) {
        String identifier = AbstractScalaCodegen.camelize(this.sanitizeName(name), true);
        if (capitalized) {
            identifier = StringUtils.capitalize((String)identifier);
        }
        if (identifier.matches("[a-zA-Z_$][\\w_$]+") && !this.isReservedWord(identifier)) {
            return identifier;
        }
        return this.escapeReservedWord(identifier);
    }

    protected String stripPackageName(String input) {
        if (StringUtils.isEmpty((CharSequence)input) || input.lastIndexOf(".") < 0) {
            return input;
        }
        int lastIndexOfDot = input.lastIndexOf(".");
        return input.substring(lastIndexOfDot + 1);
    }

    @Override
    protected void setTemplateEngine() {
        this.templateEngine = new MustacheTemplateEngine((CodegenConfig)this);
    }
}

