/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.builder.internal.utils;

import io.sundr.SundrException;
import io.sundr.builder.Constants;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.ExternalBuildables;
import io.sundr.builder.annotations.Inline;
import io.sundr.builder.internal.BuilderContext;
import io.sundr.builder.internal.BuilderContextManager;
import io.sundr.builder.internal.functions.PropertyAs;
import io.sundr.codegen.functions.ClassToJavaType;
import io.sundr.codegen.model.AttributeSupport;
import io.sundr.codegen.model.JavaClazz;
import io.sundr.codegen.model.JavaMethod;
import io.sundr.codegen.model.JavaProperty;
import io.sundr.codegen.model.JavaType;
import io.sundr.codegen.utils.StringUtils;
import io.sundr.codegen.utils.TypeUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuilderUtils {
    public static final String BUILDABLE = "BUILDABLE";
    private static final String[] GENERIC_NAMES = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S"};
    private static int counter = 0;

    private BuilderUtils() {
    }

    public static JavaMethod findBuildableConstructor(JavaClazz clazz) {
        for (JavaMethod candidate : clazz.getConstructors()) {
            if (!candidate.getAnnotations().contains(Constants.BUILDABLE_ANNOTATION)) continue;
            return candidate;
        }
        for (JavaMethod candidate : clazz.getConstructors()) {
            if (candidate.getArguments().length == 0) continue;
            return candidate;
        }
        return (JavaMethod)clazz.getConstructors().iterator().next();
    }

    public static JavaMethod findGetter(JavaClazz clazz, JavaProperty property) {
        for (JavaMethod method : clazz.getMethods()) {
            if (!BuilderUtils.isApplicableGetterOf(method, property)) continue;
            return method;
        }
        throw new SundrException("No getter found for property: " + property.getName() + " on class: " + clazz.getType().getFullyQualifiedName());
    }

    public static boolean hasSetter(JavaClazz clazz, JavaProperty property) {
        for (JavaMethod method : clazz.getMethods()) {
            if (!BuilderUtils.isApplicableSetterOf(method, property)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasOrInheritsSetter(JavaClazz clazz, JavaProperty property) {
        JavaClazz target = clazz;
        while (target != null && !Constants.OBJECT.equals((Object)target) && BuilderUtils.isBuildable((AttributeSupport)target)) {
            for (JavaMethod method : target.getMethods()) {
                if (!BuilderUtils.isApplicableSetterOf(method, property)) continue;
                return true;
            }
            String superFQN = target.getType().getSuperClass().getFullyQualifiedName();
            target = StringUtils.isNullOrEmpty((String)superFQN) ? null : (JavaClazz)BuilderContextManager.getContext().getStringToJavaClazz().apply((Object)superFQN);
        }
        return false;
    }

    private static boolean isApplicableGetterOf(JavaMethod method, JavaProperty property) {
        if (!method.getReturnType().isAssignable(property.getType())) {
            return false;
        }
        if (method.getName().endsWith("get" + property.getNameCapitalized())) {
            return true;
        }
        return method.getName().endsWith("is" + property.getNameCapitalized());
    }

    private static boolean isApplicableSetterOf(JavaMethod method, JavaProperty property) {
        if (method.getArguments().length != 1) {
            return false;
        }
        if (!method.getArguments()[0].getType().equals((Object)property.getType())) {
            return false;
        }
        return method.getName().endsWith("set" + property.getNameCapitalized());
    }

    public static boolean methodHasArgument(JavaMethod method, JavaProperty property) {
        for (JavaProperty candidate : method.getArguments()) {
            if (!candidate.equals((Object)property)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasBuildableConstructorWithArgument(JavaClazz clazz, JavaProperty property) {
        JavaMethod constructor = BuilderUtils.findBuildableConstructor(clazz);
        if (constructor == null) {
            return false;
        }
        return BuilderUtils.methodHasArgument(constructor, property);
    }

    public static boolean hasDefaultConstructor(JavaClazz item) {
        if (item == null) {
            return false;
        }
        if (item.getConstructors().isEmpty()) {
            return true;
        }
        for (JavaMethod constructor : item.getConstructors()) {
            if (constructor.getArguments().length != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isBuildable(AttributeSupport item) {
        if (item == null) {
            return false;
        }
        if (item.getAttributes().containsKey(BUILDABLE)) {
            return (Boolean)item.getAttributes().get(BUILDABLE);
        }
        return false;
    }

    public static Set<JavaMethod> getInlineableConstructors(JavaProperty property) {
        HashSet<JavaMethod> result = new HashSet<JavaMethod>();
        JavaClazz clazz = (JavaClazz)PropertyAs.CLASS.apply((Object)property);
        for (JavaMethod candidate : clazz.getConstructors()) {
            if (!BuilderUtils.isInlineable(candidate)) continue;
            result.add(candidate);
        }
        return result;
    }

    public static boolean isInlineable(JavaMethod method) {
        if (method.getArguments().length == 0 || method.getArguments().length > 5) {
            return false;
        }
        for (JavaProperty argument : method.getArguments()) {
            if (StringUtils.isNullOrEmpty((String)argument.getType().getPackageName()) || argument.getType().getPackageName().startsWith("java.lang")) continue;
            return false;
        }
        return true;
    }

    public static JavaType getInlineType(BuilderContext context, Inline inline) {
        try {
            return ClassToJavaType.FUNCTION.apply(inline.type());
        }
        catch (MirroredTypeException e) {
            return (JavaType)context.getStringJavaTypeFunction().apply((Object)e.getTypeMirror().toString());
        }
    }

    public static JavaType getInlineReturnType(BuilderContext context, Inline inline) {
        try {
            return ClassToJavaType.FUNCTION.apply(inline.returnType());
        }
        catch (MirroredTypeException e) {
            return (JavaType)context.getStringJavaTypeFunction().apply((Object)e.getTypeMirror().toString());
        }
    }

    public static Set<TypeElement> getBuildableReferences(BuilderContext context, Buildable buildable) {
        LinkedHashSet<TypeElement> result = new LinkedHashSet<TypeElement>();
        for (BuildableReference ref : buildable.refs()) {
            try {
                result.add(context.getElements().getTypeElement(ref.value().getCanonicalName()));
            }
            catch (MirroredTypeException e) {
                result.add(context.getElements().getTypeElement(e.getTypeMirror().toString()));
            }
        }
        return result;
    }

    public static Set<TypeElement> getBuildableReferences(BuilderContext context, ExternalBuildables buildable) {
        LinkedHashSet<TypeElement> result = new LinkedHashSet<TypeElement>();
        for (BuildableReference ref : buildable.refs()) {
            try {
                result.add(context.getElements().getTypeElement(ref.value().getCanonicalName()));
            }
            catch (MirroredTypeException e) {
                result.add(context.getElements().getTypeElement(e.getTypeMirror().toString()));
            }
        }
        return result;
    }

    public static boolean isPrimitive(JavaType type) {
        for (JavaType t : Constants.PRIMITIVE_TYPES) {
            if (!type.getSimpleName().equals(t.getSimpleName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isMap(JavaType type) {
        if (TypeUtils.unwrapGeneric((JavaType)type).equals((Object)TypeUtils.unwrapGeneric((JavaType)Constants.MAP))) {
            return true;
        }
        for (JavaType i : type.getInterfaces()) {
            if (type.getFullyQualifiedName().equals(i.getFullyQualifiedName()) || !BuilderUtils.isMap(i)) continue;
            return true;
        }
        return false;
    }

    public static boolean isList(JavaType type) {
        if (TypeUtils.unwrapGeneric((JavaType)type).equals((Object)TypeUtils.unwrapGeneric((JavaType)Constants.LIST))) {
            return true;
        }
        for (JavaType i : type.getInterfaces()) {
            if (type.getFullyQualifiedName().equals(i.getFullyQualifiedName()) || !BuilderUtils.isList(i)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSet(JavaType type) {
        if (TypeUtils.unwrapGeneric((JavaType)type).equals((Object)TypeUtils.unwrapGeneric((JavaType)Constants.SET))) {
            return true;
        }
        for (JavaType i : type.getInterfaces()) {
            if (type.getFullyQualifiedName().equals(i.getFullyQualifiedName()) || !BuilderUtils.isSet(i)) continue;
            return true;
        }
        return false;
    }

    public static JavaType getNextGeneric(JavaType type, Collection<JavaType> excluded) {
        HashSet<String> skip = new HashSet<String>();
        for (JavaType s : BuilderUtils.allGenericsOf(type)) {
            skip.add(s.getClassName());
        }
        for (JavaType s : excluded) {
            skip.add(s.getClassName());
        }
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < GENERIC_NAMES.length; ++j) {
                String name = GENERIC_NAMES[j] + (i > 0 ? String.valueOf(i) : "");
                if (skip.contains(name)) continue;
                return TypeUtils.newGeneric((String)name);
            }
        }
        throw new IllegalStateException("Could not allocate generic parameter letter for: " + type.getFullyQualifiedName());
    }

    public static JavaType getNextGeneric(JavaType type, JavaType ... excluded) {
        return BuilderUtils.getNextGeneric(type, Arrays.asList(excluded));
    }

    public static Set<JavaType> allGenericsOf(JavaClazz clazz) {
        HashSet<JavaType> result = new HashSet<JavaType>(BuilderUtils.allGenericsOf(clazz.getType()));
        for (JavaProperty property : clazz.getFields()) {
            result.addAll(BuilderUtils.allGenericsOf(property));
        }
        for (JavaMethod method : clazz.getMethods()) {
            result.addAll(BuilderUtils.allGenericsOf(method));
        }
        return result;
    }

    public static Set<JavaType> allGenericsOf(JavaType type) {
        return new HashSet<JavaType>(Arrays.asList(type.getGenericTypes()));
    }

    public static Collection<JavaType> allGenericsOf(JavaProperty property) {
        return BuilderUtils.allGenericsOf(property.getType());
    }

    public static Collection<JavaType> allGenericsOf(JavaMethod method) {
        HashSet<JavaType> result = new HashSet<JavaType>(BuilderUtils.allGenericsOf(method.getReturnType()));
        for (JavaProperty property : method.getArguments()) {
            result.addAll(BuilderUtils.allGenericsOf(property));
        }
        return result;
    }
}

