/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.builder.internal.processor;

import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import io.sundr.builder.internal.BuilderContext;
import io.sundr.builder.internal.BuilderContextManager;
import io.sundr.builder.internal.functions.ClazzAs;
import io.sundr.builder.internal.processor.AbstractBuilderProcessor;
import io.sundr.builder.internal.utils.BuilderUtils;
import io.sundr.codegen.model.JavaClazz;
import io.sundr.codegen.utils.ModelUtils;
import java.io.IOException;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedAnnotationTypes(value={"io.sundr.builder.annotations.Buildable"})
public class BuildableProcessor
extends AbstractBuilderProcessor {
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        Elements elements = this.processingEnv.getElementUtils();
        for (TypeElement typeElement : annotations) {
            for (Element element : env.getElementsAnnotatedWith(typeElement)) {
                Buildable buildable = element.getAnnotation(Buildable.class);
                BuilderContext ctx = BuilderContextManager.create(elements, buildable.generateBuilderPackage(), buildable.builderPackage(), new Inline[0]);
                ctx.getRepository().register(ModelUtils.getClassElement((Element)element));
                for (TypeElement ref : BuilderUtils.getBuildableReferences(ctx, buildable)) {
                    ctx.getRepository().register(ModelUtils.getClassElement((Element)ref));
                }
            }
        }
        for (TypeElement typeElement : annotations) {
            for (Element element : env.getElementsAnnotatedWith(typeElement)) {
                boolean isAbstract = element.getModifiers().contains((Object)Modifier.ABSTRACT);
                Buildable buildable = element.getAnnotation(Buildable.class);
                BuilderContext ctx = BuilderContextManager.create(elements, buildable.generateBuilderPackage(), buildable.builderPackage(), new Inline[0]);
                JavaClazz clazz = (JavaClazz)ctx.getTypeElementToJavaClazz().apply((Object)ModelUtils.getClassElement((Element)element));
                this.generateLocalDependenciesIfNeeded();
                try {
                    this.generateFromClazz((JavaClazz)ClazzAs.FLUENT_INTERFACE.apply(clazz), "templates/builder/fluentinterface.vm");
                    this.generateFromClazz((JavaClazz)ClazzAs.FLUENT_IMPL.apply(clazz), "templates/builder/fluentimpl.vm");
                    if (!isAbstract) {
                        if (buildable.editableEnabled()) {
                            this.generateFromClazz((JavaClazz)ClazzAs.EDITABLE_BUILDER.apply(clazz), this.selectBuilderTemplate(buildable.validationEnabled()));
                            this.generateFromClazz((JavaClazz)ClazzAs.EDITABLE.apply(clazz), "templates/builder/editable.vm");
                        } else {
                            this.generateFromClazz((JavaClazz)ClazzAs.BUILDER.apply(clazz), this.selectBuilderTemplate(buildable.validationEnabled()));
                        }
                    }
                    for (Inline inline : buildable.inline()) {
                        this.generateFromClazz(this.inlineableOf(ctx, clazz, inline), "templates/builder/class.vm");
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return true;
    }
}

