/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.builder.internal.functions;

import io.sundr.Function;
import io.sundr.builder.Constants;
import io.sundr.builder.internal.functions.Decendants;
import io.sundr.builder.internal.functions.PropertyAs;
import io.sundr.builder.internal.functions.TypeAs;
import io.sundr.builder.internal.utils.BuilderUtils;
import io.sundr.codegen.model.AttributeSupport;
import io.sundr.codegen.model.EditableJavaProperty;
import io.sundr.codegen.model.EditableJavaType;
import io.sundr.codegen.model.JavaMethod;
import io.sundr.codegen.model.JavaMethodBuilder;
import io.sundr.codegen.model.JavaMethodFluent;
import io.sundr.codegen.model.JavaProperty;
import io.sundr.codegen.model.JavaPropertyBuilder;
import io.sundr.codegen.model.JavaType;
import io.sundr.codegen.model.JavaTypeBuilder;
import io.sundr.codegen.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.Modifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ToMethod implements Function<JavaProperty, JavaMethod>
{
    WITH{

        public JavaMethod apply(JavaProperty property) {
            String methodName = "with" + property.getNameCapitalized();
            return ((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().addToModifiers(new Modifier[]{Modifier.PUBLIC})).withName(methodName)).withReturnType(Constants.T)).withArguments(new JavaProperty[]{property})).addToAttributes("BODY", (Object)this.getBody(property))).build();
        }

        private String getBody(JavaProperty property) {
            String name = property.getName();
            JavaType type = property.getType();
            String className = type.getClassName();
            StringBuilder sb = new StringBuilder();
            if (type.isCollection()) {
                sb.append("this." + name + ".clear();");
                if (className.contains("Map")) {
                    sb.append("if (" + name + " != null) {this." + name + ".putAll(" + name + ");} return (T) this;");
                } else if (className.contains("List") || className.contains("Set")) {
                    JavaType unwraped = (JavaType)TypeAs.UNWRAP_COLLECTION_OF.apply(property.getType());
                    String addToMethodName = "addTo" + property.getNameCapitalized();
                    sb.append("if (" + name + " != null) {for (" + unwraped.getSimpleName() + " item : " + name + "){this." + addToMethodName + "(item);}} return (T) this;");
                }
                return sb.toString();
            }
            if (BuilderUtils.isBuildable((AttributeSupport)property)) {
                JavaType builder = (JavaType)TypeAs.combine(TypeAs.UNWRAP_COLLECTION_OF, TypeAs.BUILDER).apply((Object)property.getType());
                String propertyName = property.getName();
                String builderClass = builder.getSimpleName();
                return "if (" + propertyName + "!=null){ this." + propertyName + "= new " + builderClass + "(" + propertyName + "); _visitables.add(this." + propertyName + ");} return (T) this;";
            }
            return "this." + property.getName() + "=" + property.getName() + "; return (T) this;";
        }
    }
    ,
    WITH_ARRAY{

        public JavaMethod apply(JavaProperty property) {
            String methodName = "with" + property.getNameCapitalized();
            JavaType unwraped = (JavaType)TypeAs.combine(TypeAs.UNWRAP_COLLECTION_OF, TypeAs.UNWRAP_ARRAY_OF).apply((Object)property.getType());
            String addToMethodName = "addTo" + property.getNameCapitalized();
            EditableJavaProperty arrayProperty = ((JavaPropertyBuilder)((JavaPropertyBuilder)new JavaPropertyBuilder(property).withType((JavaType)((JavaTypeBuilder)new JavaTypeBuilder(unwraped).withArray(true)).build())).withArray(true)).build();
            return ((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().addToModifiers(new Modifier[]{Modifier.PUBLIC})).withName(methodName)).withReturnType(Constants.T)).withArguments(new JavaProperty[]{arrayProperty})).addToAttributes("BODY", (Object)("this." + property.getName() + ".clear(); if (" + property.getName() + " != null) {for (" + unwraped.getSimpleName() + " item :" + property.getName() + "){ this." + addToMethodName + "(item);}} return (T) this;"))).build();
        }
    }
    ,
    GETTER{

        public JavaMethod apply(final JavaProperty property) {
            String body;
            String prefix = property.getType().isBoolean() ? "is" : "get";
            String methodName = prefix + property.getNameCapitalized();
            TreeSet<JavaProperty> descendants = new TreeSet<JavaProperty>(new Comparator<JavaProperty>(){

                @Override
                public int compare(JavaProperty left, JavaProperty right) {
                    return left.getName().compareTo(right.getName());
                }
            });
            descendants.addAll((Collection)Decendants.PROPERTY_BUILDABLE_ANCESTORS.apply((Object)property));
            if (BuilderUtils.isMap(property.getType())) {
                body = "return this." + property.getName() + ";";
            } else if (BuilderUtils.isBuildable((AttributeSupport)property)) {
                body = BuilderUtils.isList(property.getType()) || BuilderUtils.isSet(property.getType()) ? "return build(" + property.getName() + ");" : "return this." + property.getName() + "!=null?this." + property.getName() + ".build():null;";
            } else if (!descendants.isEmpty()) {
                if (BuilderUtils.isList(property.getType()) || BuilderUtils.isSet(property.getType())) {
                    String names = StringUtils.join(descendants, (Function)new Function<JavaProperty, String>(){
                        String className;
                        {
                            this.className = ((JavaType)TypeAs.UNWRAP_COLLECTION_OF.apply(property.getType())).getClassName();
                        }

                        public String apply(JavaProperty item) {
                            return "this.<" + this.className + ">build(" + item.getName() + ")";
                        }
                    }, (String)", ");
                    body = "return aggregate(" + names + ");";
                } else {
                    body = "return this." + property.getName() + ";";
                }
            } else {
                body = "return this." + property.getName() + ";";
            }
            return ((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().addToModifiers(new Modifier[]{Modifier.PUBLIC})).withName(methodName)).withReturnType(property.getType())).withArguments(new JavaProperty[0])).addToAttributes("BODY", (Object)body)).build();
        }
    }
    ,
    GETTER_ARRAY{

        public JavaMethod apply(JavaProperty property) {
            String prefix = property.getType().isBoolean() ? "is" : "get";
            String methodName = prefix + property.getNameCapitalized();
            JavaType type = property.getType();
            Boolean isBuildable = BuilderUtils.isBuildable((AttributeSupport)type);
            JavaType targetType = isBuildable != false ? (JavaType)TypeAs.VISITABLE_BUILDER.apply(type) : (JavaType)TypeAs.UNWRAP_ARRAY_OF.apply(type);
            String body = String.format(isBuildable != false ? BUILDABLE_ARRAY_GETTER_TEXT : SIMPLE_ARRAY_GETTER_TEXT, type.getClassName(), targetType.getSimpleName(), property.getName(), type.getClassName(), property.getName());
            return ((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().addToModifiers(new Modifier[]{Modifier.PUBLIC})).withName(methodName)).withReturnType(property.getType())).withArguments(new JavaProperty[0])).addToAttributes("BODY", (Object)body)).build();
        }
    }
    ,
    SETTER{

        public JavaMethod apply(JavaProperty property) {
            String methodName = "set" + property.getNameCapitalized();
            return ((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().addToModifiers(new Modifier[]{Modifier.PUBLIC})).withName(methodName)).withReturnType(Constants.VOID)).withArguments(new JavaProperty[]{property})).addToAttributes("BODY", (Object)("this." + property.getName() + "=" + property.getName() + ";"))).build();
        }
    }
    ,
    ADD_TO_COLLECTION{

        public JavaMethod apply(JavaProperty property) {
            String body;
            EditableJavaProperty item = ((JavaPropertyBuilder)((JavaPropertyBuilder)((JavaPropertyBuilder)new JavaPropertyBuilder(property).withName("items")).withArray(true)).withType((JavaType)TypeAs.combine(TypeAs.UNWRAP_COLLECTION_OF, TypeAs.REMOVE_GENERICS).apply((Object)property.getType()))).build();
            String methodName = "addTo" + property.getNameCapitalized();
            Set descendants = (Set)Decendants.PROPERTY_BUILDABLE_ANCESTORS.apply((Object)property);
            if (BuilderUtils.isBuildable((AttributeSupport)property)) {
                JavaType builder = (JavaType)TypeAs.combine(TypeAs.UNWRAP_COLLECTION_OF, TypeAs.BUILDER).apply((Object)property.getType());
                String builderClass = builder.getClassName();
                body = "for (" + item.getType().getClassName() + " item : items) {" + builderClass + " builder = new " + builderClass + "(item);_visitables.add(builder);this." + property.getName() + ".add(builder);} return (T)this;";
            } else if (!descendants.isEmpty()) {
                body = "for (" + item.getType().getSimpleName() + " item : items) {" + StringUtils.join((Iterable)descendants, (Function)new Function<JavaProperty, String>(){

                    public String apply(JavaProperty item) {
                        JavaType t = (JavaType)TypeAs.UNWRAP_COLLECTION_OF.apply(item.getType());
                        String addToMethodName = "addTo" + StringUtils.captializeFirst((String)item.getName());
                        return "if (item instanceof " + t.getClassName() + "){" + addToMethodName + "((" + t.getClassName() + ")item);}\n";
                    }
                }, (String)" else ");
                body = body + "} return (T)this;";
            } else {
                body = "for (" + item.getType().getSimpleName() + " item : items) {this." + property.getName() + ".add(item);} return (T)this;";
            }
            return ((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().addToModifiers(new Modifier[]{Modifier.PUBLIC})).withName(methodName)).withReturnType(Constants.T)).withArguments(new JavaProperty[]{item})).addToAttributes("BODY", (Object)body)).build();
        }
    }
    ,
    REMOVE_FROM_COLLECTION{

        public JavaMethod apply(JavaProperty property) {
            String body;
            EditableJavaProperty item = ((JavaPropertyBuilder)((JavaPropertyBuilder)((JavaPropertyBuilder)new JavaPropertyBuilder(property).withName("items")).withArray(true)).withType((JavaType)TypeAs.combine(TypeAs.UNWRAP_COLLECTION_OF, TypeAs.REMOVE_GENERICS).apply((Object)property.getType()))).build();
            String methodName = "removeFrom" + property.getNameCapitalized();
            Set descendants = (Set)Decendants.PROPERTY_BUILDABLE_ANCESTORS.apply((Object)property);
            if (BuilderUtils.isBuildable((AttributeSupport)property)) {
                JavaType builder = (JavaType)TypeAs.combine(TypeAs.UNWRAP_COLLECTION_OF, TypeAs.BUILDER).apply((Object)property.getType());
                String builderClass = builder.getClassName();
                body = "for (" + item.getType().getClassName() + " item : items) {" + builderClass + " builder = new " + builderClass + "(item);_visitables.remove(builder);this." + property.getName() + ".remove(builder);} return (T)this;";
            } else if (!descendants.isEmpty()) {
                body = "for (" + item.getType().getSimpleName() + " item : items) {" + StringUtils.join((Iterable)descendants, (Function)new Function<JavaProperty, String>(){

                    public String apply(JavaProperty item) {
                        JavaType t = (JavaType)TypeAs.UNWRAP_COLLECTION_OF.apply(item.getType());
                        String removeFromMethodName = "removeFrom" + StringUtils.captializeFirst((String)item.getName());
                        return "if (item instanceof " + t.getClassName() + "){" + removeFromMethodName + "((" + t.getClassName() + ")item);}\n";
                    }
                }, (String)" else ");
                body = body + "} return (T)this;";
            } else {
                body = "for (" + item.getType().getClassName() + " item : items) {this." + property.getName() + ".remove(item);} return (T)this;";
            }
            return ((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().addToModifiers(new Modifier[]{Modifier.PUBLIC})).withName(methodName)).withReturnType(Constants.T)).withArguments(new JavaProperty[]{item})).addToAttributes("BODY", (Object)body)).build();
        }
    }
    ,
    ADD_MAP_TO_MAP{

        public JavaMethod apply(JavaProperty property) {
            JavaType mapType = property.getType();
            EditableJavaProperty mapProperty = ((JavaPropertyBuilder)((JavaPropertyBuilder)new JavaPropertyBuilder().withName("map")).withType(mapType)).build();
            String methodName = "addTo" + property.getNameCapitalized();
            return ((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().addToModifiers(new Modifier[]{Modifier.PUBLIC})).withName(methodName)).withReturnType(Constants.T)).withArguments(new JavaProperty[]{mapProperty})).addToAttributes("BODY", (Object)("if(map != null) { this." + property.getName() + ".putAll(map);} return (T)this;"))).build();
        }
    }
    ,
    ADD_TO_MAP{

        public JavaMethod apply(JavaProperty property) {
            JavaType mapType = property.getType();
            JavaType keyType = mapType.getGenericTypes()[0];
            JavaType valueType = mapType.getGenericTypes()[1];
            EditableJavaProperty keyProperty = ((JavaPropertyBuilder)((JavaPropertyBuilder)new JavaPropertyBuilder().withName("key")).withType(keyType)).build();
            EditableJavaProperty valueProperty = ((JavaPropertyBuilder)((JavaPropertyBuilder)new JavaPropertyBuilder().withName("value")).withType(valueType)).build();
            String methodName = "addTo" + property.getNameCapitalized();
            return ((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().addToModifiers(new Modifier[]{Modifier.PUBLIC})).withName(methodName)).withReturnType(Constants.T)).withArguments(new JavaProperty[]{keyProperty, valueProperty})).addToAttributes("BODY", (Object)("if(key != null && value != null) {this." + property.getName() + ".put(key, value);} return (T)this;"))).build();
        }
    }
    ,
    REMOVE_MAP_FROM_MAP{

        public JavaMethod apply(JavaProperty property) {
            JavaType mapType = property.getType();
            EditableJavaProperty mapProperty = ((JavaPropertyBuilder)((JavaPropertyBuilder)new JavaPropertyBuilder().withName("map")).withType(mapType)).build();
            String methodName = "removeFrom" + property.getNameCapitalized();
            return ((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().addToModifiers(new Modifier[]{Modifier.PUBLIC})).withName(methodName)).withReturnType(Constants.T)).withArguments(new JavaProperty[]{mapProperty})).addToAttributes("BODY", (Object)("if(map != null) { for(Object key : map.keySet()) {this." + property.getName() + ".remove(key);}} return (T)this;"))).build();
        }
    }
    ,
    REMOVE_FROM_MAP{

        public JavaMethod apply(JavaProperty property) {
            JavaType mapType = property.getType();
            JavaType keyType = mapType.getGenericTypes()[0];
            EditableJavaProperty keyProperty = ((JavaPropertyBuilder)((JavaPropertyBuilder)new JavaPropertyBuilder().withName("key")).withType(keyType)).build();
            String methodName = "removeFrom" + property.getNameCapitalized();
            return ((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().addToModifiers(new Modifier[]{Modifier.PUBLIC})).withName(methodName)).withReturnType(Constants.T)).withArguments(new JavaProperty[]{keyProperty})).addToAttributes("BODY", (Object)("if(key != null) {this." + property.getName() + ".remove(key);} return (T)this;"))).build();
        }
    }
    ,
    WITH_NEW_NESTED{

        public JavaMethod apply(JavaProperty property) {
            JavaType baseType = (JavaType)TypeAs.UNWRAP_COLLECTION_OF.apply(property.getType());
            JavaType nestedType = (JavaType)PropertyAs.NESTED_INTERFACE_TYPE.apply((Object)property);
            JavaType nestedTypeImpl = (JavaType)PropertyAs.NESTED_TYPE.apply((Object)property);
            ArrayList<Object> generics = new ArrayList<Object>();
            LinkedHashSet<JavaType> typeParameters = new LinkedHashSet<JavaType>();
            for (JavaType generic : baseType.getGenericTypes()) {
                generics.add(TypeAs.REMOVE_SUPERCLASS.apply(generic));
                typeParameters.add(generic);
            }
            generics.add(Constants.T);
            EditableJavaType rewraped = ((JavaTypeBuilder)new JavaTypeBuilder(nestedType).withGenericTypes(generics.toArray(new JavaType[generics.size()]))).build();
            EditableJavaType rewrapedImpl = ((JavaTypeBuilder)new JavaTypeBuilder(nestedTypeImpl).withGenericTypes(generics.toArray(new JavaType[generics.size()]))).build();
            String prefix = property.getType().isCollection() ? "addNew" : "withNew";
            String methodName = prefix + StringUtils.captializeFirst((String)(property.getType().isCollection() ? StringUtils.singularize((String)property.getName()) : property.getName()));
            return ((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().addToModifiers(new Modifier[]{Modifier.PUBLIC})).withTypeParameters(typeParameters)).withReturnType((JavaType)rewraped)).withName(methodName)).addToAttributes("BODY", (Object)("return new " + rewrapedImpl.getClassName() + "();"))).build();
        }
    }
    ,
    WITH_NEW_LIKE_NESTED{

        public JavaMethod apply(JavaProperty property) {
            JavaType baseType = (JavaType)TypeAs.UNWRAP_COLLECTION_OF.apply(property.getType());
            JavaType nestedType = (JavaType)PropertyAs.NESTED_INTERFACE_TYPE.apply((Object)property);
            JavaType nestedTypeImpl = (JavaType)PropertyAs.NESTED_TYPE.apply((Object)property);
            ArrayList<JavaType> generics = new ArrayList<JavaType>();
            for (JavaType ignore : baseType.getGenericTypes()) {
                generics.add(Constants.Q);
            }
            generics.add(Constants.T);
            EditableJavaType rewraped = ((JavaTypeBuilder)new JavaTypeBuilder(nestedType).withGenericTypes(generics.toArray(new JavaType[generics.size()]))).build();
            EditableJavaType rewrapedImpl = ((JavaTypeBuilder)new JavaTypeBuilder(nestedTypeImpl).withGenericTypes(generics.toArray(new JavaType[generics.size()]))).build();
            String prefix = property.getType().isCollection() ? "addNew" : "withNew";
            String suffix = "Like";
            String methodName = prefix + StringUtils.captializeFirst((String)(property.getType().isCollection() ? StringUtils.singularize((String)property.getName()) : property.getName())) + suffix;
            return ((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodFluent.ArgumentsNested)((JavaMethodFluent.ArgumentsNested)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().addToModifiers(new Modifier[]{Modifier.PUBLIC})).withReturnType((JavaType)rewraped)).withName(methodName)).addNewArgument().withName("item")).withType((JavaType)TypeAs.REMOVE_GENERICS.apply(baseType))).endArgument()).addToAttributes("BODY", (Object)("return new " + rewrapedImpl.getClassName() + "(item);"))).build();
        }
    }
    ,
    EDIT_NESTED{

        public JavaMethod apply(JavaProperty property) {
            JavaType nestedType = (JavaType)PropertyAs.NESTED_INTERFACE_TYPE.apply((Object)property);
            EditableJavaType rewraped = ((JavaTypeBuilder)new JavaTypeBuilder(nestedType).withGenericTypes(new JavaType[]{Constants.T})).build();
            String prefix = "edit";
            String methodNameBase = StringUtils.captializeFirst((String)property.getName());
            String methodName = prefix + methodNameBase;
            return ((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().addToModifiers(new Modifier[]{Modifier.PUBLIC})).withReturnType((JavaType)rewraped)).withName(methodName)).addToAttributes("BODY", (Object)("return withNew" + methodNameBase + "Like(get" + methodNameBase + "());"))).build();
        }
    }
    ,
    AND{

        public JavaMethod apply(JavaProperty property) {
            String classPrefix = this.getClassPrefix(property);
            String prefix = property.getType().isCollection() ? "addTo" : "with";
            String withMethodName = prefix + StringUtils.captializeFirst((String)property.getName());
            return ((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().addToModifiers(new Modifier[]{Modifier.PUBLIC})).withReturnType(Constants.N)).withName("and")).addToAttributes("BODY", (Object)("return (N) " + classPrefix + withMethodName + "(builder.build());"))).build();
        }

        private String getClassPrefix(JavaProperty property) {
            Object memberOf = property.getAttributes().get("MEMBER_OF");
            if (memberOf instanceof JavaType) {
                return ((JavaType)memberOf).getClassName() + ".this.";
            }
            return "";
        }
    }
    ,
    END{

        public JavaMethod apply(JavaProperty property) {
            String methodName = "end" + StringUtils.captializeFirst((String)(property.getType().isCollection() ? StringUtils.singularize((String)property.getName()) : property.getName()));
            return ((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().addToModifiers(new Modifier[]{Modifier.PUBLIC})).withReturnType(Constants.N)).withName(methodName)).addToAttributes("BODY", (Object)"return and();")).build();
        }
    };

    private static final String BUILDABLE_ARRAY_GETTER_TEXT;
    private static final String SIMPLE_ARRAY_GETTER_TEXT;

    static {
        BUILDABLE_ARRAY_GETTER_TEXT = StringUtils.loadResourceQuietly((String)"snippets/buildable-array-getter.txt");
        SIMPLE_ARRAY_GETTER_TEXT = StringUtils.loadResourceQuietly((String)"snippets/simple-array-getter.txt");
    }
}

