/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.util;

import java.math.BigDecimal;
import java.math.BigInteger;

public class DecimalUtil {
    private static final byte zero = 0;
    private static final byte minus_one = -1;
    private static final long[] POWER_OF_10 = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L};

    public static BigDecimal getBigDecimalFromBytes(byte[] value, int scale, int byteWidth) {
        byte[] reversed = new byte[value.length];
        for (int i = 0; i < byteWidth; ++i) {
            reversed[byteWidth - 1 - i] = value[i];
        }
        BigInteger unscaledValue = new BigInteger(reversed);
        return new BigDecimal(unscaledValue, scale);
    }

    public static byte[] encodeDecimalIntoBytes(BigDecimal decimal, int scale, int byteWidth) {
        BigDecimal scaledDecimal = decimal.multiply(DecimalUtil.powerOfTen(scale));
        byte[] bytes = scaledDecimal.toBigInteger().toByteArray();
        if (bytes.length > byteWidth) {
            throw new UnsupportedOperationException("Decimal size greater than " + byteWidth + " bytes: " + bytes.length);
        }
        byte[] encodedBytes = new byte[byteWidth];
        int padByte = bytes[0] < 0 ? -1 : 0;
        byte[] bytesLE = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            bytesLE[i] = bytes[bytes.length - 1 - i];
        }
        int destIndex = 0;
        for (int i = 0; i < bytes.length; ++i) {
            encodedBytes[destIndex++] = bytesLE[i];
        }
        for (int j = bytes.length; j < byteWidth; ++j) {
            encodedBytes[destIndex++] = padByte;
        }
        return encodedBytes;
    }

    private static BigDecimal powerOfTen(int scale) {
        if (scale < POWER_OF_10.length) {
            return new BigDecimal(POWER_OF_10[scale]);
        }
        int length = POWER_OF_10.length;
        BigDecimal bd = new BigDecimal(POWER_OF_10[length - 1]);
        for (int i = length - 1; i < scale; ++i) {
            bd = bd.multiply(new BigDecimal(10));
        }
        return bd;
    }
}

