/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.type;

import io.substrait.expression.FunctionArg;
import io.substrait.extension.SimpleExtension;
import io.substrait.function.NullableType;
import io.substrait.function.ParameterizedType;
import io.substrait.function.TypeExpression;
import io.substrait.type.ImmutableType;
import io.substrait.type.TypeCreator;
import io.substrait.type.TypeVisitor;
import io.substrait.util.VisitationContext;
import java.util.Collections;
import java.util.List;
import org.immutables.value.Value;

@Value.Enclosing
public interface Type
extends TypeExpression,
ParameterizedType,
NullableType,
FunctionArg {
    public static TypeCreator withNullability(boolean nullable) {
        return nullable ? TypeCreator.NULLABLE : TypeCreator.REQUIRED;
    }

    @Override
    public <R, E extends Throwable> R accept(TypeVisitor<R, E> var1) throws E;

    @Override
    default public <R, C extends VisitationContext, E extends Throwable> R accept(SimpleExtension.Function fnDef, int argIdx, FunctionArg.FuncArgVisitor<R, C, E> fnArgVisitor, C context) throws E {
        return fnArgVisitor.visitType(fnDef, argIdx, this, context);
    }

    default public boolean equalsIgnoringNullability(Type other) {
        return TypeCreator.asNullable(this).equals(TypeCreator.asNullable(other));
    }

    public static class ParameterNull
    implements Parameter {
        public static final ParameterNull INSTANCE = new ParameterNull();

        private ParameterNull() {
        }
    }

    @Value.Immutable
    public static abstract class ParameterStringValue
    implements Parameter {
        public abstract String value();
    }

    @Value.Immutable
    public static abstract class ParameterEnumValue
    implements Parameter {
        public abstract String value();
    }

    @Value.Immutable
    public static abstract class ParameterIntegerValue
    implements Parameter {
        public abstract long value();
    }

    @Value.Immutable
    public static abstract class ParameterBooleanValue
    implements Parameter {
        public abstract boolean value();
    }

    @Value.Immutable
    public static abstract class ParameterDataType
    implements Parameter {
        public abstract Type type();
    }

    public static interface Parameter {
    }

    @Value.Immutable
    public static abstract class UserDefined
    implements Type {
        public abstract String urn();

        public abstract String name();

        @Value.Default
        public List<Parameter> typeParameters() {
            return Collections.emptyList();
        }

        public static ImmutableType.UserDefined.Builder builder() {
            return ImmutableType.UserDefined.builder();
        }

        @Override
        public <R, E extends Throwable> R accept(TypeVisitor<R, E> typeVisitor) throws E {
            return typeVisitor.visit(this);
        }
    }

    @Value.Immutable
    public static abstract class Map
    implements Type {
        public abstract Type key();

        public abstract Type value();

        public static ImmutableType.Map.Builder builder() {
            return ImmutableType.Map.builder();
        }

        @Override
        public <R, E extends Throwable> R accept(TypeVisitor<R, E> typeVisitor) throws E {
            return typeVisitor.visit(this);
        }
    }

    @Value.Immutable
    public static abstract class ListType
    implements Type {
        public abstract Type elementType();

        public static ImmutableType.ListType.Builder builder() {
            return ImmutableType.ListType.builder();
        }

        @Override
        public <R, E extends Throwable> R accept(TypeVisitor<R, E> typeVisitor) throws E {
            return typeVisitor.visit(this);
        }
    }

    @Value.Immutable
    public static abstract class Struct
    implements Type {
        public abstract List<Type> fields();

        public static ImmutableType.Struct.Builder builder() {
            return ImmutableType.Struct.builder();
        }

        @Override
        public <R, E extends Throwable> R accept(TypeVisitor<R, E> typeVisitor) throws E {
            return typeVisitor.visit(this);
        }
    }

    @Value.Immutable
    public static abstract class PrecisionTimestampTZ
    implements Type {
        public abstract int precision();

        public static ImmutableType.PrecisionTimestampTZ.Builder builder() {
            return ImmutableType.PrecisionTimestampTZ.builder();
        }

        @Override
        public <R, E extends Throwable> R accept(TypeVisitor<R, E> typeVisitor) throws E {
            return typeVisitor.visit(this);
        }
    }

    @Value.Immutable
    public static abstract class PrecisionTimestamp
    implements Type {
        public abstract int precision();

        public static ImmutableType.PrecisionTimestamp.Builder builder() {
            return ImmutableType.PrecisionTimestamp.builder();
        }

        @Override
        public <R, E extends Throwable> R accept(TypeVisitor<R, E> typeVisitor) throws E {
            return typeVisitor.visit(this);
        }
    }

    @Value.Immutable
    public static abstract class PrecisionTime
    implements Type {
        public abstract int precision();

        public static ImmutableType.PrecisionTime.Builder builder() {
            return ImmutableType.PrecisionTime.builder();
        }

        @Override
        public <R, E extends Throwable> R accept(TypeVisitor<R, E> typeVisitor) throws E {
            return typeVisitor.visit(this);
        }
    }

    @Value.Immutable
    public static abstract class Decimal
    implements Type {
        public abstract int scale();

        public abstract int precision();

        public static ImmutableType.Decimal.Builder builder() {
            return ImmutableType.Decimal.builder();
        }

        @Override
        public <R, E extends Throwable> R accept(TypeVisitor<R, E> typeVisitor) throws E {
            return typeVisitor.visit(this);
        }
    }

    @Value.Immutable
    public static abstract class FixedBinary
    implements Type {
        public abstract int length();

        public static ImmutableType.FixedBinary.Builder builder() {
            return ImmutableType.FixedBinary.builder();
        }

        @Override
        public <R, E extends Throwable> R accept(TypeVisitor<R, E> typeVisitor) throws E {
            return typeVisitor.visit(this);
        }
    }

    @Value.Immutable
    public static abstract class VarChar
    implements Type {
        public abstract int length();

        public static ImmutableType.VarChar.Builder builder() {
            return ImmutableType.VarChar.builder();
        }

        @Override
        public <R, E extends Throwable> R accept(TypeVisitor<R, E> typeVisitor) throws E {
            return typeVisitor.visit(this);
        }
    }

    @Value.Immutable
    public static abstract class FixedChar
    implements Type {
        public abstract int length();

        public static ImmutableType.FixedChar.Builder builder() {
            return ImmutableType.FixedChar.builder();
        }

        @Override
        public <R, E extends Throwable> R accept(TypeVisitor<R, E> typeVisitor) throws E {
            return typeVisitor.visit(this);
        }
    }

    @Value.Immutable
    public static abstract class UUID
    implements Type {
        public static ImmutableType.UUID.Builder builder() {
            return ImmutableType.UUID.builder();
        }

        @Override
        public <R, E extends Throwable> R accept(TypeVisitor<R, E> typeVisitor) throws E {
            return typeVisitor.visit(this);
        }
    }

    @Value.Immutable
    public static abstract class IntervalCompound
    implements Type {
        public abstract int precision();

        public static ImmutableType.IntervalCompound.Builder builder() {
            return ImmutableType.IntervalCompound.builder();
        }

        @Override
        public <R, E extends Throwable> R accept(TypeVisitor<R, E> typeVisitor) throws E {
            return typeVisitor.visit(this);
        }
    }

    @Value.Immutable
    public static abstract class IntervalDay
    implements Type {
        public abstract int precision();

        public static ImmutableType.IntervalDay.Builder builder() {
            return ImmutableType.IntervalDay.builder();
        }

        @Override
        public <R, E extends Throwable> R accept(TypeVisitor<R, E> typeVisitor) throws E {
            return typeVisitor.visit(this);
        }
    }

    @Value.Immutable
    public static abstract class IntervalYear
    implements Type {
        public static ImmutableType.IntervalYear.Builder builder() {
            return ImmutableType.IntervalYear.builder();
        }

        @Override
        public <R, E extends Throwable> R accept(TypeVisitor<R, E> typeVisitor) throws E {
            return typeVisitor.visit(this);
        }
    }

    @Deprecated
    @Value.Immutable
    public static abstract class Timestamp
    implements Type {
        @Deprecated
        public static ImmutableType.Timestamp.Builder builder() {
            return ImmutableType.Timestamp.builder();
        }

        @Override
        public <R, E extends Throwable> R accept(TypeVisitor<R, E> typeVisitor) throws E {
            return typeVisitor.visit(this);
        }
    }

    @Deprecated
    @Value.Immutable
    public static abstract class TimestampTZ
    implements Type {
        public static ImmutableType.TimestampTZ.Builder builder() {
            return ImmutableType.TimestampTZ.builder();
        }

        @Override
        public <R, E extends Throwable> R accept(TypeVisitor<R, E> typeVisitor) throws E {
            return typeVisitor.visit(this);
        }
    }

    @Value.Immutable
    public static abstract class Time
    implements Type {
        public static ImmutableType.Time.Builder builder() {
            return ImmutableType.Time.builder();
        }

        @Override
        public <R, E extends Throwable> R accept(TypeVisitor<R, E> typeVisitor) throws E {
            return typeVisitor.visit(this);
        }
    }

    @Value.Immutable
    public static abstract class Date
    implements Type {
        public static ImmutableType.Date.Builder builder() {
            return ImmutableType.Date.builder();
        }

        @Override
        public <R, E extends Throwable> R accept(TypeVisitor<R, E> typeVisitor) throws E {
            return typeVisitor.visit(this);
        }
    }

    @Value.Immutable
    public static abstract class Binary
    implements Type {
        public static ImmutableType.Binary.Builder builder() {
            return ImmutableType.Binary.builder();
        }

        @Override
        public <R, E extends Throwable> R accept(TypeVisitor<R, E> typeVisitor) throws E {
            return typeVisitor.visit(this);
        }
    }

    @Value.Immutable
    public static abstract class Str
    implements Type {
        public static ImmutableType.Str.Builder builder() {
            return ImmutableType.Str.builder();
        }

        @Override
        public <R, E extends Throwable> R accept(TypeVisitor<R, E> typeVisitor) throws E {
            return typeVisitor.visit(this);
        }
    }

    @Value.Immutable
    public static abstract class FP64
    implements Type {
        public static ImmutableType.FP64.Builder builder() {
            return ImmutableType.FP64.builder();
        }

        @Override
        public <R, E extends Throwable> R accept(TypeVisitor<R, E> typeVisitor) throws E {
            return typeVisitor.visit(this);
        }
    }

    @Value.Immutable
    public static abstract class FP32
    implements Type {
        public static ImmutableType.FP32.Builder builder() {
            return ImmutableType.FP32.builder();
        }

        @Override
        public <R, E extends Throwable> R accept(TypeVisitor<R, E> typeVisitor) throws E {
            return typeVisitor.visit(this);
        }
    }

    @Value.Immutable
    public static abstract class I64
    implements Type {
        public static ImmutableType.I64.Builder builder() {
            return ImmutableType.I64.builder();
        }

        @Override
        public <R, E extends Throwable> R accept(TypeVisitor<R, E> typeVisitor) throws E {
            return typeVisitor.visit(this);
        }
    }

    @Value.Immutable
    public static abstract class I32
    implements Type {
        public static ImmutableType.I32.Builder builder() {
            return ImmutableType.I32.builder();
        }

        @Override
        public <R, E extends Throwable> R accept(TypeVisitor<R, E> typeVisitor) throws E {
            return typeVisitor.visit(this);
        }
    }

    @Value.Immutable
    public static abstract class I16
    implements Type {
        public static ImmutableType.I16.Builder builder() {
            return ImmutableType.I16.builder();
        }

        @Override
        public <R, E extends Throwable> R accept(TypeVisitor<R, E> typeVisitor) throws E {
            return typeVisitor.visit(this);
        }
    }

    @Value.Immutable
    public static abstract class I8
    implements Type {
        public static ImmutableType.I8.Builder builder() {
            return ImmutableType.I8.builder();
        }

        @Override
        public <R, E extends Throwable> R accept(TypeVisitor<R, E> typeVisitor) throws E {
            return typeVisitor.visit(this);
        }
    }

    @Value.Immutable
    public static abstract class Bool
    implements Type {
        public static ImmutableType.Bool.Builder builder() {
            return ImmutableType.Bool.builder();
        }

        @Override
        public <R, E extends Throwable> R accept(TypeVisitor<R, E> typeVisitor) throws E {
            return typeVisitor.visit(this);
        }
    }
}

