/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation.physical;

import io.substrait.expression.Expression;
import io.substrait.extension.AdvancedExtension;
import io.substrait.hint.Hint;
import io.substrait.relation.AbstractRel;
import io.substrait.relation.HasExtension;
import io.substrait.relation.Rel;
import io.substrait.relation.SingleInputRel;
import io.substrait.relation.physical.AbstractExchangeRel;
import io.substrait.relation.physical.MultiBucketExchange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ImmutableMultiBucketExchange
extends MultiBucketExchange {
    private final AdvancedExtension extension;
    private final Rel.Remap remap;
    private final AdvancedExtension commonExtension;
    private final Hint hint;
    private final Rel input;
    private final Integer partitionCount;
    private final List<AbstractExchangeRel.ExchangeTarget> targets;
    private final Expression expression;
    private final boolean constrainedToCount;

    private ImmutableMultiBucketExchange(AdvancedExtension extension, Rel.Remap remap, AdvancedExtension commonExtension, Hint hint, Rel input, Integer partitionCount, List<AbstractExchangeRel.ExchangeTarget> targets, Expression expression, boolean constrainedToCount) {
        this.extension = extension;
        this.remap = remap;
        this.commonExtension = commonExtension;
        this.hint = hint;
        this.input = input;
        this.partitionCount = partitionCount;
        this.targets = targets;
        this.expression = expression;
        this.constrainedToCount = constrainedToCount;
    }

    @Override
    public Optional<AdvancedExtension> getExtension() {
        return Optional.ofNullable(this.extension);
    }

    @Override
    public Optional<Rel.Remap> getRemap() {
        return Optional.ofNullable(this.remap);
    }

    @Override
    public Optional<AdvancedExtension> getCommonExtension() {
        return Optional.ofNullable(this.commonExtension);
    }

    @Override
    public Optional<Hint> getHint() {
        return Optional.ofNullable(this.hint);
    }

    @Override
    public Rel getInput() {
        return this.input;
    }

    @Override
    public Integer getPartitionCount() {
        return this.partitionCount;
    }

    @Override
    public List<AbstractExchangeRel.ExchangeTarget> getTargets() {
        return this.targets;
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public boolean getConstrainedToCount() {
        return this.constrainedToCount;
    }

    public final ImmutableMultiBucketExchange withExtension(AdvancedExtension value) {
        AdvancedExtension newValue = Objects.requireNonNull(value, "extension");
        if (this.extension == newValue) {
            return this;
        }
        return new ImmutableMultiBucketExchange(newValue, this.remap, this.commonExtension, this.hint, this.input, this.partitionCount, this.targets, this.expression, this.constrainedToCount);
    }

    public final ImmutableMultiBucketExchange withExtension(Optional<? extends AdvancedExtension> optional) {
        AdvancedExtension value = optional.orElse(null);
        if (this.extension == value) {
            return this;
        }
        return new ImmutableMultiBucketExchange(value, this.remap, this.commonExtension, this.hint, this.input, this.partitionCount, this.targets, this.expression, this.constrainedToCount);
    }

    public final ImmutableMultiBucketExchange withRemap(Rel.Remap value) {
        Rel.Remap newValue = Objects.requireNonNull(value, "remap");
        if (this.remap == newValue) {
            return this;
        }
        return new ImmutableMultiBucketExchange(this.extension, newValue, this.commonExtension, this.hint, this.input, this.partitionCount, this.targets, this.expression, this.constrainedToCount);
    }

    public final ImmutableMultiBucketExchange withRemap(Optional<? extends Rel.Remap> optional) {
        Rel.Remap value = optional.orElse(null);
        if (this.remap == value) {
            return this;
        }
        return new ImmutableMultiBucketExchange(this.extension, value, this.commonExtension, this.hint, this.input, this.partitionCount, this.targets, this.expression, this.constrainedToCount);
    }

    public final ImmutableMultiBucketExchange withCommonExtension(AdvancedExtension value) {
        AdvancedExtension newValue = Objects.requireNonNull(value, "commonExtension");
        if (this.commonExtension == newValue) {
            return this;
        }
        return new ImmutableMultiBucketExchange(this.extension, this.remap, newValue, this.hint, this.input, this.partitionCount, this.targets, this.expression, this.constrainedToCount);
    }

    public final ImmutableMultiBucketExchange withCommonExtension(Optional<? extends AdvancedExtension> optional) {
        AdvancedExtension value = optional.orElse(null);
        if (this.commonExtension == value) {
            return this;
        }
        return new ImmutableMultiBucketExchange(this.extension, this.remap, value, this.hint, this.input, this.partitionCount, this.targets, this.expression, this.constrainedToCount);
    }

    public final ImmutableMultiBucketExchange withHint(Hint value) {
        Hint newValue = Objects.requireNonNull(value, "hint");
        if (this.hint == newValue) {
            return this;
        }
        return new ImmutableMultiBucketExchange(this.extension, this.remap, this.commonExtension, newValue, this.input, this.partitionCount, this.targets, this.expression, this.constrainedToCount);
    }

    public final ImmutableMultiBucketExchange withHint(Optional<? extends Hint> optional) {
        Hint value = optional.orElse(null);
        if (this.hint == value) {
            return this;
        }
        return new ImmutableMultiBucketExchange(this.extension, this.remap, this.commonExtension, value, this.input, this.partitionCount, this.targets, this.expression, this.constrainedToCount);
    }

    public final ImmutableMultiBucketExchange withInput(Rel value) {
        if (this.input == value) {
            return this;
        }
        Rel newValue = Objects.requireNonNull(value, "input");
        return new ImmutableMultiBucketExchange(this.extension, this.remap, this.commonExtension, this.hint, newValue, this.partitionCount, this.targets, this.expression, this.constrainedToCount);
    }

    public final ImmutableMultiBucketExchange withPartitionCount(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "partitionCount");
        if (this.partitionCount.equals(newValue)) {
            return this;
        }
        return new ImmutableMultiBucketExchange(this.extension, this.remap, this.commonExtension, this.hint, this.input, newValue, this.targets, this.expression, this.constrainedToCount);
    }

    public final ImmutableMultiBucketExchange withTargets(AbstractExchangeRel.ExchangeTarget ... elements) {
        List<AbstractExchangeRel.ExchangeTarget> newValue = ImmutableMultiBucketExchange.createUnmodifiableList(false, ImmutableMultiBucketExchange.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMultiBucketExchange(this.extension, this.remap, this.commonExtension, this.hint, this.input, this.partitionCount, newValue, this.expression, this.constrainedToCount);
    }

    public final ImmutableMultiBucketExchange withTargets(Iterable<? extends AbstractExchangeRel.ExchangeTarget> elements) {
        if (this.targets == elements) {
            return this;
        }
        List<AbstractExchangeRel.ExchangeTarget> newValue = ImmutableMultiBucketExchange.createUnmodifiableList(false, ImmutableMultiBucketExchange.createSafeList(elements, true, false));
        return new ImmutableMultiBucketExchange(this.extension, this.remap, this.commonExtension, this.hint, this.input, this.partitionCount, newValue, this.expression, this.constrainedToCount);
    }

    public final ImmutableMultiBucketExchange withExpression(Expression value) {
        if (this.expression == value) {
            return this;
        }
        Expression newValue = Objects.requireNonNull(value, "expression");
        return new ImmutableMultiBucketExchange(this.extension, this.remap, this.commonExtension, this.hint, this.input, this.partitionCount, this.targets, newValue, this.constrainedToCount);
    }

    public final ImmutableMultiBucketExchange withConstrainedToCount(boolean value) {
        if (this.constrainedToCount == value) {
            return this;
        }
        return new ImmutableMultiBucketExchange(this.extension, this.remap, this.commonExtension, this.hint, this.input, this.partitionCount, this.targets, this.expression, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMultiBucketExchange && this.equalsByValue((ImmutableMultiBucketExchange)another);
    }

    private boolean equalsByValue(ImmutableMultiBucketExchange another) {
        return Objects.equals(this.extension, another.extension) && Objects.equals(this.remap, another.remap) && Objects.equals(this.commonExtension, another.commonExtension) && Objects.equals(this.hint, another.hint) && this.input.equals(another.input) && this.partitionCount.equals(another.partitionCount) && this.targets.equals(another.targets) && this.expression.equals(another.expression) && this.constrainedToCount == another.constrainedToCount;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.extension);
        h += (h << 5) + Objects.hashCode(this.remap);
        h += (h << 5) + Objects.hashCode(this.commonExtension);
        h += (h << 5) + Objects.hashCode(this.hint);
        h += (h << 5) + this.input.hashCode();
        h += (h << 5) + this.partitionCount.hashCode();
        h += (h << 5) + this.targets.hashCode();
        h += (h << 5) + this.expression.hashCode();
        h += (h << 5) + Boolean.hashCode(this.constrainedToCount);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("MultiBucketExchange{");
        if (this.extension != null) {
            builder.append("extension=").append(this.extension);
        }
        if (this.remap != null) {
            if (builder.length() > 20) {
                builder.append(", ");
            }
            builder.append("remap=").append(this.remap);
        }
        if (this.commonExtension != null) {
            if (builder.length() > 20) {
                builder.append(", ");
            }
            builder.append("commonExtension=").append(this.commonExtension);
        }
        if (this.hint != null) {
            if (builder.length() > 20) {
                builder.append(", ");
            }
            builder.append("hint=").append(this.hint);
        }
        if (builder.length() > 20) {
            builder.append(", ");
        }
        builder.append("input=").append(this.input);
        builder.append(", ");
        builder.append("partitionCount=").append(this.partitionCount);
        builder.append(", ");
        builder.append("targets=").append(this.targets);
        builder.append(", ");
        builder.append("expression=").append(this.expression);
        builder.append(", ");
        builder.append("constrainedToCount=").append(this.constrainedToCount);
        return builder.append("}").toString();
    }

    public static ImmutableMultiBucketExchange copyOf(MultiBucketExchange instance) {
        if (instance instanceof ImmutableMultiBucketExchange) {
            return (ImmutableMultiBucketExchange)instance;
        }
        return ImmutableMultiBucketExchange.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_INPUT = 1L;
        private static final long INIT_BIT_PARTITION_COUNT = 2L;
        private static final long INIT_BIT_EXPRESSION = 4L;
        private static final long INIT_BIT_CONSTRAINED_TO_COUNT = 8L;
        private long initBits = 15L;
        private AdvancedExtension extension;
        private Rel.Remap remap;
        private AdvancedExtension commonExtension;
        private Hint hint;
        private Rel input;
        private Integer partitionCount;
        private List<AbstractExchangeRel.ExchangeTarget> targets = new ArrayList<AbstractExchangeRel.ExchangeTarget>();
        private Expression expression;
        private boolean constrainedToCount;

        private Builder() {
        }

        public final Builder from(AbstractExchangeRel instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(HasExtension instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(MultiBucketExchange instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(Rel instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(AbstractRel instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(SingleInputRel instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            Optional<Rel.Remap> remapOptional;
            Optional<AdvancedExtension> commonExtensionOptional;
            Optional<Hint> hintOptional;
            Optional<AdvancedExtension> extensionOptional;
            Object instance;
            long bits = 0L;
            if (object instanceof AbstractExchangeRel) {
                instance = (AbstractExchangeRel)object;
                if ((bits & 8L) == 0L) {
                    this.input(((SingleInputRel)instance).getInput());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.partitionCount(((AbstractExchangeRel)instance).getPartitionCount());
                    bits |= 0x10L;
                }
                if ((bits & 1L) == 0L) {
                    extensionOptional = instance.getExtension();
                    if (extensionOptional.isPresent()) {
                        this.extension(extensionOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 0x20L) == 0L) {
                    hintOptional = instance.getHint();
                    if (hintOptional.isPresent()) {
                        this.hint(hintOptional);
                    }
                    bits |= 0x20L;
                }
                if ((bits & 2L) == 0L) {
                    commonExtensionOptional = instance.getCommonExtension();
                    if (commonExtensionOptional.isPresent()) {
                        this.commonExtension(commonExtensionOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.addAllTargets(((AbstractExchangeRel)instance).getTargets());
                    bits |= 4L;
                }
                if ((bits & 0x40L) == 0L) {
                    remapOptional = instance.getRemap();
                    if (remapOptional.isPresent()) {
                        this.remap(remapOptional);
                    }
                    bits |= 0x40L;
                }
            }
            if (object instanceof HasExtension) {
                instance = (HasExtension)object;
                if ((bits & 1L) == 0L) {
                    extensionOptional = instance.getExtension();
                    if (extensionOptional.isPresent()) {
                        this.extension(extensionOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof MultiBucketExchange) {
                instance = (MultiBucketExchange)object;
                if ((bits & 8L) == 0L) {
                    this.input(((SingleInputRel)instance).getInput());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.partitionCount(((AbstractExchangeRel)instance).getPartitionCount());
                    bits |= 0x10L;
                }
                if ((bits & 1L) == 0L) {
                    extensionOptional = instance.getExtension();
                    if (extensionOptional.isPresent()) {
                        this.extension(extensionOptional);
                    }
                    bits |= 1L;
                }
                this.expression(((MultiBucketExchange)instance).getExpression());
                if ((bits & 0x20L) == 0L) {
                    hintOptional = instance.getHint();
                    if (hintOptional.isPresent()) {
                        this.hint(hintOptional);
                    }
                    bits |= 0x20L;
                }
                this.constrainedToCount(((MultiBucketExchange)instance).getConstrainedToCount());
                if ((bits & 2L) == 0L) {
                    commonExtensionOptional = instance.getCommonExtension();
                    if (commonExtensionOptional.isPresent()) {
                        this.commonExtension(commonExtensionOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.addAllTargets(((AbstractExchangeRel)instance).getTargets());
                    bits |= 4L;
                }
                if ((bits & 0x40L) == 0L) {
                    remapOptional = instance.getRemap();
                    if (remapOptional.isPresent()) {
                        this.remap(remapOptional);
                    }
                    bits |= 0x40L;
                }
            }
            if (object instanceof Rel) {
                instance = (Rel)object;
                if ((bits & 2L) == 0L) {
                    commonExtensionOptional = instance.getCommonExtension();
                    if (commonExtensionOptional.isPresent()) {
                        this.commonExtension(commonExtensionOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 0x20L) == 0L) {
                    hintOptional = instance.getHint();
                    if (hintOptional.isPresent()) {
                        this.hint(hintOptional);
                    }
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    remapOptional = instance.getRemap();
                    if (remapOptional.isPresent()) {
                        this.remap(remapOptional);
                    }
                    bits |= 0x40L;
                }
            }
            if (object instanceof AbstractRel) {
                instance = (AbstractRel)object;
                if ((bits & 2L) == 0L) {
                    commonExtensionOptional = instance.getCommonExtension();
                    if (commonExtensionOptional.isPresent()) {
                        this.commonExtension(commonExtensionOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 0x20L) == 0L) {
                    hintOptional = instance.getHint();
                    if (hintOptional.isPresent()) {
                        this.hint(hintOptional);
                    }
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    remapOptional = instance.getRemap();
                    if (remapOptional.isPresent()) {
                        this.remap(remapOptional);
                    }
                    bits |= 0x40L;
                }
            }
            if (object instanceof SingleInputRel) {
                instance = (SingleInputRel)object;
                if ((bits & 8L) == 0L) {
                    this.input(((SingleInputRel)instance).getInput());
                    bits |= 8L;
                }
                if ((bits & 2L) == 0L) {
                    commonExtensionOptional = instance.getCommonExtension();
                    if (commonExtensionOptional.isPresent()) {
                        this.commonExtension(commonExtensionOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 0x20L) == 0L) {
                    hintOptional = instance.getHint();
                    if (hintOptional.isPresent()) {
                        this.hint(hintOptional);
                    }
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    remapOptional = instance.getRemap();
                    if (remapOptional.isPresent()) {
                        this.remap(remapOptional);
                    }
                    bits |= 0x40L;
                }
            }
        }

        public final Builder extension(AdvancedExtension extension) {
            this.extension = Objects.requireNonNull(extension, "extension");
            return this;
        }

        public final Builder extension(Optional<? extends AdvancedExtension> extension) {
            this.extension = extension.orElse(null);
            return this;
        }

        public final Builder remap(Rel.Remap remap) {
            this.remap = Objects.requireNonNull(remap, "remap");
            return this;
        }

        public final Builder remap(Optional<? extends Rel.Remap> remap) {
            this.remap = remap.orElse(null);
            return this;
        }

        public final Builder commonExtension(AdvancedExtension commonExtension) {
            this.commonExtension = Objects.requireNonNull(commonExtension, "commonExtension");
            return this;
        }

        public final Builder commonExtension(Optional<? extends AdvancedExtension> commonExtension) {
            this.commonExtension = commonExtension.orElse(null);
            return this;
        }

        public final Builder hint(Hint hint) {
            this.hint = Objects.requireNonNull(hint, "hint");
            return this;
        }

        public final Builder hint(Optional<? extends Hint> hint) {
            this.hint = hint.orElse(null);
            return this;
        }

        public final Builder input(Rel input) {
            this.input = Objects.requireNonNull(input, "input");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder partitionCount(Integer partitionCount) {
            this.partitionCount = Objects.requireNonNull(partitionCount, "partitionCount");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addTargets(AbstractExchangeRel.ExchangeTarget element) {
            this.targets.add(Objects.requireNonNull(element, "targets element"));
            return this;
        }

        public final Builder addTargets(AbstractExchangeRel.ExchangeTarget ... elements) {
            for (AbstractExchangeRel.ExchangeTarget element : elements) {
                this.targets.add(Objects.requireNonNull(element, "targets element"));
            }
            return this;
        }

        public final Builder targets(Iterable<? extends AbstractExchangeRel.ExchangeTarget> elements) {
            this.targets.clear();
            return this.addAllTargets(elements);
        }

        public final Builder addAllTargets(Iterable<? extends AbstractExchangeRel.ExchangeTarget> elements) {
            for (AbstractExchangeRel.ExchangeTarget exchangeTarget : elements) {
                this.targets.add(Objects.requireNonNull(exchangeTarget, "targets element"));
            }
            return this;
        }

        public final Builder expression(Expression expression) {
            this.expression = Objects.requireNonNull(expression, "expression");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder constrainedToCount(boolean constrainedToCount) {
            this.constrainedToCount = constrainedToCount;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableMultiBucketExchange build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMultiBucketExchange(this.extension, this.remap, this.commonExtension, this.hint, this.input, this.partitionCount, ImmutableMultiBucketExchange.createUnmodifiableList(true, this.targets), this.expression, this.constrainedToCount);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("input");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("partitionCount");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("expression");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("constrainedToCount");
            }
            return "Cannot build MultiBucketExchange, some of required attributes are not set " + attributes;
        }
    }
}

