/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation;

import io.substrait.expression.AggregateFunctionInvocation;
import io.substrait.expression.Expression;
import io.substrait.expression.FunctionArg;
import io.substrait.expression.proto.ProtoExpressionConverter;
import io.substrait.extension.DefaultExtensionCatalog;
import io.substrait.extension.ExtensionLookup;
import io.substrait.extension.SimpleExtension;
import io.substrait.proto.AggregateFunction;
import io.substrait.type.proto.ProtoTypeConverter;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ProtoAggregateFunctionConverter {
    private final ExtensionLookup lookup;
    private final SimpleExtension.ExtensionCollection extensions;
    private final ProtoTypeConverter protoTypeConverter;
    private final ProtoExpressionConverter protoExpressionConverter;

    public ProtoAggregateFunctionConverter(ExtensionLookup lookup, ProtoExpressionConverter protoExpressionConverter) {
        this(lookup, DefaultExtensionCatalog.DEFAULT_COLLECTION, protoExpressionConverter);
    }

    public ProtoAggregateFunctionConverter(ExtensionLookup lookup, SimpleExtension.ExtensionCollection extensions, ProtoExpressionConverter protoExpressionConverter) {
        this.lookup = lookup;
        this.extensions = extensions;
        this.protoTypeConverter = new ProtoTypeConverter(lookup, extensions);
        this.protoExpressionConverter = protoExpressionConverter;
    }

    public AggregateFunctionInvocation from(AggregateFunction measure) {
        FunctionArg.ProtoFrom protoFrom = new FunctionArg.ProtoFrom(this.protoExpressionConverter, this.protoTypeConverter);
        SimpleExtension.AggregateFunctionVariant aggregateFunction = this.lookup.getAggregateFunction(measure.getFunctionReference(), this.extensions);
        List functionArgs = IntStream.range(0, measure.getArgumentsCount()).mapToObj(i -> protoFrom.convert(aggregateFunction, i, measure.getArguments(i))).collect(Collectors.toList());
        List options = measure.getOptionsList().stream().map(ProtoExpressionConverter::fromFunctionOption).collect(Collectors.toList());
        List sorts = measure.getSortsList().stream().map(this.protoExpressionConverter::fromSortField).collect(Collectors.toList());
        return AggregateFunctionInvocation.builder().arguments(functionArgs).declaration(aggregateFunction).outputType(this.protoTypeConverter.from(measure.getOutputType())).aggregationPhase(Expression.AggregationPhase.fromProto(measure.getPhase())).invocation(Expression.AggregationInvocation.fromProto(measure.getInvocation())).options(options).sort(sorts).build();
    }
}

