/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation;

import io.substrait.expression.Expression;
import io.substrait.relation.AbstractUpdate;
import java.util.ArrayList;
import java.util.Objects;

public final class ImmutableTransformExpression
extends AbstractUpdate.TransformExpression {
    private final Expression transformation;
    private final int columnTarget;

    private ImmutableTransformExpression(Expression transformation, int columnTarget) {
        this.transformation = transformation;
        this.columnTarget = columnTarget;
    }

    @Override
    public Expression getTransformation() {
        return this.transformation;
    }

    @Override
    public int getColumnTarget() {
        return this.columnTarget;
    }

    public final ImmutableTransformExpression withTransformation(Expression value) {
        if (this.transformation == value) {
            return this;
        }
        Expression newValue = Objects.requireNonNull(value, "transformation");
        return new ImmutableTransformExpression(newValue, this.columnTarget);
    }

    public final ImmutableTransformExpression withColumnTarget(int value) {
        if (this.columnTarget == value) {
            return this;
        }
        return new ImmutableTransformExpression(this.transformation, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTransformExpression && this.equalsByValue((ImmutableTransformExpression)another);
    }

    private boolean equalsByValue(ImmutableTransformExpression another) {
        return this.transformation.equals(another.transformation) && this.columnTarget == another.columnTarget;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.transformation.hashCode();
        h += (h << 5) + this.columnTarget;
        return h;
    }

    public String toString() {
        return "TransformExpression{transformation=" + this.transformation + ", columnTarget=" + this.columnTarget + "}";
    }

    public static ImmutableTransformExpression copyOf(AbstractUpdate.TransformExpression instance) {
        if (instance instanceof ImmutableTransformExpression) {
            return (ImmutableTransformExpression)instance;
        }
        return ImmutableTransformExpression.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TRANSFORMATION = 1L;
        private static final long INIT_BIT_COLUMN_TARGET = 2L;
        private long initBits = 3L;
        private Expression transformation;
        private int columnTarget;

        private Builder() {
        }

        public final Builder from(AbstractUpdate.TransformExpression instance) {
            Objects.requireNonNull(instance, "instance");
            this.transformation(instance.getTransformation());
            this.columnTarget(instance.getColumnTarget());
            return this;
        }

        public final Builder transformation(Expression transformation) {
            this.transformation = Objects.requireNonNull(transformation, "transformation");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder columnTarget(int columnTarget) {
            this.columnTarget = columnTarget;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableTransformExpression build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTransformExpression(this.transformation, this.columnTarget);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("transformation");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("columnTarget");
            }
            return "Cannot build TransformExpression, some of required attributes are not set " + attributes;
        }
    }
}

