/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation;

import io.substrait.expression.Expression;
import io.substrait.extension.AdvancedExtension;
import io.substrait.hint.Hint;
import io.substrait.relation.AbstractDdlRel;
import io.substrait.relation.AbstractRel;
import io.substrait.relation.Extension;
import io.substrait.relation.ExtensionDdl;
import io.substrait.relation.HasExtension;
import io.substrait.relation.Rel;
import io.substrait.relation.ZeroInputRel;
import io.substrait.type.NamedStruct;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

public final class ImmutableExtensionDdl
extends ExtensionDdl {
    private final AdvancedExtension extension;
    private final Rel.Remap remap;
    private final AdvancedExtension commonExtension;
    private final Hint hint;
    private final NamedStruct tableSchema;
    private final Expression.StructLiteral tableDefaults;
    private final AbstractDdlRel.DdlObject object;
    private final AbstractDdlRel.DdlOp operation;
    private final Rel viewDefinition;
    private final Extension.DdlExtensionObject detail;

    private ImmutableExtensionDdl(AdvancedExtension extension, Rel.Remap remap, AdvancedExtension commonExtension, Hint hint, NamedStruct tableSchema, Expression.StructLiteral tableDefaults, AbstractDdlRel.DdlObject object, AbstractDdlRel.DdlOp operation, Rel viewDefinition, Extension.DdlExtensionObject detail) {
        this.extension = extension;
        this.remap = remap;
        this.commonExtension = commonExtension;
        this.hint = hint;
        this.tableSchema = tableSchema;
        this.tableDefaults = tableDefaults;
        this.object = object;
        this.operation = operation;
        this.viewDefinition = viewDefinition;
        this.detail = detail;
    }

    @Override
    public Optional<AdvancedExtension> getExtension() {
        return Optional.ofNullable(this.extension);
    }

    @Override
    public Optional<Rel.Remap> getRemap() {
        return Optional.ofNullable(this.remap);
    }

    @Override
    public Optional<AdvancedExtension> getCommonExtension() {
        return Optional.ofNullable(this.commonExtension);
    }

    @Override
    public Optional<Hint> getHint() {
        return Optional.ofNullable(this.hint);
    }

    @Override
    public NamedStruct getTableSchema() {
        return this.tableSchema;
    }

    @Override
    public Expression.StructLiteral getTableDefaults() {
        return this.tableDefaults;
    }

    @Override
    public AbstractDdlRel.DdlObject getObject() {
        return this.object;
    }

    @Override
    public AbstractDdlRel.DdlOp getOperation() {
        return this.operation;
    }

    @Override
    public Optional<Rel> getViewDefinition() {
        return Optional.ofNullable(this.viewDefinition);
    }

    @Override
    public Extension.DdlExtensionObject getDetail() {
        return this.detail;
    }

    public final ImmutableExtensionDdl withExtension(AdvancedExtension value) {
        AdvancedExtension newValue = Objects.requireNonNull(value, "extension");
        if (this.extension == newValue) {
            return this;
        }
        return new ImmutableExtensionDdl(newValue, this.remap, this.commonExtension, this.hint, this.tableSchema, this.tableDefaults, this.object, this.operation, this.viewDefinition, this.detail);
    }

    public final ImmutableExtensionDdl withExtension(Optional<? extends AdvancedExtension> optional) {
        AdvancedExtension value = optional.orElse(null);
        if (this.extension == value) {
            return this;
        }
        return new ImmutableExtensionDdl(value, this.remap, this.commonExtension, this.hint, this.tableSchema, this.tableDefaults, this.object, this.operation, this.viewDefinition, this.detail);
    }

    public final ImmutableExtensionDdl withRemap(Rel.Remap value) {
        Rel.Remap newValue = Objects.requireNonNull(value, "remap");
        if (this.remap == newValue) {
            return this;
        }
        return new ImmutableExtensionDdl(this.extension, newValue, this.commonExtension, this.hint, this.tableSchema, this.tableDefaults, this.object, this.operation, this.viewDefinition, this.detail);
    }

    public final ImmutableExtensionDdl withRemap(Optional<? extends Rel.Remap> optional) {
        Rel.Remap value = optional.orElse(null);
        if (this.remap == value) {
            return this;
        }
        return new ImmutableExtensionDdl(this.extension, value, this.commonExtension, this.hint, this.tableSchema, this.tableDefaults, this.object, this.operation, this.viewDefinition, this.detail);
    }

    public final ImmutableExtensionDdl withCommonExtension(AdvancedExtension value) {
        AdvancedExtension newValue = Objects.requireNonNull(value, "commonExtension");
        if (this.commonExtension == newValue) {
            return this;
        }
        return new ImmutableExtensionDdl(this.extension, this.remap, newValue, this.hint, this.tableSchema, this.tableDefaults, this.object, this.operation, this.viewDefinition, this.detail);
    }

    public final ImmutableExtensionDdl withCommonExtension(Optional<? extends AdvancedExtension> optional) {
        AdvancedExtension value = optional.orElse(null);
        if (this.commonExtension == value) {
            return this;
        }
        return new ImmutableExtensionDdl(this.extension, this.remap, value, this.hint, this.tableSchema, this.tableDefaults, this.object, this.operation, this.viewDefinition, this.detail);
    }

    public final ImmutableExtensionDdl withHint(Hint value) {
        Hint newValue = Objects.requireNonNull(value, "hint");
        if (this.hint == newValue) {
            return this;
        }
        return new ImmutableExtensionDdl(this.extension, this.remap, this.commonExtension, newValue, this.tableSchema, this.tableDefaults, this.object, this.operation, this.viewDefinition, this.detail);
    }

    public final ImmutableExtensionDdl withHint(Optional<? extends Hint> optional) {
        Hint value = optional.orElse(null);
        if (this.hint == value) {
            return this;
        }
        return new ImmutableExtensionDdl(this.extension, this.remap, this.commonExtension, value, this.tableSchema, this.tableDefaults, this.object, this.operation, this.viewDefinition, this.detail);
    }

    public final ImmutableExtensionDdl withTableSchema(NamedStruct value) {
        if (this.tableSchema == value) {
            return this;
        }
        NamedStruct newValue = Objects.requireNonNull(value, "tableSchema");
        return new ImmutableExtensionDdl(this.extension, this.remap, this.commonExtension, this.hint, newValue, this.tableDefaults, this.object, this.operation, this.viewDefinition, this.detail);
    }

    public final ImmutableExtensionDdl withTableDefaults(Expression.StructLiteral value) {
        if (this.tableDefaults == value) {
            return this;
        }
        Expression.StructLiteral newValue = Objects.requireNonNull(value, "tableDefaults");
        return new ImmutableExtensionDdl(this.extension, this.remap, this.commonExtension, this.hint, this.tableSchema, newValue, this.object, this.operation, this.viewDefinition, this.detail);
    }

    public final ImmutableExtensionDdl withObject(AbstractDdlRel.DdlObject value) {
        AbstractDdlRel.DdlObject newValue = Objects.requireNonNull(value, "object");
        if (this.object == newValue) {
            return this;
        }
        return new ImmutableExtensionDdl(this.extension, this.remap, this.commonExtension, this.hint, this.tableSchema, this.tableDefaults, newValue, this.operation, this.viewDefinition, this.detail);
    }

    public final ImmutableExtensionDdl withOperation(AbstractDdlRel.DdlOp value) {
        AbstractDdlRel.DdlOp newValue = Objects.requireNonNull(value, "operation");
        if (this.operation == newValue) {
            return this;
        }
        return new ImmutableExtensionDdl(this.extension, this.remap, this.commonExtension, this.hint, this.tableSchema, this.tableDefaults, this.object, newValue, this.viewDefinition, this.detail);
    }

    public final ImmutableExtensionDdl withViewDefinition(Rel value) {
        Rel newValue = Objects.requireNonNull(value, "viewDefinition");
        if (this.viewDefinition == newValue) {
            return this;
        }
        return new ImmutableExtensionDdl(this.extension, this.remap, this.commonExtension, this.hint, this.tableSchema, this.tableDefaults, this.object, this.operation, newValue, this.detail);
    }

    public final ImmutableExtensionDdl withViewDefinition(Optional<? extends Rel> optional) {
        Rel value = optional.orElse(null);
        if (this.viewDefinition == value) {
            return this;
        }
        return new ImmutableExtensionDdl(this.extension, this.remap, this.commonExtension, this.hint, this.tableSchema, this.tableDefaults, this.object, this.operation, value, this.detail);
    }

    public final ImmutableExtensionDdl withDetail(Extension.DdlExtensionObject value) {
        if (this.detail == value) {
            return this;
        }
        Extension.DdlExtensionObject newValue = Objects.requireNonNull(value, "detail");
        return new ImmutableExtensionDdl(this.extension, this.remap, this.commonExtension, this.hint, this.tableSchema, this.tableDefaults, this.object, this.operation, this.viewDefinition, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExtensionDdl && this.equalsByValue((ImmutableExtensionDdl)another);
    }

    private boolean equalsByValue(ImmutableExtensionDdl another) {
        return Objects.equals(this.extension, another.extension) && Objects.equals(this.remap, another.remap) && Objects.equals(this.commonExtension, another.commonExtension) && Objects.equals(this.hint, another.hint) && this.tableSchema.equals(another.tableSchema) && this.tableDefaults.equals(another.tableDefaults) && this.object.equals((Object)another.object) && this.operation.equals((Object)another.operation) && Objects.equals(this.viewDefinition, another.viewDefinition) && this.detail.equals(another.detail);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.extension);
        h += (h << 5) + Objects.hashCode(this.remap);
        h += (h << 5) + Objects.hashCode(this.commonExtension);
        h += (h << 5) + Objects.hashCode(this.hint);
        h += (h << 5) + this.tableSchema.hashCode();
        h += (h << 5) + this.tableDefaults.hashCode();
        h += (h << 5) + this.object.hashCode();
        h += (h << 5) + this.operation.hashCode();
        h += (h << 5) + Objects.hashCode(this.viewDefinition);
        h += (h << 5) + this.detail.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ExtensionDdl{");
        if (this.extension != null) {
            builder.append("extension=").append(this.extension);
        }
        if (this.remap != null) {
            if (builder.length() > 13) {
                builder.append(", ");
            }
            builder.append("remap=").append(this.remap);
        }
        if (this.commonExtension != null) {
            if (builder.length() > 13) {
                builder.append(", ");
            }
            builder.append("commonExtension=").append(this.commonExtension);
        }
        if (this.hint != null) {
            if (builder.length() > 13) {
                builder.append(", ");
            }
            builder.append("hint=").append(this.hint);
        }
        if (builder.length() > 13) {
            builder.append(", ");
        }
        builder.append("tableSchema=").append(this.tableSchema);
        builder.append(", ");
        builder.append("tableDefaults=").append(this.tableDefaults);
        builder.append(", ");
        builder.append("object=").append((Object)this.object);
        builder.append(", ");
        builder.append("operation=").append((Object)this.operation);
        if (this.viewDefinition != null) {
            builder.append(", ");
            builder.append("viewDefinition=").append(this.viewDefinition);
        }
        builder.append(", ");
        builder.append("detail=").append(this.detail);
        return builder.append("}").toString();
    }

    public static ImmutableExtensionDdl copyOf(ExtensionDdl instance) {
        if (instance instanceof ImmutableExtensionDdl) {
            return (ImmutableExtensionDdl)instance;
        }
        return ImmutableExtensionDdl.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TABLE_SCHEMA = 1L;
        private static final long INIT_BIT_TABLE_DEFAULTS = 2L;
        private static final long INIT_BIT_OBJECT = 4L;
        private static final long INIT_BIT_OPERATION = 8L;
        private static final long INIT_BIT_DETAIL = 16L;
        private long initBits = 31L;
        private AdvancedExtension extension;
        private Rel.Remap remap;
        private AdvancedExtension commonExtension;
        private Hint hint;
        private NamedStruct tableSchema;
        private Expression.StructLiteral tableDefaults;
        private AbstractDdlRel.DdlObject object;
        private AbstractDdlRel.DdlOp operation;
        private Rel viewDefinition;
        private Extension.DdlExtensionObject detail;

        private Builder() {
        }

        public final Builder from(ZeroInputRel instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(HasExtension instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(ExtensionDdl instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(Rel instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(AbstractRel instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(AbstractDdlRel instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            Optional<Rel> viewDefinitionOptional;
            Optional<AdvancedExtension> extensionOptional;
            Optional<Rel.Remap> remapOptional;
            Optional<Hint> hintOptional;
            Optional<AdvancedExtension> commonExtensionOptional;
            Object instance;
            long bits = 0L;
            if (object instanceof ZeroInputRel) {
                instance = (ZeroInputRel)object;
                if ((bits & 4L) == 0L) {
                    commonExtensionOptional = instance.getCommonExtension();
                    if (commonExtensionOptional.isPresent()) {
                        this.commonExtension(commonExtensionOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 0x10L) == 0L) {
                    hintOptional = instance.getHint();
                    if (hintOptional.isPresent()) {
                        this.hint(hintOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x80L) == 0L) {
                    remapOptional = instance.getRemap();
                    if (remapOptional.isPresent()) {
                        this.remap(remapOptional);
                    }
                    bits |= 0x80L;
                }
            }
            if (object instanceof HasExtension) {
                instance = (HasExtension)object;
                if ((bits & 2L) == 0L) {
                    extensionOptional = instance.getExtension();
                    if (extensionOptional.isPresent()) {
                        this.extension(extensionOptional);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof ExtensionDdl) {
                instance = (ExtensionDdl)object;
                if ((bits & 1L) == 0L) {
                    viewDefinitionOptional = ((AbstractDdlRel)instance).getViewDefinition();
                    if (viewDefinitionOptional.isPresent()) {
                        this.viewDefinition(viewDefinitionOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    extensionOptional = instance.getExtension();
                    if (extensionOptional.isPresent()) {
                        this.extension(extensionOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 0x10L) == 0L) {
                    hintOptional = instance.getHint();
                    if (hintOptional.isPresent()) {
                        this.hint(hintOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.tableDefaults(((AbstractDdlRel)instance).getTableDefaults());
                    bits |= 0x20L;
                }
                this.detail(((ExtensionDdl)instance).getDetail());
                if ((bits & 4L) == 0L) {
                    commonExtensionOptional = instance.getCommonExtension();
                    if (commonExtensionOptional.isPresent()) {
                        this.commonExtension(commonExtensionOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.operation(((AbstractDdlRel)instance).getOperation());
                    bits |= 0x40L;
                }
                if ((bits & 8L) == 0L) {
                    this.tableSchema(((AbstractDdlRel)instance).getTableSchema());
                    bits |= 8L;
                }
                if ((bits & 0x80L) == 0L) {
                    remapOptional = instance.getRemap();
                    if (remapOptional.isPresent()) {
                        this.remap(remapOptional);
                    }
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.object(((AbstractDdlRel)instance).getObject());
                    bits |= 0x100L;
                }
            }
            if (object instanceof Rel) {
                instance = (Rel)object;
                if ((bits & 4L) == 0L) {
                    commonExtensionOptional = instance.getCommonExtension();
                    if (commonExtensionOptional.isPresent()) {
                        this.commonExtension(commonExtensionOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 0x10L) == 0L) {
                    hintOptional = instance.getHint();
                    if (hintOptional.isPresent()) {
                        this.hint(hintOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x80L) == 0L) {
                    remapOptional = instance.getRemap();
                    if (remapOptional.isPresent()) {
                        this.remap(remapOptional);
                    }
                    bits |= 0x80L;
                }
            }
            if (object instanceof AbstractRel) {
                instance = (AbstractRel)object;
                if ((bits & 4L) == 0L) {
                    commonExtensionOptional = instance.getCommonExtension();
                    if (commonExtensionOptional.isPresent()) {
                        this.commonExtension(commonExtensionOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 0x10L) == 0L) {
                    hintOptional = instance.getHint();
                    if (hintOptional.isPresent()) {
                        this.hint(hintOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x80L) == 0L) {
                    remapOptional = instance.getRemap();
                    if (remapOptional.isPresent()) {
                        this.remap(remapOptional);
                    }
                    bits |= 0x80L;
                }
            }
            if (object instanceof AbstractDdlRel) {
                instance = (AbstractDdlRel)object;
                if ((bits & 1L) == 0L) {
                    viewDefinitionOptional = ((AbstractDdlRel)instance).getViewDefinition();
                    if (viewDefinitionOptional.isPresent()) {
                        this.viewDefinition(viewDefinitionOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    extensionOptional = instance.getExtension();
                    if (extensionOptional.isPresent()) {
                        this.extension(extensionOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 0x10L) == 0L) {
                    hintOptional = instance.getHint();
                    if (hintOptional.isPresent()) {
                        this.hint(hintOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.tableDefaults(((AbstractDdlRel)instance).getTableDefaults());
                    bits |= 0x20L;
                }
                if ((bits & 4L) == 0L) {
                    commonExtensionOptional = instance.getCommonExtension();
                    if (commonExtensionOptional.isPresent()) {
                        this.commonExtension(commonExtensionOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.operation(((AbstractDdlRel)instance).getOperation());
                    bits |= 0x40L;
                }
                if ((bits & 8L) == 0L) {
                    this.tableSchema(((AbstractDdlRel)instance).getTableSchema());
                    bits |= 8L;
                }
                if ((bits & 0x80L) == 0L) {
                    remapOptional = instance.getRemap();
                    if (remapOptional.isPresent()) {
                        this.remap(remapOptional);
                    }
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.object(((AbstractDdlRel)instance).getObject());
                    bits |= 0x100L;
                }
            }
        }

        public final Builder extension(AdvancedExtension extension) {
            this.extension = Objects.requireNonNull(extension, "extension");
            return this;
        }

        public final Builder extension(Optional<? extends AdvancedExtension> extension) {
            this.extension = extension.orElse(null);
            return this;
        }

        public final Builder remap(Rel.Remap remap) {
            this.remap = Objects.requireNonNull(remap, "remap");
            return this;
        }

        public final Builder remap(Optional<? extends Rel.Remap> remap) {
            this.remap = remap.orElse(null);
            return this;
        }

        public final Builder commonExtension(AdvancedExtension commonExtension) {
            this.commonExtension = Objects.requireNonNull(commonExtension, "commonExtension");
            return this;
        }

        public final Builder commonExtension(Optional<? extends AdvancedExtension> commonExtension) {
            this.commonExtension = commonExtension.orElse(null);
            return this;
        }

        public final Builder hint(Hint hint) {
            this.hint = Objects.requireNonNull(hint, "hint");
            return this;
        }

        public final Builder hint(Optional<? extends Hint> hint) {
            this.hint = hint.orElse(null);
            return this;
        }

        public final Builder tableSchema(NamedStruct tableSchema) {
            this.tableSchema = Objects.requireNonNull(tableSchema, "tableSchema");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder tableDefaults(Expression.StructLiteral tableDefaults) {
            this.tableDefaults = Objects.requireNonNull(tableDefaults, "tableDefaults");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder object(AbstractDdlRel.DdlObject object) {
            this.object = Objects.requireNonNull(object, "object");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder operation(AbstractDdlRel.DdlOp operation) {
            this.operation = Objects.requireNonNull(operation, "operation");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder viewDefinition(Rel viewDefinition) {
            this.viewDefinition = Objects.requireNonNull(viewDefinition, "viewDefinition");
            return this;
        }

        public final Builder viewDefinition(Optional<? extends Rel> viewDefinition) {
            this.viewDefinition = viewDefinition.orElse(null);
            return this;
        }

        public final Builder detail(Extension.DdlExtensionObject detail) {
            this.detail = Objects.requireNonNull(detail, "detail");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableExtensionDdl build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExtensionDdl(this.extension, this.remap, this.commonExtension, this.hint, this.tableSchema, this.tableDefaults, this.object, this.operation, this.viewDefinition, this.detail);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("tableSchema");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("tableDefaults");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("object");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("operation");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("detail");
            }
            return "Cannot build ExtensionDdl, some of required attributes are not set " + attributes;
        }
    }
}

