/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.expression;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import io.substrait.expression.Expression;
import io.substrait.expression.FunctionArg;
import io.substrait.expression.FunctionOption;
import io.substrait.expression.WindowBound;
import io.substrait.extension.SimpleExtension;
import io.substrait.relation.Rel;
import io.substrait.type.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public final class ImmutableExpression {
    private ImmutableExpression() {
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class InPredicate
    extends Expression.InPredicate {
        private final Rel haystack;
        private final List<Expression> needles;

        private InPredicate(Rel haystack, List<Expression> needles) {
            this.haystack = haystack;
            this.needles = needles;
        }

        @Override
        public Rel haystack() {
            return this.haystack;
        }

        @Override
        public List<Expression> needles() {
            return this.needles;
        }

        public final InPredicate withHaystack(Rel value) {
            if (this.haystack == value) {
                return this;
            }
            Rel newValue = Objects.requireNonNull(value, "haystack");
            return new InPredicate(newValue, this.needles);
        }

        public final InPredicate withNeedles(Expression ... elements) {
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(Arrays.asList(elements), true, false));
            return new InPredicate(this.haystack, newValue);
        }

        public final InPredicate withNeedles(Iterable<? extends Expression> elements) {
            if (this.needles == elements) {
                return this;
            }
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(elements, true, false));
            return new InPredicate(this.haystack, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof InPredicate && this.equalsByValue((InPredicate)another);
        }

        private boolean equalsByValue(InPredicate another) {
            return this.haystack.equals(another.haystack) && this.needles.equals(another.needles);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.haystack.hashCode();
            h += (h << 5) + this.needles.hashCode();
            return h;
        }

        public String toString() {
            return "InPredicate{haystack=" + this.haystack + ", needles=" + this.needles + "}";
        }

        public static InPredicate copyOf(Expression.InPredicate instance) {
            if (instance instanceof InPredicate) {
                return (InPredicate)instance;
            }
            return InPredicate.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_HAYSTACK = 1L;
            private long initBits = 1L;
            private Rel haystack;
            private List<Expression> needles = new ArrayList<Expression>();

            private Builder() {
            }

            public final Builder from(Expression.InPredicate instance) {
                Objects.requireNonNull(instance, "instance");
                this.haystack(instance.haystack());
                this.addAllNeedles(instance.needles());
                return this;
            }

            public final Builder haystack(Rel haystack) {
                this.haystack = Objects.requireNonNull(haystack, "haystack");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder addNeedles(Expression element) {
                this.needles.add(Objects.requireNonNull(element, "needles element"));
                return this;
            }

            public final Builder addNeedles(Expression ... elements) {
                for (Expression element : elements) {
                    this.needles.add(Objects.requireNonNull(element, "needles element"));
                }
                return this;
            }

            public final Builder needles(Iterable<? extends Expression> elements) {
                this.needles.clear();
                return this.addAllNeedles(elements);
            }

            public final Builder addAllNeedles(Iterable<? extends Expression> elements) {
                for (Expression expression : elements) {
                    this.needles.add(Objects.requireNonNull(expression, "needles element"));
                }
                return this;
            }

            public InPredicate build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new InPredicate(this.haystack, ImmutableExpression.createUnmodifiableList(true, this.needles));
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("haystack");
                }
                return "Cannot build InPredicate, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class ScalarSubquery
    extends Expression.ScalarSubquery {
        private final Type type;
        private final Rel input;

        private ScalarSubquery(Type type, Rel input) {
            this.type = type;
            this.input = input;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public Rel input() {
            return this.input;
        }

        public final ScalarSubquery withType(Type value) {
            if (this.type == value) {
                return this;
            }
            Type newValue = Objects.requireNonNull(value, "type");
            return new ScalarSubquery(newValue, this.input);
        }

        public final ScalarSubquery withInput(Rel value) {
            if (this.input == value) {
                return this;
            }
            Rel newValue = Objects.requireNonNull(value, "input");
            return new ScalarSubquery(this.type, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ScalarSubquery && this.equalsByValue((ScalarSubquery)another);
        }

        private boolean equalsByValue(ScalarSubquery another) {
            return this.type.equals(another.type) && this.input.equals(another.input);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.type.hashCode();
            h += (h << 5) + this.input.hashCode();
            return h;
        }

        public String toString() {
            return "ScalarSubquery{type=" + this.type + ", input=" + this.input + "}";
        }

        public static ScalarSubquery copyOf(Expression.ScalarSubquery instance) {
            if (instance instanceof ScalarSubquery) {
                return (ScalarSubquery)instance;
            }
            return ScalarSubquery.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_TYPE = 1L;
            private static final long INIT_BIT_INPUT = 2L;
            private long initBits = 3L;
            private Type type;
            private Rel input;

            private Builder() {
            }

            public final Builder from(Expression.ScalarSubquery instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression.Subquery instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                Expression instance;
                long bits = 0L;
                if (object instanceof Expression.ScalarSubquery) {
                    instance = (Expression.ScalarSubquery)object;
                    if ((bits & 1L) == 0L) {
                        this.type(instance.getType());
                        bits |= 1L;
                    }
                    this.input(((Expression.ScalarSubquery)instance).input());
                }
                if (object instanceof Expression) {
                    instance = (Expression)object;
                    if ((bits & 1L) == 0L) {
                        this.type(instance.getType());
                        bits |= 1L;
                    }
                }
                if (object instanceof Expression.Subquery) {
                    instance = (Expression.Subquery)object;
                    if ((bits & 1L) == 0L) {
                        this.type(instance.getType());
                        bits |= 1L;
                    }
                }
            }

            public final Builder type(Type type) {
                this.type = Objects.requireNonNull(type, "type");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder input(Rel input) {
                this.input = Objects.requireNonNull(input, "input");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public ScalarSubquery build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new ScalarSubquery(this.type, this.input);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("type");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("input");
                }
                return "Cannot build ScalarSubquery, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class SetPredicate
    extends Expression.SetPredicate {
        private final Expression.PredicateOp predicateOp;
        private final Rel tuples;

        private SetPredicate(Expression.PredicateOp predicateOp, Rel tuples) {
            this.predicateOp = predicateOp;
            this.tuples = tuples;
        }

        @Override
        public Expression.PredicateOp predicateOp() {
            return this.predicateOp;
        }

        @Override
        public Rel tuples() {
            return this.tuples;
        }

        public final SetPredicate withPredicateOp(Expression.PredicateOp value) {
            Expression.PredicateOp newValue = Objects.requireNonNull(value, "predicateOp");
            if (this.predicateOp == newValue) {
                return this;
            }
            return new SetPredicate(newValue, this.tuples);
        }

        public final SetPredicate withTuples(Rel value) {
            if (this.tuples == value) {
                return this;
            }
            Rel newValue = Objects.requireNonNull(value, "tuples");
            return new SetPredicate(this.predicateOp, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof SetPredicate && this.equalsByValue((SetPredicate)another);
        }

        private boolean equalsByValue(SetPredicate another) {
            return this.predicateOp.equals((Object)another.predicateOp) && this.tuples.equals(another.tuples);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.predicateOp.hashCode();
            h += (h << 5) + this.tuples.hashCode();
            return h;
        }

        public String toString() {
            return "SetPredicate{predicateOp=" + (Object)((Object)this.predicateOp) + ", tuples=" + this.tuples + "}";
        }

        public static SetPredicate copyOf(Expression.SetPredicate instance) {
            if (instance instanceof SetPredicate) {
                return (SetPredicate)instance;
            }
            return SetPredicate.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_PREDICATE_OP = 1L;
            private static final long INIT_BIT_TUPLES = 2L;
            private long initBits = 3L;
            private Expression.PredicateOp predicateOp;
            private Rel tuples;

            private Builder() {
            }

            public final Builder from(Expression.SetPredicate instance) {
                Objects.requireNonNull(instance, "instance");
                this.predicateOp(instance.predicateOp());
                this.tuples(instance.tuples());
                return this;
            }

            public final Builder predicateOp(Expression.PredicateOp predicateOp) {
                this.predicateOp = Objects.requireNonNull(predicateOp, "predicateOp");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder tuples(Rel tuples) {
                this.tuples = Objects.requireNonNull(tuples, "tuples");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public SetPredicate build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new SetPredicate(this.predicateOp, this.tuples);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("predicateOp");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("tuples");
                }
                return "Cannot build SetPredicate, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class SortField
    extends Expression.SortField {
        private final Expression expr;
        private final Expression.SortDirection direction;

        private SortField(Expression expr, Expression.SortDirection direction) {
            this.expr = expr;
            this.direction = direction;
        }

        @Override
        public Expression expr() {
            return this.expr;
        }

        @Override
        public Expression.SortDirection direction() {
            return this.direction;
        }

        public final SortField withExpr(Expression value) {
            if (this.expr == value) {
                return this;
            }
            Expression newValue = Objects.requireNonNull(value, "expr");
            return new SortField(newValue, this.direction);
        }

        public final SortField withDirection(Expression.SortDirection value) {
            Expression.SortDirection newValue = Objects.requireNonNull(value, "direction");
            if (this.direction == newValue) {
                return this;
            }
            return new SortField(this.expr, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof SortField && this.equalsByValue((SortField)another);
        }

        private boolean equalsByValue(SortField another) {
            return this.expr.equals(another.expr) && this.direction.equals((Object)another.direction);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.expr.hashCode();
            h += (h << 5) + this.direction.hashCode();
            return h;
        }

        public String toString() {
            return "SortField{expr=" + this.expr + ", direction=" + (Object)((Object)this.direction) + "}";
        }

        public static SortField copyOf(Expression.SortField instance) {
            if (instance instanceof SortField) {
                return (SortField)instance;
            }
            return SortField.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_EXPR = 1L;
            private static final long INIT_BIT_DIRECTION = 2L;
            private long initBits = 3L;
            private Expression expr;
            private Expression.SortDirection direction;

            private Builder() {
            }

            public final Builder from(Expression.SortField instance) {
                Objects.requireNonNull(instance, "instance");
                this.expr(instance.expr());
                this.direction(instance.direction());
                return this;
            }

            public final Builder expr(Expression expr) {
                this.expr = Objects.requireNonNull(expr, "expr");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder direction(Expression.SortDirection direction) {
                this.direction = Objects.requireNonNull(direction, "direction");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public SortField build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new SortField(this.expr, this.direction);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("expr");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("direction");
                }
                return "Cannot build SortField, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class MultiOrListRecord
    extends Expression.MultiOrListRecord {
        private final List<Expression> values;

        private MultiOrListRecord(List<Expression> values) {
            this.values = values;
        }

        @Override
        public List<Expression> values() {
            return this.values;
        }

        public final MultiOrListRecord withValues(Expression ... elements) {
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(Arrays.asList(elements), true, false));
            return new MultiOrListRecord(newValue);
        }

        public final MultiOrListRecord withValues(Iterable<? extends Expression> elements) {
            if (this.values == elements) {
                return this;
            }
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(elements, true, false));
            return new MultiOrListRecord(newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof MultiOrListRecord && this.equalsByValue((MultiOrListRecord)another);
        }

        private boolean equalsByValue(MultiOrListRecord another) {
            return this.values.equals(another.values);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.values.hashCode();
            return h;
        }

        public String toString() {
            return "MultiOrListRecord{values=" + this.values + "}";
        }

        public static MultiOrListRecord copyOf(Expression.MultiOrListRecord instance) {
            if (instance instanceof MultiOrListRecord) {
                return (MultiOrListRecord)instance;
            }
            return MultiOrListRecord.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private List<Expression> values = new ArrayList<Expression>();

            private Builder() {
            }

            public final Builder from(Expression.MultiOrListRecord instance) {
                Objects.requireNonNull(instance, "instance");
                this.addAllValues(instance.values());
                return this;
            }

            public final Builder addValues(Expression element) {
                this.values.add(Objects.requireNonNull(element, "values element"));
                return this;
            }

            public final Builder addValues(Expression ... elements) {
                for (Expression element : elements) {
                    this.values.add(Objects.requireNonNull(element, "values element"));
                }
                return this;
            }

            public final Builder values(Iterable<? extends Expression> elements) {
                this.values.clear();
                return this.addAllValues(elements);
            }

            public final Builder addAllValues(Iterable<? extends Expression> elements) {
                for (Expression expression : elements) {
                    this.values.add(Objects.requireNonNull(expression, "values element"));
                }
                return this;
            }

            public MultiOrListRecord build() {
                return new MultiOrListRecord(ImmutableExpression.createUnmodifiableList(true, this.values));
            }
        }
    }

    public static final class NestedList
    extends Expression.NestedList {
        private final boolean nullable;
        private final List<Expression> values;

        private NestedList(Builder builder) {
            this.values = ImmutableExpression.createUnmodifiableList(true, builder.values);
            this.nullable = builder.nullableIsSet() ? builder.nullable : super.nullable();
        }

        private NestedList(boolean nullable, List<Expression> values) {
            this.nullable = nullable;
            this.values = values;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public List<Expression> values() {
            return this.values;
        }

        public final NestedList withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return NestedList.validate(new NestedList(value, this.values));
        }

        public final NestedList withValues(Expression ... elements) {
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(Arrays.asList(elements), true, false));
            return NestedList.validate(new NestedList(this.nullable, newValue));
        }

        public final NestedList withValues(Iterable<? extends Expression> elements) {
            if (this.values == elements) {
                return this;
            }
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(elements, true, false));
            return NestedList.validate(new NestedList(this.nullable, newValue));
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof NestedList && this.equalsByValue((NestedList)another);
        }

        private boolean equalsByValue(NestedList another) {
            return this.nullable == another.nullable && this.values.equals(another.values);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.values.hashCode();
            return h;
        }

        public String toString() {
            return "NestedList{nullable=" + this.nullable + ", values=" + this.values + "}";
        }

        private static NestedList validate(NestedList instance) {
            instance.check();
            return instance;
        }

        public static NestedList copyOf(Expression.NestedList instance) {
            if (instance instanceof NestedList) {
                return (NestedList)instance;
            }
            return NestedList.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long OPT_BIT_NULLABLE = 1L;
            private long optBits;
            private boolean nullable;
            private List<Expression> values = new ArrayList<Expression>();

            private Builder() {
            }

            public final Builder from(Expression.NestedList instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression.Nested instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                Expression.Nested instance;
                long bits = 0L;
                if (object instanceof Expression.NestedList) {
                    instance = (Expression.NestedList)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.addAllValues(((Expression.NestedList)instance).values());
                }
                if (object instanceof Expression.Nested) {
                    instance = (Expression.Nested)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.optBits |= 1L;
                return this;
            }

            public final Builder addValues(Expression element) {
                this.values.add(Objects.requireNonNull(element, "values element"));
                return this;
            }

            public final Builder addValues(Expression ... elements) {
                for (Expression element : elements) {
                    this.values.add(Objects.requireNonNull(element, "values element"));
                }
                return this;
            }

            public final Builder values(Iterable<? extends Expression> elements) {
                this.values.clear();
                return this.addAllValues(elements);
            }

            public final Builder addAllValues(Iterable<? extends Expression> elements) {
                for (Expression expression : elements) {
                    this.values.add(Objects.requireNonNull(expression, "values element"));
                }
                return this;
            }

            public NestedList build() {
                return NestedList.validate(new NestedList(this));
            }

            private boolean nullableIsSet() {
                return (this.optBits & 1L) != 0L;
            }
        }
    }

    public static final class MultiOrList
    extends Expression.MultiOrList {
        private final List<Expression> conditions;
        private final List<Expression.MultiOrListRecord> optionCombinations;

        private MultiOrList(List<Expression> conditions, List<Expression.MultiOrListRecord> optionCombinations) {
            this.conditions = conditions;
            this.optionCombinations = optionCombinations;
        }

        @Override
        public List<Expression> conditions() {
            return this.conditions;
        }

        @Override
        public List<Expression.MultiOrListRecord> optionCombinations() {
            return this.optionCombinations;
        }

        public final MultiOrList withConditions(Expression ... elements) {
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(Arrays.asList(elements), true, false));
            return new MultiOrList(newValue, this.optionCombinations);
        }

        public final MultiOrList withConditions(Iterable<? extends Expression> elements) {
            if (this.conditions == elements) {
                return this;
            }
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(elements, true, false));
            return new MultiOrList(newValue, this.optionCombinations);
        }

        public final MultiOrList withOptionCombinations(Expression.MultiOrListRecord ... elements) {
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(Arrays.asList(elements), true, false));
            return new MultiOrList(this.conditions, newValue);
        }

        public final MultiOrList withOptionCombinations(Iterable<? extends Expression.MultiOrListRecord> elements) {
            if (this.optionCombinations == elements) {
                return this;
            }
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(elements, true, false));
            return new MultiOrList(this.conditions, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof MultiOrList && this.equalsByValue((MultiOrList)another);
        }

        private boolean equalsByValue(MultiOrList another) {
            return this.conditions.equals(another.conditions) && this.optionCombinations.equals(another.optionCombinations);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.conditions.hashCode();
            h += (h << 5) + this.optionCombinations.hashCode();
            return h;
        }

        public String toString() {
            return "MultiOrList{conditions=" + this.conditions + ", optionCombinations=" + this.optionCombinations + "}";
        }

        public static MultiOrList copyOf(Expression.MultiOrList instance) {
            if (instance instanceof MultiOrList) {
                return (MultiOrList)instance;
            }
            return MultiOrList.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private List<Expression> conditions = new ArrayList<Expression>();
            private List<Expression.MultiOrListRecord> optionCombinations = new ArrayList<Expression.MultiOrListRecord>();

            private Builder() {
            }

            public final Builder from(Expression.MultiOrList instance) {
                Objects.requireNonNull(instance, "instance");
                this.addAllConditions(instance.conditions());
                this.addAllOptionCombinations(instance.optionCombinations());
                return this;
            }

            public final Builder addConditions(Expression element) {
                this.conditions.add(Objects.requireNonNull(element, "conditions element"));
                return this;
            }

            public final Builder addConditions(Expression ... elements) {
                for (Expression element : elements) {
                    this.conditions.add(Objects.requireNonNull(element, "conditions element"));
                }
                return this;
            }

            public final Builder conditions(Iterable<? extends Expression> elements) {
                this.conditions.clear();
                return this.addAllConditions(elements);
            }

            public final Builder addAllConditions(Iterable<? extends Expression> elements) {
                for (Expression expression : elements) {
                    this.conditions.add(Objects.requireNonNull(expression, "conditions element"));
                }
                return this;
            }

            public final Builder addOptionCombinations(Expression.MultiOrListRecord element) {
                this.optionCombinations.add(Objects.requireNonNull(element, "optionCombinations element"));
                return this;
            }

            public final Builder addOptionCombinations(Expression.MultiOrListRecord ... elements) {
                for (Expression.MultiOrListRecord element : elements) {
                    this.optionCombinations.add(Objects.requireNonNull(element, "optionCombinations element"));
                }
                return this;
            }

            public final Builder optionCombinations(Iterable<? extends Expression.MultiOrListRecord> elements) {
                this.optionCombinations.clear();
                return this.addAllOptionCombinations(elements);
            }

            public final Builder addAllOptionCombinations(Iterable<? extends Expression.MultiOrListRecord> elements) {
                for (Expression.MultiOrListRecord multiOrListRecord : elements) {
                    this.optionCombinations.add(Objects.requireNonNull(multiOrListRecord, "optionCombinations element"));
                }
                return this;
            }

            public MultiOrList build() {
                return new MultiOrList(ImmutableExpression.createUnmodifiableList(true, this.conditions), ImmutableExpression.createUnmodifiableList(true, this.optionCombinations));
            }
        }
    }

    public static final class SingleOrList
    extends Expression.SingleOrList {
        private final Expression condition;
        private final List<Expression> options;

        private SingleOrList(Expression condition, List<Expression> options) {
            this.condition = condition;
            this.options = options;
        }

        @Override
        public Expression condition() {
            return this.condition;
        }

        @Override
        public List<Expression> options() {
            return this.options;
        }

        public final SingleOrList withCondition(Expression value) {
            if (this.condition == value) {
                return this;
            }
            Expression newValue = Objects.requireNonNull(value, "condition");
            return new SingleOrList(newValue, this.options);
        }

        public final SingleOrList withOptions(Expression ... elements) {
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(Arrays.asList(elements), true, false));
            return new SingleOrList(this.condition, newValue);
        }

        public final SingleOrList withOptions(Iterable<? extends Expression> elements) {
            if (this.options == elements) {
                return this;
            }
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(elements, true, false));
            return new SingleOrList(this.condition, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof SingleOrList && this.equalsByValue((SingleOrList)another);
        }

        private boolean equalsByValue(SingleOrList another) {
            return this.condition.equals(another.condition) && this.options.equals(another.options);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.condition.hashCode();
            h += (h << 5) + this.options.hashCode();
            return h;
        }

        public String toString() {
            return "SingleOrList{condition=" + this.condition + ", options=" + this.options + "}";
        }

        public static SingleOrList copyOf(Expression.SingleOrList instance) {
            if (instance instanceof SingleOrList) {
                return (SingleOrList)instance;
            }
            return SingleOrList.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_CONDITION = 1L;
            private long initBits = 1L;
            private Expression condition;
            private List<Expression> options = new ArrayList<Expression>();

            private Builder() {
            }

            public final Builder from(Expression.SingleOrList instance) {
                Objects.requireNonNull(instance, "instance");
                this.condition(instance.condition());
                this.addAllOptions(instance.options());
                return this;
            }

            public final Builder condition(Expression condition) {
                this.condition = Objects.requireNonNull(condition, "condition");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder addOptions(Expression element) {
                this.options.add(Objects.requireNonNull(element, "options element"));
                return this;
            }

            public final Builder addOptions(Expression ... elements) {
                for (Expression element : elements) {
                    this.options.add(Objects.requireNonNull(element, "options element"));
                }
                return this;
            }

            public final Builder options(Iterable<? extends Expression> elements) {
                this.options.clear();
                return this.addAllOptions(elements);
            }

            public final Builder addAllOptions(Iterable<? extends Expression> elements) {
                for (Expression expression : elements) {
                    this.options.add(Objects.requireNonNull(expression, "options element"));
                }
                return this;
            }

            public SingleOrList build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new SingleOrList(this.condition, ImmutableExpression.createUnmodifiableList(true, this.options));
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("condition");
                }
                return "Cannot build SingleOrList, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class WindowFunctionInvocation
    extends Expression.WindowFunctionInvocation {
        private final SimpleExtension.WindowFunctionVariant declaration;
        private final List<FunctionArg> arguments;
        private final List<FunctionOption> options;
        private final Expression.AggregationPhase aggregationPhase;
        private final List<Expression> partitionBy;
        private final List<Expression.SortField> sort;
        private final Expression.WindowBoundsType boundsType;
        private final WindowBound lowerBound;
        private final WindowBound upperBound;
        private final Type outputType;
        private final Expression.AggregationInvocation invocation;

        private WindowFunctionInvocation(SimpleExtension.WindowFunctionVariant declaration, List<FunctionArg> arguments, List<FunctionOption> options, Expression.AggregationPhase aggregationPhase, List<Expression> partitionBy, List<Expression.SortField> sort, Expression.WindowBoundsType boundsType, WindowBound lowerBound, WindowBound upperBound, Type outputType, Expression.AggregationInvocation invocation) {
            this.declaration = declaration;
            this.arguments = arguments;
            this.options = options;
            this.aggregationPhase = aggregationPhase;
            this.partitionBy = partitionBy;
            this.sort = sort;
            this.boundsType = boundsType;
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
            this.outputType = outputType;
            this.invocation = invocation;
        }

        @Override
        public SimpleExtension.WindowFunctionVariant declaration() {
            return this.declaration;
        }

        @Override
        public List<FunctionArg> arguments() {
            return this.arguments;
        }

        @Override
        public List<FunctionOption> options() {
            return this.options;
        }

        @Override
        public Expression.AggregationPhase aggregationPhase() {
            return this.aggregationPhase;
        }

        @Override
        public List<Expression> partitionBy() {
            return this.partitionBy;
        }

        @Override
        public List<Expression.SortField> sort() {
            return this.sort;
        }

        @Override
        public Expression.WindowBoundsType boundsType() {
            return this.boundsType;
        }

        @Override
        public WindowBound lowerBound() {
            return this.lowerBound;
        }

        @Override
        public WindowBound upperBound() {
            return this.upperBound;
        }

        @Override
        public Type outputType() {
            return this.outputType;
        }

        @Override
        public Expression.AggregationInvocation invocation() {
            return this.invocation;
        }

        public final WindowFunctionInvocation withDeclaration(SimpleExtension.WindowFunctionVariant value) {
            if (this.declaration == value) {
                return this;
            }
            SimpleExtension.WindowFunctionVariant newValue = Objects.requireNonNull(value, "declaration");
            return WindowFunctionInvocation.validate(new WindowFunctionInvocation(newValue, this.arguments, this.options, this.aggregationPhase, this.partitionBy, this.sort, this.boundsType, this.lowerBound, this.upperBound, this.outputType, this.invocation));
        }

        public final WindowFunctionInvocation withArguments(FunctionArg ... elements) {
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(Arrays.asList(elements), true, false));
            return WindowFunctionInvocation.validate(new WindowFunctionInvocation(this.declaration, newValue, this.options, this.aggregationPhase, this.partitionBy, this.sort, this.boundsType, this.lowerBound, this.upperBound, this.outputType, this.invocation));
        }

        public final WindowFunctionInvocation withArguments(Iterable<? extends FunctionArg> elements) {
            if (this.arguments == elements) {
                return this;
            }
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(elements, true, false));
            return WindowFunctionInvocation.validate(new WindowFunctionInvocation(this.declaration, newValue, this.options, this.aggregationPhase, this.partitionBy, this.sort, this.boundsType, this.lowerBound, this.upperBound, this.outputType, this.invocation));
        }

        public final WindowFunctionInvocation withOptions(FunctionOption ... elements) {
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(Arrays.asList(elements), true, false));
            return WindowFunctionInvocation.validate(new WindowFunctionInvocation(this.declaration, this.arguments, newValue, this.aggregationPhase, this.partitionBy, this.sort, this.boundsType, this.lowerBound, this.upperBound, this.outputType, this.invocation));
        }

        public final WindowFunctionInvocation withOptions(Iterable<? extends FunctionOption> elements) {
            if (this.options == elements) {
                return this;
            }
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(elements, true, false));
            return WindowFunctionInvocation.validate(new WindowFunctionInvocation(this.declaration, this.arguments, newValue, this.aggregationPhase, this.partitionBy, this.sort, this.boundsType, this.lowerBound, this.upperBound, this.outputType, this.invocation));
        }

        public final WindowFunctionInvocation withAggregationPhase(Expression.AggregationPhase value) {
            Expression.AggregationPhase newValue = Objects.requireNonNull(value, "aggregationPhase");
            if (this.aggregationPhase == newValue) {
                return this;
            }
            return WindowFunctionInvocation.validate(new WindowFunctionInvocation(this.declaration, this.arguments, this.options, newValue, this.partitionBy, this.sort, this.boundsType, this.lowerBound, this.upperBound, this.outputType, this.invocation));
        }

        public final WindowFunctionInvocation withPartitionBy(Expression ... elements) {
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(Arrays.asList(elements), true, false));
            return WindowFunctionInvocation.validate(new WindowFunctionInvocation(this.declaration, this.arguments, this.options, this.aggregationPhase, newValue, this.sort, this.boundsType, this.lowerBound, this.upperBound, this.outputType, this.invocation));
        }

        public final WindowFunctionInvocation withPartitionBy(Iterable<? extends Expression> elements) {
            if (this.partitionBy == elements) {
                return this;
            }
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(elements, true, false));
            return WindowFunctionInvocation.validate(new WindowFunctionInvocation(this.declaration, this.arguments, this.options, this.aggregationPhase, newValue, this.sort, this.boundsType, this.lowerBound, this.upperBound, this.outputType, this.invocation));
        }

        public final WindowFunctionInvocation withSort(Expression.SortField ... elements) {
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(Arrays.asList(elements), true, false));
            return WindowFunctionInvocation.validate(new WindowFunctionInvocation(this.declaration, this.arguments, this.options, this.aggregationPhase, this.partitionBy, newValue, this.boundsType, this.lowerBound, this.upperBound, this.outputType, this.invocation));
        }

        public final WindowFunctionInvocation withSort(Iterable<? extends Expression.SortField> elements) {
            if (this.sort == elements) {
                return this;
            }
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(elements, true, false));
            return WindowFunctionInvocation.validate(new WindowFunctionInvocation(this.declaration, this.arguments, this.options, this.aggregationPhase, this.partitionBy, newValue, this.boundsType, this.lowerBound, this.upperBound, this.outputType, this.invocation));
        }

        public final WindowFunctionInvocation withBoundsType(Expression.WindowBoundsType value) {
            Expression.WindowBoundsType newValue = Objects.requireNonNull(value, "boundsType");
            if (this.boundsType == newValue) {
                return this;
            }
            return WindowFunctionInvocation.validate(new WindowFunctionInvocation(this.declaration, this.arguments, this.options, this.aggregationPhase, this.partitionBy, this.sort, newValue, this.lowerBound, this.upperBound, this.outputType, this.invocation));
        }

        public final WindowFunctionInvocation withLowerBound(WindowBound value) {
            if (this.lowerBound == value) {
                return this;
            }
            WindowBound newValue = Objects.requireNonNull(value, "lowerBound");
            return WindowFunctionInvocation.validate(new WindowFunctionInvocation(this.declaration, this.arguments, this.options, this.aggregationPhase, this.partitionBy, this.sort, this.boundsType, newValue, this.upperBound, this.outputType, this.invocation));
        }

        public final WindowFunctionInvocation withUpperBound(WindowBound value) {
            if (this.upperBound == value) {
                return this;
            }
            WindowBound newValue = Objects.requireNonNull(value, "upperBound");
            return WindowFunctionInvocation.validate(new WindowFunctionInvocation(this.declaration, this.arguments, this.options, this.aggregationPhase, this.partitionBy, this.sort, this.boundsType, this.lowerBound, newValue, this.outputType, this.invocation));
        }

        public final WindowFunctionInvocation withOutputType(Type value) {
            if (this.outputType == value) {
                return this;
            }
            Type newValue = Objects.requireNonNull(value, "outputType");
            return WindowFunctionInvocation.validate(new WindowFunctionInvocation(this.declaration, this.arguments, this.options, this.aggregationPhase, this.partitionBy, this.sort, this.boundsType, this.lowerBound, this.upperBound, newValue, this.invocation));
        }

        public final WindowFunctionInvocation withInvocation(Expression.AggregationInvocation value) {
            Expression.AggregationInvocation newValue = Objects.requireNonNull(value, "invocation");
            if (this.invocation == newValue) {
                return this;
            }
            return WindowFunctionInvocation.validate(new WindowFunctionInvocation(this.declaration, this.arguments, this.options, this.aggregationPhase, this.partitionBy, this.sort, this.boundsType, this.lowerBound, this.upperBound, this.outputType, newValue));
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof WindowFunctionInvocation && this.equalsByValue((WindowFunctionInvocation)another);
        }

        private boolean equalsByValue(WindowFunctionInvocation another) {
            return this.declaration.equals(another.declaration) && this.arguments.equals(another.arguments) && this.options.equals(another.options) && this.aggregationPhase.equals((Object)another.aggregationPhase) && this.partitionBy.equals(another.partitionBy) && this.sort.equals(another.sort) && this.boundsType.equals((Object)another.boundsType) && this.lowerBound.equals(another.lowerBound) && this.upperBound.equals(another.upperBound) && this.outputType.equals(another.outputType) && this.invocation.equals((Object)another.invocation);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.declaration.hashCode();
            h += (h << 5) + this.arguments.hashCode();
            h += (h << 5) + this.options.hashCode();
            h += (h << 5) + this.aggregationPhase.hashCode();
            h += (h << 5) + this.partitionBy.hashCode();
            h += (h << 5) + this.sort.hashCode();
            h += (h << 5) + this.boundsType.hashCode();
            h += (h << 5) + this.lowerBound.hashCode();
            h += (h << 5) + this.upperBound.hashCode();
            h += (h << 5) + this.outputType.hashCode();
            h += (h << 5) + this.invocation.hashCode();
            return h;
        }

        public String toString() {
            return "WindowFunctionInvocation{declaration=" + this.declaration + ", arguments=" + this.arguments + ", options=" + this.options + ", aggregationPhase=" + (Object)((Object)this.aggregationPhase) + ", partitionBy=" + this.partitionBy + ", sort=" + this.sort + ", boundsType=" + (Object)((Object)this.boundsType) + ", lowerBound=" + this.lowerBound + ", upperBound=" + this.upperBound + ", outputType=" + this.outputType + ", invocation=" + (Object)((Object)this.invocation) + "}";
        }

        private static WindowFunctionInvocation validate(WindowFunctionInvocation instance) {
            instance.check();
            return instance;
        }

        public static WindowFunctionInvocation copyOf(Expression.WindowFunctionInvocation instance) {
            if (instance instanceof WindowFunctionInvocation) {
                return (WindowFunctionInvocation)instance;
            }
            return WindowFunctionInvocation.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_DECLARATION = 1L;
            private static final long INIT_BIT_AGGREGATION_PHASE = 2L;
            private static final long INIT_BIT_BOUNDS_TYPE = 4L;
            private static final long INIT_BIT_LOWER_BOUND = 8L;
            private static final long INIT_BIT_UPPER_BOUND = 16L;
            private static final long INIT_BIT_OUTPUT_TYPE = 32L;
            private static final long INIT_BIT_INVOCATION = 64L;
            private long initBits = 127L;
            private SimpleExtension.WindowFunctionVariant declaration;
            private List<FunctionArg> arguments = new ArrayList<FunctionArg>();
            private List<FunctionOption> options = new ArrayList<FunctionOption>();
            private Expression.AggregationPhase aggregationPhase;
            private List<Expression> partitionBy = new ArrayList<Expression>();
            private List<Expression.SortField> sort = new ArrayList<Expression.SortField>();
            private Expression.WindowBoundsType boundsType;
            private WindowBound lowerBound;
            private WindowBound upperBound;
            private Type outputType;
            private Expression.AggregationInvocation invocation;

            private Builder() {
            }

            public final Builder from(Expression.WindowFunctionInvocation instance) {
                Objects.requireNonNull(instance, "instance");
                this.declaration(instance.declaration());
                this.addAllArguments(instance.arguments());
                this.addAllOptions(instance.options());
                this.aggregationPhase(instance.aggregationPhase());
                this.addAllPartitionBy(instance.partitionBy());
                this.addAllSort(instance.sort());
                this.boundsType(instance.boundsType());
                this.lowerBound(instance.lowerBound());
                this.upperBound(instance.upperBound());
                this.outputType(instance.outputType());
                this.invocation(instance.invocation());
                return this;
            }

            public final Builder declaration(SimpleExtension.WindowFunctionVariant declaration) {
                this.declaration = Objects.requireNonNull(declaration, "declaration");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder addArguments(FunctionArg element) {
                this.arguments.add(Objects.requireNonNull(element, "arguments element"));
                return this;
            }

            public final Builder addArguments(FunctionArg ... elements) {
                for (FunctionArg element : elements) {
                    this.arguments.add(Objects.requireNonNull(element, "arguments element"));
                }
                return this;
            }

            public final Builder arguments(Iterable<? extends FunctionArg> elements) {
                this.arguments.clear();
                return this.addAllArguments(elements);
            }

            public final Builder addAllArguments(Iterable<? extends FunctionArg> elements) {
                for (FunctionArg functionArg : elements) {
                    this.arguments.add(Objects.requireNonNull(functionArg, "arguments element"));
                }
                return this;
            }

            public final Builder addOptions(FunctionOption element) {
                this.options.add(Objects.requireNonNull(element, "options element"));
                return this;
            }

            public final Builder addOptions(FunctionOption ... elements) {
                for (FunctionOption element : elements) {
                    this.options.add(Objects.requireNonNull(element, "options element"));
                }
                return this;
            }

            public final Builder options(Iterable<? extends FunctionOption> elements) {
                this.options.clear();
                return this.addAllOptions(elements);
            }

            public final Builder addAllOptions(Iterable<? extends FunctionOption> elements) {
                for (FunctionOption functionOption : elements) {
                    this.options.add(Objects.requireNonNull(functionOption, "options element"));
                }
                return this;
            }

            public final Builder aggregationPhase(Expression.AggregationPhase aggregationPhase) {
                this.aggregationPhase = Objects.requireNonNull(aggregationPhase, "aggregationPhase");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public final Builder addPartitionBy(Expression element) {
                this.partitionBy.add(Objects.requireNonNull(element, "partitionBy element"));
                return this;
            }

            public final Builder addPartitionBy(Expression ... elements) {
                for (Expression element : elements) {
                    this.partitionBy.add(Objects.requireNonNull(element, "partitionBy element"));
                }
                return this;
            }

            public final Builder partitionBy(Iterable<? extends Expression> elements) {
                this.partitionBy.clear();
                return this.addAllPartitionBy(elements);
            }

            public final Builder addAllPartitionBy(Iterable<? extends Expression> elements) {
                for (Expression expression : elements) {
                    this.partitionBy.add(Objects.requireNonNull(expression, "partitionBy element"));
                }
                return this;
            }

            public final Builder addSort(Expression.SortField element) {
                this.sort.add(Objects.requireNonNull(element, "sort element"));
                return this;
            }

            public final Builder addSort(Expression.SortField ... elements) {
                for (Expression.SortField element : elements) {
                    this.sort.add(Objects.requireNonNull(element, "sort element"));
                }
                return this;
            }

            public final Builder sort(Iterable<? extends Expression.SortField> elements) {
                this.sort.clear();
                return this.addAllSort(elements);
            }

            public final Builder addAllSort(Iterable<? extends Expression.SortField> elements) {
                for (Expression.SortField sortField : elements) {
                    this.sort.add(Objects.requireNonNull(sortField, "sort element"));
                }
                return this;
            }

            public final Builder boundsType(Expression.WindowBoundsType boundsType) {
                this.boundsType = Objects.requireNonNull(boundsType, "boundsType");
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            public final Builder lowerBound(WindowBound lowerBound) {
                this.lowerBound = Objects.requireNonNull(lowerBound, "lowerBound");
                this.initBits &= 0xFFFFFFFFFFFFFFF7L;
                return this;
            }

            public final Builder upperBound(WindowBound upperBound) {
                this.upperBound = Objects.requireNonNull(upperBound, "upperBound");
                this.initBits &= 0xFFFFFFFFFFFFFFEFL;
                return this;
            }

            public final Builder outputType(Type outputType) {
                this.outputType = Objects.requireNonNull(outputType, "outputType");
                this.initBits &= 0xFFFFFFFFFFFFFFDFL;
                return this;
            }

            public final Builder invocation(Expression.AggregationInvocation invocation) {
                this.invocation = Objects.requireNonNull(invocation, "invocation");
                this.initBits &= 0xFFFFFFFFFFFFFFBFL;
                return this;
            }

            public WindowFunctionInvocation build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return WindowFunctionInvocation.validate(new WindowFunctionInvocation(this.declaration, ImmutableExpression.createUnmodifiableList(true, this.arguments), ImmutableExpression.createUnmodifiableList(true, this.options), this.aggregationPhase, ImmutableExpression.createUnmodifiableList(true, this.partitionBy), ImmutableExpression.createUnmodifiableList(true, this.sort), this.boundsType, this.lowerBound, this.upperBound, this.outputType, this.invocation));
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("declaration");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("aggregationPhase");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("boundsType");
                }
                if ((this.initBits & 8L) != 0L) {
                    attributes.add("lowerBound");
                }
                if ((this.initBits & 0x10L) != 0L) {
                    attributes.add("upperBound");
                }
                if ((this.initBits & 0x20L) != 0L) {
                    attributes.add("outputType");
                }
                if ((this.initBits & 0x40L) != 0L) {
                    attributes.add("invocation");
                }
                return "Cannot build WindowFunctionInvocation, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class ScalarFunctionInvocation
    extends Expression.ScalarFunctionInvocation {
        private final SimpleExtension.ScalarFunctionVariant declaration;
        private final List<FunctionArg> arguments;
        private final List<FunctionOption> options;
        private final Type outputType;

        private ScalarFunctionInvocation(SimpleExtension.ScalarFunctionVariant declaration, List<FunctionArg> arguments, List<FunctionOption> options, Type outputType) {
            this.declaration = declaration;
            this.arguments = arguments;
            this.options = options;
            this.outputType = outputType;
        }

        @Override
        public SimpleExtension.ScalarFunctionVariant declaration() {
            return this.declaration;
        }

        @Override
        public List<FunctionArg> arguments() {
            return this.arguments;
        }

        @Override
        public List<FunctionOption> options() {
            return this.options;
        }

        @Override
        public Type outputType() {
            return this.outputType;
        }

        public final ScalarFunctionInvocation withDeclaration(SimpleExtension.ScalarFunctionVariant value) {
            if (this.declaration == value) {
                return this;
            }
            SimpleExtension.ScalarFunctionVariant newValue = Objects.requireNonNull(value, "declaration");
            return ScalarFunctionInvocation.validate(new ScalarFunctionInvocation(newValue, this.arguments, this.options, this.outputType));
        }

        public final ScalarFunctionInvocation withArguments(FunctionArg ... elements) {
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(Arrays.asList(elements), true, false));
            return ScalarFunctionInvocation.validate(new ScalarFunctionInvocation(this.declaration, newValue, this.options, this.outputType));
        }

        public final ScalarFunctionInvocation withArguments(Iterable<? extends FunctionArg> elements) {
            if (this.arguments == elements) {
                return this;
            }
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(elements, true, false));
            return ScalarFunctionInvocation.validate(new ScalarFunctionInvocation(this.declaration, newValue, this.options, this.outputType));
        }

        public final ScalarFunctionInvocation withOptions(FunctionOption ... elements) {
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(Arrays.asList(elements), true, false));
            return ScalarFunctionInvocation.validate(new ScalarFunctionInvocation(this.declaration, this.arguments, newValue, this.outputType));
        }

        public final ScalarFunctionInvocation withOptions(Iterable<? extends FunctionOption> elements) {
            if (this.options == elements) {
                return this;
            }
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(elements, true, false));
            return ScalarFunctionInvocation.validate(new ScalarFunctionInvocation(this.declaration, this.arguments, newValue, this.outputType));
        }

        public final ScalarFunctionInvocation withOutputType(Type value) {
            if (this.outputType == value) {
                return this;
            }
            Type newValue = Objects.requireNonNull(value, "outputType");
            return ScalarFunctionInvocation.validate(new ScalarFunctionInvocation(this.declaration, this.arguments, this.options, newValue));
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ScalarFunctionInvocation && this.equalsByValue((ScalarFunctionInvocation)another);
        }

        private boolean equalsByValue(ScalarFunctionInvocation another) {
            return this.declaration.equals(another.declaration) && this.arguments.equals(another.arguments) && this.options.equals(another.options) && this.outputType.equals(another.outputType);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.declaration.hashCode();
            h += (h << 5) + this.arguments.hashCode();
            h += (h << 5) + this.options.hashCode();
            h += (h << 5) + this.outputType.hashCode();
            return h;
        }

        public String toString() {
            return "ScalarFunctionInvocation{declaration=" + this.declaration + ", arguments=" + this.arguments + ", options=" + this.options + ", outputType=" + this.outputType + "}";
        }

        private static ScalarFunctionInvocation validate(ScalarFunctionInvocation instance) {
            instance.check();
            return instance;
        }

        public static ScalarFunctionInvocation copyOf(Expression.ScalarFunctionInvocation instance) {
            if (instance instanceof ScalarFunctionInvocation) {
                return (ScalarFunctionInvocation)instance;
            }
            return ScalarFunctionInvocation.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_DECLARATION = 1L;
            private static final long INIT_BIT_OUTPUT_TYPE = 2L;
            private long initBits = 3L;
            private SimpleExtension.ScalarFunctionVariant declaration;
            private List<FunctionArg> arguments = new ArrayList<FunctionArg>();
            private List<FunctionOption> options = new ArrayList<FunctionOption>();
            private Type outputType;

            private Builder() {
            }

            public final Builder from(Expression.ScalarFunctionInvocation instance) {
                Objects.requireNonNull(instance, "instance");
                this.declaration(instance.declaration());
                this.addAllArguments(instance.arguments());
                this.addAllOptions(instance.options());
                this.outputType(instance.outputType());
                return this;
            }

            public final Builder declaration(SimpleExtension.ScalarFunctionVariant declaration) {
                this.declaration = Objects.requireNonNull(declaration, "declaration");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder addArguments(FunctionArg element) {
                this.arguments.add(Objects.requireNonNull(element, "arguments element"));
                return this;
            }

            public final Builder addArguments(FunctionArg ... elements) {
                for (FunctionArg element : elements) {
                    this.arguments.add(Objects.requireNonNull(element, "arguments element"));
                }
                return this;
            }

            public final Builder arguments(Iterable<? extends FunctionArg> elements) {
                this.arguments.clear();
                return this.addAllArguments(elements);
            }

            public final Builder addAllArguments(Iterable<? extends FunctionArg> elements) {
                for (FunctionArg functionArg : elements) {
                    this.arguments.add(Objects.requireNonNull(functionArg, "arguments element"));
                }
                return this;
            }

            public final Builder addOptions(FunctionOption element) {
                this.options.add(Objects.requireNonNull(element, "options element"));
                return this;
            }

            public final Builder addOptions(FunctionOption ... elements) {
                for (FunctionOption element : elements) {
                    this.options.add(Objects.requireNonNull(element, "options element"));
                }
                return this;
            }

            public final Builder options(Iterable<? extends FunctionOption> elements) {
                this.options.clear();
                return this.addAllOptions(elements);
            }

            public final Builder addAllOptions(Iterable<? extends FunctionOption> elements) {
                for (FunctionOption functionOption : elements) {
                    this.options.add(Objects.requireNonNull(functionOption, "options element"));
                }
                return this;
            }

            public final Builder outputType(Type outputType) {
                this.outputType = Objects.requireNonNull(outputType, "outputType");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public ScalarFunctionInvocation build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return ScalarFunctionInvocation.validate(new ScalarFunctionInvocation(this.declaration, ImmutableExpression.createUnmodifiableList(true, this.arguments), ImmutableExpression.createUnmodifiableList(true, this.options), this.outputType));
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("declaration");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("outputType");
                }
                return "Cannot build ScalarFunctionInvocation, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class Cast
    extends Expression.Cast {
        private final Type type;
        private final Expression input;
        private final Expression.FailureBehavior failureBehavior;

        private Cast(Type type, Expression input, Expression.FailureBehavior failureBehavior) {
            this.type = type;
            this.input = input;
            this.failureBehavior = failureBehavior;
        }

        @Override
        public Type type() {
            return this.type;
        }

        @Override
        public Expression input() {
            return this.input;
        }

        @Override
        public Expression.FailureBehavior failureBehavior() {
            return this.failureBehavior;
        }

        public final Cast withType(Type value) {
            if (this.type == value) {
                return this;
            }
            Type newValue = Objects.requireNonNull(value, "type");
            return new Cast(newValue, this.input, this.failureBehavior);
        }

        public final Cast withInput(Expression value) {
            if (this.input == value) {
                return this;
            }
            Expression newValue = Objects.requireNonNull(value, "input");
            return new Cast(this.type, newValue, this.failureBehavior);
        }

        public final Cast withFailureBehavior(Expression.FailureBehavior value) {
            Expression.FailureBehavior newValue = Objects.requireNonNull(value, "failureBehavior");
            if (this.failureBehavior == newValue) {
                return this;
            }
            return new Cast(this.type, this.input, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Cast && this.equalsByValue((Cast)another);
        }

        private boolean equalsByValue(Cast another) {
            return this.type.equals(another.type) && this.input.equals(another.input) && this.failureBehavior.equals((Object)another.failureBehavior);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.type.hashCode();
            h += (h << 5) + this.input.hashCode();
            h += (h << 5) + this.failureBehavior.hashCode();
            return h;
        }

        public String toString() {
            return "Cast{type=" + this.type + ", input=" + this.input + ", failureBehavior=" + (Object)((Object)this.failureBehavior) + "}";
        }

        public static Cast copyOf(Expression.Cast instance) {
            if (instance instanceof Cast) {
                return (Cast)instance;
            }
            return Cast.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_TYPE = 1L;
            private static final long INIT_BIT_INPUT = 2L;
            private static final long INIT_BIT_FAILURE_BEHAVIOR = 4L;
            private long initBits = 7L;
            private Type type;
            private Expression input;
            private Expression.FailureBehavior failureBehavior;

            private Builder() {
            }

            public final Builder from(Expression.Cast instance) {
                Objects.requireNonNull(instance, "instance");
                this.type(instance.type());
                this.input(instance.input());
                this.failureBehavior(instance.failureBehavior());
                return this;
            }

            public final Builder type(Type type) {
                this.type = Objects.requireNonNull(type, "type");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder input(Expression input) {
                this.input = Objects.requireNonNull(input, "input");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public final Builder failureBehavior(Expression.FailureBehavior failureBehavior) {
                this.failureBehavior = Objects.requireNonNull(failureBehavior, "failureBehavior");
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            public Cast build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Cast(this.type, this.input, this.failureBehavior);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("type");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("input");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("failureBehavior");
                }
                return "Cannot build Cast, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class IfClause
    extends Expression.IfClause {
        private final Expression condition;
        private final Expression then;

        private IfClause(Expression condition, Expression then) {
            this.condition = condition;
            this.then = then;
        }

        @Override
        public Expression condition() {
            return this.condition;
        }

        @Override
        public Expression then() {
            return this.then;
        }

        public final IfClause withCondition(Expression value) {
            if (this.condition == value) {
                return this;
            }
            Expression newValue = Objects.requireNonNull(value, "condition");
            return new IfClause(newValue, this.then);
        }

        public final IfClause withThen(Expression value) {
            if (this.then == value) {
                return this;
            }
            Expression newValue = Objects.requireNonNull(value, "then");
            return new IfClause(this.condition, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof IfClause && this.equalsByValue((IfClause)another);
        }

        private boolean equalsByValue(IfClause another) {
            return this.condition.equals(another.condition) && this.then.equals(another.then);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.condition.hashCode();
            h += (h << 5) + this.then.hashCode();
            return h;
        }

        public String toString() {
            return "IfClause{condition=" + this.condition + ", then=" + this.then + "}";
        }

        public static IfClause copyOf(Expression.IfClause instance) {
            if (instance instanceof IfClause) {
                return (IfClause)instance;
            }
            return IfClause.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_CONDITION = 1L;
            private static final long INIT_BIT_THEN = 2L;
            private long initBits = 3L;
            private Expression condition;
            private Expression then;

            private Builder() {
            }

            public final Builder from(Expression.IfClause instance) {
                Objects.requireNonNull(instance, "instance");
                this.condition(instance.condition());
                this.then(instance.then());
                return this;
            }

            public final Builder condition(Expression condition) {
                this.condition = Objects.requireNonNull(condition, "condition");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder then(Expression then) {
                this.then = Objects.requireNonNull(then, "then");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public IfClause build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new IfClause(this.condition, this.then);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("condition");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("then");
                }
                return "Cannot build IfClause, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class IfThen
    extends Expression.IfThen {
        private final List<Expression.IfClause> ifClauses;
        private final Expression elseClause;

        private IfThen(List<Expression.IfClause> ifClauses, Expression elseClause) {
            this.ifClauses = ifClauses;
            this.elseClause = elseClause;
        }

        @Override
        public List<Expression.IfClause> ifClauses() {
            return this.ifClauses;
        }

        @Override
        public Expression elseClause() {
            return this.elseClause;
        }

        public final IfThen withIfClauses(Expression.IfClause ... elements) {
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(Arrays.asList(elements), true, false));
            return new IfThen(newValue, this.elseClause);
        }

        public final IfThen withIfClauses(Iterable<? extends Expression.IfClause> elements) {
            if (this.ifClauses == elements) {
                return this;
            }
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(elements, true, false));
            return new IfThen(newValue, this.elseClause);
        }

        public final IfThen withElseClause(Expression value) {
            if (this.elseClause == value) {
                return this;
            }
            Expression newValue = Objects.requireNonNull(value, "elseClause");
            return new IfThen(this.ifClauses, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof IfThen && this.equalsByValue((IfThen)another);
        }

        private boolean equalsByValue(IfThen another) {
            return this.ifClauses.equals(another.ifClauses) && this.elseClause.equals(another.elseClause);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.ifClauses.hashCode();
            h += (h << 5) + this.elseClause.hashCode();
            return h;
        }

        public String toString() {
            return "IfThen{ifClauses=" + this.ifClauses + ", elseClause=" + this.elseClause + "}";
        }

        public static IfThen copyOf(Expression.IfThen instance) {
            if (instance instanceof IfThen) {
                return (IfThen)instance;
            }
            return IfThen.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_ELSE_CLAUSE = 1L;
            private long initBits = 1L;
            private List<Expression.IfClause> ifClauses = new ArrayList<Expression.IfClause>();
            private Expression elseClause;

            private Builder() {
            }

            public final Builder from(Expression.IfThen instance) {
                Objects.requireNonNull(instance, "instance");
                this.addAllIfClauses(instance.ifClauses());
                this.elseClause(instance.elseClause());
                return this;
            }

            public final Builder addIfClauses(Expression.IfClause element) {
                this.ifClauses.add(Objects.requireNonNull(element, "ifClauses element"));
                return this;
            }

            public final Builder addIfClauses(Expression.IfClause ... elements) {
                for (Expression.IfClause element : elements) {
                    this.ifClauses.add(Objects.requireNonNull(element, "ifClauses element"));
                }
                return this;
            }

            public final Builder ifClauses(Iterable<? extends Expression.IfClause> elements) {
                this.ifClauses.clear();
                return this.addAllIfClauses(elements);
            }

            public final Builder addAllIfClauses(Iterable<? extends Expression.IfClause> elements) {
                for (Expression.IfClause ifClause : elements) {
                    this.ifClauses.add(Objects.requireNonNull(ifClause, "ifClauses element"));
                }
                return this;
            }

            public final Builder elseClause(Expression elseClause) {
                this.elseClause = Objects.requireNonNull(elseClause, "elseClause");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public IfThen build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new IfThen(ImmutableExpression.createUnmodifiableList(true, this.ifClauses), this.elseClause);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("elseClause");
                }
                return "Cannot build IfThen, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class SwitchClause
    extends Expression.SwitchClause {
        private final Expression.Literal condition;
        private final Expression then;

        private SwitchClause(Expression.Literal condition, Expression then) {
            this.condition = condition;
            this.then = then;
        }

        @Override
        public Expression.Literal condition() {
            return this.condition;
        }

        @Override
        public Expression then() {
            return this.then;
        }

        public final SwitchClause withCondition(Expression.Literal value) {
            if (this.condition == value) {
                return this;
            }
            Expression.Literal newValue = Objects.requireNonNull(value, "condition");
            return new SwitchClause(newValue, this.then);
        }

        public final SwitchClause withThen(Expression value) {
            if (this.then == value) {
                return this;
            }
            Expression newValue = Objects.requireNonNull(value, "then");
            return new SwitchClause(this.condition, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof SwitchClause && this.equalsByValue((SwitchClause)another);
        }

        private boolean equalsByValue(SwitchClause another) {
            return this.condition.equals(another.condition) && this.then.equals(another.then);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.condition.hashCode();
            h += (h << 5) + this.then.hashCode();
            return h;
        }

        public String toString() {
            return "SwitchClause{condition=" + this.condition + ", then=" + this.then + "}";
        }

        public static SwitchClause copyOf(Expression.SwitchClause instance) {
            if (instance instanceof SwitchClause) {
                return (SwitchClause)instance;
            }
            return SwitchClause.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_CONDITION = 1L;
            private static final long INIT_BIT_THEN = 2L;
            private long initBits = 3L;
            private Expression.Literal condition;
            private Expression then;

            private Builder() {
            }

            public final Builder from(Expression.SwitchClause instance) {
                Objects.requireNonNull(instance, "instance");
                this.condition(instance.condition());
                this.then(instance.then());
                return this;
            }

            public final Builder condition(Expression.Literal condition) {
                this.condition = Objects.requireNonNull(condition, "condition");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder then(Expression then) {
                this.then = Objects.requireNonNull(then, "then");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public SwitchClause build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new SwitchClause(this.condition, this.then);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("condition");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("then");
                }
                return "Cannot build SwitchClause, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class Switch
    extends Expression.Switch {
        private final Expression match;
        private final List<Expression.SwitchClause> switchClauses;
        private final Expression defaultClause;

        private Switch(Expression match, List<Expression.SwitchClause> switchClauses, Expression defaultClause) {
            this.match = match;
            this.switchClauses = switchClauses;
            this.defaultClause = defaultClause;
        }

        @Override
        public Expression match() {
            return this.match;
        }

        @Override
        public List<Expression.SwitchClause> switchClauses() {
            return this.switchClauses;
        }

        @Override
        public Expression defaultClause() {
            return this.defaultClause;
        }

        public final Switch withMatch(Expression value) {
            if (this.match == value) {
                return this;
            }
            Expression newValue = Objects.requireNonNull(value, "match");
            return new Switch(newValue, this.switchClauses, this.defaultClause);
        }

        public final Switch withSwitchClauses(Expression.SwitchClause ... elements) {
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(Arrays.asList(elements), true, false));
            return new Switch(this.match, newValue, this.defaultClause);
        }

        public final Switch withSwitchClauses(Iterable<? extends Expression.SwitchClause> elements) {
            if (this.switchClauses == elements) {
                return this;
            }
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(elements, true, false));
            return new Switch(this.match, newValue, this.defaultClause);
        }

        public final Switch withDefaultClause(Expression value) {
            if (this.defaultClause == value) {
                return this;
            }
            Expression newValue = Objects.requireNonNull(value, "defaultClause");
            return new Switch(this.match, this.switchClauses, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Switch && this.equalsByValue((Switch)another);
        }

        private boolean equalsByValue(Switch another) {
            return this.match.equals(another.match) && this.switchClauses.equals(another.switchClauses) && this.defaultClause.equals(another.defaultClause);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.match.hashCode();
            h += (h << 5) + this.switchClauses.hashCode();
            h += (h << 5) + this.defaultClause.hashCode();
            return h;
        }

        public String toString() {
            return "Switch{match=" + this.match + ", switchClauses=" + this.switchClauses + ", defaultClause=" + this.defaultClause + "}";
        }

        public static Switch copyOf(Expression.Switch instance) {
            if (instance instanceof Switch) {
                return (Switch)instance;
            }
            return Switch.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_MATCH = 1L;
            private static final long INIT_BIT_DEFAULT_CLAUSE = 2L;
            private long initBits = 3L;
            private Expression match;
            private List<Expression.SwitchClause> switchClauses = new ArrayList<Expression.SwitchClause>();
            private Expression defaultClause;

            private Builder() {
            }

            public final Builder from(Expression.Switch instance) {
                Objects.requireNonNull(instance, "instance");
                this.match(instance.match());
                this.addAllSwitchClauses(instance.switchClauses());
                this.defaultClause(instance.defaultClause());
                return this;
            }

            public final Builder match(Expression match) {
                this.match = Objects.requireNonNull(match, "match");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder addSwitchClauses(Expression.SwitchClause element) {
                this.switchClauses.add(Objects.requireNonNull(element, "switchClauses element"));
                return this;
            }

            public final Builder addSwitchClauses(Expression.SwitchClause ... elements) {
                for (Expression.SwitchClause element : elements) {
                    this.switchClauses.add(Objects.requireNonNull(element, "switchClauses element"));
                }
                return this;
            }

            public final Builder switchClauses(Iterable<? extends Expression.SwitchClause> elements) {
                this.switchClauses.clear();
                return this.addAllSwitchClauses(elements);
            }

            public final Builder addAllSwitchClauses(Iterable<? extends Expression.SwitchClause> elements) {
                for (Expression.SwitchClause switchClause : elements) {
                    this.switchClauses.add(Objects.requireNonNull(switchClause, "switchClauses element"));
                }
                return this;
            }

            public final Builder defaultClause(Expression defaultClause) {
                this.defaultClause = Objects.requireNonNull(defaultClause, "defaultClause");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public Switch build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Switch(this.match, ImmutableExpression.createUnmodifiableList(true, this.switchClauses), this.defaultClause);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("match");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("defaultClause");
                }
                return "Cannot build Switch, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class UserDefinedStructLiteral
    extends Expression.UserDefinedStructLiteral {
        private final boolean nullable;
        private final String urn;
        private final String name;
        private final List<Type.Parameter> typeParameters;
        private final List<Expression.Literal> fields;

        private UserDefinedStructLiteral(Builder builder) {
            this.urn = builder.urn;
            this.name = builder.name;
            this.typeParameters = ImmutableExpression.createUnmodifiableList(true, builder.typeParameters);
            this.fields = ImmutableExpression.createUnmodifiableList(true, builder.fields);
            this.nullable = builder.nullableIsSet() ? builder.nullable : super.nullable();
        }

        private UserDefinedStructLiteral(boolean nullable, String urn, String name, List<Type.Parameter> typeParameters, List<Expression.Literal> fields) {
            this.nullable = nullable;
            this.urn = urn;
            this.name = name;
            this.typeParameters = typeParameters;
            this.fields = fields;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public String urn() {
            return this.urn;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public List<Type.Parameter> typeParameters() {
            return this.typeParameters;
        }

        @Override
        public List<Expression.Literal> fields() {
            return this.fields;
        }

        public final UserDefinedStructLiteral withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new UserDefinedStructLiteral(value, this.urn, this.name, this.typeParameters, this.fields);
        }

        public final UserDefinedStructLiteral withUrn(String value) {
            String newValue = Objects.requireNonNull(value, "urn");
            if (this.urn.equals(newValue)) {
                return this;
            }
            return new UserDefinedStructLiteral(this.nullable, newValue, this.name, this.typeParameters, this.fields);
        }

        public final UserDefinedStructLiteral withName(String value) {
            String newValue = Objects.requireNonNull(value, "name");
            if (this.name.equals(newValue)) {
                return this;
            }
            return new UserDefinedStructLiteral(this.nullable, this.urn, newValue, this.typeParameters, this.fields);
        }

        public final UserDefinedStructLiteral withTypeParameters(Type.Parameter ... elements) {
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(Arrays.asList(elements), true, false));
            return new UserDefinedStructLiteral(this.nullable, this.urn, this.name, newValue, this.fields);
        }

        public final UserDefinedStructLiteral withTypeParameters(Iterable<? extends Type.Parameter> elements) {
            if (this.typeParameters == elements) {
                return this;
            }
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(elements, true, false));
            return new UserDefinedStructLiteral(this.nullable, this.urn, this.name, newValue, this.fields);
        }

        public final UserDefinedStructLiteral withFields(Expression.Literal ... elements) {
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(Arrays.asList(elements), true, false));
            return new UserDefinedStructLiteral(this.nullable, this.urn, this.name, this.typeParameters, newValue);
        }

        public final UserDefinedStructLiteral withFields(Iterable<? extends Expression.Literal> elements) {
            if (this.fields == elements) {
                return this;
            }
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(elements, true, false));
            return new UserDefinedStructLiteral(this.nullable, this.urn, this.name, this.typeParameters, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof UserDefinedStructLiteral && this.equalsByValue((UserDefinedStructLiteral)another);
        }

        private boolean equalsByValue(UserDefinedStructLiteral another) {
            return this.nullable == another.nullable && this.urn.equals(another.urn) && this.name.equals(another.name) && this.typeParameters.equals(another.typeParameters) && this.fields.equals(another.fields);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.urn.hashCode();
            h += (h << 5) + this.name.hashCode();
            h += (h << 5) + this.typeParameters.hashCode();
            h += (h << 5) + this.fields.hashCode();
            return h;
        }

        public String toString() {
            return "UserDefinedStructLiteral{nullable=" + this.nullable + ", urn=" + this.urn + ", name=" + this.name + ", typeParameters=" + this.typeParameters + ", fields=" + this.fields + "}";
        }

        public static UserDefinedStructLiteral copyOf(Expression.UserDefinedStructLiteral instance) {
            if (instance instanceof UserDefinedStructLiteral) {
                return (UserDefinedStructLiteral)instance;
            }
            return UserDefinedStructLiteral.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_URN = 1L;
            private static final long INIT_BIT_NAME = 2L;
            private static final long OPT_BIT_NULLABLE = 1L;
            private long initBits = 3L;
            private long optBits;
            private boolean nullable;
            private String urn;
            private String name;
            private List<Type.Parameter> typeParameters = new ArrayList<Type.Parameter>();
            private List<Expression.Literal> fields = new ArrayList<Expression.Literal>();

            private Builder() {
            }

            public final Builder from(Expression.UserDefinedStructLiteral instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression.Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression.UserDefinedLiteral instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                Expression.Literal instance;
                long bits = 0L;
                if (object instanceof Expression.UserDefinedStructLiteral) {
                    instance = (Expression.UserDefinedStructLiteral)object;
                    if ((bits & 4L) == 0L) {
                        this.urn(((Expression.UserDefinedStructLiteral)instance).urn());
                        bits |= 4L;
                    }
                    if ((bits & 8L) == 0L) {
                        this.name(((Expression.UserDefinedStructLiteral)instance).name());
                        bits |= 8L;
                    }
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.addAllFields(((Expression.UserDefinedStructLiteral)instance).fields());
                    if ((bits & 2L) == 0L) {
                        this.addAllTypeParameters(((Expression.UserDefinedStructLiteral)instance).typeParameters());
                        bits |= 2L;
                    }
                }
                if (object instanceof Expression.Literal) {
                    instance = (Expression.Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Expression.UserDefinedLiteral) {
                    instance = (Expression.UserDefinedLiteral)object;
                    if ((bits & 4L) == 0L) {
                        this.urn(instance.urn());
                        bits |= 4L;
                    }
                    if ((bits & 8L) == 0L) {
                        this.name(instance.name());
                        bits |= 8L;
                    }
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.addAllTypeParameters(instance.typeParameters());
                        bits |= 2L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.optBits |= 1L;
                return this;
            }

            public final Builder urn(String urn) {
                this.urn = Objects.requireNonNull(urn, "urn");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder name(String name) {
                this.name = Objects.requireNonNull(name, "name");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public final Builder addTypeParameters(Type.Parameter element) {
                this.typeParameters.add(Objects.requireNonNull(element, "typeParameters element"));
                return this;
            }

            public final Builder addTypeParameters(Type.Parameter ... elements) {
                for (Type.Parameter element : elements) {
                    this.typeParameters.add(Objects.requireNonNull(element, "typeParameters element"));
                }
                return this;
            }

            public final Builder typeParameters(Iterable<? extends Type.Parameter> elements) {
                this.typeParameters.clear();
                return this.addAllTypeParameters(elements);
            }

            public final Builder addAllTypeParameters(Iterable<? extends Type.Parameter> elements) {
                for (Type.Parameter parameter : elements) {
                    this.typeParameters.add(Objects.requireNonNull(parameter, "typeParameters element"));
                }
                return this;
            }

            public final Builder addFields(Expression.Literal element) {
                this.fields.add(Objects.requireNonNull(element, "fields element"));
                return this;
            }

            public final Builder addFields(Expression.Literal ... elements) {
                for (Expression.Literal element : elements) {
                    this.fields.add(Objects.requireNonNull(element, "fields element"));
                }
                return this;
            }

            public final Builder fields(Iterable<? extends Expression.Literal> elements) {
                this.fields.clear();
                return this.addAllFields(elements);
            }

            public final Builder addAllFields(Iterable<? extends Expression.Literal> elements) {
                for (Expression.Literal literal : elements) {
                    this.fields.add(Objects.requireNonNull(literal, "fields element"));
                }
                return this;
            }

            public UserDefinedStructLiteral build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new UserDefinedStructLiteral(this);
            }

            private boolean nullableIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("urn");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("name");
                }
                return "Cannot build UserDefinedStructLiteral, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class UserDefinedAnyLiteral
    extends Expression.UserDefinedAnyLiteral {
        private final boolean nullable;
        private final String urn;
        private final String name;
        private final List<Type.Parameter> typeParameters;
        private final Any value;

        private UserDefinedAnyLiteral(Builder builder) {
            this.urn = builder.urn;
            this.name = builder.name;
            this.typeParameters = ImmutableExpression.createUnmodifiableList(true, builder.typeParameters);
            this.value = builder.value;
            this.nullable = builder.nullableIsSet() ? builder.nullable : super.nullable();
        }

        private UserDefinedAnyLiteral(boolean nullable, String urn, String name, List<Type.Parameter> typeParameters, Any value) {
            this.nullable = nullable;
            this.urn = urn;
            this.name = name;
            this.typeParameters = typeParameters;
            this.value = value;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public String urn() {
            return this.urn;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public List<Type.Parameter> typeParameters() {
            return this.typeParameters;
        }

        @Override
        public Any value() {
            return this.value;
        }

        public final UserDefinedAnyLiteral withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new UserDefinedAnyLiteral(value, this.urn, this.name, this.typeParameters, this.value);
        }

        public final UserDefinedAnyLiteral withUrn(String value) {
            String newValue = Objects.requireNonNull(value, "urn");
            if (this.urn.equals(newValue)) {
                return this;
            }
            return new UserDefinedAnyLiteral(this.nullable, newValue, this.name, this.typeParameters, this.value);
        }

        public final UserDefinedAnyLiteral withName(String value) {
            String newValue = Objects.requireNonNull(value, "name");
            if (this.name.equals(newValue)) {
                return this;
            }
            return new UserDefinedAnyLiteral(this.nullable, this.urn, newValue, this.typeParameters, this.value);
        }

        public final UserDefinedAnyLiteral withTypeParameters(Type.Parameter ... elements) {
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(Arrays.asList(elements), true, false));
            return new UserDefinedAnyLiteral(this.nullable, this.urn, this.name, newValue, this.value);
        }

        public final UserDefinedAnyLiteral withTypeParameters(Iterable<? extends Type.Parameter> elements) {
            if (this.typeParameters == elements) {
                return this;
            }
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(elements, true, false));
            return new UserDefinedAnyLiteral(this.nullable, this.urn, this.name, newValue, this.value);
        }

        public final UserDefinedAnyLiteral withValue(Any value) {
            if (this.value == value) {
                return this;
            }
            Any newValue = Objects.requireNonNull(value, "value");
            return new UserDefinedAnyLiteral(this.nullable, this.urn, this.name, this.typeParameters, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof UserDefinedAnyLiteral && this.equalsByValue((UserDefinedAnyLiteral)another);
        }

        private boolean equalsByValue(UserDefinedAnyLiteral another) {
            return this.nullable == another.nullable && this.urn.equals(another.urn) && this.name.equals(another.name) && this.typeParameters.equals(another.typeParameters) && this.value.equals((Object)another.value);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.urn.hashCode();
            h += (h << 5) + this.name.hashCode();
            h += (h << 5) + this.typeParameters.hashCode();
            h += (h << 5) + this.value.hashCode();
            return h;
        }

        public String toString() {
            return "UserDefinedAnyLiteral{nullable=" + this.nullable + ", urn=" + this.urn + ", name=" + this.name + ", typeParameters=" + this.typeParameters + ", value=" + this.value + "}";
        }

        public static UserDefinedAnyLiteral copyOf(Expression.UserDefinedAnyLiteral instance) {
            if (instance instanceof UserDefinedAnyLiteral) {
                return (UserDefinedAnyLiteral)instance;
            }
            return UserDefinedAnyLiteral.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_URN = 1L;
            private static final long INIT_BIT_NAME = 2L;
            private static final long INIT_BIT_VALUE = 4L;
            private static final long OPT_BIT_NULLABLE = 1L;
            private long initBits = 7L;
            private long optBits;
            private boolean nullable;
            private String urn;
            private String name;
            private List<Type.Parameter> typeParameters = new ArrayList<Type.Parameter>();
            private Any value;

            private Builder() {
            }

            public final Builder from(Expression.UserDefinedAnyLiteral instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression.Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression.UserDefinedLiteral instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                Expression.Literal instance;
                long bits = 0L;
                if (object instanceof Expression.UserDefinedAnyLiteral) {
                    instance = (Expression.UserDefinedAnyLiteral)object;
                    if ((bits & 4L) == 0L) {
                        this.urn(((Expression.UserDefinedAnyLiteral)instance).urn());
                        bits |= 4L;
                    }
                    if ((bits & 8L) == 0L) {
                        this.name(((Expression.UserDefinedAnyLiteral)instance).name());
                        bits |= 8L;
                    }
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.addAllTypeParameters(((Expression.UserDefinedAnyLiteral)instance).typeParameters());
                        bits |= 2L;
                    }
                    this.value(((Expression.UserDefinedAnyLiteral)instance).value());
                }
                if (object instanceof Expression.Literal) {
                    instance = (Expression.Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Expression.UserDefinedLiteral) {
                    instance = (Expression.UserDefinedLiteral)object;
                    if ((bits & 4L) == 0L) {
                        this.urn(instance.urn());
                        bits |= 4L;
                    }
                    if ((bits & 8L) == 0L) {
                        this.name(instance.name());
                        bits |= 8L;
                    }
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.addAllTypeParameters(instance.typeParameters());
                        bits |= 2L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.optBits |= 1L;
                return this;
            }

            public final Builder urn(String urn) {
                this.urn = Objects.requireNonNull(urn, "urn");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder name(String name) {
                this.name = Objects.requireNonNull(name, "name");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public final Builder addTypeParameters(Type.Parameter element) {
                this.typeParameters.add(Objects.requireNonNull(element, "typeParameters element"));
                return this;
            }

            public final Builder addTypeParameters(Type.Parameter ... elements) {
                for (Type.Parameter element : elements) {
                    this.typeParameters.add(Objects.requireNonNull(element, "typeParameters element"));
                }
                return this;
            }

            public final Builder typeParameters(Iterable<? extends Type.Parameter> elements) {
                this.typeParameters.clear();
                return this.addAllTypeParameters(elements);
            }

            public final Builder addAllTypeParameters(Iterable<? extends Type.Parameter> elements) {
                for (Type.Parameter parameter : elements) {
                    this.typeParameters.add(Objects.requireNonNull(parameter, "typeParameters element"));
                }
                return this;
            }

            public final Builder value(Any value) {
                this.value = Objects.requireNonNull(value, "value");
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            public UserDefinedAnyLiteral build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new UserDefinedAnyLiteral(this);
            }

            private boolean nullableIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("urn");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("name");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("value");
                }
                return "Cannot build UserDefinedAnyLiteral, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class NestedStruct
    extends Expression.NestedStruct {
        private final boolean nullable;
        private final List<Expression> fields;

        private NestedStruct(Builder builder) {
            this.fields = ImmutableExpression.createUnmodifiableList(true, builder.fields);
            this.nullable = builder.nullableIsSet() ? builder.nullable : super.nullable();
        }

        private NestedStruct(boolean nullable, List<Expression> fields) {
            this.nullable = nullable;
            this.fields = fields;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public List<Expression> fields() {
            return this.fields;
        }

        public final NestedStruct withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new NestedStruct(value, this.fields);
        }

        public final NestedStruct withFields(Expression ... elements) {
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(Arrays.asList(elements), true, false));
            return new NestedStruct(this.nullable, newValue);
        }

        public final NestedStruct withFields(Iterable<? extends Expression> elements) {
            if (this.fields == elements) {
                return this;
            }
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(elements, true, false));
            return new NestedStruct(this.nullable, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof NestedStruct && this.equalsByValue((NestedStruct)another);
        }

        private boolean equalsByValue(NestedStruct another) {
            return this.nullable == another.nullable && this.fields.equals(another.fields);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.fields.hashCode();
            return h;
        }

        public String toString() {
            return "NestedStruct{nullable=" + this.nullable + ", fields=" + this.fields + "}";
        }

        public static NestedStruct copyOf(Expression.NestedStruct instance) {
            if (instance instanceof NestedStruct) {
                return (NestedStruct)instance;
            }
            return NestedStruct.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long OPT_BIT_NULLABLE = 1L;
            private long optBits;
            private boolean nullable;
            private List<Expression> fields = new ArrayList<Expression>();

            private Builder() {
            }

            public final Builder from(Expression.Nested instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression.NestedStruct instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                Expression.Nested instance;
                long bits = 0L;
                if (object instanceof Expression.Nested) {
                    instance = (Expression.Nested)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Expression.NestedStruct) {
                    instance = (Expression.NestedStruct)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.addAllFields(((Expression.NestedStruct)instance).fields());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.optBits |= 1L;
                return this;
            }

            public final Builder addFields(Expression element) {
                this.fields.add(Objects.requireNonNull(element, "fields element"));
                return this;
            }

            public final Builder addFields(Expression ... elements) {
                for (Expression element : elements) {
                    this.fields.add(Objects.requireNonNull(element, "fields element"));
                }
                return this;
            }

            public final Builder fields(Iterable<? extends Expression> elements) {
                this.fields.clear();
                return this.addAllFields(elements);
            }

            public final Builder addAllFields(Iterable<? extends Expression> elements) {
                for (Expression expression : elements) {
                    this.fields.add(Objects.requireNonNull(expression, "fields element"));
                }
                return this;
            }

            public NestedStruct build() {
                return new NestedStruct(this);
            }

            private boolean nullableIsSet() {
                return (this.optBits & 1L) != 0L;
            }
        }
    }

    public static final class StructLiteral
    extends Expression.StructLiteral {
        private final boolean nullable;
        private final List<Expression.Literal> fields;

        private StructLiteral(Builder builder) {
            this.fields = ImmutableExpression.createUnmodifiableList(true, builder.fields);
            this.nullable = builder.nullableIsSet() ? builder.nullable : super.nullable();
        }

        private StructLiteral(boolean nullable, List<Expression.Literal> fields) {
            this.nullable = nullable;
            this.fields = fields;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public List<Expression.Literal> fields() {
            return this.fields;
        }

        public final StructLiteral withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new StructLiteral(value, this.fields);
        }

        public final StructLiteral withFields(Expression.Literal ... elements) {
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(Arrays.asList(elements), true, false));
            return new StructLiteral(this.nullable, newValue);
        }

        public final StructLiteral withFields(Iterable<? extends Expression.Literal> elements) {
            if (this.fields == elements) {
                return this;
            }
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(elements, true, false));
            return new StructLiteral(this.nullable, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof StructLiteral && this.equalsByValue((StructLiteral)another);
        }

        private boolean equalsByValue(StructLiteral another) {
            return this.nullable == another.nullable && this.fields.equals(another.fields);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.fields.hashCode();
            return h;
        }

        public String toString() {
            return "StructLiteral{nullable=" + this.nullable + ", fields=" + this.fields + "}";
        }

        public static StructLiteral copyOf(Expression.StructLiteral instance) {
            if (instance instanceof StructLiteral) {
                return (StructLiteral)instance;
            }
            return StructLiteral.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long OPT_BIT_NULLABLE = 1L;
            private long optBits;
            private boolean nullable;
            private List<Expression.Literal> fields = new ArrayList<Expression.Literal>();

            private Builder() {
            }

            public final Builder from(Expression.Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression.StructLiteral instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                Expression.Literal instance;
                long bits = 0L;
                if (object instanceof Expression.Literal) {
                    instance = (Expression.Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Expression.StructLiteral) {
                    instance = (Expression.StructLiteral)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.addAllFields(((Expression.StructLiteral)instance).fields());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.optBits |= 1L;
                return this;
            }

            public final Builder addFields(Expression.Literal element) {
                this.fields.add(Objects.requireNonNull(element, "fields element"));
                return this;
            }

            public final Builder addFields(Expression.Literal ... elements) {
                for (Expression.Literal element : elements) {
                    this.fields.add(Objects.requireNonNull(element, "fields element"));
                }
                return this;
            }

            public final Builder fields(Iterable<? extends Expression.Literal> elements) {
                this.fields.clear();
                return this.addAllFields(elements);
            }

            public final Builder addAllFields(Iterable<? extends Expression.Literal> elements) {
                for (Expression.Literal literal : elements) {
                    this.fields.add(Objects.requireNonNull(literal, "fields element"));
                }
                return this;
            }

            public StructLiteral build() {
                return new StructLiteral(this);
            }

            private boolean nullableIsSet() {
                return (this.optBits & 1L) != 0L;
            }
        }
    }

    public static final class EmptyListLiteral
    extends Expression.EmptyListLiteral {
        private final boolean nullable;
        private final Type elementType;

        private EmptyListLiteral(Builder builder) {
            this.elementType = builder.elementType;
            this.nullable = builder.nullableIsSet() ? builder.nullable : super.nullable();
        }

        private EmptyListLiteral(boolean nullable, Type elementType) {
            this.nullable = nullable;
            this.elementType = elementType;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public Type elementType() {
            return this.elementType;
        }

        public final EmptyListLiteral withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new EmptyListLiteral(value, this.elementType);
        }

        public final EmptyListLiteral withElementType(Type value) {
            if (this.elementType == value) {
                return this;
            }
            Type newValue = Objects.requireNonNull(value, "elementType");
            return new EmptyListLiteral(this.nullable, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof EmptyListLiteral && this.equalsByValue((EmptyListLiteral)another);
        }

        private boolean equalsByValue(EmptyListLiteral another) {
            return this.nullable == another.nullable && this.elementType.equals(another.elementType);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.elementType.hashCode();
            return h;
        }

        public String toString() {
            return "EmptyListLiteral{nullable=" + this.nullable + ", elementType=" + this.elementType + "}";
        }

        public static EmptyListLiteral copyOf(Expression.EmptyListLiteral instance) {
            if (instance instanceof EmptyListLiteral) {
                return (EmptyListLiteral)instance;
            }
            return EmptyListLiteral.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_ELEMENT_TYPE = 1L;
            private static final long OPT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private long optBits;
            private boolean nullable;
            private Type elementType;

            private Builder() {
            }

            public final Builder from(Expression.Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression.EmptyListLiteral instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                Expression.Literal instance;
                long bits = 0L;
                if (object instanceof Expression.Literal) {
                    instance = (Expression.Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Expression.EmptyListLiteral) {
                    instance = (Expression.EmptyListLiteral)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.elementType(((Expression.EmptyListLiteral)instance).elementType());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.optBits |= 1L;
                return this;
            }

            public final Builder elementType(Type elementType) {
                this.elementType = Objects.requireNonNull(elementType, "elementType");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public EmptyListLiteral build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new EmptyListLiteral(this);
            }

            private boolean nullableIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("elementType");
                }
                return "Cannot build EmptyListLiteral, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class ListLiteral
    extends Expression.ListLiteral {
        private final boolean nullable;
        private final List<Expression.Literal> values;

        private ListLiteral(Builder builder) {
            this.values = ImmutableExpression.createUnmodifiableList(true, builder.values);
            this.nullable = builder.nullableIsSet() ? builder.nullable : super.nullable();
        }

        private ListLiteral(boolean nullable, List<Expression.Literal> values) {
            this.nullable = nullable;
            this.values = values;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public List<Expression.Literal> values() {
            return this.values;
        }

        public final ListLiteral withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new ListLiteral(value, this.values);
        }

        public final ListLiteral withValues(Expression.Literal ... elements) {
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(Arrays.asList(elements), true, false));
            return new ListLiteral(this.nullable, newValue);
        }

        public final ListLiteral withValues(Iterable<? extends Expression.Literal> elements) {
            if (this.values == elements) {
                return this;
            }
            List newValue = ImmutableExpression.createUnmodifiableList(false, ImmutableExpression.createSafeList(elements, true, false));
            return new ListLiteral(this.nullable, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ListLiteral && this.equalsByValue((ListLiteral)another);
        }

        private boolean equalsByValue(ListLiteral another) {
            return this.nullable == another.nullable && this.values.equals(another.values);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.values.hashCode();
            return h;
        }

        public String toString() {
            return "ListLiteral{nullable=" + this.nullable + ", values=" + this.values + "}";
        }

        public static ListLiteral copyOf(Expression.ListLiteral instance) {
            if (instance instanceof ListLiteral) {
                return (ListLiteral)instance;
            }
            return ListLiteral.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long OPT_BIT_NULLABLE = 1L;
            private long optBits;
            private boolean nullable;
            private List<Expression.Literal> values = new ArrayList<Expression.Literal>();

            private Builder() {
            }

            public final Builder from(Expression.ListLiteral instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression.Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                Expression.Literal instance;
                long bits = 0L;
                if (object instanceof Expression.ListLiteral) {
                    instance = (Expression.ListLiteral)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.addAllValues(((Expression.ListLiteral)instance).values());
                }
                if (object instanceof Expression.Literal) {
                    instance = (Expression.Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.optBits |= 1L;
                return this;
            }

            public final Builder addValues(Expression.Literal element) {
                this.values.add(Objects.requireNonNull(element, "values element"));
                return this;
            }

            public final Builder addValues(Expression.Literal ... elements) {
                for (Expression.Literal element : elements) {
                    this.values.add(Objects.requireNonNull(element, "values element"));
                }
                return this;
            }

            public final Builder values(Iterable<? extends Expression.Literal> elements) {
                this.values.clear();
                return this.addAllValues(elements);
            }

            public final Builder addAllValues(Iterable<? extends Expression.Literal> elements) {
                for (Expression.Literal literal : elements) {
                    this.values.add(Objects.requireNonNull(literal, "values element"));
                }
                return this;
            }

            public ListLiteral build() {
                return new ListLiteral(this);
            }

            private boolean nullableIsSet() {
                return (this.optBits & 1L) != 0L;
            }
        }
    }

    public static final class EmptyMapLiteral
    extends Expression.EmptyMapLiteral {
        private final boolean nullable;
        private final Type keyType;
        private final Type valueType;

        private EmptyMapLiteral(Builder builder) {
            this.keyType = builder.keyType;
            this.valueType = builder.valueType;
            this.nullable = builder.nullableIsSet() ? builder.nullable : super.nullable();
        }

        private EmptyMapLiteral(boolean nullable, Type keyType, Type valueType) {
            this.nullable = nullable;
            this.keyType = keyType;
            this.valueType = valueType;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public Type keyType() {
            return this.keyType;
        }

        @Override
        public Type valueType() {
            return this.valueType;
        }

        public final EmptyMapLiteral withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new EmptyMapLiteral(value, this.keyType, this.valueType);
        }

        public final EmptyMapLiteral withKeyType(Type value) {
            if (this.keyType == value) {
                return this;
            }
            Type newValue = Objects.requireNonNull(value, "keyType");
            return new EmptyMapLiteral(this.nullable, newValue, this.valueType);
        }

        public final EmptyMapLiteral withValueType(Type value) {
            if (this.valueType == value) {
                return this;
            }
            Type newValue = Objects.requireNonNull(value, "valueType");
            return new EmptyMapLiteral(this.nullable, this.keyType, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof EmptyMapLiteral && this.equalsByValue((EmptyMapLiteral)another);
        }

        private boolean equalsByValue(EmptyMapLiteral another) {
            return this.nullable == another.nullable && this.keyType.equals(another.keyType) && this.valueType.equals(another.valueType);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.keyType.hashCode();
            h += (h << 5) + this.valueType.hashCode();
            return h;
        }

        public String toString() {
            return "EmptyMapLiteral{nullable=" + this.nullable + ", keyType=" + this.keyType + ", valueType=" + this.valueType + "}";
        }

        public static EmptyMapLiteral copyOf(Expression.EmptyMapLiteral instance) {
            if (instance instanceof EmptyMapLiteral) {
                return (EmptyMapLiteral)instance;
            }
            return EmptyMapLiteral.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_KEY_TYPE = 1L;
            private static final long INIT_BIT_VALUE_TYPE = 2L;
            private static final long OPT_BIT_NULLABLE = 1L;
            private long initBits = 3L;
            private long optBits;
            private boolean nullable;
            private Type keyType;
            private Type valueType;

            private Builder() {
            }

            public final Builder from(Expression.EmptyMapLiteral instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression.Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                Expression.Literal instance;
                long bits = 0L;
                if (object instanceof Expression.EmptyMapLiteral) {
                    instance = (Expression.EmptyMapLiteral)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.keyType(((Expression.EmptyMapLiteral)instance).keyType());
                    this.valueType(((Expression.EmptyMapLiteral)instance).valueType());
                }
                if (object instanceof Expression.Literal) {
                    instance = (Expression.Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.optBits |= 1L;
                return this;
            }

            public final Builder keyType(Type keyType) {
                this.keyType = Objects.requireNonNull(keyType, "keyType");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder valueType(Type valueType) {
                this.valueType = Objects.requireNonNull(valueType, "valueType");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public EmptyMapLiteral build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new EmptyMapLiteral(this);
            }

            private boolean nullableIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("keyType");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("valueType");
                }
                return "Cannot build EmptyMapLiteral, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class MapLiteral
    extends Expression.MapLiteral {
        private final boolean nullable;
        private final Map<Expression.Literal, Expression.Literal> values;

        private MapLiteral(Builder builder) {
            this.values = ImmutableExpression.createUnmodifiableMap(false, false, builder.values);
            this.nullable = builder.nullableIsSet() ? builder.nullable : super.nullable();
        }

        private MapLiteral(boolean nullable, Map<Expression.Literal, Expression.Literal> values) {
            this.nullable = nullable;
            this.values = values;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public Map<Expression.Literal, Expression.Literal> values() {
            return this.values;
        }

        public final MapLiteral withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new MapLiteral(value, this.values);
        }

        public final MapLiteral withValues(Map<? extends Expression.Literal, ? extends Expression.Literal> entries) {
            if (this.values == entries) {
                return this;
            }
            Map newValue = ImmutableExpression.createUnmodifiableMap(true, false, entries);
            return new MapLiteral(this.nullable, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof MapLiteral && this.equalsByValue((MapLiteral)another);
        }

        private boolean equalsByValue(MapLiteral another) {
            return this.nullable == another.nullable && this.values.equals(another.values);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.values.hashCode();
            return h;
        }

        public String toString() {
            return "MapLiteral{nullable=" + this.nullable + ", values=" + this.values + "}";
        }

        public static MapLiteral copyOf(Expression.MapLiteral instance) {
            if (instance instanceof MapLiteral) {
                return (MapLiteral)instance;
            }
            return MapLiteral.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long OPT_BIT_NULLABLE = 1L;
            private long optBits;
            private boolean nullable;
            private Map<Expression.Literal, Expression.Literal> values = new LinkedHashMap<Expression.Literal, Expression.Literal>();

            private Builder() {
            }

            public final Builder from(Expression.MapLiteral instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression.Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                Expression.Literal instance;
                long bits = 0L;
                if (object instanceof Expression.MapLiteral) {
                    instance = (Expression.MapLiteral)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.putAllValues(((Expression.MapLiteral)instance).values());
                }
                if (object instanceof Expression.Literal) {
                    instance = (Expression.Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.optBits |= 1L;
                return this;
            }

            public final Builder putValues(Expression.Literal key, Expression.Literal value) {
                this.values.put(Objects.requireNonNull(key, "values key"), Objects.requireNonNull(value, value == null ? "values value for key: " + key : null));
                return this;
            }

            public final Builder putValues(Map.Entry<? extends Expression.Literal, ? extends Expression.Literal> entry) {
                Expression.Literal v;
                Expression.Literal k = entry.getKey();
                this.values.put(Objects.requireNonNull(k, "values key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "values value for key: " + k : null));
                return this;
            }

            public final Builder values(Map<? extends Expression.Literal, ? extends Expression.Literal> entries) {
                this.values.clear();
                return this.putAllValues(entries);
            }

            public final Builder putAllValues(Map<? extends Expression.Literal, ? extends Expression.Literal> entries) {
                for (Map.Entry<? extends Expression.Literal, ? extends Expression.Literal> e : entries.entrySet()) {
                    Expression.Literal v;
                    Expression.Literal k = e.getKey();
                    this.values.put(Objects.requireNonNull(k, "values key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "values value for key: " + k : null));
                }
                return this;
            }

            public MapLiteral build() {
                return new MapLiteral(this);
            }

            private boolean nullableIsSet() {
                return (this.optBits & 1L) != 0L;
            }
        }
    }

    public static final class DecimalLiteral
    extends Expression.DecimalLiteral {
        private final boolean nullable;
        private final ByteString value;
        private final int precision;
        private final int scale;

        private DecimalLiteral(Builder builder) {
            this.value = builder.value;
            this.precision = builder.precision;
            this.scale = builder.scale;
            this.nullable = builder.nullableIsSet() ? builder.nullable : super.nullable();
        }

        private DecimalLiteral(boolean nullable, ByteString value, int precision, int scale) {
            this.nullable = nullable;
            this.value = value;
            this.precision = precision;
            this.scale = scale;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public ByteString value() {
            return this.value;
        }

        @Override
        public int precision() {
            return this.precision;
        }

        @Override
        public int scale() {
            return this.scale;
        }

        public final DecimalLiteral withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new DecimalLiteral(value, this.value, this.precision, this.scale);
        }

        public final DecimalLiteral withValue(ByteString value) {
            if (this.value == value) {
                return this;
            }
            ByteString newValue = Objects.requireNonNull(value, "value");
            return new DecimalLiteral(this.nullable, newValue, this.precision, this.scale);
        }

        public final DecimalLiteral withPrecision(int value) {
            if (this.precision == value) {
                return this;
            }
            return new DecimalLiteral(this.nullable, this.value, value, this.scale);
        }

        public final DecimalLiteral withScale(int value) {
            if (this.scale == value) {
                return this;
            }
            return new DecimalLiteral(this.nullable, this.value, this.precision, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof DecimalLiteral && this.equalsByValue((DecimalLiteral)another);
        }

        private boolean equalsByValue(DecimalLiteral another) {
            return this.nullable == another.nullable && this.value.equals((Object)another.value) && this.precision == another.precision && this.scale == another.scale;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.value.hashCode();
            h += (h << 5) + this.precision;
            h += (h << 5) + this.scale;
            return h;
        }

        public String toString() {
            return "DecimalLiteral{nullable=" + this.nullable + ", value=" + this.value + ", precision=" + this.precision + ", scale=" + this.scale + "}";
        }

        public static DecimalLiteral copyOf(Expression.DecimalLiteral instance) {
            if (instance instanceof DecimalLiteral) {
                return (DecimalLiteral)instance;
            }
            return DecimalLiteral.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_VALUE = 1L;
            private static final long INIT_BIT_PRECISION = 2L;
            private static final long INIT_BIT_SCALE = 4L;
            private static final long OPT_BIT_NULLABLE = 1L;
            private long initBits = 7L;
            private long optBits;
            private boolean nullable;
            private ByteString value;
            private int precision;
            private int scale;

            private Builder() {
            }

            public final Builder from(Expression.Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression.DecimalLiteral instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                Expression.Literal instance;
                long bits = 0L;
                if (object instanceof Expression.Literal) {
                    instance = (Expression.Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Expression.DecimalLiteral) {
                    instance = (Expression.DecimalLiteral)object;
                    this.scale(((Expression.DecimalLiteral)instance).scale());
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.value(((Expression.DecimalLiteral)instance).value());
                    this.precision(((Expression.DecimalLiteral)instance).precision());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.optBits |= 1L;
                return this;
            }

            public final Builder value(ByteString value) {
                this.value = Objects.requireNonNull(value, "value");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder precision(int precision) {
                this.precision = precision;
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public final Builder scale(int scale) {
                this.scale = scale;
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            public DecimalLiteral build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new DecimalLiteral(this);
            }

            private boolean nullableIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("value");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("precision");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("scale");
                }
                return "Cannot build DecimalLiteral, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class FixedBinaryLiteral
    extends Expression.FixedBinaryLiteral {
        private final boolean nullable;
        private final ByteString value;

        private FixedBinaryLiteral(Builder builder) {
            this.value = builder.value;
            this.nullable = builder.nullableIsSet() ? builder.nullable : super.nullable();
        }

        private FixedBinaryLiteral(boolean nullable, ByteString value) {
            this.nullable = nullable;
            this.value = value;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public ByteString value() {
            return this.value;
        }

        public final FixedBinaryLiteral withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new FixedBinaryLiteral(value, this.value);
        }

        public final FixedBinaryLiteral withValue(ByteString value) {
            if (this.value == value) {
                return this;
            }
            ByteString newValue = Objects.requireNonNull(value, "value");
            return new FixedBinaryLiteral(this.nullable, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof FixedBinaryLiteral && this.equalsByValue((FixedBinaryLiteral)another);
        }

        private boolean equalsByValue(FixedBinaryLiteral another) {
            return this.nullable == another.nullable && this.value.equals((Object)another.value);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.value.hashCode();
            return h;
        }

        public String toString() {
            return "FixedBinaryLiteral{nullable=" + this.nullable + ", value=" + this.value + "}";
        }

        public static FixedBinaryLiteral copyOf(Expression.FixedBinaryLiteral instance) {
            if (instance instanceof FixedBinaryLiteral) {
                return (FixedBinaryLiteral)instance;
            }
            return FixedBinaryLiteral.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_VALUE = 1L;
            private static final long OPT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private long optBits;
            private boolean nullable;
            private ByteString value;

            private Builder() {
            }

            public final Builder from(Expression.FixedBinaryLiteral instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression.Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                Expression.Literal instance;
                long bits = 0L;
                if (object instanceof Expression.FixedBinaryLiteral) {
                    instance = (Expression.FixedBinaryLiteral)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.value(((Expression.FixedBinaryLiteral)instance).value());
                }
                if (object instanceof Expression.Literal) {
                    instance = (Expression.Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.optBits |= 1L;
                return this;
            }

            public final Builder value(ByteString value) {
                this.value = Objects.requireNonNull(value, "value");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public FixedBinaryLiteral build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new FixedBinaryLiteral(this);
            }

            private boolean nullableIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("value");
                }
                return "Cannot build FixedBinaryLiteral, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class VarCharLiteral
    extends Expression.VarCharLiteral {
        private final boolean nullable;
        private final String value;
        private final int length;

        private VarCharLiteral(Builder builder) {
            this.value = builder.value;
            this.length = builder.length;
            this.nullable = builder.nullableIsSet() ? builder.nullable : super.nullable();
        }

        private VarCharLiteral(boolean nullable, String value, int length) {
            this.nullable = nullable;
            this.value = value;
            this.length = length;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public int length() {
            return this.length;
        }

        public final VarCharLiteral withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new VarCharLiteral(value, this.value, this.length);
        }

        public final VarCharLiteral withValue(String value) {
            String newValue = Objects.requireNonNull(value, "value");
            if (this.value.equals(newValue)) {
                return this;
            }
            return new VarCharLiteral(this.nullable, newValue, this.length);
        }

        public final VarCharLiteral withLength(int value) {
            if (this.length == value) {
                return this;
            }
            return new VarCharLiteral(this.nullable, this.value, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof VarCharLiteral && this.equalsByValue((VarCharLiteral)another);
        }

        private boolean equalsByValue(VarCharLiteral another) {
            return this.nullable == another.nullable && this.value.equals(another.value) && this.length == another.length;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.value.hashCode();
            h += (h << 5) + this.length;
            return h;
        }

        public String toString() {
            return "VarCharLiteral{nullable=" + this.nullable + ", value=" + this.value + ", length=" + this.length + "}";
        }

        public static VarCharLiteral copyOf(Expression.VarCharLiteral instance) {
            if (instance instanceof VarCharLiteral) {
                return (VarCharLiteral)instance;
            }
            return VarCharLiteral.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_VALUE = 1L;
            private static final long INIT_BIT_LENGTH = 2L;
            private static final long OPT_BIT_NULLABLE = 1L;
            private long initBits = 3L;
            private long optBits;
            private boolean nullable;
            private String value;
            private int length;

            private Builder() {
            }

            public final Builder from(Expression.VarCharLiteral instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression.Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                Expression.Literal instance;
                long bits = 0L;
                if (object instanceof Expression.VarCharLiteral) {
                    instance = (Expression.VarCharLiteral)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.length(((Expression.VarCharLiteral)instance).length());
                    this.value(((Expression.VarCharLiteral)instance).value());
                }
                if (object instanceof Expression.Literal) {
                    instance = (Expression.Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.optBits |= 1L;
                return this;
            }

            public final Builder value(String value) {
                this.value = Objects.requireNonNull(value, "value");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder length(int length) {
                this.length = length;
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public VarCharLiteral build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new VarCharLiteral(this);
            }

            private boolean nullableIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("value");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("length");
                }
                return "Cannot build VarCharLiteral, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class FixedCharLiteral
    extends Expression.FixedCharLiteral {
        private final boolean nullable;
        private final String value;

        private FixedCharLiteral(Builder builder) {
            this.value = builder.value;
            this.nullable = builder.nullableIsSet() ? builder.nullable : super.nullable();
        }

        private FixedCharLiteral(boolean nullable, String value) {
            this.nullable = nullable;
            this.value = value;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public String value() {
            return this.value;
        }

        public final FixedCharLiteral withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new FixedCharLiteral(value, this.value);
        }

        public final FixedCharLiteral withValue(String value) {
            String newValue = Objects.requireNonNull(value, "value");
            if (this.value.equals(newValue)) {
                return this;
            }
            return new FixedCharLiteral(this.nullable, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof FixedCharLiteral && this.equalsByValue((FixedCharLiteral)another);
        }

        private boolean equalsByValue(FixedCharLiteral another) {
            return this.nullable == another.nullable && this.value.equals(another.value);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.value.hashCode();
            return h;
        }

        public String toString() {
            return "FixedCharLiteral{nullable=" + this.nullable + ", value=" + this.value + "}";
        }

        public static FixedCharLiteral copyOf(Expression.FixedCharLiteral instance) {
            if (instance instanceof FixedCharLiteral) {
                return (FixedCharLiteral)instance;
            }
            return FixedCharLiteral.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_VALUE = 1L;
            private static final long OPT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private long optBits;
            private boolean nullable;
            private String value;

            private Builder() {
            }

            public final Builder from(Expression.FixedCharLiteral instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression.Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                Expression.Literal instance;
                long bits = 0L;
                if (object instanceof Expression.FixedCharLiteral) {
                    instance = (Expression.FixedCharLiteral)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.value(((Expression.FixedCharLiteral)instance).value());
                }
                if (object instanceof Expression.Literal) {
                    instance = (Expression.Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.optBits |= 1L;
                return this;
            }

            public final Builder value(String value) {
                this.value = Objects.requireNonNull(value, "value");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public FixedCharLiteral build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new FixedCharLiteral(this);
            }

            private boolean nullableIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("value");
                }
                return "Cannot build FixedCharLiteral, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class UUIDLiteral
    extends Expression.UUIDLiteral {
        private final boolean nullable;
        private final UUID value;

        private UUIDLiteral(Builder builder) {
            this.value = builder.value;
            this.nullable = builder.nullableIsSet() ? builder.nullable : super.nullable();
        }

        private UUIDLiteral(boolean nullable, UUID value) {
            this.nullable = nullable;
            this.value = value;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public UUID value() {
            return this.value;
        }

        public final UUIDLiteral withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new UUIDLiteral(value, this.value);
        }

        public final UUIDLiteral withValue(UUID value) {
            if (this.value == value) {
                return this;
            }
            UUID newValue = Objects.requireNonNull(value, "value");
            return new UUIDLiteral(this.nullable, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof UUIDLiteral && this.equalsByValue((UUIDLiteral)another);
        }

        private boolean equalsByValue(UUIDLiteral another) {
            return this.nullable == another.nullable && this.value.equals(another.value);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.value.hashCode();
            return h;
        }

        public String toString() {
            return "UUIDLiteral{nullable=" + this.nullable + ", value=" + this.value + "}";
        }

        public static UUIDLiteral copyOf(Expression.UUIDLiteral instance) {
            if (instance instanceof UUIDLiteral) {
                return (UUIDLiteral)instance;
            }
            return UUIDLiteral.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_VALUE = 1L;
            private static final long OPT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private long optBits;
            private boolean nullable;
            private UUID value;

            private Builder() {
            }

            public final Builder from(Expression.UUIDLiteral instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression.Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                Expression.Literal instance;
                long bits = 0L;
                if (object instanceof Expression.UUIDLiteral) {
                    instance = (Expression.UUIDLiteral)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.value(((Expression.UUIDLiteral)instance).value());
                }
                if (object instanceof Expression.Literal) {
                    instance = (Expression.Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.optBits |= 1L;
                return this;
            }

            public final Builder value(UUID value) {
                this.value = Objects.requireNonNull(value, "value");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public UUIDLiteral build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new UUIDLiteral(this);
            }

            private boolean nullableIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("value");
                }
                return "Cannot build UUIDLiteral, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class IntervalCompoundLiteral
    extends Expression.IntervalCompoundLiteral {
        private final boolean nullable;
        private final int years;
        private final int months;
        private final int days;
        private final int seconds;
        private final long subseconds;
        private final int precision;

        private IntervalCompoundLiteral(Builder builder) {
            this.years = builder.years;
            this.months = builder.months;
            this.days = builder.days;
            this.seconds = builder.seconds;
            this.subseconds = builder.subseconds;
            this.precision = builder.precision;
            this.nullable = builder.nullableIsSet() ? builder.nullable : super.nullable();
        }

        private IntervalCompoundLiteral(boolean nullable, int years, int months, int days, int seconds, long subseconds, int precision) {
            this.nullable = nullable;
            this.years = years;
            this.months = months;
            this.days = days;
            this.seconds = seconds;
            this.subseconds = subseconds;
            this.precision = precision;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public int years() {
            return this.years;
        }

        @Override
        public int months() {
            return this.months;
        }

        @Override
        public int days() {
            return this.days;
        }

        @Override
        public int seconds() {
            return this.seconds;
        }

        @Override
        public long subseconds() {
            return this.subseconds;
        }

        @Override
        public int precision() {
            return this.precision;
        }

        public final IntervalCompoundLiteral withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new IntervalCompoundLiteral(value, this.years, this.months, this.days, this.seconds, this.subseconds, this.precision);
        }

        public final IntervalCompoundLiteral withYears(int value) {
            if (this.years == value) {
                return this;
            }
            return new IntervalCompoundLiteral(this.nullable, value, this.months, this.days, this.seconds, this.subseconds, this.precision);
        }

        public final IntervalCompoundLiteral withMonths(int value) {
            if (this.months == value) {
                return this;
            }
            return new IntervalCompoundLiteral(this.nullable, this.years, value, this.days, this.seconds, this.subseconds, this.precision);
        }

        public final IntervalCompoundLiteral withDays(int value) {
            if (this.days == value) {
                return this;
            }
            return new IntervalCompoundLiteral(this.nullable, this.years, this.months, value, this.seconds, this.subseconds, this.precision);
        }

        public final IntervalCompoundLiteral withSeconds(int value) {
            if (this.seconds == value) {
                return this;
            }
            return new IntervalCompoundLiteral(this.nullable, this.years, this.months, this.days, value, this.subseconds, this.precision);
        }

        public final IntervalCompoundLiteral withSubseconds(long value) {
            if (this.subseconds == value) {
                return this;
            }
            return new IntervalCompoundLiteral(this.nullable, this.years, this.months, this.days, this.seconds, value, this.precision);
        }

        public final IntervalCompoundLiteral withPrecision(int value) {
            if (this.precision == value) {
                return this;
            }
            return new IntervalCompoundLiteral(this.nullable, this.years, this.months, this.days, this.seconds, this.subseconds, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof IntervalCompoundLiteral && this.equalsByValue((IntervalCompoundLiteral)another);
        }

        private boolean equalsByValue(IntervalCompoundLiteral another) {
            return this.nullable == another.nullable && this.years == another.years && this.months == another.months && this.days == another.days && this.seconds == another.seconds && this.subseconds == another.subseconds && this.precision == another.precision;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.years;
            h += (h << 5) + this.months;
            h += (h << 5) + this.days;
            h += (h << 5) + this.seconds;
            h += (h << 5) + Long.hashCode(this.subseconds);
            h += (h << 5) + this.precision;
            return h;
        }

        public String toString() {
            return "IntervalCompoundLiteral{nullable=" + this.nullable + ", years=" + this.years + ", months=" + this.months + ", days=" + this.days + ", seconds=" + this.seconds + ", subseconds=" + this.subseconds + ", precision=" + this.precision + "}";
        }

        public static IntervalCompoundLiteral copyOf(Expression.IntervalCompoundLiteral instance) {
            if (instance instanceof IntervalCompoundLiteral) {
                return (IntervalCompoundLiteral)instance;
            }
            return IntervalCompoundLiteral.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_YEARS = 1L;
            private static final long INIT_BIT_MONTHS = 2L;
            private static final long INIT_BIT_DAYS = 4L;
            private static final long INIT_BIT_SECONDS = 8L;
            private static final long INIT_BIT_SUBSECONDS = 16L;
            private static final long INIT_BIT_PRECISION = 32L;
            private static final long OPT_BIT_NULLABLE = 1L;
            private long initBits = 63L;
            private long optBits;
            private boolean nullable;
            private int years;
            private int months;
            private int days;
            private int seconds;
            private long subseconds;
            private int precision;

            private Builder() {
            }

            public final Builder from(Expression.IntervalCompoundLiteral instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression.Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                Expression.Literal instance;
                long bits = 0L;
                if (object instanceof Expression.IntervalCompoundLiteral) {
                    instance = (Expression.IntervalCompoundLiteral)object;
                    this.seconds(((Expression.IntervalCompoundLiteral)instance).seconds());
                    this.months(((Expression.IntervalCompoundLiteral)instance).months());
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.precision(((Expression.IntervalCompoundLiteral)instance).precision());
                    this.days(((Expression.IntervalCompoundLiteral)instance).days());
                    this.subseconds(((Expression.IntervalCompoundLiteral)instance).subseconds());
                    this.years(((Expression.IntervalCompoundLiteral)instance).years());
                }
                if (object instanceof Expression.Literal) {
                    instance = (Expression.Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.optBits |= 1L;
                return this;
            }

            public final Builder years(int years) {
                this.years = years;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder months(int months) {
                this.months = months;
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public final Builder days(int days) {
                this.days = days;
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            public final Builder seconds(int seconds) {
                this.seconds = seconds;
                this.initBits &= 0xFFFFFFFFFFFFFFF7L;
                return this;
            }

            public final Builder subseconds(long subseconds) {
                this.subseconds = subseconds;
                this.initBits &= 0xFFFFFFFFFFFFFFEFL;
                return this;
            }

            public final Builder precision(int precision) {
                this.precision = precision;
                this.initBits &= 0xFFFFFFFFFFFFFFDFL;
                return this;
            }

            public IntervalCompoundLiteral build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new IntervalCompoundLiteral(this);
            }

            private boolean nullableIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("years");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("months");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("days");
                }
                if ((this.initBits & 8L) != 0L) {
                    attributes.add("seconds");
                }
                if ((this.initBits & 0x10L) != 0L) {
                    attributes.add("subseconds");
                }
                if ((this.initBits & 0x20L) != 0L) {
                    attributes.add("precision");
                }
                return "Cannot build IntervalCompoundLiteral, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class IntervalDayLiteral
    extends Expression.IntervalDayLiteral {
        private final boolean nullable;
        private final int days;
        private final int seconds;
        private final long subseconds;
        private final int precision;

        private IntervalDayLiteral(Builder builder) {
            this.days = builder.days;
            this.seconds = builder.seconds;
            this.subseconds = builder.subseconds;
            this.precision = builder.precision;
            this.nullable = builder.nullableIsSet() ? builder.nullable : super.nullable();
        }

        private IntervalDayLiteral(boolean nullable, int days, int seconds, long subseconds, int precision) {
            this.nullable = nullable;
            this.days = days;
            this.seconds = seconds;
            this.subseconds = subseconds;
            this.precision = precision;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public int days() {
            return this.days;
        }

        @Override
        public int seconds() {
            return this.seconds;
        }

        @Override
        public long subseconds() {
            return this.subseconds;
        }

        @Override
        public int precision() {
            return this.precision;
        }

        public final IntervalDayLiteral withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new IntervalDayLiteral(value, this.days, this.seconds, this.subseconds, this.precision);
        }

        public final IntervalDayLiteral withDays(int value) {
            if (this.days == value) {
                return this;
            }
            return new IntervalDayLiteral(this.nullable, value, this.seconds, this.subseconds, this.precision);
        }

        public final IntervalDayLiteral withSeconds(int value) {
            if (this.seconds == value) {
                return this;
            }
            return new IntervalDayLiteral(this.nullable, this.days, value, this.subseconds, this.precision);
        }

        public final IntervalDayLiteral withSubseconds(long value) {
            if (this.subseconds == value) {
                return this;
            }
            return new IntervalDayLiteral(this.nullable, this.days, this.seconds, value, this.precision);
        }

        public final IntervalDayLiteral withPrecision(int value) {
            if (this.precision == value) {
                return this;
            }
            return new IntervalDayLiteral(this.nullable, this.days, this.seconds, this.subseconds, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof IntervalDayLiteral && this.equalsByValue((IntervalDayLiteral)another);
        }

        private boolean equalsByValue(IntervalDayLiteral another) {
            return this.nullable == another.nullable && this.days == another.days && this.seconds == another.seconds && this.subseconds == another.subseconds && this.precision == another.precision;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.days;
            h += (h << 5) + this.seconds;
            h += (h << 5) + Long.hashCode(this.subseconds);
            h += (h << 5) + this.precision;
            return h;
        }

        public String toString() {
            return "IntervalDayLiteral{nullable=" + this.nullable + ", days=" + this.days + ", seconds=" + this.seconds + ", subseconds=" + this.subseconds + ", precision=" + this.precision + "}";
        }

        public static IntervalDayLiteral copyOf(Expression.IntervalDayLiteral instance) {
            if (instance instanceof IntervalDayLiteral) {
                return (IntervalDayLiteral)instance;
            }
            return IntervalDayLiteral.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_DAYS = 1L;
            private static final long INIT_BIT_SECONDS = 2L;
            private static final long INIT_BIT_SUBSECONDS = 4L;
            private static final long INIT_BIT_PRECISION = 8L;
            private static final long OPT_BIT_NULLABLE = 1L;
            private long initBits = 15L;
            private long optBits;
            private boolean nullable;
            private int days;
            private int seconds;
            private long subseconds;
            private int precision;

            private Builder() {
            }

            public final Builder from(Expression.IntervalDayLiteral instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression.Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                Expression.Literal instance;
                long bits = 0L;
                if (object instanceof Expression.IntervalDayLiteral) {
                    instance = (Expression.IntervalDayLiteral)object;
                    this.days(((Expression.IntervalDayLiteral)instance).days());
                    this.seconds(((Expression.IntervalDayLiteral)instance).seconds());
                    this.subseconds(((Expression.IntervalDayLiteral)instance).subseconds());
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.precision(((Expression.IntervalDayLiteral)instance).precision());
                }
                if (object instanceof Expression.Literal) {
                    instance = (Expression.Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.optBits |= 1L;
                return this;
            }

            public final Builder days(int days) {
                this.days = days;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder seconds(int seconds) {
                this.seconds = seconds;
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public final Builder subseconds(long subseconds) {
                this.subseconds = subseconds;
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            public final Builder precision(int precision) {
                this.precision = precision;
                this.initBits &= 0xFFFFFFFFFFFFFFF7L;
                return this;
            }

            public IntervalDayLiteral build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new IntervalDayLiteral(this);
            }

            private boolean nullableIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("days");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("seconds");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("subseconds");
                }
                if ((this.initBits & 8L) != 0L) {
                    attributes.add("precision");
                }
                return "Cannot build IntervalDayLiteral, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class IntervalYearLiteral
    extends Expression.IntervalYearLiteral {
        private final boolean nullable;
        private final int years;
        private final int months;

        private IntervalYearLiteral(Builder builder) {
            this.years = builder.years;
            this.months = builder.months;
            this.nullable = builder.nullableIsSet() ? builder.nullable : super.nullable();
        }

        private IntervalYearLiteral(boolean nullable, int years, int months) {
            this.nullable = nullable;
            this.years = years;
            this.months = months;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public int years() {
            return this.years;
        }

        @Override
        public int months() {
            return this.months;
        }

        public final IntervalYearLiteral withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new IntervalYearLiteral(value, this.years, this.months);
        }

        public final IntervalYearLiteral withYears(int value) {
            if (this.years == value) {
                return this;
            }
            return new IntervalYearLiteral(this.nullable, value, this.months);
        }

        public final IntervalYearLiteral withMonths(int value) {
            if (this.months == value) {
                return this;
            }
            return new IntervalYearLiteral(this.nullable, this.years, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof IntervalYearLiteral && this.equalsByValue((IntervalYearLiteral)another);
        }

        private boolean equalsByValue(IntervalYearLiteral another) {
            return this.nullable == another.nullable && this.years == another.years && this.months == another.months;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.years;
            h += (h << 5) + this.months;
            return h;
        }

        public String toString() {
            return "IntervalYearLiteral{nullable=" + this.nullable + ", years=" + this.years + ", months=" + this.months + "}";
        }

        public static IntervalYearLiteral copyOf(Expression.IntervalYearLiteral instance) {
            if (instance instanceof IntervalYearLiteral) {
                return (IntervalYearLiteral)instance;
            }
            return IntervalYearLiteral.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_YEARS = 1L;
            private static final long INIT_BIT_MONTHS = 2L;
            private static final long OPT_BIT_NULLABLE = 1L;
            private long initBits = 3L;
            private long optBits;
            private boolean nullable;
            private int years;
            private int months;

            private Builder() {
            }

            public final Builder from(Expression.IntervalYearLiteral instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression.Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                Expression.Literal instance;
                long bits = 0L;
                if (object instanceof Expression.IntervalYearLiteral) {
                    instance = (Expression.IntervalYearLiteral)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.years(((Expression.IntervalYearLiteral)instance).years());
                    this.months(((Expression.IntervalYearLiteral)instance).months());
                }
                if (object instanceof Expression.Literal) {
                    instance = (Expression.Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.optBits |= 1L;
                return this;
            }

            public final Builder years(int years) {
                this.years = years;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder months(int months) {
                this.months = months;
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public IntervalYearLiteral build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new IntervalYearLiteral(this);
            }

            private boolean nullableIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("years");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("months");
                }
                return "Cannot build IntervalYearLiteral, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class PrecisionTimestampTZLiteral
    extends Expression.PrecisionTimestampTZLiteral {
        private final boolean nullable;
        private final long value;
        private final int precision;

        private PrecisionTimestampTZLiteral(Builder builder) {
            this.value = builder.value;
            this.precision = builder.precision;
            this.nullable = builder.nullableIsSet() ? builder.nullable : super.nullable();
        }

        private PrecisionTimestampTZLiteral(boolean nullable, long value, int precision) {
            this.nullable = nullable;
            this.value = value;
            this.precision = precision;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public long value() {
            return this.value;
        }

        @Override
        public int precision() {
            return this.precision;
        }

        public final PrecisionTimestampTZLiteral withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new PrecisionTimestampTZLiteral(value, this.value, this.precision);
        }

        public final PrecisionTimestampTZLiteral withValue(long value) {
            if (this.value == value) {
                return this;
            }
            return new PrecisionTimestampTZLiteral(this.nullable, value, this.precision);
        }

        public final PrecisionTimestampTZLiteral withPrecision(int value) {
            if (this.precision == value) {
                return this;
            }
            return new PrecisionTimestampTZLiteral(this.nullable, this.value, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof PrecisionTimestampTZLiteral && this.equalsByValue((PrecisionTimestampTZLiteral)another);
        }

        private boolean equalsByValue(PrecisionTimestampTZLiteral another) {
            return this.nullable == another.nullable && this.value == another.value && this.precision == another.precision;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + Long.hashCode(this.value);
            h += (h << 5) + this.precision;
            return h;
        }

        public String toString() {
            return "PrecisionTimestampTZLiteral{nullable=" + this.nullable + ", value=" + this.value + ", precision=" + this.precision + "}";
        }

        public static PrecisionTimestampTZLiteral copyOf(Expression.PrecisionTimestampTZLiteral instance) {
            if (instance instanceof PrecisionTimestampTZLiteral) {
                return (PrecisionTimestampTZLiteral)instance;
            }
            return PrecisionTimestampTZLiteral.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_VALUE = 1L;
            private static final long INIT_BIT_PRECISION = 2L;
            private static final long OPT_BIT_NULLABLE = 1L;
            private long initBits = 3L;
            private long optBits;
            private boolean nullable;
            private long value;
            private int precision;

            private Builder() {
            }

            public final Builder from(Expression.PrecisionTimestampTZLiteral instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression.Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                Expression.Literal instance;
                long bits = 0L;
                if (object instanceof Expression.PrecisionTimestampTZLiteral) {
                    instance = (Expression.PrecisionTimestampTZLiteral)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.value(((Expression.PrecisionTimestampTZLiteral)instance).value());
                    this.precision(((Expression.PrecisionTimestampTZLiteral)instance).precision());
                }
                if (object instanceof Expression.Literal) {
                    instance = (Expression.Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.optBits |= 1L;
                return this;
            }

            public final Builder value(long value) {
                this.value = value;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder precision(int precision) {
                this.precision = precision;
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public PrecisionTimestampTZLiteral build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new PrecisionTimestampTZLiteral(this);
            }

            private boolean nullableIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("value");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("precision");
                }
                return "Cannot build PrecisionTimestampTZLiteral, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class PrecisionTimestampLiteral
    extends Expression.PrecisionTimestampLiteral {
        private final boolean nullable;
        private final long value;
        private final int precision;

        private PrecisionTimestampLiteral(Builder builder) {
            this.value = builder.value;
            this.precision = builder.precision;
            this.nullable = builder.nullableIsSet() ? builder.nullable : super.nullable();
        }

        private PrecisionTimestampLiteral(boolean nullable, long value, int precision) {
            this.nullable = nullable;
            this.value = value;
            this.precision = precision;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public long value() {
            return this.value;
        }

        @Override
        public int precision() {
            return this.precision;
        }

        public final PrecisionTimestampLiteral withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new PrecisionTimestampLiteral(value, this.value, this.precision);
        }

        public final PrecisionTimestampLiteral withValue(long value) {
            if (this.value == value) {
                return this;
            }
            return new PrecisionTimestampLiteral(this.nullable, value, this.precision);
        }

        public final PrecisionTimestampLiteral withPrecision(int value) {
            if (this.precision == value) {
                return this;
            }
            return new PrecisionTimestampLiteral(this.nullable, this.value, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof PrecisionTimestampLiteral && this.equalsByValue((PrecisionTimestampLiteral)another);
        }

        private boolean equalsByValue(PrecisionTimestampLiteral another) {
            return this.nullable == another.nullable && this.value == another.value && this.precision == another.precision;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + Long.hashCode(this.value);
            h += (h << 5) + this.precision;
            return h;
        }

        public String toString() {
            return "PrecisionTimestampLiteral{nullable=" + this.nullable + ", value=" + this.value + ", precision=" + this.precision + "}";
        }

        public static PrecisionTimestampLiteral copyOf(Expression.PrecisionTimestampLiteral instance) {
            if (instance instanceof PrecisionTimestampLiteral) {
                return (PrecisionTimestampLiteral)instance;
            }
            return PrecisionTimestampLiteral.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_VALUE = 1L;
            private static final long INIT_BIT_PRECISION = 2L;
            private static final long OPT_BIT_NULLABLE = 1L;
            private long initBits = 3L;
            private long optBits;
            private boolean nullable;
            private long value;
            private int precision;

            private Builder() {
            }

            public final Builder from(Expression.PrecisionTimestampLiteral instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression.Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                Expression.Literal instance;
                long bits = 0L;
                if (object instanceof Expression.PrecisionTimestampLiteral) {
                    instance = (Expression.PrecisionTimestampLiteral)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.value(((Expression.PrecisionTimestampLiteral)instance).value());
                    this.precision(((Expression.PrecisionTimestampLiteral)instance).precision());
                }
                if (object instanceof Expression.Literal) {
                    instance = (Expression.Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.optBits |= 1L;
                return this;
            }

            public final Builder value(long value) {
                this.value = value;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder precision(int precision) {
                this.precision = precision;
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public PrecisionTimestampLiteral build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new PrecisionTimestampLiteral(this);
            }

            private boolean nullableIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("value");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("precision");
                }
                return "Cannot build PrecisionTimestampLiteral, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class TimestampTZLiteral
    extends Expression.TimestampTZLiteral {
        private final boolean nullable;
        private final long value;

        private TimestampTZLiteral(Builder builder) {
            this.value = builder.value;
            this.nullable = builder.nullableIsSet() ? builder.nullable : super.nullable();
        }

        private TimestampTZLiteral(boolean nullable, long value) {
            this.nullable = nullable;
            this.value = value;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public long value() {
            return this.value;
        }

        public final TimestampTZLiteral withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new TimestampTZLiteral(value, this.value);
        }

        public final TimestampTZLiteral withValue(long value) {
            if (this.value == value) {
                return this;
            }
            return new TimestampTZLiteral(this.nullable, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof TimestampTZLiteral && this.equalsByValue((TimestampTZLiteral)another);
        }

        private boolean equalsByValue(TimestampTZLiteral another) {
            return this.nullable == another.nullable && this.value == another.value;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + Long.hashCode(this.value);
            return h;
        }

        public String toString() {
            return "TimestampTZLiteral{nullable=" + this.nullable + ", value=" + this.value + "}";
        }

        public static TimestampTZLiteral copyOf(Expression.TimestampTZLiteral instance) {
            if (instance instanceof TimestampTZLiteral) {
                return (TimestampTZLiteral)instance;
            }
            return TimestampTZLiteral.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_VALUE = 1L;
            private static final long OPT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private long optBits;
            private boolean nullable;
            private long value;

            private Builder() {
            }

            public final Builder from(Expression.TimestampTZLiteral instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression.Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                Expression.Literal instance;
                long bits = 0L;
                if (object instanceof Expression.TimestampTZLiteral) {
                    instance = (Expression.TimestampTZLiteral)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.value(((Expression.TimestampTZLiteral)instance).value());
                }
                if (object instanceof Expression.Literal) {
                    instance = (Expression.Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.optBits |= 1L;
                return this;
            }

            public final Builder value(long value) {
                this.value = value;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public TimestampTZLiteral build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new TimestampTZLiteral(this);
            }

            private boolean nullableIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("value");
                }
                return "Cannot build TimestampTZLiteral, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class DateLiteral
    extends Expression.DateLiteral {
        private final boolean nullable;
        private final int value;

        private DateLiteral(Builder builder) {
            this.value = builder.value;
            this.nullable = builder.nullableIsSet() ? builder.nullable : super.nullable();
        }

        private DateLiteral(boolean nullable, int value) {
            this.nullable = nullable;
            this.value = value;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public int value() {
            return this.value;
        }

        public final DateLiteral withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new DateLiteral(value, this.value);
        }

        public final DateLiteral withValue(int value) {
            if (this.value == value) {
                return this;
            }
            return new DateLiteral(this.nullable, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof DateLiteral && this.equalsByValue((DateLiteral)another);
        }

        private boolean equalsByValue(DateLiteral another) {
            return this.nullable == another.nullable && this.value == another.value;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.value;
            return h;
        }

        public String toString() {
            return "DateLiteral{nullable=" + this.nullable + ", value=" + this.value + "}";
        }

        public static DateLiteral copyOf(Expression.DateLiteral instance) {
            if (instance instanceof DateLiteral) {
                return (DateLiteral)instance;
            }
            return DateLiteral.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_VALUE = 1L;
            private static final long OPT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private long optBits;
            private boolean nullable;
            private int value;

            private Builder() {
            }

            public final Builder from(Expression.Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression.DateLiteral instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                Expression.Literal instance;
                long bits = 0L;
                if (object instanceof Expression.Literal) {
                    instance = (Expression.Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Expression.DateLiteral) {
                    instance = (Expression.DateLiteral)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.value(((Expression.DateLiteral)instance).value());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.optBits |= 1L;
                return this;
            }

            public final Builder value(int value) {
                this.value = value;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public DateLiteral build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new DateLiteral(this);
            }

            private boolean nullableIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("value");
                }
                return "Cannot build DateLiteral, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class TimeLiteral
    extends Expression.TimeLiteral {
        private final boolean nullable;
        private final long value;

        private TimeLiteral(Builder builder) {
            this.value = builder.value;
            this.nullable = builder.nullableIsSet() ? builder.nullable : super.nullable();
        }

        private TimeLiteral(boolean nullable, long value) {
            this.nullable = nullable;
            this.value = value;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public long value() {
            return this.value;
        }

        public final TimeLiteral withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new TimeLiteral(value, this.value);
        }

        public final TimeLiteral withValue(long value) {
            if (this.value == value) {
                return this;
            }
            return new TimeLiteral(this.nullable, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof TimeLiteral && this.equalsByValue((TimeLiteral)another);
        }

        private boolean equalsByValue(TimeLiteral another) {
            return this.nullable == another.nullable && this.value == another.value;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + Long.hashCode(this.value);
            return h;
        }

        public String toString() {
            return "TimeLiteral{nullable=" + this.nullable + ", value=" + this.value + "}";
        }

        public static TimeLiteral copyOf(Expression.TimeLiteral instance) {
            if (instance instanceof TimeLiteral) {
                return (TimeLiteral)instance;
            }
            return TimeLiteral.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_VALUE = 1L;
            private static final long OPT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private long optBits;
            private boolean nullable;
            private long value;

            private Builder() {
            }

            public final Builder from(Expression.TimeLiteral instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression.Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                Expression.Literal instance;
                long bits = 0L;
                if (object instanceof Expression.TimeLiteral) {
                    instance = (Expression.TimeLiteral)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.value(((Expression.TimeLiteral)instance).value());
                }
                if (object instanceof Expression.Literal) {
                    instance = (Expression.Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.optBits |= 1L;
                return this;
            }

            public final Builder value(long value) {
                this.value = value;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public TimeLiteral build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new TimeLiteral(this);
            }

            private boolean nullableIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("value");
                }
                return "Cannot build TimeLiteral, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class TimestampLiteral
    extends Expression.TimestampLiteral {
        private final boolean nullable;
        private final long value;

        private TimestampLiteral(Builder builder) {
            this.value = builder.value;
            this.nullable = builder.nullableIsSet() ? builder.nullable : super.nullable();
        }

        private TimestampLiteral(boolean nullable, long value) {
            this.nullable = nullable;
            this.value = value;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public long value() {
            return this.value;
        }

        public final TimestampLiteral withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new TimestampLiteral(value, this.value);
        }

        public final TimestampLiteral withValue(long value) {
            if (this.value == value) {
                return this;
            }
            return new TimestampLiteral(this.nullable, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof TimestampLiteral && this.equalsByValue((TimestampLiteral)another);
        }

        private boolean equalsByValue(TimestampLiteral another) {
            return this.nullable == another.nullable && this.value == another.value;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + Long.hashCode(this.value);
            return h;
        }

        public String toString() {
            return "TimestampLiteral{nullable=" + this.nullable + ", value=" + this.value + "}";
        }

        public static TimestampLiteral copyOf(Expression.TimestampLiteral instance) {
            if (instance instanceof TimestampLiteral) {
                return (TimestampLiteral)instance;
            }
            return TimestampLiteral.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_VALUE = 1L;
            private static final long OPT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private long optBits;
            private boolean nullable;
            private long value;

            private Builder() {
            }

            public final Builder from(Expression.TimestampLiteral instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression.Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                Expression.Literal instance;
                long bits = 0L;
                if (object instanceof Expression.TimestampLiteral) {
                    instance = (Expression.TimestampLiteral)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.value(((Expression.TimestampLiteral)instance).value());
                }
                if (object instanceof Expression.Literal) {
                    instance = (Expression.Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.optBits |= 1L;
                return this;
            }

            public final Builder value(long value) {
                this.value = value;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public TimestampLiteral build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new TimestampLiteral(this);
            }

            private boolean nullableIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("value");
                }
                return "Cannot build TimestampLiteral, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class BinaryLiteral
    extends Expression.BinaryLiteral {
        private final boolean nullable;
        private final ByteString value;

        private BinaryLiteral(Builder builder) {
            this.value = builder.value;
            this.nullable = builder.nullableIsSet() ? builder.nullable : super.nullable();
        }

        private BinaryLiteral(boolean nullable, ByteString value) {
            this.nullable = nullable;
            this.value = value;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public ByteString value() {
            return this.value;
        }

        public final BinaryLiteral withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new BinaryLiteral(value, this.value);
        }

        public final BinaryLiteral withValue(ByteString value) {
            if (this.value == value) {
                return this;
            }
            ByteString newValue = Objects.requireNonNull(value, "value");
            return new BinaryLiteral(this.nullable, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof BinaryLiteral && this.equalsByValue((BinaryLiteral)another);
        }

        private boolean equalsByValue(BinaryLiteral another) {
            return this.nullable == another.nullable && this.value.equals((Object)another.value);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.value.hashCode();
            return h;
        }

        public String toString() {
            return "BinaryLiteral{nullable=" + this.nullable + ", value=" + this.value + "}";
        }

        public static BinaryLiteral copyOf(Expression.BinaryLiteral instance) {
            if (instance instanceof BinaryLiteral) {
                return (BinaryLiteral)instance;
            }
            return BinaryLiteral.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_VALUE = 1L;
            private static final long OPT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private long optBits;
            private boolean nullable;
            private ByteString value;

            private Builder() {
            }

            public final Builder from(Expression.Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression.BinaryLiteral instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                Expression.Literal instance;
                long bits = 0L;
                if (object instanceof Expression.Literal) {
                    instance = (Expression.Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Expression.BinaryLiteral) {
                    instance = (Expression.BinaryLiteral)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.value(((Expression.BinaryLiteral)instance).value());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.optBits |= 1L;
                return this;
            }

            public final Builder value(ByteString value) {
                this.value = Objects.requireNonNull(value, "value");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public BinaryLiteral build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new BinaryLiteral(this);
            }

            private boolean nullableIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("value");
                }
                return "Cannot build BinaryLiteral, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class StrLiteral
    extends Expression.StrLiteral {
        private final boolean nullable;
        private final String value;

        private StrLiteral(Builder builder) {
            this.value = builder.value;
            this.nullable = builder.nullableIsSet() ? builder.nullable : super.nullable();
        }

        private StrLiteral(boolean nullable, String value) {
            this.nullable = nullable;
            this.value = value;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public String value() {
            return this.value;
        }

        public final StrLiteral withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new StrLiteral(value, this.value);
        }

        public final StrLiteral withValue(String value) {
            String newValue = Objects.requireNonNull(value, "value");
            if (this.value.equals(newValue)) {
                return this;
            }
            return new StrLiteral(this.nullable, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof StrLiteral && this.equalsByValue((StrLiteral)another);
        }

        private boolean equalsByValue(StrLiteral another) {
            return this.nullable == another.nullable && this.value.equals(another.value);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.value.hashCode();
            return h;
        }

        public String toString() {
            return "StrLiteral{nullable=" + this.nullable + ", value=" + this.value + "}";
        }

        public static StrLiteral copyOf(Expression.StrLiteral instance) {
            if (instance instanceof StrLiteral) {
                return (StrLiteral)instance;
            }
            return StrLiteral.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_VALUE = 1L;
            private static final long OPT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private long optBits;
            private boolean nullable;
            private String value;

            private Builder() {
            }

            public final Builder from(Expression.StrLiteral instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression.Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                Expression.Literal instance;
                long bits = 0L;
                if (object instanceof Expression.StrLiteral) {
                    instance = (Expression.StrLiteral)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.value(((Expression.StrLiteral)instance).value());
                }
                if (object instanceof Expression.Literal) {
                    instance = (Expression.Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.optBits |= 1L;
                return this;
            }

            public final Builder value(String value) {
                this.value = Objects.requireNonNull(value, "value");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public StrLiteral build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new StrLiteral(this);
            }

            private boolean nullableIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("value");
                }
                return "Cannot build StrLiteral, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class FP64Literal
    extends Expression.FP64Literal {
        private final boolean nullable;
        private final double value;

        private FP64Literal(Builder builder) {
            this.value = builder.value;
            this.nullable = builder.nullableIsSet() ? builder.nullable : super.nullable();
        }

        private FP64Literal(boolean nullable, double value) {
            this.nullable = nullable;
            this.value = value;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public double value() {
            return this.value;
        }

        public final FP64Literal withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new FP64Literal(value, this.value);
        }

        public final FP64Literal withValue(double value) {
            if (Double.doubleToLongBits(this.value) == Double.doubleToLongBits(value)) {
                return this;
            }
            return new FP64Literal(this.nullable, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof FP64Literal && this.equalsByValue((FP64Literal)another);
        }

        private boolean equalsByValue(FP64Literal another) {
            return this.nullable == another.nullable && Double.doubleToLongBits(this.value) == Double.doubleToLongBits(another.value);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + Double.hashCode(this.value);
            return h;
        }

        public String toString() {
            return "FP64Literal{nullable=" + this.nullable + ", value=" + this.value + "}";
        }

        public static FP64Literal copyOf(Expression.FP64Literal instance) {
            if (instance instanceof FP64Literal) {
                return (FP64Literal)instance;
            }
            return FP64Literal.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_VALUE = 1L;
            private static final long OPT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private long optBits;
            private boolean nullable;
            private double value;

            private Builder() {
            }

            public final Builder from(Expression.Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression.FP64Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                Expression.Literal instance;
                long bits = 0L;
                if (object instanceof Expression.Literal) {
                    instance = (Expression.Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Expression.FP64Literal) {
                    instance = (Expression.FP64Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.value(((Expression.FP64Literal)instance).value());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.optBits |= 1L;
                return this;
            }

            public final Builder value(double value) {
                this.value = value;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public FP64Literal build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new FP64Literal(this);
            }

            private boolean nullableIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("value");
                }
                return "Cannot build FP64Literal, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class FP32Literal
    extends Expression.FP32Literal {
        private final boolean nullable;
        private final float value;

        private FP32Literal(Builder builder) {
            this.value = builder.value;
            this.nullable = builder.nullableIsSet() ? builder.nullable : super.nullable();
        }

        private FP32Literal(boolean nullable, float value) {
            this.nullable = nullable;
            this.value = value;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public float value() {
            return this.value;
        }

        public final FP32Literal withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new FP32Literal(value, this.value);
        }

        public final FP32Literal withValue(float value) {
            if (Float.floatToIntBits(this.value) == Float.floatToIntBits(value)) {
                return this;
            }
            return new FP32Literal(this.nullable, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof FP32Literal && this.equalsByValue((FP32Literal)another);
        }

        private boolean equalsByValue(FP32Literal another) {
            return this.nullable == another.nullable && Float.floatToIntBits(this.value) == Float.floatToIntBits(another.value);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + Float.hashCode(this.value);
            return h;
        }

        public String toString() {
            return "FP32Literal{nullable=" + this.nullable + ", value=" + this.value + "}";
        }

        public static FP32Literal copyOf(Expression.FP32Literal instance) {
            if (instance instanceof FP32Literal) {
                return (FP32Literal)instance;
            }
            return FP32Literal.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_VALUE = 1L;
            private static final long OPT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private long optBits;
            private boolean nullable;
            private float value;

            private Builder() {
            }

            public final Builder from(Expression.FP32Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression.Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                Expression.Literal instance;
                long bits = 0L;
                if (object instanceof Expression.FP32Literal) {
                    instance = (Expression.FP32Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.value(((Expression.FP32Literal)instance).value());
                }
                if (object instanceof Expression.Literal) {
                    instance = (Expression.Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.optBits |= 1L;
                return this;
            }

            public final Builder value(float value) {
                this.value = value;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public FP32Literal build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new FP32Literal(this);
            }

            private boolean nullableIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("value");
                }
                return "Cannot build FP32Literal, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class I64Literal
    extends Expression.I64Literal {
        private final boolean nullable;
        private final long value;

        private I64Literal(Builder builder) {
            this.value = builder.value;
            this.nullable = builder.nullableIsSet() ? builder.nullable : super.nullable();
        }

        private I64Literal(boolean nullable, long value) {
            this.nullable = nullable;
            this.value = value;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public long value() {
            return this.value;
        }

        public final I64Literal withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new I64Literal(value, this.value);
        }

        public final I64Literal withValue(long value) {
            if (this.value == value) {
                return this;
            }
            return new I64Literal(this.nullable, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof I64Literal && this.equalsByValue((I64Literal)another);
        }

        private boolean equalsByValue(I64Literal another) {
            return this.nullable == another.nullable && this.value == another.value;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + Long.hashCode(this.value);
            return h;
        }

        public String toString() {
            return "I64Literal{nullable=" + this.nullable + ", value=" + this.value + "}";
        }

        public static I64Literal copyOf(Expression.I64Literal instance) {
            if (instance instanceof I64Literal) {
                return (I64Literal)instance;
            }
            return I64Literal.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_VALUE = 1L;
            private static final long OPT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private long optBits;
            private boolean nullable;
            private long value;

            private Builder() {
            }

            public final Builder from(Expression.I64Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression.Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                Expression.Literal instance;
                long bits = 0L;
                if (object instanceof Expression.I64Literal) {
                    instance = (Expression.I64Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.value(((Expression.I64Literal)instance).value());
                }
                if (object instanceof Expression.Literal) {
                    instance = (Expression.Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.optBits |= 1L;
                return this;
            }

            public final Builder value(long value) {
                this.value = value;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public I64Literal build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new I64Literal(this);
            }

            private boolean nullableIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("value");
                }
                return "Cannot build I64Literal, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class I32Literal
    extends Expression.I32Literal {
        private final boolean nullable;
        private final int value;

        private I32Literal(Builder builder) {
            this.value = builder.value;
            this.nullable = builder.nullableIsSet() ? builder.nullable : super.nullable();
        }

        private I32Literal(boolean nullable, int value) {
            this.nullable = nullable;
            this.value = value;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public int value() {
            return this.value;
        }

        public final I32Literal withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new I32Literal(value, this.value);
        }

        public final I32Literal withValue(int value) {
            if (this.value == value) {
                return this;
            }
            return new I32Literal(this.nullable, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof I32Literal && this.equalsByValue((I32Literal)another);
        }

        private boolean equalsByValue(I32Literal another) {
            return this.nullable == another.nullable && this.value == another.value;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.value;
            return h;
        }

        public String toString() {
            return "I32Literal{nullable=" + this.nullable + ", value=" + this.value + "}";
        }

        public static I32Literal copyOf(Expression.I32Literal instance) {
            if (instance instanceof I32Literal) {
                return (I32Literal)instance;
            }
            return I32Literal.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_VALUE = 1L;
            private static final long OPT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private long optBits;
            private boolean nullable;
            private int value;

            private Builder() {
            }

            public final Builder from(Expression.Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression.I32Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                Expression.Literal instance;
                long bits = 0L;
                if (object instanceof Expression.Literal) {
                    instance = (Expression.Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof Expression.I32Literal) {
                    instance = (Expression.I32Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.value(((Expression.I32Literal)instance).value());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.optBits |= 1L;
                return this;
            }

            public final Builder value(int value) {
                this.value = value;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public I32Literal build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new I32Literal(this);
            }

            private boolean nullableIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("value");
                }
                return "Cannot build I32Literal, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class I16Literal
    extends Expression.I16Literal {
        private final boolean nullable;
        private final int value;

        private I16Literal(Builder builder) {
            this.value = builder.value;
            this.nullable = builder.nullableIsSet() ? builder.nullable : super.nullable();
        }

        private I16Literal(boolean nullable, int value) {
            this.nullable = nullable;
            this.value = value;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public int value() {
            return this.value;
        }

        public final I16Literal withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new I16Literal(value, this.value);
        }

        public final I16Literal withValue(int value) {
            if (this.value == value) {
                return this;
            }
            return new I16Literal(this.nullable, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof I16Literal && this.equalsByValue((I16Literal)another);
        }

        private boolean equalsByValue(I16Literal another) {
            return this.nullable == another.nullable && this.value == another.value;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.value;
            return h;
        }

        public String toString() {
            return "I16Literal{nullable=" + this.nullable + ", value=" + this.value + "}";
        }

        public static I16Literal copyOf(Expression.I16Literal instance) {
            if (instance instanceof I16Literal) {
                return (I16Literal)instance;
            }
            return I16Literal.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_VALUE = 1L;
            private static final long OPT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private long optBits;
            private boolean nullable;
            private int value;

            private Builder() {
            }

            public final Builder from(Expression.I16Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression.Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                Expression.Literal instance;
                long bits = 0L;
                if (object instanceof Expression.I16Literal) {
                    instance = (Expression.I16Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.value(((Expression.I16Literal)instance).value());
                }
                if (object instanceof Expression.Literal) {
                    instance = (Expression.Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.optBits |= 1L;
                return this;
            }

            public final Builder value(int value) {
                this.value = value;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public I16Literal build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new I16Literal(this);
            }

            private boolean nullableIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("value");
                }
                return "Cannot build I16Literal, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class I8Literal
    extends Expression.I8Literal {
        private final boolean nullable;
        private final int value;

        private I8Literal(Builder builder) {
            this.value = builder.value;
            this.nullable = builder.nullableIsSet() ? builder.nullable : super.nullable();
        }

        private I8Literal(boolean nullable, int value) {
            this.nullable = nullable;
            this.value = value;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public int value() {
            return this.value;
        }

        public final I8Literal withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new I8Literal(value, this.value);
        }

        public final I8Literal withValue(int value) {
            if (this.value == value) {
                return this;
            }
            return new I8Literal(this.nullable, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof I8Literal && this.equalsByValue((I8Literal)another);
        }

        private boolean equalsByValue(I8Literal another) {
            return this.nullable == another.nullable && this.value == another.value;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.value;
            return h;
        }

        public String toString() {
            return "I8Literal{nullable=" + this.nullable + ", value=" + this.value + "}";
        }

        public static I8Literal copyOf(Expression.I8Literal instance) {
            if (instance instanceof I8Literal) {
                return (I8Literal)instance;
            }
            return I8Literal.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_VALUE = 1L;
            private static final long OPT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private long optBits;
            private boolean nullable;
            private int value;

            private Builder() {
            }

            public final Builder from(Expression.I8Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression.Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                Expression.Literal instance;
                long bits = 0L;
                if (object instanceof Expression.I8Literal) {
                    instance = (Expression.I8Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.value(((Expression.I8Literal)instance).value());
                }
                if (object instanceof Expression.Literal) {
                    instance = (Expression.Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.optBits |= 1L;
                return this;
            }

            public final Builder value(int value) {
                this.value = value;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public I8Literal build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new I8Literal(this);
            }

            private boolean nullableIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("value");
                }
                return "Cannot build I8Literal, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class BoolLiteral
    extends Expression.BoolLiteral {
        private final boolean nullable;
        private final Boolean value;

        private BoolLiteral(Builder builder) {
            this.value = builder.value;
            this.nullable = builder.nullableIsSet() ? builder.nullable : super.nullable();
        }

        private BoolLiteral(boolean nullable, Boolean value) {
            this.nullable = nullable;
            this.value = value;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public Boolean value() {
            return this.value;
        }

        public final BoolLiteral withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new BoolLiteral(value, this.value);
        }

        public final BoolLiteral withValue(Boolean value) {
            Boolean newValue = Objects.requireNonNull(value, "value");
            if (this.value.equals(newValue)) {
                return this;
            }
            return new BoolLiteral(this.nullable, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof BoolLiteral && this.equalsByValue((BoolLiteral)another);
        }

        private boolean equalsByValue(BoolLiteral another) {
            return this.nullable == another.nullable && this.value.equals(another.value);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.value.hashCode();
            return h;
        }

        public String toString() {
            return "BoolLiteral{nullable=" + this.nullable + ", value=" + this.value + "}";
        }

        public static BoolLiteral copyOf(Expression.BoolLiteral instance) {
            if (instance instanceof BoolLiteral) {
                return (BoolLiteral)instance;
            }
            return BoolLiteral.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_VALUE = 1L;
            private static final long OPT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private long optBits;
            private boolean nullable;
            private Boolean value;

            private Builder() {
            }

            public final Builder from(Expression.BoolLiteral instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression.Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                Expression.Literal instance;
                long bits = 0L;
                if (object instanceof Expression.BoolLiteral) {
                    instance = (Expression.BoolLiteral)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.value(((Expression.BoolLiteral)instance).value());
                }
                if (object instanceof Expression.Literal) {
                    instance = (Expression.Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.optBits |= 1L;
                return this;
            }

            public final Builder value(Boolean value) {
                this.value = Objects.requireNonNull(value, "value");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public BoolLiteral build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new BoolLiteral(this);
            }

            private boolean nullableIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("value");
                }
                return "Cannot build BoolLiteral, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class NullLiteral
    extends Expression.NullLiteral {
        private final boolean nullable;
        private final Type type;

        private NullLiteral(Builder builder) {
            this.type = builder.type;
            this.nullable = builder.nullableIsSet() ? builder.nullable : super.nullable();
        }

        private NullLiteral(boolean nullable, Type type) {
            this.nullable = nullable;
            this.type = type;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public Type type() {
            return this.type;
        }

        public final NullLiteral withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new NullLiteral(value, this.type);
        }

        public final NullLiteral withType(Type value) {
            if (this.type == value) {
                return this;
            }
            Type newValue = Objects.requireNonNull(value, "type");
            return new NullLiteral(this.nullable, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof NullLiteral && this.equalsByValue((NullLiteral)another);
        }

        private boolean equalsByValue(NullLiteral another) {
            return this.nullable == another.nullable && this.type.equals(another.type);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.type.hashCode();
            return h;
        }

        public String toString() {
            return "NullLiteral{nullable=" + this.nullable + ", type=" + this.type + "}";
        }

        public static NullLiteral copyOf(Expression.NullLiteral instance) {
            if (instance instanceof NullLiteral) {
                return (NullLiteral)instance;
            }
            return NullLiteral.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_TYPE = 1L;
            private static final long OPT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private long optBits;
            private boolean nullable;
            private Type type;

            private Builder() {
            }

            public final Builder from(Expression.NullLiteral instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(Expression.Literal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                Expression.Literal instance;
                long bits = 0L;
                if (object instanceof Expression.NullLiteral) {
                    instance = (Expression.NullLiteral)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.type(((Expression.NullLiteral)instance).type());
                }
                if (object instanceof Expression.Literal) {
                    instance = (Expression.Literal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.optBits |= 1L;
                return this;
            }

            public final Builder type(Type type) {
                this.type = Objects.requireNonNull(type, "type");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public NullLiteral build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new NullLiteral(this);
            }

            private boolean nullableIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("type");
                }
                return "Cannot build NullLiteral, some of required attributes are not set " + attributes;
            }
        }
    }
}

