/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation;

import com.google.protobuf.Any;
import io.substrait.expression.Expression;
import io.substrait.expression.FieldReference;
import io.substrait.expression.FunctionArg;
import io.substrait.expression.proto.ExpressionProtoConverter;
import io.substrait.extension.AdvancedExtension;
import io.substrait.extension.ExtensionCollector;
import io.substrait.extension.ExtensionProtoConverter;
import io.substrait.extension.SimpleExtension;
import io.substrait.hint.Hint;
import io.substrait.plan.Plan;
import io.substrait.proto.AggregateFunction;
import io.substrait.proto.AggregateRel;
import io.substrait.proto.ConsistentPartitionWindowRel;
import io.substrait.proto.CrossRel;
import io.substrait.proto.DdlRel;
import io.substrait.proto.ExchangeRel;
import io.substrait.proto.ExpandRel;
import io.substrait.proto.Expression;
import io.substrait.proto.ExtensionLeafRel;
import io.substrait.proto.ExtensionMultiRel;
import io.substrait.proto.ExtensionObject;
import io.substrait.proto.ExtensionSingleRel;
import io.substrait.proto.FetchRel;
import io.substrait.proto.FilterRel;
import io.substrait.proto.FunctionArgument;
import io.substrait.proto.HashJoinRel;
import io.substrait.proto.JoinRel;
import io.substrait.proto.MergeJoinRel;
import io.substrait.proto.NamedObjectWrite;
import io.substrait.proto.NamedTable;
import io.substrait.proto.NestedLoopJoinRel;
import io.substrait.proto.ProjectRel;
import io.substrait.proto.ReadRel;
import io.substrait.proto.RelCommon;
import io.substrait.proto.RelRoot;
import io.substrait.proto.SetRel;
import io.substrait.proto.SortField;
import io.substrait.proto.SortRel;
import io.substrait.proto.Type;
import io.substrait.proto.UpdateRel;
import io.substrait.proto.WriteRel;
import io.substrait.relation.AbstractUpdate;
import io.substrait.relation.Aggregate;
import io.substrait.relation.ConsistentPartitionWindow;
import io.substrait.relation.Cross;
import io.substrait.relation.EmptyScan;
import io.substrait.relation.Expand;
import io.substrait.relation.ExtensionDdl;
import io.substrait.relation.ExtensionLeaf;
import io.substrait.relation.ExtensionMulti;
import io.substrait.relation.ExtensionSingle;
import io.substrait.relation.ExtensionTable;
import io.substrait.relation.ExtensionWrite;
import io.substrait.relation.Fetch;
import io.substrait.relation.Filter;
import io.substrait.relation.Join;
import io.substrait.relation.LocalFiles;
import io.substrait.relation.NamedDdl;
import io.substrait.relation.NamedScan;
import io.substrait.relation.NamedUpdate;
import io.substrait.relation.NamedWrite;
import io.substrait.relation.Project;
import io.substrait.relation.Rel;
import io.substrait.relation.RelVisitor;
import io.substrait.relation.Set;
import io.substrait.relation.Sort;
import io.substrait.relation.VirtualTableScan;
import io.substrait.relation.files.FileOrFiles;
import io.substrait.relation.physical.AbstractExchangeRel;
import io.substrait.relation.physical.BroadcastExchange;
import io.substrait.relation.physical.HashJoin;
import io.substrait.relation.physical.MergeJoin;
import io.substrait.relation.physical.MultiBucketExchange;
import io.substrait.relation.physical.NestedLoopJoin;
import io.substrait.relation.physical.RoundRobinExchange;
import io.substrait.relation.physical.ScatterExchange;
import io.substrait.relation.physical.SingleBucketExchange;
import io.substrait.relation.physical.TargetType;
import io.substrait.type.proto.TypeProtoConverter;
import io.substrait.util.EmptyVisitationContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jspecify.annotations.NonNull;

public class RelProtoConverter
implements RelVisitor<io.substrait.proto.Rel, EmptyVisitationContext, RuntimeException> {
    protected final @NonNull ExpressionProtoConverter exprProtoConverter;
    protected final @NonNull TypeProtoConverter typeProtoConverter;
    protected final @NonNull ExtensionProtoConverter<?, ?> extensionProtoConverter;
    protected final @NonNull ExtensionCollector extensionCollector;

    public RelProtoConverter(@NonNull ExtensionCollector extensionCollector) {
        this(extensionCollector, new ExtensionProtoConverter());
    }

    public RelProtoConverter(@NonNull ExtensionCollector extensionCollector, @NonNull ExtensionProtoConverter<?, ?> extensionProtoConverter) {
        if (extensionCollector == null) {
            throw new IllegalArgumentException("ExtensionCollector is required");
        }
        if (extensionProtoConverter == null) {
            throw new IllegalArgumentException("ExtensionProtoConverter is required");
        }
        this.extensionCollector = extensionCollector;
        this.exprProtoConverter = new ExpressionProtoConverter(extensionCollector, this);
        this.typeProtoConverter = new TypeProtoConverter(extensionCollector);
        this.extensionProtoConverter = extensionProtoConverter;
    }

    public ExpressionProtoConverter getExpressionProtoConverter() {
        return this.exprProtoConverter;
    }

    public TypeProtoConverter getTypeProtoConverter() {
        return this.typeProtoConverter;
    }

    public RelRoot toProto(Plan.Root relRoot) {
        return RelRoot.newBuilder().setInput(this.toProto(relRoot.getInput())).addAllNames(relRoot.getNames()).build();
    }

    public io.substrait.proto.Rel toProto(Rel rel) {
        return rel.accept(this, EmptyVisitationContext.INSTANCE);
    }

    protected Expression toProto(io.substrait.expression.Expression expression) {
        return this.exprProtoConverter.toProto(expression);
    }

    protected List<Expression> toProto(List<io.substrait.expression.Expression> expression) {
        return this.exprProtoConverter.toProto(expression);
    }

    protected Type toProto(io.substrait.type.Type type) {
        return this.typeProtoConverter.toProto(type);
    }

    private List<SortField> toProtoS(List<Expression.SortField> sorts) {
        return sorts.stream().map(s -> SortField.newBuilder().setDirection(s.direction().toProto()).setExpr(this.toProto(s.expr())).build()).collect(Collectors.toList());
    }

    private Expression.FieldReference toProto(FieldReference fieldReference) {
        return this.toProto((io.substrait.expression.Expression)fieldReference).getSelection();
    }

    @Override
    public io.substrait.proto.Rel visit(Aggregate aggregate, EmptyVisitationContext context) throws RuntimeException {
        AggregateRel.Builder builder = AggregateRel.newBuilder().setInput(this.toProto(aggregate.getInput())).setCommon(this.common(aggregate)).addAllGroupings(aggregate.getGroupings().stream().map(this::toProto).collect(Collectors.toList())).addAllMeasures(aggregate.getMeasures().stream().map(this::toProto).collect(Collectors.toList()));
        aggregate.getExtension().ifPresent(ae -> builder.setAdvancedExtension(this.extensionProtoConverter.toProto((AdvancedExtension<?, ?>)ae)));
        return io.substrait.proto.Rel.newBuilder().setAggregate(builder).build();
    }

    private AggregateRel.Measure toProto(Aggregate.Measure measure) {
        FunctionArg.FuncArgVisitor<FunctionArgument, EmptyVisitationContext, RuntimeException> argVisitor = FunctionArg.toProto(this.typeProtoConverter, this.exprProtoConverter);
        List<FunctionArg> args = measure.getFunction().arguments();
        SimpleExtension.AggregateFunctionVariant aggFuncDef = measure.getFunction().declaration();
        AggregateFunction.Builder func = AggregateFunction.newBuilder().setPhase(measure.getFunction().aggregationPhase().toProto()).setInvocation(measure.getFunction().invocation().toProto()).setOutputType(this.toProto(measure.getFunction().getType())).addAllArguments(IntStream.range(0, args.size()).mapToObj(i -> (FunctionArgument)((FunctionArg)args.get(i)).accept(aggFuncDef, i, argVisitor, EmptyVisitationContext.INSTANCE)).collect(Collectors.toList())).addAllSorts(this.toProtoS(measure.getFunction().sort())).setFunctionReference(this.extensionCollector.getFunctionReference(measure.getFunction().declaration())).addAllOptions(measure.getFunction().options().stream().map(ExpressionProtoConverter::from).collect(Collectors.toList()));
        AggregateRel.Measure.Builder builder = AggregateRel.Measure.newBuilder().setMeasure(func);
        measure.getPreMeasureFilter().ifPresent(f -> builder.setFilter(this.toProto((io.substrait.expression.Expression)f)));
        return builder.build();
    }

    private AggregateRel.Grouping toProto(Aggregate.Grouping grouping) {
        return AggregateRel.Grouping.newBuilder().addAllGroupingExpressions(this.toProto(grouping.getExpressions())).build();
    }

    @Override
    public io.substrait.proto.Rel visit(EmptyScan emptyScan, EmptyVisitationContext context) throws RuntimeException {
        ReadRel.Builder builder = ReadRel.newBuilder().setCommon(this.common(emptyScan)).setVirtualTable(ReadRel.VirtualTable.newBuilder().build()).setBaseSchema(emptyScan.getInitialSchema().toProto(this.typeProtoConverter));
        emptyScan.getExtension().ifPresent(ae -> builder.setAdvancedExtension(this.extensionProtoConverter.toProto((AdvancedExtension<?, ?>)ae)));
        return io.substrait.proto.Rel.newBuilder().setRead(builder.build()).build();
    }

    @Override
    public io.substrait.proto.Rel visit(Fetch fetch, EmptyVisitationContext context) throws RuntimeException {
        FetchRel.Builder builder = FetchRel.newBuilder().setCommon(this.common(fetch)).setInput(this.toProto(fetch.getInput())).setOffset(fetch.getOffset()).setCount(fetch.getCount().orElse(-1L));
        fetch.getExtension().ifPresent(ae -> builder.setAdvancedExtension(this.extensionProtoConverter.toProto((AdvancedExtension<?, ?>)ae)));
        return io.substrait.proto.Rel.newBuilder().setFetch(builder).build();
    }

    @Override
    public io.substrait.proto.Rel visit(Filter filter, EmptyVisitationContext context) throws RuntimeException {
        FilterRel.Builder builder = FilterRel.newBuilder().setCommon(this.common(filter)).setInput(this.toProto(filter.getInput())).setCondition(this.toProto(filter.getCondition()));
        filter.getExtension().ifPresent(ae -> builder.setAdvancedExtension(this.extensionProtoConverter.toProto((AdvancedExtension<?, ?>)ae)));
        return io.substrait.proto.Rel.newBuilder().setFilter(builder).build();
    }

    @Override
    public io.substrait.proto.Rel visit(Join join, EmptyVisitationContext context) throws RuntimeException {
        JoinRel.Builder builder = JoinRel.newBuilder().setCommon(this.common(join)).setLeft(this.toProto(join.getLeft())).setRight(this.toProto(join.getRight())).setType(join.getJoinType().toProto());
        join.getCondition().ifPresent(t -> builder.setExpression(this.toProto((io.substrait.expression.Expression)t)));
        join.getPostJoinFilter().ifPresent(t -> builder.setPostJoinFilter(this.toProto((io.substrait.expression.Expression)t)));
        join.getExtension().ifPresent(ae -> builder.setAdvancedExtension(this.extensionProtoConverter.toProto((AdvancedExtension<?, ?>)ae)));
        return io.substrait.proto.Rel.newBuilder().setJoin(builder).build();
    }

    @Override
    public io.substrait.proto.Rel visit(Set set, EmptyVisitationContext context) throws RuntimeException {
        SetRel.Builder builder = SetRel.newBuilder().setCommon(this.common(set)).setOp(set.getSetOp().toProto());
        set.getInputs().forEach(inputRel -> builder.addInputs(this.toProto((Rel)inputRel)));
        set.getExtension().ifPresent(ae -> builder.setAdvancedExtension(this.extensionProtoConverter.toProto((AdvancedExtension<?, ?>)ae)));
        return io.substrait.proto.Rel.newBuilder().setSet(builder).build();
    }

    @Override
    public io.substrait.proto.Rel visit(NamedScan namedScan, EmptyVisitationContext context) throws RuntimeException {
        ReadRel.Builder builder = ReadRel.newBuilder().setCommon(this.common(namedScan)).setNamedTable(ReadRel.NamedTable.newBuilder().addAllNames(namedScan.getNames())).setBaseSchema(namedScan.getInitialSchema().toProto(this.typeProtoConverter));
        namedScan.getFilter().ifPresent(f -> builder.setFilter(this.toProto((io.substrait.expression.Expression)f)));
        namedScan.getBestEffortFilter().ifPresent(f -> builder.setBestEffortFilter(this.toProto((io.substrait.expression.Expression)f)));
        namedScan.getExtension().ifPresent(ae -> builder.setAdvancedExtension(this.extensionProtoConverter.toProto((AdvancedExtension<?, ?>)ae)));
        return io.substrait.proto.Rel.newBuilder().setRead(builder).build();
    }

    @Override
    public io.substrait.proto.Rel visit(LocalFiles localFiles, EmptyVisitationContext context) throws RuntimeException {
        ReadRel.Builder builder = ReadRel.newBuilder().setCommon(this.common(localFiles)).setLocalFiles(ReadRel.LocalFiles.newBuilder().addAllItems(localFiles.getItems().stream().map(FileOrFiles::toProto).collect(Collectors.toList())).build()).setBaseSchema(localFiles.getInitialSchema().toProto(this.typeProtoConverter));
        localFiles.getFilter().ifPresent(t -> builder.setFilter(this.toProto((io.substrait.expression.Expression)t)));
        localFiles.getBestEffortFilter().ifPresent(t -> builder.setBestEffortFilter(this.toProto((io.substrait.expression.Expression)t)));
        localFiles.getExtension().ifPresent(ae -> builder.setAdvancedExtension(this.extensionProtoConverter.toProto((AdvancedExtension<?, ?>)ae)));
        return io.substrait.proto.Rel.newBuilder().setRead(builder.build()).build();
    }

    @Override
    public io.substrait.proto.Rel visit(ExtensionTable extensionTable, EmptyVisitationContext context) throws RuntimeException {
        ReadRel.ExtensionTable.Builder extensionTableBuilder = ReadRel.ExtensionTable.newBuilder().setDetail((Any)extensionTable.getDetail().toProto(this));
        ReadRel.Builder builder = ReadRel.newBuilder().setCommon(this.common(extensionTable)).setBaseSchema(extensionTable.getInitialSchema().toProto(this.typeProtoConverter)).setExtensionTable(extensionTableBuilder);
        extensionTable.getExtension().ifPresent(ae -> builder.setAdvancedExtension(this.extensionProtoConverter.toProto((AdvancedExtension<?, ?>)ae)));
        return io.substrait.proto.Rel.newBuilder().setRead(builder).build();
    }

    @Override
    public io.substrait.proto.Rel visit(HashJoin hashJoin, EmptyVisitationContext context) throws RuntimeException {
        HashJoinRel.Builder builder = HashJoinRel.newBuilder().setCommon(this.common(hashJoin)).setLeft(this.toProto(hashJoin.getLeft())).setRight(this.toProto(hashJoin.getRight())).setType(hashJoin.getJoinType().toProto());
        List<FieldReference> leftKeys = hashJoin.getLeftKeys();
        List<FieldReference> rightKeys = hashJoin.getRightKeys();
        if (leftKeys.size() != rightKeys.size()) {
            throw new IllegalArgumentException("Number of left and right keys must be equal.");
        }
        builder.addAllLeftKeys(leftKeys.stream().map(this::toProto).collect(Collectors.toList()));
        builder.addAllRightKeys(rightKeys.stream().map(this::toProto).collect(Collectors.toList()));
        hashJoin.getPostJoinFilter().ifPresent(t -> builder.setPostJoinFilter(this.toProto((io.substrait.expression.Expression)t)));
        hashJoin.getExtension().ifPresent(ae -> builder.setAdvancedExtension(this.extensionProtoConverter.toProto((AdvancedExtension<?, ?>)ae)));
        return io.substrait.proto.Rel.newBuilder().setHashJoin(builder).build();
    }

    @Override
    public io.substrait.proto.Rel visit(MergeJoin mergeJoin, EmptyVisitationContext context) throws RuntimeException {
        MergeJoinRel.Builder builder = MergeJoinRel.newBuilder().setCommon(this.common(mergeJoin)).setLeft(this.toProto(mergeJoin.getLeft())).setRight(this.toProto(mergeJoin.getRight())).setType(mergeJoin.getJoinType().toProto());
        List<FieldReference> leftKeys = mergeJoin.getLeftKeys();
        List<FieldReference> rightKeys = mergeJoin.getRightKeys();
        if (leftKeys.size() != rightKeys.size()) {
            throw new IllegalArgumentException("Number of left and right keys must be equal.");
        }
        builder.addAllLeftKeys(leftKeys.stream().map(this::toProto).collect(Collectors.toList()));
        builder.addAllRightKeys(rightKeys.stream().map(this::toProto).collect(Collectors.toList()));
        mergeJoin.getPostJoinFilter().ifPresent(t -> builder.setPostJoinFilter(this.toProto((io.substrait.expression.Expression)t)));
        mergeJoin.getExtension().ifPresent(ae -> builder.setAdvancedExtension(this.extensionProtoConverter.toProto((AdvancedExtension<?, ?>)ae)));
        return io.substrait.proto.Rel.newBuilder().setMergeJoin(builder).build();
    }

    @Override
    public io.substrait.proto.Rel visit(NestedLoopJoin nestedLoopJoin, EmptyVisitationContext context) throws RuntimeException {
        NestedLoopJoinRel.Builder builder = NestedLoopJoinRel.newBuilder().setCommon(this.common(nestedLoopJoin)).setLeft(this.toProto(nestedLoopJoin.getLeft())).setRight(this.toProto(nestedLoopJoin.getRight())).setExpression(this.toProto(nestedLoopJoin.getCondition())).setType(nestedLoopJoin.getJoinType().toProto());
        nestedLoopJoin.getExtension().ifPresent(ae -> builder.setAdvancedExtension(this.extensionProtoConverter.toProto((AdvancedExtension<?, ?>)ae)));
        return io.substrait.proto.Rel.newBuilder().setNestedLoopJoin(builder).build();
    }

    @Override
    public io.substrait.proto.Rel visit(ConsistentPartitionWindow consistentPartitionWindow, EmptyVisitationContext context) throws RuntimeException {
        ConsistentPartitionWindowRel.Builder builder = ConsistentPartitionWindowRel.newBuilder().setCommon(this.common(consistentPartitionWindow)).setInput(this.toProto(consistentPartitionWindow.getInput())).addAllSorts(this.toProtoS(consistentPartitionWindow.getSorts())).addAllPartitionExpressions(this.toProto(consistentPartitionWindow.getPartitionExpressions())).addAllWindowFunctions(this.toProtoWindowRelFunctions(consistentPartitionWindow.getWindowFunctions()));
        consistentPartitionWindow.getExtension().ifPresent(ae -> builder.setAdvancedExtension(this.extensionProtoConverter.toProto((AdvancedExtension<?, ?>)ae)));
        return io.substrait.proto.Rel.newBuilder().setWindow(builder).build();
    }

    @Override
    public io.substrait.proto.Rel visit(NamedWrite write, EmptyVisitationContext context) throws RuntimeException {
        WriteRel.Builder builder = WriteRel.newBuilder().setCommon(this.common(write)).setInput(this.toProto(write.getInput())).setNamedTable(NamedObjectWrite.newBuilder().addAllNames(write.getNames())).setTableSchema(write.getTableSchema().toProto(this.typeProtoConverter)).setOp(write.getOperation().toProto()).setCreateMode(write.getCreateMode().toProto()).setOutput(write.getOutputMode().toProto());
        write.getExtension().ifPresent(ae -> builder.setAdvancedExtension(this.extensionProtoConverter.toProto((AdvancedExtension<?, ?>)ae)));
        return io.substrait.proto.Rel.newBuilder().setWrite(builder).build();
    }

    @Override
    public io.substrait.proto.Rel visit(ExtensionWrite write, EmptyVisitationContext context) throws RuntimeException {
        WriteRel.Builder builder = WriteRel.newBuilder().setCommon(this.common(write)).setInput(this.toProto(write.getInput())).setExtensionTable(ExtensionObject.newBuilder().setDetail((Any)write.getDetail().toProto(this))).setTableSchema(write.getTableSchema().toProto(this.typeProtoConverter)).setOp(write.getOperation().toProto()).setCreateMode(write.getCreateMode().toProto()).setOutput(write.getOutputMode().toProto());
        write.getExtension().ifPresent(ae -> builder.setAdvancedExtension(this.extensionProtoConverter.toProto((AdvancedExtension<?, ?>)ae)));
        return io.substrait.proto.Rel.newBuilder().setWrite(builder).build();
    }

    @Override
    public io.substrait.proto.Rel visit(NamedDdl ddl, EmptyVisitationContext context) throws RuntimeException {
        DdlRel.Builder builder = DdlRel.newBuilder().setCommon(this.common(ddl)).setTableSchema(ddl.getTableSchema().toProto(this.typeProtoConverter)).setTableDefaults(this.toProto(ddl.getTableDefaults()).getLiteral().getStruct()).setNamedObject(NamedObjectWrite.newBuilder().addAllNames(ddl.getNames())).setObject(ddl.getObject().toProto()).setOp(ddl.getOperation().toProto());
        if (ddl.getViewDefinition().isPresent()) {
            builder.setViewDefinition(this.toProto(ddl.getViewDefinition().get()));
        }
        ddl.getExtension().ifPresent(ae -> builder.setAdvancedExtension(this.extensionProtoConverter.toProto((AdvancedExtension<?, ?>)ae)));
        return io.substrait.proto.Rel.newBuilder().setDdl(builder).build();
    }

    @Override
    public io.substrait.proto.Rel visit(ExtensionDdl ddl, EmptyVisitationContext context) throws RuntimeException {
        DdlRel.Builder builder = DdlRel.newBuilder().setCommon(this.common(ddl)).setTableSchema(ddl.getTableSchema().toProto(this.typeProtoConverter)).setTableDefaults(this.toProto(ddl.getTableDefaults()).getLiteral().getStruct()).setExtensionObject(ExtensionObject.newBuilder().setDetail((Any)ddl.getDetail().toProto(this))).setObject(ddl.getObject().toProto()).setOp(ddl.getOperation().toProto());
        if (ddl.getViewDefinition().isPresent()) {
            builder.setViewDefinition(this.toProto(ddl.getViewDefinition().get()));
        }
        ddl.getExtension().ifPresent(ae -> builder.setAdvancedExtension(this.extensionProtoConverter.toProto((AdvancedExtension<?, ?>)ae)));
        return io.substrait.proto.Rel.newBuilder().setDdl(builder).build();
    }

    @Override
    public io.substrait.proto.Rel visit(NamedUpdate update, EmptyVisitationContext context) throws RuntimeException {
        UpdateRel.Builder builder = UpdateRel.newBuilder().setNamedTable(NamedTable.newBuilder().addAllNames(update.getNames())).setTableSchema(update.getTableSchema().toProto(this.typeProtoConverter)).addAllTransformations(update.getTransformations().stream().map(this::toProto).collect(Collectors.toList())).setCondition(this.toProto(update.getCondition()));
        update.getExtension().ifPresent(ae -> builder.setAdvancedExtension(this.extensionProtoConverter.toProto((AdvancedExtension<?, ?>)ae)));
        return io.substrait.proto.Rel.newBuilder().setUpdate(builder).build();
    }

    @Override
    public io.substrait.proto.Rel visit(ScatterExchange exchange, EmptyVisitationContext context) throws RuntimeException {
        ExchangeRel.Builder builder = ExchangeRel.newBuilder().setScatterByFields(ExchangeRel.ScatterFields.newBuilder().addAllFields(exchange.getFields().stream().map(this::toProto).collect(Collectors.toList())).build()).setPartitionCount(exchange.getPartitionCount()).addAllTargets(exchange.getTargets().stream().map(this::toProto).collect(Collectors.toList())).setCommon(this.common(exchange)).setInput(this.toProto(exchange.getInput()));
        return io.substrait.proto.Rel.newBuilder().setExchange(builder).build();
    }

    @Override
    public io.substrait.proto.Rel visit(SingleBucketExchange exchange, EmptyVisitationContext context) throws RuntimeException {
        ExchangeRel.Builder builder = ExchangeRel.newBuilder().setSingleTarget(ExchangeRel.SingleBucketExpression.newBuilder().setExpression(this.toProto(exchange.getExpression())).build()).setPartitionCount(exchange.getPartitionCount()).addAllTargets(exchange.getTargets().stream().map(this::toProto).collect(Collectors.toList())).setCommon(this.common(exchange)).setInput(this.toProto(exchange.getInput()));
        return io.substrait.proto.Rel.newBuilder().setExchange(builder).build();
    }

    @Override
    public io.substrait.proto.Rel visit(MultiBucketExchange exchange, EmptyVisitationContext context) throws RuntimeException {
        ExchangeRel.Builder builder = ExchangeRel.newBuilder().setMultiTarget(ExchangeRel.MultiBucketExpression.newBuilder().setExpression(this.toProto(exchange.getExpression())).setConstrainedToCount(exchange.getConstrainedToCount()).build()).setPartitionCount(exchange.getPartitionCount()).addAllTargets(exchange.getTargets().stream().map(this::toProto).collect(Collectors.toList())).setCommon(this.common(exchange)).setInput(this.toProto(exchange.getInput()));
        return io.substrait.proto.Rel.newBuilder().setExchange(builder).build();
    }

    @Override
    public io.substrait.proto.Rel visit(RoundRobinExchange exchange, EmptyVisitationContext context) throws RuntimeException {
        ExchangeRel.Builder builder = ExchangeRel.newBuilder().setRoundRobin(ExchangeRel.RoundRobin.newBuilder().setExact(exchange.getExact()).build()).setPartitionCount(exchange.getPartitionCount()).addAllTargets(exchange.getTargets().stream().map(this::toProto).collect(Collectors.toList())).setCommon(this.common(exchange)).setInput(this.toProto(exchange.getInput()));
        return io.substrait.proto.Rel.newBuilder().setExchange(builder).build();
    }

    @Override
    public io.substrait.proto.Rel visit(BroadcastExchange exchange, EmptyVisitationContext context) throws RuntimeException {
        ExchangeRel.Builder builder = ExchangeRel.newBuilder().setBroadcast(ExchangeRel.Broadcast.newBuilder().build()).setPartitionCount(exchange.getPartitionCount()).addAllTargets(exchange.getTargets().stream().map(this::toProto).collect(Collectors.toList())).setCommon(this.common(exchange)).setInput(this.toProto(exchange.getInput()));
        return io.substrait.proto.Rel.newBuilder().setExchange(builder).build();
    }

    private ExchangeRel.ExchangeTarget toProto(AbstractExchangeRel.ExchangeTarget target) {
        ExchangeRel.ExchangeTarget.Builder builder = ExchangeRel.ExchangeTarget.newBuilder().addAllPartitionId(target.getPartitionIds());
        if (target.getType() instanceof TargetType.Uri) {
            builder.setUri(((TargetType.Uri)target.getType()).getUri());
        } else if (target.getType() instanceof TargetType.Extended) {
            builder.setExtended(((TargetType.Extended)target.getType()).getExtended());
        }
        return builder.build();
    }

    UpdateRel.TransformExpression toProto(AbstractUpdate.TransformExpression transformation) {
        return UpdateRel.TransformExpression.newBuilder().setTransformation(this.toProto(transformation.getTransformation())).setColumnTarget(transformation.getColumnTarget()).build();
    }

    private List<ConsistentPartitionWindowRel.WindowRelFunction> toProtoWindowRelFunctions(Collection<ConsistentPartitionWindow.WindowRelFunctionInvocation> windowRelFunctionInvocations) {
        return windowRelFunctionInvocations.stream().map(f -> {
            FunctionArg.FuncArgVisitor<FunctionArgument, EmptyVisitationContext, RuntimeException> argVisitor = FunctionArg.toProto(this.typeProtoConverter, this.exprProtoConverter);
            List<FunctionArg> args = f.arguments();
            SimpleExtension.WindowFunctionVariant aggFuncDef = f.declaration();
            List arguments = IntStream.range(0, args.size()).mapToObj(i -> (FunctionArgument)((FunctionArg)args.get(i)).accept(aggFuncDef, i, argVisitor, EmptyVisitationContext.INSTANCE)).collect(Collectors.toList());
            List options = f.options().stream().map(ExpressionProtoConverter::from).collect(Collectors.toList());
            return ConsistentPartitionWindowRel.WindowRelFunction.newBuilder().setInvocation(f.invocation().toProto()).setPhase(f.aggregationPhase().toProto()).setOutputType(this.toProto(f.outputType())).addAllArguments(arguments).addAllOptions(options).setFunctionReference(this.extensionCollector.getFunctionReference(f.declaration())).setBoundsType(f.boundsType().toProto()).setLowerBound(ExpressionProtoConverter.BoundConverter.convert(f.lowerBound())).setUpperBound(ExpressionProtoConverter.BoundConverter.convert(f.upperBound())).build();
        }).collect(Collectors.toList());
    }

    @Override
    public io.substrait.proto.Rel visit(Project project, EmptyVisitationContext context) throws RuntimeException {
        ProjectRel.Builder builder = ProjectRel.newBuilder().setCommon(this.common(project)).setInput(this.toProto(project.getInput())).addAllExpressions(this.toProto(project.getExpressions()));
        project.getExtension().ifPresent(ae -> builder.setAdvancedExtension(this.extensionProtoConverter.toProto((AdvancedExtension<?, ?>)ae)));
        return io.substrait.proto.Rel.newBuilder().setProject(builder).build();
    }

    @Override
    public io.substrait.proto.Rel visit(Expand expand, EmptyVisitationContext context) throws RuntimeException {
        ExpandRel.Builder builder = ExpandRel.newBuilder().setCommon(this.common(expand)).setInput(this.toProto(expand.getInput()));
        expand.getFields().forEach(expandField -> {
            if (expandField instanceof Expand.ConsistentField) {
                Expand.ConsistentField cf = (Expand.ConsistentField)expandField;
                builder.addFields(ExpandRel.ExpandField.newBuilder().setConsistentField(this.toProto(cf.getExpression())).build());
            } else if (expandField instanceof Expand.SwitchingField) {
                Expand.SwitchingField sf = (Expand.SwitchingField)expandField;
                builder.addFields(ExpandRel.ExpandField.newBuilder().setSwitchingField(ExpandRel.SwitchingField.newBuilder().addAllDuplicates(this.toProto(sf.getDuplicates()))).build());
            } else {
                throw new IllegalArgumentException("Consistent or Switching fields must be set for the Expand relation.");
            }
        });
        return io.substrait.proto.Rel.newBuilder().setExpand(builder).build();
    }

    @Override
    public io.substrait.proto.Rel visit(Sort sort, EmptyVisitationContext context) throws RuntimeException {
        SortRel.Builder builder = SortRel.newBuilder().setCommon(this.common(sort)).setInput(this.toProto(sort.getInput())).addAllSorts(this.toProtoS(sort.getSortFields()));
        sort.getExtension().ifPresent(ae -> builder.setAdvancedExtension(this.extensionProtoConverter.toProto((AdvancedExtension<?, ?>)ae)));
        return io.substrait.proto.Rel.newBuilder().setSort(builder).build();
    }

    @Override
    public io.substrait.proto.Rel visit(Cross cross, EmptyVisitationContext context) throws RuntimeException {
        CrossRel.Builder builder = CrossRel.newBuilder().setCommon(this.common(cross)).setLeft(this.toProto(cross.getLeft())).setRight(this.toProto(cross.getRight()));
        cross.getExtension().ifPresent(ae -> builder.setAdvancedExtension(this.extensionProtoConverter.toProto((AdvancedExtension<?, ?>)ae)));
        return io.substrait.proto.Rel.newBuilder().setCross(builder).build();
    }

    @Override
    public io.substrait.proto.Rel visit(VirtualTableScan virtualTableScan, EmptyVisitationContext context) throws RuntimeException {
        ArrayList<Expression.Nested.Struct> structs = new ArrayList<Expression.Nested.Struct>();
        for (Expression.NestedStruct row : virtualTableScan.getRows()) {
            structs.add(Expression.Nested.Struct.newBuilder().addAllFields(row.fields().stream().map(this::toProto).collect(Collectors.toList())).build());
        }
        ReadRel.Builder builder = ReadRel.newBuilder().setCommon(this.common(virtualTableScan)).setVirtualTable(ReadRel.VirtualTable.newBuilder().addAllExpressions(structs).build()).setBaseSchema(virtualTableScan.getInitialSchema().toProto(this.typeProtoConverter));
        virtualTableScan.getFilter().ifPresent(f -> builder.setFilter(this.toProto((io.substrait.expression.Expression)f)));
        virtualTableScan.getBestEffortFilter().ifPresent(f -> builder.setBestEffortFilter(this.toProto((io.substrait.expression.Expression)f)));
        virtualTableScan.getExtension().ifPresent(ae -> builder.setAdvancedExtension(this.extensionProtoConverter.toProto((AdvancedExtension<?, ?>)ae)));
        return io.substrait.proto.Rel.newBuilder().setRead(builder).build();
    }

    @Override
    public io.substrait.proto.Rel visit(ExtensionLeaf extensionLeaf, EmptyVisitationContext context) throws RuntimeException {
        ExtensionLeafRel.Builder builder = ExtensionLeafRel.newBuilder().setCommon(this.common(extensionLeaf)).setDetail((Any)extensionLeaf.getDetail().toProto(this));
        return io.substrait.proto.Rel.newBuilder().setExtensionLeaf(builder).build();
    }

    @Override
    public io.substrait.proto.Rel visit(ExtensionSingle extensionSingle, EmptyVisitationContext context) throws RuntimeException {
        ExtensionSingleRel.Builder builder = ExtensionSingleRel.newBuilder().setCommon(this.common(extensionSingle)).setInput(this.toProto(extensionSingle.getInput())).setDetail((Any)extensionSingle.getDetail().toProto(this));
        return io.substrait.proto.Rel.newBuilder().setExtensionSingle(builder).build();
    }

    @Override
    public io.substrait.proto.Rel visit(ExtensionMulti extensionMulti, EmptyVisitationContext context) throws RuntimeException {
        List inputs = extensionMulti.getInputs().stream().map(this::toProto).collect(Collectors.toList());
        ExtensionMultiRel.Builder builder = ExtensionMultiRel.newBuilder().setCommon(this.common(extensionMulti)).addAllInputs(inputs).setDetail((Any)extensionMulti.getDetail().toProto(this));
        return io.substrait.proto.Rel.newBuilder().setExtensionMulti(builder).build();
    }

    private RelCommon common(Rel rel) {
        RelCommon.Builder builder = RelCommon.newBuilder();
        rel.getCommonExtension().ifPresent(extension -> builder.setAdvancedExtension(this.extensionProtoConverter.toProto((AdvancedExtension<?, ?>)extension)));
        Rel.Remap remap = rel.getRemap().orElse(null);
        if (remap != null) {
            builder.setEmit(RelCommon.Emit.newBuilder().addAllOutputMapping(remap.indices()));
        } else {
            builder.setDirect(RelCommon.Direct.getDefaultInstance());
        }
        if (rel.getHint().isPresent()) {
            Hint hint = rel.getHint().get();
            RelCommon.Hint.Builder hintBuilder = RelCommon.Hint.newBuilder();
            hint.getAlias().ifPresent(hintBuilder::setAlias);
            hintBuilder.addAllOutputNames(hint.getOutputNames());
            if (hint.getStats().isPresent()) {
                Hint.Stats stats = hint.getStats().get();
                RelCommon.Hint.Stats.Builder statsBuilder = RelCommon.Hint.Stats.newBuilder();
                stats.getExtension().ifPresent(ae -> statsBuilder.setAdvancedExtension(this.extensionProtoConverter.toProto((AdvancedExtension<?, ?>)ae)));
                hintBuilder.setStats(statsBuilder.setRowCount(stats.rowCount()).setRecordSize(stats.recordSize()));
            }
            if (hint.getRuntimeConstraint().isPresent()) {
                Hint.RuntimeConstraint rc = hint.getRuntimeConstraint().get();
                RelCommon.Hint.RuntimeConstraint.Builder rcBuilder = RelCommon.Hint.RuntimeConstraint.newBuilder();
                rc.getExtension().ifPresent(ae -> rcBuilder.setAdvancedExtension(this.extensionProtoConverter.toProto((AdvancedExtension<?, ?>)ae)));
                hintBuilder.setConstraint(rcBuilder);
            }
            hint.getLoadedComputations().forEach(loadedComp -> hintBuilder.addLoadedComputations(RelCommon.Hint.LoadedComputation.newBuilder().setComputationIdReference(loadedComp.computationId()).setType(loadedComp.computationType().toProto())));
            hint.getSavedComputations().forEach(savedComp -> hintBuilder.addSavedComputations(RelCommon.Hint.SavedComputation.newBuilder().setComputationId(savedComp.computationId()).setType(savedComp.computationType().toProto())));
            builder.setHint(hintBuilder.build());
        }
        return builder.build();
    }
}

