/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation;

import io.substrait.expression.Expression;
import io.substrait.extension.AdvancedExtension;
import io.substrait.hint.Hint;
import io.substrait.relation.AbstractRel;
import io.substrait.relation.BiRel;
import io.substrait.relation.HasExtension;
import io.substrait.relation.Join;
import io.substrait.relation.Rel;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

public final class ImmutableJoin
extends Join {
    private final AdvancedExtension extension;
    private final Rel.Remap remap;
    private final AdvancedExtension commonExtension;
    private final Hint hint;
    private final Rel left;
    private final Rel right;
    private final Expression condition;
    private final Expression postJoinFilter;
    private final Join.JoinType joinType;

    private ImmutableJoin(AdvancedExtension extension, Rel.Remap remap, AdvancedExtension commonExtension, Hint hint, Rel left, Rel right, Expression condition, Expression postJoinFilter, Join.JoinType joinType) {
        this.extension = extension;
        this.remap = remap;
        this.commonExtension = commonExtension;
        this.hint = hint;
        this.left = left;
        this.right = right;
        this.condition = condition;
        this.postJoinFilter = postJoinFilter;
        this.joinType = joinType;
    }

    @Override
    public Optional<AdvancedExtension> getExtension() {
        return Optional.ofNullable(this.extension);
    }

    @Override
    public Optional<Rel.Remap> getRemap() {
        return Optional.ofNullable(this.remap);
    }

    @Override
    public Optional<AdvancedExtension> getCommonExtension() {
        return Optional.ofNullable(this.commonExtension);
    }

    @Override
    public Optional<Hint> getHint() {
        return Optional.ofNullable(this.hint);
    }

    @Override
    public Rel getLeft() {
        return this.left;
    }

    @Override
    public Rel getRight() {
        return this.right;
    }

    @Override
    public Optional<Expression> getCondition() {
        return Optional.ofNullable(this.condition);
    }

    @Override
    public Optional<Expression> getPostJoinFilter() {
        return Optional.ofNullable(this.postJoinFilter);
    }

    @Override
    public Join.JoinType getJoinType() {
        return this.joinType;
    }

    public final ImmutableJoin withExtension(AdvancedExtension value) {
        AdvancedExtension newValue = Objects.requireNonNull(value, "extension");
        if (this.extension == newValue) {
            return this;
        }
        return new ImmutableJoin(newValue, this.remap, this.commonExtension, this.hint, this.left, this.right, this.condition, this.postJoinFilter, this.joinType);
    }

    public final ImmutableJoin withExtension(Optional<? extends AdvancedExtension> optional) {
        AdvancedExtension value = optional.orElse(null);
        if (this.extension == value) {
            return this;
        }
        return new ImmutableJoin(value, this.remap, this.commonExtension, this.hint, this.left, this.right, this.condition, this.postJoinFilter, this.joinType);
    }

    public final ImmutableJoin withRemap(Rel.Remap value) {
        Rel.Remap newValue = Objects.requireNonNull(value, "remap");
        if (this.remap == newValue) {
            return this;
        }
        return new ImmutableJoin(this.extension, newValue, this.commonExtension, this.hint, this.left, this.right, this.condition, this.postJoinFilter, this.joinType);
    }

    public final ImmutableJoin withRemap(Optional<? extends Rel.Remap> optional) {
        Rel.Remap value = optional.orElse(null);
        if (this.remap == value) {
            return this;
        }
        return new ImmutableJoin(this.extension, value, this.commonExtension, this.hint, this.left, this.right, this.condition, this.postJoinFilter, this.joinType);
    }

    public final ImmutableJoin withCommonExtension(AdvancedExtension value) {
        AdvancedExtension newValue = Objects.requireNonNull(value, "commonExtension");
        if (this.commonExtension == newValue) {
            return this;
        }
        return new ImmutableJoin(this.extension, this.remap, newValue, this.hint, this.left, this.right, this.condition, this.postJoinFilter, this.joinType);
    }

    public final ImmutableJoin withCommonExtension(Optional<? extends AdvancedExtension> optional) {
        AdvancedExtension value = optional.orElse(null);
        if (this.commonExtension == value) {
            return this;
        }
        return new ImmutableJoin(this.extension, this.remap, value, this.hint, this.left, this.right, this.condition, this.postJoinFilter, this.joinType);
    }

    public final ImmutableJoin withHint(Hint value) {
        Hint newValue = Objects.requireNonNull(value, "hint");
        if (this.hint == newValue) {
            return this;
        }
        return new ImmutableJoin(this.extension, this.remap, this.commonExtension, newValue, this.left, this.right, this.condition, this.postJoinFilter, this.joinType);
    }

    public final ImmutableJoin withHint(Optional<? extends Hint> optional) {
        Hint value = optional.orElse(null);
        if (this.hint == value) {
            return this;
        }
        return new ImmutableJoin(this.extension, this.remap, this.commonExtension, value, this.left, this.right, this.condition, this.postJoinFilter, this.joinType);
    }

    public final ImmutableJoin withLeft(Rel value) {
        if (this.left == value) {
            return this;
        }
        Rel newValue = Objects.requireNonNull(value, "left");
        return new ImmutableJoin(this.extension, this.remap, this.commonExtension, this.hint, newValue, this.right, this.condition, this.postJoinFilter, this.joinType);
    }

    public final ImmutableJoin withRight(Rel value) {
        if (this.right == value) {
            return this;
        }
        Rel newValue = Objects.requireNonNull(value, "right");
        return new ImmutableJoin(this.extension, this.remap, this.commonExtension, this.hint, this.left, newValue, this.condition, this.postJoinFilter, this.joinType);
    }

    public final ImmutableJoin withCondition(Expression value) {
        Expression newValue = Objects.requireNonNull(value, "condition");
        if (this.condition == newValue) {
            return this;
        }
        return new ImmutableJoin(this.extension, this.remap, this.commonExtension, this.hint, this.left, this.right, newValue, this.postJoinFilter, this.joinType);
    }

    public final ImmutableJoin withCondition(Optional<? extends Expression> optional) {
        Expression value = optional.orElse(null);
        if (this.condition == value) {
            return this;
        }
        return new ImmutableJoin(this.extension, this.remap, this.commonExtension, this.hint, this.left, this.right, value, this.postJoinFilter, this.joinType);
    }

    public final ImmutableJoin withPostJoinFilter(Expression value) {
        Expression newValue = Objects.requireNonNull(value, "postJoinFilter");
        if (this.postJoinFilter == newValue) {
            return this;
        }
        return new ImmutableJoin(this.extension, this.remap, this.commonExtension, this.hint, this.left, this.right, this.condition, newValue, this.joinType);
    }

    public final ImmutableJoin withPostJoinFilter(Optional<? extends Expression> optional) {
        Expression value = optional.orElse(null);
        if (this.postJoinFilter == value) {
            return this;
        }
        return new ImmutableJoin(this.extension, this.remap, this.commonExtension, this.hint, this.left, this.right, this.condition, value, this.joinType);
    }

    public final ImmutableJoin withJoinType(Join.JoinType value) {
        Join.JoinType newValue = Objects.requireNonNull(value, "joinType");
        if (this.joinType == newValue) {
            return this;
        }
        return new ImmutableJoin(this.extension, this.remap, this.commonExtension, this.hint, this.left, this.right, this.condition, this.postJoinFilter, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJoin && this.equalsByValue((ImmutableJoin)another);
    }

    private boolean equalsByValue(ImmutableJoin another) {
        return Objects.equals(this.extension, another.extension) && Objects.equals(this.remap, another.remap) && Objects.equals(this.commonExtension, another.commonExtension) && Objects.equals(this.hint, another.hint) && this.left.equals(another.left) && this.right.equals(another.right) && Objects.equals(this.condition, another.condition) && Objects.equals(this.postJoinFilter, another.postJoinFilter) && this.joinType.equals((Object)another.joinType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.extension);
        h += (h << 5) + Objects.hashCode(this.remap);
        h += (h << 5) + Objects.hashCode(this.commonExtension);
        h += (h << 5) + Objects.hashCode(this.hint);
        h += (h << 5) + this.left.hashCode();
        h += (h << 5) + this.right.hashCode();
        h += (h << 5) + Objects.hashCode(this.condition);
        h += (h << 5) + Objects.hashCode(this.postJoinFilter);
        h += (h << 5) + this.joinType.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Join{");
        if (this.extension != null) {
            builder.append("extension=").append(this.extension);
        }
        if (this.remap != null) {
            if (builder.length() > 5) {
                builder.append(", ");
            }
            builder.append("remap=").append(this.remap);
        }
        if (this.commonExtension != null) {
            if (builder.length() > 5) {
                builder.append(", ");
            }
            builder.append("commonExtension=").append(this.commonExtension);
        }
        if (this.hint != null) {
            if (builder.length() > 5) {
                builder.append(", ");
            }
            builder.append("hint=").append(this.hint);
        }
        if (builder.length() > 5) {
            builder.append(", ");
        }
        builder.append("left=").append(this.left);
        builder.append(", ");
        builder.append("right=").append(this.right);
        if (this.condition != null) {
            builder.append(", ");
            builder.append("condition=").append(this.condition);
        }
        if (this.postJoinFilter != null) {
            builder.append(", ");
            builder.append("postJoinFilter=").append(this.postJoinFilter);
        }
        builder.append(", ");
        builder.append("joinType=").append((Object)this.joinType);
        return builder.append("}").toString();
    }

    public static ImmutableJoin copyOf(Join instance) {
        if (instance instanceof ImmutableJoin) {
            return (ImmutableJoin)instance;
        }
        return ImmutableJoin.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_LEFT = 1L;
        private static final long INIT_BIT_RIGHT = 2L;
        private static final long INIT_BIT_JOIN_TYPE = 4L;
        private long initBits = 7L;
        private AdvancedExtension extension;
        private Rel.Remap remap;
        private AdvancedExtension commonExtension;
        private Hint hint;
        private Rel left;
        private Rel right;
        private Expression condition;
        private Expression postJoinFilter;
        private Join.JoinType joinType;

        private Builder() {
        }

        public final Builder from(HasExtension instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(Rel instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(AbstractRel instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(Join instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(BiRel instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            Optional<Rel.Remap> remapOptional;
            Optional<Hint> hintOptional;
            Optional<AdvancedExtension> commonExtensionOptional;
            Object instance;
            long bits = 0L;
            if (object instanceof HasExtension) {
                instance = (HasExtension)object;
                if ((bits & 1L) == 0L) {
                    Optional<AdvancedExtension> extensionOptional = instance.getExtension();
                    if (extensionOptional.isPresent()) {
                        this.extension(extensionOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof Rel) {
                instance = (Rel)object;
                if ((bits & 4L) == 0L) {
                    commonExtensionOptional = instance.getCommonExtension();
                    if (commonExtensionOptional.isPresent()) {
                        this.commonExtension(commonExtensionOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 0x10L) == 0L) {
                    hintOptional = instance.getHint();
                    if (hintOptional.isPresent()) {
                        this.hint(hintOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    remapOptional = instance.getRemap();
                    if (remapOptional.isPresent()) {
                        this.remap(remapOptional);
                    }
                    bits |= 0x20L;
                }
            }
            if (object instanceof AbstractRel) {
                instance = (AbstractRel)object;
                if ((bits & 4L) == 0L) {
                    commonExtensionOptional = instance.getCommonExtension();
                    if (commonExtensionOptional.isPresent()) {
                        this.commonExtension(commonExtensionOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 0x10L) == 0L) {
                    hintOptional = instance.getHint();
                    if (hintOptional.isPresent()) {
                        this.hint(hintOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    remapOptional = instance.getRemap();
                    if (remapOptional.isPresent()) {
                        this.remap(remapOptional);
                    }
                    bits |= 0x20L;
                }
            }
            if (object instanceof Join) {
                Optional<Expression> conditionOptional;
                instance = (Join)object;
                Optional<Expression> postJoinFilterOptional = ((Join)instance).getPostJoinFilter();
                if (postJoinFilterOptional.isPresent()) {
                    this.postJoinFilter(postJoinFilterOptional);
                }
                if ((bits & 1L) == 0L) {
                    Optional<AdvancedExtension> extensionOptional = instance.getExtension();
                    if (extensionOptional.isPresent()) {
                        this.extension(extensionOptional);
                    }
                    bits |= 1L;
                }
                if ((conditionOptional = ((Join)instance).getCondition()).isPresent()) {
                    this.condition(conditionOptional);
                }
                if ((bits & 8L) == 0L) {
                    this.left(((BiRel)instance).getLeft());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    Optional<Hint> hintOptional2 = instance.getHint();
                    if (hintOptional2.isPresent()) {
                        this.hint(hintOptional2);
                    }
                    bits |= 0x10L;
                }
                this.joinType(((Join)instance).getJoinType());
                if ((bits & 2L) == 0L) {
                    this.right(((BiRel)instance).getRight());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    Optional<AdvancedExtension> commonExtensionOptional2 = instance.getCommonExtension();
                    if (commonExtensionOptional2.isPresent()) {
                        this.commonExtension(commonExtensionOptional2);
                    }
                    bits |= 4L;
                }
                if ((bits & 0x20L) == 0L) {
                    Optional<Rel.Remap> remapOptional2 = instance.getRemap();
                    if (remapOptional2.isPresent()) {
                        this.remap(remapOptional2);
                    }
                    bits |= 0x20L;
                }
            }
            if (object instanceof BiRel) {
                instance = (BiRel)object;
                if ((bits & 2L) == 0L) {
                    this.right(((BiRel)instance).getRight());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    commonExtensionOptional = instance.getCommonExtension();
                    if (commonExtensionOptional.isPresent()) {
                        this.commonExtension(commonExtensionOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.left(((BiRel)instance).getLeft());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    hintOptional = instance.getHint();
                    if (hintOptional.isPresent()) {
                        this.hint(hintOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    remapOptional = instance.getRemap();
                    if (remapOptional.isPresent()) {
                        this.remap(remapOptional);
                    }
                    bits |= 0x20L;
                }
            }
        }

        public final Builder extension(AdvancedExtension extension) {
            this.extension = Objects.requireNonNull(extension, "extension");
            return this;
        }

        public final Builder extension(Optional<? extends AdvancedExtension> extension) {
            this.extension = extension.orElse(null);
            return this;
        }

        public final Builder remap(Rel.Remap remap) {
            this.remap = Objects.requireNonNull(remap, "remap");
            return this;
        }

        public final Builder remap(Optional<? extends Rel.Remap> remap) {
            this.remap = remap.orElse(null);
            return this;
        }

        public final Builder commonExtension(AdvancedExtension commonExtension) {
            this.commonExtension = Objects.requireNonNull(commonExtension, "commonExtension");
            return this;
        }

        public final Builder commonExtension(Optional<? extends AdvancedExtension> commonExtension) {
            this.commonExtension = commonExtension.orElse(null);
            return this;
        }

        public final Builder hint(Hint hint) {
            this.hint = Objects.requireNonNull(hint, "hint");
            return this;
        }

        public final Builder hint(Optional<? extends Hint> hint) {
            this.hint = hint.orElse(null);
            return this;
        }

        public final Builder left(Rel left) {
            this.left = Objects.requireNonNull(left, "left");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder right(Rel right) {
            this.right = Objects.requireNonNull(right, "right");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder condition(Expression condition) {
            this.condition = Objects.requireNonNull(condition, "condition");
            return this;
        }

        public final Builder condition(Optional<? extends Expression> condition) {
            this.condition = condition.orElse(null);
            return this;
        }

        public final Builder postJoinFilter(Expression postJoinFilter) {
            this.postJoinFilter = Objects.requireNonNull(postJoinFilter, "postJoinFilter");
            return this;
        }

        public final Builder postJoinFilter(Optional<? extends Expression> postJoinFilter) {
            this.postJoinFilter = postJoinFilter.orElse(null);
            return this;
        }

        public final Builder joinType(Join.JoinType joinType) {
            this.joinType = Objects.requireNonNull(joinType, "joinType");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableJoin build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableJoin(this.extension, this.remap, this.commonExtension, this.hint, this.left, this.right, this.condition, this.postJoinFilter, this.joinType);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("left");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("right");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("joinType");
            }
            return "Cannot build Join, some of required attributes are not set " + attributes;
        }
    }
}

