/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation;

import io.substrait.expression.Expression;
import io.substrait.expression.ExpressionVisitor;
import io.substrait.expression.FieldReference;
import io.substrait.expression.FunctionArg;
import io.substrait.relation.CopyOnWriteUtils;
import io.substrait.relation.Rel;
import io.substrait.relation.RelCopyOnWriteVisitor;
import io.substrait.util.EmptyVisitationContext;
import java.util.List;
import java.util.Optional;

public class ExpressionCopyOnWriteVisitor<E extends Exception>
implements ExpressionVisitor<Optional<Expression>, EmptyVisitationContext, E> {
    private final RelCopyOnWriteVisitor<E> relCopyOnWriteVisitor;

    public ExpressionCopyOnWriteVisitor(RelCopyOnWriteVisitor<E> relCopyOnWriteVisitor) {
        this.relCopyOnWriteVisitor = relCopyOnWriteVisitor;
    }

    protected final RelCopyOnWriteVisitor<E> getRelCopyOnWriteVisitor() {
        return this.relCopyOnWriteVisitor;
    }

    public Optional<Expression> visitLiteral(Expression.Literal literal) {
        return Optional.empty();
    }

    @Override
    public Optional<Expression> visit(Expression.NullLiteral expr, EmptyVisitationContext context) throws E {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.BoolLiteral expr, EmptyVisitationContext context) throws E {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.I8Literal expr, EmptyVisitationContext context) throws E {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.I16Literal expr, EmptyVisitationContext context) throws E {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.I32Literal expr, EmptyVisitationContext context) throws E {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.I64Literal expr, EmptyVisitationContext context) throws E {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.FP32Literal expr, EmptyVisitationContext context) throws E {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.FP64Literal expr, EmptyVisitationContext context) throws E {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.StrLiteral expr, EmptyVisitationContext context) throws E {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.BinaryLiteral expr, EmptyVisitationContext context) throws E {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.TimeLiteral expr, EmptyVisitationContext context) throws E {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.DateLiteral expr, EmptyVisitationContext context) throws E {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.TimestampLiteral expr, EmptyVisitationContext context) throws E {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.TimestampTZLiteral expr, EmptyVisitationContext context) throws E {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.PrecisionTimestampLiteral expr, EmptyVisitationContext context) throws E {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.PrecisionTimestampTZLiteral expr, EmptyVisitationContext context) throws E {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.IntervalYearLiteral expr, EmptyVisitationContext context) throws E {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.IntervalDayLiteral expr, EmptyVisitationContext context) throws E {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.IntervalCompoundLiteral expr, EmptyVisitationContext context) throws E {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.UUIDLiteral expr, EmptyVisitationContext context) throws E {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.FixedCharLiteral expr, EmptyVisitationContext context) throws E {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.VarCharLiteral expr, EmptyVisitationContext context) throws E {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.FixedBinaryLiteral expr, EmptyVisitationContext context) throws E {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.DecimalLiteral expr, EmptyVisitationContext context) throws E {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.MapLiteral expr, EmptyVisitationContext context) throws E {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.EmptyMapLiteral expr, EmptyVisitationContext context) throws E {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.ListLiteral expr, EmptyVisitationContext context) throws E {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.EmptyListLiteral expr, EmptyVisitationContext context) throws E {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.StructLiteral expr, EmptyVisitationContext context) throws E {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.NestedStruct expr, EmptyVisitationContext context) throws E {
        Optional<List<Expression>> expressions = this.visitExprList(expr.fields(), context);
        return expressions.map(expressionList -> Expression.NestedStruct.builder().from(expr).fields((Iterable<? extends Expression>)expressionList).build());
    }

    @Override
    public Optional<Expression> visit(Expression.UserDefinedLiteral expr, EmptyVisitationContext context) throws E {
        return this.visitLiteral(expr);
    }

    @Override
    public Optional<Expression> visit(Expression.Switch expr, EmptyVisitationContext context) throws E {
        Optional match = (Optional)expr.match().accept(this, context);
        Optional<List<Expression.SwitchClause>> switchClauses = CopyOnWriteUtils.transformList(expr.switchClauses(), context, this::visitSwitchClause);
        Optional defaultClause = (Optional)expr.defaultClause().accept(this, context);
        if (CopyOnWriteUtils.allEmpty(match, switchClauses, defaultClause)) {
            return Optional.empty();
        }
        return Optional.of(Expression.Switch.builder().from(expr).match(match.orElse(expr.match())).switchClauses((Iterable<? extends Expression.SwitchClause>)switchClauses.orElse(expr.switchClauses())).defaultClause(defaultClause.orElse(expr.defaultClause())).build());
    }

    protected Optional<Expression.SwitchClause> visitSwitchClause(Expression.SwitchClause switchClause, EmptyVisitationContext context) throws E {
        return ((Optional)switchClause.then().accept(this, context)).map(then -> Expression.SwitchClause.builder().from(switchClause).then((Expression)then).build());
    }

    @Override
    public Optional<Expression> visit(Expression.IfThen ifThen, EmptyVisitationContext context) throws E {
        Optional<List<Expression.IfClause>> ifClauses = CopyOnWriteUtils.transformList(ifThen.ifClauses(), context, this::visitIfClause);
        Optional elseClause = (Optional)ifThen.elseClause().accept(this, context);
        if (CopyOnWriteUtils.allEmpty(ifClauses, elseClause)) {
            return Optional.empty();
        }
        return Optional.of(Expression.IfThen.builder().from(ifThen).ifClauses((Iterable<? extends Expression.IfClause>)ifClauses.orElse(ifThen.ifClauses())).elseClause(elseClause.orElse(ifThen.elseClause())).build());
    }

    protected Optional<Expression.IfClause> visitIfClause(Expression.IfClause ifClause, EmptyVisitationContext context) throws E {
        Optional condition = (Optional)ifClause.condition().accept(this, context);
        Optional then = (Optional)ifClause.then().accept(this, context);
        if (CopyOnWriteUtils.allEmpty(condition, then)) {
            return Optional.empty();
        }
        return Optional.of(Expression.IfClause.builder().from(ifClause).condition(condition.orElse(ifClause.condition())).then(then.orElse(ifClause.then())).build());
    }

    @Override
    public Optional<Expression> visit(Expression.ScalarFunctionInvocation sfi, EmptyVisitationContext context) throws E {
        return this.visitFunctionArguments(sfi.arguments(), context).map(arguments -> Expression.ScalarFunctionInvocation.builder().from(sfi).arguments((Iterable<? extends FunctionArg>)arguments).build());
    }

    @Override
    public Optional<Expression> visit(Expression.WindowFunctionInvocation wfi, EmptyVisitationContext context) throws E {
        Optional<List<FunctionArg>> arguments = this.visitFunctionArguments(wfi.arguments(), context);
        Optional<List<Expression>> partitionBy = this.visitExprList(wfi.partitionBy(), context);
        Optional<List<Expression.SortField>> sort = CopyOnWriteUtils.transformList(wfi.sort(), context, this::visitSortField);
        if (CopyOnWriteUtils.allEmpty(arguments, partitionBy, sort)) {
            return Optional.empty();
        }
        return Optional.of(Expression.WindowFunctionInvocation.builder().from(wfi).arguments((Iterable<? extends FunctionArg>)arguments.orElse(wfi.arguments())).partitionBy((Iterable<? extends Expression>)partitionBy.orElse(wfi.partitionBy())).sort((Iterable<? extends Expression.SortField>)sort.orElse(wfi.sort())).build());
    }

    @Override
    public Optional<Expression> visit(Expression.Cast cast, EmptyVisitationContext context) throws E {
        return ((Optional)cast.input().accept(this, context)).map(input -> Expression.Cast.builder().from(cast).input((Expression)input).build());
    }

    @Override
    public Optional<Expression> visit(Expression.SingleOrList singleOrList, EmptyVisitationContext context) throws E {
        Optional condition = (Optional)singleOrList.condition().accept(this, context);
        Optional<List<Expression>> options = this.visitExprList(singleOrList.options(), context);
        if (CopyOnWriteUtils.allEmpty(condition, options)) {
            return Optional.empty();
        }
        return Optional.of(Expression.SingleOrList.builder().from(singleOrList).condition(condition.orElse(singleOrList.condition())).options((Iterable<? extends Expression>)options.orElse(singleOrList.options())).build());
    }

    @Override
    public Optional<Expression> visit(Expression.MultiOrList multiOrList, EmptyVisitationContext context) throws E {
        Optional<List<Expression>> conditions = this.visitExprList(multiOrList.conditions(), context);
        Optional<List<Expression.MultiOrListRecord>> optionCombinations = CopyOnWriteUtils.transformList(multiOrList.optionCombinations(), context, this::visitMultiOrListRecord);
        if (CopyOnWriteUtils.allEmpty(conditions, optionCombinations)) {
            return Optional.empty();
        }
        return Optional.of(Expression.MultiOrList.builder().from(multiOrList).conditions((Iterable<? extends Expression>)conditions.orElse(multiOrList.conditions())).optionCombinations((Iterable<? extends Expression.MultiOrListRecord>)optionCombinations.orElse(multiOrList.optionCombinations())).build());
    }

    protected Optional<Expression.MultiOrListRecord> visitMultiOrListRecord(Expression.MultiOrListRecord multiOrListRecord, EmptyVisitationContext context) throws E {
        return this.visitExprList(multiOrListRecord.values(), context).map(values -> Expression.MultiOrListRecord.builder().from(multiOrListRecord).values((Iterable<? extends Expression>)values).build());
    }

    @Override
    public Optional<Expression> visit(FieldReference fieldReference, EmptyVisitationContext context) throws E {
        Optional<Expression> inputExpression = this.visitOptionalExpression(fieldReference.inputExpression(), context);
        if (CopyOnWriteUtils.allEmpty(inputExpression)) {
            return Optional.empty();
        }
        return Optional.of(FieldReference.builder().inputExpression(inputExpression).build());
    }

    @Override
    public Optional<Expression> visit(Expression.SetPredicate setPredicate, EmptyVisitationContext context) throws E {
        return ((Optional)setPredicate.tuples().accept(this.getRelCopyOnWriteVisitor(), context)).map(tuple -> Expression.SetPredicate.builder().from(setPredicate).tuples((Rel)tuple).build());
    }

    @Override
    public Optional<Expression> visit(Expression.ScalarSubquery scalarSubquery, EmptyVisitationContext context) throws E {
        return ((Optional)scalarSubquery.input().accept(this.getRelCopyOnWriteVisitor(), context)).map(input -> Expression.ScalarSubquery.builder().from(scalarSubquery).input((Rel)input).build());
    }

    @Override
    public Optional<Expression> visit(Expression.InPredicate inPredicate, EmptyVisitationContext context) throws E {
        Optional haystack = (Optional)inPredicate.haystack().accept(this.getRelCopyOnWriteVisitor(), context);
        Optional<List<Expression>> needles = this.visitExprList(inPredicate.needles(), context);
        if (CopyOnWriteUtils.allEmpty(haystack, needles)) {
            return Optional.empty();
        }
        return Optional.of(Expression.InPredicate.builder().from(inPredicate).haystack(haystack.orElse(inPredicate.haystack())).needles((Iterable<? extends Expression>)needles.orElse(inPredicate.needles())).build());
    }

    protected Optional<List<Expression>> visitExprList(List<Expression> exprs, EmptyVisitationContext context) throws E {
        return CopyOnWriteUtils.transformList(exprs, context, (e, c) -> (Optional)e.accept(this, c));
    }

    private Optional<Expression> visitOptionalExpression(Optional<Expression> optExpr, EmptyVisitationContext context) throws E {
        if (optExpr.isPresent()) {
            return (Optional)optExpr.get().accept(this, context);
        }
        return Optional.empty();
    }

    protected Optional<List<FunctionArg>> visitFunctionArguments(List<FunctionArg> funcArgs, EmptyVisitationContext context) throws E {
        return CopyOnWriteUtils.transformList(funcArgs, context, (arg, c) -> {
            if (arg instanceof Expression) {
                return ((Optional)((Expression)arg).accept(this, c)).flatMap(Optional::of);
            }
            return Optional.empty();
        });
    }

    protected Optional<Expression.SortField> visitSortField(Expression.SortField sortField, EmptyVisitationContext context) throws E {
        return ((Optional)sortField.expr().accept(this, context)).map(expr -> Expression.SortField.builder().from(sortField).expr((Expression)expr).build());
    }
}

