/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.hint;

import io.substrait.hint.ImmutableHint;
import io.substrait.hint.ImmutableLoadedComputation;
import io.substrait.hint.ImmutableRuntimeConstraint;
import io.substrait.hint.ImmutableSavedComputation;
import io.substrait.hint.ImmutableStats;
import io.substrait.proto.RelCommon;
import io.substrait.relation.HasExtension;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public abstract class Hint
implements HasExtension {
    public abstract Optional<String> getAlias();

    public abstract List<String> getOutputNames();

    public abstract Optional<Stats> getStats();

    public abstract Optional<RuntimeConstraint> getRuntimeConstraint();

    public abstract List<LoadedComputation> getLoadedComputations();

    public abstract List<SavedComputation> getSavedComputations();

    public static ImmutableHint.Builder builder() {
        return ImmutableHint.builder();
    }

    @Value.Immutable
    public static abstract class RuntimeConstraint
    implements HasExtension {
        public static ImmutableRuntimeConstraint.Builder builder() {
            return ImmutableRuntimeConstraint.builder();
        }
    }

    @Value.Immutable
    public static abstract class LoadedComputation {
        public abstract int computationId();

        public abstract ComputationType computationType();

        public static ImmutableLoadedComputation.Builder builder() {
            return ImmutableLoadedComputation.builder();
        }
    }

    @Value.Immutable
    public static abstract class SavedComputation {
        public abstract int computationId();

        public abstract ComputationType computationType();

        public static ImmutableSavedComputation.Builder builder() {
            return ImmutableSavedComputation.builder();
        }
    }

    @Value.Immutable
    public static abstract class Stats
    implements HasExtension {
        public abstract double rowCount();

        public abstract double recordSize();

        public static ImmutableStats.Builder builder() {
            return ImmutableStats.builder();
        }
    }

    public static enum ComputationType {
        COMPUTATION_TYPE_UNSPECIFIED(RelCommon.Hint.ComputationType.COMPUTATION_TYPE_UNSPECIFIED),
        COMPUTATION_TYPE_HASHTABLE(RelCommon.Hint.ComputationType.COMPUTATION_TYPE_HASHTABLE),
        COMPUTATION_TYPE_BLOOM_FILTER(RelCommon.Hint.ComputationType.COMPUTATION_TYPE_BLOOM_FILTER),
        COMPUTATION_TYPE_UNKNOWN(RelCommon.Hint.ComputationType.COMPUTATION_TYPE_UNKNOWN);

        private final RelCommon.Hint.ComputationType proto;

        private ComputationType(RelCommon.Hint.ComputationType compType) {
            this.proto = compType;
        }

        public RelCommon.Hint.ComputationType toProto() {
            return this.proto;
        }

        public static ComputationType fromProto(RelCommon.Hint.ComputationType proto) {
            for (ComputationType compTypePojo : ComputationType.values()) {
                if (compTypePojo.proto != proto) continue;
                return compTypePojo;
            }
            throw new IllegalArgumentException("Unknown computation type: " + (Object)((Object)proto));
        }
    }
}

