/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation.files;

import com.google.protobuf.Any;
import io.substrait.relation.files.FileFormat;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

public final class ImmutableFileFormat {
    private ImmutableFileFormat() {
    }

    public static final class Extension
    extends FileFormat.Extension {
        private final Any extension;

        private Extension(Any extension) {
            this.extension = extension;
        }

        @Override
        public Any getExtension() {
            return this.extension;
        }

        public final Extension withExtension(Any value) {
            if (this.extension == value) {
                return this;
            }
            Any newValue = Objects.requireNonNull(value, "extension");
            return new Extension(newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Extension && this.equalsByValue((Extension)another);
        }

        private boolean equalsByValue(Extension another) {
            return this.extension.equals((Object)another.extension);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.extension.hashCode();
            return h;
        }

        public String toString() {
            return "Extension{extension=" + this.extension + "}";
        }

        public static Extension copyOf(FileFormat.Extension instance) {
            if (instance instanceof Extension) {
                return (Extension)instance;
            }
            return Extension.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_EXTENSION = 1L;
            private long initBits = 1L;
            private Any extension;

            private Builder() {
            }

            public final Builder from(FileFormat.Extension instance) {
                Objects.requireNonNull(instance, "instance");
                this.extension(instance.getExtension());
                return this;
            }

            public final Builder extension(Any extension) {
                this.extension = Objects.requireNonNull(extension, "extension");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public Extension build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Extension(this.extension);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("extension");
                }
                return "Cannot build Extension, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class DelimiterSeparatedTextReadOptions
    extends FileFormat.DelimiterSeparatedTextReadOptions {
        private final String fieldDelimiter;
        private final long maxLineSize;
        private final String quote;
        private final long headerLinesToSkip;
        private final String escape;
        private final String valueTreatedAsNull;

        private DelimiterSeparatedTextReadOptions(String fieldDelimiter, long maxLineSize, String quote, long headerLinesToSkip, String escape, String valueTreatedAsNull) {
            this.fieldDelimiter = fieldDelimiter;
            this.maxLineSize = maxLineSize;
            this.quote = quote;
            this.headerLinesToSkip = headerLinesToSkip;
            this.escape = escape;
            this.valueTreatedAsNull = valueTreatedAsNull;
        }

        @Override
        public String getFieldDelimiter() {
            return this.fieldDelimiter;
        }

        @Override
        public long getMaxLineSize() {
            return this.maxLineSize;
        }

        @Override
        public String getQuote() {
            return this.quote;
        }

        @Override
        public long getHeaderLinesToSkip() {
            return this.headerLinesToSkip;
        }

        @Override
        public String getEscape() {
            return this.escape;
        }

        @Override
        public Optional<String> getValueTreatedAsNull() {
            return Optional.ofNullable(this.valueTreatedAsNull);
        }

        public final DelimiterSeparatedTextReadOptions withFieldDelimiter(String value) {
            String newValue = Objects.requireNonNull(value, "fieldDelimiter");
            if (this.fieldDelimiter.equals(newValue)) {
                return this;
            }
            return new DelimiterSeparatedTextReadOptions(newValue, this.maxLineSize, this.quote, this.headerLinesToSkip, this.escape, this.valueTreatedAsNull);
        }

        public final DelimiterSeparatedTextReadOptions withMaxLineSize(long value) {
            if (this.maxLineSize == value) {
                return this;
            }
            return new DelimiterSeparatedTextReadOptions(this.fieldDelimiter, value, this.quote, this.headerLinesToSkip, this.escape, this.valueTreatedAsNull);
        }

        public final DelimiterSeparatedTextReadOptions withQuote(String value) {
            String newValue = Objects.requireNonNull(value, "quote");
            if (this.quote.equals(newValue)) {
                return this;
            }
            return new DelimiterSeparatedTextReadOptions(this.fieldDelimiter, this.maxLineSize, newValue, this.headerLinesToSkip, this.escape, this.valueTreatedAsNull);
        }

        public final DelimiterSeparatedTextReadOptions withHeaderLinesToSkip(long value) {
            if (this.headerLinesToSkip == value) {
                return this;
            }
            return new DelimiterSeparatedTextReadOptions(this.fieldDelimiter, this.maxLineSize, this.quote, value, this.escape, this.valueTreatedAsNull);
        }

        public final DelimiterSeparatedTextReadOptions withEscape(String value) {
            String newValue = Objects.requireNonNull(value, "escape");
            if (this.escape.equals(newValue)) {
                return this;
            }
            return new DelimiterSeparatedTextReadOptions(this.fieldDelimiter, this.maxLineSize, this.quote, this.headerLinesToSkip, newValue, this.valueTreatedAsNull);
        }

        public final DelimiterSeparatedTextReadOptions withValueTreatedAsNull(String value) {
            String newValue = Objects.requireNonNull(value, "valueTreatedAsNull");
            if (Objects.equals(this.valueTreatedAsNull, newValue)) {
                return this;
            }
            return new DelimiterSeparatedTextReadOptions(this.fieldDelimiter, this.maxLineSize, this.quote, this.headerLinesToSkip, this.escape, newValue);
        }

        public final DelimiterSeparatedTextReadOptions withValueTreatedAsNull(Optional<String> optional) {
            String value = optional.orElse(null);
            if (Objects.equals(this.valueTreatedAsNull, value)) {
                return this;
            }
            return new DelimiterSeparatedTextReadOptions(this.fieldDelimiter, this.maxLineSize, this.quote, this.headerLinesToSkip, this.escape, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof DelimiterSeparatedTextReadOptions && this.equalsByValue((DelimiterSeparatedTextReadOptions)another);
        }

        private boolean equalsByValue(DelimiterSeparatedTextReadOptions another) {
            return this.fieldDelimiter.equals(another.fieldDelimiter) && this.maxLineSize == another.maxLineSize && this.quote.equals(another.quote) && this.headerLinesToSkip == another.headerLinesToSkip && this.escape.equals(another.escape) && Objects.equals(this.valueTreatedAsNull, another.valueTreatedAsNull);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.fieldDelimiter.hashCode();
            h += (h << 5) + Long.hashCode(this.maxLineSize);
            h += (h << 5) + this.quote.hashCode();
            h += (h << 5) + Long.hashCode(this.headerLinesToSkip);
            h += (h << 5) + this.escape.hashCode();
            h += (h << 5) + Objects.hashCode(this.valueTreatedAsNull);
            return h;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("DelimiterSeparatedTextReadOptions{");
            builder.append("fieldDelimiter=").append(this.fieldDelimiter);
            builder.append(", ");
            builder.append("maxLineSize=").append(this.maxLineSize);
            builder.append(", ");
            builder.append("quote=").append(this.quote);
            builder.append(", ");
            builder.append("headerLinesToSkip=").append(this.headerLinesToSkip);
            builder.append(", ");
            builder.append("escape=").append(this.escape);
            if (this.valueTreatedAsNull != null) {
                builder.append(", ");
                builder.append("valueTreatedAsNull=").append(this.valueTreatedAsNull);
            }
            return builder.append("}").toString();
        }

        public static DelimiterSeparatedTextReadOptions copyOf(FileFormat.DelimiterSeparatedTextReadOptions instance) {
            if (instance instanceof DelimiterSeparatedTextReadOptions) {
                return (DelimiterSeparatedTextReadOptions)instance;
            }
            return DelimiterSeparatedTextReadOptions.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_FIELD_DELIMITER = 1L;
            private static final long INIT_BIT_MAX_LINE_SIZE = 2L;
            private static final long INIT_BIT_QUOTE = 4L;
            private static final long INIT_BIT_HEADER_LINES_TO_SKIP = 8L;
            private static final long INIT_BIT_ESCAPE = 16L;
            private long initBits = 31L;
            private String fieldDelimiter;
            private long maxLineSize;
            private String quote;
            private long headerLinesToSkip;
            private String escape;
            private String valueTreatedAsNull;

            private Builder() {
            }

            public final Builder from(FileFormat.DelimiterSeparatedTextReadOptions instance) {
                Objects.requireNonNull(instance, "instance");
                this.fieldDelimiter(instance.getFieldDelimiter());
                this.maxLineSize(instance.getMaxLineSize());
                this.quote(instance.getQuote());
                this.headerLinesToSkip(instance.getHeaderLinesToSkip());
                this.escape(instance.getEscape());
                Optional<String> valueTreatedAsNullOptional = instance.getValueTreatedAsNull();
                if (valueTreatedAsNullOptional.isPresent()) {
                    this.valueTreatedAsNull(valueTreatedAsNullOptional);
                }
                return this;
            }

            public final Builder fieldDelimiter(String fieldDelimiter) {
                this.fieldDelimiter = Objects.requireNonNull(fieldDelimiter, "fieldDelimiter");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder maxLineSize(long maxLineSize) {
                this.maxLineSize = maxLineSize;
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public final Builder quote(String quote) {
                this.quote = Objects.requireNonNull(quote, "quote");
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            public final Builder headerLinesToSkip(long headerLinesToSkip) {
                this.headerLinesToSkip = headerLinesToSkip;
                this.initBits &= 0xFFFFFFFFFFFFFFF7L;
                return this;
            }

            public final Builder escape(String escape) {
                this.escape = Objects.requireNonNull(escape, "escape");
                this.initBits &= 0xFFFFFFFFFFFFFFEFL;
                return this;
            }

            public final Builder valueTreatedAsNull(String valueTreatedAsNull) {
                this.valueTreatedAsNull = Objects.requireNonNull(valueTreatedAsNull, "valueTreatedAsNull");
                return this;
            }

            public final Builder valueTreatedAsNull(Optional<String> valueTreatedAsNull) {
                this.valueTreatedAsNull = valueTreatedAsNull.orElse(null);
                return this;
            }

            public DelimiterSeparatedTextReadOptions build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new DelimiterSeparatedTextReadOptions(this.fieldDelimiter, this.maxLineSize, this.quote, this.headerLinesToSkip, this.escape, this.valueTreatedAsNull);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("fieldDelimiter");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("maxLineSize");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("quote");
                }
                if ((this.initBits & 8L) != 0L) {
                    attributes.add("headerLinesToSkip");
                }
                if ((this.initBits & 0x10L) != 0L) {
                    attributes.add("escape");
                }
                return "Cannot build DelimiterSeparatedTextReadOptions, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class DwrfReadOptions
    extends FileFormat.DwrfReadOptions {
        private DwrfReadOptions(Builder builder) {
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof DwrfReadOptions && this.equalsByValue((DwrfReadOptions)another);
        }

        private boolean equalsByValue(DwrfReadOptions another) {
            return true;
        }

        public int hashCode() {
            return -633787213;
        }

        public String toString() {
            return "DwrfReadOptions{}";
        }

        public static DwrfReadOptions copyOf(FileFormat.DwrfReadOptions instance) {
            if (instance instanceof DwrfReadOptions) {
                return (DwrfReadOptions)instance;
            }
            return DwrfReadOptions.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Builder() {
            }

            public final Builder from(FileFormat.DwrfReadOptions instance) {
                Objects.requireNonNull(instance, "instance");
                return this;
            }

            public DwrfReadOptions build() {
                return new DwrfReadOptions(this);
            }
        }
    }

    public static final class OrcReadOptions
    extends FileFormat.OrcReadOptions {
        private OrcReadOptions(Builder builder) {
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof OrcReadOptions && this.equalsByValue((OrcReadOptions)another);
        }

        private boolean equalsByValue(OrcReadOptions another) {
            return true;
        }

        public int hashCode() {
            return 2613748;
        }

        public String toString() {
            return "OrcReadOptions{}";
        }

        public static OrcReadOptions copyOf(FileFormat.OrcReadOptions instance) {
            if (instance instanceof OrcReadOptions) {
                return (OrcReadOptions)instance;
            }
            return OrcReadOptions.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Builder() {
            }

            public final Builder from(FileFormat.OrcReadOptions instance) {
                Objects.requireNonNull(instance, "instance");
                return this;
            }

            public OrcReadOptions build() {
                return new OrcReadOptions(this);
            }
        }
    }

    public static final class ArrowReadOptions
    extends FileFormat.ArrowReadOptions {
        private ArrowReadOptions(Builder builder) {
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ArrowReadOptions && this.equalsByValue((ArrowReadOptions)another);
        }

        private boolean equalsByValue(ArrowReadOptions another) {
            return true;
        }

        public int hashCode() {
            return 992281067;
        }

        public String toString() {
            return "ArrowReadOptions{}";
        }

        public static ArrowReadOptions copyOf(FileFormat.ArrowReadOptions instance) {
            if (instance instanceof ArrowReadOptions) {
                return (ArrowReadOptions)instance;
            }
            return ArrowReadOptions.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Builder() {
            }

            public final Builder from(FileFormat.ArrowReadOptions instance) {
                Objects.requireNonNull(instance, "instance");
                return this;
            }

            public ArrowReadOptions build() {
                return new ArrowReadOptions(this);
            }
        }
    }

    public static final class ParquetReadOptions
    extends FileFormat.ParquetReadOptions {
        private ParquetReadOptions(Builder builder) {
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ParquetReadOptions && this.equalsByValue((ParquetReadOptions)another);
        }

        private boolean equalsByValue(ParquetReadOptions another) {
            return true;
        }

        public int hashCode() {
            return 1986126816;
        }

        public String toString() {
            return "ParquetReadOptions{}";
        }

        public static ParquetReadOptions copyOf(FileFormat.ParquetReadOptions instance) {
            if (instance instanceof ParquetReadOptions) {
                return (ParquetReadOptions)instance;
            }
            return ParquetReadOptions.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Builder() {
            }

            public final Builder from(FileFormat.ParquetReadOptions instance) {
                Objects.requireNonNull(instance, "instance");
                return this;
            }

            public ParquetReadOptions build() {
                return new ParquetReadOptions(this);
            }
        }
    }
}

