/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation;

import io.substrait.extension.AdvancedExtension;
import io.substrait.hint.Hint;
import io.substrait.relation.AbstractRel;
import io.substrait.relation.AbstractWriteRel;
import io.substrait.relation.HasExtension;
import io.substrait.relation.NamedWrite;
import io.substrait.relation.Rel;
import io.substrait.relation.SingleInputRel;
import io.substrait.type.NamedStruct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ImmutableNamedWrite
extends NamedWrite {
    private final AdvancedExtension extension;
    private final Rel.Remap remap;
    private final AdvancedExtension commonExtension;
    private final Hint hint;
    private final Rel input;
    private final NamedStruct tableSchema;
    private final AbstractWriteRel.WriteOp operation;
    private final AbstractWriteRel.CreateMode createMode;
    private final AbstractWriteRel.OutputMode outputMode;
    private final List<String> names;

    private ImmutableNamedWrite(AdvancedExtension extension, Rel.Remap remap, AdvancedExtension commonExtension, Hint hint, Rel input, NamedStruct tableSchema, AbstractWriteRel.WriteOp operation, AbstractWriteRel.CreateMode createMode, AbstractWriteRel.OutputMode outputMode, List<String> names) {
        this.extension = extension;
        this.remap = remap;
        this.commonExtension = commonExtension;
        this.hint = hint;
        this.input = input;
        this.tableSchema = tableSchema;
        this.operation = operation;
        this.createMode = createMode;
        this.outputMode = outputMode;
        this.names = names;
    }

    @Override
    public Optional<AdvancedExtension> getExtension() {
        return Optional.ofNullable(this.extension);
    }

    @Override
    public Optional<Rel.Remap> getRemap() {
        return Optional.ofNullable(this.remap);
    }

    @Override
    public Optional<AdvancedExtension> getCommonExtension() {
        return Optional.ofNullable(this.commonExtension);
    }

    @Override
    public Optional<Hint> getHint() {
        return Optional.ofNullable(this.hint);
    }

    @Override
    public Rel getInput() {
        return this.input;
    }

    @Override
    public NamedStruct getTableSchema() {
        return this.tableSchema;
    }

    @Override
    public AbstractWriteRel.WriteOp getOperation() {
        return this.operation;
    }

    @Override
    public AbstractWriteRel.CreateMode getCreateMode() {
        return this.createMode;
    }

    @Override
    public AbstractWriteRel.OutputMode getOutputMode() {
        return this.outputMode;
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    public final ImmutableNamedWrite withExtension(AdvancedExtension value) {
        AdvancedExtension newValue = Objects.requireNonNull(value, "extension");
        if (this.extension == newValue) {
            return this;
        }
        return new ImmutableNamedWrite(newValue, this.remap, this.commonExtension, this.hint, this.input, this.tableSchema, this.operation, this.createMode, this.outputMode, this.names);
    }

    public final ImmutableNamedWrite withExtension(Optional<? extends AdvancedExtension> optional) {
        AdvancedExtension value = optional.orElse(null);
        if (this.extension == value) {
            return this;
        }
        return new ImmutableNamedWrite(value, this.remap, this.commonExtension, this.hint, this.input, this.tableSchema, this.operation, this.createMode, this.outputMode, this.names);
    }

    public final ImmutableNamedWrite withRemap(Rel.Remap value) {
        Rel.Remap newValue = Objects.requireNonNull(value, "remap");
        if (this.remap == newValue) {
            return this;
        }
        return new ImmutableNamedWrite(this.extension, newValue, this.commonExtension, this.hint, this.input, this.tableSchema, this.operation, this.createMode, this.outputMode, this.names);
    }

    public final ImmutableNamedWrite withRemap(Optional<? extends Rel.Remap> optional) {
        Rel.Remap value = optional.orElse(null);
        if (this.remap == value) {
            return this;
        }
        return new ImmutableNamedWrite(this.extension, value, this.commonExtension, this.hint, this.input, this.tableSchema, this.operation, this.createMode, this.outputMode, this.names);
    }

    public final ImmutableNamedWrite withCommonExtension(AdvancedExtension value) {
        AdvancedExtension newValue = Objects.requireNonNull(value, "commonExtension");
        if (this.commonExtension == newValue) {
            return this;
        }
        return new ImmutableNamedWrite(this.extension, this.remap, newValue, this.hint, this.input, this.tableSchema, this.operation, this.createMode, this.outputMode, this.names);
    }

    public final ImmutableNamedWrite withCommonExtension(Optional<? extends AdvancedExtension> optional) {
        AdvancedExtension value = optional.orElse(null);
        if (this.commonExtension == value) {
            return this;
        }
        return new ImmutableNamedWrite(this.extension, this.remap, value, this.hint, this.input, this.tableSchema, this.operation, this.createMode, this.outputMode, this.names);
    }

    public final ImmutableNamedWrite withHint(Hint value) {
        Hint newValue = Objects.requireNonNull(value, "hint");
        if (this.hint == newValue) {
            return this;
        }
        return new ImmutableNamedWrite(this.extension, this.remap, this.commonExtension, newValue, this.input, this.tableSchema, this.operation, this.createMode, this.outputMode, this.names);
    }

    public final ImmutableNamedWrite withHint(Optional<? extends Hint> optional) {
        Hint value = optional.orElse(null);
        if (this.hint == value) {
            return this;
        }
        return new ImmutableNamedWrite(this.extension, this.remap, this.commonExtension, value, this.input, this.tableSchema, this.operation, this.createMode, this.outputMode, this.names);
    }

    public final ImmutableNamedWrite withInput(Rel value) {
        if (this.input == value) {
            return this;
        }
        Rel newValue = Objects.requireNonNull(value, "input");
        return new ImmutableNamedWrite(this.extension, this.remap, this.commonExtension, this.hint, newValue, this.tableSchema, this.operation, this.createMode, this.outputMode, this.names);
    }

    public final ImmutableNamedWrite withTableSchema(NamedStruct value) {
        if (this.tableSchema == value) {
            return this;
        }
        NamedStruct newValue = Objects.requireNonNull(value, "tableSchema");
        return new ImmutableNamedWrite(this.extension, this.remap, this.commonExtension, this.hint, this.input, newValue, this.operation, this.createMode, this.outputMode, this.names);
    }

    public final ImmutableNamedWrite withOperation(AbstractWriteRel.WriteOp value) {
        AbstractWriteRel.WriteOp newValue = Objects.requireNonNull(value, "operation");
        if (this.operation == newValue) {
            return this;
        }
        return new ImmutableNamedWrite(this.extension, this.remap, this.commonExtension, this.hint, this.input, this.tableSchema, newValue, this.createMode, this.outputMode, this.names);
    }

    public final ImmutableNamedWrite withCreateMode(AbstractWriteRel.CreateMode value) {
        AbstractWriteRel.CreateMode newValue = Objects.requireNonNull(value, "createMode");
        if (this.createMode == newValue) {
            return this;
        }
        return new ImmutableNamedWrite(this.extension, this.remap, this.commonExtension, this.hint, this.input, this.tableSchema, this.operation, newValue, this.outputMode, this.names);
    }

    public final ImmutableNamedWrite withOutputMode(AbstractWriteRel.OutputMode value) {
        AbstractWriteRel.OutputMode newValue = Objects.requireNonNull(value, "outputMode");
        if (this.outputMode == newValue) {
            return this;
        }
        return new ImmutableNamedWrite(this.extension, this.remap, this.commonExtension, this.hint, this.input, this.tableSchema, this.operation, this.createMode, newValue, this.names);
    }

    public final ImmutableNamedWrite withNames(String ... elements) {
        List<String> newValue = ImmutableNamedWrite.createUnmodifiableList(false, ImmutableNamedWrite.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableNamedWrite(this.extension, this.remap, this.commonExtension, this.hint, this.input, this.tableSchema, this.operation, this.createMode, this.outputMode, newValue);
    }

    public final ImmutableNamedWrite withNames(Iterable<String> elements) {
        if (this.names == elements) {
            return this;
        }
        List<String> newValue = ImmutableNamedWrite.createUnmodifiableList(false, ImmutableNamedWrite.createSafeList(elements, true, false));
        return new ImmutableNamedWrite(this.extension, this.remap, this.commonExtension, this.hint, this.input, this.tableSchema, this.operation, this.createMode, this.outputMode, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNamedWrite && this.equalsByValue((ImmutableNamedWrite)another);
    }

    private boolean equalsByValue(ImmutableNamedWrite another) {
        return Objects.equals(this.extension, another.extension) && Objects.equals(this.remap, another.remap) && Objects.equals(this.commonExtension, another.commonExtension) && Objects.equals(this.hint, another.hint) && this.input.equals(another.input) && this.tableSchema.equals(another.tableSchema) && this.operation.equals((Object)another.operation) && this.createMode.equals((Object)another.createMode) && this.outputMode.equals((Object)another.outputMode) && this.names.equals(another.names);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.extension);
        h += (h << 5) + Objects.hashCode(this.remap);
        h += (h << 5) + Objects.hashCode(this.commonExtension);
        h += (h << 5) + Objects.hashCode(this.hint);
        h += (h << 5) + this.input.hashCode();
        h += (h << 5) + this.tableSchema.hashCode();
        h += (h << 5) + this.operation.hashCode();
        h += (h << 5) + this.createMode.hashCode();
        h += (h << 5) + this.outputMode.hashCode();
        h += (h << 5) + this.names.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("NamedWrite{");
        if (this.extension != null) {
            builder.append("extension=").append(this.extension);
        }
        if (this.remap != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("remap=").append(this.remap);
        }
        if (this.commonExtension != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("commonExtension=").append(this.commonExtension);
        }
        if (this.hint != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("hint=").append(this.hint);
        }
        if (builder.length() > 11) {
            builder.append(", ");
        }
        builder.append("input=").append(this.input);
        builder.append(", ");
        builder.append("tableSchema=").append(this.tableSchema);
        builder.append(", ");
        builder.append("operation=").append((Object)this.operation);
        builder.append(", ");
        builder.append("createMode=").append((Object)this.createMode);
        builder.append(", ");
        builder.append("outputMode=").append((Object)this.outputMode);
        builder.append(", ");
        builder.append("names=").append(this.names);
        return builder.append("}").toString();
    }

    public static ImmutableNamedWrite copyOf(NamedWrite instance) {
        if (instance instanceof ImmutableNamedWrite) {
            return (ImmutableNamedWrite)instance;
        }
        return ImmutableNamedWrite.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_INPUT = 1L;
        private static final long INIT_BIT_TABLE_SCHEMA = 2L;
        private static final long INIT_BIT_OPERATION = 4L;
        private static final long INIT_BIT_CREATE_MODE = 8L;
        private static final long INIT_BIT_OUTPUT_MODE = 16L;
        private long initBits = 31L;
        private AdvancedExtension extension;
        private Rel.Remap remap;
        private AdvancedExtension commonExtension;
        private Hint hint;
        private Rel input;
        private NamedStruct tableSchema;
        private AbstractWriteRel.WriteOp operation;
        private AbstractWriteRel.CreateMode createMode;
        private AbstractWriteRel.OutputMode outputMode;
        private List<String> names = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(HasExtension instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(NamedWrite instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(Rel instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(AbstractRel instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(AbstractWriteRel instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(SingleInputRel instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            Optional<Rel.Remap> remapOptional;
            Optional<AdvancedExtension> commonExtensionOptional;
            Optional<Hint> hintOptional;
            Optional<AdvancedExtension> extensionOptional;
            Object instance;
            long bits = 0L;
            if (object instanceof HasExtension) {
                instance = (HasExtension)object;
                if ((bits & 1L) == 0L) {
                    extensionOptional = instance.getExtension();
                    if (extensionOptional.isPresent()) {
                        this.extension(extensionOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof NamedWrite) {
                instance = (NamedWrite)object;
                if ((bits & 0x20L) == 0L) {
                    this.input(((SingleInputRel)instance).getInput());
                    bits |= 0x20L;
                }
                if ((bits & 1L) == 0L) {
                    extensionOptional = instance.getExtension();
                    if (extensionOptional.isPresent()) {
                        this.extension(extensionOptional);
                    }
                    bits |= 1L;
                }
                this.addAllNames(((NamedWrite)instance).getNames());
                if ((bits & 2L) == 0L) {
                    this.createMode(((AbstractWriteRel)instance).getCreateMode());
                    bits |= 2L;
                }
                if ((bits & 0x40L) == 0L) {
                    hintOptional = instance.getHint();
                    if (hintOptional.isPresent()) {
                        this.hint(hintOptional);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 4L) == 0L) {
                    this.outputMode(((AbstractWriteRel)instance).getOutputMode());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    commonExtensionOptional = instance.getCommonExtension();
                    if (commonExtensionOptional.isPresent()) {
                        this.commonExtension(commonExtensionOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.operation(((AbstractWriteRel)instance).getOperation());
                    bits |= 0x80L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.tableSchema(((AbstractWriteRel)instance).getTableSchema());
                    bits |= 0x10L;
                }
                if ((bits & 0x100L) == 0L) {
                    remapOptional = instance.getRemap();
                    if (remapOptional.isPresent()) {
                        this.remap(remapOptional);
                    }
                    bits |= 0x100L;
                }
            }
            if (object instanceof Rel) {
                instance = (Rel)object;
                if ((bits & 8L) == 0L) {
                    commonExtensionOptional = instance.getCommonExtension();
                    if (commonExtensionOptional.isPresent()) {
                        this.commonExtension(commonExtensionOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x40L) == 0L) {
                    hintOptional = instance.getHint();
                    if (hintOptional.isPresent()) {
                        this.hint(hintOptional);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x100L) == 0L) {
                    remapOptional = instance.getRemap();
                    if (remapOptional.isPresent()) {
                        this.remap(remapOptional);
                    }
                    bits |= 0x100L;
                }
            }
            if (object instanceof AbstractRel) {
                instance = (AbstractRel)object;
                if ((bits & 8L) == 0L) {
                    commonExtensionOptional = instance.getCommonExtension();
                    if (commonExtensionOptional.isPresent()) {
                        this.commonExtension(commonExtensionOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x40L) == 0L) {
                    hintOptional = instance.getHint();
                    if (hintOptional.isPresent()) {
                        this.hint(hintOptional);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x100L) == 0L) {
                    remapOptional = instance.getRemap();
                    if (remapOptional.isPresent()) {
                        this.remap(remapOptional);
                    }
                    bits |= 0x100L;
                }
            }
            if (object instanceof AbstractWriteRel) {
                instance = (AbstractWriteRel)object;
                if ((bits & 0x20L) == 0L) {
                    this.input(((SingleInputRel)instance).getInput());
                    bits |= 0x20L;
                }
                if ((bits & 1L) == 0L) {
                    extensionOptional = instance.getExtension();
                    if (extensionOptional.isPresent()) {
                        this.extension(extensionOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.createMode(((AbstractWriteRel)instance).getCreateMode());
                    bits |= 2L;
                }
                if ((bits & 0x40L) == 0L) {
                    hintOptional = instance.getHint();
                    if (hintOptional.isPresent()) {
                        this.hint(hintOptional);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 4L) == 0L) {
                    this.outputMode(((AbstractWriteRel)instance).getOutputMode());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    commonExtensionOptional = instance.getCommonExtension();
                    if (commonExtensionOptional.isPresent()) {
                        this.commonExtension(commonExtensionOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.operation(((AbstractWriteRel)instance).getOperation());
                    bits |= 0x80L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.tableSchema(((AbstractWriteRel)instance).getTableSchema());
                    bits |= 0x10L;
                }
                if ((bits & 0x100L) == 0L) {
                    remapOptional = instance.getRemap();
                    if (remapOptional.isPresent()) {
                        this.remap(remapOptional);
                    }
                    bits |= 0x100L;
                }
            }
            if (object instanceof SingleInputRel) {
                instance = (SingleInputRel)object;
                if ((bits & 0x20L) == 0L) {
                    this.input(((SingleInputRel)instance).getInput());
                    bits |= 0x20L;
                }
                if ((bits & 8L) == 0L) {
                    commonExtensionOptional = instance.getCommonExtension();
                    if (commonExtensionOptional.isPresent()) {
                        this.commonExtension(commonExtensionOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x40L) == 0L) {
                    hintOptional = instance.getHint();
                    if (hintOptional.isPresent()) {
                        this.hint(hintOptional);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x100L) == 0L) {
                    remapOptional = instance.getRemap();
                    if (remapOptional.isPresent()) {
                        this.remap(remapOptional);
                    }
                    bits |= 0x100L;
                }
            }
        }

        public final Builder extension(AdvancedExtension extension) {
            this.extension = Objects.requireNonNull(extension, "extension");
            return this;
        }

        public final Builder extension(Optional<? extends AdvancedExtension> extension) {
            this.extension = extension.orElse(null);
            return this;
        }

        public final Builder remap(Rel.Remap remap) {
            this.remap = Objects.requireNonNull(remap, "remap");
            return this;
        }

        public final Builder remap(Optional<? extends Rel.Remap> remap) {
            this.remap = remap.orElse(null);
            return this;
        }

        public final Builder commonExtension(AdvancedExtension commonExtension) {
            this.commonExtension = Objects.requireNonNull(commonExtension, "commonExtension");
            return this;
        }

        public final Builder commonExtension(Optional<? extends AdvancedExtension> commonExtension) {
            this.commonExtension = commonExtension.orElse(null);
            return this;
        }

        public final Builder hint(Hint hint) {
            this.hint = Objects.requireNonNull(hint, "hint");
            return this;
        }

        public final Builder hint(Optional<? extends Hint> hint) {
            this.hint = hint.orElse(null);
            return this;
        }

        public final Builder input(Rel input) {
            this.input = Objects.requireNonNull(input, "input");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder tableSchema(NamedStruct tableSchema) {
            this.tableSchema = Objects.requireNonNull(tableSchema, "tableSchema");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder operation(AbstractWriteRel.WriteOp operation) {
            this.operation = Objects.requireNonNull(operation, "operation");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder createMode(AbstractWriteRel.CreateMode createMode) {
            this.createMode = Objects.requireNonNull(createMode, "createMode");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder outputMode(AbstractWriteRel.OutputMode outputMode) {
            this.outputMode = Objects.requireNonNull(outputMode, "outputMode");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder addNames(String element) {
            this.names.add(Objects.requireNonNull(element, "names element"));
            return this;
        }

        public final Builder addNames(String ... elements) {
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder names(Iterable<String> elements) {
            this.names.clear();
            return this.addAllNames(elements);
        }

        public final Builder addAllNames(Iterable<String> elements) {
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public ImmutableNamedWrite build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNamedWrite(this.extension, this.remap, this.commonExtension, this.hint, this.input, this.tableSchema, this.operation, this.createMode, this.outputMode, ImmutableNamedWrite.createUnmodifiableList(true, this.names));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("input");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("tableSchema");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("operation");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("createMode");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("outputMode");
            }
            return "Cannot build NamedWrite, some of required attributes are not set " + attributes;
        }
    }
}

