/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation;

import io.substrait.expression.AggregateFunctionInvocation;
import io.substrait.expression.Expression;
import io.substrait.relation.Aggregate;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

public final class ImmutableMeasure
extends Aggregate.Measure {
    private final AggregateFunctionInvocation function;
    private final Expression preMeasureFilter;

    private ImmutableMeasure(AggregateFunctionInvocation function, Expression preMeasureFilter) {
        this.function = function;
        this.preMeasureFilter = preMeasureFilter;
    }

    @Override
    public AggregateFunctionInvocation getFunction() {
        return this.function;
    }

    @Override
    public Optional<Expression> getPreMeasureFilter() {
        return Optional.ofNullable(this.preMeasureFilter);
    }

    public final ImmutableMeasure withFunction(AggregateFunctionInvocation value) {
        if (this.function == value) {
            return this;
        }
        AggregateFunctionInvocation newValue = Objects.requireNonNull(value, "function");
        return new ImmutableMeasure(newValue, this.preMeasureFilter);
    }

    public final ImmutableMeasure withPreMeasureFilter(Expression value) {
        Expression newValue = Objects.requireNonNull(value, "preMeasureFilter");
        if (this.preMeasureFilter == newValue) {
            return this;
        }
        return new ImmutableMeasure(this.function, newValue);
    }

    public final ImmutableMeasure withPreMeasureFilter(Optional<? extends Expression> optional) {
        Expression value = optional.orElse(null);
        if (this.preMeasureFilter == value) {
            return this;
        }
        return new ImmutableMeasure(this.function, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMeasure && this.equalsByValue((ImmutableMeasure)another);
    }

    private boolean equalsByValue(ImmutableMeasure another) {
        return this.function.equals(another.function) && Objects.equals(this.preMeasureFilter, another.preMeasureFilter);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.function.hashCode();
        h += (h << 5) + Objects.hashCode(this.preMeasureFilter);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Measure{");
        builder.append("function=").append(this.function);
        if (this.preMeasureFilter != null) {
            builder.append(", ");
            builder.append("preMeasureFilter=").append(this.preMeasureFilter);
        }
        return builder.append("}").toString();
    }

    public static ImmutableMeasure copyOf(Aggregate.Measure instance) {
        if (instance instanceof ImmutableMeasure) {
            return (ImmutableMeasure)instance;
        }
        return ImmutableMeasure.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_FUNCTION = 1L;
        private long initBits = 1L;
        private AggregateFunctionInvocation function;
        private Expression preMeasureFilter;

        private Builder() {
        }

        public final Builder from(Aggregate.Measure instance) {
            Objects.requireNonNull(instance, "instance");
            this.function(instance.getFunction());
            Optional<Expression> preMeasureFilterOptional = instance.getPreMeasureFilter();
            if (preMeasureFilterOptional.isPresent()) {
                this.preMeasureFilter(preMeasureFilterOptional);
            }
            return this;
        }

        public final Builder function(AggregateFunctionInvocation function) {
            this.function = Objects.requireNonNull(function, "function");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder preMeasureFilter(Expression preMeasureFilter) {
            this.preMeasureFilter = Objects.requireNonNull(preMeasureFilter, "preMeasureFilter");
            return this;
        }

        public final Builder preMeasureFilter(Optional<? extends Expression> preMeasureFilter) {
            this.preMeasureFilter = preMeasureFilter.orElse(null);
            return this;
        }

        public ImmutableMeasure build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMeasure(this.function, this.preMeasureFilter);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("function");
            }
            return "Cannot build Measure, some of required attributes are not set " + attributes;
        }
    }
}

