/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.expression;

import io.substrait.expression.AggregateFunctionInvocation;
import io.substrait.expression.Expression;
import io.substrait.expression.FunctionArg;
import io.substrait.expression.FunctionOption;
import io.substrait.extension.SimpleExtension;
import io.substrait.type.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class ImmutableAggregateFunctionInvocation
extends AggregateFunctionInvocation {
    private final SimpleExtension.AggregateFunctionVariant declaration;
    private final List<FunctionArg> arguments;
    private final List<FunctionOption> options;
    private final Expression.AggregationPhase aggregationPhase;
    private final List<Expression.SortField> sort;
    private final Type outputType;
    private final Expression.AggregationInvocation invocation;

    private ImmutableAggregateFunctionInvocation(SimpleExtension.AggregateFunctionVariant declaration, List<FunctionArg> arguments, List<FunctionOption> options, Expression.AggregationPhase aggregationPhase, List<Expression.SortField> sort, Type outputType, Expression.AggregationInvocation invocation) {
        this.declaration = declaration;
        this.arguments = arguments;
        this.options = options;
        this.aggregationPhase = aggregationPhase;
        this.sort = sort;
        this.outputType = outputType;
        this.invocation = invocation;
    }

    @Override
    public SimpleExtension.AggregateFunctionVariant declaration() {
        return this.declaration;
    }

    @Override
    public List<FunctionArg> arguments() {
        return this.arguments;
    }

    @Override
    public List<FunctionOption> options() {
        return this.options;
    }

    @Override
    public Expression.AggregationPhase aggregationPhase() {
        return this.aggregationPhase;
    }

    @Override
    public List<Expression.SortField> sort() {
        return this.sort;
    }

    @Override
    public Type outputType() {
        return this.outputType;
    }

    @Override
    public Expression.AggregationInvocation invocation() {
        return this.invocation;
    }

    public final ImmutableAggregateFunctionInvocation withDeclaration(SimpleExtension.AggregateFunctionVariant value) {
        if (this.declaration == value) {
            return this;
        }
        SimpleExtension.AggregateFunctionVariant newValue = Objects.requireNonNull(value, "declaration");
        return new ImmutableAggregateFunctionInvocation(newValue, this.arguments, this.options, this.aggregationPhase, this.sort, this.outputType, this.invocation);
    }

    public final ImmutableAggregateFunctionInvocation withArguments(FunctionArg ... elements) {
        List<FunctionArg> newValue = ImmutableAggregateFunctionInvocation.createUnmodifiableList(false, ImmutableAggregateFunctionInvocation.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableAggregateFunctionInvocation(this.declaration, newValue, this.options, this.aggregationPhase, this.sort, this.outputType, this.invocation);
    }

    public final ImmutableAggregateFunctionInvocation withArguments(Iterable<? extends FunctionArg> elements) {
        if (this.arguments == elements) {
            return this;
        }
        List<FunctionArg> newValue = ImmutableAggregateFunctionInvocation.createUnmodifiableList(false, ImmutableAggregateFunctionInvocation.createSafeList(elements, true, false));
        return new ImmutableAggregateFunctionInvocation(this.declaration, newValue, this.options, this.aggregationPhase, this.sort, this.outputType, this.invocation);
    }

    public final ImmutableAggregateFunctionInvocation withOptions(FunctionOption ... elements) {
        List<FunctionOption> newValue = ImmutableAggregateFunctionInvocation.createUnmodifiableList(false, ImmutableAggregateFunctionInvocation.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableAggregateFunctionInvocation(this.declaration, this.arguments, newValue, this.aggregationPhase, this.sort, this.outputType, this.invocation);
    }

    public final ImmutableAggregateFunctionInvocation withOptions(Iterable<? extends FunctionOption> elements) {
        if (this.options == elements) {
            return this;
        }
        List<FunctionOption> newValue = ImmutableAggregateFunctionInvocation.createUnmodifiableList(false, ImmutableAggregateFunctionInvocation.createSafeList(elements, true, false));
        return new ImmutableAggregateFunctionInvocation(this.declaration, this.arguments, newValue, this.aggregationPhase, this.sort, this.outputType, this.invocation);
    }

    public final ImmutableAggregateFunctionInvocation withAggregationPhase(Expression.AggregationPhase value) {
        Expression.AggregationPhase newValue = Objects.requireNonNull(value, "aggregationPhase");
        if (this.aggregationPhase == newValue) {
            return this;
        }
        return new ImmutableAggregateFunctionInvocation(this.declaration, this.arguments, this.options, newValue, this.sort, this.outputType, this.invocation);
    }

    public final ImmutableAggregateFunctionInvocation withSort(Expression.SortField ... elements) {
        List<Expression.SortField> newValue = ImmutableAggregateFunctionInvocation.createUnmodifiableList(false, ImmutableAggregateFunctionInvocation.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableAggregateFunctionInvocation(this.declaration, this.arguments, this.options, this.aggregationPhase, newValue, this.outputType, this.invocation);
    }

    public final ImmutableAggregateFunctionInvocation withSort(Iterable<? extends Expression.SortField> elements) {
        if (this.sort == elements) {
            return this;
        }
        List<Expression.SortField> newValue = ImmutableAggregateFunctionInvocation.createUnmodifiableList(false, ImmutableAggregateFunctionInvocation.createSafeList(elements, true, false));
        return new ImmutableAggregateFunctionInvocation(this.declaration, this.arguments, this.options, this.aggregationPhase, newValue, this.outputType, this.invocation);
    }

    public final ImmutableAggregateFunctionInvocation withOutputType(Type value) {
        if (this.outputType == value) {
            return this;
        }
        Type newValue = Objects.requireNonNull(value, "outputType");
        return new ImmutableAggregateFunctionInvocation(this.declaration, this.arguments, this.options, this.aggregationPhase, this.sort, newValue, this.invocation);
    }

    public final ImmutableAggregateFunctionInvocation withInvocation(Expression.AggregationInvocation value) {
        Expression.AggregationInvocation newValue = Objects.requireNonNull(value, "invocation");
        if (this.invocation == newValue) {
            return this;
        }
        return new ImmutableAggregateFunctionInvocation(this.declaration, this.arguments, this.options, this.aggregationPhase, this.sort, this.outputType, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAggregateFunctionInvocation && this.equalsByValue((ImmutableAggregateFunctionInvocation)another);
    }

    private boolean equalsByValue(ImmutableAggregateFunctionInvocation another) {
        return this.declaration.equals(another.declaration) && this.arguments.equals(another.arguments) && this.options.equals(another.options) && this.aggregationPhase.equals((Object)another.aggregationPhase) && this.sort.equals(another.sort) && this.outputType.equals(another.outputType) && this.invocation.equals((Object)another.invocation);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.declaration.hashCode();
        h += (h << 5) + this.arguments.hashCode();
        h += (h << 5) + this.options.hashCode();
        h += (h << 5) + this.aggregationPhase.hashCode();
        h += (h << 5) + this.sort.hashCode();
        h += (h << 5) + this.outputType.hashCode();
        h += (h << 5) + this.invocation.hashCode();
        return h;
    }

    public String toString() {
        return "AggregateFunctionInvocation{declaration=" + this.declaration + ", arguments=" + this.arguments + ", options=" + this.options + ", aggregationPhase=" + (Object)((Object)this.aggregationPhase) + ", sort=" + this.sort + ", outputType=" + this.outputType + ", invocation=" + (Object)((Object)this.invocation) + "}";
    }

    public static ImmutableAggregateFunctionInvocation copyOf(AggregateFunctionInvocation instance) {
        if (instance instanceof ImmutableAggregateFunctionInvocation) {
            return (ImmutableAggregateFunctionInvocation)instance;
        }
        return ImmutableAggregateFunctionInvocation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_DECLARATION = 1L;
        private static final long INIT_BIT_AGGREGATION_PHASE = 2L;
        private static final long INIT_BIT_OUTPUT_TYPE = 4L;
        private static final long INIT_BIT_INVOCATION = 8L;
        private long initBits = 15L;
        private SimpleExtension.AggregateFunctionVariant declaration;
        private List<FunctionArg> arguments = new ArrayList<FunctionArg>();
        private List<FunctionOption> options = new ArrayList<FunctionOption>();
        private Expression.AggregationPhase aggregationPhase;
        private List<Expression.SortField> sort = new ArrayList<Expression.SortField>();
        private Type outputType;
        private Expression.AggregationInvocation invocation;

        private Builder() {
        }

        public final Builder from(AggregateFunctionInvocation instance) {
            Objects.requireNonNull(instance, "instance");
            this.declaration(instance.declaration());
            this.addAllArguments(instance.arguments());
            this.addAllOptions(instance.options());
            this.aggregationPhase(instance.aggregationPhase());
            this.addAllSort(instance.sort());
            this.outputType(instance.outputType());
            this.invocation(instance.invocation());
            return this;
        }

        public final Builder declaration(SimpleExtension.AggregateFunctionVariant declaration) {
            this.declaration = Objects.requireNonNull(declaration, "declaration");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addArguments(FunctionArg element) {
            this.arguments.add(Objects.requireNonNull(element, "arguments element"));
            return this;
        }

        public final Builder addArguments(FunctionArg ... elements) {
            for (FunctionArg element : elements) {
                this.arguments.add(Objects.requireNonNull(element, "arguments element"));
            }
            return this;
        }

        public final Builder arguments(Iterable<? extends FunctionArg> elements) {
            this.arguments.clear();
            return this.addAllArguments(elements);
        }

        public final Builder addAllArguments(Iterable<? extends FunctionArg> elements) {
            for (FunctionArg functionArg : elements) {
                this.arguments.add(Objects.requireNonNull(functionArg, "arguments element"));
            }
            return this;
        }

        public final Builder addOptions(FunctionOption element) {
            this.options.add(Objects.requireNonNull(element, "options element"));
            return this;
        }

        public final Builder addOptions(FunctionOption ... elements) {
            for (FunctionOption element : elements) {
                this.options.add(Objects.requireNonNull(element, "options element"));
            }
            return this;
        }

        public final Builder options(Iterable<? extends FunctionOption> elements) {
            this.options.clear();
            return this.addAllOptions(elements);
        }

        public final Builder addAllOptions(Iterable<? extends FunctionOption> elements) {
            for (FunctionOption functionOption : elements) {
                this.options.add(Objects.requireNonNull(functionOption, "options element"));
            }
            return this;
        }

        public final Builder aggregationPhase(Expression.AggregationPhase aggregationPhase) {
            this.aggregationPhase = Objects.requireNonNull(aggregationPhase, "aggregationPhase");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addSort(Expression.SortField element) {
            this.sort.add(Objects.requireNonNull(element, "sort element"));
            return this;
        }

        public final Builder addSort(Expression.SortField ... elements) {
            for (Expression.SortField element : elements) {
                this.sort.add(Objects.requireNonNull(element, "sort element"));
            }
            return this;
        }

        public final Builder sort(Iterable<? extends Expression.SortField> elements) {
            this.sort.clear();
            return this.addAllSort(elements);
        }

        public final Builder addAllSort(Iterable<? extends Expression.SortField> elements) {
            for (Expression.SortField sortField : elements) {
                this.sort.add(Objects.requireNonNull(sortField, "sort element"));
            }
            return this;
        }

        public final Builder outputType(Type outputType) {
            this.outputType = Objects.requireNonNull(outputType, "outputType");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder invocation(Expression.AggregationInvocation invocation) {
            this.invocation = Objects.requireNonNull(invocation, "invocation");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableAggregateFunctionInvocation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAggregateFunctionInvocation(this.declaration, ImmutableAggregateFunctionInvocation.createUnmodifiableList(true, this.arguments), ImmutableAggregateFunctionInvocation.createUnmodifiableList(true, this.options), this.aggregationPhase, ImmutableAggregateFunctionInvocation.createUnmodifiableList(true, this.sort), this.outputType, this.invocation);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("declaration");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("aggregationPhase");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("outputType");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("invocation");
            }
            return "Cannot build AggregateFunctionInvocation, some of required attributes are not set " + attributes;
        }
    }
}

