/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation;

import io.substrait.relation.Rel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class ImmutableRemap
extends Rel.Remap {
    private final List<Integer> indices;

    private ImmutableRemap(List<Integer> indices) {
        this.indices = indices;
    }

    @Override
    public List<Integer> indices() {
        return this.indices;
    }

    public final ImmutableRemap withIndices(int ... elements) {
        ArrayList<Integer> wrappedList = new ArrayList<Integer>(elements.length);
        for (int element : elements) {
            wrappedList.add(element);
        }
        List<Integer> newValue = ImmutableRemap.createUnmodifiableList(false, wrappedList);
        return new ImmutableRemap(newValue);
    }

    public final ImmutableRemap withIndices(Iterable<Integer> elements) {
        if (this.indices == elements) {
            return this;
        }
        List<Integer> newValue = ImmutableRemap.createUnmodifiableList(false, ImmutableRemap.createSafeList(elements, true, false));
        return new ImmutableRemap(newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRemap && this.equalsByValue((ImmutableRemap)another);
    }

    private boolean equalsByValue(ImmutableRemap another) {
        return this.indices.equals(another.indices);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.indices.hashCode();
        return h;
    }

    public String toString() {
        return "Remap{indices=" + this.indices + "}";
    }

    public static ImmutableRemap copyOf(Rel.Remap instance) {
        if (instance instanceof ImmutableRemap) {
            return (ImmutableRemap)instance;
        }
        return ImmutableRemap.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private List<Integer> indices = new ArrayList<Integer>();

        private Builder() {
        }

        public final Builder from(Rel.Remap instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllIndices(instance.indices());
            return this;
        }

        public final Builder addIndices(int element) {
            this.indices.add(element);
            return this;
        }

        public final Builder addIndices(int ... elements) {
            for (int element : elements) {
                this.indices.add(element);
            }
            return this;
        }

        public final Builder indices(Iterable<Integer> elements) {
            this.indices.clear();
            return this.addAllIndices(elements);
        }

        public final Builder addAllIndices(Iterable<Integer> elements) {
            for (Integer element : elements) {
                this.indices.add(Objects.requireNonNull(element, "indices element"));
            }
            return this;
        }

        public ImmutableRemap build() {
            return new ImmutableRemap(ImmutableRemap.createUnmodifiableList(true, this.indices));
        }
    }
}

