/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation;

import io.substrait.expression.Expression;
import io.substrait.extension.AdvancedExtension;
import io.substrait.hint.Hint;
import io.substrait.relation.AbstractRel;
import io.substrait.relation.Expand;
import io.substrait.relation.Rel;
import io.substrait.relation.SingleInputRel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ImmutableExpand
extends Expand {
    private final Rel.Remap remap;
    private final AdvancedExtension commonExtension;
    private final Hint hint;
    private final Rel input;
    private final List<Expand.ExpandField> fields;

    private ImmutableExpand(Rel.Remap remap, AdvancedExtension commonExtension, Hint hint, Rel input, List<Expand.ExpandField> fields) {
        this.remap = remap;
        this.commonExtension = commonExtension;
        this.hint = hint;
        this.input = input;
        this.fields = fields;
    }

    @Override
    public Optional<Rel.Remap> getRemap() {
        return Optional.ofNullable(this.remap);
    }

    @Override
    public Optional<AdvancedExtension> getCommonExtension() {
        return Optional.ofNullable(this.commonExtension);
    }

    @Override
    public Optional<Hint> getHint() {
        return Optional.ofNullable(this.hint);
    }

    @Override
    public Rel getInput() {
        return this.input;
    }

    @Override
    public List<Expand.ExpandField> getFields() {
        return this.fields;
    }

    public final ImmutableExpand withRemap(Rel.Remap value) {
        Rel.Remap newValue = Objects.requireNonNull(value, "remap");
        if (this.remap == newValue) {
            return this;
        }
        return new ImmutableExpand(newValue, this.commonExtension, this.hint, this.input, this.fields);
    }

    public final ImmutableExpand withRemap(Optional<? extends Rel.Remap> optional) {
        Rel.Remap value = optional.orElse(null);
        if (this.remap == value) {
            return this;
        }
        return new ImmutableExpand(value, this.commonExtension, this.hint, this.input, this.fields);
    }

    public final ImmutableExpand withCommonExtension(AdvancedExtension value) {
        AdvancedExtension newValue = Objects.requireNonNull(value, "commonExtension");
        if (this.commonExtension == newValue) {
            return this;
        }
        return new ImmutableExpand(this.remap, newValue, this.hint, this.input, this.fields);
    }

    public final ImmutableExpand withCommonExtension(Optional<? extends AdvancedExtension> optional) {
        AdvancedExtension value = optional.orElse(null);
        if (this.commonExtension == value) {
            return this;
        }
        return new ImmutableExpand(this.remap, value, this.hint, this.input, this.fields);
    }

    public final ImmutableExpand withHint(Hint value) {
        Hint newValue = Objects.requireNonNull(value, "hint");
        if (this.hint == newValue) {
            return this;
        }
        return new ImmutableExpand(this.remap, this.commonExtension, newValue, this.input, this.fields);
    }

    public final ImmutableExpand withHint(Optional<? extends Hint> optional) {
        Hint value = optional.orElse(null);
        if (this.hint == value) {
            return this;
        }
        return new ImmutableExpand(this.remap, this.commonExtension, value, this.input, this.fields);
    }

    public final ImmutableExpand withInput(Rel value) {
        if (this.input == value) {
            return this;
        }
        Rel newValue = Objects.requireNonNull(value, "input");
        return new ImmutableExpand(this.remap, this.commonExtension, this.hint, newValue, this.fields);
    }

    public final ImmutableExpand withFields(Expand.ExpandField ... elements) {
        List<Expand.ExpandField> newValue = ImmutableExpand.createUnmodifiableList(false, ImmutableExpand.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableExpand(this.remap, this.commonExtension, this.hint, this.input, newValue);
    }

    public final ImmutableExpand withFields(Iterable<? extends Expand.ExpandField> elements) {
        if (this.fields == elements) {
            return this;
        }
        List<Expand.ExpandField> newValue = ImmutableExpand.createUnmodifiableList(false, ImmutableExpand.createSafeList(elements, true, false));
        return new ImmutableExpand(this.remap, this.commonExtension, this.hint, this.input, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExpand && this.equalsByValue((ImmutableExpand)another);
    }

    private boolean equalsByValue(ImmutableExpand another) {
        return Objects.equals(this.remap, another.remap) && Objects.equals(this.commonExtension, another.commonExtension) && Objects.equals(this.hint, another.hint) && this.input.equals(another.input) && this.fields.equals(another.fields);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.remap);
        h += (h << 5) + Objects.hashCode(this.commonExtension);
        h += (h << 5) + Objects.hashCode(this.hint);
        h += (h << 5) + this.input.hashCode();
        h += (h << 5) + this.fields.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Expand{");
        if (this.remap != null) {
            builder.append("remap=").append(this.remap);
        }
        if (this.commonExtension != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("commonExtension=").append(this.commonExtension);
        }
        if (this.hint != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("hint=").append(this.hint);
        }
        if (builder.length() > 7) {
            builder.append(", ");
        }
        builder.append("input=").append(this.input);
        builder.append(", ");
        builder.append("fields=").append(this.fields);
        return builder.append("}").toString();
    }

    public static ImmutableExpand copyOf(Expand instance) {
        if (instance instanceof ImmutableExpand) {
            return (ImmutableExpand)instance;
        }
        return ImmutableExpand.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_INPUT = 1L;
        private long initBits = 1L;
        private Rel.Remap remap;
        private AdvancedExtension commonExtension;
        private Hint hint;
        private Rel input;
        private List<Expand.ExpandField> fields = new ArrayList<Expand.ExpandField>();

        private Builder() {
        }

        public final Builder from(Rel instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(Expand instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(AbstractRel instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(SingleInputRel instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            Optional<Rel.Remap> remapOptional;
            Optional<Hint> hintOptional;
            Optional<AdvancedExtension> commonExtensionOptional;
            Rel instance;
            long bits = 0L;
            if (object instanceof Rel) {
                instance = (Rel)object;
                if ((bits & 1L) == 0L) {
                    commonExtensionOptional = instance.getCommonExtension();
                    if (commonExtensionOptional.isPresent()) {
                        this.commonExtension(commonExtensionOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    hintOptional = instance.getHint();
                    if (hintOptional.isPresent()) {
                        this.hint(hintOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    remapOptional = instance.getRemap();
                    if (remapOptional.isPresent()) {
                        this.remap(remapOptional);
                    }
                    bits |= 8L;
                }
            }
            if (object instanceof Expand) {
                instance = (Expand)object;
                this.addAllFields(((Expand)instance).getFields());
                if ((bits & 2L) == 0L) {
                    this.input(((SingleInputRel)instance).getInput());
                    bits |= 2L;
                }
            }
            if (object instanceof AbstractRel) {
                instance = (AbstractRel)object;
                if ((bits & 1L) == 0L) {
                    commonExtensionOptional = instance.getCommonExtension();
                    if (commonExtensionOptional.isPresent()) {
                        this.commonExtension(commonExtensionOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    hintOptional = instance.getHint();
                    if (hintOptional.isPresent()) {
                        this.hint(hintOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    remapOptional = instance.getRemap();
                    if (remapOptional.isPresent()) {
                        this.remap(remapOptional);
                    }
                    bits |= 8L;
                }
            }
            if (object instanceof SingleInputRel) {
                instance = (SingleInputRel)object;
                if ((bits & 2L) == 0L) {
                    this.input(((SingleInputRel)instance).getInput());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    commonExtensionOptional = instance.getCommonExtension();
                    if (commonExtensionOptional.isPresent()) {
                        this.commonExtension(commonExtensionOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    hintOptional = instance.getHint();
                    if (hintOptional.isPresent()) {
                        this.hint(hintOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    remapOptional = instance.getRemap();
                    if (remapOptional.isPresent()) {
                        this.remap(remapOptional);
                    }
                    bits |= 8L;
                }
            }
        }

        public final Builder remap(Rel.Remap remap) {
            this.remap = Objects.requireNonNull(remap, "remap");
            return this;
        }

        public final Builder remap(Optional<? extends Rel.Remap> remap) {
            this.remap = remap.orElse(null);
            return this;
        }

        public final Builder commonExtension(AdvancedExtension commonExtension) {
            this.commonExtension = Objects.requireNonNull(commonExtension, "commonExtension");
            return this;
        }

        public final Builder commonExtension(Optional<? extends AdvancedExtension> commonExtension) {
            this.commonExtension = commonExtension.orElse(null);
            return this;
        }

        public final Builder hint(Hint hint) {
            this.hint = Objects.requireNonNull(hint, "hint");
            return this;
        }

        public final Builder hint(Optional<? extends Hint> hint) {
            this.hint = hint.orElse(null);
            return this;
        }

        public final Builder input(Rel input) {
            this.input = Objects.requireNonNull(input, "input");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addFields(Expand.ExpandField element) {
            this.fields.add(Objects.requireNonNull(element, "fields element"));
            return this;
        }

        public final Builder addFields(Expand.ExpandField ... elements) {
            for (Expand.ExpandField element : elements) {
                this.fields.add(Objects.requireNonNull(element, "fields element"));
            }
            return this;
        }

        public final Builder fields(Iterable<? extends Expand.ExpandField> elements) {
            this.fields.clear();
            return this.addAllFields(elements);
        }

        public final Builder addAllFields(Iterable<? extends Expand.ExpandField> elements) {
            for (Expand.ExpandField expandField : elements) {
                this.fields.add(Objects.requireNonNull(expandField, "fields element"));
            }
            return this;
        }

        public ImmutableExpand build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExpand(this.remap, this.commonExtension, this.hint, this.input, ImmutableExpand.createUnmodifiableList(true, this.fields));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("input");
            }
            return "Cannot build Expand, some of required attributes are not set " + attributes;
        }
    }

    public static final class SwitchingField
    extends Expand.SwitchingField {
        private final List<Expression> duplicates;

        private SwitchingField(List<Expression> duplicates) {
            this.duplicates = duplicates;
        }

        @Override
        public List<Expression> getDuplicates() {
            return this.duplicates;
        }

        public final SwitchingField withDuplicates(Expression ... elements) {
            List newValue = ImmutableExpand.createUnmodifiableList(false, ImmutableExpand.createSafeList(Arrays.asList(elements), true, false));
            return new SwitchingField(newValue);
        }

        public final SwitchingField withDuplicates(Iterable<? extends Expression> elements) {
            if (this.duplicates == elements) {
                return this;
            }
            List newValue = ImmutableExpand.createUnmodifiableList(false, ImmutableExpand.createSafeList(elements, true, false));
            return new SwitchingField(newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof SwitchingField && this.equalsByValue((SwitchingField)another);
        }

        private boolean equalsByValue(SwitchingField another) {
            return this.duplicates.equals(another.duplicates);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.duplicates.hashCode();
            return h;
        }

        public String toString() {
            return "SwitchingField{duplicates=" + this.duplicates + "}";
        }

        public static SwitchingField copyOf(Expand.SwitchingField instance) {
            if (instance instanceof SwitchingField) {
                return (SwitchingField)instance;
            }
            return SwitchingField.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private List<Expression> duplicates = new ArrayList<Expression>();

            private Builder() {
            }

            public final Builder from(Expand.SwitchingField instance) {
                Objects.requireNonNull(instance, "instance");
                this.addAllDuplicates(instance.getDuplicates());
                return this;
            }

            public final Builder addDuplicates(Expression element) {
                this.duplicates.add(Objects.requireNonNull(element, "duplicates element"));
                return this;
            }

            public final Builder addDuplicates(Expression ... elements) {
                for (Expression element : elements) {
                    this.duplicates.add(Objects.requireNonNull(element, "duplicates element"));
                }
                return this;
            }

            public final Builder duplicates(Iterable<? extends Expression> elements) {
                this.duplicates.clear();
                return this.addAllDuplicates(elements);
            }

            public final Builder addAllDuplicates(Iterable<? extends Expression> elements) {
                for (Expression expression : elements) {
                    this.duplicates.add(Objects.requireNonNull(expression, "duplicates element"));
                }
                return this;
            }

            public SwitchingField build() {
                return new SwitchingField(ImmutableExpand.createUnmodifiableList(true, this.duplicates));
            }
        }
    }

    public static final class ConsistentField
    extends Expand.ConsistentField {
        private final Expression expression;

        private ConsistentField(Expression expression) {
            this.expression = expression;
        }

        @Override
        public Expression getExpression() {
            return this.expression;
        }

        public final ConsistentField withExpression(Expression value) {
            if (this.expression == value) {
                return this;
            }
            Expression newValue = Objects.requireNonNull(value, "expression");
            return new ConsistentField(newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ConsistentField && this.equalsByValue((ConsistentField)another);
        }

        private boolean equalsByValue(ConsistentField another) {
            return this.expression.equals(another.expression);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.expression.hashCode();
            return h;
        }

        public String toString() {
            return "ConsistentField{expression=" + this.expression + "}";
        }

        public static ConsistentField copyOf(Expand.ConsistentField instance) {
            if (instance instanceof ConsistentField) {
                return (ConsistentField)instance;
            }
            return ConsistentField.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_EXPRESSION = 1L;
            private long initBits = 1L;
            private Expression expression;

            private Builder() {
            }

            public final Builder from(Expand.ConsistentField instance) {
                Objects.requireNonNull(instance, "instance");
                this.expression(instance.getExpression());
                return this;
            }

            public final Builder expression(Expression expression) {
                this.expression = Objects.requireNonNull(expression, "expression");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public ConsistentField build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new ConsistentField(this.expression);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("expression");
                }
                return "Cannot build ConsistentField, some of required attributes are not set " + attributes;
            }
        }
    }
}

