/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.hint;

import io.substrait.extension.AdvancedExtension;
import io.substrait.hint.Hint;
import io.substrait.relation.HasExtension;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

public final class ImmutableStats
extends Hint.Stats {
    private final AdvancedExtension extension;
    private final double rowCount;
    private final double recordSize;

    private ImmutableStats(AdvancedExtension extension, double rowCount, double recordSize) {
        this.extension = extension;
        this.rowCount = rowCount;
        this.recordSize = recordSize;
    }

    @Override
    public Optional<AdvancedExtension> getExtension() {
        return Optional.ofNullable(this.extension);
    }

    @Override
    public double rowCount() {
        return this.rowCount;
    }

    @Override
    public double recordSize() {
        return this.recordSize;
    }

    public final ImmutableStats withExtension(AdvancedExtension value) {
        AdvancedExtension newValue = Objects.requireNonNull(value, "extension");
        if (this.extension == newValue) {
            return this;
        }
        return new ImmutableStats(newValue, this.rowCount, this.recordSize);
    }

    public final ImmutableStats withExtension(Optional<? extends AdvancedExtension> optional) {
        AdvancedExtension value = optional.orElse(null);
        if (this.extension == value) {
            return this;
        }
        return new ImmutableStats(value, this.rowCount, this.recordSize);
    }

    public final ImmutableStats withRowCount(double value) {
        if (Double.doubleToLongBits(this.rowCount) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableStats(this.extension, value, this.recordSize);
    }

    public final ImmutableStats withRecordSize(double value) {
        if (Double.doubleToLongBits(this.recordSize) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableStats(this.extension, this.rowCount, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStats && this.equalsByValue((ImmutableStats)another);
    }

    private boolean equalsByValue(ImmutableStats another) {
        return Objects.equals(this.extension, another.extension) && Double.doubleToLongBits(this.rowCount) == Double.doubleToLongBits(another.rowCount) && Double.doubleToLongBits(this.recordSize) == Double.doubleToLongBits(another.recordSize);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.extension);
        h += (h << 5) + Double.hashCode(this.rowCount);
        h += (h << 5) + Double.hashCode(this.recordSize);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Stats{");
        if (this.extension != null) {
            builder.append("extension=").append(this.extension);
        }
        if (builder.length() > 6) {
            builder.append(", ");
        }
        builder.append("rowCount=").append(this.rowCount);
        builder.append(", ");
        builder.append("recordSize=").append(this.recordSize);
        return builder.append("}").toString();
    }

    public static ImmutableStats copyOf(Hint.Stats instance) {
        if (instance instanceof ImmutableStats) {
            return (ImmutableStats)instance;
        }
        return ImmutableStats.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ROW_COUNT = 1L;
        private static final long INIT_BIT_RECORD_SIZE = 2L;
        private long initBits = 3L;
        private AdvancedExtension extension;
        private double rowCount;
        private double recordSize;

        private Builder() {
        }

        public final Builder from(HasExtension instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(Hint.Stats instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            HasExtension instance;
            Optional<AdvancedExtension> extensionOptional;
            long bits = 0L;
            if (object instanceof HasExtension && (extensionOptional = (instance = (HasExtension)object).getExtension()).isPresent()) {
                this.extension(extensionOptional);
            }
            if (object instanceof Hint.Stats) {
                instance = (Hint.Stats)object;
                this.rowCount(((Hint.Stats)instance).rowCount());
                this.recordSize(((Hint.Stats)instance).recordSize());
            }
        }

        public final Builder extension(AdvancedExtension extension) {
            this.extension = Objects.requireNonNull(extension, "extension");
            return this;
        }

        public final Builder extension(Optional<? extends AdvancedExtension> extension) {
            this.extension = extension.orElse(null);
            return this;
        }

        public final Builder rowCount(double rowCount) {
            this.rowCount = rowCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder recordSize(double recordSize) {
            this.recordSize = recordSize;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableStats build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStats(this.extension, this.rowCount, this.recordSize);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("rowCount");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("recordSize");
            }
            return "Cannot build Stats, some of required attributes are not set " + attributes;
        }
    }
}

