/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.function;

import io.substrait.function.NullableType;
import io.substrait.function.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class ImmutableParameterizedType {
    private ImmutableParameterizedType() {
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class StringLiteral
    extends ParameterizedType.StringLiteral {
        private final boolean nullable;
        private final String value;

        private StringLiteral(boolean nullable, String value) {
            this.nullable = nullable;
            this.value = value;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public String value() {
            return this.value;
        }

        public final StringLiteral withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new StringLiteral(value, this.value);
        }

        public final StringLiteral withValue(String value) {
            String newValue = Objects.requireNonNull(value, "value");
            if (this.value.equals(newValue)) {
                return this;
            }
            return new StringLiteral(this.nullable, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof StringLiteral && this.equalsByValue((StringLiteral)another);
        }

        private boolean equalsByValue(StringLiteral another) {
            return this.nullable == another.nullable && this.value.equals(another.value);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.value.hashCode();
            return h;
        }

        public String toString() {
            return "StringLiteral{nullable=" + this.nullable + ", value=" + this.value + "}";
        }

        public static StringLiteral copyOf(ParameterizedType.StringLiteral instance) {
            if (instance instanceof StringLiteral) {
                return (StringLiteral)instance;
            }
            return StringLiteral.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private static final long INIT_BIT_VALUE = 2L;
            private long initBits = 3L;
            private boolean nullable;
            private String value;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(ParameterizedType.StringLiteral instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof ParameterizedType.StringLiteral) {
                    instance = (ParameterizedType.StringLiteral)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.value(((ParameterizedType.StringLiteral)instance).value());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder value(String value) {
                this.value = Objects.requireNonNull(value, "value");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public StringLiteral build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new StringLiteral(this.nullable, this.value);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("value");
                }
                return "Cannot build StringLiteral, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class Map
    extends ParameterizedType.Map {
        private final boolean nullable;
        private final ParameterizedType key;
        private final ParameterizedType value;

        private Map(boolean nullable, ParameterizedType key, ParameterizedType value) {
            this.nullable = nullable;
            this.key = key;
            this.value = value;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public ParameterizedType key() {
            return this.key;
        }

        @Override
        public ParameterizedType value() {
            return this.value;
        }

        public final Map withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new Map(value, this.key, this.value);
        }

        public final Map withKey(ParameterizedType value) {
            if (this.key == value) {
                return this;
            }
            ParameterizedType newValue = Objects.requireNonNull(value, "key");
            return new Map(this.nullable, newValue, this.value);
        }

        public final Map withValue(ParameterizedType value) {
            if (this.value == value) {
                return this;
            }
            ParameterizedType newValue = Objects.requireNonNull(value, "value");
            return new Map(this.nullable, this.key, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Map && this.equalsByValue((Map)another);
        }

        private boolean equalsByValue(Map another) {
            return this.nullable == another.nullable && this.key.equals(another.key) && this.value.equals(another.value);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.key.hashCode();
            h += (h << 5) + this.value.hashCode();
            return h;
        }

        public String toString() {
            return "Map{nullable=" + this.nullable + ", key=" + this.key + ", value=" + this.value + "}";
        }

        public static Map copyOf(ParameterizedType.Map instance) {
            if (instance instanceof Map) {
                return (Map)instance;
            }
            return Map.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private static final long INIT_BIT_KEY = 2L;
            private static final long INIT_BIT_VALUE = 4L;
            private long initBits = 7L;
            private boolean nullable;
            private ParameterizedType key;
            private ParameterizedType value;

            private Builder() {
            }

            public final Builder from(ParameterizedType.Map instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof ParameterizedType.Map) {
                    instance = (ParameterizedType.Map)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.value(((ParameterizedType.Map)instance).value());
                    this.key(((ParameterizedType.Map)instance).key());
                }
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder key(ParameterizedType key) {
                this.key = Objects.requireNonNull(key, "key");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public final Builder value(ParameterizedType value) {
                this.value = Objects.requireNonNull(value, "value");
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            public Map build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Map(this.nullable, this.key, this.value);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("key");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("value");
                }
                return "Cannot build Map, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class ListType
    extends ParameterizedType.ListType {
        private final boolean nullable;
        private final ParameterizedType name;

        private ListType(boolean nullable, ParameterizedType name) {
            this.nullable = nullable;
            this.name = name;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public ParameterizedType name() {
            return this.name;
        }

        public final ListType withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new ListType(value, this.name);
        }

        public final ListType withName(ParameterizedType value) {
            if (this.name == value) {
                return this;
            }
            ParameterizedType newValue = Objects.requireNonNull(value, "name");
            return new ListType(this.nullable, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ListType && this.equalsByValue((ListType)another);
        }

        private boolean equalsByValue(ListType another) {
            return this.nullable == another.nullable && this.name.equals(another.name);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.name.hashCode();
            return h;
        }

        public String toString() {
            return "ListType{nullable=" + this.nullable + ", name=" + this.name + "}";
        }

        public static ListType copyOf(ParameterizedType.ListType instance) {
            if (instance instanceof ListType) {
                return (ListType)instance;
            }
            return ListType.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private static final long INIT_BIT_NAME = 2L;
            private long initBits = 3L;
            private boolean nullable;
            private ParameterizedType name;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(ParameterizedType.ListType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof ParameterizedType.ListType) {
                    instance = (ParameterizedType.ListType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.name(((ParameterizedType.ListType)instance).name());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder name(ParameterizedType name) {
                this.name = Objects.requireNonNull(name, "name");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public ListType build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new ListType(this.nullable, this.name);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("name");
                }
                return "Cannot build ListType, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class Struct
    extends ParameterizedType.Struct {
        private final boolean nullable;
        private final List<ParameterizedType> fields;

        private Struct(boolean nullable, List<ParameterizedType> fields) {
            this.nullable = nullable;
            this.fields = fields;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public List<ParameterizedType> fields() {
            return this.fields;
        }

        public final Struct withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new Struct(value, this.fields);
        }

        public final Struct withFields(ParameterizedType ... elements) {
            List newValue = ImmutableParameterizedType.createUnmodifiableList(false, ImmutableParameterizedType.createSafeList(Arrays.asList(elements), true, false));
            return new Struct(this.nullable, newValue);
        }

        public final Struct withFields(Iterable<? extends ParameterizedType> elements) {
            if (this.fields == elements) {
                return this;
            }
            List newValue = ImmutableParameterizedType.createUnmodifiableList(false, ImmutableParameterizedType.createSafeList(elements, true, false));
            return new Struct(this.nullable, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Struct && this.equalsByValue((Struct)another);
        }

        private boolean equalsByValue(Struct another) {
            return this.nullable == another.nullable && this.fields.equals(another.fields);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.fields.hashCode();
            return h;
        }

        public String toString() {
            return "Struct{nullable=" + this.nullable + ", fields=" + this.fields + "}";
        }

        public static Struct copyOf(ParameterizedType.Struct instance) {
            if (instance instanceof Struct) {
                return (Struct)instance;
            }
            return Struct.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private long initBits = 1L;
            private boolean nullable;
            private List<ParameterizedType> fields = new ArrayList<ParameterizedType>();

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(ParameterizedType.Struct instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof ParameterizedType.Struct) {
                    instance = (ParameterizedType.Struct)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.addAllFields(((ParameterizedType.Struct)instance).fields());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder addFields(ParameterizedType element) {
                this.fields.add(Objects.requireNonNull(element, "fields element"));
                return this;
            }

            public final Builder addFields(ParameterizedType ... elements) {
                for (ParameterizedType element : elements) {
                    this.fields.add(Objects.requireNonNull(element, "fields element"));
                }
                return this;
            }

            public final Builder fields(Iterable<? extends ParameterizedType> elements) {
                this.fields.clear();
                return this.addAllFields(elements);
            }

            public final Builder addAllFields(Iterable<? extends ParameterizedType> elements) {
                for (ParameterizedType parameterizedType : elements) {
                    this.fields.add(Objects.requireNonNull(parameterizedType, "fields element"));
                }
                return this;
            }

            public Struct build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Struct(this.nullable, ImmutableParameterizedType.createUnmodifiableList(true, this.fields));
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                return "Cannot build Struct, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class PrecisionTimestampTZ
    extends ParameterizedType.PrecisionTimestampTZ {
        private final boolean nullable;
        private final ParameterizedType.StringLiteral precision;

        private PrecisionTimestampTZ(boolean nullable, ParameterizedType.StringLiteral precision) {
            this.nullable = nullable;
            this.precision = precision;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public ParameterizedType.StringLiteral precision() {
            return this.precision;
        }

        public final PrecisionTimestampTZ withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new PrecisionTimestampTZ(value, this.precision);
        }

        public final PrecisionTimestampTZ withPrecision(ParameterizedType.StringLiteral value) {
            if (this.precision == value) {
                return this;
            }
            ParameterizedType.StringLiteral newValue = Objects.requireNonNull(value, "precision");
            return new PrecisionTimestampTZ(this.nullable, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof PrecisionTimestampTZ && this.equalsByValue((PrecisionTimestampTZ)another);
        }

        private boolean equalsByValue(PrecisionTimestampTZ another) {
            return this.nullable == another.nullable && this.precision.equals(another.precision);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.precision.hashCode();
            return h;
        }

        public String toString() {
            return "PrecisionTimestampTZ{nullable=" + this.nullable + ", precision=" + this.precision + "}";
        }

        public static PrecisionTimestampTZ copyOf(ParameterizedType.PrecisionTimestampTZ instance) {
            if (instance instanceof PrecisionTimestampTZ) {
                return (PrecisionTimestampTZ)instance;
            }
            return PrecisionTimestampTZ.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private static final long INIT_BIT_PRECISION = 2L;
            private long initBits = 3L;
            private boolean nullable;
            private ParameterizedType.StringLiteral precision;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(ParameterizedType.PrecisionTimestampTZ instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof ParameterizedType.PrecisionTimestampTZ) {
                    instance = (ParameterizedType.PrecisionTimestampTZ)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.precision(((ParameterizedType.PrecisionTimestampTZ)instance).precision());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder precision(ParameterizedType.StringLiteral precision) {
                this.precision = Objects.requireNonNull(precision, "precision");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public PrecisionTimestampTZ build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new PrecisionTimestampTZ(this.nullable, this.precision);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("precision");
                }
                return "Cannot build PrecisionTimestampTZ, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class PrecisionTimestamp
    extends ParameterizedType.PrecisionTimestamp {
        private final boolean nullable;
        private final ParameterizedType.StringLiteral precision;

        private PrecisionTimestamp(boolean nullable, ParameterizedType.StringLiteral precision) {
            this.nullable = nullable;
            this.precision = precision;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public ParameterizedType.StringLiteral precision() {
            return this.precision;
        }

        public final PrecisionTimestamp withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new PrecisionTimestamp(value, this.precision);
        }

        public final PrecisionTimestamp withPrecision(ParameterizedType.StringLiteral value) {
            if (this.precision == value) {
                return this;
            }
            ParameterizedType.StringLiteral newValue = Objects.requireNonNull(value, "precision");
            return new PrecisionTimestamp(this.nullable, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof PrecisionTimestamp && this.equalsByValue((PrecisionTimestamp)another);
        }

        private boolean equalsByValue(PrecisionTimestamp another) {
            return this.nullable == another.nullable && this.precision.equals(another.precision);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.precision.hashCode();
            return h;
        }

        public String toString() {
            return "PrecisionTimestamp{nullable=" + this.nullable + ", precision=" + this.precision + "}";
        }

        public static PrecisionTimestamp copyOf(ParameterizedType.PrecisionTimestamp instance) {
            if (instance instanceof PrecisionTimestamp) {
                return (PrecisionTimestamp)instance;
            }
            return PrecisionTimestamp.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private static final long INIT_BIT_PRECISION = 2L;
            private long initBits = 3L;
            private boolean nullable;
            private ParameterizedType.StringLiteral precision;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(ParameterizedType.PrecisionTimestamp instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof ParameterizedType.PrecisionTimestamp) {
                    instance = (ParameterizedType.PrecisionTimestamp)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.precision(((ParameterizedType.PrecisionTimestamp)instance).precision());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder precision(ParameterizedType.StringLiteral precision) {
                this.precision = Objects.requireNonNull(precision, "precision");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public PrecisionTimestamp build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new PrecisionTimestamp(this.nullable, this.precision);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("precision");
                }
                return "Cannot build PrecisionTimestamp, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class PrecisionTime
    extends ParameterizedType.PrecisionTime {
        private final boolean nullable;
        private final ParameterizedType.StringLiteral precision;

        private PrecisionTime(boolean nullable, ParameterizedType.StringLiteral precision) {
            this.nullable = nullable;
            this.precision = precision;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public ParameterizedType.StringLiteral precision() {
            return this.precision;
        }

        public final PrecisionTime withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new PrecisionTime(value, this.precision);
        }

        public final PrecisionTime withPrecision(ParameterizedType.StringLiteral value) {
            if (this.precision == value) {
                return this;
            }
            ParameterizedType.StringLiteral newValue = Objects.requireNonNull(value, "precision");
            return new PrecisionTime(this.nullable, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof PrecisionTime && this.equalsByValue((PrecisionTime)another);
        }

        private boolean equalsByValue(PrecisionTime another) {
            return this.nullable == another.nullable && this.precision.equals(another.precision);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.precision.hashCode();
            return h;
        }

        public String toString() {
            return "PrecisionTime{nullable=" + this.nullable + ", precision=" + this.precision + "}";
        }

        public static PrecisionTime copyOf(ParameterizedType.PrecisionTime instance) {
            if (instance instanceof PrecisionTime) {
                return (PrecisionTime)instance;
            }
            return PrecisionTime.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private static final long INIT_BIT_PRECISION = 2L;
            private long initBits = 3L;
            private boolean nullable;
            private ParameterizedType.StringLiteral precision;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(ParameterizedType.PrecisionTime instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof ParameterizedType.PrecisionTime) {
                    instance = (ParameterizedType.PrecisionTime)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.precision(((ParameterizedType.PrecisionTime)instance).precision());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder precision(ParameterizedType.StringLiteral precision) {
                this.precision = Objects.requireNonNull(precision, "precision");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public PrecisionTime build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new PrecisionTime(this.nullable, this.precision);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("precision");
                }
                return "Cannot build PrecisionTime, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class IntervalCompound
    extends ParameterizedType.IntervalCompound {
        private final boolean nullable;
        private final ParameterizedType.StringLiteral precision;

        private IntervalCompound(boolean nullable, ParameterizedType.StringLiteral precision) {
            this.nullable = nullable;
            this.precision = precision;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public ParameterizedType.StringLiteral precision() {
            return this.precision;
        }

        public final IntervalCompound withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new IntervalCompound(value, this.precision);
        }

        public final IntervalCompound withPrecision(ParameterizedType.StringLiteral value) {
            if (this.precision == value) {
                return this;
            }
            ParameterizedType.StringLiteral newValue = Objects.requireNonNull(value, "precision");
            return new IntervalCompound(this.nullable, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof IntervalCompound && this.equalsByValue((IntervalCompound)another);
        }

        private boolean equalsByValue(IntervalCompound another) {
            return this.nullable == another.nullable && this.precision.equals(another.precision);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.precision.hashCode();
            return h;
        }

        public String toString() {
            return "IntervalCompound{nullable=" + this.nullable + ", precision=" + this.precision + "}";
        }

        public static IntervalCompound copyOf(ParameterizedType.IntervalCompound instance) {
            if (instance instanceof IntervalCompound) {
                return (IntervalCompound)instance;
            }
            return IntervalCompound.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private static final long INIT_BIT_PRECISION = 2L;
            private long initBits = 3L;
            private boolean nullable;
            private ParameterizedType.StringLiteral precision;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(ParameterizedType.IntervalCompound instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof ParameterizedType.IntervalCompound) {
                    instance = (ParameterizedType.IntervalCompound)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.precision(((ParameterizedType.IntervalCompound)instance).precision());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder precision(ParameterizedType.StringLiteral precision) {
                this.precision = Objects.requireNonNull(precision, "precision");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public IntervalCompound build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new IntervalCompound(this.nullable, this.precision);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("precision");
                }
                return "Cannot build IntervalCompound, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class IntervalDay
    extends ParameterizedType.IntervalDay {
        private final boolean nullable;
        private final ParameterizedType.StringLiteral precision;

        private IntervalDay(boolean nullable, ParameterizedType.StringLiteral precision) {
            this.nullable = nullable;
            this.precision = precision;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public ParameterizedType.StringLiteral precision() {
            return this.precision;
        }

        public final IntervalDay withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new IntervalDay(value, this.precision);
        }

        public final IntervalDay withPrecision(ParameterizedType.StringLiteral value) {
            if (this.precision == value) {
                return this;
            }
            ParameterizedType.StringLiteral newValue = Objects.requireNonNull(value, "precision");
            return new IntervalDay(this.nullable, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof IntervalDay && this.equalsByValue((IntervalDay)another);
        }

        private boolean equalsByValue(IntervalDay another) {
            return this.nullable == another.nullable && this.precision.equals(another.precision);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.precision.hashCode();
            return h;
        }

        public String toString() {
            return "IntervalDay{nullable=" + this.nullable + ", precision=" + this.precision + "}";
        }

        public static IntervalDay copyOf(ParameterizedType.IntervalDay instance) {
            if (instance instanceof IntervalDay) {
                return (IntervalDay)instance;
            }
            return IntervalDay.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private static final long INIT_BIT_PRECISION = 2L;
            private long initBits = 3L;
            private boolean nullable;
            private ParameterizedType.StringLiteral precision;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(ParameterizedType.IntervalDay instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof ParameterizedType.IntervalDay) {
                    instance = (ParameterizedType.IntervalDay)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.precision(((ParameterizedType.IntervalDay)instance).precision());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder precision(ParameterizedType.StringLiteral precision) {
                this.precision = Objects.requireNonNull(precision, "precision");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public IntervalDay build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new IntervalDay(this.nullable, this.precision);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("precision");
                }
                return "Cannot build IntervalDay, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class Decimal
    extends ParameterizedType.Decimal {
        private final boolean nullable;
        private final ParameterizedType.StringLiteral scale;
        private final ParameterizedType.StringLiteral precision;

        private Decimal(boolean nullable, ParameterizedType.StringLiteral scale, ParameterizedType.StringLiteral precision) {
            this.nullable = nullable;
            this.scale = scale;
            this.precision = precision;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public ParameterizedType.StringLiteral scale() {
            return this.scale;
        }

        @Override
        public ParameterizedType.StringLiteral precision() {
            return this.precision;
        }

        public final Decimal withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new Decimal(value, this.scale, this.precision);
        }

        public final Decimal withScale(ParameterizedType.StringLiteral value) {
            if (this.scale == value) {
                return this;
            }
            ParameterizedType.StringLiteral newValue = Objects.requireNonNull(value, "scale");
            return new Decimal(this.nullable, newValue, this.precision);
        }

        public final Decimal withPrecision(ParameterizedType.StringLiteral value) {
            if (this.precision == value) {
                return this;
            }
            ParameterizedType.StringLiteral newValue = Objects.requireNonNull(value, "precision");
            return new Decimal(this.nullable, this.scale, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Decimal && this.equalsByValue((Decimal)another);
        }

        private boolean equalsByValue(Decimal another) {
            return this.nullable == another.nullable && this.scale.equals(another.scale) && this.precision.equals(another.precision);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.scale.hashCode();
            h += (h << 5) + this.precision.hashCode();
            return h;
        }

        public String toString() {
            return "Decimal{nullable=" + this.nullable + ", scale=" + this.scale + ", precision=" + this.precision + "}";
        }

        public static Decimal copyOf(ParameterizedType.Decimal instance) {
            if (instance instanceof Decimal) {
                return (Decimal)instance;
            }
            return Decimal.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private static final long INIT_BIT_SCALE = 2L;
            private static final long INIT_BIT_PRECISION = 4L;
            private long initBits = 7L;
            private boolean nullable;
            private ParameterizedType.StringLiteral scale;
            private ParameterizedType.StringLiteral precision;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(ParameterizedType.Decimal instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof ParameterizedType.Decimal) {
                    instance = (ParameterizedType.Decimal)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.scale(((ParameterizedType.Decimal)instance).scale());
                    this.precision(((ParameterizedType.Decimal)instance).precision());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder scale(ParameterizedType.StringLiteral scale) {
                this.scale = Objects.requireNonNull(scale, "scale");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public final Builder precision(ParameterizedType.StringLiteral precision) {
                this.precision = Objects.requireNonNull(precision, "precision");
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            public Decimal build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Decimal(this.nullable, this.scale, this.precision);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("scale");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("precision");
                }
                return "Cannot build Decimal, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class FixedBinary
    extends ParameterizedType.FixedBinary {
        private final boolean nullable;
        private final ParameterizedType.StringLiteral length;

        private FixedBinary(boolean nullable, ParameterizedType.StringLiteral length) {
            this.nullable = nullable;
            this.length = length;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public ParameterizedType.StringLiteral length() {
            return this.length;
        }

        public final FixedBinary withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new FixedBinary(value, this.length);
        }

        public final FixedBinary withLength(ParameterizedType.StringLiteral value) {
            if (this.length == value) {
                return this;
            }
            ParameterizedType.StringLiteral newValue = Objects.requireNonNull(value, "length");
            return new FixedBinary(this.nullable, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof FixedBinary && this.equalsByValue((FixedBinary)another);
        }

        private boolean equalsByValue(FixedBinary another) {
            return this.nullable == another.nullable && this.length.equals(another.length);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.length.hashCode();
            return h;
        }

        public String toString() {
            return "FixedBinary{nullable=" + this.nullable + ", length=" + this.length + "}";
        }

        public static FixedBinary copyOf(ParameterizedType.FixedBinary instance) {
            if (instance instanceof FixedBinary) {
                return (FixedBinary)instance;
            }
            return FixedBinary.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private static final long INIT_BIT_LENGTH = 2L;
            private long initBits = 3L;
            private boolean nullable;
            private ParameterizedType.StringLiteral length;

            private Builder() {
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(ParameterizedType.FixedBinary instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
                if (object instanceof ParameterizedType.FixedBinary) {
                    instance = (ParameterizedType.FixedBinary)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.length(((ParameterizedType.FixedBinary)instance).length());
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder length(ParameterizedType.StringLiteral length) {
                this.length = Objects.requireNonNull(length, "length");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public FixedBinary build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new FixedBinary(this.nullable, this.length);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("length");
                }
                return "Cannot build FixedBinary, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class VarChar
    extends ParameterizedType.VarChar {
        private final boolean nullable;
        private final ParameterizedType.StringLiteral length;

        private VarChar(boolean nullable, ParameterizedType.StringLiteral length) {
            this.nullable = nullable;
            this.length = length;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public ParameterizedType.StringLiteral length() {
            return this.length;
        }

        public final VarChar withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new VarChar(value, this.length);
        }

        public final VarChar withLength(ParameterizedType.StringLiteral value) {
            if (this.length == value) {
                return this;
            }
            ParameterizedType.StringLiteral newValue = Objects.requireNonNull(value, "length");
            return new VarChar(this.nullable, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof VarChar && this.equalsByValue((VarChar)another);
        }

        private boolean equalsByValue(VarChar another) {
            return this.nullable == another.nullable && this.length.equals(another.length);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.length.hashCode();
            return h;
        }

        public String toString() {
            return "VarChar{nullable=" + this.nullable + ", length=" + this.length + "}";
        }

        public static VarChar copyOf(ParameterizedType.VarChar instance) {
            if (instance instanceof VarChar) {
                return (VarChar)instance;
            }
            return VarChar.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private static final long INIT_BIT_LENGTH = 2L;
            private long initBits = 3L;
            private boolean nullable;
            private ParameterizedType.StringLiteral length;

            private Builder() {
            }

            public final Builder from(ParameterizedType.VarChar instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof ParameterizedType.VarChar) {
                    instance = (ParameterizedType.VarChar)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.length(((ParameterizedType.VarChar)instance).length());
                }
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder length(ParameterizedType.StringLiteral length) {
                this.length = Objects.requireNonNull(length, "length");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public VarChar build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new VarChar(this.nullable, this.length);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("length");
                }
                return "Cannot build VarChar, some of required attributes are not set " + attributes;
            }
        }
    }

    public static final class FixedChar
    extends ParameterizedType.FixedChar {
        private final boolean nullable;
        private final ParameterizedType.StringLiteral length;

        private FixedChar(boolean nullable, ParameterizedType.StringLiteral length) {
            this.nullable = nullable;
            this.length = length;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public ParameterizedType.StringLiteral length() {
            return this.length;
        }

        public final FixedChar withNullable(boolean value) {
            if (this.nullable == value) {
                return this;
            }
            return new FixedChar(value, this.length);
        }

        public final FixedChar withLength(ParameterizedType.StringLiteral value) {
            if (this.length == value) {
                return this;
            }
            ParameterizedType.StringLiteral newValue = Objects.requireNonNull(value, "length");
            return new FixedChar(this.nullable, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof FixedChar && this.equalsByValue((FixedChar)another);
        }

        private boolean equalsByValue(FixedChar another) {
            return this.nullable == another.nullable && this.length.equals(another.length);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Boolean.hashCode(this.nullable);
            h += (h << 5) + this.length.hashCode();
            return h;
        }

        public String toString() {
            return "FixedChar{nullable=" + this.nullable + ", length=" + this.length + "}";
        }

        public static FixedChar copyOf(ParameterizedType.FixedChar instance) {
            if (instance instanceof FixedChar) {
                return (FixedChar)instance;
            }
            return FixedChar.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private static final long INIT_BIT_NULLABLE = 1L;
            private static final long INIT_BIT_LENGTH = 2L;
            private long initBits = 3L;
            private boolean nullable;
            private ParameterizedType.StringLiteral length;

            private Builder() {
            }

            public final Builder from(ParameterizedType.FixedChar instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(NullableType instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                NullableType instance;
                long bits = 0L;
                if (object instanceof ParameterizedType.FixedChar) {
                    instance = (ParameterizedType.FixedChar)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                    this.length(((ParameterizedType.FixedChar)instance).length());
                }
                if (object instanceof NullableType) {
                    instance = (NullableType)object;
                    if ((bits & 1L) == 0L) {
                        this.nullable(instance.nullable());
                        bits |= 1L;
                    }
                }
            }

            public final Builder nullable(boolean nullable) {
                this.nullable = nullable;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder length(ParameterizedType.StringLiteral length) {
                this.length = Objects.requireNonNull(length, "length");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public FixedChar build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new FixedChar(this.nullable, this.length);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("nullable");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("length");
                }
                return "Cannot build FixedChar, some of required attributes are not set " + attributes;
            }
        }
    }
}

