/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.extension;

import io.substrait.extension.AbstractExtensionLookup;
import io.substrait.extension.DefaultExtensionCatalog;
import io.substrait.extension.SimpleExtension;
import io.substrait.proto.ExtendedExpression;
import io.substrait.proto.Plan;
import io.substrait.proto.SimpleExtensionDeclaration;
import io.substrait.proto.SimpleExtensionURI;
import io.substrait.proto.SimpleExtensionURN;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImmutableExtensionLookup
extends AbstractExtensionLookup {
    private ImmutableExtensionLookup(Map<Integer, SimpleExtension.FunctionAnchor> functionMap, Map<Integer, SimpleExtension.TypeAnchor> typeMap) {
        super(functionMap, typeMap);
    }

    public static Builder builder() {
        return ImmutableExtensionLookup.builder(DefaultExtensionCatalog.DEFAULT_COLLECTION);
    }

    public static Builder builder(SimpleExtension.ExtensionCollection extensionCollection) {
        return new Builder(extensionCollection);
    }

    public static class Builder {
        private final Map<Integer, SimpleExtension.FunctionAnchor> functionMap = new HashMap<Integer, SimpleExtension.FunctionAnchor>();
        private final Map<Integer, SimpleExtension.TypeAnchor> typeMap = new HashMap<Integer, SimpleExtension.TypeAnchor>();
        private final SimpleExtension.ExtensionCollection extensionCollection;

        public Builder(SimpleExtension.ExtensionCollection extensionCollection) {
            if (extensionCollection == null) {
                throw new IllegalArgumentException("ExtensionCollection is required");
            }
            this.extensionCollection = extensionCollection;
        }

        private String resolveUrnFromUri(String uri) {
            return this.extensionCollection.getUrnFromUri(uri);
        }

        private SimpleExtension.FunctionAnchor resolveFunctionAnchor(SimpleExtensionDeclaration.ExtensionFunction func, Map<Integer, String> urnMap, Map<Integer, String> uriMap) {
            if (func.getExtensionUrnReference() != 0) {
                String urnFromUrnRef = urnMap.get(func.getExtensionUrnReference());
                if (urnFromUrnRef == null) {
                    throw new IllegalStateException(String.format("Function '%s' references URN anchor %d, but no URN is registered at that anchor", func.getName(), func.getExtensionUrnReference()));
                }
                return SimpleExtension.FunctionAnchor.of(urnFromUrnRef, func.getName());
            }
            if (func.getExtensionUriReference() != 0) {
                String uriFromUriRef = uriMap.get(func.getExtensionUriReference());
                if (uriFromUriRef == null) {
                    throw new IllegalStateException(String.format("Function '%s' references URI anchor %d, but no URI is registered at that anchor", func.getName(), func.getExtensionUriReference()));
                }
                String urnFromUriRef = this.resolveUrnFromUri(uriFromUriRef);
                if (urnFromUriRef == null) {
                    throw new IllegalStateException(String.format("Function '%s' references URI anchor %d with URI '%s', but this URI could not be resolved to a URN. Ensure a URI <-> URN mapping is registered in the ExtensionCollection.", func.getName(), func.getExtensionUriReference(), uriFromUriRef));
                }
                return SimpleExtension.FunctionAnchor.of(urnFromUriRef, func.getName());
            }
            String urn = urnMap.get(func.getExtensionUrnReference());
            String uri = uriMap.get(func.getExtensionUriReference());
            if (uri != null && urn != null) {
                String resolvedUrn = this.resolveUrnFromUri(uri);
                if (urn.equals(resolvedUrn)) {
                    return SimpleExtension.FunctionAnchor.of(urn, func.getName());
                }
                throw new IllegalStateException(String.format("Conflicting URI/URN mapping at reference 0: URI '%s' maps to URN '%s', but reference 0 also specifies URN '%s'. These must be consistent for proper resolution.", uri, resolvedUrn, urn));
            }
            if (urn != null) {
                return SimpleExtension.FunctionAnchor.of(urn, func.getName());
            }
            if (uri != null && this.resolveUrnFromUri(uri) != null) {
                return SimpleExtension.FunctionAnchor.of(this.resolveUrnFromUri(uri), func.getName());
            }
            throw new IllegalStateException(String.format("All resolution strategies failed for URI %s and URN %s (perhaps a URI <-> URN mapping was not registered during the migration) ", uri, urn));
        }

        private SimpleExtension.TypeAnchor resolveTypeAnchor(SimpleExtensionDeclaration.ExtensionType type, Map<Integer, String> urnMap, Map<Integer, String> uriMap) {
            if (type.getExtensionUrnReference() != 0) {
                String urnFromUrnRef = urnMap.get(type.getExtensionUrnReference());
                if (urnFromUrnRef == null) {
                    throw new IllegalStateException(String.format("Type '%s' references URN anchor %d, but no URN is registered at that anchor", type.getName(), type.getExtensionUrnReference()));
                }
                return SimpleExtension.TypeAnchor.of(urnFromUrnRef, type.getName());
            }
            if (type.getExtensionUriReference() != 0) {
                String uriFromUriRef = uriMap.get(type.getExtensionUriReference());
                if (uriFromUriRef == null) {
                    throw new IllegalStateException(String.format("Type '%s' references URI anchor %d, but no URI is registered at that anchor", type.getName(), type.getExtensionUriReference()));
                }
                String urnFromUriRef = this.resolveUrnFromUri(uriFromUriRef);
                if (urnFromUriRef == null) {
                    throw new IllegalStateException(String.format("Type '%s' references URI anchor %d with URI '%s', but this URI could not be resolved to a URN. Ensure a URI <-> URN mapping is registered in the ExtensionCollection.", type.getName(), type.getExtensionUriReference(), uriFromUriRef));
                }
                return SimpleExtension.TypeAnchor.of(urnFromUriRef, type.getName());
            }
            String urn = urnMap.get(type.getExtensionUrnReference());
            String uri = uriMap.get(type.getExtensionUriReference());
            if (uri != null && urn != null) {
                String resolvedUrn = this.resolveUrnFromUri(uri);
                if (urn.equals(resolvedUrn)) {
                    return SimpleExtension.TypeAnchor.of(urn, type.getName());
                }
                throw new IllegalStateException(String.format("Conflicting URI/URN mapping at reference 0: URI '%s' maps to URN '%s', but reference 0 also specifies URN '%s'. These must be consistent for proper resolution.", uri, resolvedUrn, urn));
            }
            if (urn != null) {
                return SimpleExtension.TypeAnchor.of(urn, type.getName());
            }
            if (uri != null && this.resolveUrnFromUri(uri) != null) {
                return SimpleExtension.TypeAnchor.of(this.resolveUrnFromUri(uri), type.getName());
            }
            throw new IllegalStateException(String.format("All resolution strategies failed for URI %s and URN %s (perhaps a URI <-> URN mapping was not registered during the migration) ", uri, urn));
        }

        public Builder from(Plan plan) {
            return this.from(plan.getExtensionUrnsList(), plan.getExtensionUrisList(), plan.getExtensionsList());
        }

        public Builder from(ExtendedExpression extendedExpression) {
            return this.from(extendedExpression.getExtensionUrnsList(), extendedExpression.getExtensionUrisList(), extendedExpression.getExtensionsList());
        }

        private Builder from(List<SimpleExtensionURN> simpleExtensionURNs, List<SimpleExtensionURI> simpleExtensionURIs, List<SimpleExtensionDeclaration> simpleExtensionDeclarations) {
            SimpleExtension.Anchor anchor;
            int reference;
            HashMap<Integer, String> urnMap = new HashMap<Integer, String>();
            HashMap<Integer, String> uriMap = new HashMap<Integer, String>();
            for (SimpleExtensionURN simpleExtensionURN : simpleExtensionURNs) {
                urnMap.put(simpleExtensionURN.getExtensionUrnAnchor(), simpleExtensionURN.getUrn());
            }
            for (SimpleExtensionURI simpleExtensionURI : simpleExtensionURIs) {
                uriMap.put(simpleExtensionURI.getExtensionUriAnchor(), simpleExtensionURI.getUri());
            }
            for (SimpleExtensionDeclaration simpleExtensionDeclaration : simpleExtensionDeclarations) {
                if (!simpleExtensionDeclaration.hasExtensionFunction()) continue;
                SimpleExtensionDeclaration.ExtensionFunction func = simpleExtensionDeclaration.getExtensionFunction();
                reference = func.getFunctionAnchor();
                anchor = this.resolveFunctionAnchor(func, urnMap, uriMap);
                this.functionMap.put(reference, (SimpleExtension.FunctionAnchor)anchor);
            }
            for (SimpleExtensionDeclaration simpleExtensionDeclaration : simpleExtensionDeclarations) {
                if (!simpleExtensionDeclaration.hasExtensionType()) continue;
                SimpleExtensionDeclaration.ExtensionType type = simpleExtensionDeclaration.getExtensionType();
                reference = type.getTypeAnchor();
                anchor = this.resolveTypeAnchor(type, urnMap, uriMap);
                this.typeMap.put(reference, (SimpleExtension.TypeAnchor)anchor);
            }
            return this;
        }

        public ImmutableExtensionLookup build() {
            return new ImmutableExtensionLookup(Collections.unmodifiableMap(this.functionMap), Collections.unmodifiableMap(this.typeMap));
        }
    }
}

