/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.status.KafkaConnectStatus;
import io.strimzi.api.kafka.model.status.KafkaConnectStatusFluent;
import io.strimzi.api.kafka.model.status.KafkaConnectStatusFluentImpl;
import java.util.Objects;

public class KafkaConnectStatusBuilder
extends KafkaConnectStatusFluentImpl<KafkaConnectStatusBuilder>
implements VisitableBuilder<KafkaConnectStatus, KafkaConnectStatusBuilder> {
    KafkaConnectStatusFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaConnectStatusBuilder() {
        this(true);
    }

    public KafkaConnectStatusBuilder(Boolean validationEnabled) {
        this(new KafkaConnectStatus(), validationEnabled);
    }

    public KafkaConnectStatusBuilder(KafkaConnectStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public KafkaConnectStatusBuilder(KafkaConnectStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KafkaConnectStatus(), validationEnabled);
    }

    public KafkaConnectStatusBuilder(KafkaConnectStatusFluent<?> fluent, KafkaConnectStatus instance) {
        this(fluent, instance, true);
    }

    public KafkaConnectStatusBuilder(KafkaConnectStatusFluent<?> fluent, KafkaConnectStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withUrl(instance.getUrl());
        fluent.withConnectorPlugins(instance.getConnectorPlugins());
        fluent.withReplicas(instance.getReplicas());
        fluent.withLabelSelector(instance.getLabelSelector());
        fluent.withConditions(instance.getConditions());
        fluent.withObservedGeneration(instance.getObservedGeneration());
        this.validationEnabled = validationEnabled;
    }

    public KafkaConnectStatusBuilder(KafkaConnectStatus instance) {
        this(instance, (Boolean)true);
    }

    public KafkaConnectStatusBuilder(KafkaConnectStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withUrl(instance.getUrl());
        this.withConnectorPlugins(instance.getConnectorPlugins());
        this.withReplicas(instance.getReplicas());
        this.withLabelSelector(instance.getLabelSelector());
        this.withConditions(instance.getConditions());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.validationEnabled = validationEnabled;
    }

    public KafkaConnectStatus build() {
        KafkaConnectStatus buildable = new KafkaConnectStatus();
        buildable.setConditions(this.fluent.getConditions());
        buildable.setObservedGeneration(this.fluent.getObservedGeneration());
        buildable.setUrl(this.fluent.getUrl());
        buildable.setConnectorPlugins(this.fluent.getConnectorPlugins());
        buildable.setReplicas(this.fluent.getReplicas());
        buildable.setLabelSelector(this.fluent.getLabelSelector());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaConnectStatusBuilder that = (KafkaConnectStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

