/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.authentication;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainFluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainFluentImpl;
import java.util.Objects;

public class KafkaClientAuthenticationPlainBuilder
extends KafkaClientAuthenticationPlainFluentImpl<KafkaClientAuthenticationPlainBuilder>
implements VisitableBuilder<KafkaClientAuthenticationPlain, KafkaClientAuthenticationPlainBuilder> {
    KafkaClientAuthenticationPlainFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaClientAuthenticationPlainBuilder() {
        this(true);
    }

    public KafkaClientAuthenticationPlainBuilder(Boolean validationEnabled) {
        this(new KafkaClientAuthenticationPlain(), validationEnabled);
    }

    public KafkaClientAuthenticationPlainBuilder(KafkaClientAuthenticationPlainFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public KafkaClientAuthenticationPlainBuilder(KafkaClientAuthenticationPlainFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KafkaClientAuthenticationPlain(), validationEnabled);
    }

    public KafkaClientAuthenticationPlainBuilder(KafkaClientAuthenticationPlainFluent<?> fluent, KafkaClientAuthenticationPlain instance) {
        this(fluent, instance, true);
    }

    public KafkaClientAuthenticationPlainBuilder(KafkaClientAuthenticationPlainFluent<?> fluent, KafkaClientAuthenticationPlain instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withUsername(instance.getUsername());
        fluent.withPasswordSecret(instance.getPasswordSecret());
        this.validationEnabled = validationEnabled;
    }

    public KafkaClientAuthenticationPlainBuilder(KafkaClientAuthenticationPlain instance) {
        this(instance, (Boolean)true);
    }

    public KafkaClientAuthenticationPlainBuilder(KafkaClientAuthenticationPlain instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withUsername(instance.getUsername());
        this.withPasswordSecret(instance.getPasswordSecret());
        this.validationEnabled = validationEnabled;
    }

    public KafkaClientAuthenticationPlain build() {
        KafkaClientAuthenticationPlain buildable = new KafkaClientAuthenticationPlain();
        buildable.setUsername(this.fluent.getUsername());
        buildable.setPasswordSecret(this.fluent.getPasswordSecret());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaClientAuthenticationPlainBuilder that = (KafkaClientAuthenticationPlainBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

