/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.authentication;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluentImpl;
import java.util.Objects;

public class KafkaClientAuthenticationOAuthBuilder
extends KafkaClientAuthenticationOAuthFluentImpl<KafkaClientAuthenticationOAuthBuilder>
implements VisitableBuilder<KafkaClientAuthenticationOAuth, KafkaClientAuthenticationOAuthBuilder> {
    KafkaClientAuthenticationOAuthFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaClientAuthenticationOAuthBuilder() {
        this(true);
    }

    public KafkaClientAuthenticationOAuthBuilder(Boolean validationEnabled) {
        this(new KafkaClientAuthenticationOAuth(), validationEnabled);
    }

    public KafkaClientAuthenticationOAuthBuilder(KafkaClientAuthenticationOAuthFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public KafkaClientAuthenticationOAuthBuilder(KafkaClientAuthenticationOAuthFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KafkaClientAuthenticationOAuth(), validationEnabled);
    }

    public KafkaClientAuthenticationOAuthBuilder(KafkaClientAuthenticationOAuthFluent<?> fluent, KafkaClientAuthenticationOAuth instance) {
        this(fluent, instance, true);
    }

    public KafkaClientAuthenticationOAuthBuilder(KafkaClientAuthenticationOAuthFluent<?> fluent, KafkaClientAuthenticationOAuth instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withClientId(instance.getClientId());
        fluent.withScope(instance.getScope());
        fluent.withAudience(instance.getAudience());
        fluent.withTokenEndpointUri(instance.getTokenEndpointUri());
        fluent.withConnectTimeoutSeconds(instance.getConnectTimeoutSeconds());
        fluent.withReadTimeoutSeconds(instance.getReadTimeoutSeconds());
        fluent.withClientSecret(instance.getClientSecret());
        fluent.withAccessToken(instance.getAccessToken());
        fluent.withRefreshToken(instance.getRefreshToken());
        fluent.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());
        fluent.withDisableTlsHostnameVerification(instance.isDisableTlsHostnameVerification());
        fluent.withMaxTokenExpirySeconds(instance.getMaxTokenExpirySeconds());
        fluent.withAccessTokenIsJwt(instance.isAccessTokenIsJwt());
        this.validationEnabled = validationEnabled;
    }

    public KafkaClientAuthenticationOAuthBuilder(KafkaClientAuthenticationOAuth instance) {
        this(instance, (Boolean)true);
    }

    public KafkaClientAuthenticationOAuthBuilder(KafkaClientAuthenticationOAuth instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withClientId(instance.getClientId());
        this.withScope(instance.getScope());
        this.withAudience(instance.getAudience());
        this.withTokenEndpointUri(instance.getTokenEndpointUri());
        this.withConnectTimeoutSeconds(instance.getConnectTimeoutSeconds());
        this.withReadTimeoutSeconds(instance.getReadTimeoutSeconds());
        this.withClientSecret(instance.getClientSecret());
        this.withAccessToken(instance.getAccessToken());
        this.withRefreshToken(instance.getRefreshToken());
        this.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());
        this.withDisableTlsHostnameVerification(instance.isDisableTlsHostnameVerification());
        this.withMaxTokenExpirySeconds(instance.getMaxTokenExpirySeconds());
        this.withAccessTokenIsJwt(instance.isAccessTokenIsJwt());
        this.validationEnabled = validationEnabled;
    }

    public KafkaClientAuthenticationOAuth build() {
        KafkaClientAuthenticationOAuth buildable = new KafkaClientAuthenticationOAuth();
        buildable.setClientId(this.fluent.getClientId());
        buildable.setScope(this.fluent.getScope());
        buildable.setAudience(this.fluent.getAudience());
        buildable.setTokenEndpointUri(this.fluent.getTokenEndpointUri());
        buildable.setConnectTimeoutSeconds(this.fluent.getConnectTimeoutSeconds());
        buildable.setReadTimeoutSeconds(this.fluent.getReadTimeoutSeconds());
        buildable.setClientSecret(this.fluent.getClientSecret());
        buildable.setAccessToken(this.fluent.getAccessToken());
        buildable.setRefreshToken(this.fluent.getRefreshToken());
        buildable.setTlsTrustedCertificates(this.fluent.getTlsTrustedCertificates());
        buildable.setDisableTlsHostnameVerification(this.fluent.isDisableTlsHostnameVerification());
        buildable.setMaxTokenExpirySeconds(this.fluent.getMaxTokenExpirySeconds());
        buildable.setAccessTokenIsJwt(this.fluent.isAccessTokenIsJwt());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaClientAuthenticationOAuthBuilder that = (KafkaClientAuthenticationOAuthBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

