/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.SystemProperty;
import io.strimzi.api.kafka.model.SystemPropertyFluent;
import io.strimzi.api.kafka.model.SystemPropertyFluentImpl;
import java.util.Objects;

public class SystemPropertyBuilder
extends SystemPropertyFluentImpl<SystemPropertyBuilder>
implements VisitableBuilder<SystemProperty, SystemPropertyBuilder> {
    SystemPropertyFluent<?> fluent;
    Boolean validationEnabled;

    public SystemPropertyBuilder() {
        this(true);
    }

    public SystemPropertyBuilder(Boolean validationEnabled) {
        this(new SystemProperty(), validationEnabled);
    }

    public SystemPropertyBuilder(SystemPropertyFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public SystemPropertyBuilder(SystemPropertyFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new SystemProperty(), validationEnabled);
    }

    public SystemPropertyBuilder(SystemPropertyFluent<?> fluent, SystemProperty instance) {
        this(fluent, instance, true);
    }

    public SystemPropertyBuilder(SystemPropertyFluent<?> fluent, SystemProperty instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withValue(instance.getValue());
        this.validationEnabled = validationEnabled;
    }

    public SystemPropertyBuilder(SystemProperty instance) {
        this(instance, (Boolean)true);
    }

    public SystemPropertyBuilder(SystemProperty instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withValue(instance.getValue());
        this.validationEnabled = validationEnabled;
    }

    public SystemProperty build() {
        SystemProperty buildable = new SystemProperty();
        buildable.setName(this.fluent.getName());
        buildable.setValue(this.fluent.getValue());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SystemPropertyBuilder that = (SystemPropertyBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

